(release-3007.10)=
# Salt 3007.10 release notes

<!---
Do not edit this file. This is auto generated.
Edit the templates in doc/topics/releases/templates/
for a given release.
-->


<!--
Add release specific details below
-->

<!--
Do not edit the changelog below.
This is auto generated.
-->
## Changelog

### Fixed

- Fixed an issue with how existing entries are tracked in grains.list_present. Previous entries were only considered if
  the grain previously existed. If not then the state would not "see" the duplicates. Removed the dubious tracking via
  "context" and focused on using checking for existance in the live grains. [#31427](https://github.com/saltstack/salt/issues/31427)
- Fixed issue with complex objects in grains.list_present. Original fix #52710 did not fully address the problem. [#39875](https://github.com/saltstack/salt/issues/39875)
- Fixed ssh_auth.present to respect provided `options` when read keys from source file [#60769](https://github.com/saltstack/salt/issues/60769)
- Fixed ssh_auth regexp to handle key types with @ or . [#61299](https://github.com/saltstack/salt/issues/61299)
- Fixed a TypeError exception thrown by ssh_known_hosts.present when the specified user account does not exist [#62049](https://github.com/saltstack/salt/issues/62049)
- Fixed false identification of text as binary in salt.utils.file.is_binary if utf-8 multibyte character is truncated at end of 2048 bytes sample. [#62214](https://github.com/saltstack/salt/issues/62214)
- Fix runtime error on OpenBSD by adding support for the osfullname grain [#64189](https://github.com/saltstack/salt/issues/64189)
- Fix closing of TCP transport channels and avoid additional errors [#66568](https://github.com/saltstack/salt/issues/66568)
- Fixed false negative "is not text" in salt.utils.files.is_text if an utf-8 multibyte character is truncated at end of 512 bytes sample. [#66706](https://github.com/saltstack/salt/issues/66706)
- fixes salt runner mine.get not returning value if allow_tgt is defined in mine function [#68188](https://github.com/saltstack/salt/issues/68188)
- Forward minion list events in Syndic cluster mode to enable proper job completion detection [#68319](https://github.com/saltstack/salt/issues/68319)
- Fixes issue with asyncio logger not using SaltLoggingClass and causing exceptions when "%(jid)s" is used in a log format. [#68400](https://github.com/saltstack/salt/issues/68400)
- Fixed ssh_auth.present and ssh.absent to report changes if some key was added or removed when reading keys from a source file [#68403](https://github.com/saltstack/salt/issues/68403)
- Test loader now prevents .pyc files from being written during test run using
  sys.dont_write_bytecode = True. This results in 3x faster test execution and
  reduced IO operations [#68412](https://github.com/saltstack/salt/issues/68412)
- Fixes a issue where variable names were reversed when detecting domain and
  username from a username. [#68450](https://github.com/saltstack/salt/issues/68450)
- Changed the glob pattern for APT sources from `**/*.list` to `*.list`, in line
  with APT's default pattern in sources.list.d [#68475](https://github.com/saltstack/salt/issues/68475)
- Remove unwanted error log from aptpkg [#68485](https://github.com/saltstack/salt/issues/68485)
- Use the packaging library instead of the deprecated pkg_resources library for
  working with version to avoid a deprecation warning when running salt
  commands [#68487](https://github.com/saltstack/salt/issues/68487)
- Fixes issue with disk.tune passing incorrect args for read-only and read-write
  to blockdev.
  Improves argument and error handling in blockdev. [#68490](https://github.com/saltstack/salt/issues/68490)
- Enhance mod_data to Use Global Loader Extensions in salt-ssh [#68496](https://github.com/saltstack/salt/issues/68496)
- Fix race condition in Salt Syndic when multiple Syndic Masters return at the same time and the Master of Masters tries to write to the same file in the job cache. [#68508](https://github.com/saltstack/salt/issues/68508)
- Patch tornado for CVE-2023-28370 [#68529](https://github.com/saltstack/salt/issues/68529)
- Fixed some of the commands in the Contributing guide. [#68538](https://github.com/saltstack/salt/issues/68538)
- Fix check for non-blockdev devices in blockdev.tuned. Check always returned True
  previously, now actually checks with file.is_blkdev. [#68541](https://github.com/saltstack/salt/issues/68541)
- Added documentation and CLI help text for the --disable-keepalive option for
  salt-minion and salt-proxy, which disables the automatic restart mechanism
  when external process managers like systemd handle daemon restarts. [#68544](https://github.com/saltstack/salt/issues/68544)
- Upgrade relenv to 0.22.1 and fix Python 3.13 support

  - Updated relenv from 0.21.2 to 0.22.1
  - Fixed backports module import for Python 3.13 compatibility
  - Fixed RUSTFLAGS conflicts when compiling cryptography package
  - Fixed toolchain cache location for relenv 0.22.1
  - Added Obsoletes directives to prevent EPEL salt3006 package conflicts on Rocky 9 [#68552](https://github.com/saltstack/salt/issues/68552)
- Fixed minion process name pollution when multiprocessing is disabled [#68553](https://github.com/saltstack/salt/issues/68553)
