/* swc.c - simple command line Switch Controller - enable/disable ports

   Copyright (C) 2001  Russell Kroll <rkroll@exploits.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

#include <ctype.h>
#include <ctype.h>
#include <stdio.h>
#include <getopt.h>
#include <stdlib.h>
#include <string.h>

#include "common.h"

void help(char *prog)
{
	fprintf(stderr, "Control switch ports remotely via SNMP.\n\n");
	fprintf(stderr, "usage: %s [-h] -s <ip> -p <port> -c <community> -a <action>\n", prog);
	fprintf(stderr, "  -s <ip>		set remote switch address\n");
	fprintf(stderr, "  -p <port>		set port to be changed\n");
	fprintf(stderr, "  -c <community>	specify community for SNMP access\n");
	fprintf(stderr, "  -a <action>		action for port: 'up' or 'down'\n");
	exit(0);
}

int main(int argc, char **argv)
{
	int	i, ret, action;
	char	exec[512], *swip, *comm, *swport, buf[256], *arg[3], test[16],
		*inport, *prog;
	FILE	*ss;

	prog = argv[0];
	swip = comm = inport = NULL;
	action = 0;

	/* Switch, Community, Port, Action */

	while ((i = getopt(argc, argv, "+hs:c:p:a:")) != EOF) {
		switch(i) {
			case 'h':
				help(prog);
				break;

			case 's':
				swip = strdup(optarg);
				break;

			case 'p':
				inport = strdup(optarg);
				break;

			case 'c':
				comm = strdup(optarg);
				break;

			case 'a':
				if (!strcasecmp(optarg, "up"))
					action = 1;
				if (!strcasecmp(optarg, "down"))
					action = 2;
				if ((action != 1) && (action != 2))
					help(prog);
				break;
		}
	}

	if ((!swip) || (!comm) || (!inport) || (action == 0))
		help(prog);

	/* first get switch's internal number for this port */

	snprintf(exec, sizeof(exec), "snmpget %s %s 17.1.4.1.2.%s",
		swip, comm, inport);

	ss = popen(exec, "r");
	if (!ss) {
		perror("popen");
		exit(1);
	}

	fgets(buf, sizeof(buf), ss);
	pclose(ss);

	buf[strlen(buf) - 1] = '\0';

	ret = parseconf(NULL, 0, buf, arg, 3);

	if (ret != 1)
		exit(1);

	snprintf(test, sizeof(test), "17.1.4.1.2.%s", inport);

	/* basic sanity tests */

	if (strcmp(arg[0], test) != 0) {
		fprintf(stderr, "Bogus result from snmpget\n");
		exit(1);
	}

	if (strcmp(arg[1], "=") != 0) {
		fprintf(stderr, "Bogus result from snmpget\n");
		exit(1);
	}

	swport = arg[2];

	/* now build the command */

	snprintf(exec, sizeof(exec), "snmpset %s %s "
		"interfaces.ifTable.ifEntry.ifAdminStatus.%s i %d",
		swip, comm, swport, action);

	system(exec);

	return 0;
}
