#!/usr/bin/perl -w
#
# Convert an AvantGo .subs file to a sitescooper .site file.
#
# usage: perl subs-to-site.pl subsfilename > sitefilename

$offsitelinks = 'false';
$images = 'false';
$title = 'Untitled';
$levels = 1;

@levels = qw(Story Contents Issue Level4 Level5);

while (<>) {
  s/\s+/ /g;
  / chewLevels = (\d+);/ and ($levels = $1);
  / followOffsiteLinks = (\S+);/ and ($offsitelinks = $1);
  / includesImages = (\S+);/ and ($images = $1);
  / rootUrlString = \"(.+)\";/ and ($url = $1);
  / title = \"(.+)\";/ and ($title = $1);
}

if (!defined $url) {
  die "
Sorry, no rootUrlString found in subs file.  I do not know how to
convert this kind of file, yet.  Please mail this subs file to the
sitescooper list at <sitescooper\@netnoteinc.com> and we will all
have a go at working it out!
  ";
}

$site = "URL: $url
Name: $title
Levels: $levels\n";

for ($i = 1; $i < $levels; $i++) {
  $site .= $levels[$i]."Print: 1\n";
}

if ($offsitelinks eq 'true') {
  $site .= "StoryURL: http://.*\n";
}

# always use ALT tags, AvantGo sites quite often use images for navigation.
$site .= "UseAltTagForURL: http://.*\n";

$site .= "#
# This site was converted from an AvantGo .subs file by subs-to-site.pl.
# See http://sitescooper.cx/ for more information on sitescooper.
";

print $site;

=head1 NAME

subs-to-site - convert an AvantGo .subs file to a Sitescooper .site file.

=head1 SYNOPSIS

subs-to-site subsfile.subs > whatever.site

=head1 DESCRIPTION

This script will try to convert an AvantGo .subs file to a .site file suitable
for use with B<sitescooper>.

Provide the path of the .subs file as the command-line argument, and it'll try
to work out a decent site file for that site.  Currently the site file will
still require a little bit of hand-editing afterwards.

=head1 SEE ALSO

C<sitescooper>(1), C<rss-to-site>(1), C<subs-to-site>(1)

=head1 AUTHOR

Justin Mason E<lt>jm /at/ jmason.orgE<gt>

=head1 COPYRIGHT

Copyright (C) 1999-2000 Justin Mason

This program is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the Free
Software Foundation; either version 2 of the License, or (at your option)
any later version.

This program is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc., 59
Temple Place - Suite 330, Boston, MA  02111-1307, USA, or read it on
the web at http://www.gnu.org/copyleft/gpl.html .

=cut

