# Summary

- [Introduction](./introduction.md)
- [Install](./install.md)
- [Getting Started](./getting_started.md)

# User Guide

- [Key Concepts](./user_guide/key_concepts.md)
- [Terminal User Interface (TUI)](./user_guide/tui/index.md)
  - [In-App Editing & File Viewing](./user_guide/tui/editor.md)
  - [Data Filtering & Querying](./user_guide/tui/filter_query.md)
- [Command Line Interface (CLI)](./user_guide/cli.md)
- [Templates](./user_guide/templates/index.md)
  - [Chains - Complex Template Values](./user_guide/templates/chains.md)
  - [Data Extraction via JSONPath](./user_guide/templates/selector.md)
- [Collection Reuse & Inheritance](./user_guide/inheritance.md)
- [Importing External Collections](./user_guide/import.md)

# CLI Commands

- [slumber collections](./cli/collections.md)
- [slumber generate](./cli/generate.md)
- [slumber history](./cli/history.md)
- [slumber import](./cli/import.md)
- [slumber new](./cli/new.md)
- [slumber request](./cli/request.md)
- [slumber show](./cli/show.md)

# API Reference

- [Request Collection](./api/request_collection/index.md)
  - [Profile](./api/request_collection/profile.md)
  - [Template](./api/request_collection/template.md)
  - [Request Recipe](./api/request_collection/request_recipe.md)
    - [Query Parameters](./api/request_collection/query_parameters.md)
    - [Authentication](./api/request_collection/authentication.md)
    - [Recipe Body](./api/request_collection/recipe_body.md)
  - [Chain](./api/request_collection/chain.md)
  - [Chain Source](./api/request_collection/chain_source.md)
  - [Content Type](./api/request_collection/content_type.md)
- [Configuration](./api/configuration/index.md)
  - [Input Bindings](./api/configuration/input_bindings.md)
  - [MIME Maps](./api/configuration/mime.md)
  - [Theme](./api/configuration/theme.md)

# Integration

- [Neovim Integration](./integration/neovim-integration.md)

# Troubleshooting

- [Logs](./troubleshooting/logs.md)
- [Lost Request History](./troubleshooting/lost_history.md)
- [Shell Completions](./troubleshooting/shell_completions.md)
- [TLS Certificate Errors](./troubleshooting/tls.md)
