# Summary

- [Introduction](./introduction.md)
- [Install](./install.md)
- [Getting Started](./getting_started.md)

# User Guide

- [Key Concepts](./user_guide/key_concepts.md)
  - [Recipes](./user_guide/recipes.md)
  - [Templates](./user_guide/templates/index.md)
    - [Values](./user_guide/templates/values.md)
    - [Functions](./user_guide/templates/functions.md)
    - [Examples](./user_guide/templates/examples.md)
  - [Profiles](./user_guide/profiles.md)
- [Collection Reuse with `$ref`](./user_guide/composition.md)
- [Importing External Collections](./user_guide/import.md)
- [Terminal User Interface (TUI)](./user_guide/tui/index.md)
  - [In-App Editing & File Viewing](./user_guide/tui/editor.md)
  - [Data Filtering & Querying](./user_guide/tui/filter_query.md)
- [Command Line Interface (CLI)](./user_guide/cli/index.md)
  - [Subcommands](./user_guide/cli/subcommands.md)
- [Database & Persistence](./user_guide/database.md)
- [JSON Schema: Completion & Validation](./user_guide/json_schema.md)

# API Reference

- [Request Collection](./api/request_collection/index.md)
  - [Profile](./api/request_collection/profile.md)
  - [Request Recipe](./api/request_collection/request_recipe.md)
    - [Query Parameters](./api/request_collection/query_parameters.md)
    - [Authentication](./api/request_collection/authentication.md)
    - [Recipe Body](./api/request_collection/recipe_body.md)
- [Configuration](./api/configuration/index.md)
  - [Input Bindings](./api/configuration/input_bindings.md)
  - [MIME Maps](./api/configuration/mime.md)
  - [Theme](./api/configuration/theme.md)
- [Template Functions](./api/template_functions.md)

# Integration

- [Neovim Integration](./integration/neovim-integration.md)

# Troubleshooting

- [Logs](./troubleshooting/logs.md)
- [Lost Request History](./troubleshooting/lost_history.md)
- [TLS Certificate Errors](./troubleshooting/tls.md)

# Other

- [v3 to v4 Migration](./other/v4_migration.md)
- [Changelog](./other/changelog.md)
