/*
 * Copyright (c) 1997-2012 Motonori Nakamura <motonori@wide.ad.jp>
 * Copyright (c) 1997-2012 WIDE Project
 * Copyright (c) 1997-2003 Kyoto University
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by WIDE Project and
 *      its contributors.
 * 4. Neither the name of the Project, the University nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef lint
static char *copyright1 = "@(#)Copyright (c) 1997,1998 Motonori Nakamura";
static char *copyright2 = "@(#)Copyright (c) 1997,1998 WIDE Project.";
static char *copyright3 = "@(#)Copyright (c) 1997,1998 Kyoto University.";
static char *copyright4 = "@(#)All rights reserved.";
static char *_id_ = "$Id: main.c,v 1.76 2012/06/07 07:51:35 motonori Exp $";
#endif

# include "common.h"
# define MAIN	1
# include "extern.h"

void
usage(progname)
char *progname;
{
	printf("Usage: %s [options]\n", progname);
	printf("Options are:\n");
	printf("	-1		no piggybacking; par recipient SMTP\n");
	printf("	-2		separated delivery per domain\n");
	printf("	-5		check A/AAAA to fallback for v4 or v6 only\n");
	printf("	-a alias	my alias names to check MX list\n");
	printf("	-A		try T_ANY query first to get MX\n");
	printf("	-b size		TCP send buffer size\n");
	printf("	-c name		client side official name\n");
	printf("	-d debugopt	set debug options\n");
	printf("\t   opts:	A: all		a: address	c: conn.\n");
	printf("\t\t	e: event	h: hash		l: LMTP\n");
	printf("\t\t	m: map		n: DNS		s: SMTP\n");
	printf("\t\t	t: transaction	u: res. usage\n");
	printf("\t\t	D: no delivery	Q: DNS query only\n");
	printf("	-E		get queue-id info. from Received:\n");
	printf("	-F		insert recipient info. on Received:\n");
	printf("	-g gateway	set protocol gateway MX host\n");
	printf("	-h		show this message\n");
	printf("	-I queue-id	equiv. to -i but no purge on RSET\n");
	printf("	-i queue-id	queue-id from sendmail for logging\n");
	printf("	-l facility	set logging facility\n");
	printf("	-M map-file	path of map file\n");
	printf("	-m fallbackmx	set fallback MX host\n");
#ifdef INET6
	printf("	-N domain	4:IPv4 only, 6:IPv6 only, B:Both\n");
	printf("\t		B4:try IPv4 first, B6:try IPv6 first\n");
#endif
	printf("	-n num		available number of sockets\n");
	printf("	-o source-addr	source address for SMTP connection\n");
	printf("	-p port		SMTP source port number\n");
	printf("	-q num		max number of concurrent queries\n");
	printf("	-R num/file	max recipients per transaction\n");
	printf("	-r num		min recipients to work\n");
	printf("	-s size		max message size\n");
	printf("	-t cate=val	set timeouts (val: NUM[hms]; default is s)\n");
	printf("\t   cate(gory):	total, connect, greet, helo, mail,\n");
	printf("\t		rcpt, data, body, term, cache, rset, quit\n");
	printf("	-u		reuse SMTP connection for other MX\n");
	printf("	-V		insert version info. on Received:\n");
	printf("	-x		no error even if MX points absent A\n");
	printf("	-y\t	refer A RR if this host is the first MX\n");
	printf("	-z		surpress SMTP pipelining\n");
	printf("Version: %s\n", version);
}

static void
sig_quit()
{
	exit(EX_TEMPFAIL);
}

int
main(argc, argv, envp)
int argc;
char *argv[];
char *envp[];
{
	struct servent *sp;
	extern int optind;
	extern int opterr;
	extern char *optarg;
	char *progname, *p;
	int opt;
	struct rlimit limit;
	SockAddr peername;
	int peernamelen;
#define SHOW_UID 0
#if SHOW_UID
	uid_t uid;
#endif

	if (chdir("/var/tmp") < 0)
		if (chdir("/usr/tmp") < 0)
			chdir("/tmp");

	signal(SIGALRM, SIG_IGN);
        signal(SIGHUP,  SIG_IGN);
	signal(SIGQUIT, sig_quit);
        signal(SIGINT,  sig_quit);
        signal(SIGTERM,  sig_quit);
	if ((progname = strrchr(argv[0], '/')) != NULL)
		progname++;
	else
		progname = argv[0];
	myname[0] = '\0';
	myaliases = NULL;

	bzero(&sti, sizeof(sti));
	if ((p = getenv("SM_START_TIME")) != NULL)
	{
		sti.time_sm_start = (time_t)atoi(p);
	}

	bzero(&cnf, sizeof(cnf));
	cnf.sd_max = MAX_SOCK;
	cnf.log_facility = LOG_DEFAULT;
	cnf.rcpts_trans = 100;
	cnf.cquery_max = 50;
	cnf.src_mod_ptn = "<%s+%s=%s@%s>";

        if((sp = getservbyname("smtp", "tcp")) != NULL)
                cnf.dst_port = ntohs(sp->s_port);
        else
                cnf.dst_port = 25;

	initsetproctitle(argc, argv, envp);

	opterr = 0;
#ifdef INET6
#define	OPTS	"125Aa:b:c:d:EFg:hI:i:l:M:m:N:n:o:p:q:R:r:S:s:t:uVxyz"
#else
#define	OPTS	"125Aa:b:c:d:EFg:hI:i:l:M:m:n:o:p:R:q:r:S:s:t:uVxyz"
#endif
	while ((opt = getopt(argc, argv, OPTS)) != -1)
	{
		switch (opt)
		{
		    case '1':	/* 1: no piggybacking */
			cnf.rcpts_trans = 1;
			break;
		    case '2':	/* 2: no piggybacking among domains */
			cnf.domainsep = 1;
			break;
		    case '5':	/* 5: check A/AAAA to fallback for v4/v6 only */
			cnf.v4v6fallback = 1;
			break;
		    case 'A':	/* A: try T_ANY first */
			cnf.tryANYfirst = 1;
			break;
		    case 'a':	/* a: alias names */
			if (addmyalias(optarg) < 0)
			{
				/* XXX */
			}
			break;
		    case 'b':	/* b: send buffer size */
			cnf.sendbufsize = atoi(optarg);
			break;
		    case 'c':	/* c: client side official name */
			strncpy(myname, optarg, sizeof(myname));
			break;
		    case 'd':	/* d: debug option */
			p = optarg;
			while (*p != '\0')
			{
				switch (*p)
				{
				    case 'A':
					cnf.debug |= DEBUG_ALL;
					break;
				    case 'a':
					cnf.debug |= DEBUG_ADDRESS;
					break;
				    case 'c':
					cnf.debug |= DEBUG_CONNECT;
					break;
				    case 'e':
					cnf.debug |= DEBUG_EVENT;
					break;
				    case 'h':
					cnf.debug |= DEBUG_HASH;
					break;
				    case 'l':
					cnf.debug |= DEBUG_LMTP;
					break;
				    case 'm':
					cnf.debug |= DEBUG_MAP;
					break;
				    case 'n':
					cnf.debug |= DEBUG_DNS;
					break;
				    case 's':
					cnf.debug |= DEBUG_SMTP;
					break;
				    case 't':
					cnf.debug |= DEBUG_TRANS;
					break;
				    case 'u':
					cnf.debug |= DEBUG_RESUSE;
					break;
				    case 'D':
					cnf.debug |= DEBUG_NODELIVERY;
					break;
				    case 'Q':
					cnf.debug |= DEBUG_QUERYONLY;
					break;
				}
				p++;
			}
			break;
		    case 'E':	/* E: get queue-id info. from Received: */
			cnf.parsequeueid = 1;
			break;
#if 0
		    case 'f':	/* f: socket number to be freed at a time */
			break;
#endif
		    case 'F':	/* F: show recipient information */
			cnf.showrecipient++;
			break;
		    case 'g':	/* g: protocol gateway MX */
			if (cnf.pgateway != NULL)
				free(cnf.pgateway);
			cnf.pgateway = newstr(optarg);
			break;
		    case 'I':	/* I: queue-id just for logging (no purge) */
			if (env.queueid != NULL)
				free(env.queueid);
			env.queueid = newstr(optarg);
			env.keepqueueid = 1;
			break;
		    case 'i':	/* i: queue-id just for logging */
			if (env.queueid != NULL)
				free(env.queueid);
			env.queueid = newstr(optarg);
			break;
		    case 'l':	/* l: logging facility */
			if (strcasecmp(optarg, "none") == 0)
				cnf.log_facility = LOG_NONE;
			else if (strcasecmp(optarg, "stderr") == 0)
				cnf.log_facility = LOG_STDERR;
#ifdef LOG_DAEMON
			else if (strcasecmp(optarg, "daemon") == 0)
				cnf.log_facility = LOG_DAEMON;
#endif
#ifdef LOG_MAIL
			else if (strcasecmp(optarg, "mail") == 0)
				cnf.log_facility = LOG_MAIL;
#endif
#ifdef LOG_USER
			else if (strcasecmp(optarg, "user") == 0)
				cnf.log_facility = LOG_USER;
#endif
#ifdef LOG_LOCAL0
			else if (strcasecmp(optarg, "local0") == 0)
				cnf.log_facility = LOG_LOCAL0;
#endif
#ifdef LOG_LOCAL1
			else if (strcasecmp(optarg, "local1") == 0)
				cnf.log_facility = LOG_LOCAL1;
#endif
#ifdef LOG_LOCAL2
			else if (strcasecmp(optarg, "local2") == 0)
				cnf.log_facility = LOG_LOCAL2;
#endif
#ifdef LOG_LOCAL3
			else if (strcasecmp(optarg, "local3") == 0)
				cnf.log_facility = LOG_LOCAL3;
#endif
#ifdef LOG_LOCAL4
			else if (strcasecmp(optarg, "local4") == 0)
				cnf.log_facility = LOG_LOCAL4;
#endif
#ifdef LOG_LOCAL5
			else if (strcasecmp(optarg, "local5") == 0)
				cnf.log_facility = LOG_LOCAL5;
#endif
#ifdef LOG_LOCAL6
			else if (strcasecmp(optarg, "local6") == 0)
				cnf.log_facility = LOG_LOCAL6;
#endif
#ifdef LOG_LOCAL7
			else if (strcasecmp(optarg, "local7") == 0)
				cnf.log_facility = LOG_LOCAL7;
#endif
			break;
		    case 'M':	/* M: path of map faile */
			if (cnf.map != NULL)
				free(cnf.map);
			cnf.map = newstr(optarg);
			break;
		    case 'm':	/* m: fallback MX */
			if (cnf.fallbackmx != NULL)
				free(cnf.fallbackmx);
			cnf.fallbackmx = newstr(optarg);
			break;
#ifdef INET6
		    case 'N':	/* N: internet domain to be used */
			switch (*optarg)
			{
			  case '4':
				cnf.inetdom |= SMTP_V4;
				break;
			  case '6':
				cnf.inetdom |= SMTP_V6;
				break;
			  case 'b':
			  case 'B':
				cnf.inetdom |= SMTP_V4|SMTP_V6;
				switch (optarg[1])
				{
				  case '4':
					cnf.inetdom |= SMTP_V4_FIRST;
					break;
				  case '6':
					cnf.inetdom |= SMTP_V6_FIRST;
					break;
				}
				break;
			}
			break;
#endif
		    case 'n':	/* n: available socket number */
			cnf.sd_max = atoi(optarg);
			if (cnf.sd_max < 1)
				cnf.sd_max = 1;
			break;
		    case 'o':	/* o: source IP address */
			if (cnf.sourceIP != NULL)
				free(cnf.sourceIP);
			cnf.sourceIP = newstr(optarg);
			break;
		    case 'p':	/* p: source port number */
				/* rresvport() used if negative */
			cnf.src_port = atoi(optarg);
			break;
		    /* Q: quick start */
		    case 'q':	/* q: max number of concurrent queries */
			cnf.cquery_max = atoi(optarg);
			break;
		    case 'R':	/* R: recipients par transaction */
#if 0
			cnf.rcpts_trans = atoi(optarg);
#else
			if (cnf.rcpts_def != NULL)
				free(cnf.rcpts_def);
			cnf.rcpts_def = NULL;
			if(isnumeric(optarg))
				cnf.rcpts_trans = atoi(optarg);
			else
				cnf.rcpts_def = newstr(optarg);
#endif
			break;
		    case 'r':	/* r: number of recipients lower limit */
			cnf.rcpt_min = atoi(optarg);
			break;
		    case 'S':	/* S: sender envelope address modification */
			if (*optarg == '/')
			{
				if (cnf.src_mod_path != NULL)
					free(cnf.src_mod_path);
				cnf.src_mod_path = newstr(optarg);
			}
			else
			{
#if 0
				if (cnf.src_mod_ptn != NULL)
					free(cnf.src_mod_ptn);
#endif
				cnf.src_mod_ptn = newstr(optarg);
			}
			break;
		    case 's':	/* s: max message size */
			cnf.data_max = atoi(optarg);
			break;
		    case 't':	/* t: timeouts */
			set_timeout(optarg);
			break;
		    case 'u':	/* u: reuse SMTP connection */
			cnf.smtp_reuse = 1;
			break;
		    case 'V':	/* V: show version info. on Received: */
			cnf.showversion = 1;
			break;
		    case 'x':	/* x: no error even if MX points absent A */
			cnf.absentAok = 1;
			break;
		    case 'y':	/* y: refer A RR if this host is first MX */
			cnf.useAfirstMX = 1;
			break;
		    case 'z':	/* z: surpress SMTP pipelining */
			cnf.nopipelining = 1;
			break;
		    case 'h':
		    default:
			usage(progname);
			exit(EX_TEMPFAIL);
			break;
		}
	}
	argc -= optind;
	argv += optind;

#if 0
	if (argc > 0)
	{
		usage(progname);
		exit(EX_TEMPFAIL);
	}
#endif

#ifdef INET6
	/* set default */
	if (cnf.inetdom == 0)
		cnf.inetdom |= SMTP_V4|SMTP_V6|SMTP_V6_FIRST;
#endif

	init_logg();

	peernamelen = sizeof(peername);
	if (getpeername(0, (struct sockaddr *)&peername, &peernamelen) == 0)
	{
#ifdef INET6
		char buf[MAXLINE];
#endif
		switch (peername.in.sin_family)
		{
		    case AF_INET:
			logg(LOG_INFO, "connected from %s",
				inet_ntoa(peername.in.sin_addr));
			break;
#ifdef INET6
		    case AF_INET6:
			inet_ntop(AF_INET6, &peername.in6.sin6_addr,
				buf, sizeof(buf));
			logg(LOG_INFO, "connected from %s", buf);
			break;
#endif
		}
	}

	if (cnf.sd_max > MAX_SOCK)
	{
		logg(LOG_INFO, "cnf.sd_max should not be greater than %d, recompile smtpfeed with greater FD_SETSIZE", MAX_SOCK);
		cnf.sd_max = MAX_SOCK;
	}
#ifdef RLIMIT_NOFILE
	if (!getrlimit(RLIMIT_NOFILE, &limit))
	{
		if (limit.rlim_max - 1 < cnf.sd_max)
		{
			logg(LOG_INFO, "cnf.sd_max should be %d",
				limit.rlim_max - 1);
			cnf.sd_max = limit.rlim_max - 1;
		}
		limit.rlim_cur = limit.rlim_max; /* make soft limit the max */
		if (setrlimit(RLIMIT_NOFILE, &limit) == -1)
		{
			logg(LOG_NOTICE, "can't set max sd to %d",
				limit.rlim_cur);
		}
	}
#endif

#if SHOW_UID
	uid = geteuid();
#ifdef INET6
        logg(LOG_DEBUG, "%s (with IPv6) started (uid %d with %d descriptors)",
		version, uid, cnf.sd_max);
#else
        logg(LOG_DEBUG, "%s started (uid %d with %d descriptors)",
		version, uid, cnf.sd_max);
#endif
#else
#ifdef INET6
        logg(LOG_DEBUG, "%s (with IPv6) started (with %d descriptors)",
		version, cnf.sd_max);
#else
        logg(LOG_DEBUG, "%s started (with %d descriptors)",
		version, cnf.sd_max);
#endif
#endif

	res_init();
	if (cnf.map != NULL && host_map_load() < 0)
	{
		exit(EX_TEMPFAIL);
	}
	resource_usage("initialize");

	if (cnf.t_timeout == 0)
		cnf.t_timeout = 55 MINUTES;
	host_list = NULL;
	domain_list = NULL;

	_res.options |= RES_DEFNAMES | RES_DNSRCH;

	if (*myname == '\0')
		gethostname(myname, sizeof(myname));
	if (strchr(myname, '.') == NULL)
	{
		/* not a FQDN */
		struct hostent *hp;

		hp = gethostbyname(myname);
		if (hp != NULL)
		{
			if (strchr(hp->h_name, '.') != NULL)
				strncpy(myname, hp->h_name, sizeof(myname));
			else
			{
				while (*hp->h_aliases != NULL)
				{
					if (strchr(*hp->h_aliases, '.') != NULL)
					{
						strncpy(myname, *hp->h_aliases,
							sizeof(myname));
						break;
					}
					hp->h_aliases++;
				}
			}
		}
		if (strchr(myname, '.') == NULL)
			logg(LOG_INFO, "hostname (%s) is not a FQDN", myname);
	}
	if (addmyalias(myname) < 0)
	{
		/* XXX */
	}
	if (cnf.fallbackmx != NULL && isamyalias(cnf.fallbackmx))
	{
		logg(LOG_INFO, "ignoring fallbackmx (%s)", cnf.fallbackmx);
		free(cnf.fallbackmx);
		cnf.fallbackmx = NULL;
	}
	if (cnf.pgateway != NULL && isamyalias(cnf.pgateway))
	{
		logg(LOG_INFO, "ignoring protocol gateway (%s)", cnf.pgateway);
		free(cnf.pgateway);
		cnf.pgateway = NULL;
	}

	if (cnf.rcpts_def != NULL)
	{
		if(rcpts_def_load() < 0)
		{
			logg(LOG_INFO, "ignoring R option (%s)", cnf.rcpts_def);
			free(cnf.rcpts_def);
			cnf.rcpts_def = NULL;
		}
	}

	/* stdin/stdout will be used */
#if 0
	close (2);
	close (3);
	close (4);
#endif

	_res.options &= ~(RES_DEFNAMES | RES_DNSRCH);

	lmtp();

	resource_usage("all done");

	exit(EX_OK);
	/*NOTREACHED*/
	return EX_OK;
}
