#! /usr/local/bin/perl

# summary-log.pl : summarize statistic information from syslog file.

# Usage: cat /var/log/local5.log* | summary-log.pl > summary

$LowLimit = 10;

%month = ('Jan', 1, 'Feb', 2, 'Mar', 3, 'Apr', 4, 'May', 5, 'Jun', 6,
	'Jul', 7, 'Aug', 8, 'Sep', 9, 'Oct', 10, 'Nov', 11, 'Dec', 12);

print "# Version 1\n";
print "# nsent,ntrans,maxsock,tsendmail,tmx,tdelivery\n";

while (<>) {
	chop;
	next unless (m|smtp_i/o|);
	@line = split(' ');

	$date = $month{$line[0]}.'/'.$line[1].' '.$line[2];

	undef %data;
	foreach $eq (split(' ')) {
		if ($eq =~ /=/) {
			($data{$`} = $') =~ s|/|,|;
		}
	}

	next if ((split(',', $data{nsent}))[0] < $LowLimit);
#	next if ($data{tsendmail} < 0);

	print "$date, $data{nsent}, $data{ntrans}, $data{maxsock}, "
		."$data{tsendmail}, $data{tmx}, $data{tdelivery}\n";
}

exit 0;
