/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.booter;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.maven.surefire.booter.ClassLoaderConfiguration;
import org.apache.maven.surefire.booter.ClasspathConfiguration;
import org.apache.maven.surefire.booter.PropertiesWrapper;
import org.apache.maven.surefire.booter.ProviderConfiguration;
import org.apache.maven.surefire.booter.Shutdown;
import org.apache.maven.surefire.booter.StartupConfiguration;
import org.apache.maven.surefire.booter.SystemPropertyManager;
import org.apache.maven.surefire.booter.TypeEncodedValue;
import org.apache.maven.surefire.cli.CommandLineOption;
import org.apache.maven.surefire.report.ReporterConfiguration;
import org.apache.maven.surefire.testset.DirectoryScannerParameters;
import org.apache.maven.surefire.testset.RunOrderParameters;
import org.apache.maven.surefire.testset.TestArtifactInfo;
import org.apache.maven.surefire.testset.TestListResolver;
import org.apache.maven.surefire.testset.TestRequest;

public class BooterDeserializer {
    private final PropertiesWrapper properties;

    public BooterDeserializer(InputStream inputStream) throws IOException {
        this.properties = SystemPropertyManager.loadProperties(inputStream);
    }

    public ProviderConfiguration deserialize() {
        File reportsDirectory = new File(this.properties.getProperty("reportsDirectory"));
        String testNgVersion = this.properties.getProperty("testFwJarVersion");
        String testArtifactClassifier = this.properties.getProperty("testFwJarClassifier");
        TypeEncodedValue typeEncodedTestForFork = this.properties.getTypeEncodedValue("forkTestSet");
        boolean preferTestsFromInStream = this.properties.getBooleanProperty("preferTestsFromInStream");
        String requestedTest = this.properties.getProperty("requestedTest");
        File sourceDirectory = this.properties.getFileProperty("testSuiteDefinitionTestSourceDirectory");
        List<String> excludes = this.properties.getStringList("excludes");
        List<String> includes = this.properties.getStringList("includes");
        List<String> specificTests = this.properties.getStringList("specificTest");
        List<String> testSuiteXmlFiles = this.properties.getStringList("testSuiteXmlFiles");
        File testClassesDirectory = this.properties.getFileProperty("testClassesDirectory");
        String runOrder = this.properties.getProperty("runOrder");
        String runStatisticsFile = this.properties.getProperty("runStatisticsFile");
        int rerunFailingTestsCount = this.properties.getIntProperty("rerunFailingTestsCount");
        DirectoryScannerParameters dirScannerParams = new DirectoryScannerParameters(testClassesDirectory, includes, excludes, specificTests, this.properties.getBooleanProperty("failIfNoTests"), runOrder);
        RunOrderParameters runOrderParameters = new RunOrderParameters(runOrder, runStatisticsFile);
        TestArtifactInfo testNg = new TestArtifactInfo(testNgVersion, testArtifactClassifier);
        TestRequest testSuiteDefinition = new TestRequest(testSuiteXmlFiles, sourceDirectory, new TestListResolver(requestedTest), rerunFailingTestsCount);
        ReporterConfiguration reporterConfiguration = new ReporterConfiguration(reportsDirectory, this.properties.getBooleanProperty("isTrimStackTrace"));
        List<String> cli = this.properties.getStringList("mainCliOptions");
        int failFastCount = this.properties.getIntProperty("failFastCount");
        Shutdown shutdown = Shutdown.valueOf((String)this.properties.getProperty("shutdown"));
        return new ProviderConfiguration(dirScannerParams, runOrderParameters, this.properties.getBooleanProperty("failIfNoTests"), reporterConfiguration, testNg, testSuiteDefinition, this.properties.getProperties(), typeEncodedTestForFork, preferTestsFromInStream, CommandLineOption.fromStrings(cli), failFastCount, shutdown);
    }

    public StartupConfiguration getProviderConfiguration() {
        boolean useSystemClassLoader = this.properties.getBooleanProperty("useSystemClassLoader");
        boolean useManifestOnlyJar = this.properties.getBooleanProperty("useManifestOnlyJar");
        String providerConfiguration = this.properties.getProperty("providerConfiguration");
        ClassLoaderConfiguration classLoaderConfiguration = new ClassLoaderConfiguration(useSystemClassLoader, useManifestOnlyJar);
        ClasspathConfiguration classpathConfiguration = new ClasspathConfiguration(this.properties);
        return StartupConfiguration.inForkedVm(providerConfiguration, classpathConfiguration, classLoaderConfiguration);
    }
}

