#include "sniff2.h"

extern pcap_t *ip_socket;

void ifOpen(void)
{
   char *interface;
   char errbuf[PCAP_ERRBUF_SIZE];
   __u32  localnet, netmask;
   struct bpf_program fcode;

         interface = pcap_lookupdev(errbuf);
         printf("Found interface: %s\n",interface);
         if (interface == NULL) {
            printf("interface not found: %s\n",errbuf);
            exit(-1);
	}
      ip_socket = pcap_open_live(interface,1024,1,1024,errbuf);
      if (ip_socket == NULL) {
         printf("pcap_open_live failed: %s\n",errbuf);
         exit(-1);
      }
      
      if (pcap_lookupnet(interface, &localnet, &netmask, errbuf) < 0) {
	 localnet = 0;
         netmask = 0;
         printf("%s", errbuf);
         exit(-1);
      }
      if (pcap_compile(ip_socket, &fcode, FILTER, 0, netmask) < 0) {
         printf("%s", pcap_geterr(ip_socket));
         exit(-1);
      }
      if (pcap_setfilter(ip_socket, &fcode) < 0) {
         printf("%s", pcap_geterr(ip_socket));
         exit(-1);
      }
}
