/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.refactoring.gui;

import java.awt.Component;
import java.awt.Frame;
import javax.swing.JLabel;
import javax.swing.JTextField;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.plugins.refactoring.gui.AbstractRefactoringDialog;

public class RenameTableDialog
extends AbstractRefactoringDialog {
    private static final long serialVersionUID = 1L;
    public static final int DIALOG_TYPE_VIEW = 1;
    public static final int DIALOG_TYPE_TABLE = 2;
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(RenameTableDialog.class);
    private final IDatabaseObjectInfo[] dbInfo;
    private JTextField tableTF;

    public RenameTableDialog(IDatabaseObjectInfo[] dbInfo, int dialogType, Frame owningFrame) {
        super(owningFrame);
        this.dbInfo = dbInfo;
        if (dialogType == 2) {
            this.setTitle(i18n.TITLE_TABLE);
        } else if (dialogType == 1) {
            this.setTitle(i18n.TITLE_VIEW);
        }
        this.init();
    }

    protected void init() {
        this.setSize(400, 150);
        JLabel catalogLabel = this.getBorderedLabel(i18n.CATALOG_LABEL + " ", this.emptyBorder);
        this.pane.add((Component)catalogLabel, this.getLabelConstraints(this.c));
        JTextField catalogTF = new JTextField();
        catalogTF.setPreferredSize(this.mediumField);
        catalogTF.setEditable(false);
        catalogTF.setText(this.dbInfo[0].getCatalogName());
        this.pane.add((Component)catalogTF, this.getFieldConstraints(this.c));
        JLabel schemaLabel = this.getBorderedLabel(i18n.SCHEMA_LABEL + " ", this.emptyBorder);
        this.pane.add((Component)schemaLabel, this.getLabelConstraints(this.c));
        JTextField schemaTF = new JTextField();
        schemaTF.setPreferredSize(this.mediumField);
        schemaTF.setEditable(false);
        schemaTF.setText(this.dbInfo[0].getSchemaName());
        this.pane.add((Component)schemaTF, this.getFieldConstraints(this.c));
        JLabel tableLabel = this.getBorderedLabel(i18n.TABLE_LABEL + " ", this.emptyBorder);
        tableLabel.setVerticalAlignment(1);
        this.pane.add((Component)tableLabel, this.getLabelConstraints(this.c));
        this.tableTF = new JTextField();
        this.tableTF.setToolTipText(s_stringMgr.getString("RenameTableDialog.tableField.ToolTipText", new Object[]{this.dbInfo[0].getSimpleName()}));
        this.tableTF.setPreferredSize(this.mediumField);
        this.tableTF.setEditable(true);
        this.tableTF.setText(this.dbInfo[0].getSimpleName());
        this.pane.add((Component)this.tableTF, this.getFieldConstraints(this.c));
        this.executeButton.setRequestFocusEnabled(true);
    }

    public String getNewSimpleName() {
        return this.tableTF.getText();
    }

    static /* synthetic */ StringManager access$000() {
        return s_stringMgr;
    }

    static interface i18n {
        public static final String CATALOG_LABEL = RenameTableDialog.access$000().getString("RenameTableDialog.catalogLabel");
        public static final String SCHEMA_LABEL = RenameTableDialog.access$000().getString("RenameTableDialog.schemaLabel");
        public static final String TABLE_LABEL = RenameTableDialog.access$000().getString("RenameTableDialog.viewLabel");
        public static final String TITLE_VIEW = RenameTableDialog.access$000().getString("RenameTableDialog.titleView");
        public static final String TITLE_TABLE = RenameTableDialog.access$000().getString("RenameTableDialog.titleTable");
    }
}

