/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel.overview;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import net.sourceforge.squirrel_sql.client.gui.builders.UIFactory;
import net.sourceforge.squirrel_sql.client.session.mainpanel.overview.ChartConfigListener;
import net.sourceforge.squirrel_sql.client.session.mainpanel.overview.ChartConfigPanelTab;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class ChartConfigPanel
extends JScrollPane {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ChartConfigPanel.class);

    public ChartConfigPanel(ArrayList<ChartConfigPanelTab> chartConfigPanelTabs, ChartConfigListener chartConfigListener) {
        JTabbedPane tabbedPane = UIFactory.getInstance().createTabbedPane();
        for (ChartConfigPanelTab chartConfigPanelTab : chartConfigPanelTabs) {
            tabbedPane.add(chartConfigPanelTab.getTabTitle(), this.createTabPanel(chartConfigPanelTab, chartConfigListener));
        }
        this.setViewportView(tabbedPane);
    }

    private JPanel createTabPanel(ChartConfigPanelTab chartConfigPanelTab, ChartConfigListener chartConfigListener) {
        JPanel ret = new JPanel(new BorderLayout());
        ret.add((Component)this.createCloseButtonPanel(chartConfigListener), "North");
        ret.add((Component)chartConfigPanelTab, "Center");
        return ret;
    }

    private JPanel createCloseButtonPanel(final ChartConfigListener chartConfigListener) {
        JPanel ret = new JPanel(new BorderLayout());
        JButton btnClose = new JButton(s_stringMgr.getString("overview.ChartConfigPanel.close"));
        ret.add((Component)btnClose, "West");
        ret.add((Component)new JPanel(), "Center");
        btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                chartConfigListener.closeSplit();
            }
        });
        return ret;
    }
}

