set title 'MDP Sender Congestion Control Metrics'
set data style lines
set xlabel 'Time (sec)'
set ylabel 'Rate (kbps)'
set y2label 'Rtt Measurements (sec)'
set ytics nomirror
set y2tics
plot \
'mdpLog.txt' using 1:5 \
'RateControlStatus> time>%lf loss>%lf rtt>%lf tzero>%lf goal_rate>%lf' t 'Goal Rate', \
'mdpLog.txt' using 1:6 \
'RateControlStatus> time>%lf loss>%lf rtt>%lf tzero>%lf goal_rate>%lf tx_rate>%lf' t 'Tx Rate', \
'mdpLog.txt' using 1:3 \
'RateControlStatus> time>%lf loss>%lf rtt>%lf tzero>%lf goal_rate>%lf' axes x1y2 t 'RTT', \
'mdpLog.txt' using 1:4 \
'RateControlStatus> time>%lf loss>%lf rtt>%lf tzero>%lf goal_rate>%lf tx_rate>%lf' axes x1y2 t 'T0', \
'mdpLog.txt' using 1:($2 * 100) \
'RateControlStatus> time>%lf loss>%lf rtt>%lf tzero>%lf goal_rate>%lf' axes x1y2 t 'Loss Estimate', \
'mdpLog.txt' using 1:7 \
'RateControlStatus> time>%lf loss>%lf rtt>%lf tzero>%lf goal_rate>%lf tx_rate>%lf frate>%lf' t 'F-Rate'


