/*********************************************************************
 *
 * AUTHORIZATION TO USE AND DISTRIBUTE
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that: 
 *
 * (1) source code distributions retain this paragraph in its entirety, 
 *  
 * (2) distributions including binary code include this paragraph in
 *     its entirety in the documentation or other materials provided 
 *     with the distribution, and 
 *
 * (3) all advertising materials mentioning features or use of this 
 *     software display the following acknowledgment:
 * 
 *      "This product includes software written and developed 
 *       by Brian Adamson and Joe Macker of the Naval Research 
 *       Laboratory (NRL)." 
 *         
 *  The name of NRL, the name(s) of NRL  employee(s), or any entity
 *  of the United States Government may not be used to endorse or
 *  promote  products derived from this software, nor does the 
 *  inclusion of the NRL written and developed software  directly or
 *  indirectly suggest NRL or United States  Government endorsement
 *  of this product.
 * 
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 ********************************************************************/
 
/*************************************************************
Multicast Dissemination Protocol version 2 (MDPv2)

This source code is part of the prototype NRL MDPv2 release
and was written and developed by Brian Adamson and Joe Macker.
This is presently experimental code and therefore use it at your 
own risk.  Please include this notice and provide credit to the 
authors and NRL if this program or parts of it are used for any 
purpose.

We would appreciate receiving any contributed enhancements 
or modifications to this code release. Please contact the developers 
with comments/questions regarding this code release.  Feedback on
use of this code can help continue support for further development.

Joe Macker  				        Brian Adamson
Email: <macker@itd.nrl.navy.mil>	<adamson@newlink.net>
Telephone: +1-202-767-2001		    +1-202-404-1194
Naval Research Laboratory		    Newlink Global Engineering Corp.
Information Technology Division 	6506 Loisdale Road Suite 209
4555 Overlook Avenue			    Springfield VA 22150
Washington DC 20375                 <http://www.ngec.com>
**************************************************************/

// winMdp.h : main header file for the WINMDP application
//

#ifndef __AFXWIN_H__
	#error include 'stdafx.h' before including this file for PCH
#endif

#include <ddeml.h>

#include "resource.h"		// main symbols
#include "mdpApi.h"
#include "mdpApp.h"

#define MDP_TIMER_MSG (WM_USER+1)
#define MDP_SOCKET_MSG (WM_USER+2)
const TX_INTERVAL_TIMER = 1;  // timer id for TxIntervalTimer


// We're forced to keep a list of sockets of our
// own since Win32 doesn't let us attach user data to
// sockets getting async notification

class WinSocketItem
{
	friend class WinSocketList;

	public:
		enum SocketType {UDP, TCP};
		WinSocketItem(SOCKET theHandle, SocketType theType, void* userData);
		SOCKET Handle() {return handle;}
		void* UserData() {return user_data;}
		SocketType Type() {return type;}

	private:
		SOCKET			handle;
		SocketType	    type;
		void*			user_data;
		WinSocketItem*	next;
};

class WinSocketList
{
	public:
		WinSocketList();
		~WinSocketList();
		void Destroy();
		WinSocketItem* FindSocketByHandle(SOCKET theHandle);
		WinSocketItem* NewSocketItem(SOCKET						theHandle, 
						             WinSocketItem::SocketType	theType, 
			                         void*						userData);
		void DeleteSocketItem(SOCKET theHandle);

	private:
		WinSocketItem* top;
};  // end class WinSocketList


/////////////////////////////////////////////////////////////////////////////
// CWinMdpApp:
// See winMdp.cpp for the implementation of this class
//

class CWinMdpApp : public CWinApp, public MdpApp
{
    public:
	    CWinMdpApp();

        void StartTxIntervalTimer(double delay);     
        void StopTxIntervalTimer();
	    void OnTxIntervalTimeout();
		void Alert(const char *format, ...);
		WinSocketItem* FindSocketByHandle(SOCKET theHandle) {return socket_list.FindSocketByHandle(theHandle);}
		void ClearTimerPost() {timer_post_pending = false;}

    private:
    // Members

	    UINT	timer_resolution;
		bool	timer_post_pending;

	    // Post Processor DDE state
	    DWORD		lIdInst;   // DDE instance id
	    HCONV		hConv;     // dde converstation handle
	    DWORD		transaction_id;
	    DWORD		window_id; // dde browser window id
	    PFNCALLBACK	lpDDECallback;
		HANDLE		post_processor_handle;

		UINT		tx_interval_timer_id;
		WinSocketList socket_list;

    // Methods
	    void SetStatusText(const char* theText);
        void SetProgressMeter(unsigned int percent);
        void PostProcess(const char* path);

	    static HDDEDATA CALLBACK DDEClientCallback(
			    UINT uiType, UINT uiFmt, HCONV hConv, 
			    HSZ sz1, HSZ sz2, HDDEDATA hData,
			    DWORD lData1, DWORD lData2);

	    static bool MdpTimerInstaller(MdpTimerInstallCmd    cmd, 
                                      double                delay,
                                      MdpTimerHandle        timerHandle, 
                                      MdpInstanceHandle     instanceHandle);

	    static void CALLBACK MdpTimerCallback(UINT uID, UINT uMsg, DWORD dwUser, 
										      DWORD dw1, DWORD dw2);

		static bool MdpSocketInstaller(MdpSocketInstallCmd  cmd,
                                       MdpSocketHandle       socketHandle,
                                       MdpInstanceHandle     instanceHandle);
    // Overrides
    // ClassWizard generated virtual function overrides
    //{{AFX_VIRTUAL(CWinMdpApp)
    public:
	    virtual BOOL InitInstance();
	    virtual int ExitInstance();
	    //}}AFX_VIRTUAL

    // Implementation

	    //{{AFX_MSG(CWinMdpApp)
	    afx_msg void OnMdpTimer(WPARAM wParam, LPARAM lParam);
	    afx_msg void OnSettingsDebug();
	    afx_msg void OnSettingsProcessor();
	    //}}AFX_MSG
	    DECLARE_MESSAGE_MAP()

};  // end class CWinMdpApp

extern CWinMdpApp theApp;

/////////////////////////////////////////////////////////////////////////////

// For parsing command line options
class CWinMdpCmdLineInfo : public CCommandLineInfo
{
	private:
		CWinMdpApp* app;
		char current_flag;
        bool error_detected;

	public:
		CWinMdpCmdLineInfo(CWinMdpApp* theApp);
        bool ErrorDetected() {return error_detected;}
		// Overrides
		void ParseParam(LPCTSTR lpszParam, BOOL bFlag, BOOL bLast);
};  // end class CWinMdpCmdLineInfo


