// Arguments: Doubles, Doubles, Doubles
#include <stan/math/prim/scal.hpp>

using stan::math::var;
using std::numeric_limits;
using std::vector;

class AgradDistributionNormal : public AgradDistributionTest {
 public:
  void valid_values(vector<vector<double> >& parameters,
                    vector<double>& log_prob) {
    vector<double> param(3);

    param[0] = 0;  // y
    param[1] = 0;  // mu
    param[2] = 1;  // sigma
    parameters.push_back(param);
    log_prob.push_back(-0.918938533204672669541);  // expected log_prob

    param[0] = 1;  // y
    param[1] = 0;  // mu
    param[2] = 1;  // sigma
    parameters.push_back(param);
    log_prob.push_back(-1.418938533204672669541);  // expected log_prob

    param[0] = -2;  // y
    param[1] = 0;   // mu
    param[2] = 1;   // sigma
    parameters.push_back(param);
    log_prob.push_back(-2.918938533204672669541);  // expected log_prob

    param[0] = -3.5;  // y
    param[1] = 1.9;   // mu
    param[2] = 7.2;   // sigma
    parameters.push_back(param);
    log_prob.push_back(-3.174269559226682080322);  // expected log_prob
  }

  void invalid_values(vector<size_t>& index, vector<double>& value) {
    // y

    // mu
    index.push_back(1U);
    value.push_back(numeric_limits<double>::infinity());

    index.push_back(1U);
    value.push_back(-numeric_limits<double>::infinity());

    // sigma
    index.push_back(2U);
    value.push_back(0.0);

    index.push_back(2U);
    value.push_back(-1.0);

    index.push_back(2U);
    value.push_back(-numeric_limits<double>::infinity());
  }

  template <typename T_y, typename T_loc, typename T_scale, typename T3,
            typename T4, typename T5>
  typename stan::return_type<T_y, T_loc, T_scale>::type log_prob(
      const T_y& y, const T_loc& mu, const T_scale& sigma, const T3&, const T4&,
      const T5&) {
    return stan::math::normal_log(y, mu, sigma);
  }

  template <bool propto, typename T_y, typename T_loc, typename T_scale,
            typename T3, typename T4, typename T5>
  typename stan::return_type<T_y, T_loc, T_scale>::type log_prob(
      const T_y& y, const T_loc& mu, const T_scale& sigma, const T3&, const T4&,
      const T5&) {
    return stan::math::normal_log<propto>(y, mu, sigma);
  }

  template <typename T_y, typename T_loc, typename T_scale, typename T3,
            typename T4, typename T5>
  typename stan::return_type<T_y, T_loc, T_scale, T3, T4, T5>::type
  log_prob_function(const T_y& y, const T_loc& mu, const T_scale& sigma,
                    const T3&, const T4&, const T5&) {
    using stan::math::pi;
    return -0.5 * (y - mu) * (y - mu) / (sigma * sigma) - log(sigma)
           - log(sqrt(2.0 * pi()));
  }
};
