/* This file is part of statist
**
** It is distributed under the GNU General Public License.
** See the file COPYING for details.
** 
** (c) 1997 Dirk Melcher
** old email address: Dirk.Melcher@usf.Uni-Osnabrueck.DE
**
** adaptions for StatistX: Andreas Beyer, 1999, abeyer@usf.uni-osnabrueck.de
**
** published by Bernhard Reiter  http://www.usf.Uni-Osnabrueck.DE/~breiter
** $Id: statist.h,v 1.11 2001/11/15 20:29:38 breiter Exp breiter $
***************************************************************/

#include <stdio.h>

#include "gettext.h"
#include "memory_handling.h"

#define _STATIST_VERSION_NUMBER "1.0.1" 

#define VERSION_INFO _("STATIST --- Version " _STATIST_VERSION_NUMBER \
 "--- (C) Dirk Melcher 1997-1999\n \
Published by Bernhard Reiter 1998-2001.\n \
STATIST comes with ABSOLUTELY NO WARRANTY; it is Free Software under GPL.\n \
Read the file COPYING for details.\n\
Hint: You can often answer \"all\" for the number of columns.\n" ,\
"STATIST --- Version " _STATIST_VERSION_NUMBER \
" --- (C) Dirk Melcher 1997-1999 unter der GPL\n\
Herausgegeben 1998-2001 von Bernhard Reiter.\n\
Statist kommt ohne Garantie und ist Freie Software.\n\
TIPP: bei der Frage nach Anzahl der Spalten gilt manchmal auch \"alle\" !") 

#define STATIST_VERSION "statist -- version " _STATIST_VERSION_NUMBER

#ifdef MSDOS
#define SCREENSIZE 24
  /* change the MSDOS_FIXED_TMP_FILE, if you want statist to create
	the temporary files at a different place on MSDOS	
	"%i"  must be in the string once, to replaced by an (integer) number
   */
#ifndef MSDOS_FIXED_TMP_FILE
#define MSDOS_FIXED_TMP_FILE "c:\\tmp\\stat%i.tmp"
#endif
#else
#define SCREENSIZE 40
#endif


/* others may define TRUE & FALSE, too! */
#ifndef TRUE
#define TRUE 1
#endif
#ifndef FALSE
#define FALSE 0
#endif

#define CRASH -1
#define MCOL 60      /* Max. Anzahl der Spalten, die geladen werden duerfen */
#define CHAR_OFFSET 97  /* Position von `a' in ASCII-Code */
#define QUIT 0
#define COMMENT '#'  /* erlaubtes Kommentarzeichen in Datenfiles */
#define NODATA 'M'   /* Kennung fuer nicht vorhandene Daten in Datenfiles */
/* Kennwort -> alle Spalten waehlen */
#define _ALL_ _("all", "alle")
#define MCLASS 60    /* max. Anz. von Klassen bei Test auf Normalverteilung */
#define MPOLY 20     /* maximaler Grad des Polynoms */
#define MOPT  11     /* Max. Anzahl der Optionen */
#define MLINE 255    /* Max. Zeichen fuer Standard-Zeilenvariable */

#define WAR 0        /* Fehler-Warnung */
#define ERR 1        /* Normaler Fehler */
#define FAT 2        /* Fataler Fehler */
#define MAT 3        /* Mathe-Fehler */
#define MWA 4        /* Mathe-Warnung */

#define SQR(x) ((x) * (x))
#define PRINTLINE out_d("================================================\n\n");

/* #define GETRLINE  gets(line);             \ */
#define GETRLINE  fgets((line), (MLINE-1), (stdin)); \
                  if (strlen(line) <=1) { \
		    empty = TRUE;         \
		    return;               \
		  }                       \
		  else {                  \
		    line[strlen(line)-1]='\0'; \
		    empty = FALSE;        \
		  }

#define GETNLINE  fgets((line), (MLINE-1), (stdin)); \
                  if (strlen(line) <=1) { \
		    empty = TRUE;         \
		  }                       \
		  else {                  \
		    line[strlen(line)-1]='\0'; \
		    empty = FALSE;        \
		  }

#define GETBLINE fgets((line), (MLINE-1), (stdin));  \
                  if (strlen(line) <=1) { \
		    empty = TRUE;         \
		    break;                \
		  }                       \
		  else {                  \
		    line[strlen(line)-1]='\0'; \
		    empty = FALSE;        \
		  }

#ifdef SUNOS
extern char *sys_errlist[];
#define STRERROR(errno) sys_errlist[errno]
#else
#define STRERROR(errno) strerror(errno)
#endif

#ifdef DEBUG
#define ERR_LINE __LINE__
#define ERR_FILE __FILE__
#else
#define ERR_LINE 0
#define ERR_FILE ""
#endif


#define FOPEN(name, mode, fp)                                    \
  if ((fp = fopen((name), (mode)))==NULL) {                      \
    out_err(FAT, ERR_FILE, ERR_LINE,                             \
    _(" System reports error while opening file %s:\n   %s",	\
       " System meldet Fehler beim Oeffnen von Datei %s:\n   %s"),\
       name, STRERROR(errno));                                   \
  }

#define FWRITE(ptr, size, nmemb, fp)                             \
  if (fwrite((ptr), (size), (nmemb), (fp)) != (nmemb)) {         \
    out_err(FAT,ERR_FILE, ERR_LINE,                              \
    _(" System reports error while writing with fwrite:\n %s",   \
      " System meldet Fehler beim Schreiben mit fwrite:\n  %s"), \
              STRERROR(errno));                                  \
  }                                                              

#define FREAD(ptr, size, nmemb, fp)                              \
  if (fread((ptr), (size), (nmemb), (fp)) != (nmemb)) {          \
    if (feof(fp)) {                                              \
      out_err(FAT, ERR_FILE, ERR_LINE,                           \
    _(" Error while reading with fread: Unexpected end of file", \
        " Fehler beim Lesen mit fread: Unerwartetes Dateiende") );\
    }                                                            \
    else {                                                       \
      out_err(FAT, ERR_FILE, ERR_LINE,                           \
	  _("System reports error while reading with fread:\n %s", \
        " System meldet Fehler beim Lesen mit fread:\n  %s"),    \
              STRERROR(errno));                                  \
    }                                                            \
  }                                                              
  
#define FGETS(line, size, fp)                                    \
  if (fgets((line), (size), (fp))==NULL) {                       \
    if (feof(fp)) {                                              \
      out_err(FAT, ERR_FILE, ERR_LINE,                           \
	_("   Error while reading with fgets: Unexpected end of file\n", \
		"  Fehler beim Lesen mit fgets: Unerwartetes Dateiende\n") );\
    }                                                            \
    else {                                                       \
      out_err(FAT, ERR_FILE, ERR_LINE,                           \
	_(" System reports error while reading with fgets:\n   %s",\
      " System meldet Fehler beim Lesen mit fgets:\n   %s"),     \
              STRERROR(errno));                                  \
    }                                                            \
  }                                                              
								 
#define FCLOSE(fp)                                               \
  if (fclose(fp) != 0) {                                         \
    out_err(ERR, ERR_FILE, ERR_LINE,                             \
    _("System reports error while attempting to close file:\n  %s",\
      " System meldet Fehler beim Schliessen einer Datei:\n %s"),\
            STRERROR(errno));                                    \
  }								 



#define DIV(r, c, d)                                             \
   if ((d)==0.0) {                                               \
     out_err(MAT, ERR_FILE, ERR_LINE, 					\
     		_("Division by 0!",						\
		"Division durch 0!") );      					\
     return;							 		\
   }                                                             \
   else {                                                        \
     r = (c)/(d);                                                \
   }								 
								 
#define RDIV(r, c, d)                                            \
   if ((d)==0.0) {                                               \
     out_err(MAT, ERR_FILE, ERR_LINE,   					\
     		_("Division by 0!",						\
		"Division durch 0!") );      					\
     return REAL_MIN;						 \
   }                                                             \
   else {                                                        \
     r = (c)/(d);                                                \
   }								 
								 
								 
								 
#define SQRT(y, x)                                               \
  if ((x) < 0.0) {                                               \
     out_err(MAT, ERR_FILE, ERR_LINE,                            \
     	_("Square root with negative argument!",				\
	     "Wurzel mit negativem Argument!") );                  \
     return;                                                     \
  }                                                              \
  else {							 \
     y = sqrt(x);						 \
  }

#define RSQRT(y, x)                                               \
  if ((x) < 0.0) {                                               \
     out_err(MAT, ERR_FILE, ERR_LINE,                            \
     	_("Square root with negative argument!",				\
	     "Wurzel mit negativem Argument!") );                  \
     return REAL_MIN;                                                     \
  }                                                              \
  else {							 \
     y = sqrt(x);						 \
  }
                              

#define REAL_EPSILON DBL_EPSILON
#define REAL_MAX     DBL_MAX 
#define REAL_MIN    (-DBL_MAX)

typedef short int BOOLEAN;
typedef double REAL;
typedef REAL* PREAL;

typedef struct {
  REAL val, rank;
  int ind;
} SORTREC;


extern int errno;
extern void mywait();
extern BOOLEAN myexist(char *name);
#ifdef STATIST_X
extern void out_start(); /* start results output  */
extern void out_end();   /* end results output    */
#else
#	define out_start() 
#	define out_end()  
#endif
extern void out_d(char *fmt, ...);
extern void out_r(char *fmt, ...);
extern void out_err(int errno, char *modul, int lno, char *fmt, ...);
extern void print_histo(REAL x[], int y[], int n);
extern void finish();

extern PREAL   xx[MCOL], *yy, tempcol;
extern int     nn[MCOL], acol[MCOL], *ny;
extern BOOLEAN x_read[MCOL], empty, gnupl_open;
extern int     ncol, status;
extern char    line[MLINE];
extern char    *alias[MCOL];
extern FILE    *logfile;
extern BOOLEAN silent, noplot, help, log_set, nofile, nobell, thist, bernhard,
		delrow;


extern FILE   *pipef;









