/*	
	SDLMain.m

	The Cocoa launch pad for an SDL application.
	
	Licensed under the GNU General Public License
*/

#import "SDLMain.h"
#import "AutoCL.h"
#import <Carbon/Carbon.h>
#import <unistd.h>
#import <sys/stat.h>

extern int		gArgc;
extern char		**gArgv;
extern BOOL		gFinderLaunch;

@implementation SDLMain

- (id)init
{
	char prefPath[1024];

	// Call the super
	if (![super init])
		return NULL;
	
	// Move to the correct directory - Stratagus will fail otherwise
	chdir([[[[NSBundle mainBundle] bundlePath] stringByAppendingString:@"/../"] cString]);

	// Fill out the path to the Stratagus library
	StratagusLibPath = malloc(1024);
	strcpy(StratagusLibPath, [[[[[NSBundle mainBundle] bundlePath] lastPathComponent] stringByAppendingString:@"/Contents/Resources/data"] cString]);
	
	// Create the Preferences folder (in case it doesn't exist)
    sprintf(prefPath, "%s/Library", [NSHomeDirectory() cString]);
    if (access(prefPath, 0777)) 
        mkdir(prefPath, 0777);
    sprintf(prefPath, "%s/Library/Preferences", [NSHomeDirectory() cString]);
    if (access(prefPath, 0777))
        mkdir(prefPath, 0777);
	
	// Specify ourselves as the NSApp delegate - accept calls to applicationXXX methods
	[NSApp setDelegate:self];
	
	return self;
}

- (void)applicationDidFinishLaunching:(NSNotification *)notification
{
    int status;
	unsigned int testMod = GetCurrentKeyModifiers();
	
	// Work out the command line we should use
	if ( (unsigned int)(testMod & optionKey) != 0)
		[autoCL editCL:NULL];
	if (gFinderLaunch) {
		[autoCL updateArguments];
	}
	
    // Hand off to main application code
	status = SDL_main (gArgc, gArgv);

    // Now exit with given status (don't use terminate as it will attempt to quit the SDL application again)
    exit(status);
}

- (NSApplicationTerminateReply)applicationShouldTerminate:(NSApplication *)sender
{
	SDL_Event event;
	
	// Get the SDL application to act as if quitting
    event.type = SDL_QUIT;
    SDL_PushEvent(&event);
	
	return NSTerminateCancel;
}

@end
