#import "WarController.h"

id warController;

extern int wartool(int argc, char **argv);

extern NSString *customPath;

@implementation WarController

- (void)awakeFromNib
{
	// Set indicator size
	[indicator setDoubleValue:0];
	value = 0;
	
	// Center the window
	[window center];
	
	// Set ourselves as NSApp's delgate
	[NSApp setDelegate:self];
	
	// Focus window and application
	running = NO;
	[NSApp activateIgnoringOtherApps:YES];
	[window makeKeyAndOrderFront:self];
}

- (void)applicationDidBecomeActive:(NSNotification *)aNotification
{
	BOOL expansion = NO, mac = NO, valid = NO;
	NSFileManager *fileManager = [NSFileManager defaultManager];
	NSString *dataPath = NULL;
	
	// Set the running boolean correctly
	if (running)
		return;
	else
		running = YES;
	
	// Test for a Mac WarCraft II CD
	if ([fileManager fileExistsAtPath:@"/Volumes/WarCraft II CD/Data"]) {
		dataPath = @"/Volumes/WarCraft II CD/Data";
		mac = YES; expansion = NO; valid = YES;
	}
	
	// Test for a Mac WarCraft II Expansion CD
	if ([fileManager fileExistsAtPath:@"/Volumes/WarCraft IIx CD/Data"]) {
		dataPath = @"/Volumes/WarCraft IIx CD/Data";
		mac = YES; expansion = YES; valid = YES;
	}
	
	// Test for a PC WarCraft II CD
	if ([fileManager fileExistsAtPath:@"/Volumes/WARCRAFT2/data"]) {
		dataPath = @"/Volumes/WARCRAFT2/data";
		mac = NO; expansion = NO; valid = YES;
	}
	
	// Test for a PC WarCraft II Expansion CD
	if ([fileManager fileExistsAtPath:@"/Volumes/WARCRAFT2_X/data"]) {
		dataPath = @"/Volumes/WARCRAFT2_X/data";
		mac = NO; expansion = NO; valid = YES;
	}
	
	// Make a reference to ourselves globally available
	warController = self;
	
	// Check that we have found a valid source
	if (!valid) {
		
		// Show the location utility panel (as a sheet)
		[NSApp beginSheet:panel modalForWindow:window modalDelegate:NULL didEndSelector:NULL contextInfo:NULL];
	
	}
	else {
		
		// Run the tool
		[self expandFrom:dataPath expansion:expansion mac:mac];

		// Our work here is done
		[NSApp terminate:self];

	}
}

- (void)expandFrom:(NSString *)dataPath expansion:(BOOL)expansion mac:(BOOL)mac
{
	NSString *destDataPath = NULL, *resourcesPath = [[NSBundle mainBundle] resourcePath];
	NSFileManager *fileManager = [NSFileManager defaultManager];
	NSMutableArray *arguments;
	NSArray *tempArray;
	char *charArguments[5];
	int i;

	// Determine our destination path
	if (customPath != NULL) {
		if ([fileManager fileExistsAtPath:customPath]) {
			destDataPath = customPath;
		}
		else {
			[customPath autorelease];
			destDataPath = [[[NSBundle mainBundle] bundlePath] stringByAppendingString:@"/../../../../data"];
			destDataPath = [destDataPath stringByStandardizingPath];
			[destDataPath retain];
		}
	}
	else {
		destDataPath = [[[NSBundle mainBundle] bundlePath] stringByAppendingString:@"/../../../../data"];
		destDataPath = [destDataPath stringByStandardizingPath];
		[destDataPath retain];
	}
	
	// Complain if we can't find the destination
	if (![fileManager fileExistsAtPath:destDataPath]) {
		NSRunAlertPanel(@"Cannot Find Expected \"data\" Folder", @"The \"data\" folder expected by the WarTool could not be found. As such this tool cannot be used.", @"Ok", NULL, NULL);
		[NSApp terminate:self];
	}
	
	// Set up arguments
	arguments = [NSMutableArray arrayWithCapacity:6];
	[arguments addObject:@"dummy"];
	
	// Add Mac or PC data type specifier
	if (mac)
		[arguments addObject:@"-m"];
	
	// Add expansion or standard type specifier
	if (expansion)
		[arguments addObject:@"-e"];
	else
		[arguments addObject:@"-n"];
		
	// Add the source directory and destination directory to the arguments
	[arguments addObject:dataPath];
	[arguments addObject:destDataPath];
	
	// Now for running it all through the wartool code
	for (i = 0; i < [arguments count]; i++) {
		charArguments[i] = malloc([(NSString *)[arguments objectAtIndex:i] length] + 1000);
		strcpy(charArguments[i], [[arguments objectAtIndex:i] cString]);
	}
	wartool([arguments count], charArguments);
	for (i = 0; i < [arguments count]; i++) {
		free(charArguments[i]);
	}
	
	// Copy across all required files
	[fileManager copyPath:[resourcesPath stringByAppendingString:@"/cross.png"] toPath:[destDataPath stringByAppendingString:@"/graphics/ui/cursors/cross.png"] handler:NULL];
	[fileManager copyPath:[resourcesPath stringByAppendingString:@"/red_cross.png"] toPath:[destDataPath stringByAppendingString:@"/graphics/missiles/red_cross.png"] handler:NULL];
	[fileManager copyPath:[resourcesPath stringByAppendingString:@"/mana.png"] toPath:[destDataPath stringByAppendingString:@"/graphics/ui/mana.png"] handler:NULL];
	[fileManager copyPath:[resourcesPath stringByAppendingString:@"/mana2.png"] toPath:[destDataPath stringByAppendingString:@"/graphics/ui/mana2.png"] handler:NULL];
	[fileManager copyPath:[resourcesPath stringByAppendingString:@"/health.png"] toPath:[destDataPath stringByAppendingString:@"/graphics/ui/health.png"] handler:NULL];
	[fileManager copyPath:[resourcesPath stringByAppendingString:@"/health2.png"] toPath:[destDataPath stringByAppendingString:@"/graphics/ui/health2.png"] handler:NULL];
	[fileManager copyPath:[resourcesPath stringByAppendingString:@"/food.png"] toPath:[destDataPath stringByAppendingString:@"/graphics/ui/food.png"] handler:NULL];
	[fileManager copyPath:[resourcesPath stringByAppendingString:@"/score.png"] toPath:[destDataPath stringByAppendingString:@"/graphics/ui/score.png"] handler:NULL];
	[fileManager copyPath:[resourcesPath stringByAppendingString:@"/ore,stone,coal.png"] toPath:[destDataPath stringByAppendingString:@"/graphics/ui/ore,stone,coal.png"] handler:NULL];
	[fileManager copyPath:[destDataPath stringByAppendingString:@"/graphics/ui/title.png"] toPath:[destDataPath stringByAppendingString:@"/graphics/ui/freecraft.png"] handler:NULL];
	tempArray = [fileManager directoryContentsAtPath:[resourcesPath stringByAppendingString:@"/multi"]];
	for (i = 0; i < [tempArray count]; i++) 
		[fileManager copyPath:[[resourcesPath stringByAppendingString:@"/multi/"] stringByAppendingString:[tempArray objectAtIndex:i]] toPath:[[destDataPath stringByAppendingString:@"/puds/multi/"] stringByAppendingString:[tempArray objectAtIndex:i]] handler:NULL];
	[fileManager createDirectoryAtPath:[destDataPath stringByAppendingString:@"/music"] attributes:nil];
	[fileManager copyPath:[destDataPath stringByAppendingString:@"/puds/multi/(4)criss_cross2.pud.gz"] toPath:[destDataPath stringByAppendingString:@"/puds/default.pud.gz"] handler:NULL];
	[fileManager copyPath:[resourcesPath stringByAppendingString:@"/toccata.mod.gz"] toPath:[destDataPath stringByAppendingString:@"/music/default.mod.gz"] handler:NULL];

	// We're finished with the destination path
	[destDataPath autorelease];
}

- (IBAction)failLocation:(id)sender
{
	// Close the sheet
	[NSApp stopModal];
	[NSApp endSheet:panel];
	[panel orderOut:self];
	
	// Close the utility
	[NSApp terminate:self];
}

- (IBAction)tryLocation:(id)sender
{
	NSFileManager *fileManager = [NSFileManager defaultManager];
	NSString *dataPath;
	
	// Find the appropriate data path
	dataPath = [NSString stringWithFormat:@"/Volumes/%@/data", [input stringValue]];
	if (![fileManager fileExistsAtPath:dataPath]) {
		NSBeep();
		return;
	}
	
	// Close the sheet
	[NSApp stopModal];
	[NSApp endSheet:panel];
	[panel orderOut:self];	

	// Then run the utility
	[self expandFrom:dataPath expansion:[expansionCheck state] mac:[macCheck state]];
	
	// Close the utility
	[NSApp terminate:self];

}

- (void)setMaxProgress:(int)max
{
	[indicator setMaxValue:(double)max];
}

- (void)progress
{
	value++;
	[indicator setDoubleValue:(double)value];
	[indicator displayIfNeeded];
}

@end
