AC_DEFUN(DC_DO_TYPE, [
	if test -z "$ac_cv_sizeof_long"; then
		AC_C_INLINE
		AC_CHECK_SIZEOF(long long, 8)
		AC_CHECK_SIZEOF(long, 4)
		AC_CHECK_SIZEOF(int, 4)
		AC_CHECK_SIZEOF(short, 2)
	fi
	FOUND=0
	for dc_cv_loop in \$ac_cv_sizeof_long_long \$ac_cv_sizeof_int \$ac_cv_sizeof_long \$ac_cv_sizeof_short; do
		dc_cv_size=`eval echo $dc_cv_loop`
		dc_cv_name=`echo $dc_cv_loop | sed s/\\\$ac_cv_sizeof_//`
		if test "$dc_cv_size" = "$3"; then
			if test "$dc_cv_name" = "int"; then 
				AC_CHECK_TYPE($1, $2 int)
			fi
			if test "$dc_cv_name" = "long"; then
				AC_CHECK_TYPE($1, $2 long)
			fi
			if test "$dc_cv_name" = "long_long"; then
				AC_CHECK_TYPE($1, $2 long long)
			fi
			if test "$dc_cv_name" = "short"; then
				AC_CHECK_TYPE($1, $2 short)
			fi
			FOUND=1
			break
		fi
	done
])


AC_DEFUN(DC_ASK_OPTLIB, [
  AC_ARG_WITH($5, [  --with-$5 $4], [
# Specified
    LIBSPEC=$withval
  ], [
# Not specified
    LIBSPECFLAGS=`pkg-config --libs $5 2>/dev/null`
    LIBSPECCFLAGS=`pkg-config --cflags $5 2>/dev/null`
    AC_CHECK_LIB($1, $2, [
      OLDCPPFLAGS="$CPPFLAGS"
      OLDCFLAGS="$CFLAGS"
      CPPFLAGS="$CPPFLAGS $LIBSPECCFLAGS"
      CFLAGS="$CFLAGS $LIBSPECCFLAGS"
      AC_CHECK_HEADER($3, [
        LIBSPEC=yes
      ], [
        LIBSPEC=no
      ])
      CPPFLAGS="$OLDCPPFLAGS"
      CFLAGS="$OLDCFLAGS"
    ], [
      LIBSPEC=no
      AC_MSG_WARN(Didn't find $5)
    ], $LIBSPECFLAGS)
  ])
  case $LIBSPEC in
  	no)
  		AC_MSG_WARN(Support for $5 disabled)
  		;;
  	*)
  		if test "${LIBSPEC}" = "yes"; then
			true
		else
			LIBSPECFLAGS="-L${LIBSPEC}/lib ${LIBSPECFLAGS}"
			LIBSPECCFLAGS="-I${LIBSPEC}/include ${LIBSPECCFLAGS}"
  		fi
		AC_CHECK_LIB($1, $2, [
		  OLDCFLAGS="$CFLAGS"
		  OLDCPPFLAGS="$CPPFLAGS"
		  CPPFLAGS="$CPPFLAGS ${LIBSPECCFLAGS}"
		  CFLAGS="$CFLAGS ${LIBSPECCFLAGS}"
  		  AC_CHECK_HEADER($3, [
		    if test -n "$7"; then
		      AC_DEFINE($7, [1], [Define to 1 if you have the <$3> header file.])
		    fi
		    if test -n "$6"; then
		      AC_DEFINE($6, [1], [Define to 1 if you have $2 from $5])
		    fi
		    LDFLAGS="$LDFLAGS $LIBSPECFLAGS"
		    LIBS="$LIBS -l$1"
		  ], [
		    CFLAGS="$OLDCFLAGS"
		    CPPFLAGS="$OLDCPPFLAGS"
		    AC_MSG_ERROR(Could not find $3)
		  ])
		], [
		  AC_MSG_ERROR(Could not find $5)
		], $LIBSPECFLAGS)
  		;;
  esac
])

AC_DEFUN(DC_CHK_SWAPON, [
	AC_CHECK_FUNC(swapon, [
		AC_DEFINE(HAVE_SWAPON, [1], [Define to 1 if you have swapon()])
		AC_MSG_CHECKING(whether swapon() takes 2 arguments)
		AC_COMPILE_IFELSE(AC_LANG_PROGRAM([[
#include <unistd.h>
]], [
swapon("/tmp", 0)
]), [
		AC_DEFINE(SWAPON_TAKES_2_ARGS, [1], [Define to 1 if swapon() takes 2 arguments instead of one])
		AC_MSG_RESULT(yes)
], [
		AC_MSG_RESULT(no)
])
	])
])

AC_DEFUN(DC_CHK_OSSPECIFIC, [
	AC_MSG_CHECKING(host operating system)
	AC_MSG_RESULT($host_os)
	case $host_os in
		linux*)
			true
			;;
		*)
			DC_ASK_OPTLIB(statgrab, sg_get_mem_stats, statgrab.h, [     Use libstatgrab to gather statistics.], libstatgrab, HAVE_LIBSTATGRAB, HAVE_STATGRAB_H)
			AC_MSG_CHECKING(requirements)
			if test ! "$ac_cv_lib_statgrab_sg_get_mem_stats" = "yes"; then
				AC_MSG_ERROR(libstatgrab (http://www.i-scream.org/libstatgrab/) is required on this platform)
			fi
			AC_MSG_RESULT(okay)
			;;
	esac
	case $host_os in
		linux*)
			AC_DEFINE(SWAPD_NEED_MKSWAP, [1], [Define to 1 if you need to call mkswap before calling swapon])
			;;
		solaris*)
			AC_DEFINE(SWAPD_SWAPON_CMDLINE, ["/usr/sbin/swap -a \"%s\""], [Define to string constant needed to swapon])
			AC_DEFINE(SWAPD_SWAPOFF_CMDLINE, ["/usr/sbin/swap -d \"%s\""], [Define to string constant needed to swapoff])
			AC_DEFINE(SWAPD_SWAP_PERMS, [01600], [Define to the permissions needed for each swapfile])
			;;
		netbsd*)
			AC_DEFINE(SWAPD_SWAPOFF_CMDLINE, ["/sbin/swapctl -d \"%s\""], [Define to string constant needed to swapoff])
			;;
	esac
])
