.\"
.\" Copyright (c) 1992-1998 Michael A. Cooper.
.\" This software may be freely distributed provided it is not sold for 
.\" profit and the author is credited appropriately.
.\"
.\" $Revision: 1.39 $
.\" 
.TH sysinfo 1 "6 March 1999"
.ds ]W MagniComp Systems
.SH NAME
sysinfo \- Display system information
.SH SYNOPSIS
sysinfo
[
.B \-cfdir
.I DirName
] 
[
.B \-cffile
.I FileName
] 
[
.B \-class
.I item1,item2,...
] 
[
\-danger
]
[
.B \-format
.I FormatType
] 
[
.B \-msgclass
.I msgclass1,msgclass2,...
]
[
.B \-msglevel
.I msglevel1,msglevel2,...
]
[
.B \-offset 
.I amount
]
[
.B \-repsep
.I string
]
[
.B \-show
.I item1,item2,...
] 
[
.B \-type
.I type1,type2,...
] 
[
.B +|\-unknown
] 
[
.B +|\-useconfig
] 
[
.B +|\-useprom
] 
.br
.sp
sysinfo 
.B \-list
[
.B class|format|msgclass|msglevel|show|type
]
.br
.sp
sysinfo 
.B \-version
.SH DESCRIPTION
.I SysInfo
displays various types of information about the local host's hardware
and
operating system (OS) software.
It is intended to provide information in both human readable and
program parsable formats.
System Administrators can use 
.I SysInfo
to obtain hardware asset information and OS configuration information.
Programs which use 
.I SysInfo 
can obtain
this information
in a platform independent manner.
.PP
The amount of information displayed varies by operating system.
Here are some of the types of information that may be provided:
.IP *
Host name
.IP *
Host name aliases
.IP *
Host network addresses
.IP *
Host ID
.IP *
System serial number
.IP *
Manufacturer of the system's hardware
.IP *
System model name
.IP *
CPU type
.IP *
Application architecture
.IP *
Kernel architecture
.IP *
Amount of main memory
.IP *
Operating system name
.IP *
Operating system version
.IP *
Kernel version
.IP *
A variety of information about devices
.IP *
A variety of different kernel parameters
.IP *
A variety of different system configuration parameters
.PP
By default,
.B sysinfo
will display a "medium" level of output suitable for a quick glance at
system configuration information.
The
.B "\-msglevel all" 
option provides the maximum amount of system information.
.PP
The scope of the information presented can by limited by classes
using the ``\fB\-class \fIName\fR''
option.
Further selection can by made specifying the class of information and
a specific item using ``\fB\-class \fIName\fR \fB\-show \fIItem\fR''
.PP
Upon startup,
.B sysinfo
searches for a configuration file to parse.
If the
\fB\-cffile\fR
option is given, the specified configuration file will be used.
Otherwise
.B SysInfo
will search for a suitable configuration file.
Searching stops when the first configuration file is found.
The following search order is used:
.br
.sp
.nf
.RS
\fB/etc/sysinfo.cf
\fIConfDir\fB/${OSname}_${OSver}.cf
\fIConfDir\fB/${OSname}_${OSmajver}.cf
\fIConfDir\fB/${OSname}.cf
\fIConfDir\fB/Default.cf
.RE
.sp
.fi
.I ConfDir
is
.B /var/local/conf/sysinfo
by default, but can be overridden with the
.B \-cfdir
option.
.PP
If the file
.I /etc/sysmodel
exists, the first line of the file is read and used as the
system model name.
.SH OPTIONS
.IP "\fB\-cfdir \fIDirName\fR"
Specify the name of the directory to use to find
.B sysinfo.cf
format configuration files.
.IP "\fB\-cffile \fIFileName\fR"
Specify the name of a 
.B sysinfo.cf
format configuration file to use.
If the specified 
.I FileName
cannot be opened for any reason, an error message is displayed and the
program will exit.
.IP "\fB\-class \fIName1,Name2,...\fR"
Limit information to a specific class or classes of information.
The default class is
.B General.
.IP "\fB\-danger\fR"
Normally
.I SysInfo
checks upon startup to make sure it's running on the same platform
(OS Name, OS Version, CPU Type, and CPU Archecture (on some platforms))
as it was built on.  This option overrides/disables this check.
Using this option usually means that the information provided may be
false or incomplete.
.IP "\fB\-format \fIFormatType\fR"
Display output in
.I FormatType
format.
Valid
.I FormatType
values are:
.RS
.IP "\fBpretty\fR"
Output is suitible for human viewing.
This is the default.
.IP "\fBreport\fR"
Output is in a format suitable for parsing by a program.
Entries are printed one per line with fields seperated by ``|''
(vertical pipe) by default.
The 
.B \-repsep
option can be used to change this value.
.B NOTE:
Output format is currently not finalized and may change in a future release.
.RE
.IP "\fB\-msgclass \fImsgclass1,msgclass2,...\fR"
Specify which class of messages should be output.
The default value for
.B \-msgclass
is
.B info,warn,cerror.
The list of possible 
.I msgclass
values are:
.RS
.IP "\fBall\fR"
All of the below classes except for 
.B debug.
.IP "\fBinfo\fR"
Display normal informational messages.
All the actual useful bits of 
information about your system are output as msgclass \fBinfo\fB.
.IP "\fBwarn\fR"
Display warning messages about any condition that occured while 
.B SysInfo
is running which may affect what information is found.
Normally these are things like 
.B SysInfo
is not running with the right permissions or certain things are missing from
the system which are not required, but may result in incomplete information.
.IP "\fBgerror\fR"
Display general error messages.
These are non-fatal errors which are usually quite normal.
For instance, a certain type of query (such as a ioctl() call) of a device
fails because it's not supported on that particuliar model.
.IP "\fBcerror\fR"
Display critical errors which prevent 
.B SysInfo
from continuing further.
.IP "\fBdebug\fR"
Print debugging information.
Lots of information you normally don't want to see, but which is very 
valuable for debugging problems with
.B SysInfo.
.RE
.IP "\fB\-msglevel \fImsglevel1,msglevel2,...\fR"
Set the level of messages that are shown.
.I msglevels
is a comma separated list of values used to determine what
levels of message will be displayed.
The list of possible 
.I msglevel
values are:
.RS
.IP "\fBall\fR"
All possible levels of information.
This option provides the maximum amount of detailed information about a 
system.
.IP "\fBterse\fR"
Display output in terse format.
The affect of this option is dependent on the 
.I Class
of information being displayed.
It usually results in the labels for each output value being suppressed.
This is useful if you are running 
.B SysInfo
from a script
to obtain a few specific values (e.g. System Model, CPU Architecture, etc).
.IP "\fBbrief\fR"
More than 
.B terse
but less than 
.B all.
.IP "\fBgeneral\fR"
General level of information useful for a quick look at overall system 
configuration.
This is the default.
.IP "\fBdescriptions\fR"
Like
.B general
but with more descriptive information.
.IP "\fBconfig\fR"
Similiar to 
.B general
and
.B descriptions
.RE
.IP "\fB\-list [ class|format|msgclass|msglevel|show|type ]\fR"
List the possible values that may be used with an option.
With no arguments are specified, a list is valid arguments is
displayed.
When an argument is supplied, the information specific to that
argument
is displayed.
.IP "\fB\-offset \fIamount\fR"
Set the number of spaces to offset (indent) when printing
device information.
.IP "\fB\-repsep \fIstring\fR"
Change the field seperator string used with 
.B "\-format report"
to be
.I string.
The default is ``|''
(vertical pipe).
.IP "\fB\-show \fIitem1,item2,...\fR"
Show information only about each comma separated item.
Run
.B "sysinfo \-list show"
for a list of valid item arguments.
If the
.B \-class
option is not specified, then the 
.B General
class is assumed.
.IP "\fB\-type \fIitem1,item2,...\fR"
Limit information to a specific type of item as specified by
.I item1,item2,...
Run 
.B "sysinfo \-list type"
for a list of valid item arguments.
.IP "\fB+|-unknown\fP"
Enable (\fB+unknown\fP) or disable (\fB\-unknown\fP) showing devices
that appear to be present on the system, but are not "known" to sysinfo.
This option is disabled by default.
.IP "\fB+|-useconfig\fP"
Enable (\fB+useconfig\fP) or disable (\fB\-useconfig\fP) use of
configuration files.  This option is useful if you want to run
.I sysinfo
without having the configuration files installed.
Note that only certain types of information - such as some of the
.B General
values - will be available without use of configuration files.
The default is
\fB+useconfig\fP.
.IP "\fB+|-useprom\fP"
Enable (\fB+useprom\fP) or disable (\fB\-useprom\fP) using values
obtained from the system PROM instead of intepreting values obtained
directly from the kernel.
Certain values are normally obtained by looking up a variable in
the kernel and checking the result against a table of values compiled
into 
.B sysinfo.
By enabling this option, 
.B sysinfo
will attempt to obtain certain values from the system PROM.
This support is currently limited to the
.B "System Model"
value.
Support is also limited to those machines which support such
a system PROM.
.IP "\fB-version\fP"
Show version
information for
.I sysinfo.
.SH EXAMPLES
The following command displays the maximum amount of information about 
a system:
.RS
.nf
.B sysinfo -msglevel all
.fi
.RE
.PP
A very useful command to use when \fBDEBUGGING\fR 
.I SysInfo
is:
.RS
.nf
.B sysinfo -msglevel all -msgclass all,debug
.fi
.RE
.PP
The following example outputs just the System Model:
.RS
.nf
.B sysinfo -msglevel terse -show model
.fi
.RE
.PP
This command will limit the output to just information about
.B Kernel
variables:
.RS
.nf
.B sysinfo -class kernel
.fi
.RE
.SH AUTHOR
Michael A. Cooper
.br
MagniComp
.br
mcooper@magnicomp.com
.SH "HOME PAGE"
.B http://www.magnicomp.com/sysinfo/
.SH FILES
/var/local/conf/sysinfo	\- Directory of config files
.br
/etc/sysinfo.cf \- Master configuration file
.br
/etc/sysmodel	\- Explicitly set the CPU model name
.SH SEE ALSO
gethostid(2), gethostname(2), gethostbyname(3)
.SH DIAGNOSTICS
.IP "\fI%x: Unknown CPU type.\fP"
The CPU model for the current host could not be determined.
.IP "(unknown)"
Information could not be determined for this item.
.SH BUGS
.PP
Not all operating systems support interfaces to various pieces of
information that sysinfo supports.
.PP
Some devices, mostly devices that use 
removable media such as
tape drives and floppy disks, are only indicated (shown) as
present if media is loaded in the device and it's on-line.
This occurs because the OS does not provide a software
interface to query the device when media is not loaded.
.PP
.B SunOS 
allows only one process at a time to have
.B /dev/openprom
open.
This may result in certain pieces of information 
not always showing up consistantly.  When in doubt,
enable debugging
(\fB\-msgclass debug\fP).
.PP
Under 
.B "SunOS 5.4"
the
.B "ROM Version"
field is blank.
This is due to a change made by Sun in 
.I libkvm.
Sun patch 
.B 102555-01
is suppose to fix this problem.
.B Sysinfo 
uses a new OBP interface in
.B "SunOS 5.5"
that by-passes this problem.
.PP
Under 
.B "SunOS 4.x"
the
.B "Serial Number"
field
is left blank since the kernel usually returns incorrect information.
.PP
Under
.B "SunOS 5.x"
the
.B "Serial Number"
field
will show the serial number as obtained from the system's
.B IDPROM.
This serial number has no correspondence with the system serial
number that appears on the back of your machine.
.PP
Under
.B SunOS
there is no way to tell the difference between an MC68020 (like the
3/60) and MC68030 (like the 3/80)
based machine.
