/* Copyright (c) 1998 Joe Rumsey (mrogre@mediaone.net) */
#include "copyright.h"

#include <stdio.h>
#include "Wlib.h"
#include "struct.h"
#include "data.h"

#define BOXWIDTH 75

static void dash_box(int x, int y, int w, int h, W_Color color)
{
    W_MakeLine(dashwin, x,   y,   x+w, y,   color);
    W_MakeLine(dashwin, x+w, y,   x+w, y+h, color);
    W_MakeLine(dashwin, x+w, y+h, x,   y+h, color);
    W_MakeLine(dashwin, x,   y+h, x,   y,   color);
}

static void dash_bar(int x, int y, char *str, int val, int maxval, int curmax, int full_is_good)
{
    char buf[20];
    int fillwidth;
    int box_x, box_y, cm_x;
    W_Color color;

    x*=(W_Textwidth*15)+BOXWIDTH;
    y*=(W_Textheight+2);
    
    if(full_is_good) {
	if(val > 2*(maxval/3))
	    color = W_Green;
	else if(val > maxval/3)
	    color = W_Yellow;
	else
	    color = W_Red;
    } else {
	if(val < maxval/3)
	    color = W_Green;
	else if(val < 2*(maxval/3))
	    color = W_Yellow;
	else
	    color = W_Red;
    }

    sprintf(buf, "%s [%3d/%3d]", str, val, maxval);
    W_WriteText(dashwin, x, y, W_White, buf, strlen(buf), W_RegularFont);
    box_x = x+strlen(buf)*W_Textwidth;
    box_y = y;
    dash_box(box_x, box_y, BOXWIDTH, W_Textheight, W_White);
    fillwidth = (val * BOXWIDTH)/maxval;
    W_FillArea(dashwin, box_x+1, box_y+1, fillwidth, W_Textheight-1, color);
    if(val < maxval)
	W_ClearArea(dashwin, box_x+1+fillwidth, box_y+1, BOXWIDTH-fillwidth-1, W_Textheight-1);
    if(curmax != maxval) {
	cm_x = box_x + (curmax*BOXWIDTH)/maxval;
	W_FillArea(dashwin, cm_x, box_y+1, BOXWIDTH - (curmax*BOXWIDTH)/maxval, W_Textheight-1, W_Grey);
    }
}


void do_dash(int re)
{
    static int olddamage=-1, oldspeed=-1, oldfuel = -1, oldammo = -1, oldmines = -1, oldtrees = -1;
    int cm;

    if(re || me->p_speed != oldspeed || me->p_damage != olddamage) {
	cm = (((MAXDAMAGE - me->p_damage)*9)/MAXDAMAGE)+1;
	if(cm>9) cm=9;
	dash_bar(0,1, " Spd", me->p_speed, 9, cm, 0);
	oldspeed = me->p_speed;
    }

    if(re || me->p_damage != olddamage) {
	dash_bar(0,0, "Damg", me->p_damage, MAXDAMAGE, MAXDAMAGE, 0);
	olddamage = me->p_damage;
    }

    if(re || me->p_fuel != oldfuel) {
	dash_bar(0,2, "Fuel", (me->p_fuel*100)/MAXFUEL, 100, 100, 1);
	oldfuel = me->p_fuel;
    }

    if(re || me->p_ammo != oldammo) {
	dash_bar(1,0, "Ammo", me->p_ammo, MAXAMMO, MAXAMMO, 1);
	oldammo = me->p_ammo;
    }

    if(re || me->p_mines != oldmines) {
	dash_bar(1,1, "Mine", me->p_mines, MINESPERPLAYER, MINESPERPLAYER, 1);
	oldmines = me->p_mines;
    }
    if(re || (me->p_trees != oldtrees)) {
	dash_bar(1,2, "Tree", me->p_trees, MAXTREES, MAXTREES, 1);
	oldtrees = me->p_trees;
    }
}

