/*
 * Copyright (C) 2000 WIDE Project.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the project nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
/*
 $Id: binread.c,v 1.1.1.1 2000/04/20 05:47:19 nishida Exp $
 */
#include "tcpillust.h"
#include <sys/socket.h>
#include <pcap.h>
#include <net/if_arp.h>
#include <net/slip.h>
#include <netinet/in.h>
#include <netinet/in_systm.h>
#include <netinet/if_ether.h>
#include <netinet/ip.h>
#include <netinet/tcp.h>

#define PPP_HDRLEN 4
#define NULL_HDRLEN 4
#define ATM_HDRLEN 8

static void dumper __P((u_char *, const struct pcap_pkthdr *, const u_char *));
static void dumpip __P((u_char *, const struct timeval *));
static void init_param __P((void));
static int pcap_dlt;
static int pcap_snap;
static int	*tmpcount;
static struct tcppkt	**ptmppkt, *tmppkt;
static long adr1;
static long seq1;
static long seq2;
static long base;
static u_char *pktbuffer;

void	
read_binfile(filename, pktindex)
	char	*filename;
	int		pktindex;	
{
	char errbuf[PCAP_ERRBUF_SIZE];
	pcap_t *pc;
	int	count = -1;

	init_param();
	ptmppkt = &pkt[pktindex];
	tmpcount = &pktcount[pktindex];

	if (!(pc = pcap_open_offline(filename, errbuf))){
		perror("pcap_open");
		exit(-1);
	}
	pcap_dlt = pcap_datalink(pc);
	pcap_snap = pcap_snapshot(pc);

	if ((pktbuffer = (u_char *)malloc(pcap_snap +4)) == NULL){
		perror("malloc");
		exit(-1);
	}

	if (pcap_loop(pc, count, dumper, (u_char *)NULL) < 0) {
		perror("pcap_loop");
		exit(-2);
	}
	pcap_close(pc);
	capendtime = tmppkt[*tmpcount -1].captime - tmppkt[0].captime; 
}

static void
init_param()
{
	base = 0;
	adr1 = 0; 
	seq1 = 0;
	seq2 = 0;
}

static void
dumper(u_char *user, const struct pcap_pkthdr *inh, const u_char *inp)
{
	u_char *p;
	int caplen = inh->caplen;

	if (caplen > pcap_snap) { 
		fprintf(stderr, "packet too large %s:%d\n", __FILE__, __LINE__);
		exit(-1);
	}

	memcpy(pktbuffer, inp, caplen);
	p = pktbuffer;

	switch (pcap_dlt) {
		case DLT_EN10MB:
			if (caplen < (sizeof (struct ether_header))) 
				return;
			p += sizeof(struct ether_header);
			dumpip(p, &inh->ts);
		break;

		case DLT_SLIP:
			if (caplen < SLIP_HDRLEN)
				return;
			p += SLIP_HDRLEN;
			dumpip(p, &inh->ts);
		break;

		case DLT_PPP:
			if (caplen < PPP_HDRLEN) 
				return;
			p += PPP_HDRLEN;
			dumpip(p, &inh->ts);
		break;

		case DLT_NULL:
			if (caplen < NULL_HDRLEN) 
				return;
			p += NULL_HDRLEN;
			dumpip(p, &inh->ts);
		break;

		case DLT_ATM_RFC1483:
			if (caplen < ATM_HDRLEN) 
				return;
			p += ATM_HDRLEN;
			dumpip(p, &inh->ts);
		break;

		default:
			fprintf(stderr, "Unknown DLT %x\n", pcap_dlt);
			exit(-1);
		break;
	}
}

static void
dumpip(u_char *p, const struct timeval *tvp)
{
	struct ip *ip;
	struct tcphdr *tcp; 
	int len, optlen;
	long datalen;

	ip = (struct ip *)p;
	if (ip->ip_p != IPPROTO_TCP){
		printf("not tcp\n");
		return;
	}
		
	/* skip ip header */
	p+= ip->ip_hl * 4;	
	tcp = (struct tcphdr *)p;

	len = (tcp->th_off) *4 - sizeof(struct tcphdr);

	if (!*tmpcount){
		*ptmppkt = (struct tcppkt *)malloc(sizeof(struct tcppkt));
		if (*ptmppkt == NULL){
			perror("malloc");
			exit(-1);	
		}
		*(tmpcount) += 1;
	} else {
		*(tmpcount) += 1;
		*ptmppkt = (struct tcppkt *)realloc(*ptmppkt, 
								sizeof(struct tcppkt) * *tmpcount);
		if (*ptmppkt == NULL){
			perror("realloc");
			exit(-1);	
		}
	}

	datalen = ntohs(ip->ip_len) - ip->ip_hl * 4 - tcp->th_off *4;
	if (!base) base = tvp->tv_sec;
	if (!adr1) adr1 = ntohl(ip->ip_src.s_addr);
	if (adr1 == ntohl(ip->ip_src.s_addr) && !seq1) seq1 = ntohl(tcp->th_seq);
	if (adr1 != ntohl(ip->ip_src.s_addr) && !seq2) seq2 = ntohl(tcp->th_seq);

	tmppkt = *ptmppkt;
	memset(&tmppkt[*tmpcount -1], 0, sizeof(struct tcppkt));
	tmppkt[*tmpcount -1].captime = 
			(tvp->tv_sec - base) + (float)tvp->tv_usec/1000000.0;
	tmppkt[*tmpcount -1].src_addr = ntohl(ip->ip_src.s_addr);
	tmppkt[*tmpcount -1].dst_addr = ntohl(ip->ip_dst.s_addr);
	tmppkt[*tmpcount -1].id = ntohs(ip->ip_id);

	if (adr1 == ntohl(ip->ip_src.s_addr)) {
		tmppkt[*tmpcount -1].seq = ntohl(tcp->th_seq) - seq1;
		if (ntohl(tcp->th_ack))
			tmppkt[*tmpcount -1].ack = ntohl(tcp->th_ack) - seq2;
	} else {
		tmppkt[*tmpcount -1].seq = ntohl(tcp->th_seq) - seq2;
		if (ntohl(tcp->th_ack))
			tmppkt[*tmpcount -1].ack = ntohl(tcp->th_ack) - seq1;
	}

	tmppkt[*tmpcount -1].src_port = ntohs(tcp->th_sport);
	tmppkt[*tmpcount -1].dst_port = ntohs(tcp->th_dport);
	tmppkt[*tmpcount -1].win = ntohs(tcp->th_flags);
	tmppkt[*tmpcount -1].flags = tcp->th_flags;
	tmppkt[*tmpcount -1].datalen = datalen;

	p += sizeof(struct tcphdr);

#if 0
	while(len > 0){
		if (*p == 0 || *p == 1){
			len --;
			p ++;
			continue;
		}
		if (*p == TCPOPT_TIMESTAMP){
			len -= 10;
			p+= 10;
			continue;
		}
		p ++;
		optlen = *p -1;
		p += optlen;
		len -= optlen; 
	}
#endif
}
