/*
 * tablemm.h - -mm macros table and other explicit troff command strings
 *		Release 1.0a	August 1988
 *		Release 2.0	January 1990
 *
 * Copyright 1988, 1989, 1990  Beverly A.Erlebacher
 * erlebach@cs.toronto.edu    ...uunet!utai!erlebach
 *
 */

/*
 * miscellaneous commands, described in texi2roff.h
 */
struct misccmds mmcmds = { 
".nr _- 0\n.PH '''\n.SA 1\n.nr Cl 5\n.ds HP 14 14 14 14 14 14 14\n\
.ds HF 3 3 3 3 3 3 3\n.nr Hb 7\n.nr Hs 7\n.nr Pt 1", "\n.P 1\n",
				"\n.P 1\n.ti -\\n(Pin\n", "", "" };

struct tablerecd mmtable[] = {
    "@*",		"",	"\n.br\n",	"",	"",	ESCAPED,
    "@.",		"",	"\\&.",		"",	"",	ESCAPED,
    "@:",		"",	"",		"",	"",	ESCAPED,
    "@@",		"",	"@",		"",	"",	ESCAPED,
    "@Arrow",		"\n",	"\\(rh",	"\n",	"",	CHAR,
    "@TeX{",		"}",	"TeX",		"",	"",	INPARA,
    "@appendix",	"\n",
	"\n.if !\\n(_- \\{\\\n.nr _- 1\n.nr H1 0 1\n.af H1 A\\}\n.bp\n.H 1 ",
					"\n.sp .5\n",	"\\fB",	HEADING,
    "@appendixsec",	"\n",	"\n.sp .5\n.H 2 ",
					"\n.sp .5\n",	"\\fB",	HEADING,
    "@appendixsection",	"\n",	"\n.sp .5\n.H 2 ",
					"\n.sp .5\n",	"\\fB",	HEADING,
    "@appendixsubsec",	"\n",	"\n.sp .5\n.H 3 ",
					"\n.sp .5\n",	"\\fB",	HEADING,
    "@appendixsubsubsec","\n",	"\n.sp .5\n.H 4 ",
					"\n.sp .5\n",	"\\fB",	HEADING,
    "@arrow",		"\n",	"\\(->",	"\n",	"",	CHAR,
    "@asis",		"\n",	"",		"\n",	"",	PARAGRAPH,
    "@asis{",		"}",	"",		"",	"",	INPARA,
    "@author",		"\n",	"\n.ce\n",	"\n",	"",	HEADING,
    "@br",		"\n",	"\n.br\n.sp\n", "",	"",	PARAGRAPH,
    "@bullet{",		"}",	"\\(bu",	"",	"",	CHAR,
    "@bye",		"\n",	"",		"\n",	"",	DISCARD, 
    "@b{",		"}",	"\\fB",		"",	"\\fB",	INPARA,
    "@c",		"\n",	"",		"\n",	"",	DISCARD,
    "@center",		"\n",	"\n.ce\n",	"\n",	"",	HEADING,
    "@center{",		"}",	"\n.ce\n",	"",	"",	HEADING,
    "@chapter",		"\n",	"\n.bp\n.H 1 ",
					"\n.sp .5\n",	"\\fB",	HEADING,
    "@cindex",		"\n",	"\n.iX \"c ",	"\"\n",	"",	INDEX,
    "@cite{",		"}",	"\\fI",		"",	"\\fI",	INPARA,
    "@code{",		"}",	"\\fR\\&\\f(CW","","\\fR\\&\\f(CW",INPARA,
    "@comment",		"\n",	"",		"\n",	"",	DISCARD,
    "@contents",	"\n",	"\n.TC 1 1 5 0\n", "",	"",	INPARA,
    "@copyright{",	"}",	"\\(co",	"",	"",	CHAR,
    "@ctrl{",		"}",	"\\fR\\&\\f(CW^","","\\fR\\&\\f(CW",INPARA,
    "@dag",		"}{",	"\\(dg",	"",	"",	CHAR,
    "@dag{",		"}",	"\\(dg",	"",	"",	CHAR,
    "@ddag",		"}{",	"\\(dd",	"",	"",	CHAR,
    "@ddag{",		"}",	"\\(dd",	"",	"",	CHAR,
    "@defcmd",		"@end", "\n.P 1\n.ti -\\n(Pin\n*\\ Command: ",
						"",	"",	HEADING,
    "@defcmdx",		"\n", 	"\n.P 1\n.ti -\\n(Pin\n*\\ Command: ",
						"\n.br\n","",	HEADING,
    "@defconst",	"@end", "\n.P 1\n.ti -\\n(Pin\n*\\ Constant: ",
						"",	"",	HEADING,
    "@defconstx",	"\n", 	"\n.P 1\n.ti -\\n(Pin\n*\\ Constant: ",
						"\n.br\n","",	HEADING,
    "@deffn",		"@end", "\n.P 1\n.ti -\\n(Pin\n*\\ ",	
						"",	"",	HEADING,
    "@deffnx",		"\n", 	"\n.P 1\n.ti -\\n(Pin\n*\\ ",	
						"\n.br\n","",	HEADING,
    "@defmac",		"@end", "\n.P 1\n.ti -\\n(Pin\n*\\ Macro: ",
						"",	"",	HEADING,
    "@defmacx",		"\n", 	"\n.P 1\n.ti -\\n(Pin\n*\\ Macro: ",
						"\n.br\n","",	HEADING,
    "@defmethod",	"@end", "\n.P 1\n.ti -\\n(Pin\n*\\ Operation on ",
						"",	"",	HEADING,
    "@defmethodx",	"\n", 	"\n.P 1\n.ti -\\n(Pin\n*\\ Operation on ",
						"\n.br\n", "",	HEADING,
    "@defopt",		"@end", "\n.P 1\n.ti -\\n(Pin\n*\\ User Option: ",
						"",	"",	HEADING,
    "@defoptx",		"\n", 	"\n.P 1\n.ti -\\n(Pin\n*\\ User Option: ",
						"\n.br\n", "",	HEADING,
    "@defspec",		"@end", "\n.P 1\n.ti -\\n(Pin\n*\\ Special Form: ",
						"",	"",	HEADING,
    "@defspecx",	"\n", 	"\n.P 1\n.ti -\\n(Pin\n*\\ Special Form: ",
						"\n.br\n", "",	HEADING,
    "@defun",		"@end", "\n.P 1\n.ti -\\n(Pin\n*\\ Function: ",
						"",	"",	HEADING,
    "@defunx",		"\n", 	"\n.P 1\n.ti -\\n(Pin\n*\\ Function: ",
						"\n.br\n","",	HEADING,
    "@defvar",		"@end", "\n.P 1\n.ti -\\n(Pin\n*\\ Variable: ",
						"",	"",	HEADING,
    "@defvarx",		"\n", 	"\n.P 1\n.ti -\\n(Pin\n*\\ Variable: ",
						"\n.br\n","",	HEADING,
    "@dfn{",		"}",	"\\fI",		"",	"\\fI",	INPARA,
    "@display",		"@end", "\n.DS\n",	"\n.DE\n","",	DISPLAY,
    "@dots{",		"}",	"\\&...",	"",	"",	INPARA,
    "@eject",		"\n",	"\n.bp\n",	"",	"",	PARAGRAPH,
    "@emph{",		"}",	"\\fI",		"",	"\\fI",	INPARA,
    "@end",		"\n",	"",		"\n.sp\n.in\n", "",END,
    "@enumerate",	"@end", "\n.VL 5 0\n",	"\n.LE\n","",	ITEMIZING,
    "@equiv{",		"}",	"\\(==",	"",	"",	CHAR,
    "@error{",		"}",	"error-->",	"",	"",	CHAR,
    "@example",		"@end", "\n.DS 1\n\\fR\\&\\f(CW\n",
				"\n.DE\n", "\\fR\\&\\f(CW",	DISPLAY,
    "@example{",	"}",	"\\fR\\&\\f(CW","","\\fR\\&\\f(CW",INPARA,
    "@exdent",		"\n",	"\n.P 1\n.ti -\\n(Pin\n",	
						"\n",	"",	PARAGRAPH,
    "@expansion{",	"}",	"\\(->",	"",	"",	CHAR,
    "@file{",		"}",	"\\fR\\&\\f(CW\\(if",	"\\(is",
					"\\fR\\&\\f(CW",	INPARA,
    "@finalout",	"\n",	"",		"\n",	"",	DISCARD,
    "@findex",		"\n",	"\n.iX \"f ",	"\"\n",	"",	INDEX,
    "@footnote{",	"}",	"\n.FS \n",	"\n.FE\n","",	FOOTNOTE,
    "@group",		"@end", "\n.DS L F\n",	"\n.DE\n","",	PARAGRAPH,
    "@heading",		"\n",	"\n.sp 2\n.HU ",
					"\n.sp .5\n\n",	"\\fB",	HEADING,
    "@headings",	"\n",	"",		"\n",	"",	DISCARD,
    "@iappendix",	"\n",	"\n.bp\n.HU ",
					"\n.sp .5\n",	"\\fB",	HEADING,
    "@iappendixsec",	"\n",	"\n.sp .5\n.HU ",
					"\n.sp .5\n",	"\\fB",	HEADING,
    "@iappendixsubsec",	"\n",	"\n.sp .5\n.HU ",
					"\n.sp .5\n",	"\\fB",	HEADING,
    "@ichapter",	"\n",	"\n.bp\n.sp .5\n.HU ",
					"\n.sp .5\n",	"\\fB",	HEADING,
    "@ifinfo",		"@end", "\n", 		"\n",	"",	PARAGRAPH,
    "@iftex",		"@end", "",		"",	"",	PARAGRAPH,
    "@ignore",		"@end", "",		"",	"",	DISCARD,
    "@include",		"\n",	"",		"\n",	"",	INCLUDE,
    "@inforef{",	"}",	"See Info file ","",	"",	PARAGRAPH,
    "@isection",	"\n",	"\n.sp .5\n.HU ",
					"\n.sp .5\n",	"\\fB",	HEADING,
    "@isubsection",	"\n",	"\n.sp .5\n.HU ",
					"\n.sp .5\n",	"\\fB",	HEADING,
    "@isubsubsection",	"\n",	"\n.sp .5\n.HU ",
					"\n.sp .5\n",	"\\fB",	HEADING,
    "@item",		"\n",	"\n.LI ",	"\\ \n","",	ITEM,
    "@itemize",		"@end", "\n.VL 5 0\n",	"\n.LE\n","",	ITEMIZING,
    "@itemx",		"\n",	"\n.LI ",	"\\ \n","",	ITEM,
    "@iunnumbered",	"\n",	"\n.bp\n.HU ",
					"\n.sp .5\n",	"\\fB",	HEADING,
    "@iunnumberedsec",	"\n",	"\n.sp .5\n.HU ",
					"\n.sp .5\n",	"\\fB",	HEADING,
    "@iunnumberedsubsec","\n",	"\n.sp .5\n.HU ",
					"\n.sp .5\n",	"\\fB",	HEADING,
    "@i{",		"}",	"\\fI",		"",	"\\fI",	INPARA,
    "@kbd{",		"}",	"\\fR\\&\\f(CW","","\\fR\\&\\f(CW",INPARA,
    "@key{",		"}",	"\\fR\\&\\f(CW","","\\fR\\&\\f(CW",INPARA,
    "@kindex",		"\n",	"\n.iX \"k ",	"\"\n",	"",	INDEX,
    "@majorheading",	"\n",	"\n.sp 4\n.HU ",
					"\n.sp .5\n",	"\\fB",	HEADING,
    "@menu",		"@end", "\n.DS L\n\\s8Menu: \n",
					"\\s0\n.DE\n",	"",	DISPLAY, 
    "@minus{",		"}",	"\\-",		"",	"",	CHAR,
    "@need",		"\n",	"",		"\n",	"",	DISCARD,
    "@node",		"\n",	"\n.P 1\n.ti -\\n(Pin\n\\s8Node:",
					"\\s0\n.br\n",	"",	PARAGRAPH,
    "@noindent",	"\n",	"\n.P 1\n.ti -\\n(Pin\n","","",	PARAGRAPH,
    "@page",		"\n",	"\n.bp\n",	"",	"",	PARAGRAPH,
    "@pindex",		"\n",	"\n.iX \"p ",	"\"\n",	"",	INDEX,
    "@point{",		"}",	"*",		"",	"",	CHAR,
    "@printindex",	"\n",	"",		"\n",	"",	DISCARD,
    "@prints{",		"}",	"-|",		"",	"",	CHAR,
    "@print{",		"}",	"-|",		"",	"",	CHAR,
    "@pxref{",		"}",	"see section ",	"",	"",	PARAGRAPH,
    "@quotation",	"@end", "\n.DS I F 5\n.nh\n", "\n.DE\n","",DISPLAY,
    "@refill",		"\n",	"",		"\n",	"",	DISCARD,
    "@ref{",		"}",	"\\(if",	"\\(is","",	INPARA,
    "@result",		"\n",	"\\(rh",	"\n",	"",	CHAR,
    "@result{",		"}",	"\\(rh",	"",	"",	CHAR,
    "@r{",		"}",	"\\fR",		"",	"\\fR",	INPARA,
    "@samp{",		"}",	"\\fR\\&\\f(CW\\(if",
				"\\(is","\\fR\\&\\f(CW",	INPARA,
    "@sc{",		"}",	"\\fB",		"",	"\\fB",	INPARA,
    "@section",		"\n",	"\n.sp .5\n.H 2 ",
					"\n.sp .5\n",	"\\fB",	HEADING,
    "@setchapternewpage","\n",	"",		"\n",	"",	DISCARD,
    "@setfilename",	"\n",	"",		"\n",	"",	DISCARD,
    "@settitle",	"\n",	"\n.ds St ",
	     "\n.OH '\\\\*(St''%'\n.EH '%''\\\\*(St'\n","",	HEADING,
    "@smallbook",	"\n",	"",		"\n",	"",	DISCARD,
    "@smallexample",	"@end", "\n.DS 1\n\\fR\\&\\f(CW\n",
				"\n.DE\n","\\fR\\&\\f(CW",	DISPLAY,
    "@sp",		"\n",	"\n.sp",	"\n",	"",	PARAGRAPH,
    "@sp2",		"\n",	"\n.sp 2",	"\n",	"",	PARAGRAPH,
    "@strong{",		"}",	"\\fB",		"",	"\\fB",	INPARA,
    "@subheading",	"\n",	"\n.sp .5\n.HU ",
					"\n.sp .5\n",	"\\fB",	HEADING,
    "@subsection",	"\n",	"\n.sp .5\n.H 3 ",
					"\n.sp .5\n",	"\\fB",	HEADING,
    "@subsubheading",	"\n",	"\n.sp .5\n.HU ",
					"\n.sp .5\n",	"\\fB",	HEADING,
    "@subsubsection",	"\n",	"\n.sp .5\n.H 4 ",
					"\n.sp .5\n",	"\\fB",	HEADING,
    "@subtext",		"\n",	"\n.ce\n",	"\n",	"",	HEADING,
    "@subtitle",	"\n",	"\n.ce\n",	"\n",	"",	HEADING,
    "@summarycontents", "\n",	"\n.TC 1 1 5 0 \n", "",	"",	INPARA,
    "@syncodeindex",	"\n",	"",		"\n",	"",	DISCARD,
    "@synindex",	"\n",	"",		"\n",	"",	DISCARD,
    "@t",		"\n",	"\t",		"\n",	"",	CHAR,
    "@table",		"@end", "\n.VL 5 0\n",	"\n.LE\n","",	ITEMIZING,
    "@tex",		"@end", "",		"",	"",	DISCARD, 
    "@tindex",		"\n",	"\n.iX \"t ",	"\"\n",	"",	INDEX,
    "@title",		"\n",	"\n.ce\n",	"\n",	"",	HEADING,
    "@titlefont{",	"}",	"\n.ps +10\n.ce\n",
					 "\n.ps -10\n",	"",	PARAGRAPH,
    "@titlepage",	"@end", "\n",		"\n.bp\n","",	PARAGRAPH,
    "@titlespec",	"@end", "\n.ce \n\\&\\*(St \n","\n","",	PARAGRAPH,
    "@t{",		"}",	"\\fR\\&\\f(CW","","\\fR\\&\\f(CW",INPARA,
    "@unnumbered",	"\n",	"\n.bp\n.sp .5\n.HU ",
					"\n.sp .5\n",	"\\fB",	HEADING,
    "@unnumberedsec",	"\n",	"\n.sp .5\n.HU ",
					"\n.sp .5\n",	"\\fB",	HEADING,
    "@unnumberedsubsec","\n",	"\n.sp .5\n.HU ",
					"\n.sp .5\n",	"\\fB",	HEADING,
    "@unnumberedsubsubsec","\n","\n.sp .5\n.HU ",
					"\n.sp .5\n",	"\\fB",	HEADING,
    "@var{",		"}",	"\\fI",		"",	"\\fI",	INPARA,
    "@vfil",		"\n",	"",		"\n",	"",	DISCARD,
    "@vindex",		"\n",	"\n.iX \"v ",	"\"\n",	"",	INDEX,
    "@vskip",		"\n",	"",		"\n",	"",	DISCARD,
    "@w{",		"}",	"\n\\! ",	"\n",	"",	INPARA,
    "@xref{",		"}",	"See section ",	"",	"",	PARAGRAPH,
    "@{",		"",	"{",		"",	"",	ESCAPED,
    "@}",		"",	"}",		"",	"",	ESCAPED
};
