/*
 * Author:      William Chia-Wei Cheng (bill.cheng@acm.org)
 *
 * Copyright (C) 1990-2011, William Chia-Wei Cheng.
 *
 * Permission limited to the use, copy, display, distribute without
 * charging for a fee, and produce derivative works of "tgif" and
 * its documentation for not-for-profit purpose is hereby granted by
 * the Author, provided that the above copyright notice appears in
 * all copies made of "tgif" and that both the copyright notice
 * and this permission notice appear in supporting documentation,
 * and that the name of the Author not be used in advertising or
 * publicity pertaining to distribution of the software without
 * specific, written prior permission.  The Author makes no
 * representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied
 * warranty.  All other rights (including, but not limited to, the
 * right to sell "tgif", the right to sell or distribute derivative
 * works of "tgif", the right to distribute "tgif" for a fee, and
 * the right to include "tgif" or derivative works of "tgif" in a
 * for-sale product or service) are reserved by the Author.
 *
 * THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT
 * OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * @(#)$Header: /mm2/home/cvs/bc-src/tgif/hash.e,v 1.5 2011/05/16 16:21:57 william Exp $
 */

#ifndef _HASH_E_
#define _HASH_E_

#include "list.e"

#define TG_HASH_SIZE_SMALL   251
#define TG_HASH_SIZE_MEDIUM  509
#define TG_HASH_SIZE_LARGE  2039

typedef struct tagTgHash {
   int num_buckets;
   CVList *buckets;
} TgHash;

#ifdef _INCLUDE_FROM_HASH_C_
#undef extern
#define extern
#endif /*_INCLUDE_FROM_HASH_C_*/

extern void	CleanUpHash ARGS_DECL((TgHash*));
extern int	InitHash ARGS_DECL((TgHash*, int which));

extern int	HashStoreInt ARGS_DECL((TgHash*, char *key, int key_sz,
				int value));
extern int	HashStoreStr ARGS_DECL((TgHash*, char *key, int key_sz,
				char *value));
extern int	HashLookUpInt ARGS_DECL((TgHash*, char *key, int key_sz,
				int *pn_value_return));
extern char	*HashLookUpStr ARGS_DECL((TgHash*, char *key, int key_sz));

#ifdef _INCLUDE_FROM_HASH_C_
#undef extern
#ifndef _NO_RECURSIVE_EXTERN
#define extern extern
#endif /* ~_NO_RECURSIVE_EXTERN */
#endif /*_INCLUDE_FROM_HASH_C_*/

#endif /*_HASH_E_*/
