/*
 * Author:      William Chia-Wei Cheng (bill.cheng@acm.org)
 *
 * Copyright (C) 1990-2011, William Chia-Wei Cheng.
 *
 * Permission limited to the use, copy, display, distribute without
 * charging for a fee, and produce derivative works of "tgif" and
 * its documentation for not-for-profit purpose is hereby granted by
 * the Author, provided that the above copyright notice appears in
 * all copies made of "tgif" and that both the copyright notice
 * and this permission notice appear in supporting documentation,
 * and that the name of the Author not be used in advertising or
 * publicity pertaining to distribution of the software without
 * specific, written prior permission.  The Author makes no
 * representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied
 * warranty.  All other rights (including, but not limited to, the
 * right to sell "tgif", the right to sell or distribute derivative
 * works of "tgif", the right to distribute "tgif" for a fee, and
 * the right to include "tgif" or derivative works of "tgif" in a
 * for-sale product or service) are reserved by the Author.
 *
 * THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT
 * OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * @(#)$Header: /mm2/home/cvs/bc-src/tgif/tdgtbtn.e,v 1.6 2011/05/16 16:22:00 william Exp $
 */

#ifndef _TDGTBTN_E_
#define _TDGTBTN_E_

#include "tidget.h"

#define TDGTBTN_DEF_H_PAD 0
#define TDGTBTN_DEF_V_PAD 0

#define TDGTBTN_CLICK 0
#define TDGTBTN_STICKY 1

typedef struct tagTdgtBtn {
   TidgetInfo *pti;

   int btn_type; /* TGMUTYPE_TEXT, TGMUTYPE_COLOR, or TGMUTYPE_BITMAP */
   int btn_style; /* TDGTBTN_CLICK or TDGTBTN_STICKY */
   int font_style; /* STYLE_NR, STYLE_BR, STYLE_NI, STYLE_BI */

   /*
    * for TGMUTYPE_TEXT, str is (char*), point to a string
    * for TGMUTYPE_COLOR, str is (int), point to a color index
    * for TGMUTYPE_BITMAP, str is (Pixmap*), point to a pixmap
    */
   char *str;
   MouseOverStatusInfo mosi;
} TdgtBtn;

#ifdef _INCLUDE_FROM_TDGTBTN_C_
#undef extern
#define extern
#endif /*_INCLUDE_FROM_TDGTBTN_C_*/

extern void	CalcTdgtBtnDim ARGS_DECL((char *text, int min_len, int h_pad,
				int v_pad, int *pn_width, int *pn_height));

extern void	TdgtBtnReset ARGS_DECL((TdgtBtn*));
extern TdgtBtn	*CreateTdgtBtn ARGS_DECL((Window parent_win,
				TidgetInfo *parent_tidgetinfo, int ctl_id,
				int x, int y, int w, int h, int h_pad,
				int v_pad, int btn_type, int btn_style,
				int state, int font_style, char *str,
				MouseOverStatusInfo *pmosi));

extern int	TdgtBtnSetText ARGS_DECL((TdgtBtn*, char *str,
				MouseOverStatusInfo *pmosi));
extern char	*TdgtBtnGetText ARGS_DECL((TdgtBtn*));
extern int	TdgtBtnSetState ARGS_DECL((TdgtBtn*, int));
extern int	TdgtBtnGetState ARGS_DECL((TdgtBtn*));

extern int	InitTdgtBtn ARGS_DECL((void));
extern void	CleanUpTdgtBtn ARGS_DECL((void));

#ifdef _INCLUDE_FROM_TDGTBTN_C_
#undef extern
#ifndef _NO_RECURSIVE_EXTERN
#define extern extern
#endif /* ~_NO_RECURSIVE_EXTERN */
#endif /*_INCLUDE_FROM_TDGTBTN_C_*/

#endif /*_TDGTBTN_E_*/
