/*
 * Author:      William Chia-Wei Cheng (bill.cheng@acm.org)
 *
 * Copyright (C) 1990-2011, William Chia-Wei Cheng.
 *
 * Permission limited to the use, copy, display, distribute without
 * charging for a fee, and produce derivative works of "tgif" and
 * its documentation for not-for-profit purpose is hereby granted by
 * the Author, provided that the above copyright notice appears in
 * all copies made of "tgif" and that both the copyright notice
 * and this permission notice appear in supporting documentation,
 * and that the name of the Author not be used in advertising or
 * publicity pertaining to distribution of the software without
 * specific, written prior permission.  The Author makes no
 * representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied
 * warranty.  All other rights (including, but not limited to, the
 * right to sell "tgif", the right to sell or distribute derivative
 * works of "tgif", the right to distribute "tgif" for a fee, and
 * the right to include "tgif" or derivative works of "tgif" in a
 * for-sale product or service) are reserved by the Author.
 *
 * THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT
 * OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * @(#)$Header: /mm2/home/cvs/bc-src/tgif/tgcwheel.c,v 1.5 2011/06/02 15:53:08 william Exp $
 */

#define _INCLUDE_FROM_TGCWHEEL__C_

#include "tgifdefs.h"
#include "tidget.h"

#include "auxtext.e"
#include "dialog.e"
#include "font.e"
#include "msg.e"
#include "setup.e"
#include "strtbl.e"
#include "tgcwheel.e"
#include "tgcwdl.e"
#include "tidget.e"
#include "util.e"

/* --------------------- Init & Clean Up --------------------- */

void TgColorWheel_CleanUp(dpy, win)
   Display *dpy;
   Window win;
{
   if (gColorWheelInfo.initialized) {
      if (gColorWheelInfo.dialogbox_tidgetinfo != NULL) {
         DestroyTdgtColorWheelDialogBox(dpy,
               gColorWheelInfo.dialogbox_tidgetinfo);
      }
   }
   if (gColorWheelInfo.hs_pixmap != None) {
      XFreePixmap(mainDisplay, gColorWheelInfo.hs_pixmap);
   }
   if (gColorWheelInfo.v_pixmap != None) {
      XFreePixmap(mainDisplay, gColorWheelInfo.v_pixmap);
   }
   memset(&gColorWheelInfo, 0, sizeof(ColorWheelInfo));

   CleanUpTdgtColorWheelDlg();
}

int TgColorWheel_Init(dpy, win, arg)
   Display *dpy;
   Window win;
   char *arg;
{
   memset(&gColorWheelInfo, 0, sizeof(ColorWheelInfo));

   gColorWheelInfo.hs_pixmap = XCreatePixmap(mainDisplay, rootWindow, HS_WIDTH,
         HS_HEIGHT, mainDepth);
   if (arg != NULL) {
      UtilStrCpyN(gColorWheelInfo.color_str, sizeof(gColorWheelInfo.color_str),
            arg);
   }
   if (gColorWheelInfo.hs_pixmap == None) {
      FailAllocPixmapMessage(HS_WIDTH, HS_HEIGHT);
      TgColorWheel_CleanUp(dpy, win);
      return FALSE;
   }
   gColorWheelInfo.v_pixmap = XCreatePixmap(mainDisplay, rootWindow, V_WIDTH,
         V_HEIGHT, mainDepth);
   if (gColorWheelInfo.v_pixmap == None) {
      FailAllocPixmapMessage(V_WIDTH, V_HEIGHT);
      TgColorWheel_CleanUp(dpy, win);
      return FALSE;
   }
   if (!InitTdgtColorWheelDlg()) {
      TgColorWheel_CleanUp(dpy, win);

      return FALSE;
   }
   return TRUE;
}

void CleanUpColorWheel()
{
   TgColorWheel_CleanUp(mainDisplay, drawWindow);
}

int InitColorWheel()
{
   return TgColorWheel_Init(mainDisplay, drawWindow, NULL);
}

/* --------------------- TgColorWheel_SendKey --------------------- */

static XComposeStatus c_stat;

int TgColorWheel_SendKey(dpy, win, key_ev, buf)
   Display *dpy;
   Window win;
   XKeyEvent *key_ev;
   char *buf;
   /* return FALSE means key_ev will be handled without modifications */
{
   int has_ch=0;
   char s[80];
   KeySym key_sym=(KeySym)0;

   has_ch = XLookupString(key_ev, s, sizeof(s), &key_sym, &c_stat);
   TranslateKeys(s, &key_sym);

   return FALSE;
}

/* --------------------- TgColorWheel_HandleCntrlSpace --------------------- */

int TgColorWheel_HandleCntrlSpace(dpy, win)
   Display *dpy;
   Window win;
{
   if (!gColorWheelInfo.initialized) {
      gColorWheelInfo.initialized = TRUE;
      /* create window */
      gColorWheelInfo.dialogbox_tidgetinfo =
            CreateTdgtColorWheelDialogBox(dpy, rootWindow);
      if (gColorWheelInfo.dialogbox_tidgetinfo == NULL) {
         /* print a message */
      }
   }
   if (gColorWheelInfo.dialogbox_tidgetinfo == NULL) {
      return FALSE;
   }
   if (!gColorWheelInfo.mapped) {
      ShowTdgtColorWheelDialogBox();
      TdgtColorWheelDlgLoop(gColorWheelInfo.dialogbox_tidgetinfo);
   } else {
      HideTdgtColorWheelDialogBox();
   }
   return FALSE;
}

/* --------------------- TgColorWheel_HandleCreateText --------------------- */

int TgColorWheel_HandleCreateText(dpy, win)
   Display *dpy;
   Window win;
{
   if (gColorWheelInfo.initialized && gColorWheelInfo.mapped) {
      HideTdgtColorWheelDialogBox();
   }
   return TRUE;
}

