/* tn5250 -- an implentation of the 5250 telnet protocol.
 * Copyright (C) 1997 Michael Madore
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef TERMINAL_H
#define TERMINAL_H

// K_CTRL('X') = curses/ascii key value for Ctrl+X
#define K_CTRL(k) ((k)-0x40)

//
// The Terminal class is an abstract base class for programs wishing to
// implement a Tn5250 user interface.
//
class Terminal {
public:

   // Flags
   enum {
      HAS_COLOR	  = 0x0001
   };

   // Events
   enum {
      EVENT_KEY =	0x0001,	/* Key pressed. */
      EVENT_DATA =	0x0002,	/* Data received on fd. */
      EVENT_QUIT =	0x0004  /* Should exit emulator. */
   }; 

   // Key definitions
   // These are directly copied from <curses.h>, although the only real
   // requirement is that they be unique.  CursesTerminal is currently
   // broken and relies on them being the same, though.
   enum {
      K_FIRST_SPECIAL	= 0400, // Coincides with first Curses key.

      // Misc.
      K_ENTER		= 0x0d,
      K_NEWLINE		= 0x0a,
      K_TAB		= 0x09,
      K_BACKTAB		= 0541,

      // Function keys
      K_F1		= 0410+1,
      K_F2		= 0410+2,
      K_F3		= 0410+3,
      K_F4		= 0410+4,
      K_F5		= 0410+5,
      K_F6		= 0410+6,
      K_F7		= 0410+7,
      K_F8		= 0410+8,
      K_F9		= 0410+9,
      K_F10		= 0410+10,
      K_F11		= 0410+11,
      K_F12		= 0410+12,
      K_F13		= 0410+13,
      K_F14		= 0410+14,
      K_F15		= 0410+15,
      K_F16		= 0410+16,
      K_F17		= 0410+17,
      K_F18		= 0410+18,
      K_F19		= 0410+19,
      K_F20		= 0410+20,
      K_F21		= 0410+21,
      K_F22		= 0410+22,
      K_F23		= 0410+23,
      K_F24		= 0410+24,
      K_LEFT		= 0404,
      K_RIGHT		= 0405,
      K_UP		= 0403,
      K_DOWN		= 0402,
      K_ROLLDN		= 0523,
      K_ROLLUP		= 0522,
      K_BACKSPACE	= 0407,
      K_HOME		= 0406,
      K_END		= 0550,
      K_INSERT		= 0513,
      K_DELETE		= 0512,
      K_RESET		= 0531,
      K_PRINT		= 0532,
      K_HELP		= 0553,
      K_SYSREQ		= 0401, /* curses KEY_BREAK */
      K_CLEAR		= 0515, /* curses KEY_CLEAR */
      K_REFRESH		= 0564, /* curses KEY_REFRESH */
      K_FIELDEXIT	= 0517, /* curses KEY_EOL (clear to EOL) */
      K_TESTREQ		= 0516, /* curses KEY_EOS (as good as any) */
      K_TOGGLE		= 0533, /* curses KEY_LL (as good as any) */
      K_ERASE		= 0514, /* curses KEY_EIC (as good as any) */
      K_ATTENTION	= 0511, /* curses KEY_IL (as good as any) */
      K_DUPLICATE	= 0524, /* curses KEY_STAB (set tab - good as any) */
      K_FIELDMINUS	= 0526, /* curses KEY_CATAB (clear all tabs - g.a.a.) */
      K_UNKNOW		= 0xffff
   };
   
   virtual void init (void) = 0;
   virtual void term (void) = 0;

   virtual void connection_fd (SOCKET_TYPE fd) = 0;

   virtual int width (void) const = 0;
   virtual int height (void) const = 0;
   virtual int flags (void) const = 0;
   virtual void update (const DisplayBuffer& buffer) = 0;
   virtual void update_indicators (const DisplayBuffer& buffer) = 0;
   virtual int waitevent (void) = 0;
   virtual int getkey (void) = 0;
};

#endif /* TERMINAL_H */
