/****************************************************************************/
/*                                                                          */
/*                                Evict Key                                 */
/*                                                                          */
/*  This file is copyright 2003 IBM. See "License" for details              */
/****************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <tcpa.h>

int main(int argc, char *argv[])
{
    uint32_t ret;
    uint32_t handle;
    uint16_t num;
    uint32_t keys[256];
    int i;

    if (argc < 2) {
        fprintf(stderr, "Usage: evictkey <key handle in hex>|all\n");
        exit(1);
    }
    if(!strncmp(argv[1],"all",3)){
        if(TPM_GetCapability_Key_Handle(&num, keys, TPMLOG))
            exit(-1);
        for(i=0;i<num;i++){
            printf("Key Handle %04X being evicted\n",keys[i]);
            TPM_EvictKey(keys[i],TPMLOG);
        }
        exit(0);
    }
    ret = sscanf(argv[1], "%x", &handle);
    if (ret != 1) {
        fprintf(stderr, "Invalid argument '%s'\n", argv[1]);
        exit(-1);
    }
    ret = TPM_EvictKey(handle,TPMLOG);
    if (ret != 0) {
        fprintf(stderr, "Error %d from TPM_EvictKey\n", ret);
        exit(-1);
    }
    exit(0);
}
