/* Arch/amiga/scroll.c
	vi:ts=3 sw=3:
 */

/* $Id: scroll.c,v 5.0 1995/10/21 14:55:11 espie Exp espie $
 * $Log: scroll.c,v $
 * Revision 5.0  1995/10/21 14:55:11  espie
 * New
 *
 * Revision 1.5  1995/10/13 18:01:29  espie
 * Scroll system simpler.
 *
 * Revision 1.4  1995/05/11  12:09:26  espie
 * Dummy call added.
 *
 * Revision 1.3  1995/02/14  16:51:22  espie
 * *** empty log message ***
 *
 * Revision 1.2  1995/02/13  22:05:42  espie
 * Added one space to buffer.
 *
 * Revision 1.1  1995/01/13  13:31:35  espie
 * Initial revision
 *
 */

#include <proto/exec.h>

#include "defs.h"
#include "extern.h"
#include "Arch/amiga/amiga.h"
#include "prefs.h"
ID("$Id")

XT unsigned int inhibit_output;

/***
 ***
 ***	Scrolling line handling: 
 ***		note this is totally asynchronous and uses the TYPE_DO_SYNC
 ***		message for synchronizing with songs that are really played
 ***/

LOCAL char scroll_line[2000];

char *new_scroll(void)
   {
   scroll_line[0] = 0;
   return scroll_line;
   }

/* The actual hook that does all the printing */
LOCAL void do_scroll(VALUE p)  
   {
	char *line = p.pointer;
	if (inhibit_output == 0 && get_pref_scalar(PREF_SHOW))
		{
		add_scroller(line);
      }
   free(line);
   }

void scroll(end)
char *end;
   {
   struct ext_message *msg;
   char *p;
   int t;
   
   t = end - scroll_line;
   if (t > 0)
      {
      p = malloc(t+1);
      if (p)
         {
         strncpy(p, scroll_line, t);
         p[t] = 0;
         msg = obtain_message();
         msg->data.hook.func = do_scroll;
         msg->data.hook.p.pointer = p;
         send(msg, TYPE_SYNC_DO);
         }
      }
   }

void set_number_tracks(n)
int n;
   {
   }
