/* Modules/Pro/low.c
	vi:ts=3 sw=3:
 */

/* the amiga sound engine as it is used by Protracker and consorts.
 * (low-level layer for the soundtracker player, higher-level interface
 * to tracker resampling engine/Amiga audio.device control code)
 */

/* $Id: low.c,v 1.3 1996/05/07 15:22:25 espie Exp espie $
 * $Log: low.c,v $
 * Revision 1.3  1996/05/07 15:22:25  espie
 * First use of watched_var protocol (oversample/frequency)
 * Correction of a nasty bug (volume needs to be signed when set)
 *
 * Revision 1.2  1996/05/06 22:48:35  espie
 * *** empty log message ***
 *
 * Revision 1.1  1996/04/12 16:31:20  espie
 * Initial revision
 *
 * Revision 1.1  1996/04/09 21:14:12  espie
 * Initial revision
 *
 */

#include "defs.h"
#include "notes.h"
#include "channel.h"
#include "Modules/Pro/low.h"
#include "resample.h"
#include "song.h"
#include "empty.h"

ID("$Id: low.c,v 1.3 1996/05/07 15:22:25 espie Exp espie $")

/* setting up a given note */
void start_note(struct channel *ch)
   {
   ch->vib.offset = 0;
	ch->trem.offset = 0;
   play_note(ch->audio, ch->samp, ch->pitch);
   }

void stop_note(struct channel *ch)
	{
	play_note(ch->audio, empty_sample(), 0);
	}

void set_current_note(struct channel *ch, note note, pitch pitch)
	{
	ch->pitch = pitch;
	ch->note = note;
	}

/* changing the current pitch (value may be temporary, and so is not stored
 * in channel pitch, for instance vibratos)
 */
void set_temp_pitch(struct channel *ch, pitch pitch)
   {
   set_play_pitch(ch->audio, pitch);
   }

/* changing the current volume, storing it in ch->volume
 */
void set_current_volume(struct channel *ch, int volume)
   {
   ch->volume = MAX(MIN(volume, MAX_VOLUME), MIN_VOLUME);
   set_play_volume(ch->audio, ch->volume);
   }

/* changing the current volume WITHOUT storing it
 */
void set_temp_volume(struct channel *ch, int volume)
	{
	volume = MAX(MIN(volume, MAX_VOLUME), MIN_VOLUME);
	set_play_volume(ch->audio, volume);
	}

void set_position(struct channel *ch, size_t pos)
   {
   set_play_position(ch->audio, pos);
   }

