#include "tree_sitter/parser.h"

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#ifdef _MSC_VER
#pragma optimize("", off)
#elif defined(__clang__)
#pragma clang optimize off
#elif defined(__GNUC__)
#pragma GCC optimize ("O0")
#endif

#define LANGUAGE_VERSION 13
#define STATE_COUNT 7939
#define LARGE_STATE_COUNT 1739
#define SYMBOL_COUNT 536
#define ALIAS_COUNT 5
#define TOKEN_COUNT 209
#define EXTERNAL_TOKEN_COUNT 28
#define FIELD_COUNT 45
#define MAX_ALIAS_SEQUENCE_LENGTH 10
#define PRODUCTION_ID_COUNT 258

enum ts_symbol_identifiers {
  anon_sym_POUND_BANG = 1,
  aux_sym_shebang_line_token1 = 2,
  sym_comment = 3,
  aux_sym_simple_identifier_token1 = 4,
  aux_sym_simple_identifier_token2 = 5,
  aux_sym_simple_identifier_token3 = 6,
  aux_sym_simple_identifier_token4 = 7,
  anon_sym_actor = 8,
  anon_sym_async = 9,
  anon_sym_each = 10,
  anon_sym_lazy = 11,
  anon_sym_repeat = 12,
  anon_sym_package = 13,
  anon_sym_nil = 14,
  sym_real_literal = 15,
  sym_integer_literal = 16,
  sym_hex_literal = 17,
  sym_oct_literal = 18,
  sym_bin_literal = 19,
  anon_sym_true = 20,
  anon_sym_false = 21,
  anon_sym_DQUOTE = 22,
  aux_sym_line_str_text_token1 = 23,
  anon_sym_BSLASH = 24,
  anon_sym_u = 25,
  aux_sym__uni_character_literal_token1 = 26,
  anon_sym_DQUOTE_DQUOTE_DQUOTE = 27,
  anon_sym_RPAREN = 28,
  sym_raw_str_interpolation_start = 29,
  anon_sym_BSLASH_LPAREN = 30,
  anon_sym_COMMA = 31,
  sym__escaped_identifier = 32,
  sym__extended_regex_literal = 33,
  aux_sym__multiline_regex_literal_token1 = 34,
  aux_sym__multiline_regex_literal_token2 = 35,
  sym__oneline_regex_literal = 36,
  anon_sym_COLON = 37,
  anon_sym_BANG = 38,
  anon_sym_LPAREN = 39,
  anon_sym_LBRACK = 40,
  anon_sym_RBRACK = 41,
  anon_sym_DOT = 42,
  anon_sym_Type = 43,
  anon_sym_Protocol = 44,
  anon_sym_QMARK = 45,
  anon_sym_QMARK2 = 46,
  anon_sym_some = 47,
  anon_sym_any = 48,
  anon_sym_AMP = 49,
  anon_sym_if = 50,
  anon_sym_switch = 51,
  anon_sym_POUNDselector = 52,
  anon_sym_getter_COLON = 53,
  anon_sym_setter_COLON = 54,
  aux_sym_custom_operator_token1 = 55,
  anon_sym_LT = 56,
  anon_sym_GT = 57,
  anon_sym_await = 58,
  anon_sym_POUNDfile = 59,
  anon_sym_POUNDfileID = 60,
  anon_sym_POUNDfilePath = 61,
  anon_sym_POUNDline = 62,
  anon_sym_POUNDcolumn = 63,
  anon_sym_POUNDfunction = 64,
  anon_sym_POUNDdsohandle = 65,
  anon_sym_POUNDcolorLiteral = 66,
  anon_sym_POUNDfileLiteral = 67,
  anon_sym_POUNDimageLiteral = 68,
  anon_sym_LBRACE = 69,
  anon_sym_CARET_LBRACE = 70,
  anon_sym_RBRACE = 71,
  anon_sym_in = 72,
  anon_sym_self = 73,
  anon_sym_super = 74,
  anon_sym_guard = 75,
  anon_sym_case = 76,
  anon_sym_fallthrough = 77,
  anon_sym_do = 78,
  anon_sym_POUNDkeyPath = 79,
  anon_sym_try = 80,
  anon_sym_PLUS_EQ = 81,
  anon_sym_DASH_EQ = 82,
  anon_sym_STAR_EQ = 83,
  anon_sym_SLASH_EQ = 84,
  anon_sym_PERCENT_EQ = 85,
  anon_sym_BANG_EQ = 86,
  anon_sym_BANG_EQ_EQ = 87,
  anon_sym_EQ_EQ_EQ = 88,
  anon_sym_LT_EQ = 89,
  anon_sym_GT_EQ = 90,
  anon_sym_DOT_DOT_DOT = 91,
  anon_sym_DOT_DOT_LT = 92,
  anon_sym_is = 93,
  anon_sym_PLUS = 94,
  anon_sym_DASH = 95,
  anon_sym_STAR = 96,
  anon_sym_SLASH = 97,
  anon_sym_PERCENT = 98,
  anon_sym_PLUS_PLUS = 99,
  anon_sym_DASH_DASH = 100,
  anon_sym_TILDE = 101,
  anon_sym_PIPE = 102,
  anon_sym_CARET = 103,
  anon_sym_LT_LT = 104,
  anon_sym_GT_GT = 105,
  sym_statement_label = 106,
  anon_sym_for = 107,
  anon_sym_while = 108,
  sym_throw_keyword = 109,
  anon_sym_return = 110,
  anon_sym_continue = 111,
  anon_sym_break = 112,
  anon_sym_yield = 113,
  anon_sym_POUNDavailable = 114,
  anon_sym_POUNDunavailable = 115,
  anon_sym_import = 116,
  anon_sym_typealias = 117,
  anon_sym_struct = 118,
  anon_sym_class = 119,
  anon_sym_enum = 120,
  anon_sym_protocol = 121,
  anon_sym_let = 122,
  anon_sym_var = 123,
  anon_sym_func = 124,
  anon_sym_willSet = 125,
  anon_sym_didSet = 126,
  anon_sym_macro = 127,
  anon_sym_POUNDexternalMacro = 128,
  anon_sym_extension = 129,
  anon_sym_indirect = 130,
  anon_sym_BANG2 = 131,
  anon_sym_SEMI = 132,
  anon_sym_init = 133,
  anon_sym_deinit = 134,
  anon_sym_subscript = 135,
  anon_sym_get = 136,
  anon_sym_set = 137,
  anon_sym__modify = 138,
  anon_sym_prefix = 139,
  anon_sym_infix = 140,
  anon_sym_postfix = 141,
  anon_sym_operator = 142,
  anon_sym_precedencegroup = 143,
  anon_sym_associatedtype = 144,
  anon_sym_AT = 145,
  sym_wildcard_pattern = 146,
  anon_sym_override = 147,
  anon_sym_convenience = 148,
  anon_sym_required = 149,
  anon_sym_nonisolated = 150,
  anon_sym_public = 151,
  anon_sym_private = 152,
  anon_sym_internal = 153,
  anon_sym_fileprivate = 154,
  anon_sym_open = 155,
  anon_sym_mutating = 156,
  anon_sym_nonmutating = 157,
  anon_sym_static = 158,
  anon_sym_dynamic = 159,
  anon_sym_optional = 160,
  anon_sym_distributed = 161,
  anon_sym_final = 162,
  anon_sym_inout = 163,
  anon_sym_ATescaping = 164,
  anon_sym_ATautoclosure = 165,
  anon_sym_weak = 166,
  anon_sym_unowned = 167,
  anon_sym_unowned_LPARENsafe_RPAREN = 168,
  anon_sym_unowned_LPARENunsafe_RPAREN = 169,
  anon_sym_borrowing = 170,
  anon_sym_consuming = 171,
  anon_sym_property = 172,
  anon_sym_receiver = 173,
  anon_sym_param = 174,
  anon_sym_setparam = 175,
  anon_sym_delegate = 176,
  sym_directive = 177,
  sym_diagnostic = 178,
  anon_sym_unused1 = 179,
  anon_sym_unused2 = 180,
  sym_multiline_comment = 181,
  sym_raw_str_part = 182,
  sym_raw_str_continuing_indicator = 183,
  sym_raw_str_end_part = 184,
  sym__implicit_semi = 185,
  sym__explicit_semi = 186,
  sym__arrow_operator_custom = 187,
  sym__dot_custom = 188,
  sym__conjunction_operator_custom = 189,
  sym__disjunction_operator_custom = 190,
  sym__nil_coalescing_operator_custom = 191,
  sym__eq_custom = 192,
  sym__eq_eq_custom = 193,
  sym__plus_then_ws = 194,
  sym__minus_then_ws = 195,
  sym__bang_custom = 196,
  sym__throws_keyword = 197,
  sym__rethrows_keyword = 198,
  sym_default_keyword = 199,
  sym_where_keyword = 200,
  sym_else = 201,
  sym_catch_keyword = 202,
  sym__as_custom = 203,
  sym__as_quest_custom = 204,
  sym__as_bang_custom = 205,
  sym__async_keyword_custom = 206,
  sym__custom_operator = 207,
  sym__fake_try_bang = 208,
  sym_source_file = 209,
  sym__semi = 210,
  sym_shebang_line = 211,
  sym_simple_identifier = 212,
  sym__contextual_simple_identifier = 213,
  sym_identifier = 214,
  sym__basic_literal = 215,
  sym_boolean_literal = 216,
  sym__string_literal = 217,
  sym_line_string_literal = 218,
  sym__line_string_content = 219,
  sym_line_str_text = 220,
  sym_str_escaped_char = 221,
  sym__uni_character_literal = 222,
  sym_multi_line_string_literal = 223,
  sym_raw_string_literal = 224,
  sym_raw_str_interpolation = 225,
  sym__multi_line_string_content = 226,
  sym__interpolation = 227,
  sym__interpolation_contents = 228,
  sym_multi_line_str_text = 229,
  sym_regex_literal = 230,
  sym__multiline_regex_literal = 231,
  sym_type_annotation = 232,
  sym__possibly_implicitly_unwrapped_type = 233,
  sym__type = 234,
  sym__unannotated_type = 235,
  sym_user_type = 236,
  sym__simple_user_type = 237,
  sym_tuple_type = 238,
  sym_tuple_type_item = 239,
  sym__tuple_type_item_identifier = 240,
  sym_function_type = 241,
  sym_array_type = 242,
  sym_dictionary_type = 243,
  sym_optional_type = 244,
  sym_metatype = 245,
  sym__quest = 246,
  sym__immediate_quest = 247,
  sym_opaque_type = 248,
  sym_existential_type = 249,
  sym_type_parameter_pack = 250,
  sym_type_pack_expansion = 251,
  sym_protocol_composition_type = 252,
  sym__expression = 253,
  sym__unary_expression = 254,
  sym_postfix_expression = 255,
  sym_constructor_expression = 256,
  sym__parenthesized_type = 257,
  sym_navigation_expression = 258,
  sym__navigable_type_expression = 259,
  sym_open_start_range_expression = 260,
  sym__range_operator = 261,
  sym_open_end_range_expression = 262,
  sym_prefix_expression = 263,
  sym_as_expression = 264,
  sym_selector_expression = 265,
  sym__binary_expression = 266,
  sym_multiplicative_expression = 267,
  sym_additive_expression = 268,
  sym_range_expression = 269,
  sym_infix_expression = 270,
  sym_nil_coalescing_expression = 271,
  sym_check_expression = 272,
  sym_comparison_expression = 273,
  sym_equality_expression = 274,
  sym_conjunction_expression = 275,
  sym_disjunction_expression = 276,
  sym_bitwise_operation = 277,
  sym_custom_operator = 278,
  sym_navigation_suffix = 279,
  sym_call_suffix = 280,
  sym_constructor_suffix = 281,
  sym__constructor_value_arguments = 282,
  sym__fn_call_lambda_arguments = 283,
  sym_type_arguments = 284,
  sym_value_arguments = 285,
  sym_value_argument_label = 286,
  sym_value_argument = 287,
  sym_try_expression = 288,
  sym_await_expression = 289,
  sym__await_operator = 290,
  sym_ternary_expression = 291,
  sym__expr_hack_at_ternary_binary_suffix = 292,
  sym_expr_hack_at_ternary_binary_call = 293,
  sym_expr_hack_at_ternary_binary_call_suffix = 294,
  sym_call_expression = 295,
  sym__primary_expression = 296,
  sym_tuple_expression = 297,
  sym_array_literal = 298,
  sym_dictionary_literal = 299,
  sym__dictionary_literal_item = 300,
  sym__special_literal = 301,
  sym__playground_literal = 302,
  sym_lambda_literal = 303,
  sym__lambda_type_declaration = 304,
  sym_capture_list = 305,
  sym_capture_list_item = 306,
  sym_lambda_function_type = 307,
  sym_lambda_function_type_parameters = 308,
  sym_lambda_parameter = 309,
  sym_self_expression = 310,
  sym_super_expression = 311,
  sym__else_options = 312,
  sym_if_statement = 313,
  sym__if_condition_sequence_item = 314,
  sym__if_let_binding = 315,
  sym_guard_statement = 316,
  sym_switch_statement = 317,
  sym_switch_entry = 318,
  sym_switch_pattern = 319,
  sym_do_statement = 320,
  sym_catch_block = 321,
  sym_where_clause = 322,
  sym_key_path_expression = 323,
  sym_key_path_string_expression = 324,
  sym__key_path_component = 325,
  sym__key_path_postfixes = 326,
  sym_try_operator = 327,
  sym__try_operator_type = 328,
  sym__assignment_and_operator = 329,
  sym__equality_operator = 330,
  sym__comparison_operator = 331,
  sym__three_dot_operator = 332,
  sym__open_ended_range_operator = 333,
  sym__is_operator = 334,
  sym__additive_operator = 335,
  sym__multiplicative_operator = 336,
  sym_as_operator = 337,
  sym__prefix_unary_operator = 338,
  sym__bitwise_binary_operator = 339,
  sym__postfix_unary_operator = 340,
  sym_directly_assignable_expression = 341,
  sym_statements = 342,
  sym__local_statement = 343,
  sym__top_level_statement = 344,
  sym__block = 345,
  sym__labeled_statement = 346,
  sym_for_statement = 347,
  sym__for_statement_collection = 348,
  sym_for_statement_await = 349,
  sym_while_statement = 350,
  sym_repeat_while_statement = 351,
  sym_control_transfer_statement = 352,
  sym__throw_statement = 353,
  sym__optionally_valueful_control_keyword = 354,
  sym_assignment = 355,
  sym_value_parameter_pack = 356,
  sym_value_pack_expansion = 357,
  sym_availability_condition = 358,
  sym__availability_argument = 359,
  sym__global_declaration = 360,
  sym__type_level_declaration = 361,
  sym__local_declaration = 362,
  sym__local_property_declaration = 363,
  sym__local_typealias_declaration = 364,
  sym__local_function_declaration = 365,
  sym__local_class_declaration = 366,
  sym_import_declaration = 367,
  sym__import_kind = 368,
  sym_protocol_property_declaration = 369,
  sym_protocol_property_requirements = 370,
  sym_property_declaration = 371,
  sym__modifierless_property_declaration = 372,
  sym__single_modifierless_property_declaration = 373,
  sym__expression_with_willset_didset = 374,
  sym__expression_without_willset_didset = 375,
  sym_willset_didset_block = 376,
  sym_willset_clause = 377,
  sym_didset_clause = 378,
  sym_typealias_declaration = 379,
  sym__modifierless_typealias_declaration = 380,
  sym_function_declaration = 381,
  sym__modifierless_function_declaration = 382,
  sym__bodyless_function_declaration = 383,
  sym__modifierless_function_declaration_no_body = 384,
  sym_function_body = 385,
  sym_macro_declaration = 386,
  sym__macro_head = 387,
  sym__macro_signature = 388,
  sym_macro_definition = 389,
  sym_external_macro_definition = 390,
  sym_class_declaration = 391,
  sym__modifierless_class_declaration = 392,
  sym_class_body = 393,
  sym__inheritance_specifiers = 394,
  sym_inheritance_specifier = 395,
  sym__annotated_inheritance_specifier = 396,
  sym_type_parameters = 397,
  sym_type_parameter = 398,
  sym__type_parameter_possibly_packed = 399,
  sym_type_constraints = 400,
  sym_type_constraint = 401,
  sym_inheritance_constraint = 402,
  sym_equality_constraint = 403,
  sym__constrained_type = 404,
  sym__class_member_separator = 405,
  sym__class_member_declarations = 406,
  aux_sym__function_value_parameters = 407,
  sym__function_value_parameter = 408,
  sym_parameter = 409,
  sym__non_constructor_function_decl = 410,
  sym__referenceable_operator = 411,
  sym__equal_sign = 412,
  sym__eq_eq = 413,
  sym__dot = 414,
  sym__arrow_operator = 415,
  sym__conjunction_operator = 416,
  sym__disjunction_operator = 417,
  sym__nil_coalescing_operator = 418,
  sym__as = 419,
  sym__as_quest = 420,
  sym__as_bang = 421,
  sym_bang = 422,
  sym__async_keyword = 423,
  sym__async_modifier = 424,
  sym_throws = 425,
  sym_enum_class_body = 426,
  sym_enum_entry = 427,
  sym__enum_entry_suffix = 428,
  sym_enum_type_parameters = 429,
  sym_protocol_declaration = 430,
  sym_protocol_body = 431,
  sym__protocol_member_declarations = 432,
  sym__protocol_member_declaration = 433,
  sym_init_declaration = 434,
  sym_deinit_declaration = 435,
  sym_subscript_declaration = 436,
  sym_computed_property = 437,
  sym_computed_getter = 438,
  sym_computed_modify = 439,
  sym_computed_setter = 440,
  sym_getter_specifier = 441,
  sym_setter_specifier = 442,
  sym_modify_specifier = 443,
  aux_sym__getter_effects = 444,
  sym_operator_declaration = 445,
  sym_deprecated_operator_declaration_body = 446,
  sym_precedence_group_declaration = 447,
  sym_precedence_group_attributes = 448,
  sym_precedence_group_attribute = 449,
  sym_associatedtype_declaration = 450,
  sym_attribute = 451,
  sym__attribute_argument = 452,
  sym__universally_allowed_pattern = 453,
  sym__bound_identifier = 454,
  sym__binding_pattern_no_expr = 455,
  sym__no_expr_pattern_already_bound = 456,
  sym__binding_pattern_with_expr = 457,
  sym__direct_or_indirect_binding = 458,
  sym_value_binding_pattern = 459,
  sym__possibly_async_binding_pattern_kind = 460,
  sym__binding_kind_and_pattern = 461,
  sym__tuple_pattern_item = 462,
  sym__tuple_pattern = 463,
  sym__case_pattern = 464,
  sym__type_casting_pattern = 465,
  sym__binding_pattern = 466,
  sym_modifiers = 467,
  aux_sym__locally_permitted_modifiers = 468,
  sym_parameter_modifiers = 469,
  sym__non_local_scope_modifier = 470,
  sym__locally_permitted_modifier = 471,
  sym_property_behavior_modifier = 472,
  sym_type_modifiers = 473,
  sym_member_modifier = 474,
  sym_visibility_modifier = 475,
  sym_type_parameter_modifiers = 476,
  sym_function_modifier = 477,
  sym_mutation_modifier = 478,
  sym_property_modifier = 479,
  sym_inheritance_modifier = 480,
  sym_parameter_modifier = 481,
  sym_ownership_modifier = 482,
  sym__parameter_ownership_modifier = 483,
  aux_sym_source_file_repeat1 = 484,
  aux_sym_identifier_repeat1 = 485,
  aux_sym_line_string_literal_repeat1 = 486,
  aux_sym_multi_line_string_literal_repeat1 = 487,
  aux_sym_raw_string_literal_repeat1 = 488,
  aux_sym__interpolation_contents_repeat1 = 489,
  aux_sym_user_type_repeat1 = 490,
  aux_sym_tuple_type_repeat1 = 491,
  aux_sym_optional_type_repeat1 = 492,
  aux_sym_protocol_composition_type_repeat1 = 493,
  aux_sym__constructor_value_arguments_repeat1 = 494,
  aux_sym__fn_call_lambda_arguments_repeat1 = 495,
  aux_sym_type_arguments_repeat1 = 496,
  aux_sym_value_argument_repeat1 = 497,
  aux_sym_tuple_expression_repeat1 = 498,
  aux_sym_array_literal_repeat1 = 499,
  aux_sym_dictionary_literal_repeat1 = 500,
  aux_sym__playground_literal_repeat1 = 501,
  aux_sym__lambda_type_declaration_repeat1 = 502,
  aux_sym_capture_list_repeat1 = 503,
  aux_sym_lambda_function_type_parameters_repeat1 = 504,
  aux_sym_if_statement_repeat1 = 505,
  aux_sym_switch_statement_repeat1 = 506,
  aux_sym_switch_entry_repeat1 = 507,
  aux_sym_do_statement_repeat1 = 508,
  aux_sym_key_path_expression_repeat1 = 509,
  aux_sym__key_path_component_repeat1 = 510,
  aux_sym_statements_repeat1 = 511,
  aux_sym_repeat_while_statement_repeat1 = 512,
  aux_sym_availability_condition_repeat1 = 513,
  aux_sym__availability_argument_repeat1 = 514,
  aux_sym_protocol_property_requirements_repeat1 = 515,
  aux_sym__modifierless_property_declaration_repeat1 = 516,
  aux_sym__inheritance_specifiers_repeat1 = 517,
  aux_sym_type_parameters_repeat1 = 518,
  aux_sym_type_constraints_repeat1 = 519,
  aux_sym__constrained_type_repeat1 = 520,
  aux_sym__class_member_declarations_repeat1 = 521,
  aux_sym__function_value_parameters_repeat1 = 522,
  aux_sym_enum_class_body_repeat1 = 523,
  aux_sym_enum_entry_repeat1 = 524,
  aux_sym_enum_type_parameters_repeat1 = 525,
  aux_sym__protocol_member_declarations_repeat1 = 526,
  aux_sym_computed_property_repeat1 = 527,
  aux_sym_deprecated_operator_declaration_body_repeat1 = 528,
  aux_sym_precedence_group_attributes_repeat1 = 529,
  aux_sym_attribute_repeat1 = 530,
  aux_sym__attribute_argument_repeat1 = 531,
  aux_sym__attribute_argument_repeat2 = 532,
  aux_sym__tuple_pattern_repeat1 = 533,
  aux_sym_modifiers_repeat1 = 534,
  aux_sym_parameter_modifiers_repeat1 = 535,
  alias_sym__expression = 536,
  alias_sym_fully_open_range = 537,
  alias_sym_interpolated_expression = 538,
  alias_sym_protocol_function_declaration = 539,
  alias_sym_type_identifier = 540,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [anon_sym_POUND_BANG] = "#!",
  [aux_sym_shebang_line_token1] = "shebang_line_token1",
  [sym_comment] = "comment",
  [aux_sym_simple_identifier_token1] = "simple_identifier_token1",
  [aux_sym_simple_identifier_token2] = "simple_identifier_token2",
  [aux_sym_simple_identifier_token3] = "simple_identifier_token3",
  [aux_sym_simple_identifier_token4] = "simple_identifier_token4",
  [anon_sym_actor] = "actor",
  [anon_sym_async] = "async",
  [anon_sym_each] = "each",
  [anon_sym_lazy] = "lazy",
  [anon_sym_repeat] = "repeat",
  [anon_sym_package] = "package",
  [anon_sym_nil] = "nil",
  [sym_real_literal] = "real_literal",
  [sym_integer_literal] = "integer_literal",
  [sym_hex_literal] = "hex_literal",
  [sym_oct_literal] = "oct_literal",
  [sym_bin_literal] = "bin_literal",
  [anon_sym_true] = "true",
  [anon_sym_false] = "false",
  [anon_sym_DQUOTE] = "\"",
  [aux_sym_line_str_text_token1] = "line_str_text_token1",
  [anon_sym_BSLASH] = "\\",
  [anon_sym_u] = "u",
  [aux_sym__uni_character_literal_token1] = "_uni_character_literal_token1",
  [anon_sym_DQUOTE_DQUOTE_DQUOTE] = "\"\"\"",
  [anon_sym_RPAREN] = ")",
  [sym_raw_str_interpolation_start] = "raw_str_interpolation_start",
  [anon_sym_BSLASH_LPAREN] = "\\(",
  [anon_sym_COMMA] = ",",
  [sym__escaped_identifier] = "_escaped_identifier",
  [sym__extended_regex_literal] = "_extended_regex_literal",
  [aux_sym__multiline_regex_literal_token1] = "_multiline_regex_literal_token1",
  [aux_sym__multiline_regex_literal_token2] = "_multiline_regex_literal_token2",
  [sym__oneline_regex_literal] = "_oneline_regex_literal",
  [anon_sym_COLON] = ":",
  [anon_sym_BANG] = "!",
  [anon_sym_LPAREN] = "(",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_DOT] = ".",
  [anon_sym_Type] = "Type",
  [anon_sym_Protocol] = "Protocol",
  [anon_sym_QMARK] = "\?",
  [anon_sym_QMARK2] = "\?",
  [anon_sym_some] = "some",
  [anon_sym_any] = "any",
  [anon_sym_AMP] = "&",
  [anon_sym_if] = "if",
  [anon_sym_switch] = "switch",
  [anon_sym_POUNDselector] = "#selector",
  [anon_sym_getter_COLON] = "getter:",
  [anon_sym_setter_COLON] = "setter:",
  [aux_sym_custom_operator_token1] = "custom_operator_token1",
  [anon_sym_LT] = "<",
  [anon_sym_GT] = ">",
  [anon_sym_await] = "await",
  [anon_sym_POUNDfile] = "#file",
  [anon_sym_POUNDfileID] = "#fileID",
  [anon_sym_POUNDfilePath] = "#filePath",
  [anon_sym_POUNDline] = "#line",
  [anon_sym_POUNDcolumn] = "#column",
  [anon_sym_POUNDfunction] = "#function",
  [anon_sym_POUNDdsohandle] = "#dsohandle",
  [anon_sym_POUNDcolorLiteral] = "#colorLiteral",
  [anon_sym_POUNDfileLiteral] = "#fileLiteral",
  [anon_sym_POUNDimageLiteral] = "#imageLiteral",
  [anon_sym_LBRACE] = "{",
  [anon_sym_CARET_LBRACE] = "^{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_in] = "in",
  [anon_sym_self] = "self",
  [anon_sym_super] = "super",
  [anon_sym_guard] = "guard",
  [anon_sym_case] = "case",
  [anon_sym_fallthrough] = "fallthrough",
  [anon_sym_do] = "do",
  [anon_sym_POUNDkeyPath] = "#keyPath",
  [anon_sym_try] = "try",
  [anon_sym_PLUS_EQ] = "+=",
  [anon_sym_DASH_EQ] = "-=",
  [anon_sym_STAR_EQ] = "*=",
  [anon_sym_SLASH_EQ] = "/=",
  [anon_sym_PERCENT_EQ] = "%=",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_BANG_EQ_EQ] = "!==",
  [anon_sym_EQ_EQ_EQ] = "===",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_DOT_DOT_DOT] = "...",
  [anon_sym_DOT_DOT_LT] = "..<",
  [anon_sym_is] = "is",
  [anon_sym_PLUS] = "+",
  [anon_sym_DASH] = "-",
  [anon_sym_STAR] = "*",
  [anon_sym_SLASH] = "/",
  [anon_sym_PERCENT] = "%",
  [anon_sym_PLUS_PLUS] = "++",
  [anon_sym_DASH_DASH] = "--",
  [anon_sym_TILDE] = "~",
  [anon_sym_PIPE] = "|",
  [anon_sym_CARET] = "^",
  [anon_sym_LT_LT] = "<<",
  [anon_sym_GT_GT] = ">>",
  [sym_statement_label] = "statement_label",
  [anon_sym_for] = "for",
  [anon_sym_while] = "while",
  [sym_throw_keyword] = "throw_keyword",
  [anon_sym_return] = "return",
  [anon_sym_continue] = "continue",
  [anon_sym_break] = "break",
  [anon_sym_yield] = "yield",
  [anon_sym_POUNDavailable] = "#available",
  [anon_sym_POUNDunavailable] = "#unavailable",
  [anon_sym_import] = "import",
  [anon_sym_typealias] = "typealias",
  [anon_sym_struct] = "struct",
  [anon_sym_class] = "class",
  [anon_sym_enum] = "enum",
  [anon_sym_protocol] = "protocol",
  [anon_sym_let] = "let",
  [anon_sym_var] = "var",
  [anon_sym_func] = "func",
  [anon_sym_willSet] = "willSet",
  [anon_sym_didSet] = "didSet",
  [anon_sym_macro] = "macro",
  [anon_sym_POUNDexternalMacro] = "#externalMacro",
  [anon_sym_extension] = "extension",
  [anon_sym_indirect] = "indirect",
  [anon_sym_BANG2] = "!",
  [anon_sym_SEMI] = ";",
  [anon_sym_init] = "init",
  [anon_sym_deinit] = "deinit",
  [anon_sym_subscript] = "subscript",
  [anon_sym_get] = "get",
  [anon_sym_set] = "set",
  [anon_sym__modify] = "_modify",
  [anon_sym_prefix] = "prefix",
  [anon_sym_infix] = "infix",
  [anon_sym_postfix] = "postfix",
  [anon_sym_operator] = "operator",
  [anon_sym_precedencegroup] = "precedencegroup",
  [anon_sym_associatedtype] = "associatedtype",
  [anon_sym_AT] = "@",
  [sym_wildcard_pattern] = "wildcard_pattern",
  [anon_sym_override] = "override",
  [anon_sym_convenience] = "convenience",
  [anon_sym_required] = "required",
  [anon_sym_nonisolated] = "nonisolated",
  [anon_sym_public] = "public",
  [anon_sym_private] = "private",
  [anon_sym_internal] = "internal",
  [anon_sym_fileprivate] = "fileprivate",
  [anon_sym_open] = "open",
  [anon_sym_mutating] = "mutating",
  [anon_sym_nonmutating] = "nonmutating",
  [anon_sym_static] = "static",
  [anon_sym_dynamic] = "dynamic",
  [anon_sym_optional] = "optional",
  [anon_sym_distributed] = "distributed",
  [anon_sym_final] = "final",
  [anon_sym_inout] = "inout",
  [anon_sym_ATescaping] = "@escaping",
  [anon_sym_ATautoclosure] = "@autoclosure",
  [anon_sym_weak] = "weak",
  [anon_sym_unowned] = "unowned",
  [anon_sym_unowned_LPARENsafe_RPAREN] = "unowned(safe)",
  [anon_sym_unowned_LPARENunsafe_RPAREN] = "unowned(unsafe)",
  [anon_sym_borrowing] = "borrowing",
  [anon_sym_consuming] = "consuming",
  [anon_sym_property] = "property",
  [anon_sym_receiver] = "receiver",
  [anon_sym_param] = "param",
  [anon_sym_setparam] = "setparam",
  [anon_sym_delegate] = "delegate",
  [sym_directive] = "directive",
  [sym_diagnostic] = "diagnostic",
  [anon_sym_unused1] = "try\?",
  [anon_sym_unused2] = "try!",
  [sym_multiline_comment] = "multiline_comment",
  [sym_raw_str_part] = "raw_str_part",
  [sym_raw_str_continuing_indicator] = "raw_str_continuing_indicator",
  [sym_raw_str_end_part] = "raw_str_end_part",
  [sym__implicit_semi] = "_implicit_semi",
  [sym__explicit_semi] = "_explicit_semi",
  [sym__arrow_operator_custom] = "->",
  [sym__dot_custom] = ".",
  [sym__conjunction_operator_custom] = "&&",
  [sym__disjunction_operator_custom] = "||",
  [sym__nil_coalescing_operator_custom] = "\?\?",
  [sym__eq_custom] = "=",
  [sym__eq_eq_custom] = "==",
  [sym__plus_then_ws] = "+",
  [sym__minus_then_ws] = "-",
  [sym__bang_custom] = "_bang_custom",
  [sym__throws_keyword] = "_throws_keyword",
  [sym__rethrows_keyword] = "_rethrows_keyword",
  [sym_default_keyword] = "default_keyword",
  [sym_where_keyword] = "where_keyword",
  [sym_else] = "else",
  [sym_catch_keyword] = "catch_keyword",
  [sym__as_custom] = "as",
  [sym__as_quest_custom] = "as\?",
  [sym__as_bang_custom] = "as!",
  [sym__async_keyword_custom] = "async",
  [sym__custom_operator] = "_custom_operator",
  [sym__fake_try_bang] = "_fake_try_bang",
  [sym_source_file] = "source_file",
  [sym__semi] = "_semi",
  [sym_shebang_line] = "shebang_line",
  [sym_simple_identifier] = "simple_identifier",
  [sym__contextual_simple_identifier] = "_contextual_simple_identifier",
  [sym_identifier] = "identifier",
  [sym__basic_literal] = "_basic_literal",
  [sym_boolean_literal] = "boolean_literal",
  [sym__string_literal] = "_string_literal",
  [sym_line_string_literal] = "line_string_literal",
  [sym__line_string_content] = "_line_string_content",
  [sym_line_str_text] = "line_str_text",
  [sym_str_escaped_char] = "str_escaped_char",
  [sym__uni_character_literal] = "_uni_character_literal",
  [sym_multi_line_string_literal] = "multi_line_string_literal",
  [sym_raw_string_literal] = "raw_string_literal",
  [sym_raw_str_interpolation] = "raw_str_interpolation",
  [sym__multi_line_string_content] = "_multi_line_string_content",
  [sym__interpolation] = "_interpolation",
  [sym__interpolation_contents] = "_interpolation_contents",
  [sym_multi_line_str_text] = "multi_line_str_text",
  [sym_regex_literal] = "regex_literal",
  [sym__multiline_regex_literal] = "_multiline_regex_literal",
  [sym_type_annotation] = "type_annotation",
  [sym__possibly_implicitly_unwrapped_type] = "_possibly_implicitly_unwrapped_type",
  [sym__type] = "_type",
  [sym__unannotated_type] = "_unannotated_type",
  [sym_user_type] = "user_type",
  [sym__simple_user_type] = "_simple_user_type",
  [sym_tuple_type] = "tuple_type",
  [sym_tuple_type_item] = "tuple_type_item",
  [sym__tuple_type_item_identifier] = "_tuple_type_item_identifier",
  [sym_function_type] = "function_type",
  [sym_array_type] = "array_type",
  [sym_dictionary_type] = "dictionary_type",
  [sym_optional_type] = "optional_type",
  [sym_metatype] = "metatype",
  [sym__quest] = "_quest",
  [sym__immediate_quest] = "\?",
  [sym_opaque_type] = "opaque_type",
  [sym_existential_type] = "existential_type",
  [sym_type_parameter_pack] = "type_parameter_pack",
  [sym_type_pack_expansion] = "type_pack_expansion",
  [sym_protocol_composition_type] = "protocol_composition_type",
  [sym__expression] = "_expression",
  [sym__unary_expression] = "_unary_expression",
  [sym_postfix_expression] = "postfix_expression",
  [sym_constructor_expression] = "constructor_expression",
  [sym__parenthesized_type] = "_parenthesized_type",
  [sym_navigation_expression] = "navigation_expression",
  [sym__navigable_type_expression] = "_navigable_type_expression",
  [sym_open_start_range_expression] = "open_start_range_expression",
  [sym__range_operator] = "_range_operator",
  [sym_open_end_range_expression] = "open_end_range_expression",
  [sym_prefix_expression] = "prefix_expression",
  [sym_as_expression] = "as_expression",
  [sym_selector_expression] = "selector_expression",
  [sym__binary_expression] = "_binary_expression",
  [sym_multiplicative_expression] = "multiplicative_expression",
  [sym_additive_expression] = "additive_expression",
  [sym_range_expression] = "range_expression",
  [sym_infix_expression] = "infix_expression",
  [sym_nil_coalescing_expression] = "nil_coalescing_expression",
  [sym_check_expression] = "check_expression",
  [sym_comparison_expression] = "comparison_expression",
  [sym_equality_expression] = "equality_expression",
  [sym_conjunction_expression] = "conjunction_expression",
  [sym_disjunction_expression] = "disjunction_expression",
  [sym_bitwise_operation] = "bitwise_operation",
  [sym_custom_operator] = "custom_operator",
  [sym_navigation_suffix] = "navigation_suffix",
  [sym_call_suffix] = "call_suffix",
  [sym_constructor_suffix] = "constructor_suffix",
  [sym__constructor_value_arguments] = "value_arguments",
  [sym__fn_call_lambda_arguments] = "_fn_call_lambda_arguments",
  [sym_type_arguments] = "type_arguments",
  [sym_value_arguments] = "value_arguments",
  [sym_value_argument_label] = "value_argument_label",
  [sym_value_argument] = "value_argument",
  [sym_try_expression] = "try_expression",
  [sym_await_expression] = "await_expression",
  [sym__await_operator] = "_await_operator",
  [sym_ternary_expression] = "ternary_expression",
  [sym__expr_hack_at_ternary_binary_suffix] = "_expr_hack_at_ternary_binary_suffix",
  [sym_expr_hack_at_ternary_binary_call] = "call_expression",
  [sym_expr_hack_at_ternary_binary_call_suffix] = "call_suffix",
  [sym_call_expression] = "call_expression",
  [sym__primary_expression] = "_primary_expression",
  [sym_tuple_expression] = "tuple_expression",
  [sym_array_literal] = "array_literal",
  [sym_dictionary_literal] = "dictionary_literal",
  [sym__dictionary_literal_item] = "_dictionary_literal_item",
  [sym__special_literal] = "_special_literal",
  [sym__playground_literal] = "_playground_literal",
  [sym_lambda_literal] = "lambda_literal",
  [sym__lambda_type_declaration] = "_lambda_type_declaration",
  [sym_capture_list] = "capture_list",
  [sym_capture_list_item] = "capture_list_item",
  [sym_lambda_function_type] = "lambda_function_type",
  [sym_lambda_function_type_parameters] = "lambda_function_type_parameters",
  [sym_lambda_parameter] = "lambda_parameter",
  [sym_self_expression] = "self_expression",
  [sym_super_expression] = "super_expression",
  [sym__else_options] = "_else_options",
  [sym_if_statement] = "if_statement",
  [sym__if_condition_sequence_item] = "_if_condition_sequence_item",
  [sym__if_let_binding] = "_if_let_binding",
  [sym_guard_statement] = "guard_statement",
  [sym_switch_statement] = "switch_statement",
  [sym_switch_entry] = "switch_entry",
  [sym_switch_pattern] = "switch_pattern",
  [sym_do_statement] = "do_statement",
  [sym_catch_block] = "catch_block",
  [sym_where_clause] = "where_clause",
  [sym_key_path_expression] = "key_path_expression",
  [sym_key_path_string_expression] = "key_path_string_expression",
  [sym__key_path_component] = "_key_path_component",
  [sym__key_path_postfixes] = "_key_path_postfixes",
  [sym_try_operator] = "try_operator",
  [sym__try_operator_type] = "_try_operator_type",
  [sym__assignment_and_operator] = "_assignment_and_operator",
  [sym__equality_operator] = "_equality_operator",
  [sym__comparison_operator] = "_comparison_operator",
  [sym__three_dot_operator] = "_three_dot_operator",
  [sym__open_ended_range_operator] = "_open_ended_range_operator",
  [sym__is_operator] = "_is_operator",
  [sym__additive_operator] = "_additive_operator",
  [sym__multiplicative_operator] = "_multiplicative_operator",
  [sym_as_operator] = "as_operator",
  [sym__prefix_unary_operator] = "_prefix_unary_operator",
  [sym__bitwise_binary_operator] = "_bitwise_binary_operator",
  [sym__postfix_unary_operator] = "_postfix_unary_operator",
  [sym_directly_assignable_expression] = "directly_assignable_expression",
  [sym_statements] = "statements",
  [sym__local_statement] = "_local_statement",
  [sym__top_level_statement] = "_top_level_statement",
  [sym__block] = "_block",
  [sym__labeled_statement] = "_labeled_statement",
  [sym_for_statement] = "for_statement",
  [sym__for_statement_collection] = "_for_statement_collection",
  [sym_for_statement_await] = "await_expression",
  [sym_while_statement] = "while_statement",
  [sym_repeat_while_statement] = "repeat_while_statement",
  [sym_control_transfer_statement] = "control_transfer_statement",
  [sym__throw_statement] = "_throw_statement",
  [sym__optionally_valueful_control_keyword] = "_optionally_valueful_control_keyword",
  [sym_assignment] = "assignment",
  [sym_value_parameter_pack] = "value_parameter_pack",
  [sym_value_pack_expansion] = "value_pack_expansion",
  [sym_availability_condition] = "availability_condition",
  [sym__availability_argument] = "_availability_argument",
  [sym__global_declaration] = "_global_declaration",
  [sym__type_level_declaration] = "_type_level_declaration",
  [sym__local_declaration] = "_local_declaration",
  [sym__local_property_declaration] = "property_declaration",
  [sym__local_typealias_declaration] = "typealias_declaration",
  [sym__local_function_declaration] = "function_declaration",
  [sym__local_class_declaration] = "class_declaration",
  [sym_import_declaration] = "import_declaration",
  [sym__import_kind] = "_import_kind",
  [sym_protocol_property_declaration] = "protocol_property_declaration",
  [sym_protocol_property_requirements] = "protocol_property_requirements",
  [sym_property_declaration] = "property_declaration",
  [sym__modifierless_property_declaration] = "_modifierless_property_declaration",
  [sym__single_modifierless_property_declaration] = "_single_modifierless_property_declaration",
  [sym__expression_with_willset_didset] = "_expression_with_willset_didset",
  [sym__expression_without_willset_didset] = "_expression_without_willset_didset",
  [sym_willset_didset_block] = "willset_didset_block",
  [sym_willset_clause] = "willset_clause",
  [sym_didset_clause] = "didset_clause",
  [sym_typealias_declaration] = "typealias_declaration",
  [sym__modifierless_typealias_declaration] = "_modifierless_typealias_declaration",
  [sym_function_declaration] = "function_declaration",
  [sym__modifierless_function_declaration] = "_modifierless_function_declaration",
  [sym__bodyless_function_declaration] = "_bodyless_function_declaration",
  [sym__modifierless_function_declaration_no_body] = "_modifierless_function_declaration_no_body",
  [sym_function_body] = "function_body",
  [sym_macro_declaration] = "macro_declaration",
  [sym__macro_head] = "_macro_head",
  [sym__macro_signature] = "_macro_signature",
  [sym_macro_definition] = "macro_definition",
  [sym_external_macro_definition] = "external_macro_definition",
  [sym_class_declaration] = "class_declaration",
  [sym__modifierless_class_declaration] = "_modifierless_class_declaration",
  [sym_class_body] = "class_body",
  [sym__inheritance_specifiers] = "_inheritance_specifiers",
  [sym_inheritance_specifier] = "inheritance_specifier",
  [sym__annotated_inheritance_specifier] = "_annotated_inheritance_specifier",
  [sym_type_parameters] = "type_parameters",
  [sym_type_parameter] = "type_parameter",
  [sym__type_parameter_possibly_packed] = "_type_parameter_possibly_packed",
  [sym_type_constraints] = "type_constraints",
  [sym_type_constraint] = "type_constraint",
  [sym_inheritance_constraint] = "inheritance_constraint",
  [sym_equality_constraint] = "equality_constraint",
  [sym__constrained_type] = "_constrained_type",
  [sym__class_member_separator] = "_class_member_separator",
  [sym__class_member_declarations] = "_class_member_declarations",
  [aux_sym__function_value_parameters] = "_function_value_parameters",
  [sym__function_value_parameter] = "_function_value_parameter",
  [sym_parameter] = "parameter",
  [sym__non_constructor_function_decl] = "_non_constructor_function_decl",
  [sym__referenceable_operator] = "_referenceable_operator",
  [sym__equal_sign] = "_equal_sign",
  [sym__eq_eq] = "_eq_eq",
  [sym__dot] = "_dot",
  [sym__arrow_operator] = "_arrow_operator",
  [sym__conjunction_operator] = "_conjunction_operator",
  [sym__disjunction_operator] = "_disjunction_operator",
  [sym__nil_coalescing_operator] = "_nil_coalescing_operator",
  [sym__as] = "_as",
  [sym__as_quest] = "_as_quest",
  [sym__as_bang] = "_as_bang",
  [sym_bang] = "bang",
  [sym__async_keyword] = "_async_keyword",
  [sym__async_modifier] = "_async_modifier",
  [sym_throws] = "throws",
  [sym_enum_class_body] = "enum_class_body",
  [sym_enum_entry] = "enum_entry",
  [sym__enum_entry_suffix] = "_enum_entry_suffix",
  [sym_enum_type_parameters] = "enum_type_parameters",
  [sym_protocol_declaration] = "protocol_declaration",
  [sym_protocol_body] = "protocol_body",
  [sym__protocol_member_declarations] = "_protocol_member_declarations",
  [sym__protocol_member_declaration] = "_protocol_member_declaration",
  [sym_init_declaration] = "init_declaration",
  [sym_deinit_declaration] = "deinit_declaration",
  [sym_subscript_declaration] = "subscript_declaration",
  [sym_computed_property] = "computed_property",
  [sym_computed_getter] = "computed_getter",
  [sym_computed_modify] = "computed_modify",
  [sym_computed_setter] = "computed_setter",
  [sym_getter_specifier] = "getter_specifier",
  [sym_setter_specifier] = "setter_specifier",
  [sym_modify_specifier] = "modify_specifier",
  [aux_sym__getter_effects] = "_getter_effects",
  [sym_operator_declaration] = "operator_declaration",
  [sym_deprecated_operator_declaration_body] = "deprecated_operator_declaration_body",
  [sym_precedence_group_declaration] = "precedence_group_declaration",
  [sym_precedence_group_attributes] = "precedence_group_attributes",
  [sym_precedence_group_attribute] = "precedence_group_attribute",
  [sym_associatedtype_declaration] = "associatedtype_declaration",
  [sym_attribute] = "attribute",
  [sym__attribute_argument] = "_attribute_argument",
  [sym__universally_allowed_pattern] = "_universally_allowed_pattern",
  [sym__bound_identifier] = "_bound_identifier",
  [sym__binding_pattern_no_expr] = "_binding_pattern_no_expr",
  [sym__no_expr_pattern_already_bound] = "_no_expr_pattern_already_bound",
  [sym__binding_pattern_with_expr] = "pattern",
  [sym__direct_or_indirect_binding] = "_direct_or_indirect_binding",
  [sym_value_binding_pattern] = "value_binding_pattern",
  [sym__possibly_async_binding_pattern_kind] = "_possibly_async_binding_pattern_kind",
  [sym__binding_kind_and_pattern] = "_binding_kind_and_pattern",
  [sym__tuple_pattern_item] = "_tuple_pattern_item",
  [sym__tuple_pattern] = "_tuple_pattern",
  [sym__case_pattern] = "_case_pattern",
  [sym__type_casting_pattern] = "_type_casting_pattern",
  [sym__binding_pattern] = "_binding_pattern",
  [sym_modifiers] = "modifiers",
  [aux_sym__locally_permitted_modifiers] = "_locally_permitted_modifiers",
  [sym_parameter_modifiers] = "parameter_modifiers",
  [sym__non_local_scope_modifier] = "_non_local_scope_modifier",
  [sym__locally_permitted_modifier] = "_locally_permitted_modifier",
  [sym_property_behavior_modifier] = "property_behavior_modifier",
  [sym_type_modifiers] = "type_modifiers",
  [sym_member_modifier] = "member_modifier",
  [sym_visibility_modifier] = "visibility_modifier",
  [sym_type_parameter_modifiers] = "type_parameter_modifiers",
  [sym_function_modifier] = "function_modifier",
  [sym_mutation_modifier] = "mutation_modifier",
  [sym_property_modifier] = "property_modifier",
  [sym_inheritance_modifier] = "inheritance_modifier",
  [sym_parameter_modifier] = "parameter_modifier",
  [sym_ownership_modifier] = "ownership_modifier",
  [sym__parameter_ownership_modifier] = "_parameter_ownership_modifier",
  [aux_sym_source_file_repeat1] = "source_file_repeat1",
  [aux_sym_identifier_repeat1] = "identifier_repeat1",
  [aux_sym_line_string_literal_repeat1] = "line_string_literal_repeat1",
  [aux_sym_multi_line_string_literal_repeat1] = "multi_line_string_literal_repeat1",
  [aux_sym_raw_string_literal_repeat1] = "raw_string_literal_repeat1",
  [aux_sym__interpolation_contents_repeat1] = "_interpolation_contents_repeat1",
  [aux_sym_user_type_repeat1] = "user_type_repeat1",
  [aux_sym_tuple_type_repeat1] = "tuple_type_repeat1",
  [aux_sym_optional_type_repeat1] = "optional_type_repeat1",
  [aux_sym_protocol_composition_type_repeat1] = "protocol_composition_type_repeat1",
  [aux_sym__constructor_value_arguments_repeat1] = "_constructor_value_arguments_repeat1",
  [aux_sym__fn_call_lambda_arguments_repeat1] = "_fn_call_lambda_arguments_repeat1",
  [aux_sym_type_arguments_repeat1] = "type_arguments_repeat1",
  [aux_sym_value_argument_repeat1] = "value_argument_repeat1",
  [aux_sym_tuple_expression_repeat1] = "tuple_expression_repeat1",
  [aux_sym_array_literal_repeat1] = "array_literal_repeat1",
  [aux_sym_dictionary_literal_repeat1] = "dictionary_literal_repeat1",
  [aux_sym__playground_literal_repeat1] = "_playground_literal_repeat1",
  [aux_sym__lambda_type_declaration_repeat1] = "_lambda_type_declaration_repeat1",
  [aux_sym_capture_list_repeat1] = "capture_list_repeat1",
  [aux_sym_lambda_function_type_parameters_repeat1] = "lambda_function_type_parameters_repeat1",
  [aux_sym_if_statement_repeat1] = "if_statement_repeat1",
  [aux_sym_switch_statement_repeat1] = "switch_statement_repeat1",
  [aux_sym_switch_entry_repeat1] = "switch_entry_repeat1",
  [aux_sym_do_statement_repeat1] = "do_statement_repeat1",
  [aux_sym_key_path_expression_repeat1] = "key_path_expression_repeat1",
  [aux_sym__key_path_component_repeat1] = "_key_path_component_repeat1",
  [aux_sym_statements_repeat1] = "statements_repeat1",
  [aux_sym_repeat_while_statement_repeat1] = "repeat_while_statement_repeat1",
  [aux_sym_availability_condition_repeat1] = "availability_condition_repeat1",
  [aux_sym__availability_argument_repeat1] = "_availability_argument_repeat1",
  [aux_sym_protocol_property_requirements_repeat1] = "protocol_property_requirements_repeat1",
  [aux_sym__modifierless_property_declaration_repeat1] = "_modifierless_property_declaration_repeat1",
  [aux_sym__inheritance_specifiers_repeat1] = "_inheritance_specifiers_repeat1",
  [aux_sym_type_parameters_repeat1] = "type_parameters_repeat1",
  [aux_sym_type_constraints_repeat1] = "type_constraints_repeat1",
  [aux_sym__constrained_type_repeat1] = "_constrained_type_repeat1",
  [aux_sym__class_member_declarations_repeat1] = "_class_member_declarations_repeat1",
  [aux_sym__function_value_parameters_repeat1] = "_function_value_parameters_repeat1",
  [aux_sym_enum_class_body_repeat1] = "enum_class_body_repeat1",
  [aux_sym_enum_entry_repeat1] = "enum_entry_repeat1",
  [aux_sym_enum_type_parameters_repeat1] = "enum_type_parameters_repeat1",
  [aux_sym__protocol_member_declarations_repeat1] = "_protocol_member_declarations_repeat1",
  [aux_sym_computed_property_repeat1] = "computed_property_repeat1",
  [aux_sym_deprecated_operator_declaration_body_repeat1] = "deprecated_operator_declaration_body_repeat1",
  [aux_sym_precedence_group_attributes_repeat1] = "precedence_group_attributes_repeat1",
  [aux_sym_attribute_repeat1] = "attribute_repeat1",
  [aux_sym__attribute_argument_repeat1] = "_attribute_argument_repeat1",
  [aux_sym__attribute_argument_repeat2] = "_attribute_argument_repeat2",
  [aux_sym__tuple_pattern_repeat1] = "_tuple_pattern_repeat1",
  [aux_sym_modifiers_repeat1] = "modifiers_repeat1",
  [aux_sym_parameter_modifiers_repeat1] = "parameter_modifiers_repeat1",
  [alias_sym__expression] = "_expression",
  [alias_sym_fully_open_range] = "fully_open_range",
  [alias_sym_interpolated_expression] = "interpolated_expression",
  [alias_sym_protocol_function_declaration] = "protocol_function_declaration",
  [alias_sym_type_identifier] = "type_identifier",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [anon_sym_POUND_BANG] = anon_sym_POUND_BANG,
  [aux_sym_shebang_line_token1] = aux_sym_shebang_line_token1,
  [sym_comment] = sym_comment,
  [aux_sym_simple_identifier_token1] = aux_sym_simple_identifier_token1,
  [aux_sym_simple_identifier_token2] = aux_sym_simple_identifier_token2,
  [aux_sym_simple_identifier_token3] = aux_sym_simple_identifier_token3,
  [aux_sym_simple_identifier_token4] = aux_sym_simple_identifier_token4,
  [anon_sym_actor] = anon_sym_actor,
  [anon_sym_async] = anon_sym_async,
  [anon_sym_each] = anon_sym_each,
  [anon_sym_lazy] = anon_sym_lazy,
  [anon_sym_repeat] = anon_sym_repeat,
  [anon_sym_package] = anon_sym_package,
  [anon_sym_nil] = anon_sym_nil,
  [sym_real_literal] = sym_real_literal,
  [sym_integer_literal] = sym_integer_literal,
  [sym_hex_literal] = sym_hex_literal,
  [sym_oct_literal] = sym_oct_literal,
  [sym_bin_literal] = sym_bin_literal,
  [anon_sym_true] = anon_sym_true,
  [anon_sym_false] = anon_sym_false,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [aux_sym_line_str_text_token1] = aux_sym_line_str_text_token1,
  [anon_sym_BSLASH] = anon_sym_BSLASH,
  [anon_sym_u] = anon_sym_u,
  [aux_sym__uni_character_literal_token1] = aux_sym__uni_character_literal_token1,
  [anon_sym_DQUOTE_DQUOTE_DQUOTE] = anon_sym_DQUOTE_DQUOTE_DQUOTE,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [sym_raw_str_interpolation_start] = sym_raw_str_interpolation_start,
  [anon_sym_BSLASH_LPAREN] = anon_sym_BSLASH_LPAREN,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [sym__escaped_identifier] = sym__escaped_identifier,
  [sym__extended_regex_literal] = sym__extended_regex_literal,
  [aux_sym__multiline_regex_literal_token1] = aux_sym__multiline_regex_literal_token1,
  [aux_sym__multiline_regex_literal_token2] = aux_sym__multiline_regex_literal_token2,
  [sym__oneline_regex_literal] = sym__oneline_regex_literal,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_Type] = anon_sym_Type,
  [anon_sym_Protocol] = anon_sym_Protocol,
  [anon_sym_QMARK] = anon_sym_QMARK,
  [anon_sym_QMARK2] = anon_sym_QMARK,
  [anon_sym_some] = anon_sym_some,
  [anon_sym_any] = anon_sym_any,
  [anon_sym_AMP] = anon_sym_AMP,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_switch] = anon_sym_switch,
  [anon_sym_POUNDselector] = anon_sym_POUNDselector,
  [anon_sym_getter_COLON] = anon_sym_getter_COLON,
  [anon_sym_setter_COLON] = anon_sym_setter_COLON,
  [aux_sym_custom_operator_token1] = aux_sym_custom_operator_token1,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_await] = anon_sym_await,
  [anon_sym_POUNDfile] = anon_sym_POUNDfile,
  [anon_sym_POUNDfileID] = anon_sym_POUNDfileID,
  [anon_sym_POUNDfilePath] = anon_sym_POUNDfilePath,
  [anon_sym_POUNDline] = anon_sym_POUNDline,
  [anon_sym_POUNDcolumn] = anon_sym_POUNDcolumn,
  [anon_sym_POUNDfunction] = anon_sym_POUNDfunction,
  [anon_sym_POUNDdsohandle] = anon_sym_POUNDdsohandle,
  [anon_sym_POUNDcolorLiteral] = anon_sym_POUNDcolorLiteral,
  [anon_sym_POUNDfileLiteral] = anon_sym_POUNDfileLiteral,
  [anon_sym_POUNDimageLiteral] = anon_sym_POUNDimageLiteral,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_CARET_LBRACE] = anon_sym_CARET_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_in] = anon_sym_in,
  [anon_sym_self] = anon_sym_self,
  [anon_sym_super] = anon_sym_super,
  [anon_sym_guard] = anon_sym_guard,
  [anon_sym_case] = anon_sym_case,
  [anon_sym_fallthrough] = anon_sym_fallthrough,
  [anon_sym_do] = anon_sym_do,
  [anon_sym_POUNDkeyPath] = anon_sym_POUNDkeyPath,
  [anon_sym_try] = anon_sym_try,
  [anon_sym_PLUS_EQ] = anon_sym_PLUS_EQ,
  [anon_sym_DASH_EQ] = anon_sym_DASH_EQ,
  [anon_sym_STAR_EQ] = anon_sym_STAR_EQ,
  [anon_sym_SLASH_EQ] = anon_sym_SLASH_EQ,
  [anon_sym_PERCENT_EQ] = anon_sym_PERCENT_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_BANG_EQ_EQ] = anon_sym_BANG_EQ_EQ,
  [anon_sym_EQ_EQ_EQ] = anon_sym_EQ_EQ_EQ,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_DOT_DOT_DOT] = anon_sym_DOT_DOT_DOT,
  [anon_sym_DOT_DOT_LT] = anon_sym_DOT_DOT_LT,
  [anon_sym_is] = anon_sym_is,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_PLUS_PLUS] = anon_sym_PLUS_PLUS,
  [anon_sym_DASH_DASH] = anon_sym_DASH_DASH,
  [anon_sym_TILDE] = anon_sym_TILDE,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_LT_LT] = anon_sym_LT_LT,
  [anon_sym_GT_GT] = anon_sym_GT_GT,
  [sym_statement_label] = sym_statement_label,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_while] = anon_sym_while,
  [sym_throw_keyword] = sym_throw_keyword,
  [anon_sym_return] = anon_sym_return,
  [anon_sym_continue] = anon_sym_continue,
  [anon_sym_break] = anon_sym_break,
  [anon_sym_yield] = anon_sym_yield,
  [anon_sym_POUNDavailable] = anon_sym_POUNDavailable,
  [anon_sym_POUNDunavailable] = anon_sym_POUNDunavailable,
  [anon_sym_import] = anon_sym_import,
  [anon_sym_typealias] = anon_sym_typealias,
  [anon_sym_struct] = anon_sym_struct,
  [anon_sym_class] = anon_sym_class,
  [anon_sym_enum] = anon_sym_enum,
  [anon_sym_protocol] = anon_sym_protocol,
  [anon_sym_let] = anon_sym_let,
  [anon_sym_var] = anon_sym_var,
  [anon_sym_func] = anon_sym_func,
  [anon_sym_willSet] = anon_sym_willSet,
  [anon_sym_didSet] = anon_sym_didSet,
  [anon_sym_macro] = anon_sym_macro,
  [anon_sym_POUNDexternalMacro] = anon_sym_POUNDexternalMacro,
  [anon_sym_extension] = anon_sym_extension,
  [anon_sym_indirect] = anon_sym_indirect,
  [anon_sym_BANG2] = anon_sym_BANG,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_init] = anon_sym_init,
  [anon_sym_deinit] = anon_sym_deinit,
  [anon_sym_subscript] = anon_sym_subscript,
  [anon_sym_get] = anon_sym_get,
  [anon_sym_set] = anon_sym_set,
  [anon_sym__modify] = anon_sym__modify,
  [anon_sym_prefix] = anon_sym_prefix,
  [anon_sym_infix] = anon_sym_infix,
  [anon_sym_postfix] = anon_sym_postfix,
  [anon_sym_operator] = anon_sym_operator,
  [anon_sym_precedencegroup] = anon_sym_precedencegroup,
  [anon_sym_associatedtype] = anon_sym_associatedtype,
  [anon_sym_AT] = anon_sym_AT,
  [sym_wildcard_pattern] = sym_wildcard_pattern,
  [anon_sym_override] = anon_sym_override,
  [anon_sym_convenience] = anon_sym_convenience,
  [anon_sym_required] = anon_sym_required,
  [anon_sym_nonisolated] = anon_sym_nonisolated,
  [anon_sym_public] = anon_sym_public,
  [anon_sym_private] = anon_sym_private,
  [anon_sym_internal] = anon_sym_internal,
  [anon_sym_fileprivate] = anon_sym_fileprivate,
  [anon_sym_open] = anon_sym_open,
  [anon_sym_mutating] = anon_sym_mutating,
  [anon_sym_nonmutating] = anon_sym_nonmutating,
  [anon_sym_static] = anon_sym_static,
  [anon_sym_dynamic] = anon_sym_dynamic,
  [anon_sym_optional] = anon_sym_optional,
  [anon_sym_distributed] = anon_sym_distributed,
  [anon_sym_final] = anon_sym_final,
  [anon_sym_inout] = anon_sym_inout,
  [anon_sym_ATescaping] = anon_sym_ATescaping,
  [anon_sym_ATautoclosure] = anon_sym_ATautoclosure,
  [anon_sym_weak] = anon_sym_weak,
  [anon_sym_unowned] = anon_sym_unowned,
  [anon_sym_unowned_LPARENsafe_RPAREN] = anon_sym_unowned_LPARENsafe_RPAREN,
  [anon_sym_unowned_LPARENunsafe_RPAREN] = anon_sym_unowned_LPARENunsafe_RPAREN,
  [anon_sym_borrowing] = anon_sym_borrowing,
  [anon_sym_consuming] = anon_sym_consuming,
  [anon_sym_property] = anon_sym_property,
  [anon_sym_receiver] = anon_sym_receiver,
  [anon_sym_param] = anon_sym_param,
  [anon_sym_setparam] = anon_sym_setparam,
  [anon_sym_delegate] = anon_sym_delegate,
  [sym_directive] = sym_directive,
  [sym_diagnostic] = sym_diagnostic,
  [anon_sym_unused1] = anon_sym_unused1,
  [anon_sym_unused2] = anon_sym_unused2,
  [sym_multiline_comment] = sym_multiline_comment,
  [sym_raw_str_part] = sym_raw_str_part,
  [sym_raw_str_continuing_indicator] = sym_raw_str_continuing_indicator,
  [sym_raw_str_end_part] = sym_raw_str_end_part,
  [sym__implicit_semi] = sym__implicit_semi,
  [sym__explicit_semi] = sym__explicit_semi,
  [sym__arrow_operator_custom] = sym__arrow_operator_custom,
  [sym__dot_custom] = anon_sym_DOT,
  [sym__conjunction_operator_custom] = sym__conjunction_operator_custom,
  [sym__disjunction_operator_custom] = sym__disjunction_operator_custom,
  [sym__nil_coalescing_operator_custom] = sym__nil_coalescing_operator_custom,
  [sym__eq_custom] = sym__eq_custom,
  [sym__eq_eq_custom] = sym__eq_eq_custom,
  [sym__plus_then_ws] = anon_sym_PLUS,
  [sym__minus_then_ws] = anon_sym_DASH,
  [sym__bang_custom] = sym__bang_custom,
  [sym__throws_keyword] = sym__throws_keyword,
  [sym__rethrows_keyword] = sym__rethrows_keyword,
  [sym_default_keyword] = sym_default_keyword,
  [sym_where_keyword] = sym_where_keyword,
  [sym_else] = sym_else,
  [sym_catch_keyword] = sym_catch_keyword,
  [sym__as_custom] = sym__as_custom,
  [sym__as_quest_custom] = sym__as_quest_custom,
  [sym__as_bang_custom] = sym__as_bang_custom,
  [sym__async_keyword_custom] = anon_sym_async,
  [sym__custom_operator] = sym__custom_operator,
  [sym__fake_try_bang] = sym__fake_try_bang,
  [sym_source_file] = sym_source_file,
  [sym__semi] = sym__semi,
  [sym_shebang_line] = sym_shebang_line,
  [sym_simple_identifier] = sym_simple_identifier,
  [sym__contextual_simple_identifier] = sym__contextual_simple_identifier,
  [sym_identifier] = sym_identifier,
  [sym__basic_literal] = sym__basic_literal,
  [sym_boolean_literal] = sym_boolean_literal,
  [sym__string_literal] = sym__string_literal,
  [sym_line_string_literal] = sym_line_string_literal,
  [sym__line_string_content] = sym__line_string_content,
  [sym_line_str_text] = sym_line_str_text,
  [sym_str_escaped_char] = sym_str_escaped_char,
  [sym__uni_character_literal] = sym__uni_character_literal,
  [sym_multi_line_string_literal] = sym_multi_line_string_literal,
  [sym_raw_string_literal] = sym_raw_string_literal,
  [sym_raw_str_interpolation] = sym_raw_str_interpolation,
  [sym__multi_line_string_content] = sym__multi_line_string_content,
  [sym__interpolation] = sym__interpolation,
  [sym__interpolation_contents] = sym__interpolation_contents,
  [sym_multi_line_str_text] = sym_multi_line_str_text,
  [sym_regex_literal] = sym_regex_literal,
  [sym__multiline_regex_literal] = sym__multiline_regex_literal,
  [sym_type_annotation] = sym_type_annotation,
  [sym__possibly_implicitly_unwrapped_type] = sym__possibly_implicitly_unwrapped_type,
  [sym__type] = sym__type,
  [sym__unannotated_type] = sym__unannotated_type,
  [sym_user_type] = sym_user_type,
  [sym__simple_user_type] = sym__simple_user_type,
  [sym_tuple_type] = sym_tuple_type,
  [sym_tuple_type_item] = sym_tuple_type_item,
  [sym__tuple_type_item_identifier] = sym__tuple_type_item_identifier,
  [sym_function_type] = sym_function_type,
  [sym_array_type] = sym_array_type,
  [sym_dictionary_type] = sym_dictionary_type,
  [sym_optional_type] = sym_optional_type,
  [sym_metatype] = sym_metatype,
  [sym__quest] = sym__quest,
  [sym__immediate_quest] = anon_sym_QMARK,
  [sym_opaque_type] = sym_opaque_type,
  [sym_existential_type] = sym_existential_type,
  [sym_type_parameter_pack] = sym_type_parameter_pack,
  [sym_type_pack_expansion] = sym_type_pack_expansion,
  [sym_protocol_composition_type] = sym_protocol_composition_type,
  [sym__expression] = sym__expression,
  [sym__unary_expression] = sym__unary_expression,
  [sym_postfix_expression] = sym_postfix_expression,
  [sym_constructor_expression] = sym_constructor_expression,
  [sym__parenthesized_type] = sym__parenthesized_type,
  [sym_navigation_expression] = sym_navigation_expression,
  [sym__navigable_type_expression] = sym__navigable_type_expression,
  [sym_open_start_range_expression] = sym_open_start_range_expression,
  [sym__range_operator] = sym__range_operator,
  [sym_open_end_range_expression] = sym_open_end_range_expression,
  [sym_prefix_expression] = sym_prefix_expression,
  [sym_as_expression] = sym_as_expression,
  [sym_selector_expression] = sym_selector_expression,
  [sym__binary_expression] = sym__binary_expression,
  [sym_multiplicative_expression] = sym_multiplicative_expression,
  [sym_additive_expression] = sym_additive_expression,
  [sym_range_expression] = sym_range_expression,
  [sym_infix_expression] = sym_infix_expression,
  [sym_nil_coalescing_expression] = sym_nil_coalescing_expression,
  [sym_check_expression] = sym_check_expression,
  [sym_comparison_expression] = sym_comparison_expression,
  [sym_equality_expression] = sym_equality_expression,
  [sym_conjunction_expression] = sym_conjunction_expression,
  [sym_disjunction_expression] = sym_disjunction_expression,
  [sym_bitwise_operation] = sym_bitwise_operation,
  [sym_custom_operator] = sym_custom_operator,
  [sym_navigation_suffix] = sym_navigation_suffix,
  [sym_call_suffix] = sym_call_suffix,
  [sym_constructor_suffix] = sym_constructor_suffix,
  [sym__constructor_value_arguments] = sym_value_arguments,
  [sym__fn_call_lambda_arguments] = sym__fn_call_lambda_arguments,
  [sym_type_arguments] = sym_type_arguments,
  [sym_value_arguments] = sym_value_arguments,
  [sym_value_argument_label] = sym_value_argument_label,
  [sym_value_argument] = sym_value_argument,
  [sym_try_expression] = sym_try_expression,
  [sym_await_expression] = sym_await_expression,
  [sym__await_operator] = sym__await_operator,
  [sym_ternary_expression] = sym_ternary_expression,
  [sym__expr_hack_at_ternary_binary_suffix] = sym__expr_hack_at_ternary_binary_suffix,
  [sym_expr_hack_at_ternary_binary_call] = sym_call_expression,
  [sym_expr_hack_at_ternary_binary_call_suffix] = sym_call_suffix,
  [sym_call_expression] = sym_call_expression,
  [sym__primary_expression] = sym__primary_expression,
  [sym_tuple_expression] = sym_tuple_expression,
  [sym_array_literal] = sym_array_literal,
  [sym_dictionary_literal] = sym_dictionary_literal,
  [sym__dictionary_literal_item] = sym__dictionary_literal_item,
  [sym__special_literal] = sym__special_literal,
  [sym__playground_literal] = sym__playground_literal,
  [sym_lambda_literal] = sym_lambda_literal,
  [sym__lambda_type_declaration] = sym__lambda_type_declaration,
  [sym_capture_list] = sym_capture_list,
  [sym_capture_list_item] = sym_capture_list_item,
  [sym_lambda_function_type] = sym_lambda_function_type,
  [sym_lambda_function_type_parameters] = sym_lambda_function_type_parameters,
  [sym_lambda_parameter] = sym_lambda_parameter,
  [sym_self_expression] = sym_self_expression,
  [sym_super_expression] = sym_super_expression,
  [sym__else_options] = sym__else_options,
  [sym_if_statement] = sym_if_statement,
  [sym__if_condition_sequence_item] = sym__if_condition_sequence_item,
  [sym__if_let_binding] = sym__if_let_binding,
  [sym_guard_statement] = sym_guard_statement,
  [sym_switch_statement] = sym_switch_statement,
  [sym_switch_entry] = sym_switch_entry,
  [sym_switch_pattern] = sym_switch_pattern,
  [sym_do_statement] = sym_do_statement,
  [sym_catch_block] = sym_catch_block,
  [sym_where_clause] = sym_where_clause,
  [sym_key_path_expression] = sym_key_path_expression,
  [sym_key_path_string_expression] = sym_key_path_string_expression,
  [sym__key_path_component] = sym__key_path_component,
  [sym__key_path_postfixes] = sym__key_path_postfixes,
  [sym_try_operator] = sym_try_operator,
  [sym__try_operator_type] = sym__try_operator_type,
  [sym__assignment_and_operator] = sym__assignment_and_operator,
  [sym__equality_operator] = sym__equality_operator,
  [sym__comparison_operator] = sym__comparison_operator,
  [sym__three_dot_operator] = sym__three_dot_operator,
  [sym__open_ended_range_operator] = sym__open_ended_range_operator,
  [sym__is_operator] = sym__is_operator,
  [sym__additive_operator] = sym__additive_operator,
  [sym__multiplicative_operator] = sym__multiplicative_operator,
  [sym_as_operator] = sym_as_operator,
  [sym__prefix_unary_operator] = sym__prefix_unary_operator,
  [sym__bitwise_binary_operator] = sym__bitwise_binary_operator,
  [sym__postfix_unary_operator] = sym__postfix_unary_operator,
  [sym_directly_assignable_expression] = sym_directly_assignable_expression,
  [sym_statements] = sym_statements,
  [sym__local_statement] = sym__local_statement,
  [sym__top_level_statement] = sym__top_level_statement,
  [sym__block] = sym__block,
  [sym__labeled_statement] = sym__labeled_statement,
  [sym_for_statement] = sym_for_statement,
  [sym__for_statement_collection] = sym__for_statement_collection,
  [sym_for_statement_await] = sym_await_expression,
  [sym_while_statement] = sym_while_statement,
  [sym_repeat_while_statement] = sym_repeat_while_statement,
  [sym_control_transfer_statement] = sym_control_transfer_statement,
  [sym__throw_statement] = sym__throw_statement,
  [sym__optionally_valueful_control_keyword] = sym__optionally_valueful_control_keyword,
  [sym_assignment] = sym_assignment,
  [sym_value_parameter_pack] = sym_value_parameter_pack,
  [sym_value_pack_expansion] = sym_value_pack_expansion,
  [sym_availability_condition] = sym_availability_condition,
  [sym__availability_argument] = sym__availability_argument,
  [sym__global_declaration] = sym__global_declaration,
  [sym__type_level_declaration] = sym__type_level_declaration,
  [sym__local_declaration] = sym__local_declaration,
  [sym__local_property_declaration] = sym_property_declaration,
  [sym__local_typealias_declaration] = sym_typealias_declaration,
  [sym__local_function_declaration] = sym_function_declaration,
  [sym__local_class_declaration] = sym_class_declaration,
  [sym_import_declaration] = sym_import_declaration,
  [sym__import_kind] = sym__import_kind,
  [sym_protocol_property_declaration] = sym_protocol_property_declaration,
  [sym_protocol_property_requirements] = sym_protocol_property_requirements,
  [sym_property_declaration] = sym_property_declaration,
  [sym__modifierless_property_declaration] = sym__modifierless_property_declaration,
  [sym__single_modifierless_property_declaration] = sym__single_modifierless_property_declaration,
  [sym__expression_with_willset_didset] = sym__expression_with_willset_didset,
  [sym__expression_without_willset_didset] = sym__expression_without_willset_didset,
  [sym_willset_didset_block] = sym_willset_didset_block,
  [sym_willset_clause] = sym_willset_clause,
  [sym_didset_clause] = sym_didset_clause,
  [sym_typealias_declaration] = sym_typealias_declaration,
  [sym__modifierless_typealias_declaration] = sym__modifierless_typealias_declaration,
  [sym_function_declaration] = sym_function_declaration,
  [sym__modifierless_function_declaration] = sym__modifierless_function_declaration,
  [sym__bodyless_function_declaration] = sym__bodyless_function_declaration,
  [sym__modifierless_function_declaration_no_body] = sym__modifierless_function_declaration_no_body,
  [sym_function_body] = sym_function_body,
  [sym_macro_declaration] = sym_macro_declaration,
  [sym__macro_head] = sym__macro_head,
  [sym__macro_signature] = sym__macro_signature,
  [sym_macro_definition] = sym_macro_definition,
  [sym_external_macro_definition] = sym_external_macro_definition,
  [sym_class_declaration] = sym_class_declaration,
  [sym__modifierless_class_declaration] = sym__modifierless_class_declaration,
  [sym_class_body] = sym_class_body,
  [sym__inheritance_specifiers] = sym__inheritance_specifiers,
  [sym_inheritance_specifier] = sym_inheritance_specifier,
  [sym__annotated_inheritance_specifier] = sym__annotated_inheritance_specifier,
  [sym_type_parameters] = sym_type_parameters,
  [sym_type_parameter] = sym_type_parameter,
  [sym__type_parameter_possibly_packed] = sym__type_parameter_possibly_packed,
  [sym_type_constraints] = sym_type_constraints,
  [sym_type_constraint] = sym_type_constraint,
  [sym_inheritance_constraint] = sym_inheritance_constraint,
  [sym_equality_constraint] = sym_equality_constraint,
  [sym__constrained_type] = sym__constrained_type,
  [sym__class_member_separator] = sym__class_member_separator,
  [sym__class_member_declarations] = sym__class_member_declarations,
  [aux_sym__function_value_parameters] = aux_sym__function_value_parameters,
  [sym__function_value_parameter] = sym__function_value_parameter,
  [sym_parameter] = sym_parameter,
  [sym__non_constructor_function_decl] = sym__non_constructor_function_decl,
  [sym__referenceable_operator] = sym__referenceable_operator,
  [sym__equal_sign] = sym__equal_sign,
  [sym__eq_eq] = sym__eq_eq,
  [sym__dot] = sym__dot,
  [sym__arrow_operator] = sym__arrow_operator,
  [sym__conjunction_operator] = sym__conjunction_operator,
  [sym__disjunction_operator] = sym__disjunction_operator,
  [sym__nil_coalescing_operator] = sym__nil_coalescing_operator,
  [sym__as] = sym__as,
  [sym__as_quest] = sym__as_quest,
  [sym__as_bang] = sym__as_bang,
  [sym_bang] = sym_bang,
  [sym__async_keyword] = sym__async_keyword,
  [sym__async_modifier] = sym__async_modifier,
  [sym_throws] = sym_throws,
  [sym_enum_class_body] = sym_enum_class_body,
  [sym_enum_entry] = sym_enum_entry,
  [sym__enum_entry_suffix] = sym__enum_entry_suffix,
  [sym_enum_type_parameters] = sym_enum_type_parameters,
  [sym_protocol_declaration] = sym_protocol_declaration,
  [sym_protocol_body] = sym_protocol_body,
  [sym__protocol_member_declarations] = sym__protocol_member_declarations,
  [sym__protocol_member_declaration] = sym__protocol_member_declaration,
  [sym_init_declaration] = sym_init_declaration,
  [sym_deinit_declaration] = sym_deinit_declaration,
  [sym_subscript_declaration] = sym_subscript_declaration,
  [sym_computed_property] = sym_computed_property,
  [sym_computed_getter] = sym_computed_getter,
  [sym_computed_modify] = sym_computed_modify,
  [sym_computed_setter] = sym_computed_setter,
  [sym_getter_specifier] = sym_getter_specifier,
  [sym_setter_specifier] = sym_setter_specifier,
  [sym_modify_specifier] = sym_modify_specifier,
  [aux_sym__getter_effects] = aux_sym__getter_effects,
  [sym_operator_declaration] = sym_operator_declaration,
  [sym_deprecated_operator_declaration_body] = sym_deprecated_operator_declaration_body,
  [sym_precedence_group_declaration] = sym_precedence_group_declaration,
  [sym_precedence_group_attributes] = sym_precedence_group_attributes,
  [sym_precedence_group_attribute] = sym_precedence_group_attribute,
  [sym_associatedtype_declaration] = sym_associatedtype_declaration,
  [sym_attribute] = sym_attribute,
  [sym__attribute_argument] = sym__attribute_argument,
  [sym__universally_allowed_pattern] = sym__universally_allowed_pattern,
  [sym__bound_identifier] = sym__bound_identifier,
  [sym__binding_pattern_no_expr] = sym__binding_pattern_no_expr,
  [sym__no_expr_pattern_already_bound] = sym__no_expr_pattern_already_bound,
  [sym__binding_pattern_with_expr] = sym__binding_pattern_with_expr,
  [sym__direct_or_indirect_binding] = sym__direct_or_indirect_binding,
  [sym_value_binding_pattern] = sym_value_binding_pattern,
  [sym__possibly_async_binding_pattern_kind] = sym__possibly_async_binding_pattern_kind,
  [sym__binding_kind_and_pattern] = sym__binding_kind_and_pattern,
  [sym__tuple_pattern_item] = sym__tuple_pattern_item,
  [sym__tuple_pattern] = sym__tuple_pattern,
  [sym__case_pattern] = sym__case_pattern,
  [sym__type_casting_pattern] = sym__type_casting_pattern,
  [sym__binding_pattern] = sym__binding_pattern,
  [sym_modifiers] = sym_modifiers,
  [aux_sym__locally_permitted_modifiers] = aux_sym__locally_permitted_modifiers,
  [sym_parameter_modifiers] = sym_parameter_modifiers,
  [sym__non_local_scope_modifier] = sym__non_local_scope_modifier,
  [sym__locally_permitted_modifier] = sym__locally_permitted_modifier,
  [sym_property_behavior_modifier] = sym_property_behavior_modifier,
  [sym_type_modifiers] = sym_type_modifiers,
  [sym_member_modifier] = sym_member_modifier,
  [sym_visibility_modifier] = sym_visibility_modifier,
  [sym_type_parameter_modifiers] = sym_type_parameter_modifiers,
  [sym_function_modifier] = sym_function_modifier,
  [sym_mutation_modifier] = sym_mutation_modifier,
  [sym_property_modifier] = sym_property_modifier,
  [sym_inheritance_modifier] = sym_inheritance_modifier,
  [sym_parameter_modifier] = sym_parameter_modifier,
  [sym_ownership_modifier] = sym_ownership_modifier,
  [sym__parameter_ownership_modifier] = sym__parameter_ownership_modifier,
  [aux_sym_source_file_repeat1] = aux_sym_source_file_repeat1,
  [aux_sym_identifier_repeat1] = aux_sym_identifier_repeat1,
  [aux_sym_line_string_literal_repeat1] = aux_sym_line_string_literal_repeat1,
  [aux_sym_multi_line_string_literal_repeat1] = aux_sym_multi_line_string_literal_repeat1,
  [aux_sym_raw_string_literal_repeat1] = aux_sym_raw_string_literal_repeat1,
  [aux_sym__interpolation_contents_repeat1] = aux_sym__interpolation_contents_repeat1,
  [aux_sym_user_type_repeat1] = aux_sym_user_type_repeat1,
  [aux_sym_tuple_type_repeat1] = aux_sym_tuple_type_repeat1,
  [aux_sym_optional_type_repeat1] = aux_sym_optional_type_repeat1,
  [aux_sym_protocol_composition_type_repeat1] = aux_sym_protocol_composition_type_repeat1,
  [aux_sym__constructor_value_arguments_repeat1] = aux_sym__constructor_value_arguments_repeat1,
  [aux_sym__fn_call_lambda_arguments_repeat1] = aux_sym__fn_call_lambda_arguments_repeat1,
  [aux_sym_type_arguments_repeat1] = aux_sym_type_arguments_repeat1,
  [aux_sym_value_argument_repeat1] = aux_sym_value_argument_repeat1,
  [aux_sym_tuple_expression_repeat1] = aux_sym_tuple_expression_repeat1,
  [aux_sym_array_literal_repeat1] = aux_sym_array_literal_repeat1,
  [aux_sym_dictionary_literal_repeat1] = aux_sym_dictionary_literal_repeat1,
  [aux_sym__playground_literal_repeat1] = aux_sym__playground_literal_repeat1,
  [aux_sym__lambda_type_declaration_repeat1] = aux_sym__lambda_type_declaration_repeat1,
  [aux_sym_capture_list_repeat1] = aux_sym_capture_list_repeat1,
  [aux_sym_lambda_function_type_parameters_repeat1] = aux_sym_lambda_function_type_parameters_repeat1,
  [aux_sym_if_statement_repeat1] = aux_sym_if_statement_repeat1,
  [aux_sym_switch_statement_repeat1] = aux_sym_switch_statement_repeat1,
  [aux_sym_switch_entry_repeat1] = aux_sym_switch_entry_repeat1,
  [aux_sym_do_statement_repeat1] = aux_sym_do_statement_repeat1,
  [aux_sym_key_path_expression_repeat1] = aux_sym_key_path_expression_repeat1,
  [aux_sym__key_path_component_repeat1] = aux_sym__key_path_component_repeat1,
  [aux_sym_statements_repeat1] = aux_sym_statements_repeat1,
  [aux_sym_repeat_while_statement_repeat1] = aux_sym_repeat_while_statement_repeat1,
  [aux_sym_availability_condition_repeat1] = aux_sym_availability_condition_repeat1,
  [aux_sym__availability_argument_repeat1] = aux_sym__availability_argument_repeat1,
  [aux_sym_protocol_property_requirements_repeat1] = aux_sym_protocol_property_requirements_repeat1,
  [aux_sym__modifierless_property_declaration_repeat1] = aux_sym__modifierless_property_declaration_repeat1,
  [aux_sym__inheritance_specifiers_repeat1] = aux_sym__inheritance_specifiers_repeat1,
  [aux_sym_type_parameters_repeat1] = aux_sym_type_parameters_repeat1,
  [aux_sym_type_constraints_repeat1] = aux_sym_type_constraints_repeat1,
  [aux_sym__constrained_type_repeat1] = aux_sym__constrained_type_repeat1,
  [aux_sym__class_member_declarations_repeat1] = aux_sym__class_member_declarations_repeat1,
  [aux_sym__function_value_parameters_repeat1] = aux_sym__function_value_parameters_repeat1,
  [aux_sym_enum_class_body_repeat1] = aux_sym_enum_class_body_repeat1,
  [aux_sym_enum_entry_repeat1] = aux_sym_enum_entry_repeat1,
  [aux_sym_enum_type_parameters_repeat1] = aux_sym_enum_type_parameters_repeat1,
  [aux_sym__protocol_member_declarations_repeat1] = aux_sym__protocol_member_declarations_repeat1,
  [aux_sym_computed_property_repeat1] = aux_sym_computed_property_repeat1,
  [aux_sym_deprecated_operator_declaration_body_repeat1] = aux_sym_deprecated_operator_declaration_body_repeat1,
  [aux_sym_precedence_group_attributes_repeat1] = aux_sym_precedence_group_attributes_repeat1,
  [aux_sym_attribute_repeat1] = aux_sym_attribute_repeat1,
  [aux_sym__attribute_argument_repeat1] = aux_sym__attribute_argument_repeat1,
  [aux_sym__attribute_argument_repeat2] = aux_sym__attribute_argument_repeat2,
  [aux_sym__tuple_pattern_repeat1] = aux_sym__tuple_pattern_repeat1,
  [aux_sym_modifiers_repeat1] = aux_sym_modifiers_repeat1,
  [aux_sym_parameter_modifiers_repeat1] = aux_sym_parameter_modifiers_repeat1,
  [alias_sym__expression] = alias_sym__expression,
  [alias_sym_fully_open_range] = alias_sym_fully_open_range,
  [alias_sym_interpolated_expression] = alias_sym_interpolated_expression,
  [alias_sym_protocol_function_declaration] = alias_sym_protocol_function_declaration,
  [alias_sym_type_identifier] = alias_sym_type_identifier,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_POUND_BANG] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_shebang_line_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_simple_identifier_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_simple_identifier_token2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_simple_identifier_token3] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_simple_identifier_token4] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_actor] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_async] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_each] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_lazy] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_repeat] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_package] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_nil] = {
    .visible = true,
    .named = false,
  },
  [sym_real_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_integer_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_hex_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_oct_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_bin_literal] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_true] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_false] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_line_str_text_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_BSLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__uni_character_literal_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_DQUOTE_DQUOTE_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [sym_raw_str_interpolation_start] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_BSLASH_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [sym__escaped_identifier] = {
    .visible = false,
    .named = true,
  },
  [sym__extended_regex_literal] = {
    .visible = false,
    .named = true,
  },
  [aux_sym__multiline_regex_literal_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__multiline_regex_literal_token2] = {
    .visible = false,
    .named = false,
  },
  [sym__oneline_regex_literal] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_Type] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_Protocol] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_some] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_any] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_switch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUNDselector] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_getter_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_setter_COLON] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_custom_operator_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_await] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUNDfile] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUNDfileID] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUNDfilePath] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUNDline] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUNDcolumn] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUNDfunction] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUNDdsohandle] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUNDcolorLiteral] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUNDfileLiteral] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUNDimageLiteral] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_in] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_self] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_super] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_guard] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_case] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_fallthrough] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_do] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUNDkeyPath] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_try] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_DOT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_is] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [sym_statement_label] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_while] = {
    .visible = true,
    .named = false,
  },
  [sym_throw_keyword] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_return] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_continue] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_break] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_yield] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUNDavailable] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUNDunavailable] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_import] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_typealias] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_struct] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_class] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_enum] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_protocol] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_let] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_var] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_func] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_willSet] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_didSet] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_macro] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUNDexternalMacro] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_extension] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_indirect] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_init] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_deinit] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_subscript] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_get] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_set] = {
    .visible = true,
    .named = false,
  },
  [anon_sym__modify] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_prefix] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_infix] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_postfix] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_operator] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_precedencegroup] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_associatedtype] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [sym_wildcard_pattern] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_override] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_convenience] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_required] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_nonisolated] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_public] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_private] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_internal] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_fileprivate] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_open] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_mutating] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_nonmutating] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_static] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_dynamic] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_optional] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_distributed] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_final] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_inout] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ATescaping] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ATautoclosure] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_weak] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_unowned] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_unowned_LPARENsafe_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_unowned_LPARENunsafe_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_borrowing] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_consuming] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_property] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_receiver] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_param] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_setparam] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_delegate] = {
    .visible = true,
    .named = false,
  },
  [sym_directive] = {
    .visible = true,
    .named = true,
  },
  [sym_diagnostic] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_unused1] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_unused2] = {
    .visible = true,
    .named = false,
  },
  [sym_multiline_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_raw_str_part] = {
    .visible = true,
    .named = true,
  },
  [sym_raw_str_continuing_indicator] = {
    .visible = true,
    .named = true,
  },
  [sym_raw_str_end_part] = {
    .visible = true,
    .named = true,
  },
  [sym__implicit_semi] = {
    .visible = false,
    .named = true,
  },
  [sym__explicit_semi] = {
    .visible = false,
    .named = true,
  },
  [sym__arrow_operator_custom] = {
    .visible = true,
    .named = false,
  },
  [sym__dot_custom] = {
    .visible = true,
    .named = false,
  },
  [sym__conjunction_operator_custom] = {
    .visible = true,
    .named = false,
  },
  [sym__disjunction_operator_custom] = {
    .visible = true,
    .named = false,
  },
  [sym__nil_coalescing_operator_custom] = {
    .visible = true,
    .named = false,
  },
  [sym__eq_custom] = {
    .visible = true,
    .named = false,
  },
  [sym__eq_eq_custom] = {
    .visible = true,
    .named = false,
  },
  [sym__plus_then_ws] = {
    .visible = true,
    .named = false,
  },
  [sym__minus_then_ws] = {
    .visible = true,
    .named = false,
  },
  [sym__bang_custom] = {
    .visible = false,
    .named = true,
  },
  [sym__throws_keyword] = {
    .visible = false,
    .named = true,
  },
  [sym__rethrows_keyword] = {
    .visible = false,
    .named = true,
  },
  [sym_default_keyword] = {
    .visible = true,
    .named = true,
  },
  [sym_where_keyword] = {
    .visible = true,
    .named = true,
  },
  [sym_else] = {
    .visible = true,
    .named = true,
  },
  [sym_catch_keyword] = {
    .visible = true,
    .named = true,
  },
  [sym__as_custom] = {
    .visible = true,
    .named = false,
  },
  [sym__as_quest_custom] = {
    .visible = true,
    .named = false,
  },
  [sym__as_bang_custom] = {
    .visible = true,
    .named = false,
  },
  [sym__async_keyword_custom] = {
    .visible = true,
    .named = false,
  },
  [sym__custom_operator] = {
    .visible = false,
    .named = true,
  },
  [sym__fake_try_bang] = {
    .visible = false,
    .named = true,
  },
  [sym_source_file] = {
    .visible = true,
    .named = true,
  },
  [sym__semi] = {
    .visible = false,
    .named = true,
  },
  [sym_shebang_line] = {
    .visible = true,
    .named = true,
  },
  [sym_simple_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym__contextual_simple_identifier] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym__basic_literal] = {
    .visible = false,
    .named = true,
  },
  [sym_boolean_literal] = {
    .visible = true,
    .named = true,
  },
  [sym__string_literal] = {
    .visible = false,
    .named = true,
  },
  [sym_line_string_literal] = {
    .visible = true,
    .named = true,
  },
  [sym__line_string_content] = {
    .visible = false,
    .named = true,
  },
  [sym_line_str_text] = {
    .visible = true,
    .named = true,
  },
  [sym_str_escaped_char] = {
    .visible = true,
    .named = true,
  },
  [sym__uni_character_literal] = {
    .visible = false,
    .named = true,
  },
  [sym_multi_line_string_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_raw_string_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_raw_str_interpolation] = {
    .visible = true,
    .named = true,
  },
  [sym__multi_line_string_content] = {
    .visible = false,
    .named = true,
  },
  [sym__interpolation] = {
    .visible = false,
    .named = true,
  },
  [sym__interpolation_contents] = {
    .visible = false,
    .named = true,
  },
  [sym_multi_line_str_text] = {
    .visible = true,
    .named = true,
  },
  [sym_regex_literal] = {
    .visible = true,
    .named = true,
  },
  [sym__multiline_regex_literal] = {
    .visible = false,
    .named = true,
  },
  [sym_type_annotation] = {
    .visible = true,
    .named = true,
  },
  [sym__possibly_implicitly_unwrapped_type] = {
    .visible = false,
    .named = true,
  },
  [sym__type] = {
    .visible = false,
    .named = true,
  },
  [sym__unannotated_type] = {
    .visible = false,
    .named = true,
  },
  [sym_user_type] = {
    .visible = true,
    .named = true,
  },
  [sym__simple_user_type] = {
    .visible = false,
    .named = true,
  },
  [sym_tuple_type] = {
    .visible = true,
    .named = true,
  },
  [sym_tuple_type_item] = {
    .visible = true,
    .named = true,
  },
  [sym__tuple_type_item_identifier] = {
    .visible = false,
    .named = true,
  },
  [sym_function_type] = {
    .visible = true,
    .named = true,
  },
  [sym_array_type] = {
    .visible = true,
    .named = true,
  },
  [sym_dictionary_type] = {
    .visible = true,
    .named = true,
  },
  [sym_optional_type] = {
    .visible = true,
    .named = true,
  },
  [sym_metatype] = {
    .visible = true,
    .named = true,
  },
  [sym__quest] = {
    .visible = false,
    .named = true,
  },
  [sym__immediate_quest] = {
    .visible = true,
    .named = false,
  },
  [sym_opaque_type] = {
    .visible = true,
    .named = true,
  },
  [sym_existential_type] = {
    .visible = true,
    .named = true,
  },
  [sym_type_parameter_pack] = {
    .visible = true,
    .named = true,
  },
  [sym_type_pack_expansion] = {
    .visible = true,
    .named = true,
  },
  [sym_protocol_composition_type] = {
    .visible = true,
    .named = true,
  },
  [sym__expression] = {
    .visible = false,
    .named = true,
  },
  [sym__unary_expression] = {
    .visible = false,
    .named = true,
  },
  [sym_postfix_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_constructor_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__parenthesized_type] = {
    .visible = false,
    .named = true,
  },
  [sym_navigation_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__navigable_type_expression] = {
    .visible = false,
    .named = true,
  },
  [sym_open_start_range_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__range_operator] = {
    .visible = false,
    .named = true,
  },
  [sym_open_end_range_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_prefix_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_as_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_selector_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__binary_expression] = {
    .visible = false,
    .named = true,
  },
  [sym_multiplicative_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_additive_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_range_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_infix_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_nil_coalescing_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_check_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_comparison_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_equality_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_conjunction_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_disjunction_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_bitwise_operation] = {
    .visible = true,
    .named = true,
  },
  [sym_custom_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_navigation_suffix] = {
    .visible = true,
    .named = true,
  },
  [sym_call_suffix] = {
    .visible = true,
    .named = true,
  },
  [sym_constructor_suffix] = {
    .visible = true,
    .named = true,
  },
  [sym__constructor_value_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym__fn_call_lambda_arguments] = {
    .visible = false,
    .named = true,
  },
  [sym_type_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_value_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_value_argument_label] = {
    .visible = true,
    .named = true,
  },
  [sym_value_argument] = {
    .visible = true,
    .named = true,
  },
  [sym_try_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_await_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__await_operator] = {
    .visible = false,
    .named = true,
  },
  [sym_ternary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__expr_hack_at_ternary_binary_suffix] = {
    .visible = false,
    .named = true,
  },
  [sym_expr_hack_at_ternary_binary_call] = {
    .visible = true,
    .named = true,
  },
  [sym_expr_hack_at_ternary_binary_call_suffix] = {
    .visible = true,
    .named = true,
  },
  [sym_call_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__primary_expression] = {
    .visible = false,
    .named = true,
  },
  [sym_tuple_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_array_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_dictionary_literal] = {
    .visible = true,
    .named = true,
  },
  [sym__dictionary_literal_item] = {
    .visible = false,
    .named = true,
  },
  [sym__special_literal] = {
    .visible = false,
    .named = true,
  },
  [sym__playground_literal] = {
    .visible = false,
    .named = true,
  },
  [sym_lambda_literal] = {
    .visible = true,
    .named = true,
  },
  [sym__lambda_type_declaration] = {
    .visible = false,
    .named = true,
  },
  [sym_capture_list] = {
    .visible = true,
    .named = true,
  },
  [sym_capture_list_item] = {
    .visible = true,
    .named = true,
  },
  [sym_lambda_function_type] = {
    .visible = true,
    .named = true,
  },
  [sym_lambda_function_type_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_lambda_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_self_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_super_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__else_options] = {
    .visible = false,
    .named = true,
  },
  [sym_if_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__if_condition_sequence_item] = {
    .visible = false,
    .named = true,
  },
  [sym__if_let_binding] = {
    .visible = false,
    .named = true,
  },
  [sym_guard_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_entry] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_do_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_catch_block] = {
    .visible = true,
    .named = true,
  },
  [sym_where_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_key_path_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_key_path_string_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__key_path_component] = {
    .visible = false,
    .named = true,
  },
  [sym__key_path_postfixes] = {
    .visible = false,
    .named = true,
  },
  [sym_try_operator] = {
    .visible = true,
    .named = true,
  },
  [sym__try_operator_type] = {
    .visible = false,
    .named = true,
  },
  [sym__assignment_and_operator] = {
    .visible = false,
    .named = true,
  },
  [sym__equality_operator] = {
    .visible = false,
    .named = true,
  },
  [sym__comparison_operator] = {
    .visible = false,
    .named = true,
  },
  [sym__three_dot_operator] = {
    .visible = false,
    .named = true,
  },
  [sym__open_ended_range_operator] = {
    .visible = false,
    .named = true,
  },
  [sym__is_operator] = {
    .visible = false,
    .named = true,
  },
  [sym__additive_operator] = {
    .visible = false,
    .named = true,
  },
  [sym__multiplicative_operator] = {
    .visible = false,
    .named = true,
  },
  [sym_as_operator] = {
    .visible = true,
    .named = true,
  },
  [sym__prefix_unary_operator] = {
    .visible = false,
    .named = true,
  },
  [sym__bitwise_binary_operator] = {
    .visible = false,
    .named = true,
  },
  [sym__postfix_unary_operator] = {
    .visible = false,
    .named = true,
  },
  [sym_directly_assignable_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_statements] = {
    .visible = true,
    .named = true,
  },
  [sym__local_statement] = {
    .visible = false,
    .named = true,
  },
  [sym__top_level_statement] = {
    .visible = false,
    .named = true,
  },
  [sym__block] = {
    .visible = false,
    .named = true,
  },
  [sym__labeled_statement] = {
    .visible = false,
    .named = true,
  },
  [sym_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__for_statement_collection] = {
    .visible = false,
    .named = true,
  },
  [sym_for_statement_await] = {
    .visible = true,
    .named = true,
  },
  [sym_while_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_repeat_while_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_control_transfer_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__throw_statement] = {
    .visible = false,
    .named = true,
  },
  [sym__optionally_valueful_control_keyword] = {
    .visible = false,
    .named = true,
  },
  [sym_assignment] = {
    .visible = true,
    .named = true,
  },
  [sym_value_parameter_pack] = {
    .visible = true,
    .named = true,
  },
  [sym_value_pack_expansion] = {
    .visible = true,
    .named = true,
  },
  [sym_availability_condition] = {
    .visible = true,
    .named = true,
  },
  [sym__availability_argument] = {
    .visible = false,
    .named = true,
  },
  [sym__global_declaration] = {
    .visible = false,
    .named = true,
  },
  [sym__type_level_declaration] = {
    .visible = false,
    .named = true,
  },
  [sym__local_declaration] = {
    .visible = false,
    .named = true,
  },
  [sym__local_property_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym__local_typealias_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym__local_function_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym__local_class_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_import_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym__import_kind] = {
    .visible = false,
    .named = true,
  },
  [sym_protocol_property_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_protocol_property_requirements] = {
    .visible = true,
    .named = true,
  },
  [sym_property_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym__modifierless_property_declaration] = {
    .visible = false,
    .named = true,
  },
  [sym__single_modifierless_property_declaration] = {
    .visible = false,
    .named = true,
  },
  [sym__expression_with_willset_didset] = {
    .visible = false,
    .named = true,
  },
  [sym__expression_without_willset_didset] = {
    .visible = false,
    .named = true,
  },
  [sym_willset_didset_block] = {
    .visible = true,
    .named = true,
  },
  [sym_willset_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_didset_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_typealias_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym__modifierless_typealias_declaration] = {
    .visible = false,
    .named = true,
  },
  [sym_function_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym__modifierless_function_declaration] = {
    .visible = false,
    .named = true,
  },
  [sym__bodyless_function_declaration] = {
    .visible = false,
    .named = true,
  },
  [sym__modifierless_function_declaration_no_body] = {
    .visible = false,
    .named = true,
  },
  [sym_function_body] = {
    .visible = true,
    .named = true,
  },
  [sym_macro_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym__macro_head] = {
    .visible = false,
    .named = true,
  },
  [sym__macro_signature] = {
    .visible = false,
    .named = true,
  },
  [sym_macro_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_external_macro_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_class_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym__modifierless_class_declaration] = {
    .visible = false,
    .named = true,
  },
  [sym_class_body] = {
    .visible = true,
    .named = true,
  },
  [sym__inheritance_specifiers] = {
    .visible = false,
    .named = true,
  },
  [sym_inheritance_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym__annotated_inheritance_specifier] = {
    .visible = false,
    .named = true,
  },
  [sym_type_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_type_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym__type_parameter_possibly_packed] = {
    .visible = false,
    .named = true,
  },
  [sym_type_constraints] = {
    .visible = true,
    .named = true,
  },
  [sym_type_constraint] = {
    .visible = true,
    .named = true,
  },
  [sym_inheritance_constraint] = {
    .visible = true,
    .named = true,
  },
  [sym_equality_constraint] = {
    .visible = true,
    .named = true,
  },
  [sym__constrained_type] = {
    .visible = false,
    .named = true,
  },
  [sym__class_member_separator] = {
    .visible = false,
    .named = true,
  },
  [sym__class_member_declarations] = {
    .visible = false,
    .named = true,
  },
  [aux_sym__function_value_parameters] = {
    .visible = false,
    .named = false,
  },
  [sym__function_value_parameter] = {
    .visible = false,
    .named = true,
  },
  [sym_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym__non_constructor_function_decl] = {
    .visible = false,
    .named = true,
  },
  [sym__referenceable_operator] = {
    .visible = false,
    .named = true,
  },
  [sym__equal_sign] = {
    .visible = false,
    .named = true,
  },
  [sym__eq_eq] = {
    .visible = false,
    .named = true,
  },
  [sym__dot] = {
    .visible = false,
    .named = true,
  },
  [sym__arrow_operator] = {
    .visible = false,
    .named = true,
  },
  [sym__conjunction_operator] = {
    .visible = false,
    .named = true,
  },
  [sym__disjunction_operator] = {
    .visible = false,
    .named = true,
  },
  [sym__nil_coalescing_operator] = {
    .visible = false,
    .named = true,
  },
  [sym__as] = {
    .visible = false,
    .named = true,
  },
  [sym__as_quest] = {
    .visible = false,
    .named = true,
  },
  [sym__as_bang] = {
    .visible = false,
    .named = true,
  },
  [sym_bang] = {
    .visible = true,
    .named = true,
  },
  [sym__async_keyword] = {
    .visible = false,
    .named = true,
  },
  [sym__async_modifier] = {
    .visible = false,
    .named = true,
  },
  [sym_throws] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_class_body] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_entry] = {
    .visible = true,
    .named = true,
  },
  [sym__enum_entry_suffix] = {
    .visible = false,
    .named = true,
  },
  [sym_enum_type_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_protocol_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_protocol_body] = {
    .visible = true,
    .named = true,
  },
  [sym__protocol_member_declarations] = {
    .visible = false,
    .named = true,
  },
  [sym__protocol_member_declaration] = {
    .visible = false,
    .named = true,
  },
  [sym_init_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_deinit_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_subscript_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_computed_property] = {
    .visible = true,
    .named = true,
  },
  [sym_computed_getter] = {
    .visible = true,
    .named = true,
  },
  [sym_computed_modify] = {
    .visible = true,
    .named = true,
  },
  [sym_computed_setter] = {
    .visible = true,
    .named = true,
  },
  [sym_getter_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_setter_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_modify_specifier] = {
    .visible = true,
    .named = true,
  },
  [aux_sym__getter_effects] = {
    .visible = false,
    .named = false,
  },
  [sym_operator_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_deprecated_operator_declaration_body] = {
    .visible = true,
    .named = true,
  },
  [sym_precedence_group_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_precedence_group_attributes] = {
    .visible = true,
    .named = true,
  },
  [sym_precedence_group_attribute] = {
    .visible = true,
    .named = true,
  },
  [sym_associatedtype_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_attribute] = {
    .visible = true,
    .named = true,
  },
  [sym__attribute_argument] = {
    .visible = false,
    .named = true,
  },
  [sym__universally_allowed_pattern] = {
    .visible = false,
    .named = true,
  },
  [sym__bound_identifier] = {
    .visible = false,
    .named = true,
  },
  [sym__binding_pattern_no_expr] = {
    .visible = false,
    .named = true,
  },
  [sym__no_expr_pattern_already_bound] = {
    .visible = false,
    .named = true,
  },
  [sym__binding_pattern_with_expr] = {
    .visible = true,
    .named = true,
  },
  [sym__direct_or_indirect_binding] = {
    .visible = false,
    .named = true,
  },
  [sym_value_binding_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym__possibly_async_binding_pattern_kind] = {
    .visible = false,
    .named = true,
  },
  [sym__binding_kind_and_pattern] = {
    .visible = false,
    .named = true,
  },
  [sym__tuple_pattern_item] = {
    .visible = false,
    .named = true,
  },
  [sym__tuple_pattern] = {
    .visible = false,
    .named = true,
  },
  [sym__case_pattern] = {
    .visible = false,
    .named = true,
  },
  [sym__type_casting_pattern] = {
    .visible = false,
    .named = true,
  },
  [sym__binding_pattern] = {
    .visible = false,
    .named = true,
  },
  [sym_modifiers] = {
    .visible = true,
    .named = true,
  },
  [aux_sym__locally_permitted_modifiers] = {
    .visible = false,
    .named = false,
  },
  [sym_parameter_modifiers] = {
    .visible = true,
    .named = true,
  },
  [sym__non_local_scope_modifier] = {
    .visible = false,
    .named = true,
  },
  [sym__locally_permitted_modifier] = {
    .visible = false,
    .named = true,
  },
  [sym_property_behavior_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_type_modifiers] = {
    .visible = true,
    .named = true,
  },
  [sym_member_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_visibility_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_type_parameter_modifiers] = {
    .visible = true,
    .named = true,
  },
  [sym_function_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_mutation_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_property_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_inheritance_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_parameter_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_ownership_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym__parameter_ownership_modifier] = {
    .visible = false,
    .named = true,
  },
  [aux_sym_source_file_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_identifier_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_line_string_literal_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_multi_line_string_literal_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_raw_string_literal_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__interpolation_contents_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_user_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_tuple_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_optional_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_protocol_composition_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__constructor_value_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__fn_call_lambda_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_value_argument_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_tuple_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_array_literal_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_dictionary_literal_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__playground_literal_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__lambda_type_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_capture_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_lambda_function_type_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_if_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_switch_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_switch_entry_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_do_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_key_path_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__key_path_component_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_statements_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_repeat_while_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_availability_condition_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__availability_argument_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_protocol_property_requirements_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__modifierless_property_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__inheritance_specifiers_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_constraints_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__constrained_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__class_member_declarations_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__function_value_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_enum_class_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_enum_entry_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_enum_type_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__protocol_member_declarations_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_computed_property_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_deprecated_operator_declaration_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_precedence_group_attributes_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_attribute_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__attribute_argument_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__attribute_argument_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__tuple_pattern_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_modifiers_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_parameter_modifiers_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym__expression] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_fully_open_range] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_interpolated_expression] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_protocol_function_declaration] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_type_identifier] = {
    .visible = true,
    .named = true,
  },
};

enum ts_field_identifiers {
  field_body = 1,
  field_bound_identifier = 2,
  field_captures = 3,
  field_collection = 4,
  field_computed_value = 5,
  field_condition = 6,
  field_constrained_type = 7,
  field_constructed_type = 8,
  field_data_contents = 9,
  field_declaration_kind = 10,
  field_default_value = 11,
  field_definition = 12,
  field_element = 13,
  field_end = 14,
  field_error = 15,
  field_expr = 16,
  field_external_name = 17,
  field_if_false = 18,
  field_if_nil = 19,
  field_if_true = 20,
  field_inherits_from = 21,
  field_interpolation = 22,
  field_item = 23,
  field_key = 24,
  field_lhs = 25,
  field_must_equal = 26,
  field_must_inherit = 27,
  field_mutability = 28,
  field_name = 29,
  field_op = 30,
  field_operation = 31,
  field_operator = 32,
  field_params = 33,
  field_raw_value = 34,
  field_reference_specifier = 35,
  field_result = 36,
  field_return_type = 37,
  field_rhs = 38,
  field_start = 39,
  field_suffix = 40,
  field_target = 41,
  field_text = 42,
  field_type = 43,
  field_value = 44,
  field_wrapped = 45,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_body] = "body",
  [field_bound_identifier] = "bound_identifier",
  [field_captures] = "captures",
  [field_collection] = "collection",
  [field_computed_value] = "computed_value",
  [field_condition] = "condition",
  [field_constrained_type] = "constrained_type",
  [field_constructed_type] = "constructed_type",
  [field_data_contents] = "data_contents",
  [field_declaration_kind] = "declaration_kind",
  [field_default_value] = "default_value",
  [field_definition] = "definition",
  [field_element] = "element",
  [field_end] = "end",
  [field_error] = "error",
  [field_expr] = "expr",
  [field_external_name] = "external_name",
  [field_if_false] = "if_false",
  [field_if_nil] = "if_nil",
  [field_if_true] = "if_true",
  [field_inherits_from] = "inherits_from",
  [field_interpolation] = "interpolation",
  [field_item] = "item",
  [field_key] = "key",
  [field_lhs] = "lhs",
  [field_must_equal] = "must_equal",
  [field_must_inherit] = "must_inherit",
  [field_mutability] = "mutability",
  [field_name] = "name",
  [field_op] = "op",
  [field_operation] = "operation",
  [field_operator] = "operator",
  [field_params] = "params",
  [field_raw_value] = "raw_value",
  [field_reference_specifier] = "reference_specifier",
  [field_result] = "result",
  [field_return_type] = "return_type",
  [field_rhs] = "rhs",
  [field_start] = "start",
  [field_suffix] = "suffix",
  [field_target] = "target",
  [field_text] = "text",
  [field_type] = "type",
  [field_value] = "value",
  [field_wrapped] = "wrapped",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 1},
  [2] = {.index = 1, .length = 1},
  [5] = {.index = 2, .length = 3},
  [6] = {.index = 5, .length = 2},
  [7] = {.index = 7, .length = 3},
  [8] = {.index = 10, .length = 3},
  [9] = {.index = 13, .length = 2},
  [10] = {.index = 15, .length = 1},
  [11] = {.index = 16, .length = 1},
  [12] = {.index = 17, .length = 1},
  [13] = {.index = 18, .length = 2},
  [14] = {.index = 20, .length = 4},
  [15] = {.index = 24, .length = 1},
  [16] = {.index = 25, .length = 1},
  [17] = {.index = 26, .length = 1},
  [18] = {.index = 27, .length = 3},
  [19] = {.index = 30, .length = 1},
  [20] = {.index = 31, .length = 2},
  [21] = {.index = 30, .length = 1},
  [22] = {.index = 33, .length = 1},
  [23] = {.index = 34, .length = 2},
  [24] = {.index = 36, .length = 1},
  [25] = {.index = 37, .length = 2},
  [26] = {.index = 39, .length = 3},
  [27] = {.index = 42, .length = 1},
  [28] = {.index = 43, .length = 1},
  [29] = {.index = 44, .length = 2},
  [30] = {.index = 44, .length = 2},
  [31] = {.index = 46, .length = 4},
  [32] = {.index = 50, .length = 2},
  [33] = {.index = 52, .length = 3},
  [34] = {.index = 55, .length = 3},
  [35] = {.index = 58, .length = 2},
  [36] = {.index = 60, .length = 3},
  [37] = {.index = 63, .length = 3},
  [38] = {.index = 66, .length = 4},
  [40] = {.index = 70, .length = 1},
  [41] = {.index = 71, .length = 1},
  [42] = {.index = 72, .length = 1},
  [43] = {.index = 73, .length = 3},
  [44] = {.index = 76, .length = 2},
  [45] = {.index = 78, .length = 1},
  [46] = {.index = 79, .length = 1},
  [47] = {.index = 80, .length = 2},
  [48] = {.index = 82, .length = 2},
  [49] = {.index = 84, .length = 1},
  [50] = {.index = 85, .length = 2},
  [51] = {.index = 87, .length = 2},
  [52] = {.index = 89, .length = 3},
  [53] = {.index = 92, .length = 2},
  [54] = {.index = 94, .length = 1},
  [55] = {.index = 95, .length = 1},
  [56] = {.index = 96, .length = 1},
  [57] = {.index = 97, .length = 4},
  [58] = {.index = 101, .length = 1},
  [59] = {.index = 102, .length = 2},
  [60] = {.index = 73, .length = 3},
  [61] = {.index = 104, .length = 2},
  [62] = {.index = 106, .length = 3},
  [63] = {.index = 109, .length = 2},
  [64] = {.index = 111, .length = 3},
  [65] = {.index = 114, .length = 3},
  [66] = {.index = 117, .length = 4},
  [67] = {.index = 121, .length = 3},
  [68] = {.index = 124, .length = 1},
  [69] = {.index = 125, .length = 2},
  [70] = {.index = 127, .length = 3},
  [71] = {.index = 130, .length = 1},
  [72] = {.index = 131, .length = 1},
  [73] = {.index = 132, .length = 2},
  [74] = {.index = 134, .length = 6},
  [75] = {.index = 140, .length = 4},
  [76] = {.index = 144, .length = 4},
  [77] = {.index = 148, .length = 3},
  [78] = {.index = 151, .length = 1},
  [79] = {.index = 152, .length = 1},
  [80] = {.index = 153, .length = 1},
  [81] = {.index = 154, .length = 2},
  [82] = {.index = 156, .length = 1},
  [83] = {.index = 157, .length = 2},
  [84] = {.index = 159, .length = 1},
  [85] = {.index = 160, .length = 3},
  [86] = {.index = 163, .length = 3},
  [87] = {.index = 166, .length = 4},
  [88] = {.index = 170, .length = 3},
  [89] = {.index = 173, .length = 2},
  [90] = {.index = 175, .length = 3},
  [91] = {.index = 178, .length = 2},
  [92] = {.index = 180, .length = 2},
  [93] = {.index = 182, .length = 2},
  [94] = {.index = 184, .length = 4},
  [95] = {.index = 188, .length = 4},
  [96] = {.index = 192, .length = 6},
  [97] = {.index = 198, .length = 6},
  [98] = {.index = 204, .length = 3},
  [99] = {.index = 207, .length = 2},
  [100] = {.index = 209, .length = 2},
  [101] = {.index = 211, .length = 1},
  [102] = {.index = 212, .length = 1},
  [103] = {.index = 213, .length = 2},
  [104] = {.index = 215, .length = 3},
  [105] = {.index = 218, .length = 3},
  [106] = {.index = 221, .length = 2},
  [107] = {.index = 223, .length = 3},
  [108] = {.index = 7, .length = 3},
  [109] = {.index = 226, .length = 1},
  [110] = {.index = 160, .length = 3},
  [111] = {.index = 227, .length = 3},
  [112] = {.index = 230, .length = 1},
  [113] = {.index = 231, .length = 2},
  [114] = {.index = 233, .length = 3},
  [115] = {.index = 236, .length = 3},
  [116] = {.index = 239, .length = 3},
  [117] = {.index = 242, .length = 3},
  [118] = {.index = 245, .length = 2},
  [119] = {.index = 247, .length = 2},
  [120] = {.index = 249, .length = 1},
  [121] = {.index = 250, .length = 4},
  [122] = {.index = 254, .length = 6},
  [123] = {.index = 260, .length = 4},
  [124] = {.index = 264, .length = 4},
  [125] = {.index = 268, .length = 2},
  [126] = {.index = 270, .length = 2},
  [127] = {.index = 272, .length = 1},
  [128] = {.index = 273, .length = 2},
  [129] = {.index = 275, .length = 3},
  [130] = {.index = 278, .length = 1},
  [131] = {.index = 279, .length = 3},
  [132] = {.index = 282, .length = 2},
  [133] = {.index = 284, .length = 3},
  [134] = {.index = 287, .length = 4},
  [135] = {.index = 291, .length = 3},
  [136] = {.index = 294, .length = 2},
  [137] = {.index = 296, .length = 3},
  [138] = {.index = 299, .length = 4},
  [139] = {.index = 303, .length = 2},
  [140] = {.index = 305, .length = 3},
  [141] = {.index = 308, .length = 4},
  [142] = {.index = 312, .length = 3},
  [143] = {.index = 315, .length = 2},
  [144] = {.index = 317, .length = 3},
  [145] = {.index = 320, .length = 3},
  [146] = {.index = 46, .length = 4},
  [147] = {.index = 323, .length = 1},
  [148] = {.index = 324, .length = 2},
  [149] = {.index = 275, .length = 3},
  [150] = {.index = 326, .length = 3},
  [151] = {.index = 329, .length = 2},
  [152] = {.index = 331, .length = 1},
  [153] = {.index = 332, .length = 1},
  [154] = {.index = 333, .length = 3},
  [155] = {.index = 336, .length = 3},
  [156] = {.index = 339, .length = 3},
  [157] = {.index = 342, .length = 3},
  [158] = {.index = 345, .length = 2},
  [159] = {.index = 347, .length = 3},
  [160] = {.index = 350, .length = 2},
  [161] = {.index = 352, .length = 4},
  [162] = {.index = 356, .length = 4},
  [163] = {.index = 360, .length = 4},
  [164] = {.index = 364, .length = 4},
  [165] = {.index = 368, .length = 2},
  [166] = {.index = 370, .length = 3},
  [167] = {.index = 373, .length = 3},
  [168] = {.index = 376, .length = 3},
  [169] = {.index = 379, .length = 3},
  [170] = {.index = 382, .length = 3},
  [171] = {.index = 385, .length = 3},
  [172] = {.index = 388, .length = 1},
  [173] = {.index = 389, .length = 6},
  [174] = {.index = 395, .length = 3},
  [175] = {.index = 398, .length = 4},
  [176] = {.index = 402, .length = 3},
  [177] = {.index = 405, .length = 2},
  [178] = {.index = 407, .length = 4},
  [179] = {.index = 411, .length = 4},
  [180] = {.index = 415, .length = 4},
  [181] = {.index = 419, .length = 3},
  [182] = {.index = 422, .length = 3},
  [183] = {.index = 425, .length = 3},
  [184] = {.index = 428, .length = 3},
  [185] = {.index = 431, .length = 1},
  [186] = {.index = 432, .length = 4},
  [187] = {.index = 151, .length = 1},
  [188] = {.index = 436, .length = 3},
  [189] = {.index = 385, .length = 3},
  [190] = {.index = 439, .length = 3},
  [191] = {.index = 442, .length = 1},
  [192] = {.index = 443, .length = 1},
  [193] = {.index = 444, .length = 3},
  [194] = {.index = 447, .length = 3},
  [195] = {.index = 450, .length = 3},
  [196] = {.index = 453, .length = 5},
  [197] = {.index = 458, .length = 4},
  [198] = {.index = 462, .length = 4},
  [199] = {.index = 466, .length = 2},
  [200] = {.index = 468, .length = 3},
  [201] = {.index = 471, .length = 3},
  [202] = {.index = 474, .length = 3},
  [203] = {.index = 477, .length = 3},
  [204] = {.index = 480, .length = 3},
  [205] = {.index = 483, .length = 3},
  [206] = {.index = 486, .length = 6},
  [207] = {.index = 492, .length = 3},
  [208] = {.index = 495, .length = 2},
  [209] = {.index = 497, .length = 4},
  [210] = {.index = 501, .length = 4},
  [211] = {.index = 505, .length = 3},
  [212] = {.index = 508, .length = 3},
  [213] = {.index = 511, .length = 3},
  [214] = {.index = 514, .length = 1},
  [215] = {.index = 515, .length = 6},
  [216] = {.index = 521, .length = 6},
  [217] = {.index = 527, .length = 3},
  [218] = {.index = 530, .length = 4},
  [219] = {.index = 534, .length = 1},
  [220] = {.index = 483, .length = 3},
  [221] = {.index = 535, .length = 3},
  [222] = {.index = 538, .length = 3},
  [223] = {.index = 541, .length = 3},
  [224] = {.index = 544, .length = 5},
  [225] = {.index = 549, .length = 4},
  [226] = {.index = 553, .length = 3},
  [227] = {.index = 556, .length = 3},
  [228] = {.index = 559, .length = 3},
  [229] = {.index = 562, .length = 5},
  [230] = {.index = 567, .length = 3},
  [231] = {.index = 570, .length = 6},
  [232] = {.index = 576, .length = 2},
  [233] = {.index = 578, .length = 4},
  [234] = {.index = 582, .length = 3},
  [235] = {.index = 585, .length = 3},
  [236] = {.index = 588, .length = 6},
  [237] = {.index = 594, .length = 3},
  [238] = {.index = 597, .length = 4},
  [239] = {.index = 601, .length = 3},
  [240] = {.index = 604, .length = 3},
  [241] = {.index = 607, .length = 3},
  [242] = {.index = 610, .length = 3},
  [243] = {.index = 613, .length = 3},
  [244] = {.index = 616, .length = 5},
  [245] = {.index = 621, .length = 3},
  [246] = {.index = 624, .length = 3},
  [247] = {.index = 627, .length = 6},
  [248] = {.index = 633, .length = 3},
  [249] = {.index = 636, .length = 3},
  [250] = {.index = 639, .length = 3},
  [251] = {.index = 642, .length = 3},
  [252] = {.index = 645, .length = 1},
  [253] = {.index = 646, .length = 2},
  [254] = {.index = 648, .length = 2},
  [255] = {.index = 650, .length = 2},
  [256] = {.index = 652, .length = 2},
  [257] = {.index = 654, .length = 2},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_text, 0},
  [1] =
    {field_mutability, 0},
  [2] =
    {field_computed_value, 0, .inherited = true},
    {field_name, 0, .inherited = true},
    {field_value, 0, .inherited = true},
  [5] =
    {field_name, 0, .inherited = true},
    {field_value, 0, .inherited = true},
  [7] =
    {field_default_value, 0, .inherited = true},
    {field_name, 0, .inherited = true},
    {field_return_type, 0, .inherited = true},
  [10] =
    {field_body, 0, .inherited = true},
    {field_declaration_kind, 0, .inherited = true},
    {field_name, 0, .inherited = true},
  [13] =
    {field_interpolation, 1},
    {field_text, 0},
  [15] =
    {field_interpolation, 0, .inherited = true},
  [16] =
    {field_name, 0},
  [17] =
    {field_element, 0, .inherited = true},
  [18] =
    {field_bound_identifier, 0, .inherited = true},
    {field_name, 0, .inherited = true},
  [20] =
    {field_body, 0, .inherited = true},
    {field_default_value, 0, .inherited = true},
    {field_name, 0, .inherited = true},
    {field_return_type, 0, .inherited = true},
  [24] =
    {field_bound_identifier, 0},
  [25] =
    {field_name, 0, .inherited = true},
  [26] =
    {field_bound_identifier, 0, .inherited = true},
  [27] =
    {field_default_value, 1, .inherited = true},
    {field_name, 1, .inherited = true},
    {field_return_type, 1, .inherited = true},
  [30] =
    {field_name, 1},
  [31] =
    {field_default_value, 1, .inherited = true},
    {field_name, 0},
  [33] =
    {field_constructed_type, 0},
  [34] =
    {field_suffix, 1},
    {field_target, 0},
  [36] =
    {field_start, 0},
  [37] =
    {field_operation, 1},
    {field_target, 0},
  [39] =
    {field_element, 0, .inherited = true},
    {field_suffix, 1},
    {field_target, 0},
  [42] =
    {field_end, 1},
  [43] =
    {field_expr, 1},
  [44] =
    {field_operation, 0},
    {field_target, 1},
  [46] =
    {field_body, 1},
    {field_default_value, 0, .inherited = true},
    {field_name, 0, .inherited = true},
    {field_return_type, 0, .inherited = true},
  [50] =
    {field_default_value, 1, .inherited = true},
    {field_name, 0, .inherited = true},
  [52] =
    {field_computed_value, 1, .inherited = true},
    {field_name, 1, .inherited = true},
    {field_value, 1, .inherited = true},
  [55] =
    {field_bound_identifier, 0, .inherited = true},
    {field_name, 0},
    {field_name, 0, .inherited = true},
  [58] =
    {field_name, 1, .inherited = true},
    {field_value, 1, .inherited = true},
  [60] =
    {field_body, 1, .inherited = true},
    {field_declaration_kind, 1, .inherited = true},
    {field_name, 1, .inherited = true},
  [63] =
    {field_interpolation, 0, .inherited = true},
    {field_text, 0, .inherited = true},
    {field_text, 1},
  [66] =
    {field_interpolation, 0, .inherited = true},
    {field_interpolation, 1, .inherited = true},
    {field_text, 0, .inherited = true},
    {field_text, 1, .inherited = true},
  [70] =
    {field_value, 0},
  [71] =
    {field_interpolation, 0},
  [72] =
    {field_reference_specifier, 0, .inherited = true},
  [73] =
    {field_body, 2},
    {field_declaration_kind, 0},
    {field_name, 1},
  [76] =
    {field_interpolation, 1, .inherited = true},
    {field_text, 1, .inherited = true},
  [78] =
    {field_element, 1},
  [79] =
    {field_value, 1},
  [80] =
    {field_name, 0, .inherited = true},
    {field_type, 0},
  [82] =
    {field_element, 1},
    {field_name, 1, .inherited = true},
  [84] =
    {field_wrapped, 0},
  [85] =
    {field_key, 1, .inherited = true},
    {field_value, 1, .inherited = true},
  [87] =
    {field_bound_identifier, 1, .inherited = true},
    {field_name, 1, .inherited = true},
  [89] =
    {field_bound_identifier, 1, .inherited = true},
    {field_condition, 1},
    {field_name, 1, .inherited = true},
  [92] =
    {field_captures, 1, .inherited = true},
    {field_type, 1, .inherited = true},
  [94] =
    {field_captures, 0},
  [95] =
    {field_type, 0},
  [96] =
    {field_result, 1},
  [97] =
    {field_body, 1, .inherited = true},
    {field_default_value, 1, .inherited = true},
    {field_name, 1, .inherited = true},
    {field_return_type, 1, .inherited = true},
  [101] =
    {field_name, 1, .inherited = true},
  [102] =
    {field_default_value, 2, .inherited = true},
    {field_name, 1},
  [104] =
    {field_default_value, 2, .inherited = true},
    {field_name, 0},
  [106] =
    {field_body, 2},
    {field_default_value, 1, .inherited = true},
    {field_name, 0},
  [109] =
    {field_default_value, 0, .inherited = true},
    {field_default_value, 1, .inherited = true},
  [111] =
    {field_end, 2},
    {field_op, 1},
    {field_start, 0},
  [114] =
    {field_lhs, 0},
    {field_op, 1},
    {field_rhs, 2},
  [117] =
    {field_name, 2, .inherited = true},
    {field_op, 1},
    {field_target, 0},
    {field_type, 2},
  [121] =
    {field_expr, 0},
    {field_name, 2, .inherited = true},
    {field_type, 2},
  [124] =
    {field_suffix, 1},
  [125] =
    {field_if_nil, 2},
    {field_value, 0},
  [127] =
    {field_operator, 1},
    {field_result, 2},
    {field_target, 0},
  [130] =
    {field_default_value, 2, .inherited = true},
  [131] =
    {field_default_value, 0, .inherited = true},
  [132] =
    {field_default_value, 2, .inherited = true},
    {field_name, 0, .inherited = true},
  [134] =
    {field_computed_value, 1, .inherited = true},
    {field_computed_value, 2, .inherited = true},
    {field_name, 1, .inherited = true},
    {field_name, 2, .inherited = true},
    {field_value, 1, .inherited = true},
    {field_value, 2, .inherited = true},
  [140] =
    {field_bound_identifier, 0, .inherited = true},
    {field_name, 0},
    {field_name, 0, .inherited = true},
    {field_value, 1, .inherited = true},
  [144] =
    {field_bound_identifier, 0, .inherited = true},
    {field_computed_value, 1},
    {field_name, 0},
    {field_name, 0, .inherited = true},
  [148] =
    {field_default_value, 2, .inherited = true},
    {field_name, 2, .inherited = true},
    {field_return_type, 2, .inherited = true},
  [151] =
    {field_name, 2},
  [152] =
    {field_interpolation, 1, .inherited = true},
  [153] =
    {field_reference_specifier, 0},
  [154] =
    {field_interpolation, 0},
    {field_interpolation, 1, .inherited = true},
  [156] =
    {field_reference_specifier, 1, .inherited = true},
  [157] =
    {field_reference_specifier, 0, .inherited = true},
    {field_reference_specifier, 1, .inherited = true},
  [159] =
    {field_inherits_from, 0},
  [160] =
    {field_body, 3},
    {field_declaration_kind, 0},
    {field_name, 1},
  [163] =
    {field_name, 2, .inherited = true},
    {field_value, 1},
    {field_value, 2, .inherited = true},
  [166] =
    {field_name, 0, .inherited = true},
    {field_name, 1, .inherited = true},
    {field_value, 0, .inherited = true},
    {field_value, 1, .inherited = true},
  [170] =
    {field_name, 0, .inherited = true},
    {field_name, 1, .inherited = true},
    {field_type, 1},
  [173] =
    {field_name, 1, .inherited = true},
    {field_type, 1},
  [175] =
    {field_name, 2, .inherited = true},
    {field_params, 0},
    {field_return_type, 2},
  [178] =
    {field_key, 0},
    {field_value, 2},
  [180] =
    {field_element, 1},
    {field_element, 2, .inherited = true},
  [182] =
    {field_element, 0, .inherited = true},
    {field_element, 1, .inherited = true},
  [184] =
    {field_key, 1, .inherited = true},
    {field_key, 2, .inherited = true},
    {field_value, 1, .inherited = true},
    {field_value, 2, .inherited = true},
  [188] =
    {field_key, 0, .inherited = true},
    {field_key, 1, .inherited = true},
    {field_value, 0, .inherited = true},
    {field_value, 1, .inherited = true},
  [192] =
    {field_bound_identifier, 1, .inherited = true},
    {field_bound_identifier, 2, .inherited = true},
    {field_condition, 1},
    {field_condition, 2, .inherited = true},
    {field_name, 1, .inherited = true},
    {field_name, 2, .inherited = true},
  [198] =
    {field_bound_identifier, 0, .inherited = true},
    {field_bound_identifier, 1, .inherited = true},
    {field_condition, 0, .inherited = true},
    {field_condition, 1, .inherited = true},
    {field_name, 0, .inherited = true},
    {field_name, 1, .inherited = true},
  [204] =
    {field_name, 0},
    {field_name, 2, .inherited = true},
    {field_type, 2},
  [207] =
    {field_captures, 0},
    {field_type, 1},
  [209] =
    {field_name, 2, .inherited = true},
    {field_return_type, 2},
  [211] =
    {field_captures, 1},
  [212] =
    {field_type, 1},
  [213] =
    {field_bound_identifier, 2, .inherited = true},
    {field_name, 2, .inherited = true},
  [215] =
    {field_bound_identifier, 0, .inherited = true},
    {field_name, 0, .inherited = true},
    {field_name, 2, .inherited = true},
  [218] =
    {field_name, 1},
    {field_name, 3, .inherited = true},
    {field_value, 3},
  [221] =
    {field_default_value, 3, .inherited = true},
    {field_name, 1},
  [223] =
    {field_body, 3},
    {field_default_value, 2, .inherited = true},
    {field_name, 1},
  [226] =
    {field_body, 0, .inherited = true},
  [227] =
    {field_body, 3},
    {field_declaration_kind, 1},
    {field_name, 2},
  [230] =
    {field_default_value, 1, .inherited = true},
  [231] =
    {field_default_value, 3, .inherited = true},
    {field_name, 0},
  [233] =
    {field_body, 3},
    {field_default_value, 2, .inherited = true},
    {field_name, 0},
  [236] =
    {field_body, 3},
    {field_default_value, 1, .inherited = true},
    {field_name, 0},
  [239] =
    {field_must_inherit, 3},
    {field_name, 1},
    {field_name, 3, .inherited = true},
  [242] =
    {field_default_value, 3},
    {field_name, 1},
    {field_name, 3, .inherited = true},
  [245] =
    {field_name, 0, .inherited = true},
    {field_name, 1, .inherited = true},
  [247] =
    {field_default_value, 2, .inherited = true},
    {field_definition, 3},
  [249] =
    {field_default_value, 3, .inherited = true},
  [250] =
    {field_default_value, 1, .inherited = true},
    {field_name, 0, .inherited = true},
    {field_name, 3, .inherited = true},
    {field_return_type, 3},
  [254] =
    {field_computed_value, 0, .inherited = true},
    {field_computed_value, 1, .inherited = true},
    {field_name, 0, .inherited = true},
    {field_name, 1, .inherited = true},
    {field_value, 0, .inherited = true},
    {field_value, 1, .inherited = true},
  [260] =
    {field_bound_identifier, 0, .inherited = true},
    {field_name, 0},
    {field_name, 0, .inherited = true},
    {field_value, 2, .inherited = true},
  [264] =
    {field_bound_identifier, 0, .inherited = true},
    {field_computed_value, 2},
    {field_name, 0},
    {field_name, 0, .inherited = true},
  [268] =
    {field_default_value, 3, .inherited = true},
    {field_name, 2},
  [270] =
    {field_name, 0},
    {field_value, 2},
  [272] =
    {field_interpolation, 1},
  [273] =
    {field_interpolation, 0, .inherited = true},
    {field_interpolation, 1, .inherited = true},
  [275] =
    {field_body, 4},
    {field_declaration_kind, 0},
    {field_name, 1},
  [278] =
    {field_body, 1},
  [279] =
    {field_bound_identifier, 4, .inherited = true},
    {field_condition, 4},
    {field_name, 4, .inherited = true},
  [282] =
    {field_name, 1},
    {field_value, 3},
  [284] =
    {field_name, 0, .inherited = true},
    {field_name, 2, .inherited = true},
    {field_type, 2},
  [287] =
    {field_key, 1},
    {field_name, 1, .inherited = true},
    {field_name, 3, .inherited = true},
    {field_value, 3},
  [291] =
    {field_name, 3, .inherited = true},
    {field_params, 0},
    {field_return_type, 3},
  [294] =
    {field_name, 3, .inherited = true},
    {field_return_type, 3},
  [296] =
    {field_name, 0},
    {field_name, 3, .inherited = true},
    {field_type, 3},
  [299] =
    {field_external_name, 0},
    {field_name, 1},
    {field_name, 3, .inherited = true},
    {field_type, 3},
  [303] =
    {field_captures, 1},
    {field_type, 2},
  [305] =
    {field_bound_identifier, 1, .inherited = true},
    {field_error, 1},
    {field_name, 1, .inherited = true},
  [308] =
    {field_bound_identifier, 1, .inherited = true},
    {field_collection, 3},
    {field_item, 1},
    {field_name, 1, .inherited = true},
  [312] =
    {field_name, 1},
    {field_name, 4, .inherited = true},
    {field_value, 4},
  [315] =
    {field_default_value, 4, .inherited = true},
    {field_name, 1},
  [317] =
    {field_body, 4},
    {field_default_value, 3, .inherited = true},
    {field_name, 1},
  [320] =
    {field_body, 4},
    {field_default_value, 2, .inherited = true},
    {field_name, 1},
  [323] =
    {field_body, 1, .inherited = true},
  [324] =
    {field_body, 0, .inherited = true},
    {field_body, 1, .inherited = true},
  [326] =
    {field_body, 4},
    {field_declaration_kind, 1},
    {field_name, 2},
  [329] =
    {field_default_value, 1, .inherited = true},
    {field_default_value, 2, .inherited = true},
  [331] =
    {field_default_value, 2},
  [332] =
    {field_name, 2, .inherited = true},
  [333] =
    {field_body, 4},
    {field_default_value, 3, .inherited = true},
    {field_name, 0},
  [336] =
    {field_body, 4},
    {field_default_value, 2, .inherited = true},
    {field_name, 0},
  [339] =
    {field_body, 4},
    {field_default_value, 1, .inherited = true},
    {field_name, 0},
  [342] =
    {field_default_value, 4},
    {field_name, 1},
    {field_name, 4, .inherited = true},
  [345] =
    {field_name, 1, .inherited = true},
    {field_name, 2, .inherited = true},
  [347] =
    {field_condition, 0},
    {field_if_false, 4},
    {field_if_true, 2},
  [350] =
    {field_default_value, 3, .inherited = true},
    {field_definition, 4},
  [352] =
    {field_default_value, 2, .inherited = true},
    {field_name, 0, .inherited = true},
    {field_name, 4, .inherited = true},
    {field_return_type, 4},
  [356] =
    {field_default_value, 1, .inherited = true},
    {field_name, 0, .inherited = true},
    {field_name, 4, .inherited = true},
    {field_return_type, 4},
  [360] =
    {field_bound_identifier, 0, .inherited = true},
    {field_name, 0},
    {field_name, 0, .inherited = true},
    {field_value, 3, .inherited = true},
  [364] =
    {field_bound_identifier, 0, .inherited = true},
    {field_computed_value, 3},
    {field_name, 0},
    {field_name, 0, .inherited = true},
  [368] =
    {field_default_value, 4, .inherited = true},
    {field_name, 2},
  [370] =
    {field_body, 4},
    {field_default_value, 3, .inherited = true},
    {field_name, 2},
  [373] =
    {field_must_inherit, 4},
    {field_name, 2},
    {field_name, 4, .inherited = true},
  [376] =
    {field_default_value, 4},
    {field_name, 2},
    {field_name, 4, .inherited = true},
  [379] =
    {field_constrained_type, 0},
    {field_inherits_from, 2},
    {field_name, 2, .inherited = true},
  [382] =
    {field_constrained_type, 0},
    {field_must_equal, 2},
    {field_name, 2, .inherited = true},
  [385] =
    {field_body, 5},
    {field_declaration_kind, 0},
    {field_name, 1},
  [388] =
    {field_body, 2},
  [389] =
    {field_bound_identifier, 4, .inherited = true},
    {field_bound_identifier, 5, .inherited = true},
    {field_condition, 4},
    {field_condition, 5, .inherited = true},
    {field_name, 4, .inherited = true},
    {field_name, 5, .inherited = true},
  [395] =
    {field_bound_identifier, 5, .inherited = true},
    {field_condition, 5},
    {field_name, 5, .inherited = true},
  [398] =
    {field_name, 1},
    {field_name, 4, .inherited = true},
    {field_value, 3},
    {field_value, 4, .inherited = true},
  [402] =
    {field_name, 4, .inherited = true},
    {field_params, 0},
    {field_return_type, 4},
  [405] =
    {field_name, 4, .inherited = true},
    {field_return_type, 4},
  [407] =
    {field_external_name, 0},
    {field_name, 1},
    {field_name, 4, .inherited = true},
    {field_type, 4},
  [411] =
    {field_bound_identifier, 2, .inherited = true},
    {field_collection, 4},
    {field_item, 2},
    {field_name, 2, .inherited = true},
  [415] =
    {field_bound_identifier, 1, .inherited = true},
    {field_collection, 4},
    {field_item, 1},
    {field_name, 1, .inherited = true},
  [419] =
    {field_body, 5},
    {field_default_value, 4, .inherited = true},
    {field_name, 1},
  [422] =
    {field_body, 5},
    {field_default_value, 3, .inherited = true},
    {field_name, 1},
  [425] =
    {field_body, 5},
    {field_default_value, 2, .inherited = true},
    {field_name, 1},
  [428] =
    {field_data_contents, 2, .inherited = true},
    {field_name, 1},
    {field_raw_value, 2, .inherited = true},
  [431] =
    {field_data_contents, 0},
  [432] =
    {field_data_contents, 2, .inherited = true},
    {field_name, 1},
    {field_name, 2, .inherited = true},
    {field_raw_value, 2, .inherited = true},
  [436] =
    {field_bound_identifier, 1, .inherited = true},
    {field_name, 1},
    {field_name, 1, .inherited = true},
  [439] =
    {field_body, 5},
    {field_declaration_kind, 1},
    {field_name, 2},
  [442] =
    {field_default_value, 3},
  [443] =
    {field_name, 3, .inherited = true},
  [444] =
    {field_body, 5},
    {field_default_value, 3, .inherited = true},
    {field_name, 0},
  [447] =
    {field_body, 5},
    {field_default_value, 2, .inherited = true},
    {field_name, 0},
  [450] =
    {field_body, 5},
    {field_default_value, 1, .inherited = true},
    {field_name, 0},
  [453] =
    {field_default_value, 5},
    {field_must_inherit, 3},
    {field_name, 1},
    {field_name, 3, .inherited = true},
    {field_name, 5, .inherited = true},
  [458] =
    {field_default_value, 2, .inherited = true},
    {field_name, 0, .inherited = true},
    {field_name, 5, .inherited = true},
    {field_return_type, 5},
  [462] =
    {field_default_value, 1, .inherited = true},
    {field_name, 0, .inherited = true},
    {field_name, 5, .inherited = true},
    {field_return_type, 5},
  [466] =
    {field_default_value, 5, .inherited = true},
    {field_name, 2},
  [468] =
    {field_body, 5},
    {field_default_value, 4, .inherited = true},
    {field_name, 2},
  [471] =
    {field_body, 5},
    {field_default_value, 3, .inherited = true},
    {field_name, 2},
  [474] =
    {field_default_value, 5},
    {field_name, 2},
    {field_name, 5, .inherited = true},
  [477] =
    {field_constrained_type, 1},
    {field_inherits_from, 3},
    {field_name, 3, .inherited = true},
  [480] =
    {field_constrained_type, 1},
    {field_must_equal, 3},
    {field_name, 3, .inherited = true},
  [483] =
    {field_body, 6},
    {field_declaration_kind, 0},
    {field_name, 1},
  [486] =
    {field_bound_identifier, 5, .inherited = true},
    {field_bound_identifier, 6, .inherited = true},
    {field_condition, 5},
    {field_condition, 6, .inherited = true},
    {field_name, 5, .inherited = true},
    {field_name, 6, .inherited = true},
  [492] =
    {field_bound_identifier, 6, .inherited = true},
    {field_condition, 6},
    {field_name, 6, .inherited = true},
  [495] =
    {field_name, 5, .inherited = true},
    {field_return_type, 5},
  [497] =
    {field_bound_identifier, 2, .inherited = true},
    {field_collection, 5},
    {field_item, 2},
    {field_name, 2, .inherited = true},
  [501] =
    {field_bound_identifier, 3, .inherited = true},
    {field_collection, 5},
    {field_item, 3},
    {field_name, 3, .inherited = true},
  [505] =
    {field_body, 6},
    {field_default_value, 4, .inherited = true},
    {field_name, 1},
  [508] =
    {field_body, 6},
    {field_default_value, 3, .inherited = true},
    {field_name, 1},
  [511] =
    {field_body, 6},
    {field_default_value, 2, .inherited = true},
    {field_name, 1},
  [514] =
    {field_raw_value, 1},
  [515] =
    {field_data_contents, 2, .inherited = true},
    {field_data_contents, 3, .inherited = true},
    {field_name, 1},
    {field_name, 3, .inherited = true},
    {field_raw_value, 2, .inherited = true},
    {field_raw_value, 3, .inherited = true},
  [521] =
    {field_data_contents, 0, .inherited = true},
    {field_data_contents, 1, .inherited = true},
    {field_name, 0, .inherited = true},
    {field_name, 1, .inherited = true},
    {field_raw_value, 0, .inherited = true},
    {field_raw_value, 1, .inherited = true},
  [527] =
    {field_data_contents, 3, .inherited = true},
    {field_name, 2},
    {field_raw_value, 3, .inherited = true},
  [530] =
    {field_data_contents, 3, .inherited = true},
    {field_name, 2},
    {field_name, 3, .inherited = true},
    {field_raw_value, 3, .inherited = true},
  [534] =
    {field_name, 3},
  [535] =
    {field_body, 6},
    {field_declaration_kind, 1},
    {field_name, 2},
  [538] =
    {field_body, 6},
    {field_default_value, 3, .inherited = true},
    {field_name, 0},
  [541] =
    {field_body, 6},
    {field_default_value, 2, .inherited = true},
    {field_name, 0},
  [544] =
    {field_default_value, 6},
    {field_must_inherit, 3},
    {field_name, 1},
    {field_name, 3, .inherited = true},
    {field_name, 6, .inherited = true},
  [549] =
    {field_default_value, 2, .inherited = true},
    {field_name, 0, .inherited = true},
    {field_name, 6, .inherited = true},
    {field_return_type, 6},
  [553] =
    {field_body, 6},
    {field_default_value, 5, .inherited = true},
    {field_name, 2},
  [556] =
    {field_body, 6},
    {field_default_value, 4, .inherited = true},
    {field_name, 2},
  [559] =
    {field_body, 6},
    {field_default_value, 3, .inherited = true},
    {field_name, 2},
  [562] =
    {field_default_value, 6},
    {field_must_inherit, 4},
    {field_name, 2},
    {field_name, 4, .inherited = true},
    {field_name, 6, .inherited = true},
  [567] =
    {field_default_value, 1, .inherited = true},
    {field_name, 3, .inherited = true},
    {field_return_type, 3},
  [570] =
    {field_bound_identifier, 6, .inherited = true},
    {field_bound_identifier, 7, .inherited = true},
    {field_condition, 6},
    {field_condition, 7, .inherited = true},
    {field_name, 6, .inherited = true},
    {field_name, 7, .inherited = true},
  [576] =
    {field_name, 6, .inherited = true},
    {field_return_type, 6},
  [578] =
    {field_bound_identifier, 3, .inherited = true},
    {field_collection, 6},
    {field_item, 3},
    {field_name, 3, .inherited = true},
  [582] =
    {field_body, 7},
    {field_default_value, 4, .inherited = true},
    {field_name, 1},
  [585] =
    {field_body, 7},
    {field_default_value, 3, .inherited = true},
    {field_name, 1},
  [588] =
    {field_data_contents, 3, .inherited = true},
    {field_data_contents, 4, .inherited = true},
    {field_name, 2},
    {field_name, 4, .inherited = true},
    {field_raw_value, 3, .inherited = true},
    {field_raw_value, 4, .inherited = true},
  [594] =
    {field_data_contents, 4, .inherited = true},
    {field_name, 3},
    {field_raw_value, 4, .inherited = true},
  [597] =
    {field_data_contents, 4, .inherited = true},
    {field_name, 3},
    {field_name, 4, .inherited = true},
    {field_raw_value, 4, .inherited = true},
  [601] =
    {field_body, 7},
    {field_declaration_kind, 1},
    {field_name, 2},
  [604] =
    {field_body, 7},
    {field_default_value, 3, .inherited = true},
    {field_name, 0},
  [607] =
    {field_body, 7},
    {field_default_value, 5, .inherited = true},
    {field_name, 2},
  [610] =
    {field_body, 7},
    {field_default_value, 4, .inherited = true},
    {field_name, 2},
  [613] =
    {field_body, 7},
    {field_default_value, 3, .inherited = true},
    {field_name, 2},
  [616] =
    {field_default_value, 7},
    {field_must_inherit, 4},
    {field_name, 2},
    {field_name, 4, .inherited = true},
    {field_name, 7, .inherited = true},
  [621] =
    {field_default_value, 2, .inherited = true},
    {field_name, 4, .inherited = true},
    {field_return_type, 4},
  [624] =
    {field_body, 8},
    {field_default_value, 4, .inherited = true},
    {field_name, 1},
  [627] =
    {field_data_contents, 4, .inherited = true},
    {field_data_contents, 5, .inherited = true},
    {field_name, 3},
    {field_name, 5, .inherited = true},
    {field_raw_value, 4, .inherited = true},
    {field_raw_value, 5, .inherited = true},
  [633] =
    {field_body, 8},
    {field_default_value, 5, .inherited = true},
    {field_name, 2},
  [636] =
    {field_body, 8},
    {field_default_value, 4, .inherited = true},
    {field_name, 2},
  [639] =
    {field_default_value, 3, .inherited = true},
    {field_name, 5, .inherited = true},
    {field_return_type, 5},
  [642] =
    {field_body, 9},
    {field_default_value, 5, .inherited = true},
    {field_name, 2},
  [645] =
    {field_name, 4, .inherited = true},
  [646] =
    {field_name, 3, .inherited = true},
    {field_name, 4, .inherited = true},
  [648] =
    {field_name, 1, .inherited = true},
    {field_name, 4, .inherited = true},
  [650] =
    {field_name, 4, .inherited = true},
    {field_name, 5, .inherited = true},
  [652] =
    {field_name, 3, .inherited = true},
    {field_name, 6, .inherited = true},
  [654] =
    {field_name, 4, .inherited = true},
    {field_name, 7, .inherited = true},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [3] = {
    [0] = alias_sym_type_identifier,
  },
  [4] = {
    [0] = alias_sym_fully_open_range,
  },
  [12] = {
    [0] = sym_tuple_type_item,
  },
  [21] = {
    [1] = alias_sym_type_identifier,
  },
  [29] = {
    [1] = alias_sym__expression,
  },
  [34] = {
    [0] = sym__binding_pattern_with_expr,
  },
  [39] = {
    [0] = sym_simple_identifier,
  },
  [41] = {
    [0] = alias_sym_interpolated_expression,
  },
  [43] = {
    [1] = alias_sym_type_identifier,
  },
  [75] = {
    [0] = sym__binding_pattern_with_expr,
  },
  [76] = {
    [0] = sym__binding_pattern_with_expr,
  },
  [78] = {
    [2] = alias_sym_type_identifier,
  },
  [81] = {
    [0] = alias_sym_interpolated_expression,
  },
  [85] = {
    [1] = alias_sym_type_identifier,
  },
  [104] = {
    [0] = sym__binding_pattern_with_expr,
  },
  [105] = {
    [1] = alias_sym_type_identifier,
  },
  [108] = {
    [0] = alias_sym_protocol_function_declaration,
  },
  [111] = {
    [2] = alias_sym_type_identifier,
  },
  [116] = {
    [1] = alias_sym_type_identifier,
  },
  [117] = {
    [1] = alias_sym_type_identifier,
  },
  [123] = {
    [0] = sym__binding_pattern_with_expr,
  },
  [124] = {
    [0] = sym__binding_pattern_with_expr,
  },
  [127] = {
    [1] = alias_sym_interpolated_expression,
  },
  [129] = {
    [1] = alias_sym_type_identifier,
  },
  [140] = {
    [1] = sym__binding_pattern_with_expr,
  },
  [141] = {
    [1] = sym__binding_pattern_with_expr,
  },
  [142] = {
    [1] = alias_sym_type_identifier,
  },
  [146] = {
    [0] = alias_sym_protocol_function_declaration,
    [1] = alias_sym_protocol_function_declaration,
  },
  [150] = {
    [2] = alias_sym_type_identifier,
  },
  [157] = {
    [1] = alias_sym_type_identifier,
  },
  [163] = {
    [0] = sym__binding_pattern_with_expr,
  },
  [164] = {
    [0] = sym__binding_pattern_with_expr,
  },
  [167] = {
    [2] = alias_sym_type_identifier,
  },
  [168] = {
    [2] = alias_sym_type_identifier,
  },
  [171] = {
    [1] = alias_sym_type_identifier,
  },
  [179] = {
    [2] = sym__binding_pattern_with_expr,
  },
  [180] = {
    [1] = sym__binding_pattern_with_expr,
  },
  [188] = {
    [1] = sym__binding_pattern_with_expr,
  },
  [190] = {
    [2] = alias_sym_type_identifier,
  },
  [196] = {
    [1] = alias_sym_type_identifier,
  },
  [202] = {
    [2] = alias_sym_type_identifier,
  },
  [205] = {
    [1] = alias_sym_type_identifier,
  },
  [209] = {
    [2] = sym__binding_pattern_with_expr,
  },
  [210] = {
    [3] = sym__binding_pattern_with_expr,
  },
  [221] = {
    [2] = alias_sym_type_identifier,
  },
  [224] = {
    [1] = alias_sym_type_identifier,
  },
  [229] = {
    [2] = alias_sym_type_identifier,
  },
  [233] = {
    [3] = sym__binding_pattern_with_expr,
  },
  [239] = {
    [2] = alias_sym_type_identifier,
  },
  [244] = {
    [2] = alias_sym_type_identifier,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  sym_simple_identifier, 2,
    sym_simple_identifier,
    alias_sym_type_identifier,
  sym__parenthesized_type, 2,
    sym__parenthesized_type,
    sym_tuple_type_item,
  sym_value_argument, 2,
    sym_value_argument,
    alias_sym_interpolated_expression,
  sym__three_dot_operator, 2,
    sym__three_dot_operator,
    alias_sym_fully_open_range,
  sym__bodyless_function_declaration, 2,
    sym__bodyless_function_declaration,
    alias_sym_protocol_function_declaration,
  sym_function_body, 2,
    sym_function_body,
    alias_sym_protocol_function_declaration,
  sym__binding_pattern_no_expr, 2,
    sym__binding_pattern_no_expr,
    sym__binding_pattern_with_expr,
  sym__no_expr_pattern_already_bound, 2,
    sym__no_expr_pattern_already_bound,
    sym__binding_pattern_with_expr,
  sym__binding_kind_and_pattern, 2,
    sym__binding_kind_and_pattern,
    sym__binding_pattern_with_expr,
  0,
};

static TSCharacterRange aux_sym_simple_identifier_token1_character_set_1[] = {
  {'A', 'Z'}, {'_', '_'}, {'a', 'z'}, {0xa9, 0xaa}, {0xae, 0xae}, {0xb5, 0xb5}, {0xba, 0xba}, {0xc0, 0xd6},
  {0xd8, 0xf6}, {0xf8, 0x2c1}, {0x2c6, 0x2d1}, {0x2e0, 0x2e4}, {0x2ec, 0x2ec}, {0x2ee, 0x2ee}, {0x370, 0x374}, {0x376, 0x377},
  {0x37b, 0x37d}, {0x37f, 0x37f}, {0x386, 0x386}, {0x388, 0x38a}, {0x38c, 0x38c}, {0x38e, 0x3a1}, {0x3a3, 0x3f5}, {0x3f7, 0x481},
  {0x48a, 0x52f}, {0x531, 0x556}, {0x559, 0x559}, {0x560, 0x588}, {0x5d0, 0x5ea}, {0x5ef, 0x5f2}, {0x620, 0x64a}, {0x66e, 0x66f},
  {0x671, 0x6d3}, {0x6d5, 0x6d5}, {0x6e5, 0x6e6}, {0x6ee, 0x6ef}, {0x6fa, 0x6fc}, {0x6ff, 0x6ff}, {0x710, 0x710}, {0x712, 0x72f},
  {0x74d, 0x7a5}, {0x7b1, 0x7b1}, {0x7ca, 0x7ea}, {0x7f4, 0x7f5}, {0x7fa, 0x7fa}, {0x800, 0x815}, {0x81a, 0x81a}, {0x824, 0x824},
  {0x828, 0x828}, {0x840, 0x858}, {0x860, 0x86a}, {0x870, 0x887}, {0x889, 0x88e}, {0x8a0, 0x8c9}, {0x904, 0x939}, {0x93d, 0x93d},
  {0x950, 0x950}, {0x958, 0x961}, {0x971, 0x980}, {0x985, 0x98c}, {0x98f, 0x990}, {0x993, 0x9a8}, {0x9aa, 0x9b0}, {0x9b2, 0x9b2},
  {0x9b6, 0x9b9}, {0x9bd, 0x9bd}, {0x9ce, 0x9ce}, {0x9dc, 0x9dd}, {0x9df, 0x9e1}, {0x9f0, 0x9f1}, {0x9fc, 0x9fc}, {0xa05, 0xa0a},
  {0xa0f, 0xa10}, {0xa13, 0xa28}, {0xa2a, 0xa30}, {0xa32, 0xa33}, {0xa35, 0xa36}, {0xa38, 0xa39}, {0xa59, 0xa5c}, {0xa5e, 0xa5e},
  {0xa72, 0xa74}, {0xa85, 0xa8d}, {0xa8f, 0xa91}, {0xa93, 0xaa8}, {0xaaa, 0xab0}, {0xab2, 0xab3}, {0xab5, 0xab9}, {0xabd, 0xabd},
  {0xad0, 0xad0}, {0xae0, 0xae1}, {0xaf9, 0xaf9}, {0xb05, 0xb0c}, {0xb0f, 0xb10}, {0xb13, 0xb28}, {0xb2a, 0xb30}, {0xb32, 0xb33},
  {0xb35, 0xb39}, {0xb3d, 0xb3d}, {0xb5c, 0xb5d}, {0xb5f, 0xb61}, {0xb71, 0xb71}, {0xb83, 0xb83}, {0xb85, 0xb8a}, {0xb8e, 0xb90},
  {0xb92, 0xb95}, {0xb99, 0xb9a}, {0xb9c, 0xb9c}, {0xb9e, 0xb9f}, {0xba3, 0xba4}, {0xba8, 0xbaa}, {0xbae, 0xbb9}, {0xbd0, 0xbd0},
  {0xc05, 0xc0c}, {0xc0e, 0xc10}, {0xc12, 0xc28}, {0xc2a, 0xc39}, {0xc3d, 0xc3d}, {0xc58, 0xc5a}, {0xc5d, 0xc5d}, {0xc60, 0xc61},
  {0xc80, 0xc80}, {0xc85, 0xc8c}, {0xc8e, 0xc90}, {0xc92, 0xca8}, {0xcaa, 0xcb3}, {0xcb5, 0xcb9}, {0xcbd, 0xcbd}, {0xcdd, 0xcde},
  {0xce0, 0xce1}, {0xcf1, 0xcf2}, {0xd04, 0xd0c}, {0xd0e, 0xd10}, {0xd12, 0xd3a}, {0xd3d, 0xd3d}, {0xd4e, 0xd4e}, {0xd54, 0xd56},
  {0xd5f, 0xd61}, {0xd7a, 0xd7f}, {0xd85, 0xd96}, {0xd9a, 0xdb1}, {0xdb3, 0xdbb}, {0xdbd, 0xdbd}, {0xdc0, 0xdc6}, {0xe01, 0xe30},
  {0xe32, 0xe32}, {0xe40, 0xe46}, {0xe81, 0xe82}, {0xe84, 0xe84}, {0xe86, 0xe8a}, {0xe8c, 0xea3}, {0xea5, 0xea5}, {0xea7, 0xeb0},
  {0xeb2, 0xeb2}, {0xebd, 0xebd}, {0xec0, 0xec4}, {0xec6, 0xec6}, {0xedc, 0xedf}, {0xf00, 0xf00}, {0xf40, 0xf47}, {0xf49, 0xf6c},
  {0xf88, 0xf8c}, {0x1000, 0x102a}, {0x103f, 0x103f}, {0x1050, 0x1055}, {0x105a, 0x105d}, {0x1061, 0x1061}, {0x1065, 0x1066}, {0x106e, 0x1070},
  {0x1075, 0x1081}, {0x108e, 0x108e}, {0x10a0, 0x10c5}, {0x10c7, 0x10c7}, {0x10cd, 0x10cd}, {0x10d0, 0x10fa}, {0x10fc, 0x1248}, {0x124a, 0x124d},
  {0x1250, 0x1256}, {0x1258, 0x1258}, {0x125a, 0x125d}, {0x1260, 0x1288}, {0x128a, 0x128d}, {0x1290, 0x12b0}, {0x12b2, 0x12b5}, {0x12b8, 0x12be},
  {0x12c0, 0x12c0}, {0x12c2, 0x12c5}, {0x12c8, 0x12d6}, {0x12d8, 0x1310}, {0x1312, 0x1315}, {0x1318, 0x135a}, {0x1380, 0x138f}, {0x13a0, 0x13f5},
  {0x13f8, 0x13fd}, {0x1401, 0x166c}, {0x166f, 0x167f}, {0x1681, 0x169a}, {0x16a0, 0x16ea}, {0x16ee, 0x16f8}, {0x1700, 0x1711}, {0x171f, 0x1731},
  {0x1740, 0x1751}, {0x1760, 0x176c}, {0x176e, 0x1770}, {0x1780, 0x17b3}, {0x17d7, 0x17d7}, {0x17dc, 0x17dc}, {0x1820, 0x1878}, {0x1880, 0x18a8},
  {0x18aa, 0x18aa}, {0x18b0, 0x18f5}, {0x1900, 0x191e}, {0x1950, 0x196d}, {0x1970, 0x1974}, {0x1980, 0x19ab}, {0x19b0, 0x19c9}, {0x1a00, 0x1a16},
  {0x1a20, 0x1a54}, {0x1aa7, 0x1aa7}, {0x1b05, 0x1b33}, {0x1b45, 0x1b4c}, {0x1b83, 0x1ba0}, {0x1bae, 0x1baf}, {0x1bba, 0x1be5}, {0x1c00, 0x1c23},
  {0x1c4d, 0x1c4f}, {0x1c5a, 0x1c7d}, {0x1c80, 0x1c88}, {0x1c90, 0x1cba}, {0x1cbd, 0x1cbf}, {0x1ce9, 0x1cec}, {0x1cee, 0x1cf3}, {0x1cf5, 0x1cf6},
  {0x1cfa, 0x1cfa}, {0x1d00, 0x1dbf}, {0x1e00, 0x1f15}, {0x1f18, 0x1f1d}, {0x1f20, 0x1f45}, {0x1f48, 0x1f4d}, {0x1f50, 0x1f57}, {0x1f59, 0x1f59},
  {0x1f5b, 0x1f5b}, {0x1f5d, 0x1f5d}, {0x1f5f, 0x1f7d}, {0x1f80, 0x1fb4}, {0x1fb6, 0x1fbc}, {0x1fbe, 0x1fbe}, {0x1fc2, 0x1fc4}, {0x1fc6, 0x1fcc},
  {0x1fd0, 0x1fd3}, {0x1fd6, 0x1fdb}, {0x1fe0, 0x1fec}, {0x1ff2, 0x1ff4}, {0x1ff6, 0x1ffc}, {0x203c, 0x203c}, {0x2049, 0x2049}, {0x2071, 0x2071},
  {0x207f, 0x207f}, {0x2090, 0x209c}, {0x2102, 0x2102}, {0x2107, 0x2107}, {0x210a, 0x2113}, {0x2115, 0x2115}, {0x2118, 0x211d}, {0x2122, 0x2122},
  {0x2124, 0x2124}, {0x2126, 0x2126}, {0x2128, 0x2128}, {0x212a, 0x2139}, {0x213c, 0x213f}, {0x2145, 0x2149}, {0x214e, 0x214e}, {0x2160, 0x2188},
  {0x2194, 0x2199}, {0x21a9, 0x21aa}, {0x231a, 0x231b}, {0x2328, 0x2328}, {0x23cf, 0x23cf}, {0x23e9, 0x23f3}, {0x23f8, 0x23fa}, {0x24c2, 0x24c2},
  {0x25aa, 0x25ab}, {0x25b6, 0x25b6}, {0x25c0, 0x25c0}, {0x25fb, 0x25fe}, {0x2600, 0x2604}, {0x260e, 0x260e}, {0x2611, 0x2611}, {0x2614, 0x2615},
  {0x2618, 0x2618}, {0x261d, 0x261d}, {0x2620, 0x2620}, {0x2622, 0x2623}, {0x2626, 0x2626}, {0x262a, 0x262a}, {0x262e, 0x262f}, {0x2638, 0x263a},
  {0x2640, 0x2640}, {0x2642, 0x2642}, {0x2648, 0x2653}, {0x265f, 0x2660}, {0x2663, 0x2663}, {0x2665, 0x2666}, {0x2668, 0x2668}, {0x267b, 0x267b},
  {0x267e, 0x267f}, {0x2692, 0x2697}, {0x2699, 0x2699}, {0x269b, 0x269c}, {0x26a0, 0x26a1}, {0x26a7, 0x26a7}, {0x26aa, 0x26ab}, {0x26b0, 0x26b1},
  {0x26bd, 0x26be}, {0x26c4, 0x26c5}, {0x26c8, 0x26c8}, {0x26ce, 0x26cf}, {0x26d1, 0x26d1}, {0x26d3, 0x26d4}, {0x26e9, 0x26ea}, {0x26f0, 0x26f5},
  {0x26f7, 0x26fa}, {0x26fd, 0x26fd}, {0x2702, 0x2702}, {0x2705, 0x2705}, {0x2708, 0x270d}, {0x270f, 0x270f}, {0x2712, 0x2712}, {0x2714, 0x2714},
  {0x2716, 0x2716}, {0x271d, 0x271d}, {0x2721, 0x2721}, {0x2728, 0x2728}, {0x2733, 0x2734}, {0x2744, 0x2744}, {0x2747, 0x2747}, {0x274c, 0x274c},
  {0x274e, 0x274e}, {0x2753, 0x2755}, {0x2757, 0x2757}, {0x2763, 0x2764}, {0x2795, 0x2797}, {0x27a1, 0x27a1}, {0x27b0, 0x27b0}, {0x27bf, 0x27bf},
  {0x2934, 0x2935}, {0x2b05, 0x2b07}, {0x2b1b, 0x2b1c}, {0x2b50, 0x2b50}, {0x2b55, 0x2b55}, {0x2c00, 0x2ce4}, {0x2ceb, 0x2cee}, {0x2cf2, 0x2cf3},
  {0x2d00, 0x2d25}, {0x2d27, 0x2d27}, {0x2d2d, 0x2d2d}, {0x2d30, 0x2d67}, {0x2d6f, 0x2d6f}, {0x2d80, 0x2d96}, {0x2da0, 0x2da6}, {0x2da8, 0x2dae},
  {0x2db0, 0x2db6}, {0x2db8, 0x2dbe}, {0x2dc0, 0x2dc6}, {0x2dc8, 0x2dce}, {0x2dd0, 0x2dd6}, {0x2dd8, 0x2dde}, {0x3005, 0x3007}, {0x3021, 0x3029},
  {0x3030, 0x3035}, {0x3038, 0x303d}, {0x3041, 0x3096}, {0x309d, 0x309f}, {0x30a1, 0x30fa}, {0x30fc, 0x30ff}, {0x3105, 0x312f}, {0x3131, 0x318e},
  {0x31a0, 0x31bf}, {0x31f0, 0x31ff}, {0x3297, 0x3297}, {0x3299, 0x3299}, {0x3400, 0x4dbf}, {0x4e00, 0xa48c}, {0xa4d0, 0xa4fd}, {0xa500, 0xa60c},
  {0xa610, 0xa61f}, {0xa62a, 0xa62b}, {0xa640, 0xa66e}, {0xa67f, 0xa69d}, {0xa6a0, 0xa6ef}, {0xa717, 0xa71f}, {0xa722, 0xa788}, {0xa78b, 0xa7ca},
  {0xa7d0, 0xa7d1}, {0xa7d3, 0xa7d3}, {0xa7d5, 0xa7d9}, {0xa7f2, 0xa801}, {0xa803, 0xa805}, {0xa807, 0xa80a}, {0xa80c, 0xa822}, {0xa840, 0xa873},
  {0xa882, 0xa8b3}, {0xa8f2, 0xa8f7}, {0xa8fb, 0xa8fb}, {0xa8fd, 0xa8fe}, {0xa90a, 0xa925}, {0xa930, 0xa946}, {0xa960, 0xa97c}, {0xa984, 0xa9b2},
  {0xa9cf, 0xa9cf}, {0xa9e0, 0xa9e4}, {0xa9e6, 0xa9ef}, {0xa9fa, 0xa9fe}, {0xaa00, 0xaa28}, {0xaa40, 0xaa42}, {0xaa44, 0xaa4b}, {0xaa60, 0xaa76},
  {0xaa7a, 0xaa7a}, {0xaa7e, 0xaaaf}, {0xaab1, 0xaab1}, {0xaab5, 0xaab6}, {0xaab9, 0xaabd}, {0xaac0, 0xaac0}, {0xaac2, 0xaac2}, {0xaadb, 0xaadd},
  {0xaae0, 0xaaea}, {0xaaf2, 0xaaf4}, {0xab01, 0xab06}, {0xab09, 0xab0e}, {0xab11, 0xab16}, {0xab20, 0xab26}, {0xab28, 0xab2e}, {0xab30, 0xab5a},
  {0xab5c, 0xab69}, {0xab70, 0xabe2}, {0xac00, 0xd7a3}, {0xd7b0, 0xd7c6}, {0xd7cb, 0xd7fb}, {0xf900, 0xfa6d}, {0xfa70, 0xfad9}, {0xfb00, 0xfb06},
  {0xfb13, 0xfb17}, {0xfb1d, 0xfb1d}, {0xfb1f, 0xfb28}, {0xfb2a, 0xfb36}, {0xfb38, 0xfb3c}, {0xfb3e, 0xfb3e}, {0xfb40, 0xfb41}, {0xfb43, 0xfb44},
  {0xfb46, 0xfbb1}, {0xfbd3, 0xfc5d}, {0xfc64, 0xfd3d}, {0xfd50, 0xfd8f}, {0xfd92, 0xfdc7}, {0xfdf0, 0xfdf9}, {0xfe71, 0xfe71}, {0xfe73, 0xfe73},
  {0xfe77, 0xfe77}, {0xfe79, 0xfe79}, {0xfe7b, 0xfe7b}, {0xfe7d, 0xfe7d}, {0xfe7f, 0xfefc}, {0xff21, 0xff3a}, {0xff41, 0xff5a}, {0xff66, 0xff9d},
  {0xffa0, 0xffbe}, {0xffc2, 0xffc7}, {0xffca, 0xffcf}, {0xffd2, 0xffd7}, {0xffda, 0xffdc}, {0x10000, 0x1000b}, {0x1000d, 0x10026}, {0x10028, 0x1003a},
  {0x1003c, 0x1003d}, {0x1003f, 0x1004d}, {0x10050, 0x1005d}, {0x10080, 0x100fa}, {0x10140, 0x10174}, {0x10280, 0x1029c}, {0x102a0, 0x102d0}, {0x10300, 0x1031f},
  {0x1032d, 0x1034a}, {0x10350, 0x10375}, {0x10380, 0x1039d}, {0x103a0, 0x103c3}, {0x103c8, 0x103cf}, {0x103d1, 0x103d5}, {0x10400, 0x1049d}, {0x104b0, 0x104d3},
  {0x104d8, 0x104fb}, {0x10500, 0x10527}, {0x10530, 0x10563}, {0x10570, 0x1057a}, {0x1057c, 0x1058a}, {0x1058c, 0x10592}, {0x10594, 0x10595}, {0x10597, 0x105a1},
  {0x105a3, 0x105b1}, {0x105b3, 0x105b9}, {0x105bb, 0x105bc}, {0x10600, 0x10736}, {0x10740, 0x10755}, {0x10760, 0x10767}, {0x10780, 0x10785}, {0x10787, 0x107b0},
  {0x107b2, 0x107ba}, {0x10800, 0x10805}, {0x10808, 0x10808}, {0x1080a, 0x10835}, {0x10837, 0x10838}, {0x1083c, 0x1083c}, {0x1083f, 0x10855}, {0x10860, 0x10876},
  {0x10880, 0x1089e}, {0x108e0, 0x108f2}, {0x108f4, 0x108f5}, {0x10900, 0x10915}, {0x10920, 0x10939}, {0x10980, 0x109b7}, {0x109be, 0x109bf}, {0x10a00, 0x10a00},
  {0x10a10, 0x10a13}, {0x10a15, 0x10a17}, {0x10a19, 0x10a35}, {0x10a60, 0x10a7c}, {0x10a80, 0x10a9c}, {0x10ac0, 0x10ac7}, {0x10ac9, 0x10ae4}, {0x10b00, 0x10b35},
  {0x10b40, 0x10b55}, {0x10b60, 0x10b72}, {0x10b80, 0x10b91}, {0x10c00, 0x10c48}, {0x10c80, 0x10cb2}, {0x10cc0, 0x10cf2}, {0x10d00, 0x10d23}, {0x10e80, 0x10ea9},
  {0x10eb0, 0x10eb1}, {0x10f00, 0x10f1c}, {0x10f27, 0x10f27}, {0x10f30, 0x10f45}, {0x10f70, 0x10f81}, {0x10fb0, 0x10fc4}, {0x10fe0, 0x10ff6}, {0x11003, 0x11037},
  {0x11071, 0x11072}, {0x11075, 0x11075}, {0x11083, 0x110af}, {0x110d0, 0x110e8}, {0x11103, 0x11126}, {0x11144, 0x11144}, {0x11147, 0x11147}, {0x11150, 0x11172},
  {0x11176, 0x11176}, {0x11183, 0x111b2}, {0x111c1, 0x111c4}, {0x111da, 0x111da}, {0x111dc, 0x111dc}, {0x11200, 0x11211}, {0x11213, 0x1122b}, {0x11280, 0x11286},
  {0x11288, 0x11288}, {0x1128a, 0x1128d}, {0x1128f, 0x1129d}, {0x1129f, 0x112a8}, {0x112b0, 0x112de}, {0x11305, 0x1130c}, {0x1130f, 0x11310}, {0x11313, 0x11328},
  {0x1132a, 0x11330}, {0x11332, 0x11333}, {0x11335, 0x11339}, {0x1133d, 0x1133d}, {0x11350, 0x11350}, {0x1135d, 0x11361}, {0x11400, 0x11434}, {0x11447, 0x1144a},
  {0x1145f, 0x11461}, {0x11480, 0x114af}, {0x114c4, 0x114c5}, {0x114c7, 0x114c7}, {0x11580, 0x115ae}, {0x115d8, 0x115db}, {0x11600, 0x1162f}, {0x11644, 0x11644},
  {0x11680, 0x116aa}, {0x116b8, 0x116b8}, {0x11700, 0x1171a}, {0x11740, 0x11746}, {0x11800, 0x1182b}, {0x118a0, 0x118df}, {0x118ff, 0x11906}, {0x11909, 0x11909},
  {0x1190c, 0x11913}, {0x11915, 0x11916}, {0x11918, 0x1192f}, {0x1193f, 0x1193f}, {0x11941, 0x11941}, {0x119a0, 0x119a7}, {0x119aa, 0x119d0}, {0x119e1, 0x119e1},
  {0x119e3, 0x119e3}, {0x11a00, 0x11a00}, {0x11a0b, 0x11a32}, {0x11a3a, 0x11a3a}, {0x11a50, 0x11a50}, {0x11a5c, 0x11a89}, {0x11a9d, 0x11a9d}, {0x11ab0, 0x11af8},
  {0x11c00, 0x11c08}, {0x11c0a, 0x11c2e}, {0x11c40, 0x11c40}, {0x11c72, 0x11c8f}, {0x11d00, 0x11d06}, {0x11d08, 0x11d09}, {0x11d0b, 0x11d30}, {0x11d46, 0x11d46},
  {0x11d60, 0x11d65}, {0x11d67, 0x11d68}, {0x11d6a, 0x11d89}, {0x11d98, 0x11d98}, {0x11ee0, 0x11ef2}, {0x11fb0, 0x11fb0}, {0x12000, 0x12399}, {0x12400, 0x1246e},
  {0x12480, 0x12543}, {0x12f90, 0x12ff0}, {0x13000, 0x1342e}, {0x14400, 0x14646}, {0x16800, 0x16a38}, {0x16a40, 0x16a5e}, {0x16a70, 0x16abe}, {0x16ad0, 0x16aed},
  {0x16b00, 0x16b2f}, {0x16b40, 0x16b43}, {0x16b63, 0x16b77}, {0x16b7d, 0x16b8f}, {0x16e40, 0x16e7f}, {0x16f00, 0x16f4a}, {0x16f50, 0x16f50}, {0x16f93, 0x16f9f},
  {0x16fe0, 0x16fe1}, {0x16fe3, 0x16fe3}, {0x17000, 0x187f7}, {0x18800, 0x18cd5}, {0x18d00, 0x18d08}, {0x1aff0, 0x1aff3}, {0x1aff5, 0x1affb}, {0x1affd, 0x1affe},
  {0x1b000, 0x1b122}, {0x1b150, 0x1b152}, {0x1b164, 0x1b167}, {0x1b170, 0x1b2fb}, {0x1bc00, 0x1bc6a}, {0x1bc70, 0x1bc7c}, {0x1bc80, 0x1bc88}, {0x1bc90, 0x1bc99},
  {0x1d400, 0x1d454}, {0x1d456, 0x1d49c}, {0x1d49e, 0x1d49f}, {0x1d4a2, 0x1d4a2}, {0x1d4a5, 0x1d4a6}, {0x1d4a9, 0x1d4ac}, {0x1d4ae, 0x1d4b9}, {0x1d4bb, 0x1d4bb},
  {0x1d4bd, 0x1d4c3}, {0x1d4c5, 0x1d505}, {0x1d507, 0x1d50a}, {0x1d50d, 0x1d514}, {0x1d516, 0x1d51c}, {0x1d51e, 0x1d539}, {0x1d53b, 0x1d53e}, {0x1d540, 0x1d544},
  {0x1d546, 0x1d546}, {0x1d54a, 0x1d550}, {0x1d552, 0x1d6a5}, {0x1d6a8, 0x1d6c0}, {0x1d6c2, 0x1d6da}, {0x1d6dc, 0x1d6fa}, {0x1d6fc, 0x1d714}, {0x1d716, 0x1d734},
  {0x1d736, 0x1d74e}, {0x1d750, 0x1d76e}, {0x1d770, 0x1d788}, {0x1d78a, 0x1d7a8}, {0x1d7aa, 0x1d7c2}, {0x1d7c4, 0x1d7cb}, {0x1df00, 0x1df1e}, {0x1e100, 0x1e12c},
  {0x1e137, 0x1e13d}, {0x1e14e, 0x1e14e}, {0x1e290, 0x1e2ad}, {0x1e2c0, 0x1e2eb}, {0x1e7e0, 0x1e7e6}, {0x1e7e8, 0x1e7eb}, {0x1e7ed, 0x1e7ee}, {0x1e7f0, 0x1e7fe},
  {0x1e800, 0x1e8c4}, {0x1e900, 0x1e943}, {0x1e94b, 0x1e94b}, {0x1ee00, 0x1ee03}, {0x1ee05, 0x1ee1f}, {0x1ee21, 0x1ee22}, {0x1ee24, 0x1ee24}, {0x1ee27, 0x1ee27},
  {0x1ee29, 0x1ee32}, {0x1ee34, 0x1ee37}, {0x1ee39, 0x1ee39}, {0x1ee3b, 0x1ee3b}, {0x1ee42, 0x1ee42}, {0x1ee47, 0x1ee47}, {0x1ee49, 0x1ee49}, {0x1ee4b, 0x1ee4b},
  {0x1ee4d, 0x1ee4f}, {0x1ee51, 0x1ee52}, {0x1ee54, 0x1ee54}, {0x1ee57, 0x1ee57}, {0x1ee59, 0x1ee59}, {0x1ee5b, 0x1ee5b}, {0x1ee5d, 0x1ee5d}, {0x1ee5f, 0x1ee5f},
  {0x1ee61, 0x1ee62}, {0x1ee64, 0x1ee64}, {0x1ee67, 0x1ee6a}, {0x1ee6c, 0x1ee72}, {0x1ee74, 0x1ee77}, {0x1ee79, 0x1ee7c}, {0x1ee7e, 0x1ee7e}, {0x1ee80, 0x1ee89},
  {0x1ee8b, 0x1ee9b}, {0x1eea1, 0x1eea3}, {0x1eea5, 0x1eea9}, {0x1eeab, 0x1eebb}, {0x1f004, 0x1f004}, {0x1f0cf, 0x1f0cf}, {0x1f170, 0x1f171}, {0x1f17e, 0x1f17f},
  {0x1f18e, 0x1f18e}, {0x1f191, 0x1f19a}, {0x1f1e6, 0x1f1ff}, {0x1f201, 0x1f202}, {0x1f21a, 0x1f21a}, {0x1f22f, 0x1f22f}, {0x1f232, 0x1f23a}, {0x1f250, 0x1f251},
  {0x1f300, 0x1f321}, {0x1f324, 0x1f393}, {0x1f396, 0x1f397}, {0x1f399, 0x1f39b}, {0x1f39e, 0x1f3f0}, {0x1f3f3, 0x1f3f5}, {0x1f3f7, 0x1f4fd}, {0x1f4ff, 0x1f53d},
  {0x1f549, 0x1f54e}, {0x1f550, 0x1f567}, {0x1f56f, 0x1f570}, {0x1f573, 0x1f57a}, {0x1f587, 0x1f587}, {0x1f58a, 0x1f58d}, {0x1f590, 0x1f590}, {0x1f595, 0x1f596},
  {0x1f5a4, 0x1f5a5}, {0x1f5a8, 0x1f5a8}, {0x1f5b1, 0x1f5b2}, {0x1f5bc, 0x1f5bc}, {0x1f5c2, 0x1f5c4}, {0x1f5d1, 0x1f5d3}, {0x1f5dc, 0x1f5de}, {0x1f5e1, 0x1f5e1},
  {0x1f5e3, 0x1f5e3}, {0x1f5e8, 0x1f5e8}, {0x1f5ef, 0x1f5ef}, {0x1f5f3, 0x1f5f3}, {0x1f5fa, 0x1f64f}, {0x1f680, 0x1f6c5}, {0x1f6cb, 0x1f6d2}, {0x1f6d5, 0x1f6d7},
  {0x1f6dd, 0x1f6e5}, {0x1f6e9, 0x1f6e9}, {0x1f6eb, 0x1f6ec}, {0x1f6f0, 0x1f6f0}, {0x1f6f3, 0x1f6fc}, {0x1f7e0, 0x1f7eb}, {0x1f7f0, 0x1f7f0}, {0x1f90c, 0x1f93a},
  {0x1f93c, 0x1f945}, {0x1f947, 0x1f9ff}, {0x1fa70, 0x1fa74}, {0x1fa78, 0x1fa7c}, {0x1fa80, 0x1fa86}, {0x1fa90, 0x1faac}, {0x1fab0, 0x1faba}, {0x1fac0, 0x1fac5},
  {0x1fad0, 0x1fad9}, {0x1fae0, 0x1fae7}, {0x1faf0, 0x1faf6}, {0x20000, 0x2a6df}, {0x2a700, 0x2b738}, {0x2b740, 0x2b81d}, {0x2b820, 0x2cea1}, {0x2ceb0, 0x2ebe0},
  {0x2f800, 0x2fa1d}, {0x30000, 0x3134a},
};

static TSCharacterRange aux_sym_simple_identifier_token1_character_set_2[] = {
  {'#', '#'}, {'*', '*'}, {'0', '9'}, {'A', 'Z'}, {'_', '_'}, {'a', 'z'}, {0xa9, 0xaa}, {0xae, 0xae},
  {0xb5, 0xb5}, {0xb7, 0xb7}, {0xba, 0xba}, {0xc0, 0xd6}, {0xd8, 0xf6}, {0xf8, 0x2c1}, {0x2c6, 0x2d1}, {0x2e0, 0x2e4},
  {0x2ec, 0x2ec}, {0x2ee, 0x2ee}, {0x300, 0x374}, {0x376, 0x377}, {0x37b, 0x37d}, {0x37f, 0x37f}, {0x386, 0x38a}, {0x38c, 0x38c},
  {0x38e, 0x3a1}, {0x3a3, 0x3f5}, {0x3f7, 0x481}, {0x483, 0x487}, {0x48a, 0x52f}, {0x531, 0x556}, {0x559, 0x559}, {0x560, 0x588},
  {0x591, 0x5bd}, {0x5bf, 0x5bf}, {0x5c1, 0x5c2}, {0x5c4, 0x5c5}, {0x5c7, 0x5c7}, {0x5d0, 0x5ea}, {0x5ef, 0x5f2}, {0x610, 0x61a},
  {0x620, 0x669}, {0x66e, 0x6d3}, {0x6d5, 0x6dc}, {0x6df, 0x6e8}, {0x6ea, 0x6fc}, {0x6ff, 0x6ff}, {0x710, 0x74a}, {0x74d, 0x7b1},
  {0x7c0, 0x7f5}, {0x7fa, 0x7fa}, {0x7fd, 0x7fd}, {0x800, 0x82d}, {0x840, 0x85b}, {0x860, 0x86a}, {0x870, 0x887}, {0x889, 0x88e},
  {0x898, 0x8e1}, {0x8e3, 0x963}, {0x966, 0x96f}, {0x971, 0x983}, {0x985, 0x98c}, {0x98f, 0x990}, {0x993, 0x9a8}, {0x9aa, 0x9b0},
  {0x9b2, 0x9b2}, {0x9b6, 0x9b9}, {0x9bc, 0x9c4}, {0x9c7, 0x9c8}, {0x9cb, 0x9ce}, {0x9d7, 0x9d7}, {0x9dc, 0x9dd}, {0x9df, 0x9e3},
  {0x9e6, 0x9f1}, {0x9fc, 0x9fc}, {0x9fe, 0x9fe}, {0xa01, 0xa03}, {0xa05, 0xa0a}, {0xa0f, 0xa10}, {0xa13, 0xa28}, {0xa2a, 0xa30},
  {0xa32, 0xa33}, {0xa35, 0xa36}, {0xa38, 0xa39}, {0xa3c, 0xa3c}, {0xa3e, 0xa42}, {0xa47, 0xa48}, {0xa4b, 0xa4d}, {0xa51, 0xa51},
  {0xa59, 0xa5c}, {0xa5e, 0xa5e}, {0xa66, 0xa75}, {0xa81, 0xa83}, {0xa85, 0xa8d}, {0xa8f, 0xa91}, {0xa93, 0xaa8}, {0xaaa, 0xab0},
  {0xab2, 0xab3}, {0xab5, 0xab9}, {0xabc, 0xac5}, {0xac7, 0xac9}, {0xacb, 0xacd}, {0xad0, 0xad0}, {0xae0, 0xae3}, {0xae6, 0xaef},
  {0xaf9, 0xaff}, {0xb01, 0xb03}, {0xb05, 0xb0c}, {0xb0f, 0xb10}, {0xb13, 0xb28}, {0xb2a, 0xb30}, {0xb32, 0xb33}, {0xb35, 0xb39},
  {0xb3c, 0xb44}, {0xb47, 0xb48}, {0xb4b, 0xb4d}, {0xb55, 0xb57}, {0xb5c, 0xb5d}, {0xb5f, 0xb63}, {0xb66, 0xb6f}, {0xb71, 0xb71},
  {0xb82, 0xb83}, {0xb85, 0xb8a}, {0xb8e, 0xb90}, {0xb92, 0xb95}, {0xb99, 0xb9a}, {0xb9c, 0xb9c}, {0xb9e, 0xb9f}, {0xba3, 0xba4},
  {0xba8, 0xbaa}, {0xbae, 0xbb9}, {0xbbe, 0xbc2}, {0xbc6, 0xbc8}, {0xbca, 0xbcd}, {0xbd0, 0xbd0}, {0xbd7, 0xbd7}, {0xbe6, 0xbef},
  {0xc00, 0xc0c}, {0xc0e, 0xc10}, {0xc12, 0xc28}, {0xc2a, 0xc39}, {0xc3c, 0xc44}, {0xc46, 0xc48}, {0xc4a, 0xc4d}, {0xc55, 0xc56},
  {0xc58, 0xc5a}, {0xc5d, 0xc5d}, {0xc60, 0xc63}, {0xc66, 0xc6f}, {0xc80, 0xc83}, {0xc85, 0xc8c}, {0xc8e, 0xc90}, {0xc92, 0xca8},
  {0xcaa, 0xcb3}, {0xcb5, 0xcb9}, {0xcbc, 0xcc4}, {0xcc6, 0xcc8}, {0xcca, 0xccd}, {0xcd5, 0xcd6}, {0xcdd, 0xcde}, {0xce0, 0xce3},
  {0xce6, 0xcef}, {0xcf1, 0xcf2}, {0xd00, 0xd0c}, {0xd0e, 0xd10}, {0xd12, 0xd44}, {0xd46, 0xd48}, {0xd4a, 0xd4e}, {0xd54, 0xd57},
  {0xd5f, 0xd63}, {0xd66, 0xd6f}, {0xd7a, 0xd7f}, {0xd81, 0xd83}, {0xd85, 0xd96}, {0xd9a, 0xdb1}, {0xdb3, 0xdbb}, {0xdbd, 0xdbd},
  {0xdc0, 0xdc6}, {0xdca, 0xdca}, {0xdcf, 0xdd4}, {0xdd6, 0xdd6}, {0xdd8, 0xddf}, {0xde6, 0xdef}, {0xdf2, 0xdf3}, {0xe01, 0xe3a},
  {0xe40, 0xe4e}, {0xe50, 0xe59}, {0xe81, 0xe82}, {0xe84, 0xe84}, {0xe86, 0xe8a}, {0xe8c, 0xea3}, {0xea5, 0xea5}, {0xea7, 0xebd},
  {0xec0, 0xec4}, {0xec6, 0xec6}, {0xec8, 0xecd}, {0xed0, 0xed9}, {0xedc, 0xedf}, {0xf00, 0xf00}, {0xf18, 0xf19}, {0xf20, 0xf29},
  {0xf35, 0xf35}, {0xf37, 0xf37}, {0xf39, 0xf39}, {0xf3e, 0xf47}, {0xf49, 0xf6c}, {0xf71, 0xf84}, {0xf86, 0xf97}, {0xf99, 0xfbc},
  {0xfc6, 0xfc6}, {0x1000, 0x1049}, {0x1050, 0x109d}, {0x10a0, 0x10c5}, {0x10c7, 0x10c7}, {0x10cd, 0x10cd}, {0x10d0, 0x10fa}, {0x10fc, 0x1248},
  {0x124a, 0x124d}, {0x1250, 0x1256}, {0x1258, 0x1258}, {0x125a, 0x125d}, {0x1260, 0x1288}, {0x128a, 0x128d}, {0x1290, 0x12b0}, {0x12b2, 0x12b5},
  {0x12b8, 0x12be}, {0x12c0, 0x12c0}, {0x12c2, 0x12c5}, {0x12c8, 0x12d6}, {0x12d8, 0x1310}, {0x1312, 0x1315}, {0x1318, 0x135a}, {0x135d, 0x135f},
  {0x1369, 0x1371}, {0x1380, 0x138f}, {0x13a0, 0x13f5}, {0x13f8, 0x13fd}, {0x1401, 0x166c}, {0x166f, 0x167f}, {0x1681, 0x169a}, {0x16a0, 0x16ea},
  {0x16ee, 0x16f8}, {0x1700, 0x1715}, {0x171f, 0x1734}, {0x1740, 0x1753}, {0x1760, 0x176c}, {0x176e, 0x1770}, {0x1772, 0x1773}, {0x1780, 0x17d3},
  {0x17d7, 0x17d7}, {0x17dc, 0x17dd}, {0x17e0, 0x17e9}, {0x180b, 0x180d}, {0x180f, 0x1819}, {0x1820, 0x1878}, {0x1880, 0x18aa}, {0x18b0, 0x18f5},
  {0x1900, 0x191e}, {0x1920, 0x192b}, {0x1930, 0x193b}, {0x1946, 0x196d}, {0x1970, 0x1974}, {0x1980, 0x19ab}, {0x19b0, 0x19c9}, {0x19d0, 0x19da},
  {0x1a00, 0x1a1b}, {0x1a20, 0x1a5e}, {0x1a60, 0x1a7c}, {0x1a7f, 0x1a89}, {0x1a90, 0x1a99}, {0x1aa7, 0x1aa7}, {0x1ab0, 0x1abd}, {0x1abf, 0x1ace},
  {0x1b00, 0x1b4c}, {0x1b50, 0x1b59}, {0x1b6b, 0x1b73}, {0x1b80, 0x1bf3}, {0x1c00, 0x1c37}, {0x1c40, 0x1c49}, {0x1c4d, 0x1c7d}, {0x1c80, 0x1c88},
  {0x1c90, 0x1cba}, {0x1cbd, 0x1cbf}, {0x1cd0, 0x1cd2}, {0x1cd4, 0x1cfa}, {0x1d00, 0x1f15}, {0x1f18, 0x1f1d}, {0x1f20, 0x1f45}, {0x1f48, 0x1f4d},
  {0x1f50, 0x1f57}, {0x1f59, 0x1f59}, {0x1f5b, 0x1f5b}, {0x1f5d, 0x1f5d}, {0x1f5f, 0x1f7d}, {0x1f80, 0x1fb4}, {0x1fb6, 0x1fbc}, {0x1fbe, 0x1fbe},
  {0x1fc2, 0x1fc4}, {0x1fc6, 0x1fcc}, {0x1fd0, 0x1fd3}, {0x1fd6, 0x1fdb}, {0x1fe0, 0x1fec}, {0x1ff2, 0x1ff4}, {0x1ff6, 0x1ffc}, {0x200d, 0x200d},
  {0x203c, 0x203c}, {0x203f, 0x2040}, {0x2049, 0x2049}, {0x2054, 0x2054}, {0x2071, 0x2071}, {0x207f, 0x207f}, {0x2090, 0x209c}, {0x20d0, 0x20dc},
  {0x20e1, 0x20e1}, {0x20e5, 0x20f0}, {0x2102, 0x2102}, {0x2107, 0x2107}, {0x210a, 0x2113}, {0x2115, 0x2115}, {0x2118, 0x211d}, {0x2122, 0x2122},
  {0x2124, 0x2124}, {0x2126, 0x2126}, {0x2128, 0x2128}, {0x212a, 0x2139}, {0x213c, 0x213f}, {0x2145, 0x2149}, {0x214e, 0x214e}, {0x2160, 0x2188},
  {0x2194, 0x2199}, {0x21a9, 0x21aa}, {0x231a, 0x231b}, {0x2328, 0x2328}, {0x23cf, 0x23cf}, {0x23e9, 0x23f3}, {0x23f8, 0x23fa}, {0x24c2, 0x24c2},
  {0x25aa, 0x25ab}, {0x25b6, 0x25b6}, {0x25c0, 0x25c0}, {0x25fb, 0x25fe}, {0x2600, 0x2604}, {0x260e, 0x260e}, {0x2611, 0x2611}, {0x2614, 0x2615},
  {0x2618, 0x2618}, {0x261d, 0x261d}, {0x2620, 0x2620}, {0x2622, 0x2623}, {0x2626, 0x2626}, {0x262a, 0x262a}, {0x262e, 0x262f}, {0x2638, 0x263a},
  {0x2640, 0x2640}, {0x2642, 0x2642}, {0x2648, 0x2653}, {0x265f, 0x2660}, {0x2663, 0x2663}, {0x2665, 0x2666}, {0x2668, 0x2668}, {0x267b, 0x267b},
  {0x267e, 0x267f}, {0x2692, 0x2697}, {0x2699, 0x2699}, {0x269b, 0x269c}, {0x26a0, 0x26a1}, {0x26a7, 0x26a7}, {0x26aa, 0x26ab}, {0x26b0, 0x26b1},
  {0x26bd, 0x26be}, {0x26c4, 0x26c5}, {0x26c8, 0x26c8}, {0x26ce, 0x26cf}, {0x26d1, 0x26d1}, {0x26d3, 0x26d4}, {0x26e9, 0x26ea}, {0x26f0, 0x26f5},
  {0x26f7, 0x26fa}, {0x26fd, 0x26fd}, {0x2702, 0x2702}, {0x2705, 0x2705}, {0x2708, 0x270d}, {0x270f, 0x270f}, {0x2712, 0x2712}, {0x2714, 0x2714},
  {0x2716, 0x2716}, {0x271d, 0x271d}, {0x2721, 0x2721}, {0x2728, 0x2728}, {0x2733, 0x2734}, {0x2744, 0x2744}, {0x2747, 0x2747}, {0x274c, 0x274c},
  {0x274e, 0x274e}, {0x2753, 0x2755}, {0x2757, 0x2757}, {0x2763, 0x2764}, {0x2795, 0x2797}, {0x27a1, 0x27a1}, {0x27b0, 0x27b0}, {0x27bf, 0x27bf},
  {0x2934, 0x2935}, {0x2b05, 0x2b07}, {0x2b1b, 0x2b1c}, {0x2b50, 0x2b50}, {0x2b55, 0x2b55}, {0x2c00, 0x2ce4}, {0x2ceb, 0x2cf3}, {0x2d00, 0x2d25},
  {0x2d27, 0x2d27}, {0x2d2d, 0x2d2d}, {0x2d30, 0x2d67}, {0x2d6f, 0x2d6f}, {0x2d7f, 0x2d96}, {0x2da0, 0x2da6}, {0x2da8, 0x2dae}, {0x2db0, 0x2db6},
  {0x2db8, 0x2dbe}, {0x2dc0, 0x2dc6}, {0x2dc8, 0x2dce}, {0x2dd0, 0x2dd6}, {0x2dd8, 0x2dde}, {0x2de0, 0x2dff}, {0x3005, 0x3007}, {0x3021, 0x3035},
  {0x3038, 0x303d}, {0x3041, 0x3096}, {0x3099, 0x309a}, {0x309d, 0x309f}, {0x30a1, 0x30fa}, {0x30fc, 0x30ff}, {0x3105, 0x312f}, {0x3131, 0x318e},
  {0x31a0, 0x31bf}, {0x31f0, 0x31ff}, {0x3297, 0x3297}, {0x3299, 0x3299}, {0x3400, 0x4dbf}, {0x4e00, 0xa48c}, {0xa4d0, 0xa4fd}, {0xa500, 0xa60c},
  {0xa610, 0xa62b}, {0xa640, 0xa66f}, {0xa674, 0xa67d}, {0xa67f, 0xa6f1}, {0xa717, 0xa71f}, {0xa722, 0xa788}, {0xa78b, 0xa7ca}, {0xa7d0, 0xa7d1},
  {0xa7d3, 0xa7d3}, {0xa7d5, 0xa7d9}, {0xa7f2, 0xa827}, {0xa82c, 0xa82c}, {0xa840, 0xa873}, {0xa880, 0xa8c5}, {0xa8d0, 0xa8d9}, {0xa8e0, 0xa8f7},
  {0xa8fb, 0xa8fb}, {0xa8fd, 0xa92d}, {0xa930, 0xa953}, {0xa960, 0xa97c}, {0xa980, 0xa9c0}, {0xa9cf, 0xa9d9}, {0xa9e0, 0xa9fe}, {0xaa00, 0xaa36},
  {0xaa40, 0xaa4d}, {0xaa50, 0xaa59}, {0xaa60, 0xaa76}, {0xaa7a, 0xaac2}, {0xaadb, 0xaadd}, {0xaae0, 0xaaef}, {0xaaf2, 0xaaf6}, {0xab01, 0xab06},
  {0xab09, 0xab0e}, {0xab11, 0xab16}, {0xab20, 0xab26}, {0xab28, 0xab2e}, {0xab30, 0xab5a}, {0xab5c, 0xab69}, {0xab70, 0xabea}, {0xabec, 0xabed},
  {0xabf0, 0xabf9}, {0xac00, 0xd7a3}, {0xd7b0, 0xd7c6}, {0xd7cb, 0xd7fb}, {0xf900, 0xfa6d}, {0xfa70, 0xfad9}, {0xfb00, 0xfb06}, {0xfb13, 0xfb17},
  {0xfb1d, 0xfb28}, {0xfb2a, 0xfb36}, {0xfb38, 0xfb3c}, {0xfb3e, 0xfb3e}, {0xfb40, 0xfb41}, {0xfb43, 0xfb44}, {0xfb46, 0xfbb1}, {0xfbd3, 0xfc5d},
  {0xfc64, 0xfd3d}, {0xfd50, 0xfd8f}, {0xfd92, 0xfdc7}, {0xfdf0, 0xfdf9}, {0xfe00, 0xfe0f}, {0xfe20, 0xfe2f}, {0xfe33, 0xfe34}, {0xfe4d, 0xfe4f},
  {0xfe71, 0xfe71}, {0xfe73, 0xfe73}, {0xfe77, 0xfe77}, {0xfe79, 0xfe79}, {0xfe7b, 0xfe7b}, {0xfe7d, 0xfe7d}, {0xfe7f, 0xfefc}, {0xff10, 0xff19},
  {0xff21, 0xff3a}, {0xff3f, 0xff3f}, {0xff41, 0xff5a}, {0xff66, 0xffbe}, {0xffc2, 0xffc7}, {0xffca, 0xffcf}, {0xffd2, 0xffd7}, {0xffda, 0xffdc},
  {0x10000, 0x1000b}, {0x1000d, 0x10026}, {0x10028, 0x1003a}, {0x1003c, 0x1003d}, {0x1003f, 0x1004d}, {0x10050, 0x1005d}, {0x10080, 0x100fa}, {0x10140, 0x10174},
  {0x101fd, 0x101fd}, {0x10280, 0x1029c}, {0x102a0, 0x102d0}, {0x102e0, 0x102e0}, {0x10300, 0x1031f}, {0x1032d, 0x1034a}, {0x10350, 0x1037a}, {0x10380, 0x1039d},
  {0x103a0, 0x103c3}, {0x103c8, 0x103cf}, {0x103d1, 0x103d5}, {0x10400, 0x1049d}, {0x104a0, 0x104a9}, {0x104b0, 0x104d3}, {0x104d8, 0x104fb}, {0x10500, 0x10527},
  {0x10530, 0x10563}, {0x10570, 0x1057a}, {0x1057c, 0x1058a}, {0x1058c, 0x10592}, {0x10594, 0x10595}, {0x10597, 0x105a1}, {0x105a3, 0x105b1}, {0x105b3, 0x105b9},
  {0x105bb, 0x105bc}, {0x10600, 0x10736}, {0x10740, 0x10755}, {0x10760, 0x10767}, {0x10780, 0x10785}, {0x10787, 0x107b0}, {0x107b2, 0x107ba}, {0x10800, 0x10805},
  {0x10808, 0x10808}, {0x1080a, 0x10835}, {0x10837, 0x10838}, {0x1083c, 0x1083c}, {0x1083f, 0x10855}, {0x10860, 0x10876}, {0x10880, 0x1089e}, {0x108e0, 0x108f2},
  {0x108f4, 0x108f5}, {0x10900, 0x10915}, {0x10920, 0x10939}, {0x10980, 0x109b7}, {0x109be, 0x109bf}, {0x10a00, 0x10a03}, {0x10a05, 0x10a06}, {0x10a0c, 0x10a13},
  {0x10a15, 0x10a17}, {0x10a19, 0x10a35}, {0x10a38, 0x10a3a}, {0x10a3f, 0x10a3f}, {0x10a60, 0x10a7c}, {0x10a80, 0x10a9c}, {0x10ac0, 0x10ac7}, {0x10ac9, 0x10ae6},
  {0x10b00, 0x10b35}, {0x10b40, 0x10b55}, {0x10b60, 0x10b72}, {0x10b80, 0x10b91}, {0x10c00, 0x10c48}, {0x10c80, 0x10cb2}, {0x10cc0, 0x10cf2}, {0x10d00, 0x10d27},
  {0x10d30, 0x10d39}, {0x10e80, 0x10ea9}, {0x10eab, 0x10eac}, {0x10eb0, 0x10eb1}, {0x10f00, 0x10f1c}, {0x10f27, 0x10f27}, {0x10f30, 0x10f50}, {0x10f70, 0x10f85},
  {0x10fb0, 0x10fc4}, {0x10fe0, 0x10ff6}, {0x11000, 0x11046}, {0x11066, 0x11075}, {0x1107f, 0x110ba}, {0x110c2, 0x110c2}, {0x110d0, 0x110e8}, {0x110f0, 0x110f9},
  {0x11100, 0x11134}, {0x11136, 0x1113f}, {0x11144, 0x11147}, {0x11150, 0x11173}, {0x11176, 0x11176}, {0x11180, 0x111c4}, {0x111c9, 0x111cc}, {0x111ce, 0x111da},
  {0x111dc, 0x111dc}, {0x11200, 0x11211}, {0x11213, 0x11237}, {0x1123e, 0x1123e}, {0x11280, 0x11286}, {0x11288, 0x11288}, {0x1128a, 0x1128d}, {0x1128f, 0x1129d},
  {0x1129f, 0x112a8}, {0x112b0, 0x112ea}, {0x112f0, 0x112f9}, {0x11300, 0x11303}, {0x11305, 0x1130c}, {0x1130f, 0x11310}, {0x11313, 0x11328}, {0x1132a, 0x11330},
  {0x11332, 0x11333}, {0x11335, 0x11339}, {0x1133b, 0x11344}, {0x11347, 0x11348}, {0x1134b, 0x1134d}, {0x11350, 0x11350}, {0x11357, 0x11357}, {0x1135d, 0x11363},
  {0x11366, 0x1136c}, {0x11370, 0x11374}, {0x11400, 0x1144a}, {0x11450, 0x11459}, {0x1145e, 0x11461}, {0x11480, 0x114c5}, {0x114c7, 0x114c7}, {0x114d0, 0x114d9},
  {0x11580, 0x115b5}, {0x115b8, 0x115c0}, {0x115d8, 0x115dd}, {0x11600, 0x11640}, {0x11644, 0x11644}, {0x11650, 0x11659}, {0x11680, 0x116b8}, {0x116c0, 0x116c9},
  {0x11700, 0x1171a}, {0x1171d, 0x1172b}, {0x11730, 0x11739}, {0x11740, 0x11746}, {0x11800, 0x1183a}, {0x118a0, 0x118e9}, {0x118ff, 0x11906}, {0x11909, 0x11909},
  {0x1190c, 0x11913}, {0x11915, 0x11916}, {0x11918, 0x11935}, {0x11937, 0x11938}, {0x1193b, 0x11943}, {0x11950, 0x11959}, {0x119a0, 0x119a7}, {0x119aa, 0x119d7},
  {0x119da, 0x119e1}, {0x119e3, 0x119e4}, {0x11a00, 0x11a3e}, {0x11a47, 0x11a47}, {0x11a50, 0x11a99}, {0x11a9d, 0x11a9d}, {0x11ab0, 0x11af8}, {0x11c00, 0x11c08},
  {0x11c0a, 0x11c36}, {0x11c38, 0x11c40}, {0x11c50, 0x11c59}, {0x11c72, 0x11c8f}, {0x11c92, 0x11ca7}, {0x11ca9, 0x11cb6}, {0x11d00, 0x11d06}, {0x11d08, 0x11d09},
  {0x11d0b, 0x11d36}, {0x11d3a, 0x11d3a}, {0x11d3c, 0x11d3d}, {0x11d3f, 0x11d47}, {0x11d50, 0x11d59}, {0x11d60, 0x11d65}, {0x11d67, 0x11d68}, {0x11d6a, 0x11d8e},
  {0x11d90, 0x11d91}, {0x11d93, 0x11d98}, {0x11da0, 0x11da9}, {0x11ee0, 0x11ef6}, {0x11fb0, 0x11fb0}, {0x12000, 0x12399}, {0x12400, 0x1246e}, {0x12480, 0x12543},
  {0x12f90, 0x12ff0}, {0x13000, 0x1342e}, {0x14400, 0x14646}, {0x16800, 0x16a38}, {0x16a40, 0x16a5e}, {0x16a60, 0x16a69}, {0x16a70, 0x16abe}, {0x16ac0, 0x16ac9},
  {0x16ad0, 0x16aed}, {0x16af0, 0x16af4}, {0x16b00, 0x16b36}, {0x16b40, 0x16b43}, {0x16b50, 0x16b59}, {0x16b63, 0x16b77}, {0x16b7d, 0x16b8f}, {0x16e40, 0x16e7f},
  {0x16f00, 0x16f4a}, {0x16f4f, 0x16f87}, {0x16f8f, 0x16f9f}, {0x16fe0, 0x16fe1}, {0x16fe3, 0x16fe4}, {0x16ff0, 0x16ff1}, {0x17000, 0x187f7}, {0x18800, 0x18cd5},
  {0x18d00, 0x18d08}, {0x1aff0, 0x1aff3}, {0x1aff5, 0x1affb}, {0x1affd, 0x1affe}, {0x1b000, 0x1b122}, {0x1b150, 0x1b152}, {0x1b164, 0x1b167}, {0x1b170, 0x1b2fb},
  {0x1bc00, 0x1bc6a}, {0x1bc70, 0x1bc7c}, {0x1bc80, 0x1bc88}, {0x1bc90, 0x1bc99}, {0x1bc9d, 0x1bc9e}, {0x1cf00, 0x1cf2d}, {0x1cf30, 0x1cf46}, {0x1d165, 0x1d169},
  {0x1d16d, 0x1d172}, {0x1d17b, 0x1d182}, {0x1d185, 0x1d18b}, {0x1d1aa, 0x1d1ad}, {0x1d242, 0x1d244}, {0x1d400, 0x1d454}, {0x1d456, 0x1d49c}, {0x1d49e, 0x1d49f},
  {0x1d4a2, 0x1d4a2}, {0x1d4a5, 0x1d4a6}, {0x1d4a9, 0x1d4ac}, {0x1d4ae, 0x1d4b9}, {0x1d4bb, 0x1d4bb}, {0x1d4bd, 0x1d4c3}, {0x1d4c5, 0x1d505}, {0x1d507, 0x1d50a},
  {0x1d50d, 0x1d514}, {0x1d516, 0x1d51c}, {0x1d51e, 0x1d539}, {0x1d53b, 0x1d53e}, {0x1d540, 0x1d544}, {0x1d546, 0x1d546}, {0x1d54a, 0x1d550}, {0x1d552, 0x1d6a5},
  {0x1d6a8, 0x1d6c0}, {0x1d6c2, 0x1d6da}, {0x1d6dc, 0x1d6fa}, {0x1d6fc, 0x1d714}, {0x1d716, 0x1d734}, {0x1d736, 0x1d74e}, {0x1d750, 0x1d76e}, {0x1d770, 0x1d788},
  {0x1d78a, 0x1d7a8}, {0x1d7aa, 0x1d7c2}, {0x1d7c4, 0x1d7cb}, {0x1d7ce, 0x1d7ff}, {0x1da00, 0x1da36}, {0x1da3b, 0x1da6c}, {0x1da75, 0x1da75}, {0x1da84, 0x1da84},
  {0x1da9b, 0x1da9f}, {0x1daa1, 0x1daaf}, {0x1df00, 0x1df1e}, {0x1e000, 0x1e006}, {0x1e008, 0x1e018}, {0x1e01b, 0x1e021}, {0x1e023, 0x1e024}, {0x1e026, 0x1e02a},
  {0x1e100, 0x1e12c}, {0x1e130, 0x1e13d}, {0x1e140, 0x1e149}, {0x1e14e, 0x1e14e}, {0x1e290, 0x1e2ae}, {0x1e2c0, 0x1e2f9}, {0x1e7e0, 0x1e7e6}, {0x1e7e8, 0x1e7eb},
  {0x1e7ed, 0x1e7ee}, {0x1e7f0, 0x1e7fe}, {0x1e800, 0x1e8c4}, {0x1e8d0, 0x1e8d6}, {0x1e900, 0x1e94b}, {0x1e950, 0x1e959}, {0x1ee00, 0x1ee03}, {0x1ee05, 0x1ee1f},
  {0x1ee21, 0x1ee22}, {0x1ee24, 0x1ee24}, {0x1ee27, 0x1ee27}, {0x1ee29, 0x1ee32}, {0x1ee34, 0x1ee37}, {0x1ee39, 0x1ee39}, {0x1ee3b, 0x1ee3b}, {0x1ee42, 0x1ee42},
  {0x1ee47, 0x1ee47}, {0x1ee49, 0x1ee49}, {0x1ee4b, 0x1ee4b}, {0x1ee4d, 0x1ee4f}, {0x1ee51, 0x1ee52}, {0x1ee54, 0x1ee54}, {0x1ee57, 0x1ee57}, {0x1ee59, 0x1ee59},
  {0x1ee5b, 0x1ee5b}, {0x1ee5d, 0x1ee5d}, {0x1ee5f, 0x1ee5f}, {0x1ee61, 0x1ee62}, {0x1ee64, 0x1ee64}, {0x1ee67, 0x1ee6a}, {0x1ee6c, 0x1ee72}, {0x1ee74, 0x1ee77},
  {0x1ee79, 0x1ee7c}, {0x1ee7e, 0x1ee7e}, {0x1ee80, 0x1ee89}, {0x1ee8b, 0x1ee9b}, {0x1eea1, 0x1eea3}, {0x1eea5, 0x1eea9}, {0x1eeab, 0x1eebb}, {0x1f004, 0x1f004},
  {0x1f0cf, 0x1f0cf}, {0x1f170, 0x1f171}, {0x1f17e, 0x1f17f}, {0x1f18e, 0x1f18e}, {0x1f191, 0x1f19a}, {0x1f1e6, 0x1f1ff}, {0x1f201, 0x1f202}, {0x1f21a, 0x1f21a},
  {0x1f22f, 0x1f22f}, {0x1f232, 0x1f23a}, {0x1f250, 0x1f251}, {0x1f300, 0x1f321}, {0x1f324, 0x1f393}, {0x1f396, 0x1f397}, {0x1f399, 0x1f39b}, {0x1f39e, 0x1f3f0},
  {0x1f3f3, 0x1f3f5}, {0x1f3f7, 0x1f4fd}, {0x1f4ff, 0x1f53d}, {0x1f549, 0x1f54e}, {0x1f550, 0x1f567}, {0x1f56f, 0x1f570}, {0x1f573, 0x1f57a}, {0x1f587, 0x1f587},
  {0x1f58a, 0x1f58d}, {0x1f590, 0x1f590}, {0x1f595, 0x1f596}, {0x1f5a4, 0x1f5a5}, {0x1f5a8, 0x1f5a8}, {0x1f5b1, 0x1f5b2}, {0x1f5bc, 0x1f5bc}, {0x1f5c2, 0x1f5c4},
  {0x1f5d1, 0x1f5d3}, {0x1f5dc, 0x1f5de}, {0x1f5e1, 0x1f5e1}, {0x1f5e3, 0x1f5e3}, {0x1f5e8, 0x1f5e8}, {0x1f5ef, 0x1f5ef}, {0x1f5f3, 0x1f5f3}, {0x1f5fa, 0x1f64f},
  {0x1f680, 0x1f6c5}, {0x1f6cb, 0x1f6d2}, {0x1f6d5, 0x1f6d7}, {0x1f6dd, 0x1f6e5}, {0x1f6e9, 0x1f6e9}, {0x1f6eb, 0x1f6ec}, {0x1f6f0, 0x1f6f0}, {0x1f6f3, 0x1f6fc},
  {0x1f7e0, 0x1f7eb}, {0x1f7f0, 0x1f7f0}, {0x1f90c, 0x1f93a}, {0x1f93c, 0x1f945}, {0x1f947, 0x1f9ff}, {0x1fa70, 0x1fa74}, {0x1fa78, 0x1fa7c}, {0x1fa80, 0x1fa86},
  {0x1fa90, 0x1faac}, {0x1fab0, 0x1faba}, {0x1fac0, 0x1fac5}, {0x1fad0, 0x1fad9}, {0x1fae0, 0x1fae7}, {0x1faf0, 0x1faf6}, {0x1fbf0, 0x1fbf9}, {0x20000, 0x2a6df},
  {0x2a700, 0x2b738}, {0x2b740, 0x2b81d}, {0x2b820, 0x2cea1}, {0x2ceb0, 0x2ebe0}, {0x2f800, 0x2fa1d}, {0x30000, 0x3134a}, {0xe0100, 0xe01ef},
};

static TSCharacterRange aux_sym_simple_identifier_token1_character_set_3[] = {
  {'#', '#'}, {'*', '*'}, {'0', '9'}, {'A', 'Z'}, {'_', '_'}, {'a', 'z'}, {0xa9, 0xaa}, {0xae, 0xae},
  {0xb5, 0xb5}, {0xb7, 0xb7}, {0xba, 0xba}, {0xc0, 0xd6}, {0xd8, 0xf6}, {0xf8, 0x2c1}, {0x2c6, 0x2d1}, {0x2e0, 0x2e4},
  {0x2ec, 0x2ec}, {0x2ee, 0x2ee}, {0x300, 0x374}, {0x376, 0x377}, {0x37b, 0x37d}, {0x37f, 0x37f}, {0x386, 0x38a}, {0x38c, 0x38c},
  {0x38e, 0x3a1}, {0x3a3, 0x3f5}, {0x3f7, 0x481}, {0x483, 0x487}, {0x48a, 0x52f}, {0x531, 0x556}, {0x559, 0x559}, {0x560, 0x588},
  {0x591, 0x5bd}, {0x5bf, 0x5bf}, {0x5c1, 0x5c2}, {0x5c4, 0x5c5}, {0x5c7, 0x5c7}, {0x5d0, 0x5ea}, {0x5ef, 0x5f2}, {0x610, 0x61a},
  {0x620, 0x669}, {0x66e, 0x6d3}, {0x6d5, 0x6dc}, {0x6df, 0x6e8}, {0x6ea, 0x6fc}, {0x6ff, 0x6ff}, {0x710, 0x74a}, {0x74d, 0x7b1},
  {0x7c0, 0x7f5}, {0x7fa, 0x7fa}, {0x7fd, 0x7fd}, {0x800, 0x82d}, {0x840, 0x85b}, {0x860, 0x86a}, {0x870, 0x887}, {0x889, 0x88e},
  {0x898, 0x8e1}, {0x8e3, 0x963}, {0x966, 0x96f}, {0x971, 0x983}, {0x985, 0x98c}, {0x98f, 0x990}, {0x993, 0x9a8}, {0x9aa, 0x9b0},
  {0x9b2, 0x9b2}, {0x9b6, 0x9b9}, {0x9bc, 0x9c4}, {0x9c7, 0x9c8}, {0x9cb, 0x9ce}, {0x9d7, 0x9d7}, {0x9dc, 0x9dd}, {0x9df, 0x9e3},
  {0x9e6, 0x9f1}, {0x9fc, 0x9fc}, {0x9fe, 0x9fe}, {0xa01, 0xa03}, {0xa05, 0xa0a}, {0xa0f, 0xa10}, {0xa13, 0xa28}, {0xa2a, 0xa30},
  {0xa32, 0xa33}, {0xa35, 0xa36}, {0xa38, 0xa39}, {0xa3c, 0xa3c}, {0xa3e, 0xa42}, {0xa47, 0xa48}, {0xa4b, 0xa4d}, {0xa51, 0xa51},
  {0xa59, 0xa5c}, {0xa5e, 0xa5e}, {0xa66, 0xa75}, {0xa81, 0xa83}, {0xa85, 0xa8d}, {0xa8f, 0xa91}, {0xa93, 0xaa8}, {0xaaa, 0xab0},
  {0xab2, 0xab3}, {0xab5, 0xab9}, {0xabc, 0xac5}, {0xac7, 0xac9}, {0xacb, 0xacd}, {0xad0, 0xad0}, {0xae0, 0xae3}, {0xae6, 0xaef},
  {0xaf9, 0xaff}, {0xb01, 0xb03}, {0xb05, 0xb0c}, {0xb0f, 0xb10}, {0xb13, 0xb28}, {0xb2a, 0xb30}, {0xb32, 0xb33}, {0xb35, 0xb39},
  {0xb3c, 0xb44}, {0xb47, 0xb48}, {0xb4b, 0xb4d}, {0xb55, 0xb57}, {0xb5c, 0xb5d}, {0xb5f, 0xb63}, {0xb66, 0xb6f}, {0xb71, 0xb71},
  {0xb82, 0xb83}, {0xb85, 0xb8a}, {0xb8e, 0xb90}, {0xb92, 0xb95}, {0xb99, 0xb9a}, {0xb9c, 0xb9c}, {0xb9e, 0xb9f}, {0xba3, 0xba4},
  {0xba8, 0xbaa}, {0xbae, 0xbb9}, {0xbbe, 0xbc2}, {0xbc6, 0xbc8}, {0xbca, 0xbcd}, {0xbd0, 0xbd0}, {0xbd7, 0xbd7}, {0xbe6, 0xbef},
  {0xc00, 0xc0c}, {0xc0e, 0xc10}, {0xc12, 0xc28}, {0xc2a, 0xc39}, {0xc3c, 0xc44}, {0xc46, 0xc48}, {0xc4a, 0xc4d}, {0xc55, 0xc56},
  {0xc58, 0xc5a}, {0xc5d, 0xc5d}, {0xc60, 0xc63}, {0xc66, 0xc6f}, {0xc80, 0xc83}, {0xc85, 0xc8c}, {0xc8e, 0xc90}, {0xc92, 0xca8},
  {0xcaa, 0xcb3}, {0xcb5, 0xcb9}, {0xcbc, 0xcc4}, {0xcc6, 0xcc8}, {0xcca, 0xccd}, {0xcd5, 0xcd6}, {0xcdd, 0xcde}, {0xce0, 0xce3},
  {0xce6, 0xcef}, {0xcf1, 0xcf2}, {0xd00, 0xd0c}, {0xd0e, 0xd10}, {0xd12, 0xd44}, {0xd46, 0xd48}, {0xd4a, 0xd4e}, {0xd54, 0xd57},
  {0xd5f, 0xd63}, {0xd66, 0xd6f}, {0xd7a, 0xd7f}, {0xd81, 0xd83}, {0xd85, 0xd96}, {0xd9a, 0xdb1}, {0xdb3, 0xdbb}, {0xdbd, 0xdbd},
  {0xdc0, 0xdc6}, {0xdca, 0xdca}, {0xdcf, 0xdd4}, {0xdd6, 0xdd6}, {0xdd8, 0xddf}, {0xde6, 0xdef}, {0xdf2, 0xdf3}, {0xe01, 0xe3a},
  {0xe40, 0xe4e}, {0xe50, 0xe59}, {0xe81, 0xe82}, {0xe84, 0xe84}, {0xe86, 0xe8a}, {0xe8c, 0xea3}, {0xea5, 0xea5}, {0xea7, 0xebd},
  {0xec0, 0xec4}, {0xec6, 0xec6}, {0xec8, 0xecd}, {0xed0, 0xed9}, {0xedc, 0xedf}, {0xf00, 0xf00}, {0xf18, 0xf19}, {0xf20, 0xf29},
  {0xf35, 0xf35}, {0xf37, 0xf37}, {0xf39, 0xf39}, {0xf3e, 0xf47}, {0xf49, 0xf6c}, {0xf71, 0xf84}, {0xf86, 0xf97}, {0xf99, 0xfbc},
  {0xfc6, 0xfc6}, {0x1000, 0x1049}, {0x1050, 0x109d}, {0x10a0, 0x10c5}, {0x10c7, 0x10c7}, {0x10cd, 0x10cd}, {0x10d0, 0x10fa}, {0x10fc, 0x1248},
  {0x124a, 0x124d}, {0x1250, 0x1256}, {0x1258, 0x1258}, {0x125a, 0x125d}, {0x1260, 0x1288}, {0x128a, 0x128d}, {0x1290, 0x12b0}, {0x12b2, 0x12b5},
  {0x12b8, 0x12be}, {0x12c0, 0x12c0}, {0x12c2, 0x12c5}, {0x12c8, 0x12d6}, {0x12d8, 0x1310}, {0x1312, 0x1315}, {0x1318, 0x135a}, {0x135d, 0x135f},
  {0x1369, 0x1371}, {0x1380, 0x138f}, {0x13a0, 0x13f5}, {0x13f8, 0x13fd}, {0x1401, 0x166c}, {0x166f, 0x167f}, {0x1681, 0x169a}, {0x16a0, 0x16ea},
  {0x16ee, 0x16f8}, {0x1700, 0x1715}, {0x171f, 0x1734}, {0x1740, 0x1753}, {0x1760, 0x176c}, {0x176e, 0x1770}, {0x1772, 0x1773}, {0x1780, 0x17d3},
  {0x17d7, 0x17d7}, {0x17dc, 0x17dd}, {0x17e0, 0x17e9}, {0x180b, 0x180d}, {0x180f, 0x1819}, {0x1820, 0x1878}, {0x1880, 0x18aa}, {0x18b0, 0x18f5},
  {0x1900, 0x191e}, {0x1920, 0x192b}, {0x1930, 0x193b}, {0x1946, 0x196d}, {0x1970, 0x1974}, {0x1980, 0x19ab}, {0x19b0, 0x19c9}, {0x19d0, 0x19da},
  {0x1a00, 0x1a1b}, {0x1a20, 0x1a5e}, {0x1a60, 0x1a7c}, {0x1a7f, 0x1a89}, {0x1a90, 0x1a99}, {0x1aa7, 0x1aa7}, {0x1ab0, 0x1abd}, {0x1abf, 0x1ace},
  {0x1b00, 0x1b4c}, {0x1b50, 0x1b59}, {0x1b6b, 0x1b73}, {0x1b80, 0x1bf3}, {0x1c00, 0x1c37}, {0x1c40, 0x1c49}, {0x1c4d, 0x1c7d}, {0x1c80, 0x1c88},
  {0x1c90, 0x1cba}, {0x1cbd, 0x1cbf}, {0x1cd0, 0x1cd2}, {0x1cd4, 0x1cfa}, {0x1d00, 0x1f15}, {0x1f18, 0x1f1d}, {0x1f20, 0x1f45}, {0x1f48, 0x1f4d},
  {0x1f50, 0x1f57}, {0x1f59, 0x1f59}, {0x1f5b, 0x1f5b}, {0x1f5d, 0x1f5d}, {0x1f5f, 0x1f7d}, {0x1f80, 0x1fb4}, {0x1fb6, 0x1fbc}, {0x1fbe, 0x1fbe},
  {0x1fc2, 0x1fc4}, {0x1fc6, 0x1fcc}, {0x1fd0, 0x1fd3}, {0x1fd6, 0x1fdb}, {0x1fe0, 0x1fec}, {0x1ff2, 0x1ff4}, {0x1ff6, 0x1ffc}, {0x200d, 0x200d},
  {0x203c, 0x203c}, {0x203f, 0x2040}, {0x2049, 0x2049}, {0x2054, 0x2054}, {0x2071, 0x2071}, {0x207f, 0x207f}, {0x2090, 0x209c}, {0x20d0, 0x20dc},
  {0x20e1, 0x20e1}, {0x20e3, 0x20e3}, {0x20e5, 0x20f0}, {0x2102, 0x2102}, {0x2107, 0x2107}, {0x210a, 0x2113}, {0x2115, 0x2115}, {0x2118, 0x211d},
  {0x2122, 0x2122}, {0x2124, 0x2124}, {0x2126, 0x2126}, {0x2128, 0x2128}, {0x212a, 0x2139}, {0x213c, 0x213f}, {0x2145, 0x2149}, {0x214e, 0x214e},
  {0x2160, 0x2188}, {0x2194, 0x2199}, {0x21a9, 0x21aa}, {0x231a, 0x231b}, {0x2328, 0x2328}, {0x23cf, 0x23cf}, {0x23e9, 0x23f3}, {0x23f8, 0x23fa},
  {0x24c2, 0x24c2}, {0x25aa, 0x25ab}, {0x25b6, 0x25b6}, {0x25c0, 0x25c0}, {0x25fb, 0x25fe}, {0x2600, 0x2604}, {0x260e, 0x260e}, {0x2611, 0x2611},
  {0x2614, 0x2615}, {0x2618, 0x2618}, {0x261d, 0x261d}, {0x2620, 0x2620}, {0x2622, 0x2623}, {0x2626, 0x2626}, {0x262a, 0x262a}, {0x262e, 0x262f},
  {0x2638, 0x263a}, {0x2640, 0x2640}, {0x2642, 0x2642}, {0x2648, 0x2653}, {0x265f, 0x2660}, {0x2663, 0x2663}, {0x2665, 0x2666}, {0x2668, 0x2668},
  {0x267b, 0x267b}, {0x267e, 0x267f}, {0x2692, 0x2697}, {0x2699, 0x2699}, {0x269b, 0x269c}, {0x26a0, 0x26a1}, {0x26a7, 0x26a7}, {0x26aa, 0x26ab},
  {0x26b0, 0x26b1}, {0x26bd, 0x26be}, {0x26c4, 0x26c5}, {0x26c8, 0x26c8}, {0x26ce, 0x26cf}, {0x26d1, 0x26d1}, {0x26d3, 0x26d4}, {0x26e9, 0x26ea},
  {0x26f0, 0x26f5}, {0x26f7, 0x26fa}, {0x26fd, 0x26fd}, {0x2702, 0x2702}, {0x2705, 0x2705}, {0x2708, 0x270d}, {0x270f, 0x270f}, {0x2712, 0x2712},
  {0x2714, 0x2714}, {0x2716, 0x2716}, {0x271d, 0x271d}, {0x2721, 0x2721}, {0x2728, 0x2728}, {0x2733, 0x2734}, {0x2744, 0x2744}, {0x2747, 0x2747},
  {0x274c, 0x274c}, {0x274e, 0x274e}, {0x2753, 0x2755}, {0x2757, 0x2757}, {0x2763, 0x2764}, {0x2795, 0x2797}, {0x27a1, 0x27a1}, {0x27b0, 0x27b0},
  {0x27bf, 0x27bf}, {0x2934, 0x2935}, {0x2b05, 0x2b07}, {0x2b1b, 0x2b1c}, {0x2b50, 0x2b50}, {0x2b55, 0x2b55}, {0x2c00, 0x2ce4}, {0x2ceb, 0x2cf3},
  {0x2d00, 0x2d25}, {0x2d27, 0x2d27}, {0x2d2d, 0x2d2d}, {0x2d30, 0x2d67}, {0x2d6f, 0x2d6f}, {0x2d7f, 0x2d96}, {0x2da0, 0x2da6}, {0x2da8, 0x2dae},
  {0x2db0, 0x2db6}, {0x2db8, 0x2dbe}, {0x2dc0, 0x2dc6}, {0x2dc8, 0x2dce}, {0x2dd0, 0x2dd6}, {0x2dd8, 0x2dde}, {0x2de0, 0x2dff}, {0x3005, 0x3007},
  {0x3021, 0x3035}, {0x3038, 0x303d}, {0x3041, 0x3096}, {0x3099, 0x309a}, {0x309d, 0x309f}, {0x30a1, 0x30fa}, {0x30fc, 0x30ff}, {0x3105, 0x312f},
  {0x3131, 0x318e}, {0x31a0, 0x31bf}, {0x31f0, 0x31ff}, {0x3297, 0x3297}, {0x3299, 0x3299}, {0x3400, 0x4dbf}, {0x4e00, 0xa48c}, {0xa4d0, 0xa4fd},
  {0xa500, 0xa60c}, {0xa610, 0xa62b}, {0xa640, 0xa66f}, {0xa674, 0xa67d}, {0xa67f, 0xa6f1}, {0xa717, 0xa71f}, {0xa722, 0xa788}, {0xa78b, 0xa7ca},
  {0xa7d0, 0xa7d1}, {0xa7d3, 0xa7d3}, {0xa7d5, 0xa7d9}, {0xa7f2, 0xa827}, {0xa82c, 0xa82c}, {0xa840, 0xa873}, {0xa880, 0xa8c5}, {0xa8d0, 0xa8d9},
  {0xa8e0, 0xa8f7}, {0xa8fb, 0xa8fb}, {0xa8fd, 0xa92d}, {0xa930, 0xa953}, {0xa960, 0xa97c}, {0xa980, 0xa9c0}, {0xa9cf, 0xa9d9}, {0xa9e0, 0xa9fe},
  {0xaa00, 0xaa36}, {0xaa40, 0xaa4d}, {0xaa50, 0xaa59}, {0xaa60, 0xaa76}, {0xaa7a, 0xaac2}, {0xaadb, 0xaadd}, {0xaae0, 0xaaef}, {0xaaf2, 0xaaf6},
  {0xab01, 0xab06}, {0xab09, 0xab0e}, {0xab11, 0xab16}, {0xab20, 0xab26}, {0xab28, 0xab2e}, {0xab30, 0xab5a}, {0xab5c, 0xab69}, {0xab70, 0xabea},
  {0xabec, 0xabed}, {0xabf0, 0xabf9}, {0xac00, 0xd7a3}, {0xd7b0, 0xd7c6}, {0xd7cb, 0xd7fb}, {0xf900, 0xfa6d}, {0xfa70, 0xfad9}, {0xfb00, 0xfb06},
  {0xfb13, 0xfb17}, {0xfb1d, 0xfb28}, {0xfb2a, 0xfb36}, {0xfb38, 0xfb3c}, {0xfb3e, 0xfb3e}, {0xfb40, 0xfb41}, {0xfb43, 0xfb44}, {0xfb46, 0xfbb1},
  {0xfbd3, 0xfc5d}, {0xfc64, 0xfd3d}, {0xfd50, 0xfd8f}, {0xfd92, 0xfdc7}, {0xfdf0, 0xfdf9}, {0xfe00, 0xfe0f}, {0xfe20, 0xfe2f}, {0xfe33, 0xfe34},
  {0xfe4d, 0xfe4f}, {0xfe71, 0xfe71}, {0xfe73, 0xfe73}, {0xfe77, 0xfe77}, {0xfe79, 0xfe79}, {0xfe7b, 0xfe7b}, {0xfe7d, 0xfe7d}, {0xfe7f, 0xfefc},
  {0xff10, 0xff19}, {0xff21, 0xff3a}, {0xff3f, 0xff3f}, {0xff41, 0xff5a}, {0xff66, 0xffbe}, {0xffc2, 0xffc7}, {0xffca, 0xffcf}, {0xffd2, 0xffd7},
  {0xffda, 0xffdc}, {0x10000, 0x1000b}, {0x1000d, 0x10026}, {0x10028, 0x1003a}, {0x1003c, 0x1003d}, {0x1003f, 0x1004d}, {0x10050, 0x1005d}, {0x10080, 0x100fa},
  {0x10140, 0x10174}, {0x101fd, 0x101fd}, {0x10280, 0x1029c}, {0x102a0, 0x102d0}, {0x102e0, 0x102e0}, {0x10300, 0x1031f}, {0x1032d, 0x1034a}, {0x10350, 0x1037a},
  {0x10380, 0x1039d}, {0x103a0, 0x103c3}, {0x103c8, 0x103cf}, {0x103d1, 0x103d5}, {0x10400, 0x1049d}, {0x104a0, 0x104a9}, {0x104b0, 0x104d3}, {0x104d8, 0x104fb},
  {0x10500, 0x10527}, {0x10530, 0x10563}, {0x10570, 0x1057a}, {0x1057c, 0x1058a}, {0x1058c, 0x10592}, {0x10594, 0x10595}, {0x10597, 0x105a1}, {0x105a3, 0x105b1},
  {0x105b3, 0x105b9}, {0x105bb, 0x105bc}, {0x10600, 0x10736}, {0x10740, 0x10755}, {0x10760, 0x10767}, {0x10780, 0x10785}, {0x10787, 0x107b0}, {0x107b2, 0x107ba},
  {0x10800, 0x10805}, {0x10808, 0x10808}, {0x1080a, 0x10835}, {0x10837, 0x10838}, {0x1083c, 0x1083c}, {0x1083f, 0x10855}, {0x10860, 0x10876}, {0x10880, 0x1089e},
  {0x108e0, 0x108f2}, {0x108f4, 0x108f5}, {0x10900, 0x10915}, {0x10920, 0x10939}, {0x10980, 0x109b7}, {0x109be, 0x109bf}, {0x10a00, 0x10a03}, {0x10a05, 0x10a06},
  {0x10a0c, 0x10a13}, {0x10a15, 0x10a17}, {0x10a19, 0x10a35}, {0x10a38, 0x10a3a}, {0x10a3f, 0x10a3f}, {0x10a60, 0x10a7c}, {0x10a80, 0x10a9c}, {0x10ac0, 0x10ac7},
  {0x10ac9, 0x10ae6}, {0x10b00, 0x10b35}, {0x10b40, 0x10b55}, {0x10b60, 0x10b72}, {0x10b80, 0x10b91}, {0x10c00, 0x10c48}, {0x10c80, 0x10cb2}, {0x10cc0, 0x10cf2},
  {0x10d00, 0x10d27}, {0x10d30, 0x10d39}, {0x10e80, 0x10ea9}, {0x10eab, 0x10eac}, {0x10eb0, 0x10eb1}, {0x10f00, 0x10f1c}, {0x10f27, 0x10f27}, {0x10f30, 0x10f50},
  {0x10f70, 0x10f85}, {0x10fb0, 0x10fc4}, {0x10fe0, 0x10ff6}, {0x11000, 0x11046}, {0x11066, 0x11075}, {0x1107f, 0x110ba}, {0x110c2, 0x110c2}, {0x110d0, 0x110e8},
  {0x110f0, 0x110f9}, {0x11100, 0x11134}, {0x11136, 0x1113f}, {0x11144, 0x11147}, {0x11150, 0x11173}, {0x11176, 0x11176}, {0x11180, 0x111c4}, {0x111c9, 0x111cc},
  {0x111ce, 0x111da}, {0x111dc, 0x111dc}, {0x11200, 0x11211}, {0x11213, 0x11237}, {0x1123e, 0x1123e}, {0x11280, 0x11286}, {0x11288, 0x11288}, {0x1128a, 0x1128d},
  {0x1128f, 0x1129d}, {0x1129f, 0x112a8}, {0x112b0, 0x112ea}, {0x112f0, 0x112f9}, {0x11300, 0x11303}, {0x11305, 0x1130c}, {0x1130f, 0x11310}, {0x11313, 0x11328},
  {0x1132a, 0x11330}, {0x11332, 0x11333}, {0x11335, 0x11339}, {0x1133b, 0x11344}, {0x11347, 0x11348}, {0x1134b, 0x1134d}, {0x11350, 0x11350}, {0x11357, 0x11357},
  {0x1135d, 0x11363}, {0x11366, 0x1136c}, {0x11370, 0x11374}, {0x11400, 0x1144a}, {0x11450, 0x11459}, {0x1145e, 0x11461}, {0x11480, 0x114c5}, {0x114c7, 0x114c7},
  {0x114d0, 0x114d9}, {0x11580, 0x115b5}, {0x115b8, 0x115c0}, {0x115d8, 0x115dd}, {0x11600, 0x11640}, {0x11644, 0x11644}, {0x11650, 0x11659}, {0x11680, 0x116b8},
  {0x116c0, 0x116c9}, {0x11700, 0x1171a}, {0x1171d, 0x1172b}, {0x11730, 0x11739}, {0x11740, 0x11746}, {0x11800, 0x1183a}, {0x118a0, 0x118e9}, {0x118ff, 0x11906},
  {0x11909, 0x11909}, {0x1190c, 0x11913}, {0x11915, 0x11916}, {0x11918, 0x11935}, {0x11937, 0x11938}, {0x1193b, 0x11943}, {0x11950, 0x11959}, {0x119a0, 0x119a7},
  {0x119aa, 0x119d7}, {0x119da, 0x119e1}, {0x119e3, 0x119e4}, {0x11a00, 0x11a3e}, {0x11a47, 0x11a47}, {0x11a50, 0x11a99}, {0x11a9d, 0x11a9d}, {0x11ab0, 0x11af8},
  {0x11c00, 0x11c08}, {0x11c0a, 0x11c36}, {0x11c38, 0x11c40}, {0x11c50, 0x11c59}, {0x11c72, 0x11c8f}, {0x11c92, 0x11ca7}, {0x11ca9, 0x11cb6}, {0x11d00, 0x11d06},
  {0x11d08, 0x11d09}, {0x11d0b, 0x11d36}, {0x11d3a, 0x11d3a}, {0x11d3c, 0x11d3d}, {0x11d3f, 0x11d47}, {0x11d50, 0x11d59}, {0x11d60, 0x11d65}, {0x11d67, 0x11d68},
  {0x11d6a, 0x11d8e}, {0x11d90, 0x11d91}, {0x11d93, 0x11d98}, {0x11da0, 0x11da9}, {0x11ee0, 0x11ef6}, {0x11fb0, 0x11fb0}, {0x12000, 0x12399}, {0x12400, 0x1246e},
  {0x12480, 0x12543}, {0x12f90, 0x12ff0}, {0x13000, 0x1342e}, {0x14400, 0x14646}, {0x16800, 0x16a38}, {0x16a40, 0x16a5e}, {0x16a60, 0x16a69}, {0x16a70, 0x16abe},
  {0x16ac0, 0x16ac9}, {0x16ad0, 0x16aed}, {0x16af0, 0x16af4}, {0x16b00, 0x16b36}, {0x16b40, 0x16b43}, {0x16b50, 0x16b59}, {0x16b63, 0x16b77}, {0x16b7d, 0x16b8f},
  {0x16e40, 0x16e7f}, {0x16f00, 0x16f4a}, {0x16f4f, 0x16f87}, {0x16f8f, 0x16f9f}, {0x16fe0, 0x16fe1}, {0x16fe3, 0x16fe4}, {0x16ff0, 0x16ff1}, {0x17000, 0x187f7},
  {0x18800, 0x18cd5}, {0x18d00, 0x18d08}, {0x1aff0, 0x1aff3}, {0x1aff5, 0x1affb}, {0x1affd, 0x1affe}, {0x1b000, 0x1b122}, {0x1b150, 0x1b152}, {0x1b164, 0x1b167},
  {0x1b170, 0x1b2fb}, {0x1bc00, 0x1bc6a}, {0x1bc70, 0x1bc7c}, {0x1bc80, 0x1bc88}, {0x1bc90, 0x1bc99}, {0x1bc9d, 0x1bc9e}, {0x1cf00, 0x1cf2d}, {0x1cf30, 0x1cf46},
  {0x1d165, 0x1d169}, {0x1d16d, 0x1d172}, {0x1d17b, 0x1d182}, {0x1d185, 0x1d18b}, {0x1d1aa, 0x1d1ad}, {0x1d242, 0x1d244}, {0x1d400, 0x1d454}, {0x1d456, 0x1d49c},
  {0x1d49e, 0x1d49f}, {0x1d4a2, 0x1d4a2}, {0x1d4a5, 0x1d4a6}, {0x1d4a9, 0x1d4ac}, {0x1d4ae, 0x1d4b9}, {0x1d4bb, 0x1d4bb}, {0x1d4bd, 0x1d4c3}, {0x1d4c5, 0x1d505},
  {0x1d507, 0x1d50a}, {0x1d50d, 0x1d514}, {0x1d516, 0x1d51c}, {0x1d51e, 0x1d539}, {0x1d53b, 0x1d53e}, {0x1d540, 0x1d544}, {0x1d546, 0x1d546}, {0x1d54a, 0x1d550},
  {0x1d552, 0x1d6a5}, {0x1d6a8, 0x1d6c0}, {0x1d6c2, 0x1d6da}, {0x1d6dc, 0x1d6fa}, {0x1d6fc, 0x1d714}, {0x1d716, 0x1d734}, {0x1d736, 0x1d74e}, {0x1d750, 0x1d76e},
  {0x1d770, 0x1d788}, {0x1d78a, 0x1d7a8}, {0x1d7aa, 0x1d7c2}, {0x1d7c4, 0x1d7cb}, {0x1d7ce, 0x1d7ff}, {0x1da00, 0x1da36}, {0x1da3b, 0x1da6c}, {0x1da75, 0x1da75},
  {0x1da84, 0x1da84}, {0x1da9b, 0x1da9f}, {0x1daa1, 0x1daaf}, {0x1df00, 0x1df1e}, {0x1e000, 0x1e006}, {0x1e008, 0x1e018}, {0x1e01b, 0x1e021}, {0x1e023, 0x1e024},
  {0x1e026, 0x1e02a}, {0x1e100, 0x1e12c}, {0x1e130, 0x1e13d}, {0x1e140, 0x1e149}, {0x1e14e, 0x1e14e}, {0x1e290, 0x1e2ae}, {0x1e2c0, 0x1e2f9}, {0x1e7e0, 0x1e7e6},
  {0x1e7e8, 0x1e7eb}, {0x1e7ed, 0x1e7ee}, {0x1e7f0, 0x1e7fe}, {0x1e800, 0x1e8c4}, {0x1e8d0, 0x1e8d6}, {0x1e900, 0x1e94b}, {0x1e950, 0x1e959}, {0x1ee00, 0x1ee03},
  {0x1ee05, 0x1ee1f}, {0x1ee21, 0x1ee22}, {0x1ee24, 0x1ee24}, {0x1ee27, 0x1ee27}, {0x1ee29, 0x1ee32}, {0x1ee34, 0x1ee37}, {0x1ee39, 0x1ee39}, {0x1ee3b, 0x1ee3b},
  {0x1ee42, 0x1ee42}, {0x1ee47, 0x1ee47}, {0x1ee49, 0x1ee49}, {0x1ee4b, 0x1ee4b}, {0x1ee4d, 0x1ee4f}, {0x1ee51, 0x1ee52}, {0x1ee54, 0x1ee54}, {0x1ee57, 0x1ee57},
  {0x1ee59, 0x1ee59}, {0x1ee5b, 0x1ee5b}, {0x1ee5d, 0x1ee5d}, {0x1ee5f, 0x1ee5f}, {0x1ee61, 0x1ee62}, {0x1ee64, 0x1ee64}, {0x1ee67, 0x1ee6a}, {0x1ee6c, 0x1ee72},
  {0x1ee74, 0x1ee77}, {0x1ee79, 0x1ee7c}, {0x1ee7e, 0x1ee7e}, {0x1ee80, 0x1ee89}, {0x1ee8b, 0x1ee9b}, {0x1eea1, 0x1eea3}, {0x1eea5, 0x1eea9}, {0x1eeab, 0x1eebb},
  {0x1f004, 0x1f004}, {0x1f0cf, 0x1f0cf}, {0x1f170, 0x1f171}, {0x1f17e, 0x1f17f}, {0x1f18e, 0x1f18e}, {0x1f191, 0x1f19a}, {0x1f1e6, 0x1f1ff}, {0x1f201, 0x1f202},
  {0x1f21a, 0x1f21a}, {0x1f22f, 0x1f22f}, {0x1f232, 0x1f23a}, {0x1f250, 0x1f251}, {0x1f300, 0x1f321}, {0x1f324, 0x1f393}, {0x1f396, 0x1f397}, {0x1f399, 0x1f39b},
  {0x1f39e, 0x1f3f0}, {0x1f3f3, 0x1f3f5}, {0x1f3f7, 0x1f4fd}, {0x1f4ff, 0x1f53d}, {0x1f549, 0x1f54e}, {0x1f550, 0x1f567}, {0x1f56f, 0x1f570}, {0x1f573, 0x1f57a},
  {0x1f587, 0x1f587}, {0x1f58a, 0x1f58d}, {0x1f590, 0x1f590}, {0x1f595, 0x1f596}, {0x1f5a4, 0x1f5a5}, {0x1f5a8, 0x1f5a8}, {0x1f5b1, 0x1f5b2}, {0x1f5bc, 0x1f5bc},
  {0x1f5c2, 0x1f5c4}, {0x1f5d1, 0x1f5d3}, {0x1f5dc, 0x1f5de}, {0x1f5e1, 0x1f5e1}, {0x1f5e3, 0x1f5e3}, {0x1f5e8, 0x1f5e8}, {0x1f5ef, 0x1f5ef}, {0x1f5f3, 0x1f5f3},
  {0x1f5fa, 0x1f64f}, {0x1f680, 0x1f6c5}, {0x1f6cb, 0x1f6d2}, {0x1f6d5, 0x1f6d7}, {0x1f6dd, 0x1f6e5}, {0x1f6e9, 0x1f6e9}, {0x1f6eb, 0x1f6ec}, {0x1f6f0, 0x1f6f0},
  {0x1f6f3, 0x1f6fc}, {0x1f7e0, 0x1f7eb}, {0x1f7f0, 0x1f7f0}, {0x1f90c, 0x1f93a}, {0x1f93c, 0x1f945}, {0x1f947, 0x1f9ff}, {0x1fa70, 0x1fa74}, {0x1fa78, 0x1fa7c},
  {0x1fa80, 0x1fa86}, {0x1fa90, 0x1faac}, {0x1fab0, 0x1faba}, {0x1fac0, 0x1fac5}, {0x1fad0, 0x1fad9}, {0x1fae0, 0x1fae7}, {0x1faf0, 0x1faf6}, {0x1fbf0, 0x1fbf9},
  {0x20000, 0x2a6df}, {0x2a700, 0x2b738}, {0x2b740, 0x2b81d}, {0x2b820, 0x2cea1}, {0x2ceb0, 0x2ebe0}, {0x2f800, 0x2fa1d}, {0x30000, 0x3134a}, {0xe0100, 0xe01ef},
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(771);
      ADVANCE_MAP(
        '!', 1639,
        '"', 1585,
        '#', 39,
        '$', 748,
        '%', 1737,
        '&', 1657,
        '(', 1640,
        ')', 1628,
        '*', 1734,
        '+', 1731,
        ',', 1631,
        '-', 1732,
        '.', 1645,
        '/', 1735,
        '0', 1572,
        ':', 1637,
        ';', 1808,
        '<', 1669,
        '=', 173,
        '>', 1671,
        '?', 1652,
        '@', 1841,
        'P', 605,
        'T', 732,
        '[', 1641,
        '\\', 1623,
        ']', 1642,
        '^', 1743,
        '_', 1842,
        '`', 189,
        'a', 251,
        'b', 551,
        'c', 197,
        'd', 297,
        'e', 190,
        'f', 191,
        'g', 333,
        'i', 379,
        'l', 192,
        'm', 195,
        'n', 409,
        'o', 582,
        'p', 193,
        'r', 298,
        's', 299,
        't', 405,
        'u', 1625,
        'v', 201,
        'w', 335,
        'y', 414,
        '{', 1685,
        '|', 1741,
        '}', 1687,
        '~', 1740,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(754);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1573);
      END_STATE();
    case 1:
      if (lookahead == '\n') ADVANCE(1634);
      if (lookahead == '/') ADVANCE(161);
      if (lookahead != 0) ADVANCE(160);
      END_STATE();
    case 2:
      if (lookahead == '\n') ADVANCE(3);
      if (lookahead == '#') ADVANCE(10);
      if (lookahead == '/') ADVANCE(164);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(2);
      if (lookahead != 0) ADVANCE(33);
      END_STATE();
    case 3:
      if (lookahead == '\n') ADVANCE(3);
      if (lookahead == '#') ADVANCE(10);
      if (lookahead == '/') ADVANCE(146);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(2);
      if (lookahead != 0) ADVANCE(33);
      END_STATE();
    case 4:
      if (lookahead == '\n') ADVANCE(34);
      if (lookahead == '/') ADVANCE(753);
      if (lookahead == 'L') ADVANCE(23);
      if (lookahead != 0) ADVANCE(33);
      END_STATE();
    case 5:
      if (lookahead == '\n') ADVANCE(34);
      if (lookahead == '/') ADVANCE(753);
      if (lookahead == 'a') ADVANCE(31);
      if (lookahead != 0) ADVANCE(33);
      END_STATE();
    case 6:
      if (lookahead == '\n') ADVANCE(34);
      if (lookahead == '/') ADVANCE(753);
      if (lookahead == 'a') ADVANCE(26);
      if (lookahead != 0) ADVANCE(33);
      END_STATE();
    case 7:
      if (lookahead == '\n') ADVANCE(34);
      if (lookahead == '/') ADVANCE(753);
      if (lookahead == 'c') ADVANCE(5);
      if (lookahead != 0) ADVANCE(33);
      END_STATE();
    case 8:
      if (lookahead == '\n') ADVANCE(34);
      if (lookahead == '/') ADVANCE(753);
      if (lookahead == 'c') ADVANCE(12);
      if (lookahead != 0) ADVANCE(33);
      END_STATE();
    case 9:
      if (lookahead == '\n') ADVANCE(34);
      if (lookahead == '/') ADVANCE(753);
      if (lookahead == 'd') ADVANCE(15);
      if (lookahead != 0) ADVANCE(33);
      END_STATE();
    case 10:
      if (lookahead == '\n') ADVANCE(34);
      if (lookahead == '/') ADVANCE(753);
      if (lookahead == 'e') ADVANCE(18);
      if (lookahead == 'i') ADVANCE(13);
      if (lookahead == 's') ADVANCE(22);
      if (lookahead == 'w') ADVANCE(6);
      if (lookahead != 0) ADVANCE(33);
      END_STATE();
    case 11:
      if (lookahead == '\n') ADVANCE(34);
      if (lookahead == '/') ADVANCE(753);
      if (lookahead == 'e') ADVANCE(1919);
      if (lookahead != 0) ADVANCE(33);
      END_STATE();
    case 12:
      if (lookahead == '\n') ADVANCE(34);
      if (lookahead == '/') ADVANCE(753);
      if (lookahead == 'e') ADVANCE(4);
      if (lookahead != 0) ADVANCE(33);
      END_STATE();
    case 13:
      if (lookahead == '\n') ADVANCE(34);
      if (lookahead == '/') ADVANCE(753);
      if (lookahead == 'f') ADVANCE(1920);
      if (lookahead != 0) ADVANCE(33);
      END_STATE();
    case 14:
      if (lookahead == '\n') ADVANCE(34);
      if (lookahead == '/') ADVANCE(753);
      if (lookahead == 'g') ADVANCE(1926);
      if (lookahead != 0) ADVANCE(33);
      END_STATE();
    case 15:
      if (lookahead == '\n') ADVANCE(34);
      if (lookahead == '/') ADVANCE(753);
      if (lookahead == 'i') ADVANCE(13);
      if (lookahead != 0) ADVANCE(33);
      END_STATE();
    case 16:
      if (lookahead == '\n') ADVANCE(34);
      if (lookahead == '/') ADVANCE(753);
      if (lookahead == 'i') ADVANCE(19);
      if (lookahead != 0) ADVANCE(33);
      END_STATE();
    case 17:
      if (lookahead == '\n') ADVANCE(34);
      if (lookahead == '/') ADVANCE(753);
      if (lookahead == 'i') ADVANCE(24);
      if (lookahead != 0) ADVANCE(33);
      END_STATE();
    case 18:
      if (lookahead == '\n') ADVANCE(34);
      if (lookahead == '/') ADVANCE(753);
      if (lookahead == 'l') ADVANCE(30);
      if (lookahead == 'n') ADVANCE(9);
      if (lookahead == 'r') ADVANCE(29);
      if (lookahead != 0) ADVANCE(33);
      END_STATE();
    case 19:
      if (lookahead == '\n') ADVANCE(34);
      if (lookahead == '/') ADVANCE(753);
      if (lookahead == 'n') ADVANCE(14);
      if (lookahead != 0) ADVANCE(33);
      END_STATE();
    case 20:
      if (lookahead == '\n') ADVANCE(34);
      if (lookahead == '/') ADVANCE(753);
      if (lookahead == 'n') ADVANCE(1917);
      if (lookahead != 0) ADVANCE(33);
      END_STATE();
    case 21:
      if (lookahead == '\n') ADVANCE(34);
      if (lookahead == '/') ADVANCE(753);
      if (lookahead == 'n') ADVANCE(16);
      if (lookahead != 0) ADVANCE(33);
      END_STATE();
    case 22:
      if (lookahead == '\n') ADVANCE(34);
      if (lookahead == '/') ADVANCE(753);
      if (lookahead == 'o') ADVANCE(32);
      if (lookahead != 0) ADVANCE(33);
      END_STATE();
    case 23:
      if (lookahead == '\n') ADVANCE(34);
      if (lookahead == '/') ADVANCE(753);
      if (lookahead == 'o') ADVANCE(7);
      if (lookahead != 0) ADVANCE(33);
      END_STATE();
    case 24:
      if (lookahead == '\n') ADVANCE(34);
      if (lookahead == '/') ADVANCE(753);
      if (lookahead == 'o') ADVANCE(20);
      if (lookahead != 0) ADVANCE(33);
      END_STATE();
    case 25:
      if (lookahead == '\n') ADVANCE(34);
      if (lookahead == '/') ADVANCE(753);
      if (lookahead == 'o') ADVANCE(28);
      if (lookahead != 0) ADVANCE(33);
      END_STATE();
    case 26:
      if (lookahead == '\n') ADVANCE(34);
      if (lookahead == '/') ADVANCE(753);
      if (lookahead == 'r') ADVANCE(21);
      if (lookahead != 0) ADVANCE(33);
      END_STATE();
    case 27:
      if (lookahead == '\n') ADVANCE(34);
      if (lookahead == '/') ADVANCE(753);
      if (lookahead == 'r') ADVANCE(8);
      if (lookahead != 0) ADVANCE(33);
      END_STATE();
    case 28:
      if (lookahead == '\n') ADVANCE(34);
      if (lookahead == '/') ADVANCE(753);
      if (lookahead == 'r') ADVANCE(1926);
      if (lookahead != 0) ADVANCE(33);
      END_STATE();
    case 29:
      if (lookahead == '\n') ADVANCE(34);
      if (lookahead == '/') ADVANCE(753);
      if (lookahead == 'r') ADVANCE(25);
      if (lookahead != 0) ADVANCE(33);
      END_STATE();
    case 30:
      if (lookahead == '\n') ADVANCE(34);
      if (lookahead == '/') ADVANCE(753);
      if (lookahead == 's') ADVANCE(11);
      if (lookahead != 0) ADVANCE(33);
      END_STATE();
    case 31:
      if (lookahead == '\n') ADVANCE(34);
      if (lookahead == '/') ADVANCE(753);
      if (lookahead == 't') ADVANCE(17);
      if (lookahead != 0) ADVANCE(33);
      END_STATE();
    case 32:
      if (lookahead == '\n') ADVANCE(34);
      if (lookahead == '/') ADVANCE(753);
      if (lookahead == 'u') ADVANCE(27);
      if (lookahead != 0) ADVANCE(33);
      END_STATE();
    case 33:
      if (lookahead == '\n') ADVANCE(34);
      if (lookahead == '/') ADVANCE(753);
      if (lookahead != 0) ADVANCE(33);
      END_STATE();
    case 34:
      if (lookahead == '\n') ADVANCE(34);
      if (lookahead == '/') ADVANCE(147);
      if (lookahead != 0) ADVANCE(33);
      END_STATE();
    case 35:
      ADVANCE_MAP(
        '!', 1639,
        '"', 1585,
        '#', 156,
        '$', 748,
        '%', 1737,
        '&', 1657,
        '(', 1640,
        ')', 1628,
        '*', 1734,
        '+', 1731,
        ',', 1631,
        '-', 1732,
        '.', 1645,
        '/', 1735,
        '0', 1572,
        '<', 1669,
        '=', 173,
        '>', 1671,
        '?', 1652,
        '[', 1641,
        '\\', 1622,
        '^', 1743,
        '`', 189,
        'a', 1196,
        'b', 1400,
        'c', 1419,
        'e', 1158,
        'f', 1160,
        'i', 1285,
        'l', 1162,
        'n', 1308,
        'p', 1169,
        'r', 1279,
        's', 1246,
        't', 1436,
        '{', 1685,
        '|', 1741,
        '~', 1740,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(43);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1573);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_1, 802, lookahead)) ADVANCE(1542);
      END_STATE();
    case 36:
      ADVANCE_MAP(
        '!', 1639,
        '"', 1585,
        '#', 156,
        '$', 748,
        '%', 1737,
        '&', 1657,
        '(', 1640,
        '*', 1734,
        '+', 1731,
        '-', 1732,
        '.', 151,
        '/', 1735,
        '0', 1572,
        '<', 1669,
        '=', 173,
        '>', 1671,
        '?', 1652,
        '[', 1641,
        '\\', 1622,
        '^', 1743,
        '`', 189,
        'a', 1200,
        'b', 1400,
        'c', 1419,
        'e', 1158,
        'f', 1160,
        'i', 1286,
        'l', 1162,
        'n', 1308,
        'p', 1169,
        'r', 1279,
        's', 1251,
        't', 1436,
        '{', 1685,
        '|', 1741,
        '~', 1740,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(63);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1573);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_1, 802, lookahead)) ADVANCE(1542);
      END_STATE();
    case 37:
      ADVANCE_MAP(
        '!', 1639,
        '#', 325,
        '$', 748,
        '%', 1737,
        '&', 1657,
        '(', 1640,
        ')', 1628,
        '*', 1734,
        '+', 1731,
        ',', 1631,
        '-', 1732,
        '.', 1644,
        '/', 1736,
        '<', 1669,
        '=', 173,
        '>', 1671,
        '?', 1652,
        '@', 1841,
        '[', 1641,
        '^', 1743,
        '`', 189,
        'a', 1197,
        'b', 1400,
        'c', 1419,
        'e', 1158,
        'i', 1390,
        'l', 1162,
        'p', 1169,
        'r', 1279,
        's', 1408,
        '{', 1685,
        '|', 1741,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(72);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_1, 802, lookahead)) ADVANCE(1542);
      END_STATE();
    case 38:
      ADVANCE_MAP(
        '!', 1639,
        '#', 325,
        '%', 1737,
        '&', 1657,
        '(', 1640,
        ')', 1628,
        '*', 1734,
        '+', 1731,
        ',', 1631,
        '-', 1732,
        '.', 1644,
        '/', 1736,
        '<', 1669,
        '=', 173,
        '>', 1671,
        '?', 1652,
        '[', 1641,
        '^', 1743,
        'i', 636,
        '{', 1685,
        '|', 1741,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(96);
      END_STATE();
    case 39:
      ADVANCE_MAP(
        '!', 772,
        '/', 1,
        'a', 722,
        'c', 557,
        'd', 639,
        'e', 489,
        'f', 417,
        'i', 382,
        'k', 331,
        'l', 415,
        's', 366,
        'u', 521,
        'w', 205,
      );
      END_STATE();
    case 40:
      ADVANCE_MAP(
        '!', 772,
        '/', 1,
        'c', 557,
        'd', 639,
        'e', 488,
        'f', 417,
        'i', 382,
        'k', 331,
        'l', 415,
        's', 366,
        'w', 205,
      );
      END_STATE();
    case 41:
      ADVANCE_MAP(
        '!', 1807,
        '"', 1585,
        '#', 156,
        '$', 748,
        '%', 1737,
        '&', 1657,
        '(', 1640,
        ')', 1628,
        '*', 1734,
        '+', 1731,
        ',', 1631,
        '-', 1732,
        '.', 1645,
        '/', 1735,
        '0', 1572,
        ':', 1637,
        '<', 1669,
        '=', 173,
        '>', 1671,
        '?', 1652,
        '[', 1641,
        '\\', 1622,
        ']', 1642,
        '^', 1743,
        '`', 189,
        'a', 1196,
        'b', 1400,
        'c', 1419,
        'e', 1158,
        'f', 1160,
        'i', 1285,
        'l', 1162,
        'n', 1308,
        'p', 1169,
        'r', 1279,
        's', 1246,
        't', 1436,
        '{', 1685,
        '|', 1741,
        '~', 1740,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(42);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1573);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_1, 802, lookahead)) ADVANCE(1542);
      END_STATE();
    case 42:
      ADVANCE_MAP(
        '!', 1807,
        '"', 1585,
        '#', 156,
        '$', 748,
        '%', 1737,
        '&', 1657,
        '(', 1640,
        ')', 1628,
        '*', 1734,
        '+', 1731,
        ',', 1631,
        '-', 1732,
        '.', 1645,
        '/', 1735,
        '0', 1572,
        ':', 1637,
        '<', 1669,
        '=', 173,
        '>', 1671,
        '?', 1651,
        '[', 1641,
        '\\', 1622,
        ']', 1642,
        '^', 1743,
        '`', 189,
        'a', 1196,
        'b', 1400,
        'c', 1419,
        'e', 1158,
        'f', 1160,
        'i', 1285,
        'l', 1162,
        'n', 1308,
        'p', 1169,
        'r', 1279,
        's', 1246,
        't', 1436,
        '{', 1685,
        '|', 1741,
        '~', 1740,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(42);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1573);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_1, 802, lookahead)) ADVANCE(1542);
      END_STATE();
    case 43:
      ADVANCE_MAP(
        '!', 1807,
        '"', 1585,
        '#', 156,
        '$', 748,
        '%', 1737,
        '&', 1657,
        '(', 1640,
        ')', 1628,
        '*', 1734,
        '+', 1731,
        ',', 1631,
        '-', 1732,
        '.', 1645,
        '/', 1735,
        '0', 1572,
        '<', 1669,
        '=', 173,
        '>', 1671,
        '?', 1651,
        '[', 1641,
        '\\', 1622,
        '^', 1743,
        '`', 189,
        'a', 1196,
        'b', 1400,
        'c', 1419,
        'e', 1158,
        'f', 1160,
        'i', 1285,
        'l', 1162,
        'n', 1308,
        'p', 1169,
        'r', 1279,
        's', 1246,
        't', 1436,
        '{', 1685,
        '|', 1741,
        '~', 1740,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(43);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1573);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_1, 802, lookahead)) ADVANCE(1542);
      END_STATE();
    case 44:
      ADVANCE_MAP(
        '!', 1807,
        '"', 1585,
        '#', 156,
        '$', 748,
        '%', 1737,
        '&', 1657,
        '(', 1640,
        ')', 1628,
        '*', 1734,
        '+', 1731,
        ',', 1631,
        '-', 1732,
        '.', 151,
        '/', 1735,
        '0', 1572,
        ':', 1637,
        '<', 1669,
        '=', 173,
        '>', 1671,
        '@', 1840,
        '[', 1641,
        '\\', 1622,
        ']', 1642,
        '^', 1743,
        '`', 189,
        'a', 1196,
        'b', 1400,
        'c', 1419,
        'e', 1158,
        'f', 1160,
        'i', 1286,
        'l', 1162,
        'n', 1308,
        'p', 1169,
        'r', 1279,
        's', 1246,
        't', 1436,
        '{', 1685,
        '|', 1741,
        '~', 1740,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(44);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1573);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_1, 802, lookahead)) ADVANCE(1542);
      END_STATE();
    case 45:
      ADVANCE_MAP(
        '!', 1807,
        '"', 1585,
        '#', 156,
        '$', 748,
        '%', 1737,
        '&', 1657,
        '(', 1640,
        ')', 1628,
        '*', 1734,
        '+', 1731,
        '-', 1732,
        '.', 151,
        '/', 1735,
        '0', 1572,
        '<', 1669,
        '=', 173,
        '>', 1671,
        '@', 1841,
        '[', 1641,
        '\\', 1622,
        '^', 1743,
        '_', 1843,
        '`', 189,
        'a', 1196,
        'b', 1400,
        'c', 1419,
        'e', 1158,
        'f', 1160,
        'i', 1284,
        'l', 1162,
        'n', 1308,
        'p', 1169,
        'r', 1279,
        's', 1246,
        't', 1436,
        '{', 1685,
        '|', 1741,
        '~', 1740,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(45);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1573);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_1, 802, lookahead)) ADVANCE(1542);
      END_STATE();
    case 46:
      ADVANCE_MAP(
        '!', 1807,
        '"', 1585,
        '#', 156,
        '$', 748,
        '%', 1737,
        '&', 1657,
        '(', 1640,
        '*', 1734,
        '+', 1731,
        ',', 1631,
        '-', 1732,
        '.', 151,
        '/', 1735,
        '0', 1572,
        ':', 1637,
        '<', 1669,
        '=', 173,
        '>', 1671,
        '?', 1652,
        '[', 1641,
        '\\', 1622,
        '^', 1743,
        '`', 189,
        'a', 1200,
        'b', 1400,
        'c', 1419,
        'e', 1158,
        'f', 1160,
        'i', 1283,
        'l', 1162,
        'n', 1308,
        'p', 1169,
        'r', 1279,
        's', 1251,
        't', 1436,
        '{', 1685,
        '|', 1741,
        '}', 1687,
        '~', 1740,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(47);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1573);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_1, 802, lookahead)) ADVANCE(1542);
      END_STATE();
    case 47:
      ADVANCE_MAP(
        '!', 1807,
        '"', 1585,
        '#', 156,
        '$', 748,
        '%', 1737,
        '&', 1657,
        '(', 1640,
        '*', 1734,
        '+', 1731,
        ',', 1631,
        '-', 1732,
        '.', 151,
        '/', 1735,
        '0', 1572,
        ':', 1637,
        '<', 1669,
        '=', 173,
        '>', 1671,
        '?', 1651,
        '[', 1641,
        '\\', 1622,
        '^', 1743,
        '`', 189,
        'a', 1200,
        'b', 1400,
        'c', 1419,
        'e', 1158,
        'f', 1160,
        'i', 1283,
        'l', 1162,
        'n', 1308,
        'p', 1169,
        'r', 1279,
        's', 1251,
        't', 1436,
        '{', 1685,
        '|', 1741,
        '}', 1687,
        '~', 1740,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(47);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1573);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_1, 802, lookahead)) ADVANCE(1542);
      END_STATE();
    case 48:
      ADVANCE_MAP(
        '!', 1807,
        '"', 1585,
        '#', 156,
        '$', 748,
        '%', 1737,
        '&', 1657,
        '(', 1640,
        '*', 1734,
        '+', 1731,
        ',', 1631,
        '-', 1732,
        '.', 151,
        '/', 1735,
        '0', 1572,
        ':', 1637,
        '<', 1669,
        '=', 173,
        '>', 1671,
        '@', 1840,
        '[', 1641,
        '\\', 1622,
        ']', 1642,
        '^', 1743,
        '`', 189,
        'a', 1196,
        'b', 1400,
        'c', 1419,
        'e', 1158,
        'f', 1160,
        'i', 1286,
        'l', 1162,
        'n', 1308,
        'p', 1169,
        'r', 1279,
        's', 1246,
        't', 1436,
        'u', 1379,
        'w', 1256,
        '{', 1685,
        '|', 1741,
        '~', 1740,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(48);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1573);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_1, 802, lookahead)) ADVANCE(1542);
      END_STATE();
    case 49:
      ADVANCE_MAP(
        '!', 1807,
        '"', 1585,
        '#', 156,
        '$', 748,
        '%', 1737,
        '&', 1657,
        '(', 1640,
        '*', 1734,
        '+', 1731,
        ',', 1631,
        '-', 1732,
        '.', 151,
        '/', 1735,
        '0', 1572,
        '<', 1669,
        '=', 173,
        '>', 1671,
        '?', 1652,
        '@', 1841,
        '[', 1641,
        '\\', 1622,
        '^', 1743,
        '`', 189,
        'a', 1200,
        'b', 1400,
        'c', 1154,
        'd', 1306,
        'e', 1158,
        'f', 1179,
        'i', 1281,
        'l', 1162,
        'm', 1515,
        'n', 1307,
        'o', 1424,
        'p', 1166,
        'r', 1230,
        's', 1250,
        't', 1436,
        'u', 1379,
        'w', 1256,
        '{', 1685,
        '|', 1741,
        '}', 1687,
        '~', 1740,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(50);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1573);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_1, 802, lookahead)) ADVANCE(1542);
      END_STATE();
    case 50:
      ADVANCE_MAP(
        '!', 1807,
        '"', 1585,
        '#', 156,
        '$', 748,
        '%', 1737,
        '&', 1657,
        '(', 1640,
        '*', 1734,
        '+', 1731,
        ',', 1631,
        '-', 1732,
        '.', 151,
        '/', 1735,
        '0', 1572,
        '<', 1669,
        '=', 173,
        '>', 1671,
        '?', 1651,
        '@', 1841,
        '[', 1641,
        '\\', 1622,
        '^', 1743,
        '`', 189,
        'a', 1200,
        'b', 1400,
        'c', 1154,
        'd', 1306,
        'e', 1158,
        'f', 1179,
        'i', 1281,
        'l', 1162,
        'm', 1515,
        'n', 1307,
        'o', 1424,
        'p', 1166,
        'r', 1230,
        's', 1250,
        't', 1436,
        'u', 1379,
        'w', 1256,
        '{', 1685,
        '|', 1741,
        '}', 1687,
        '~', 1740,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(50);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1573);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_1, 802, lookahead)) ADVANCE(1542);
      END_STATE();
    case 51:
      ADVANCE_MAP(
        '!', 1807,
        '"', 1585,
        '#', 156,
        '$', 748,
        '%', 1737,
        '&', 1657,
        '(', 1640,
        '*', 1734,
        '+', 1731,
        '-', 1732,
        '.', 151,
        '/', 1735,
        '0', 1572,
        '<', 1669,
        '=', 173,
        '>', 1671,
        '@', 1841,
        '[', 1641,
        '\\', 1622,
        '^', 1743,
        '_', 1004,
        '`', 189,
        'a', 849,
        'b', 1033,
        'c', 991,
        'd', 949,
        'e', 815,
        'f', 816,
        'g', 917,
        'i', 927,
        'l', 818,
        'm', 1125,
        'n', 950,
        'o', 1051,
        'p', 825,
        'r', 891,
        's', 892,
        't', 945,
        'u', 1015,
        'v', 828,
        'w', 902,
        'y', 973,
        '{', 1685,
        '|', 1741,
        '}', 1687,
        '~', 1740,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(51);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1573);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('h' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_1, 802, lookahead)) ADVANCE(1542);
      END_STATE();
    case 52:
      ADVANCE_MAP(
        '!', 1807,
        '"', 1585,
        '#', 156,
        '$', 748,
        '%', 1737,
        '&', 1657,
        '(', 1640,
        '*', 1734,
        '+', 1731,
        '-', 1732,
        '.', 151,
        '/', 1735,
        '0', 1572,
        '<', 1669,
        '=', 173,
        '>', 1671,
        '@', 1841,
        '[', 1641,
        '\\', 1622,
        '^', 1743,
        '`', 189,
        'a', 1196,
        'b', 1400,
        'c', 1419,
        'e', 1158,
        'f', 1160,
        'i', 1284,
        'l', 1162,
        'n', 1308,
        'p', 1169,
        'r', 1279,
        's', 1246,
        't', 1436,
        '{', 1685,
        '|', 1741,
        '~', 1740,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(52);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1573);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_1, 802, lookahead)) ADVANCE(1542);
      END_STATE();
    case 53:
      ADVANCE_MAP(
        '!', 1807,
        '"', 1585,
        '#', 156,
        '$', 748,
        '%', 1737,
        '&', 1657,
        '(', 1640,
        '*', 1734,
        '+', 1731,
        '-', 1732,
        '.', 151,
        '/', 1735,
        '0', 1572,
        '<', 1669,
        '=', 173,
        '>', 1671,
        '@', 1841,
        '[', 1641,
        '\\', 1622,
        '^', 1743,
        '`', 189,
        'a', 849,
        'b', 1033,
        'c', 841,
        'd', 947,
        'e', 815,
        'f', 816,
        'g', 1133,
        'i', 928,
        'l', 818,
        'm', 1125,
        'n', 950,
        'o', 1051,
        'p', 825,
        'r', 891,
        's', 898,
        't', 945,
        'u', 1015,
        'v', 828,
        'w', 903,
        'y', 973,
        '{', 1685,
        '|', 1741,
        '}', 1687,
        '~', 1740,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(53);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1573);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_1, 802, lookahead)) ADVANCE(1542);
      END_STATE();
    case 54:
      ADVANCE_MAP(
        '!', 1807,
        '"', 1585,
        '#', 156,
        '$', 748,
        '%', 1737,
        '&', 1657,
        '(', 1640,
        '*', 1734,
        '+', 1731,
        '-', 1732,
        '.', 151,
        '/', 1735,
        '0', 1572,
        '<', 1669,
        '=', 173,
        '>', 1671,
        '@', 1841,
        '[', 1641,
        '\\', 1622,
        '^', 1743,
        '`', 189,
        'a', 849,
        'b', 1033,
        'c', 841,
        'd', 947,
        'e', 815,
        'f', 836,
        'g', 1133,
        'i', 927,
        'l', 818,
        'm', 1125,
        'n', 950,
        'o', 1051,
        'p', 825,
        'r', 891,
        's', 898,
        't', 945,
        'u', 1015,
        'v', 828,
        'w', 903,
        'y', 973,
        '{', 1685,
        '|', 1741,
        '}', 1687,
        '~', 1740,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(54);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1573);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_1, 802, lookahead)) ADVANCE(1542);
      END_STATE();
    case 55:
      ADVANCE_MAP(
        '!', 1807,
        '"', 1585,
        '#', 156,
        '$', 748,
        '%', 1737,
        '&', 1657,
        '(', 1640,
        '*', 1734,
        '+', 1731,
        '-', 1732,
        '.', 151,
        '/', 1735,
        '0', 1572,
        '<', 1669,
        '=', 173,
        '>', 1671,
        '@', 1841,
        '[', 1641,
        '\\', 1622,
        '^', 1743,
        '`', 189,
        'a', 849,
        'b', 1033,
        'c', 991,
        'd', 949,
        'e', 815,
        'f', 816,
        'g', 1133,
        'i', 928,
        'l', 818,
        'm', 1125,
        'n', 950,
        'o', 1051,
        'p', 825,
        'r', 891,
        's', 898,
        't', 945,
        'u', 1015,
        'v', 828,
        'w', 902,
        'y', 973,
        '{', 1685,
        '|', 1741,
        '}', 1687,
        '~', 1740,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(55);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1573);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_1, 802, lookahead)) ADVANCE(1542);
      END_STATE();
    case 56:
      ADVANCE_MAP(
        '!', 1807,
        '"', 1585,
        '#', 156,
        '$', 748,
        '%', 1737,
        '&', 1657,
        '(', 1640,
        '*', 1734,
        '+', 1731,
        '-', 1732,
        '.', 151,
        '/', 1735,
        '0', 1572,
        '<', 1669,
        '=', 173,
        '>', 1671,
        '@', 1841,
        '[', 1641,
        '\\', 1622,
        '^', 1743,
        '`', 189,
        'a', 1200,
        'b', 1400,
        'c', 1154,
        'd', 1306,
        'e', 1158,
        'f', 1179,
        'i', 1282,
        'l', 1162,
        'm', 1515,
        'n', 1307,
        'o', 1424,
        'p', 1166,
        'r', 1230,
        's', 1250,
        't', 1436,
        'u', 1379,
        'w', 1256,
        '{', 1685,
        '|', 1741,
        '}', 1687,
        '~', 1740,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(56);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1573);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_1, 802, lookahead)) ADVANCE(1542);
      END_STATE();
    case 57:
      ADVANCE_MAP(
        '!', 1807,
        '"', 1585,
        '#', 156,
        '$', 748,
        '%', 1737,
        '&', 1657,
        '(', 1640,
        '*', 1734,
        '+', 1731,
        '-', 1732,
        '.', 151,
        '/', 1735,
        '0', 1572,
        '<', 1669,
        '=', 173,
        '>', 1671,
        '@', 1840,
        '[', 1641,
        '\\', 1622,
        '^', 1743,
        '_', 1004,
        '`', 189,
        'a', 849,
        'b', 1033,
        'c', 992,
        'd', 1035,
        'e', 815,
        'f', 817,
        'g', 917,
        'i', 930,
        'l', 818,
        'm', 1125,
        'n', 951,
        'p', 826,
        'r', 896,
        's', 893,
        't', 945,
        'u', 1015,
        'v', 828,
        'w', 903,
        'y', 973,
        '{', 1685,
        '|', 1741,
        '}', 1687,
        '~', 1740,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(57);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1573);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('h' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_1, 802, lookahead)) ADVANCE(1542);
      END_STATE();
    case 58:
      ADVANCE_MAP(
        '!', 1807,
        '"', 1585,
        '#', 156,
        '$', 748,
        '%', 1737,
        '&', 1657,
        '(', 1640,
        '*', 1734,
        '+', 1731,
        '-', 1732,
        '.', 151,
        '/', 1735,
        '0', 1572,
        '<', 1669,
        '=', 173,
        '>', 1671,
        '@', 1840,
        '[', 1641,
        '\\', 1622,
        '^', 1743,
        '`', 189,
        'a', 849,
        'b', 1033,
        'c', 992,
        'd', 1035,
        'e', 815,
        'f', 817,
        'g', 1133,
        'i', 930,
        'l', 818,
        'n', 952,
        'p', 826,
        'r', 896,
        's', 899,
        't', 945,
        'u', 1015,
        'v', 828,
        'w', 903,
        'y', 973,
        '{', 1685,
        '|', 1741,
        '}', 1687,
        '~', 1740,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(58);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1573);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_1, 802, lookahead)) ADVANCE(1542);
      END_STATE();
    case 59:
      ADVANCE_MAP(
        '!', 1807,
        '"', 1585,
        '#', 156,
        '$', 748,
        '%', 1737,
        '&', 1657,
        '(', 1640,
        '*', 1734,
        '+', 1731,
        '-', 1732,
        '.', 151,
        '/', 1735,
        '0', 1572,
        '<', 1669,
        '=', 173,
        '>', 1671,
        '@', 1840,
        '[', 1641,
        '\\', 1622,
        '^', 1743,
        '`', 189,
        'a', 849,
        'b', 1033,
        'c', 992,
        'd', 1035,
        'e', 815,
        'f', 817,
        'g', 1133,
        'i', 929,
        'l', 818,
        'n', 952,
        'p', 826,
        'r', 896,
        's', 899,
        't', 945,
        'u', 1015,
        'v', 828,
        'w', 903,
        'y', 973,
        '{', 1685,
        '|', 1741,
        '}', 1687,
        '~', 1740,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(59);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1573);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_1, 802, lookahead)) ADVANCE(1542);
      END_STATE();
    case 60:
      ADVANCE_MAP(
        '!', 1807,
        '"', 1585,
        '#', 156,
        '$', 748,
        '%', 1737,
        '&', 1657,
        '(', 1640,
        '*', 1734,
        '+', 1731,
        '-', 1732,
        '.', 151,
        '/', 1735,
        '0', 1572,
        '<', 1669,
        '=', 173,
        '>', 1671,
        '[', 1641,
        '\\', 1622,
        '^', 1743,
        '_', 1843,
        '`', 189,
        'a', 1196,
        'b', 1400,
        'c', 1155,
        'e', 1158,
        'f', 1160,
        'i', 1285,
        'l', 1161,
        'n', 1308,
        'p', 1169,
        'r', 1279,
        's', 1246,
        't', 1436,
        'v', 1164,
        '{', 1685,
        '|', 1741,
        '~', 1740,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(60);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1573);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_1, 802, lookahead)) ADVANCE(1542);
      END_STATE();
    case 61:
      ADVANCE_MAP(
        '!', 1807,
        '"', 1585,
        '#', 156,
        '$', 748,
        '%', 1737,
        '&', 1657,
        '(', 1640,
        '*', 1734,
        '+', 1731,
        '-', 1732,
        '.', 151,
        '/', 1735,
        '0', 1572,
        '<', 1669,
        '=', 173,
        '>', 1671,
        '[', 1641,
        '\\', 1622,
        '^', 1743,
        '_', 1843,
        '`', 189,
        'a', 1200,
        'b', 1400,
        'c', 1155,
        'e', 1158,
        'f', 1160,
        'i', 1285,
        'l', 1161,
        'n', 1308,
        'p', 1169,
        'r', 1279,
        's', 1251,
        't', 1436,
        'v', 1164,
        '{', 1685,
        '|', 1741,
        '~', 1740,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(61);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1573);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_1, 802, lookahead)) ADVANCE(1542);
      END_STATE();
    case 62:
      ADVANCE_MAP(
        '!', 1807,
        '"', 1585,
        '#', 156,
        '$', 748,
        '%', 1737,
        '&', 1657,
        '(', 1640,
        '*', 1734,
        '+', 1731,
        '-', 1732,
        '.', 151,
        '/', 1735,
        '0', 1572,
        '<', 1669,
        '=', 173,
        '>', 1671,
        '[', 1641,
        '\\', 1622,
        '^', 1743,
        '`', 189,
        'a', 1200,
        'b', 1400,
        'c', 1419,
        'e', 1158,
        'f', 1160,
        'g', 1270,
        'i', 1286,
        'l', 1162,
        'n', 1308,
        'p', 1169,
        'r', 1279,
        's', 1243,
        't', 1436,
        '{', 1685,
        '|', 1741,
        '~', 1740,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(62);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1573);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_1, 802, lookahead)) ADVANCE(1542);
      END_STATE();
    case 63:
      ADVANCE_MAP(
        '!', 1807,
        '"', 1585,
        '#', 156,
        '$', 748,
        '%', 1737,
        '&', 1657,
        '(', 1640,
        '*', 1734,
        '+', 1731,
        '-', 1732,
        '.', 151,
        '/', 1735,
        '0', 1572,
        '<', 1669,
        '=', 173,
        '>', 1671,
        '[', 1641,
        '\\', 1622,
        '^', 1743,
        '`', 189,
        'a', 1200,
        'b', 1400,
        'c', 1419,
        'e', 1158,
        'f', 1160,
        'i', 1286,
        'l', 1162,
        'n', 1308,
        'p', 1169,
        'r', 1279,
        's', 1251,
        't', 1436,
        '{', 1685,
        '|', 1741,
        '~', 1740,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(63);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1573);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_1, 802, lookahead)) ADVANCE(1542);
      END_STATE();
    case 64:
      ADVANCE_MAP(
        '!', 1807,
        '"', 1585,
        '#', 154,
        '$', 748,
        '%', 1737,
        '&', 1657,
        '(', 1640,
        '*', 1734,
        '+', 1731,
        ',', 1631,
        '-', 1732,
        '.', 151,
        '/', 1735,
        '0', 1572,
        ';', 1808,
        '<', 1669,
        '=', 173,
        '>', 1671,
        '?', 1652,
        '@', 1841,
        '[', 1641,
        '\\', 1622,
        '^', 1743,
        '`', 189,
        'a', 1198,
        'b', 1400,
        'c', 1154,
        'd', 1229,
        'e', 1156,
        'f', 1159,
        'i', 1280,
        'l', 1161,
        'm', 1515,
        'n', 1307,
        'o', 1424,
        'p', 1165,
        'r', 1230,
        's', 1247,
        't', 1435,
        'u', 1379,
        'v', 1164,
        'w', 1256,
        '{', 1685,
        '|', 1741,
        '}', 1687,
        '~', 1740,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(65);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1573);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_1, 802, lookahead)) ADVANCE(1542);
      END_STATE();
    case 65:
      ADVANCE_MAP(
        '!', 1807,
        '"', 1585,
        '#', 154,
        '$', 748,
        '%', 1737,
        '&', 1657,
        '(', 1640,
        '*', 1734,
        '+', 1731,
        ',', 1631,
        '-', 1732,
        '.', 151,
        '/', 1735,
        '0', 1572,
        ';', 1808,
        '<', 1669,
        '=', 173,
        '>', 1671,
        '?', 1651,
        '@', 1841,
        '[', 1641,
        '\\', 1622,
        '^', 1743,
        '`', 189,
        'a', 1198,
        'b', 1400,
        'c', 1154,
        'd', 1229,
        'e', 1156,
        'f', 1159,
        'i', 1280,
        'l', 1161,
        'm', 1515,
        'n', 1307,
        'o', 1424,
        'p', 1165,
        'r', 1230,
        's', 1247,
        't', 1435,
        'u', 1379,
        'v', 1164,
        'w', 1256,
        '{', 1685,
        '|', 1741,
        '}', 1687,
        '~', 1740,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(65);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1573);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_1, 802, lookahead)) ADVANCE(1542);
      END_STATE();
    case 66:
      ADVANCE_MAP(
        '!', 1807,
        '"', 1585,
        '#', 154,
        '$', 748,
        '%', 1737,
        '&', 1657,
        '(', 1640,
        '*', 1734,
        '+', 1731,
        ',', 1631,
        '-', 1732,
        '.', 151,
        '/', 1735,
        '0', 1572,
        '<', 1669,
        '=', 173,
        '>', 1671,
        '?', 1652,
        '@', 1841,
        '[', 1641,
        '\\', 1622,
        '^', 1743,
        '`', 189,
        'a', 1200,
        'b', 1400,
        'c', 1154,
        'd', 1306,
        'e', 1158,
        'f', 1179,
        'i', 1281,
        'l', 1161,
        'm', 1515,
        'n', 1307,
        'o', 1424,
        'p', 1166,
        'r', 1230,
        's', 1250,
        't', 1436,
        'u', 1379,
        'v', 1164,
        'w', 1256,
        '{', 1685,
        '|', 1741,
        '}', 1687,
        '~', 1740,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(67);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1573);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_1, 802, lookahead)) ADVANCE(1542);
      END_STATE();
    case 67:
      ADVANCE_MAP(
        '!', 1807,
        '"', 1585,
        '#', 154,
        '$', 748,
        '%', 1737,
        '&', 1657,
        '(', 1640,
        '*', 1734,
        '+', 1731,
        ',', 1631,
        '-', 1732,
        '.', 151,
        '/', 1735,
        '0', 1572,
        '<', 1669,
        '=', 173,
        '>', 1671,
        '?', 1651,
        '@', 1841,
        '[', 1641,
        '\\', 1622,
        '^', 1743,
        '`', 189,
        'a', 1200,
        'b', 1400,
        'c', 1154,
        'd', 1306,
        'e', 1158,
        'f', 1179,
        'i', 1281,
        'l', 1161,
        'm', 1515,
        'n', 1307,
        'o', 1424,
        'p', 1166,
        'r', 1230,
        's', 1250,
        't', 1436,
        'u', 1379,
        'v', 1164,
        'w', 1256,
        '{', 1685,
        '|', 1741,
        '}', 1687,
        '~', 1740,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(67);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1573);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_1, 802, lookahead)) ADVANCE(1542);
      END_STATE();
    case 68:
      ADVANCE_MAP(
        '!', 1807,
        '"', 1585,
        '#', 154,
        '$', 748,
        '%', 1737,
        '&', 1657,
        '(', 1640,
        '*', 1734,
        '+', 1731,
        '-', 1732,
        '.', 151,
        '/', 1735,
        '0', 1572,
        ':', 1637,
        '<', 1669,
        '=', 173,
        '>', 1671,
        '[', 1641,
        '\\', 1622,
        '^', 1743,
        '`', 189,
        'a', 1200,
        'b', 1400,
        'c', 1155,
        'e', 1158,
        'f', 1160,
        'i', 1286,
        'l', 1161,
        'n', 1308,
        'p', 1169,
        'r', 1279,
        's', 1251,
        't', 1436,
        'v', 1164,
        '{', 1685,
        '|', 1741,
        '~', 1740,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(68);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1573);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_1, 802, lookahead)) ADVANCE(1542);
      END_STATE();
    case 69:
      ADVANCE_MAP(
        '!', 1807,
        '"', 1585,
        '#', 155,
        '$', 748,
        '%', 1737,
        '&', 1657,
        '(', 1640,
        ')', 1628,
        '*', 1734,
        '+', 1731,
        ',', 1631,
        '-', 1732,
        '.', 151,
        '/', 1735,
        '0', 1572,
        ':', 1637,
        '<', 1669,
        '=', 173,
        '>', 1671,
        '@', 1840,
        '[', 1641,
        '\\', 1622,
        ']', 1642,
        '^', 1743,
        '`', 189,
        'a', 1200,
        'b', 1400,
        'c', 1419,
        'e', 1158,
        'f', 1160,
        'i', 1286,
        'l', 1162,
        'n', 1308,
        'p', 1169,
        'r', 1279,
        's', 1251,
        't', 1436,
        '{', 1685,
        '|', 1741,
        '}', 1687,
        '~', 1740,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(69);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1573);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_1, 802, lookahead)) ADVANCE(1542);
      END_STATE();
    case 70:
      ADVANCE_MAP(
        '!', 1807,
        '#', 325,
        '$', 748,
        '%', 1737,
        '&', 1657,
        '(', 1640,
        ')', 1628,
        '*', 1734,
        '+', 1731,
        ',', 1631,
        '-', 1732,
        '.', 1644,
        '/', 1736,
        ':', 1637,
        '<', 1669,
        '=', 173,
        '>', 1671,
        '?', 1652,
        '@', 1841,
        '[', 1641,
        '^', 1743,
        '`', 189,
        'a', 1197,
        'b', 1400,
        'c', 1419,
        'e', 1158,
        'i', 1390,
        'l', 1162,
        'p', 1169,
        'r', 1279,
        's', 1408,
        '{', 1685,
        '|', 1741,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(71);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_1, 802, lookahead)) ADVANCE(1542);
      END_STATE();
    case 71:
      ADVANCE_MAP(
        '!', 1807,
        '#', 325,
        '$', 748,
        '%', 1737,
        '&', 1657,
        '(', 1640,
        ')', 1628,
        '*', 1734,
        '+', 1731,
        ',', 1631,
        '-', 1732,
        '.', 1644,
        '/', 1736,
        ':', 1637,
        '<', 1669,
        '=', 173,
        '>', 1671,
        '?', 1651,
        '@', 1841,
        '[', 1641,
        '^', 1743,
        '`', 189,
        'a', 1197,
        'b', 1400,
        'c', 1419,
        'e', 1158,
        'i', 1390,
        'l', 1162,
        'p', 1169,
        'r', 1279,
        's', 1408,
        '{', 1685,
        '|', 1741,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(71);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_1, 802, lookahead)) ADVANCE(1542);
      END_STATE();
    case 72:
      ADVANCE_MAP(
        '!', 1807,
        '#', 325,
        '$', 748,
        '%', 1737,
        '&', 1657,
        '(', 1640,
        ')', 1628,
        '*', 1734,
        '+', 1731,
        ',', 1631,
        '-', 1732,
        '.', 1644,
        '/', 1736,
        '<', 1669,
        '=', 173,
        '>', 1671,
        '?', 1651,
        '@', 1841,
        '[', 1641,
        '^', 1743,
        '`', 189,
        'a', 1197,
        'b', 1400,
        'c', 1419,
        'e', 1158,
        'i', 1390,
        'l', 1162,
        'p', 1169,
        'r', 1279,
        's', 1408,
        '{', 1685,
        '|', 1741,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(72);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_1, 802, lookahead)) ADVANCE(1542);
      END_STATE();
    case 73:
      ADVANCE_MAP(
        '!', 1807,
        '#', 325,
        '$', 748,
        '%', 1737,
        '&', 1657,
        '(', 1640,
        '*', 1734,
        '+', 1731,
        ',', 1631,
        '-', 1732,
        '.', 1644,
        '/', 1736,
        ';', 1808,
        '<', 1669,
        '=', 173,
        '>', 1671,
        '?', 1652,
        '@', 1841,
        '[', 1641,
        '^', 1743,
        '`', 189,
        'a', 1195,
        'b', 1400,
        'c', 1154,
        'd', 1229,
        'e', 1156,
        'f', 1302,
        'i', 1359,
        'l', 1161,
        'm', 1515,
        'n', 1409,
        'o', 1424,
        'p', 1165,
        'r', 1230,
        's', 1406,
        't', 1536,
        'u', 1379,
        'v', 1164,
        'w', 1256,
        '{', 1685,
        '|', 1741,
        '}', 1687,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(75);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_1, 802, lookahead)) ADVANCE(1542);
      END_STATE();
    case 74:
      ADVANCE_MAP(
        '!', 1807,
        '#', 325,
        '$', 748,
        '%', 1737,
        '&', 1657,
        '(', 1640,
        '*', 1734,
        '+', 1731,
        ',', 1631,
        '-', 1732,
        '.', 1644,
        '/', 1736,
        ';', 1808,
        '<', 1669,
        '=', 173,
        '>', 1671,
        '?', 1652,
        '@', 1841,
        '[', 1641,
        '^', 1743,
        '`', 189,
        'a', 1199,
        'b', 1400,
        'c', 1154,
        'd', 1229,
        'e', 1156,
        'f', 1302,
        'i', 1359,
        'l', 1161,
        'm', 1515,
        'n', 1409,
        'o', 1424,
        'p', 1165,
        'r', 1230,
        's', 1474,
        't', 1536,
        'u', 1379,
        'v', 1164,
        'w', 1256,
        '{', 1685,
        '|', 1741,
        '}', 1687,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(76);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_1, 802, lookahead)) ADVANCE(1542);
      END_STATE();
    case 75:
      ADVANCE_MAP(
        '!', 1807,
        '#', 325,
        '$', 748,
        '%', 1737,
        '&', 1657,
        '(', 1640,
        '*', 1734,
        '+', 1731,
        ',', 1631,
        '-', 1732,
        '.', 1644,
        '/', 1736,
        ';', 1808,
        '<', 1669,
        '=', 173,
        '>', 1671,
        '?', 1651,
        '@', 1841,
        '[', 1641,
        '^', 1743,
        '`', 189,
        'a', 1195,
        'b', 1400,
        'c', 1154,
        'd', 1229,
        'e', 1156,
        'f', 1302,
        'i', 1359,
        'l', 1161,
        'm', 1515,
        'n', 1409,
        'o', 1424,
        'p', 1165,
        'r', 1230,
        's', 1406,
        't', 1536,
        'u', 1379,
        'v', 1164,
        'w', 1256,
        '{', 1685,
        '|', 1741,
        '}', 1687,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(75);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_1, 802, lookahead)) ADVANCE(1542);
      END_STATE();
    case 76:
      ADVANCE_MAP(
        '!', 1807,
        '#', 325,
        '$', 748,
        '%', 1737,
        '&', 1657,
        '(', 1640,
        '*', 1734,
        '+', 1731,
        ',', 1631,
        '-', 1732,
        '.', 1644,
        '/', 1736,
        ';', 1808,
        '<', 1669,
        '=', 173,
        '>', 1671,
        '?', 1651,
        '@', 1841,
        '[', 1641,
        '^', 1743,
        '`', 189,
        'a', 1199,
        'b', 1400,
        'c', 1154,
        'd', 1229,
        'e', 1156,
        'f', 1302,
        'i', 1359,
        'l', 1161,
        'm', 1515,
        'n', 1409,
        'o', 1424,
        'p', 1165,
        'r', 1230,
        's', 1474,
        't', 1536,
        'u', 1379,
        'v', 1164,
        'w', 1256,
        '{', 1685,
        '|', 1741,
        '}', 1687,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(76);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_1, 802, lookahead)) ADVANCE(1542);
      END_STATE();
    case 77:
      ADVANCE_MAP(
        '!', 1807,
        '#', 325,
        '$', 748,
        '%', 1737,
        '&', 1657,
        '(', 1640,
        '*', 1734,
        '+', 1731,
        ',', 1631,
        '-', 1732,
        '.', 1644,
        '/', 1736,
        '<', 1669,
        '=', 173,
        '>', 1671,
        '?', 1652,
        '@', 1841,
        '[', 1641,
        '^', 1743,
        '`', 189,
        'a', 1197,
        'b', 1400,
        'c', 1154,
        'd', 1306,
        'e', 1158,
        'f', 1180,
        'i', 1369,
        'l', 1162,
        'm', 1515,
        'n', 1409,
        'o', 1424,
        'p', 1166,
        'r', 1230,
        's', 1407,
        'u', 1379,
        'w', 1256,
        '{', 1685,
        '|', 1741,
        '}', 1687,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(79);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_1, 802, lookahead)) ADVANCE(1542);
      END_STATE();
    case 78:
      ADVANCE_MAP(
        '!', 1807,
        '#', 325,
        '$', 748,
        '%', 1737,
        '&', 1657,
        '(', 1640,
        '*', 1734,
        '+', 1731,
        ',', 1631,
        '-', 1732,
        '.', 1644,
        '/', 1736,
        '<', 1669,
        '=', 173,
        '>', 1671,
        '?', 1652,
        '@', 1841,
        '[', 1641,
        '^', 1743,
        '`', 189,
        'a', 1201,
        'b', 1400,
        'c', 1154,
        'd', 1306,
        'e', 1158,
        'f', 1180,
        'i', 1369,
        'l', 1162,
        'm', 1515,
        'n', 1409,
        'o', 1424,
        'p', 1166,
        'r', 1230,
        's', 1506,
        'u', 1379,
        'w', 1256,
        '{', 1685,
        '|', 1741,
        '}', 1687,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(80);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_1, 802, lookahead)) ADVANCE(1542);
      END_STATE();
    case 79:
      ADVANCE_MAP(
        '!', 1807,
        '#', 325,
        '$', 748,
        '%', 1737,
        '&', 1657,
        '(', 1640,
        '*', 1734,
        '+', 1731,
        ',', 1631,
        '-', 1732,
        '.', 1644,
        '/', 1736,
        '<', 1669,
        '=', 173,
        '>', 1671,
        '?', 1651,
        '@', 1841,
        '[', 1641,
        '^', 1743,
        '`', 189,
        'a', 1197,
        'b', 1400,
        'c', 1154,
        'd', 1306,
        'e', 1158,
        'f', 1180,
        'i', 1369,
        'l', 1162,
        'm', 1515,
        'n', 1409,
        'o', 1424,
        'p', 1166,
        'r', 1230,
        's', 1407,
        'u', 1379,
        'w', 1256,
        '{', 1685,
        '|', 1741,
        '}', 1687,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(79);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_1, 802, lookahead)) ADVANCE(1542);
      END_STATE();
    case 80:
      ADVANCE_MAP(
        '!', 1807,
        '#', 325,
        '$', 748,
        '%', 1737,
        '&', 1657,
        '(', 1640,
        '*', 1734,
        '+', 1731,
        ',', 1631,
        '-', 1732,
        '.', 1644,
        '/', 1736,
        '<', 1669,
        '=', 173,
        '>', 1671,
        '?', 1651,
        '@', 1841,
        '[', 1641,
        '^', 1743,
        '`', 189,
        'a', 1201,
        'b', 1400,
        'c', 1154,
        'd', 1306,
        'e', 1158,
        'f', 1180,
        'i', 1369,
        'l', 1162,
        'm', 1515,
        'n', 1409,
        'o', 1424,
        'p', 1166,
        'r', 1230,
        's', 1506,
        'u', 1379,
        'w', 1256,
        '{', 1685,
        '|', 1741,
        '}', 1687,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(80);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_1, 802, lookahead)) ADVANCE(1542);
      END_STATE();
    case 81:
      ADVANCE_MAP(
        '!', 1807,
        '#', 325,
        '$', 748,
        '%', 1737,
        '&', 1657,
        '(', 1640,
        '*', 1734,
        '+', 1731,
        ',', 1631,
        '-', 1732,
        '.', 150,
        '/', 1736,
        ':', 1637,
        '<', 1669,
        '=', 173,
        '>', 1671,
        '?', 1652,
        '@', 1841,
        '[', 1641,
        '^', 1743,
        '`', 189,
        'a', 1201,
        'b', 1400,
        'c', 1154,
        'd', 1306,
        'e', 1156,
        'f', 1302,
        'i', 1373,
        'l', 1161,
        'm', 1515,
        'n', 1409,
        'o', 1424,
        'p', 1166,
        'r', 1230,
        's', 1475,
        't', 1536,
        'u', 1379,
        'v', 1164,
        'w', 1256,
        '{', 1685,
        '|', 1741,
        '}', 1687,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(88);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_1, 802, lookahead)) ADVANCE(1542);
      END_STATE();
    case 82:
      ADVANCE_MAP(
        '!', 1807,
        '#', 325,
        '$', 748,
        '%', 1737,
        '&', 1657,
        '(', 1640,
        '*', 1734,
        '+', 1731,
        ',', 1631,
        '-', 1732,
        '.', 150,
        '/', 1736,
        ':', 1637,
        '<', 1669,
        '=', 173,
        '>', 1671,
        '?', 1652,
        '@', 1841,
        '[', 1641,
        '^', 1743,
        '`', 189,
        'a', 1201,
        'b', 1400,
        'c', 1154,
        'd', 1306,
        'e', 1158,
        'f', 1303,
        'i', 1375,
        'l', 1162,
        'm', 1515,
        'n', 1409,
        'o', 1424,
        'p', 1166,
        'r', 1230,
        's', 1506,
        'u', 1379,
        'w', 1256,
        '{', 1685,
        '|', 1741,
        '}', 1687,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(89);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_1, 802, lookahead)) ADVANCE(1542);
      END_STATE();
    case 83:
      ADVANCE_MAP(
        '!', 1807,
        '#', 325,
        '$', 748,
        '%', 1737,
        '&', 1657,
        '(', 1640,
        '*', 1734,
        '+', 1731,
        ',', 1631,
        '-', 1732,
        '.', 150,
        '/', 1736,
        ':', 1637,
        '<', 1669,
        '=', 173,
        '>', 1671,
        '?', 1652,
        '@', 1841,
        '[', 1641,
        '^', 1743,
        '`', 189,
        'a', 1201,
        'b', 1400,
        'c', 1347,
        'd', 1305,
        'e', 1156,
        'f', 1302,
        'i', 1373,
        'l', 1161,
        'm', 1515,
        'n', 1409,
        'o', 1424,
        'p', 1166,
        'r', 1230,
        's', 1475,
        't', 1536,
        'u', 1379,
        'v', 1164,
        'w', 1255,
        '{', 1685,
        '|', 1741,
        '}', 1687,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(90);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_1, 802, lookahead)) ADVANCE(1542);
      END_STATE();
    case 84:
      ADVANCE_MAP(
        '!', 1807,
        '#', 325,
        '$', 748,
        '%', 1737,
        '&', 1657,
        '(', 1640,
        '*', 1734,
        '+', 1731,
        ',', 1631,
        '-', 1732,
        '.', 150,
        '/', 1736,
        ':', 1637,
        '<', 1669,
        '=', 173,
        '>', 1671,
        '?', 1652,
        '@', 1841,
        '[', 1641,
        '^', 1743,
        '`', 189,
        'a', 1201,
        'b', 1400,
        'c', 1347,
        'd', 1305,
        'e', 1158,
        'f', 1303,
        'i', 1375,
        'l', 1162,
        'm', 1515,
        'n', 1409,
        'o', 1424,
        'p', 1166,
        'r', 1230,
        's', 1506,
        'u', 1379,
        'w', 1255,
        '{', 1685,
        '|', 1741,
        '}', 1687,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(91);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_1, 802, lookahead)) ADVANCE(1542);
      END_STATE();
    case 85:
      ADVANCE_MAP(
        '!', 1807,
        '#', 325,
        '$', 748,
        '%', 1737,
        '&', 1657,
        '(', 1640,
        '*', 1734,
        '+', 1731,
        ',', 1631,
        '-', 1732,
        '.', 150,
        '/', 1736,
        ':', 1637,
        '<', 1669,
        '=', 173,
        '>', 1671,
        '?', 1652,
        '@', 1840,
        '[', 1641,
        '^', 1743,
        '`', 189,
        'a', 1201,
        'b', 1400,
        'c', 1348,
        'e', 1156,
        'f', 1332,
        'i', 1376,
        'l', 1161,
        'p', 1169,
        'r', 1279,
        's', 1494,
        't', 1536,
        'u', 1379,
        'v', 1164,
        'w', 1256,
        '{', 1685,
        '|', 1741,
        '}', 1687,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(92);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_1, 802, lookahead)) ADVANCE(1542);
      END_STATE();
    case 86:
      ADVANCE_MAP(
        '!', 1807,
        '#', 325,
        '$', 748,
        '%', 1737,
        '&', 1657,
        '(', 1640,
        '*', 1734,
        '+', 1731,
        ',', 1631,
        '-', 1732,
        '.', 150,
        '/', 1736,
        ':', 1637,
        '<', 1669,
        '=', 173,
        '>', 1671,
        '?', 1652,
        '[', 1641,
        '^', 1743,
        '`', 189,
        'a', 1201,
        'b', 1400,
        'c', 1419,
        'e', 1158,
        'i', 1371,
        'l', 1161,
        'p', 1169,
        'r', 1279,
        'v', 1164,
        '{', 1685,
        '|', 1741,
        '}', 1687,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(93);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_1, 802, lookahead)) ADVANCE(1542);
      END_STATE();
    case 87:
      ADVANCE_MAP(
        '!', 1807,
        '#', 325,
        '$', 748,
        '%', 1737,
        '&', 1657,
        '(', 1640,
        '*', 1734,
        '+', 1731,
        ',', 1631,
        '-', 1732,
        '.', 150,
        '/', 1736,
        ':', 1637,
        '<', 1669,
        '=', 173,
        '>', 1671,
        '?', 1652,
        '[', 1641,
        '^', 1743,
        '`', 189,
        'a', 1201,
        'b', 1400,
        'c', 1419,
        'e', 1158,
        'i', 1371,
        'l', 1162,
        'p', 1169,
        'r', 1279,
        '{', 1685,
        '|', 1741,
        '}', 1687,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(94);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_1, 802, lookahead)) ADVANCE(1542);
      END_STATE();
    case 88:
      ADVANCE_MAP(
        '!', 1807,
        '#', 325,
        '$', 748,
        '%', 1737,
        '&', 1657,
        '(', 1640,
        '*', 1734,
        '+', 1731,
        ',', 1631,
        '-', 1732,
        '.', 150,
        '/', 1736,
        ':', 1637,
        '<', 1669,
        '=', 173,
        '>', 1671,
        '?', 1651,
        '@', 1841,
        '[', 1641,
        '^', 1743,
        '`', 189,
        'a', 1201,
        'b', 1400,
        'c', 1154,
        'd', 1306,
        'e', 1156,
        'f', 1302,
        'i', 1373,
        'l', 1161,
        'm', 1515,
        'n', 1409,
        'o', 1424,
        'p', 1166,
        'r', 1230,
        's', 1475,
        't', 1536,
        'u', 1379,
        'v', 1164,
        'w', 1256,
        '{', 1685,
        '|', 1741,
        '}', 1687,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(88);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_1, 802, lookahead)) ADVANCE(1542);
      END_STATE();
    case 89:
      ADVANCE_MAP(
        '!', 1807,
        '#', 325,
        '$', 748,
        '%', 1737,
        '&', 1657,
        '(', 1640,
        '*', 1734,
        '+', 1731,
        ',', 1631,
        '-', 1732,
        '.', 150,
        '/', 1736,
        ':', 1637,
        '<', 1669,
        '=', 173,
        '>', 1671,
        '?', 1651,
        '@', 1841,
        '[', 1641,
        '^', 1743,
        '`', 189,
        'a', 1201,
        'b', 1400,
        'c', 1154,
        'd', 1306,
        'e', 1158,
        'f', 1303,
        'i', 1375,
        'l', 1162,
        'm', 1515,
        'n', 1409,
        'o', 1424,
        'p', 1166,
        'r', 1230,
        's', 1506,
        'u', 1379,
        'w', 1256,
        '{', 1685,
        '|', 1741,
        '}', 1687,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(89);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_1, 802, lookahead)) ADVANCE(1542);
      END_STATE();
    case 90:
      ADVANCE_MAP(
        '!', 1807,
        '#', 325,
        '$', 748,
        '%', 1737,
        '&', 1657,
        '(', 1640,
        '*', 1734,
        '+', 1731,
        ',', 1631,
        '-', 1732,
        '.', 150,
        '/', 1736,
        ':', 1637,
        '<', 1669,
        '=', 173,
        '>', 1671,
        '?', 1651,
        '@', 1841,
        '[', 1641,
        '^', 1743,
        '`', 189,
        'a', 1201,
        'b', 1400,
        'c', 1347,
        'd', 1305,
        'e', 1156,
        'f', 1302,
        'i', 1373,
        'l', 1161,
        'm', 1515,
        'n', 1409,
        'o', 1424,
        'p', 1166,
        'r', 1230,
        's', 1475,
        't', 1536,
        'u', 1379,
        'v', 1164,
        'w', 1255,
        '{', 1685,
        '|', 1741,
        '}', 1687,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(90);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_1, 802, lookahead)) ADVANCE(1542);
      END_STATE();
    case 91:
      ADVANCE_MAP(
        '!', 1807,
        '#', 325,
        '$', 748,
        '%', 1737,
        '&', 1657,
        '(', 1640,
        '*', 1734,
        '+', 1731,
        ',', 1631,
        '-', 1732,
        '.', 150,
        '/', 1736,
        ':', 1637,
        '<', 1669,
        '=', 173,
        '>', 1671,
        '?', 1651,
        '@', 1841,
        '[', 1641,
        '^', 1743,
        '`', 189,
        'a', 1201,
        'b', 1400,
        'c', 1347,
        'd', 1305,
        'e', 1158,
        'f', 1303,
        'i', 1375,
        'l', 1162,
        'm', 1515,
        'n', 1409,
        'o', 1424,
        'p', 1166,
        'r', 1230,
        's', 1506,
        'u', 1379,
        'w', 1255,
        '{', 1685,
        '|', 1741,
        '}', 1687,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(91);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_1, 802, lookahead)) ADVANCE(1542);
      END_STATE();
    case 92:
      ADVANCE_MAP(
        '!', 1807,
        '#', 325,
        '$', 748,
        '%', 1737,
        '&', 1657,
        '(', 1640,
        '*', 1734,
        '+', 1731,
        ',', 1631,
        '-', 1732,
        '.', 150,
        '/', 1736,
        ':', 1637,
        '<', 1669,
        '=', 173,
        '>', 1671,
        '?', 1651,
        '@', 1840,
        '[', 1641,
        '^', 1743,
        '`', 189,
        'a', 1201,
        'b', 1400,
        'c', 1348,
        'e', 1156,
        'f', 1332,
        'i', 1376,
        'l', 1161,
        'p', 1169,
        'r', 1279,
        's', 1494,
        't', 1536,
        'u', 1379,
        'v', 1164,
        'w', 1256,
        '{', 1685,
        '|', 1741,
        '}', 1687,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(92);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_1, 802, lookahead)) ADVANCE(1542);
      END_STATE();
    case 93:
      ADVANCE_MAP(
        '!', 1807,
        '#', 325,
        '$', 748,
        '%', 1737,
        '&', 1657,
        '(', 1640,
        '*', 1734,
        '+', 1731,
        ',', 1631,
        '-', 1732,
        '.', 150,
        '/', 1736,
        ':', 1637,
        '<', 1669,
        '=', 173,
        '>', 1671,
        '?', 1651,
        '[', 1641,
        '^', 1743,
        '`', 189,
        'a', 1201,
        'b', 1400,
        'c', 1419,
        'e', 1158,
        'i', 1371,
        'l', 1161,
        'p', 1169,
        'r', 1279,
        'v', 1164,
        '{', 1685,
        '|', 1741,
        '}', 1687,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(93);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_1, 802, lookahead)) ADVANCE(1542);
      END_STATE();
    case 94:
      ADVANCE_MAP(
        '!', 1807,
        '#', 325,
        '$', 748,
        '%', 1737,
        '&', 1657,
        '(', 1640,
        '*', 1734,
        '+', 1731,
        ',', 1631,
        '-', 1732,
        '.', 150,
        '/', 1736,
        ':', 1637,
        '<', 1669,
        '=', 173,
        '>', 1671,
        '?', 1651,
        '[', 1641,
        '^', 1743,
        '`', 189,
        'a', 1201,
        'b', 1400,
        'c', 1419,
        'e', 1158,
        'i', 1371,
        'l', 1162,
        'p', 1169,
        'r', 1279,
        '{', 1685,
        '|', 1741,
        '}', 1687,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(94);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_1, 802, lookahead)) ADVANCE(1542);
      END_STATE();
    case 95:
      ADVANCE_MAP(
        '!', 1807,
        '#', 325,
        '$', 748,
        '%', 1737,
        '&', 1657,
        '*', 1734,
        '+', 1731,
        '-', 1732,
        '/', 1736,
        '<', 1669,
        '=', 173,
        '>', 1671,
        '^', 1742,
        '`', 189,
        'a', 1201,
        'b', 1400,
        'c', 1419,
        'e', 1158,
        'l', 1162,
        'p', 1169,
        'r', 1279,
        '|', 1741,
        '~', 1740,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(95);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_1, 802, lookahead)) ADVANCE(1542);
      END_STATE();
    case 96:
      ADVANCE_MAP(
        '!', 1807,
        '#', 325,
        '%', 1737,
        '&', 1657,
        '(', 1640,
        ')', 1628,
        '*', 1734,
        '+', 1731,
        ',', 1631,
        '-', 1732,
        '.', 1644,
        '/', 1736,
        '<', 1669,
        '=', 173,
        '>', 1671,
        '?', 1651,
        '[', 1641,
        '^', 1743,
        'i', 636,
        '{', 1685,
        '|', 1741,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(96);
      END_STATE();
    case 97:
      ADVANCE_MAP(
        '!', 1807,
        '#', 325,
        '%', 1737,
        '&', 1657,
        '(', 1640,
        '*', 1734,
        '+', 1731,
        ',', 1631,
        '-', 1732,
        '.', 150,
        '/', 1736,
        '<', 1669,
        '=', 173,
        '>', 1671,
        '?', 1652,
        '[', 1641,
        '^', 1743,
        'i', 514,
        '{', 1685,
        '|', 1741,
        '}', 1687,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(98);
      END_STATE();
    case 98:
      ADVANCE_MAP(
        '!', 1807,
        '#', 325,
        '%', 1737,
        '&', 1657,
        '(', 1640,
        '*', 1734,
        '+', 1731,
        ',', 1631,
        '-', 1732,
        '.', 150,
        '/', 1736,
        '<', 1669,
        '=', 173,
        '>', 1671,
        '?', 1651,
        '[', 1641,
        '^', 1743,
        'i', 514,
        '{', 1685,
        '|', 1741,
        '}', 1687,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(98);
      END_STATE();
    case 99:
      ADVANCE_MAP(
        '!', 1807,
        '#', 325,
        '%', 1737,
        '&', 1657,
        '(', 1640,
        '*', 1734,
        '+', 1731,
        '-', 1732,
        '.', 150,
        '/', 1736,
        '<', 1669,
        '=', 173,
        '>', 1671,
        '?', 1652,
        '@', 1840,
        '[', 1641,
        '^', 1743,
        'a', 253,
        'c', 470,
        'e', 515,
        'f', 445,
        'i', 540,
        'l', 192,
        's', 681,
        't', 738,
        'u', 534,
        'v', 201,
        'w', 334,
        '{', 1685,
        '|', 1741,
        '}', 1687,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(100);
      END_STATE();
    case 100:
      ADVANCE_MAP(
        '!', 1807,
        '#', 325,
        '%', 1737,
        '&', 1657,
        '(', 1640,
        '*', 1734,
        '+', 1731,
        '-', 1732,
        '.', 150,
        '/', 1736,
        '<', 1669,
        '=', 173,
        '>', 1671,
        '?', 1651,
        '@', 1840,
        '[', 1641,
        '^', 1743,
        'a', 253,
        'c', 470,
        'e', 515,
        'f', 445,
        'i', 540,
        'l', 192,
        's', 681,
        't', 738,
        'u', 534,
        'v', 201,
        'w', 334,
        '{', 1685,
        '|', 1741,
        '}', 1687,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(100);
      END_STATE();
    case 101:
      ADVANCE_MAP(
        '!', 1638,
        '#', 325,
        '$', 748,
        '&', 1657,
        '(', 1640,
        ')', 1628,
        ',', 1631,
        '.', 1646,
        '/', 162,
        ':', 1637,
        '<', 1668,
        '?', 1652,
        '@', 1841,
        '[', 1641,
        '`', 189,
        'a', 1197,
        'b', 1400,
        'c', 1419,
        'e', 1158,
        'i', 1391,
        'l', 1162,
        'p', 1169,
        'r', 1279,
        's', 1408,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(114);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_1, 802, lookahead)) ADVANCE(1542);
      END_STATE();
    case 102:
      ADVANCE_MAP(
        '!', 1638,
        '#', 325,
        '$', 748,
        '&', 1657,
        '(', 1640,
        ',', 1631,
        '.', 1643,
        '/', 162,
        ':', 1637,
        '<', 1668,
        '?', 1652,
        '@', 1841,
        '[', 1641,
        '`', 189,
        'a', 1197,
        'b', 1400,
        'c', 1154,
        'd', 1306,
        'e', 1158,
        'f', 1180,
        'i', 1370,
        'l', 1162,
        'm', 1515,
        'n', 1409,
        'o', 1424,
        'p', 1166,
        'r', 1230,
        's', 1407,
        'u', 1379,
        'w', 1256,
        '{', 1685,
        '}', 1687,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(115);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_1, 802, lookahead)) ADVANCE(1542);
      END_STATE();
    case 103:
      ADVANCE_MAP(
        '!', 1638,
        '#', 325,
        '$', 748,
        '&', 1657,
        '(', 1640,
        ',', 1631,
        '.', 1643,
        '/', 162,
        ':', 1637,
        '<', 1668,
        '?', 1652,
        '[', 1641,
        '`', 189,
        'a', 1197,
        'b', 1400,
        'c', 1419,
        'e', 1158,
        'i', 1372,
        'l', 1162,
        'p', 1169,
        'r', 1279,
        's', 1408,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(116);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_1, 802, lookahead)) ADVANCE(1542);
      END_STATE();
    case 104:
      ADVANCE_MAP(
        '!', 1638,
        '#', 325,
        '$', 748,
        '&', 1657,
        '(', 1640,
        ',', 1631,
        '.', 1643,
        '/', 162,
        '<', 1668,
        '?', 1652,
        '@', 1841,
        '[', 1641,
        '`', 189,
        'a', 1197,
        'b', 1400,
        'c', 1419,
        'e', 1158,
        'i', 1378,
        'l', 1162,
        'p', 1169,
        'r', 1279,
        's', 1408,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(117);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_1, 802, lookahead)) ADVANCE(1542);
      END_STATE();
    case 105:
      ADVANCE_MAP(
        '!', 1638,
        '#', 325,
        '$', 748,
        '(', 1640,
        '/', 162,
        '?', 1652,
        '_', 1843,
        '`', 189,
        'a', 1200,
        'b', 1400,
        'c', 1155,
        'e', 1158,
        'i', 1460,
        'l', 1161,
        'p', 1169,
        'r', 1279,
        'v', 1164,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(126);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_1, 802, lookahead)) ADVANCE(1542);
      END_STATE();
    case 106:
      ADVANCE_MAP(
        '!', 1638,
        '#', 325,
        '&', 1657,
        '(', 1640,
        ')', 1628,
        ',', 1631,
        '.', 1643,
        '/', 162,
        ':', 1637,
        '<', 1668,
        '>', 1670,
        '?', 1652,
        ']', 1642,
        '^', 742,
        'i', 513,
        'u', 1624,
        '{', 1685,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(141);
      END_STATE();
    case 107:
      ADVANCE_MAP(
        '!', 1638,
        '#', 325,
        '&', 1657,
        '(', 1640,
        ')', 1628,
        ',', 1631,
        '.', 1646,
        '/', 162,
        '0', 1574,
        ':', 1637,
        ';', 1808,
        '<', 1668,
        '>', 1670,
        '?', 1652,
        '@', 1841,
        'P', 605,
        'T', 732,
        ']', 1642,
        '^', 742,
        '_', 499,
        'a', 252,
        'b', 550,
        'c', 198,
        'd', 372,
        'e', 515,
        'f', 228,
        'g', 363,
        'i', 380,
        'l', 192,
        'm', 195,
        'n', 556,
        'o', 582,
        'p', 216,
        'r', 327,
        's', 364,
        't', 738,
        'u', 534,
        'v', 201,
        'w', 335,
        '{', 1685,
        '}', 1687,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(143);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1574);
      END_STATE();
    case 108:
      ADVANCE_MAP(
        '!', 1806,
        '#', 325,
        '$', 748,
        ')', 1628,
        '/', 162,
        '?', 1651,
        '[', 1641,
        '`', 189,
        'a', 1201,
        'b', 1400,
        'c', 1419,
        'e', 1158,
        'l', 1162,
        'p', 1169,
        'r', 1279,
        's', 1252,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(108);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_1, 802, lookahead)) ADVANCE(1542);
      END_STATE();
    case 109:
      ADVANCE_MAP(
        '"', 1585,
        '#', 157,
        '$', 748,
        '.', 749,
        '/', 158,
        '0', 1572,
        '`', 189,
        'a', 1201,
        'b', 1400,
        'c', 1419,
        'e', 1158,
        'f', 1160,
        'l', 1162,
        'n', 1308,
        'p', 1169,
        'r', 1279,
        't', 1447,
        '}', 1687,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(109);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1573);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_1, 802, lookahead)) ADVANCE(1542);
      END_STATE();
    case 110:
      if (lookahead == '"') ADVANCE(1585);
      if (lookahead == '#') ADVANCE(1597);
      if (lookahead == '/') ADVANCE(1590);
      if (lookahead == '\\') ADVANCE(1623);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(1589);
      if (lookahead != 0) ADVANCE(1621);
      END_STATE();
    case 111:
      if (lookahead == '"') ADVANCE(1627);
      END_STATE();
    case 112:
      if (lookahead == '"') ADVANCE(1584);
      if (lookahead == '#') ADVANCE(1597);
      if (lookahead == '/') ADVANCE(1590);
      if (lookahead == '\\') ADVANCE(1623);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(1589);
      if (lookahead != 0) ADVANCE(1621);
      END_STATE();
    case 113:
      if (lookahead == '#') ADVANCE(1633);
      if (lookahead == '/') ADVANCE(113);
      if (lookahead != 0) ADVANCE(160);
      END_STATE();
    case 114:
      ADVANCE_MAP(
        '#', 325,
        '$', 748,
        '&', 1657,
        '(', 1640,
        ')', 1628,
        ',', 1631,
        '.', 1646,
        '/', 162,
        ':', 1637,
        '<', 1668,
        '@', 1841,
        '[', 1641,
        '`', 189,
        'a', 1197,
        'b', 1400,
        'c', 1419,
        'e', 1158,
        'i', 1391,
        'l', 1162,
        'p', 1169,
        'r', 1279,
        's', 1408,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(114);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_1, 802, lookahead)) ADVANCE(1542);
      END_STATE();
    case 115:
      ADVANCE_MAP(
        '#', 325,
        '$', 748,
        '&', 1657,
        '(', 1640,
        ',', 1631,
        '.', 1643,
        '/', 162,
        ':', 1637,
        '<', 1668,
        '?', 1651,
        '@', 1841,
        '[', 1641,
        '`', 189,
        'a', 1197,
        'b', 1400,
        'c', 1154,
        'd', 1306,
        'e', 1158,
        'f', 1180,
        'i', 1370,
        'l', 1162,
        'm', 1515,
        'n', 1409,
        'o', 1424,
        'p', 1166,
        'r', 1230,
        's', 1407,
        'u', 1379,
        'w', 1256,
        '{', 1685,
        '}', 1687,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(115);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_1, 802, lookahead)) ADVANCE(1542);
      END_STATE();
    case 116:
      ADVANCE_MAP(
        '#', 325,
        '$', 748,
        '&', 1657,
        '(', 1640,
        ',', 1631,
        '.', 1643,
        '/', 162,
        ':', 1637,
        '<', 1668,
        '?', 1651,
        '[', 1641,
        '`', 189,
        'a', 1197,
        'b', 1400,
        'c', 1419,
        'e', 1158,
        'i', 1372,
        'l', 1162,
        'p', 1169,
        'r', 1279,
        's', 1408,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(116);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_1, 802, lookahead)) ADVANCE(1542);
      END_STATE();
    case 117:
      ADVANCE_MAP(
        '#', 325,
        '$', 748,
        '&', 1657,
        '(', 1640,
        ',', 1631,
        '.', 1643,
        '/', 162,
        '<', 1668,
        '@', 1841,
        '[', 1641,
        '`', 189,
        'a', 1197,
        'b', 1400,
        'c', 1419,
        'e', 1158,
        'i', 1378,
        'l', 1162,
        'p', 1169,
        'r', 1279,
        's', 1408,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(117);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_1, 802, lookahead)) ADVANCE(1542);
      END_STATE();
    case 118:
      ADVANCE_MAP(
        '#', 325,
        '$', 748,
        '(', 1640,
        ')', 1628,
        '*', 1733,
        ',', 1631,
        '/', 162,
        '0', 1574,
        ':', 1637,
        '<', 1668,
        '@', 1840,
        '`', 189,
        'a', 1201,
        'b', 1400,
        'c', 1419,
        'e', 1158,
        'l', 1162,
        'p', 1169,
        'r', 1279,
        '{', 1685,
        '}', 1687,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(118);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1574);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_1, 802, lookahead)) ADVANCE(1542);
      END_STATE();
    case 119:
      ADVANCE_MAP(
        '#', 325,
        '$', 748,
        '(', 1640,
        ')', 1628,
        '/', 162,
        '@', 1841,
        '[', 1641,
        '_', 1843,
        '`', 189,
        'a', 1197,
        'b', 1400,
        'c', 1419,
        'e', 1158,
        'i', 1391,
        'l', 1162,
        'p', 1169,
        'r', 1279,
        's', 1408,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(119);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_1, 802, lookahead)) ADVANCE(1542);
      END_STATE();
    case 120:
      ADVANCE_MAP(
        '#', 325,
        '$', 748,
        '(', 1640,
        ')', 1628,
        '/', 162,
        '@', 1840,
        '[', 1641,
        '_', 1843,
        '`', 189,
        'a', 1197,
        'b', 1400,
        'c', 1419,
        'e', 1158,
        'l', 1162,
        'p', 1169,
        'r', 1279,
        's', 1408,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(120);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_1, 802, lookahead)) ADVANCE(1542);
      END_STATE();
    case 121:
      ADVANCE_MAP(
        '#', 325,
        '$', 748,
        '(', 1640,
        '/', 162,
        '<', 1668,
        '@', 1841,
        '[', 1641,
        '`', 189,
        'a', 1201,
        'b', 1400,
        'c', 1154,
        'd', 1306,
        'e', 1156,
        'f', 1302,
        'i', 1374,
        'l', 1161,
        'm', 1515,
        'n', 1409,
        'o', 1424,
        'p', 1166,
        'r', 1230,
        's', 1248,
        't', 1536,
        'u', 1379,
        'v', 1164,
        'w', 1256,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(121);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_1, 802, lookahead)) ADVANCE(1542);
      END_STATE();
    case 122:
      ADVANCE_MAP(
        '#', 325,
        '$', 748,
        '(', 1640,
        '/', 162,
        '<', 1668,
        '@', 1841,
        '[', 1641,
        '`', 189,
        'a', 1201,
        'b', 1400,
        'c', 1347,
        'd', 1305,
        'e', 1156,
        'f', 1302,
        'i', 1374,
        'l', 1161,
        'm', 1515,
        'n', 1409,
        'o', 1424,
        'p', 1166,
        'r', 1230,
        's', 1248,
        't', 1536,
        'u', 1379,
        'v', 1164,
        'w', 1255,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(122);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_1, 802, lookahead)) ADVANCE(1542);
      END_STATE();
    case 123:
      ADVANCE_MAP(
        '#', 325,
        '$', 748,
        '(', 1640,
        '/', 162,
        '<', 1668,
        '@', 1840,
        '[', 1641,
        '`', 189,
        'a', 1201,
        'b', 1400,
        'c', 1348,
        'e', 1156,
        'f', 1332,
        'i', 1377,
        'l', 1161,
        'p', 1169,
        'r', 1279,
        's', 1249,
        't', 1536,
        'u', 1379,
        'v', 1164,
        'w', 1256,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(123);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_1, 802, lookahead)) ADVANCE(1542);
      END_STATE();
    case 124:
      ADVANCE_MAP(
        '#', 325,
        '$', 748,
        '(', 1640,
        '/', 162,
        '<', 1668,
        '@', 1840,
        '[', 1641,
        '`', 189,
        'a', 1201,
        'b', 1400,
        'c', 1419,
        'e', 1158,
        'i', 1372,
        'l', 1162,
        'p', 1169,
        'r', 1279,
        's', 1252,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(124);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_1, 802, lookahead)) ADVANCE(1542);
      END_STATE();
    case 125:
      ADVANCE_MAP(
        '#', 325,
        '$', 748,
        '(', 1640,
        '/', 162,
        '_', 1843,
        '`', 189,
        'a', 1200,
        'b', 1400,
        'c', 1155,
        'e', 1158,
        'i', 1460,
        'l', 1161,
        'p', 1169,
        'r', 1279,
        't', 1445,
        'v', 1164,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(125);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_1, 802, lookahead)) ADVANCE(1542);
      END_STATE();
    case 126:
      ADVANCE_MAP(
        '#', 325,
        '$', 748,
        '(', 1640,
        '/', 162,
        '_', 1843,
        '`', 189,
        'a', 1200,
        'b', 1400,
        'c', 1155,
        'e', 1158,
        'i', 1460,
        'l', 1161,
        'p', 1169,
        'r', 1279,
        'v', 1164,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(126);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_1, 802, lookahead)) ADVANCE(1542);
      END_STATE();
    case 127:
      ADVANCE_MAP(
        '#', 325,
        '$', 748,
        '(', 1640,
        '/', 162,
        '_', 1843,
        '`', 189,
        'a', 1201,
        'b', 1400,
        'c', 1155,
        'e', 1158,
        'i', 1460,
        'l', 1161,
        'p', 1169,
        'r', 1279,
        'v', 1164,
        '{', 1685,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(127);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_1, 802, lookahead)) ADVANCE(1542);
      END_STATE();
    case 128:
      ADVANCE_MAP(
        '#', 325,
        '$', 748,
        ')', 1628,
        ',', 1631,
        '/', 162,
        ']', 1642,
        '`', 189,
        'a', 1201,
        'b', 1400,
        'c', 1419,
        'e', 1158,
        'i', 1286,
        'l', 1162,
        'p', 1169,
        'r', 1279,
        's', 1527,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(128);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_1, 802, lookahead)) ADVANCE(1542);
      END_STATE();
    case 129:
      ADVANCE_MAP(
        '#', 325,
        '$', 748,
        ',', 1631,
        '/', 162,
        ':', 1637,
        '`', 189,
        'a', 1201,
        'b', 1400,
        'c', 1419,
        'e', 1158,
        'i', 1372,
        'l', 1162,
        'p', 1169,
        'r', 1279,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(129);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_1, 802, lookahead)) ADVANCE(1542);
      END_STATE();
    case 130:
      ADVANCE_MAP(
        '#', 325,
        '$', 748,
        '/', 162,
        '@', 1841,
        '`', 189,
        'a', 1199,
        'b', 1400,
        'c', 1154,
        'd', 1229,
        'e', 1156,
        'f', 1302,
        'i', 1360,
        'l', 1161,
        'm', 1515,
        'n', 1409,
        'o', 1424,
        'p', 1167,
        'r', 1230,
        's', 1474,
        't', 1536,
        'u', 1379,
        'v', 1164,
        'w', 1256,
        '{', 752,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(130);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_1, 802, lookahead)) ADVANCE(1542);
      END_STATE();
    case 131:
      ADVANCE_MAP(
        '#', 325,
        '$', 748,
        '/', 162,
        '@', 1841,
        '`', 189,
        'a', 1199,
        'b', 1400,
        'c', 1347,
        'd', 1229,
        'e', 1156,
        'f', 1302,
        'i', 1360,
        'l', 1161,
        'm', 1515,
        'n', 1409,
        'o', 1424,
        'p', 1167,
        'r', 1230,
        's', 1474,
        't', 1536,
        'u', 1379,
        'v', 1164,
        'w', 1256,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(131);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_1, 802, lookahead)) ADVANCE(1542);
      END_STATE();
    case 132:
      ADVANCE_MAP(
        '#', 325,
        '$', 748,
        '/', 162,
        '@', 1841,
        '`', 189,
        'a', 1199,
        'b', 1400,
        'c', 1347,
        'd', 1306,
        'e', 1156,
        'f', 1302,
        'i', 1360,
        'l', 1161,
        'm', 1182,
        'n', 1409,
        'o', 1424,
        'p', 1167,
        'r', 1230,
        's', 1475,
        't', 1536,
        'u', 1379,
        'v', 1164,
        'w', 1256,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(132);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_1, 802, lookahead)) ADVANCE(1542);
      END_STATE();
    case 133:
      ADVANCE_MAP(
        '#', 325,
        '$', 748,
        '/', 162,
        '@', 1841,
        '`', 189,
        'a', 1201,
        'b', 1400,
        'c', 1154,
        'd', 1306,
        'e', 1158,
        'f', 1303,
        'i', 1370,
        'l', 1162,
        'm', 1515,
        'n', 1409,
        'o', 1424,
        'p', 1166,
        'r', 1230,
        's', 1506,
        'u', 1379,
        'w', 1256,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(133);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_1, 802, lookahead)) ADVANCE(1542);
      END_STATE();
    case 134:
      ADVANCE_MAP(
        '#', 325,
        '$', 748,
        '/', 162,
        '@', 1841,
        '`', 189,
        'a', 1201,
        'b', 1400,
        'c', 1347,
        'd', 1305,
        'e', 1158,
        'f', 1303,
        'i', 1370,
        'l', 1162,
        'm', 1515,
        'n', 1409,
        'o', 1424,
        'p', 1166,
        'r', 1230,
        's', 1506,
        'u', 1379,
        'w', 1255,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(134);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_1, 802, lookahead)) ADVANCE(1542);
      END_STATE();
    case 135:
      ADVANCE_MAP(
        '#', 325,
        '$', 748,
        '/', 162,
        'P', 1459,
        'T', 1539,
        '`', 189,
        'a', 1201,
        'b', 1400,
        'c', 1419,
        'e', 1158,
        'l', 1162,
        'p', 1169,
        'r', 1279,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(135);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_1, 802, lookahead)) ADVANCE(1542);
      END_STATE();
    case 136:
      ADVANCE_MAP(
        '#', 325,
        '$', 748,
        '/', 162,
        '`', 189,
        'a', 1201,
        'b', 1400,
        'c', 1348,
        'e', 1157,
        'f', 1514,
        'l', 1161,
        'p', 1168,
        'r', 1279,
        's', 1494,
        't', 1536,
        'v', 1164,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(136);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_1, 802, lookahead)) ADVANCE(1542);
      END_STATE();
    case 137:
      ADVANCE_MAP(
        '#', 325,
        '$', 748,
        '/', 162,
        '`', 189,
        'a', 1201,
        'b', 1400,
        'c', 1419,
        'e', 1158,
        'f', 1514,
        'i', 1399,
        'l', 1162,
        'p', 1169,
        'r', 1279,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(137);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_1, 802, lookahead)) ADVANCE(1542);
      END_STATE();
    case 138:
      ADVANCE_MAP(
        '#', 325,
        '$', 748,
        '/', 162,
        '`', 189,
        'a', 1201,
        'b', 1400,
        'c', 1419,
        'e', 1158,
        'f', 1160,
        'l', 1162,
        'p', 1169,
        'r', 1279,
        't', 1447,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(138);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_1, 802, lookahead)) ADVANCE(1542);
      END_STATE();
    case 139:
      ADVANCE_MAP(
        '#', 325,
        '$', 748,
        '/', 162,
        '`', 189,
        'a', 1201,
        'b', 1400,
        'c', 1419,
        'e', 1158,
        'l', 1161,
        'p', 1169,
        'r', 1279,
        'v', 1164,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(139);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_1, 802, lookahead)) ADVANCE(1542);
      END_STATE();
    case 140:
      ADVANCE_MAP(
        '#', 325,
        '$', 748,
        '/', 162,
        '`', 189,
        'a', 1201,
        'b', 1400,
        'c', 1419,
        'e', 1158,
        'l', 1162,
        'p', 1169,
        'r', 1279,
        's', 1252,
        'u', 1379,
        'w', 1256,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(140);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_1, 802, lookahead)) ADVANCE(1542);
      END_STATE();
    case 141:
      ADVANCE_MAP(
        '#', 325,
        '&', 1657,
        '(', 1640,
        ')', 1628,
        ',', 1631,
        '.', 1643,
        '/', 162,
        ':', 1637,
        '<', 1668,
        '>', 1670,
        '?', 1651,
        ']', 1642,
        '^', 742,
        'i', 513,
        'u', 1624,
        '{', 1685,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(141);
      END_STATE();
    case 142:
      ADVANCE_MAP(
        '#', 325,
        '&', 1657,
        '(', 1640,
        ')', 1628,
        ',', 1631,
        '.', 1643,
        '/', 162,
        ':', 1637,
        '<', 1668,
        '?', 1651,
        'i', 513,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(142);
      END_STATE();
    case 143:
      ADVANCE_MAP(
        '#', 325,
        '&', 1657,
        '(', 1640,
        ')', 1628,
        ',', 1631,
        '.', 1646,
        '/', 162,
        '0', 1574,
        ':', 1637,
        ';', 1808,
        '<', 1668,
        '>', 1670,
        '?', 1651,
        '@', 1841,
        'P', 605,
        'T', 732,
        ']', 1642,
        '^', 742,
        '_', 499,
        'a', 252,
        'b', 550,
        'c', 198,
        'd', 372,
        'e', 515,
        'f', 228,
        'g', 363,
        'i', 380,
        'l', 192,
        'm', 195,
        'n', 556,
        'o', 582,
        'p', 216,
        'r', 327,
        's', 364,
        't', 738,
        'u', 534,
        'v', 201,
        'w', 335,
        '{', 1685,
        '}', 1687,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(143);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1574);
      END_STATE();
    case 144:
      ADVANCE_MAP(
        '#', 325,
        '(', 1640,
        '/', 162,
        '<', 1668,
        '@', 1840,
        '_', 499,
        'a', 253,
        'c', 470,
        'e', 515,
        'f', 445,
        'g', 362,
        'i', 539,
        'l', 192,
        'm', 706,
        'n', 575,
        's', 365,
        't', 738,
        'u', 534,
        'v', 201,
        'w', 334,
        '{', 1685,
        '}', 1687,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(144);
      END_STATE();
    case 145:
      if (lookahead == '#') ADVANCE(145);
      if (lookahead == '(') ADVANCE(1629);
      END_STATE();
    case 146:
      if (lookahead == '#') ADVANCE(1635);
      if (lookahead == '/') ADVANCE(806);
      if (lookahead != 0) ADVANCE(33);
      END_STATE();
    case 147:
      if (lookahead == '#') ADVANCE(1635);
      if (lookahead != 0) ADVANCE(33);
      END_STATE();
    case 148:
      if (lookahead == ')') ADVANCE(1903);
      END_STATE();
    case 149:
      if (lookahead == ')') ADVANCE(1904);
      END_STATE();
    case 150:
      if (lookahead == '.') ADVANCE(153);
      END_STATE();
    case 151:
      if (lookahead == '.') ADVANCE(153);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1570);
      END_STATE();
    case 152:
      if (lookahead == '.') ADVANCE(1727);
      END_STATE();
    case 153:
      if (lookahead == '.') ADVANCE(1727);
      if (lookahead == '<') ADVANCE(1728);
      END_STATE();
    case 154:
      ADVANCE_MAP(
        '/', 1,
        'a', 722,
        'c', 557,
        'd', 639,
        'e', 488,
        'f', 417,
        'i', 382,
        'k', 331,
        'l', 415,
        's', 366,
        'u', 521,
        'w', 205,
      );
      END_STATE();
    case 155:
      ADVANCE_MAP(
        '/', 1,
        'c', 557,
        'd', 639,
        'e', 489,
        'f', 417,
        'i', 382,
        'k', 331,
        'l', 415,
        's', 366,
        'w', 205,
      );
      END_STATE();
    case 156:
      ADVANCE_MAP(
        '/', 1,
        'c', 557,
        'd', 639,
        'e', 488,
        'f', 417,
        'i', 382,
        'k', 331,
        'l', 415,
        's', 366,
        'w', 205,
      );
      END_STATE();
    case 157:
      if (lookahead == '/') ADVANCE(1);
      if (lookahead == 'e') ADVANCE(488);
      if (lookahead == 'i') ADVANCE(381);
      if (lookahead == 's') ADVANCE(554);
      if (lookahead == 'w') ADVANCE(205);
      END_STATE();
    case 158:
      if (lookahead == '/') ADVANCE(809);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(744);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n') ADVANCE(159);
      END_STATE();
    case 159:
      if (lookahead == '/') ADVANCE(1636);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(744);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n') ADVANCE(159);
      END_STATE();
    case 160:
      if (lookahead == '/') ADVANCE(113);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(160);
      END_STATE();
    case 161:
      if (lookahead == '/') ADVANCE(113);
      if (lookahead != 0) ADVANCE(160);
      END_STATE();
    case 162:
      if (lookahead == '/') ADVANCE(810);
      END_STATE();
    case 163:
      if (lookahead == '/') ADVANCE(810);
      if (lookahead == '=') ADVANCE(1720);
      END_STATE();
    case 164:
      if (lookahead == '/') ADVANCE(806);
      if (lookahead != 0 &&
          lookahead != '#') ADVANCE(33);
      END_STATE();
    case 165:
      if (lookahead == '1') ADVANCE(1929);
      if (lookahead == '2') ADVANCE(1930);
      END_STATE();
    case 166:
      if (lookahead == ':') ADVANCE(1665);
      END_STATE();
    case 167:
      if (lookahead == ':') ADVANCE(1666);
      END_STATE();
    case 168:
      if (lookahead == '=') ADVANCE(1721);
      END_STATE();
    case 169:
      if (lookahead == '=') ADVANCE(1719);
      END_STATE();
    case 170:
      if (lookahead == '=') ADVANCE(1717);
      END_STATE();
    case 171:
      if (lookahead == '=') ADVANCE(1718);
      END_STATE();
    case 172:
      if (lookahead == '=') ADVANCE(1724);
      END_STATE();
    case 173:
      if (lookahead == '=') ADVANCE(172);
      END_STATE();
    case 174:
      if (lookahead == 'D') ADVANCE(1676);
      END_STATE();
    case 175:
      if (lookahead == 'L') ADVANCE(577);
      END_STATE();
    case 176:
      if (lookahead == 'L') ADVANCE(450);
      END_STATE();
    case 177:
      if (lookahead == 'L') ADVANCE(451);
      END_STATE();
    case 178:
      if (lookahead == 'M') ADVANCE(239);
      END_STATE();
    case 179:
      if (lookahead == 'P') ADVANCE(223);
      END_STATE();
    case 180:
      if (lookahead == 'S') ADVANCE(354);
      END_STATE();
    case 181:
      if (lookahead == 'S') ADVANCE(359);
      END_STATE();
    case 182:
      if (lookahead == '_') ADVANCE(182);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1573);
      END_STATE();
    case 183:
      if (lookahead == '_') ADVANCE(183);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(1577);
      END_STATE();
    case 184:
      if (lookahead == '_') ADVANCE(184);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(1576);
      END_STATE();
    case 185:
      if (lookahead == '_') ADVANCE(185);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(1575);
      END_STATE();
    case 186:
      if (lookahead == '_') ADVANCE(186);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1570);
      END_STATE();
    case 187:
      if (lookahead == '_') ADVANCE(187);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1571);
      END_STATE();
    case 188:
      if (lookahead == '_') ADVANCE(188);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1574);
      END_STATE();
    case 189:
      if (lookahead == '`') ADVANCE(1544);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ') ADVANCE(189);
      END_STATE();
    case 190:
      if (lookahead == 'a') ADVANCE(254);
      if (lookahead == 'n') ADVANCE(705);
      if (lookahead == 'x') ADVANCE(678);
      END_STATE();
    case 191:
      if (lookahead == 'a') ADVANCE(456);
      if (lookahead == 'i') ADVANCE(473);
      if (lookahead == 'o') ADVANCE(595);
      if (lookahead == 'u') ADVANCE(517);
      END_STATE();
    case 192:
      if (lookahead == 'a') ADVANCE(741);
      if (lookahead == 'e') ADVANCE(658);
      END_STATE();
    case 193:
      if (lookahead == 'a') ADVANCE(256);
      if (lookahead == 'o') ADVANCE(645);
      if (lookahead == 'r') ADVANCE(301);
      if (lookahead == 'u') ADVANCE(245);
      END_STATE();
    case 194:
      if (lookahead == 'a') ADVANCE(395);
      END_STATE();
    case 195:
      if (lookahead == 'a') ADVANCE(277);
      if (lookahead == 'u') ADVANCE(680);
      END_STATE();
    case 196:
      if (lookahead == 'a') ADVANCE(453);
      END_STATE();
    case 197:
      if (lookahead == 'a') ADVANCE(644);
      if (lookahead == 'l') ADVANCE(206);
      if (lookahead == 'o') ADVANCE(503);
      END_STATE();
    case 198:
      if (lookahead == 'a') ADVANCE(644);
      if (lookahead == 'l') ADVANCE(206);
      if (lookahead == 'o') ADVANCE(512);
      END_STATE();
    case 199:
      if (lookahead == 'a') ADVANCE(501);
      END_STATE();
    case 200:
      if (lookahead == 'a') ADVANCE(454);
      END_STATE();
    case 201:
      if (lookahead == 'a') ADVANCE(596);
      END_STATE();
    case 202:
      if (lookahead == 'a') ADVANCE(592);
      END_STATE();
    case 203:
      if (lookahead == 'a') ADVANCE(493);
      END_STATE();
    case 204:
      if (lookahead == 'a') ADVANCE(386);
      END_STATE();
    case 205:
      if (lookahead == 'a') ADVANCE(611);
      END_STATE();
    case 206:
      if (lookahead == 'a') ADVANCE(642);
      END_STATE();
    case 207:
      if (lookahead == 'a') ADVANCE(606);
      END_STATE();
    case 208:
      if (lookahead == 'a') ADVANCE(494);
      END_STATE();
    case 209:
      if (lookahead == 'a') ADVANCE(691);
      if (lookahead == 'r') ADVANCE(716);
      END_STATE();
    case 210:
      if (lookahead == 'a') ADVANCE(460);
      END_STATE();
    case 211:
      if (lookahead == 'a') ADVANCE(638);
      END_STATE();
    case 212:
      if (lookahead == 'a') ADVANCE(525);
      END_STATE();
    case 213:
      if (lookahead == 'a') ADVANCE(693);
      END_STATE();
    case 214:
      if (lookahead == 'a') ADVANCE(462);
      END_STATE();
    case 215:
      if (lookahead == 'a') ADVANCE(463);
      END_STATE();
    case 216:
      if (lookahead == 'a') ADVANCE(255);
      if (lookahead == 'o') ADVANCE(645);
      if (lookahead == 'r') ADVANCE(302);
      if (lookahead == 'u') ADVANCE(245);
      END_STATE();
    case 217:
      if (lookahead == 'a') ADVANCE(465);
      END_STATE();
    case 218:
      if (lookahead == 'a') ADVANCE(466);
      END_STATE();
    case 219:
      if (lookahead == 'a') ADVANCE(622);
      END_STATE();
    case 220:
      if (lookahead == 'a') ADVANCE(664);
      END_STATE();
    case 221:
      if (lookahead == 'a') ADVANCE(467);
      END_STATE();
    case 222:
      if (lookahead == 'a') ADVANCE(468);
      END_STATE();
    case 223:
      if (lookahead == 'a') ADVANCE(676);
      END_STATE();
    case 224:
      if (lookahead == 'a') ADVANCE(677);
      END_STATE();
    case 225:
      if (lookahead == 'a') ADVANCE(249);
      END_STATE();
    case 226:
      if (lookahead == 'a') ADVANCE(396);
      END_STATE();
    case 227:
      if (lookahead == 'a') ADVANCE(426);
      END_STATE();
    case 228:
      if (lookahead == 'a') ADVANCE(482);
      if (lookahead == 'i') ADVANCE(473);
      if (lookahead == 'o') ADVANCE(595);
      if (lookahead == 'u') ADVANCE(517);
      END_STATE();
    case 229:
      if (lookahead == 'a') ADVANCE(482);
      if (lookahead == 'i') ADVANCE(473);
      if (lookahead == 'u') ADVANCE(517);
      END_STATE();
    case 230:
      if (lookahead == 'a') ADVANCE(427);
      END_STATE();
    case 231:
      if (lookahead == 'a') ADVANCE(387);
      END_STATE();
    case 232:
      if (lookahead == 'a') ADVANCE(481);
      END_STATE();
    case 233:
      if (lookahead == 'a') ADVANCE(682);
      END_STATE();
    case 234:
      if (lookahead == 'a') ADVANCE(683);
      END_STATE();
    case 235:
      if (lookahead == 'a') ADVANCE(684);
      END_STATE();
    case 236:
      if (lookahead == 'a') ADVANCE(686);
      END_STATE();
    case 237:
      if (lookahead == 'a') ADVANCE(687);
      END_STATE();
    case 238:
      if (lookahead == 'a') ADVANCE(694);
      END_STATE();
    case 239:
      if (lookahead == 'a') ADVANCE(279);
      END_STATE();
    case 240:
      if (lookahead == 'a') ADVANCE(697);
      END_STATE();
    case 241:
      if (lookahead == 'a') ADVANCE(695);
      END_STATE();
    case 242:
      if (lookahead == 'a') ADVANCE(250);
      END_STATE();
    case 243:
      if (lookahead == 'a') ADVANCE(452);
      END_STATE();
    case 244:
      if (lookahead == 'a') ADVANCE(725);
      END_STATE();
    case 245:
      if (lookahead == 'b') ADVANCE(474);
      END_STATE();
    case 246:
      if (lookahead == 'b') ADVANCE(646);
      END_STATE();
    case 247:
      if (lookahead == 'b') ADVANCE(646);
      if (lookahead == 'p') ADVANCE(352);
      END_STATE();
    case 248:
      if (lookahead == 'b') ADVANCE(718);
      END_STATE();
    case 249:
      if (lookahead == 'b') ADVANCE(484);
      END_STATE();
    case 250:
      if (lookahead == 'b') ADVANCE(486);
      END_STATE();
    case 251:
      if (lookahead == 'c') ADVANCE(674);
      if (lookahead == 'n') ADVANCE(733);
      if (lookahead == 's') ADVANCE(641);
      if (lookahead == 'w') ADVANCE(227);
      END_STATE();
    case 252:
      if (lookahead == 'c') ADVANCE(674);
      if (lookahead == 's') ADVANCE(641);
      END_STATE();
    case 253:
      if (lookahead == 'c') ADVANCE(674);
      if (lookahead == 's') ADVANCE(740);
      END_STATE();
    case 254:
      if (lookahead == 'c') ADVANCE(399);
      END_STATE();
    case 255:
      if (lookahead == 'c') ADVANCE(455);
      END_STATE();
    case 256:
      if (lookahead == 'c') ADVANCE(455);
      if (lookahead == 'r') ADVANCE(203);
      END_STATE();
    case 257:
      if (lookahead == 'c') ADVANCE(1787);
      END_STATE();
    case 258:
      if (lookahead == 'c') ADVANCE(1552);
      END_STATE();
    case 259:
      if (lookahead == 'c') ADVANCE(1856);
      END_STATE();
    case 260:
      if (lookahead == 'c') ADVANCE(1877);
      END_STATE();
    case 261:
      if (lookahead == 'c') ADVANCE(1880);
      END_STATE();
    case 262:
      if (lookahead == 'c') ADVANCE(400);
      END_STATE();
    case 263:
      if (lookahead == 'c') ADVANCE(349);
      if (lookahead == 'p') ADVANCE(367);
      if (lookahead == 'q') ADVANCE(719);
      if (lookahead == 't') ADVANCE(715);
      END_STATE();
    case 264:
      if (lookahead == 'c') ADVANCE(475);
      END_STATE();
    case 265:
      if (lookahead == 'c') ADVANCE(202);
      END_STATE();
    case 266:
      if (lookahead == 'c') ADVANCE(449);
      END_STATE();
    case 267:
      if (lookahead == 'c') ADVANCE(690);
      END_STATE();
    case 268:
      if (lookahead == 'c') ADVANCE(665);
      END_STATE();
    case 269:
      if (lookahead == 'c') ADVANCE(336);
      if (lookahead == 'f') ADVANCE(411);
      END_STATE();
    case 270:
      if (lookahead == 'c') ADVANCE(667);
      END_STATE();
    case 271:
      if (lookahead == 'c') ADVANCE(329);
      END_STATE();
    case 272:
      if (lookahead == 'c') ADVANCE(348);
      END_STATE();
    case 273:
      if (lookahead == 'c') ADVANCE(319);
      END_STATE();
    case 274:
      if (lookahead == 'c') ADVANCE(566);
      END_STATE();
    case 275:
      if (lookahead == 'c') ADVANCE(568);
      END_STATE();
    case 276:
      if (lookahead == 'c') ADVANCE(623);
      END_STATE();
    case 277:
      if (lookahead == 'c') ADVANCE(612);
      END_STATE();
    case 278:
      if (lookahead == 'c') ADVANCE(241);
      END_STATE();
    case 279:
      if (lookahead == 'c') ADVANCE(619);
      END_STATE();
    case 280:
      if (lookahead == 'c') ADVANCE(696);
      END_STATE();
    case 281:
      if (lookahead == 'd') ADVANCE(180);
      if (lookahead == 's') ADVANCE(679);
      END_STATE();
    case 282:
      if (lookahead == 'd') ADVANCE(1703);
      END_STATE();
    case 283:
      if (lookahead == 'd') ADVANCE(1759);
      END_STATE();
    case 284:
      if (lookahead == 'd') ADVANCE(165);
      END_STATE();
    case 285:
      if (lookahead == 'd') ADVANCE(1900);
      END_STATE();
    case 286:
      if (lookahead == 'd') ADVANCE(1850);
      END_STATE();
    case 287:
      if (lookahead == 'd') ADVANCE(1886);
      END_STATE();
    case 288:
      if (lookahead == 'd') ADVANCE(1853);
      END_STATE();
    case 289:
      if (lookahead == 'd') ADVANCE(428);
      END_STATE();
    case 290:
      if (lookahead == 'd') ADVANCE(428);
      if (lookahead == 'f') ADVANCE(407);
      if (lookahead == 'i') ADVANCE(669);
      if (lookahead == 'o') ADVANCE(711);
      if (lookahead == 't') ADVANCE(351);
      END_STATE();
    case 291:
      if (lookahead == 'd') ADVANCE(412);
      END_STATE();
    case 292:
      if (lookahead == 'd') ADVANCE(418);
      END_STATE();
    case 293:
      if (lookahead == 'd') ADVANCE(699);
      END_STATE();
    case 294:
      if (lookahead == 'd') ADVANCE(370);
      END_STATE();
    case 295:
      if (lookahead == 'd') ADVANCE(316);
      END_STATE();
    case 296:
      if (lookahead == 'd') ADVANCE(485);
      END_STATE();
    case 297:
      if (lookahead == 'e') ADVANCE(420);
      if (lookahead == 'i') ADVANCE(281);
      if (lookahead == 'o') ADVANCE(1711);
      if (lookahead == 'y') ADVANCE(527);
      END_STATE();
    case 298:
      if (lookahead == 'e') ADVANCE(263);
      END_STATE();
    case 299:
      if (lookahead == 'e') ADVANCE(459);
      if (lookahead == 'o') ADVANCE(497);
      if (lookahead == 't') ADVANCE(209);
      if (lookahead == 'u') ADVANCE(247);
      if (lookahead == 'w') ADVANCE(424);
      END_STATE();
    case 300:
      if (lookahead == 'e') ADVANCE(506);
      if (lookahead == 't') ADVANCE(422);
      END_STATE();
    case 301:
      if (lookahead == 'e') ADVANCE(269);
      if (lookahead == 'i') ADVANCE(721);
      if (lookahead == 'o') ADVANCE(593);
      END_STATE();
    case 302:
      if (lookahead == 'e') ADVANCE(269);
      if (lookahead == 'i') ADVANCE(721);
      if (lookahead == 'o') ADVANCE(701);
      END_STATE();
    case 303:
      if (lookahead == 'e') ADVANCE(1647);
      END_STATE();
    case 304:
      if (lookahead == 'e') ADVANCE(1705);
      END_STATE();
    case 305:
      if (lookahead == 'e') ADVANCE(1653);
      END_STATE();
    case 306:
      if (lookahead == 'e') ADVANCE(1578);
      END_STATE();
    case 307:
      if (lookahead == 'e') ADVANCE(1923);
      END_STATE();
    case 308:
      if (lookahead == 'e') ADVANCE(1675);
      END_STATE();
    case 309:
      if (lookahead == 'e') ADVANCE(1678);
      END_STATE();
    case 310:
      if (lookahead == 'e') ADVANCE(1581);
      END_STATE();
    case 311:
      if (lookahead == 'e') ADVANCE(1749);
      END_STATE();
    case 312:
      if (lookahead == 'e') ADVANCE(1564);
      END_STATE();
    case 313:
      if (lookahead == 'e') ADVANCE(1859);
      END_STATE();
    case 314:
      if (lookahead == 'e') ADVANCE(1755);
      END_STATE();
    case 315:
      if (lookahead == 'e') ADVANCE(1915);
      END_STATE();
    case 316:
      if (lookahead == 'e') ADVANCE(1844);
      END_STATE();
    case 317:
      if (lookahead == 'e') ADVANCE(1761);
      END_STATE();
    case 318:
      if (lookahead == 'e') ADVANCE(1681);
      END_STATE();
    case 319:
      if (lookahead == 'e') ADVANCE(1847);
      END_STATE();
    case 320:
      if (lookahead == 'e') ADVANCE(1865);
      END_STATE();
    case 321:
      if (lookahead == 'e') ADVANCE(1762);
      END_STATE();
    case 322:
      if (lookahead == 'e') ADVANCE(1896);
      END_STATE();
    case 323:
      if (lookahead == 'e') ADVANCE(148);
      END_STATE();
    case 324:
      if (lookahead == 'e') ADVANCE(1837);
      END_STATE();
    case 325:
      if (lookahead == 'e') ADVANCE(488);
      if (lookahead == 'i') ADVANCE(381);
      if (lookahead == 's') ADVANCE(554);
      if (lookahead == 'w') ADVANCE(205);
      END_STATE();
    case 326:
      if (lookahead == 'e') ADVANCE(594);
      END_STATE();
    case 327:
      if (lookahead == 'e') ADVANCE(588);
      END_STATE();
    case 328:
      if (lookahead == 'e') ADVANCE(398);
      END_STATE();
    case 329:
      if (lookahead == 'e') ADVANCE(175);
      END_STATE();
    case 330:
      if (lookahead == 'e') ADVANCE(149);
      END_STATE();
    case 331:
      if (lookahead == 'e') ADVANCE(734);
      END_STATE();
    case 332:
      if (lookahead == 'e') ADVANCE(591);
      END_STATE();
    case 333:
      if (lookahead == 'e') ADVANCE(657);
      if (lookahead == 'u') ADVANCE(207);
      END_STATE();
    case 334:
      if (lookahead == 'e') ADVANCE(196);
      END_STATE();
    case 335:
      if (lookahead == 'e') ADVANCE(196);
      if (lookahead == 'h') ADVANCE(443);
      if (lookahead == 'i') ADVANCE(472);
      END_STATE();
    case 336:
      if (lookahead == 'e') ADVANCE(294);
      END_STATE();
    case 337:
      if (lookahead == 'e') ADVANCE(284);
      END_STATE();
    case 338:
      if (lookahead == 'e') ADVANCE(285);
      END_STATE();
    case 339:
      if (lookahead == 'e') ADVANCE(628);
      END_STATE();
    case 340:
      if (lookahead == 'e') ADVANCE(200);
      END_STATE();
    case 341:
      if (lookahead == 'e') ADVANCE(528);
      END_STATE();
    case 342:
      if (lookahead == 'e') ADVANCE(471);
      END_STATE();
    case 343:
      if (lookahead == 'e') ADVANCE(286);
      END_STATE();
    case 344:
      if (lookahead == 'e') ADVANCE(280);
      END_STATE();
    case 345:
      if (lookahead == 'e') ADVANCE(293);
      END_STATE();
    case 346:
      if (lookahead == 'e') ADVANCE(536);
      END_STATE();
    case 347:
      if (lookahead == 'e') ADVANCE(287);
      END_STATE();
    case 348:
      if (lookahead == 'e') ADVANCE(397);
      END_STATE();
    case 349:
      if (lookahead == 'e') ADVANCE(408);
      END_STATE();
    case 350:
      if (lookahead == 'e') ADVANCE(288);
      END_STATE();
    case 351:
      if (lookahead == 'e') ADVANCE(629);
      END_STATE();
    case 352:
      if (lookahead == 'e') ADVANCE(598);
      END_STATE();
    case 353:
      if (lookahead == 'e') ADVANCE(232);
      END_STATE();
    case 354:
      if (lookahead == 'e') ADVANCE(662);
      END_STATE();
    case 355:
      if (lookahead == 'e') ADVANCE(601);
      END_STATE();
    case 356:
      if (lookahead == 'e') ADVANCE(607);
      END_STATE();
    case 357:
      if (lookahead == 'e') ADVANCE(458);
      if (lookahead == 't') ADVANCE(209);
      if (lookahead == 'u') ADVANCE(246);
      END_STATE();
    case 358:
      if (lookahead == 'e') ADVANCE(603);
      END_STATE();
    case 359:
      if (lookahead == 'e') ADVANCE(666);
      END_STATE();
    case 360:
      if (lookahead == 'e') ADVANCE(633);
      END_STATE();
    case 361:
      if (lookahead == 'e') ADVANCE(505);
      if (lookahead == 't') ADVANCE(422);
      END_STATE();
    case 362:
      if (lookahead == 'e') ADVANCE(670);
      END_STATE();
    case 363:
      if (lookahead == 'e') ADVANCE(670);
      if (lookahead == 'u') ADVANCE(207);
      END_STATE();
    case 364:
      if (lookahead == 'e') ADVANCE(671);
      if (lookahead == 't') ADVANCE(209);
      if (lookahead == 'u') ADVANCE(246);
      if (lookahead == 'w') ADVANCE(424);
      END_STATE();
    case 365:
      if (lookahead == 'e') ADVANCE(671);
      if (lookahead == 't') ADVANCE(608);
      END_STATE();
    case 366:
      if (lookahead == 'e') ADVANCE(479);
      if (lookahead == 'o') ADVANCE(709);
      END_STATE();
    case 367:
      if (lookahead == 'e') ADVANCE(220);
      END_STATE();
    case 368:
      if (lookahead == 'e') ADVANCE(624);
      END_STATE();
    case 369:
      if (lookahead == 'e') ADVANCE(270);
      END_STATE();
    case 370:
      if (lookahead == 'e') ADVANCE(538);
      END_STATE();
    case 371:
      if (lookahead == 'e') ADVANCE(544);
      END_STATE();
    case 372:
      if (lookahead == 'e') ADVANCE(419);
      if (lookahead == 'i') ADVANCE(281);
      if (lookahead == 'o') ADVANCE(1711);
      if (lookahead == 'y') ADVANCE(527);
      END_STATE();
    case 373:
      if (lookahead == 'e') ADVANCE(419);
      if (lookahead == 'i') ADVANCE(281);
      if (lookahead == 'y') ADVANCE(527);
      END_STATE();
    case 374:
      if (lookahead == 'e') ADVANCE(419);
      if (lookahead == 'i') ADVANCE(643);
      if (lookahead == 'y') ADVANCE(527);
      END_STATE();
    case 375:
      if (lookahead == 'e') ADVANCE(632);
      END_STATE();
    case 376:
      if (lookahead == 'e') ADVANCE(634);
      END_STATE();
    case 377:
      if (lookahead == 'e') ADVANCE(635);
      END_STATE();
    case 378:
      if (lookahead == 'e') ADVANCE(177);
      END_STATE();
    case 379:
      if (lookahead == 'f') ADVANCE(1658);
      if (lookahead == 'm') ADVANCE(589);
      if (lookahead == 'n') ADVANCE(1693);
      if (lookahead == 's') ADVANCE(1729);
      END_STATE();
    case 380:
      if (lookahead == 'f') ADVANCE(1658);
      if (lookahead == 'm') ADVANCE(589);
      if (lookahead == 'n') ADVANCE(290);
      END_STATE();
    case 381:
      if (lookahead == 'f') ADVANCE(1925);
      END_STATE();
    case 382:
      if (lookahead == 'f') ADVANCE(1925);
      if (lookahead == 'm') ADVANCE(194);
      END_STATE();
    case 383:
      if (lookahead == 'f') ADVANCE(1697);
      END_STATE();
    case 384:
      if (lookahead == 'f') ADVANCE(737);
      END_STATE();
    case 385:
      if (lookahead == 'f') ADVANCE(413);
      END_STATE();
    case 386:
      if (lookahead == 'f') ADVANCE(323);
      END_STATE();
    case 387:
      if (lookahead == 'f') ADVANCE(330);
      END_STATE();
    case 388:
      if (lookahead == 'g') ADVANCE(1928);
      END_STATE();
    case 389:
      if (lookahead == 'g') ADVANCE(1871);
      END_STATE();
    case 390:
      if (lookahead == 'g') ADVANCE(1895);
      END_STATE();
    case 391:
      if (lookahead == 'g') ADVANCE(1905);
      END_STATE();
    case 392:
      if (lookahead == 'g') ADVANCE(1908);
      END_STATE();
    case 393:
      if (lookahead == 'g') ADVANCE(1874);
      END_STATE();
    case 394:
      if (lookahead == 'g') ADVANCE(403);
      END_STATE();
    case 395:
      if (lookahead == 'g') ADVANCE(378);
      END_STATE();
    case 396:
      if (lookahead == 'g') ADVANCE(312);
      END_STATE();
    case 397:
      if (lookahead == 'g') ADVANCE(618);
      END_STATE();
    case 398:
      if (lookahead == 'g') ADVANCE(234);
      END_STATE();
    case 399:
      if (lookahead == 'h') ADVANCE(1555);
      END_STATE();
    case 400:
      if (lookahead == 'h') ADVANCE(1661);
      END_STATE();
    case 401:
      if (lookahead == 'h') ADVANCE(1713);
      END_STATE();
    case 402:
      if (lookahead == 'h') ADVANCE(1677);
      END_STATE();
    case 403:
      if (lookahead == 'h') ADVANCE(1708);
      END_STATE();
    case 404:
      if (lookahead == 'h') ADVANCE(212);
      END_STATE();
    case 405:
      if (lookahead == 'h') ADVANCE(609);
      if (lookahead == 'r') ADVANCE(712);
      if (lookahead == 'y') ADVANCE(590);
      END_STATE();
    case 406:
      if (lookahead == 'h') ADVANCE(615);
      END_STATE();
    case 407:
      if (lookahead == 'i') ADVANCE(729);
      END_STATE();
    case 408:
      if (lookahead == 'i') ADVANCE(723);
      END_STATE();
    case 409:
      if (lookahead == 'i') ADVANCE(457);
      if (lookahead == 'o') ADVANCE(504);
      END_STATE();
    case 410:
      if (lookahead == 'i') ADVANCE(248);
      END_STATE();
    case 411:
      if (lookahead == 'i') ADVANCE(730);
      END_STATE();
    case 412:
      if (lookahead == 'i') ADVANCE(381);
      END_STATE();
    case 413:
      if (lookahead == 'i') ADVANCE(731);
      END_STATE();
    case 414:
      if (lookahead == 'i') ADVANCE(342);
      END_STATE();
    case 415:
      if (lookahead == 'i') ADVANCE(533);
      END_STATE();
    case 416:
      if (lookahead == 'i') ADVANCE(586);
      END_STATE();
    case 417:
      if (lookahead == 'i') ADVANCE(478);
      if (lookahead == 'u') ADVANCE(519);
      END_STATE();
    case 418:
      if (lookahead == 'i') ADVANCE(384);
      END_STATE();
    case 419:
      if (lookahead == 'i') ADVANCE(542);
      END_STATE();
    case 420:
      if (lookahead == 'i') ADVANCE(542);
      if (lookahead == 'l') ADVANCE(328);
      END_STATE();
    case 421:
      if (lookahead == 'i') ADVANCE(650);
      if (lookahead == 'm') ADVANCE(720);
      END_STATE();
    case 422:
      if (lookahead == 'i') ADVANCE(579);
      END_STATE();
    case 423:
      if (lookahead == 'i') ADVANCE(522);
      END_STATE();
    case 424:
      if (lookahead == 'i') ADVANCE(688);
      END_STATE();
    case 425:
      if (lookahead == 'i') ADVANCE(570);
      END_STATE();
    case 426:
      if (lookahead == 'i') ADVANCE(659);
      END_STATE();
    case 427:
      if (lookahead == 'i') ADVANCE(480);
      END_STATE();
    case 428:
      if (lookahead == 'i') ADVANCE(625);
      END_STATE();
    case 429:
      if (lookahead == 'i') ADVANCE(259);
      END_STATE();
    case 430:
      if (lookahead == 'i') ADVANCE(516);
      END_STATE();
    case 431:
      if (lookahead == 'i') ADVANCE(260);
      END_STATE();
    case 432:
      if (lookahead == 'i') ADVANCE(518);
      END_STATE();
    case 433:
      if (lookahead == 'i') ADVANCE(661);
      END_STATE();
    case 434:
      if (lookahead == 'i') ADVANCE(261);
      END_STATE();
    case 435:
      if (lookahead == 'i') ADVANCE(520);
      END_STATE();
    case 436:
      if (lookahead == 'i') ADVANCE(523);
      END_STATE();
    case 437:
      if (lookahead == 'i') ADVANCE(526);
      END_STATE();
    case 438:
      if (lookahead == 'i') ADVANCE(531);
      END_STATE();
    case 439:
      if (lookahead == 'i') ADVANCE(211);
      END_STATE();
    case 440:
      if (lookahead == 'i') ADVANCE(295);
      END_STATE();
    case 441:
      if (lookahead == 'i') ADVANCE(572);
      END_STATE();
    case 442:
      if (lookahead == 'i') ADVANCE(626);
      END_STATE();
    case 443:
      if (lookahead == 'i') ADVANCE(483);
      END_STATE();
    case 444:
      if (lookahead == 'i') ADVANCE(574);
      END_STATE();
    case 445:
      if (lookahead == 'i') ADVANCE(529);
      if (lookahead == 'u') ADVANCE(517);
      END_STATE();
    case 446:
      if (lookahead == 'i') ADVANCE(371);
      END_STATE();
    case 447:
      if (lookahead == 'i') ADVANCE(724);
      END_STATE();
    case 448:
      if (lookahead == 'i') ADVANCE(698);
      END_STATE();
    case 449:
      if (lookahead == 'i') ADVANCE(235);
      END_STATE();
    case 450:
      if (lookahead == 'i') ADVANCE(702);
      END_STATE();
    case 451:
      if (lookahead == 'i') ADVANCE(703);
      END_STATE();
    case 452:
      if (lookahead == 'i') ADVANCE(491);
      END_STATE();
    case 453:
      if (lookahead == 'k') ADVANCE(1897);
      END_STATE();
    case 454:
      if (lookahead == 'k') ADVANCE(1757);
      END_STATE();
    case 455:
      if (lookahead == 'k') ADVANCE(226);
      END_STATE();
    case 456:
      if (lookahead == 'l') ADVANCE(477);
      END_STATE();
    case 457:
      if (lookahead == 'l') ADVANCE(1567);
      END_STATE();
    case 458:
      if (lookahead == 'l') ADVANCE(383);
      END_STATE();
    case 459:
      if (lookahead == 'l') ADVANCE(383);
      if (lookahead == 't') ADVANCE(1821);
      END_STATE();
    case 460:
      if (lookahead == 'l') ADVANCE(1889);
      END_STATE();
    case 461:
      if (lookahead == 'l') ADVANCE(1649);
      END_STATE();
    case 462:
      if (lookahead == 'l') ADVANCE(1862);
      END_STATE();
    case 463:
      if (lookahead == 'l') ADVANCE(1883);
      END_STATE();
    case 464:
      if (lookahead == 'l') ADVANCE(1778);
      END_STATE();
    case 465:
      if (lookahead == 'l') ADVANCE(178);
      END_STATE();
    case 466:
      if (lookahead == 'l') ADVANCE(1683);
      END_STATE();
    case 467:
      if (lookahead == 'l') ADVANCE(1682);
      END_STATE();
    case 468:
      if (lookahead == 'l') ADVANCE(1684);
      END_STATE();
    case 469:
      if (lookahead == 'l') ADVANCE(567);
      END_STATE();
    case 470:
      if (lookahead == 'l') ADVANCE(206);
      END_STATE();
    case 471:
      if (lookahead == 'l') ADVANCE(283);
      END_STATE();
    case 472:
      if (lookahead == 'l') ADVANCE(487);
      END_STATE();
    case 473:
      if (lookahead == 'l') ADVANCE(332);
      if (lookahead == 'n') ADVANCE(210);
      END_STATE();
    case 474:
      if (lookahead == 'l') ADVANCE(429);
      END_STATE();
    case 475:
      if (lookahead == 'l') ADVANCE(562);
      END_STATE();
    case 476:
      if (lookahead == 'l') ADVANCE(673);
      END_STATE();
    case 477:
      if (lookahead == 'l') ADVANCE(673);
      if (lookahead == 's') ADVANCE(310);
      END_STATE();
    case 478:
      if (lookahead == 'l') ADVANCE(308);
      END_STATE();
    case 479:
      if (lookahead == 'l') ADVANCE(344);
      END_STATE();
    case 480:
      if (lookahead == 'l') ADVANCE(225);
      END_STATE();
    case 481:
      if (lookahead == 'l') ADVANCE(439);
      END_STATE();
    case 482:
      if (lookahead == 'l') ADVANCE(476);
      END_STATE();
    case 483:
      if (lookahead == 'l') ADVANCE(311);
      END_STATE();
    case 484:
      if (lookahead == 'l') ADVANCE(317);
      END_STATE();
    case 485:
      if (lookahead == 'l') ADVANCE(318);
      END_STATE();
    case 486:
      if (lookahead == 'l') ADVANCE(321);
      END_STATE();
    case 487:
      if (lookahead == 'l') ADVANCE(181);
      END_STATE();
    case 488:
      if (lookahead == 'l') ADVANCE(647);
      if (lookahead == 'n') ADVANCE(291);
      if (lookahead == 'r') ADVANCE(630);
      END_STATE();
    case 489:
      if (lookahead == 'l') ADVANCE(647);
      if (lookahead == 'n') ADVANCE(291);
      if (lookahead == 'r') ADVANCE(630);
      if (lookahead == 'x') ADVANCE(700);
      END_STATE();
    case 490:
      if (lookahead == 'l') ADVANCE(236);
      END_STATE();
    case 491:
      if (lookahead == 'l') ADVANCE(242);
      END_STATE();
    case 492:
      if (lookahead == 'm') ADVANCE(1775);
      END_STATE();
    case 493:
      if (lookahead == 'm') ADVANCE(1913);
      END_STATE();
    case 494:
      if (lookahead == 'm') ADVANCE(1914);
      END_STATE();
    case 495:
      if (lookahead == 'm') ADVANCE(589);
      if (lookahead == 'n') ADVANCE(290);
      END_STATE();
    case 496:
      if (lookahead == 'm') ADVANCE(589);
      if (lookahead == 'n') ADVANCE(290);
      if (lookahead == 's') ADVANCE(1729);
      END_STATE();
    case 497:
      if (lookahead == 'm') ADVANCE(305);
      END_STATE();
    case 498:
      if (lookahead == 'm') ADVANCE(508);
      END_STATE();
    case 499:
      if (lookahead == 'm') ADVANCE(576);
      END_STATE();
    case 500:
      if (lookahead == 'm') ADVANCE(720);
      END_STATE();
    case 501:
      if (lookahead == 'm') ADVANCE(434);
      END_STATE();
    case 502:
      if (lookahead == 'm') ADVANCE(437);
      END_STATE();
    case 503:
      if (lookahead == 'n') ADVANCE(651);
      END_STATE();
    case 504:
      if (lookahead == 'n') ADVANCE(421);
      END_STATE();
    case 505:
      if (lookahead == 'n') ADVANCE(1868);
      END_STATE();
    case 506:
      if (lookahead == 'n') ADVANCE(1868);
      if (lookahead == 'r') ADVANCE(238);
      END_STATE();
    case 507:
      if (lookahead == 'n') ADVANCE(1753);
      END_STATE();
    case 508:
      if (lookahead == 'n') ADVANCE(1679);
      END_STATE();
    case 509:
      if (lookahead == 'n') ADVANCE(1680);
      END_STATE();
    case 510:
      if (lookahead == 'n') ADVANCE(1800);
      END_STATE();
    case 511:
      if (lookahead == 'n') ADVANCE(1924);
      END_STATE();
    case 512:
      if (lookahead == 'n') ADVANCE(652);
      END_STATE();
    case 513:
      if (lookahead == 'n') ADVANCE(1688);
      END_STATE();
    case 514:
      if (lookahead == 'n') ADVANCE(1688);
      if (lookahead == 's') ADVANCE(1729);
      END_STATE();
    case 515:
      if (lookahead == 'n') ADVANCE(705);
      if (lookahead == 'x') ADVANCE(678);
      END_STATE();
    case 516:
      if (lookahead == 'n') ADVANCE(388);
      END_STATE();
    case 517:
      if (lookahead == 'n') ADVANCE(257);
      END_STATE();
    case 518:
      if (lookahead == 'n') ADVANCE(389);
      END_STATE();
    case 519:
      if (lookahead == 'n') ADVANCE(267);
      END_STATE();
    case 520:
      if (lookahead == 'n') ADVANCE(390);
      END_STATE();
    case 521:
      if (lookahead == 'n') ADVANCE(244);
      END_STATE();
    case 522:
      if (lookahead == 'n') ADVANCE(713);
      END_STATE();
    case 523:
      if (lookahead == 'n') ADVANCE(391);
      END_STATE();
    case 524:
      if (lookahead == 'n') ADVANCE(258);
      END_STATE();
    case 525:
      if (lookahead == 'n') ADVANCE(296);
      END_STATE();
    case 526:
      if (lookahead == 'n') ADVANCE(392);
      END_STATE();
    case 527:
      if (lookahead == 'n') ADVANCE(199);
      END_STATE();
    case 528:
      if (lookahead == 'n') ADVANCE(655);
      END_STATE();
    case 529:
      if (lookahead == 'n') ADVANCE(210);
      END_STATE();
    case 530:
      if (lookahead == 'n') ADVANCE(500);
      END_STATE();
    case 531:
      if (lookahead == 'n') ADVANCE(393);
      END_STATE();
    case 532:
      if (lookahead == 'n') ADVANCE(653);
      END_STATE();
    case 533:
      if (lookahead == 'n') ADVANCE(309);
      END_STATE();
    case 534:
      if (lookahead == 'n') ADVANCE(546);
      END_STATE();
    case 535:
      if (lookahead == 'n') ADVANCE(338);
      END_STATE();
    case 536:
      if (lookahead == 'n') ADVANCE(446);
      END_STATE();
    case 537:
      if (lookahead == 'n') ADVANCE(214);
      END_STATE();
    case 538:
      if (lookahead == 'n') ADVANCE(272);
      END_STATE();
    case 539:
      if (lookahead == 'n') ADVANCE(289);
      END_STATE();
    case 540:
      if (lookahead == 'n') ADVANCE(289);
      if (lookahead == 's') ADVANCE(1729);
      END_STATE();
    case 541:
      if (lookahead == 'n') ADVANCE(430);
      END_STATE();
    case 542:
      if (lookahead == 'n') ADVANCE(433);
      END_STATE();
    case 543:
      if (lookahead == 'n') ADVANCE(215);
      END_STATE();
    case 544:
      if (lookahead == 'n') ADVANCE(273);
      END_STATE();
    case 545:
      if (lookahead == 'n') ADVANCE(217);
      END_STATE();
    case 546:
      if (lookahead == 'o') ADVANCE(727);
      END_STATE();
    case 547:
      if (lookahead == 'o') ADVANCE(727);
      if (lookahead == 'u') ADVANCE(649);
      END_STATE();
    case 548:
      if (lookahead == 'o') ADVANCE(1796);
      END_STATE();
    case 549:
      if (lookahead == 'o') ADVANCE(1799);
      END_STATE();
    case 550:
      if (lookahead == 'o') ADVANCE(631);
      END_STATE();
    case 551:
      if (lookahead == 'o') ADVANCE(631);
      if (lookahead == 'r') ADVANCE(340);
      END_STATE();
    case 552:
      if (lookahead == 'o') ADVANCE(404);
      END_STATE();
    case 553:
      if (lookahead == 'o') ADVANCE(726);
      END_STATE();
    case 554:
      if (lookahead == 'o') ADVANCE(709);
      END_STATE();
    case 555:
      if (lookahead == 'o') ADVANCE(728);
      END_STATE();
    case 556:
      if (lookahead == 'o') ADVANCE(504);
      END_STATE();
    case 557:
      if (lookahead == 'o') ADVANCE(469);
      END_STATE();
    case 558:
      if (lookahead == 'o') ADVANCE(266);
      END_STATE();
    case 559:
      if (lookahead == 'o') ADVANCE(710);
      END_STATE();
    case 560:
      if (lookahead == 'o') ADVANCE(707);
      END_STATE();
    case 561:
      if (lookahead == 'o') ADVANCE(597);
      END_STATE();
    case 562:
      if (lookahead == 'o') ADVANCE(654);
      END_STATE();
    case 563:
      if (lookahead == 'o') ADVANCE(621);
      END_STATE();
    case 564:
      if (lookahead == 'o') ADVANCE(264);
      END_STATE();
    case 565:
      if (lookahead == 'o') ADVANCE(274);
      END_STATE();
    case 566:
      if (lookahead == 'o') ADVANCE(461);
      END_STATE();
    case 567:
      if (lookahead == 'o') ADVANCE(599);
      if (lookahead == 'u') ADVANCE(498);
      END_STATE();
    case 568:
      if (lookahead == 'o') ADVANCE(464);
      END_STATE();
    case 569:
      if (lookahead == 'o') ADVANCE(600);
      END_STATE();
    case 570:
      if (lookahead == 'o') ADVANCE(509);
      END_STATE();
    case 571:
      if (lookahead == 'o') ADVANCE(602);
      END_STATE();
    case 572:
      if (lookahead == 'o') ADVANCE(510);
      END_STATE();
    case 573:
      if (lookahead == 'o') ADVANCE(604);
      END_STATE();
    case 574:
      if (lookahead == 'o') ADVANCE(511);
      END_STATE();
    case 575:
      if (lookahead == 'o') ADVANCE(530);
      END_STATE();
    case 576:
      if (lookahead == 'o') ADVANCE(292);
      END_STATE();
    case 577:
      if (lookahead == 'o') ADVANCE(278);
      END_STATE();
    case 578:
      if (lookahead == 'o') ADVANCE(490);
      END_STATE();
    case 579:
      if (lookahead == 'o') ADVANCE(543);
      END_STATE();
    case 580:
      if (lookahead == 'o') ADVANCE(275);
      END_STATE();
    case 581:
      if (lookahead == 'o') ADVANCE(692);
      END_STATE();
    case 582:
      if (lookahead == 'p') ADVANCE(300);
      if (lookahead == 'v') ADVANCE(339);
      END_STATE();
    case 583:
      if (lookahead == 'p') ADVANCE(1834);
      END_STATE();
    case 584:
      if (lookahead == 'p') ADVANCE(361);
      if (lookahead == 'v') ADVANCE(339);
      END_STATE();
    case 585:
      if (lookahead == 'p') ADVANCE(303);
      END_STATE();
    case 586:
      if (lookahead == 'p') ADVANCE(668);
      END_STATE();
    case 587:
      if (lookahead == 'p') ADVANCE(324);
      END_STATE();
    case 588:
      if (lookahead == 'p') ADVANCE(367);
      if (lookahead == 'q') ADVANCE(719);
      END_STATE();
    case 589:
      if (lookahead == 'p') ADVANCE(563);
      END_STATE();
    case 590:
      if (lookahead == 'p') ADVANCE(353);
      END_STATE();
    case 591:
      if (lookahead == 'p') ADVANCE(620);
      END_STATE();
    case 592:
      if (lookahead == 'p') ADVANCE(435);
      END_STATE();
    case 593:
      if (lookahead == 'p') ADVANCE(368);
      if (lookahead == 't') ADVANCE(580);
      END_STATE();
    case 594:
      if (lookahead == 'q') ADVANCE(719);
      END_STATE();
    case 595:
      if (lookahead == 'r') ADVANCE(1747);
      END_STATE();
    case 596:
      if (lookahead == 'r') ADVANCE(1784);
      END_STATE();
    case 597:
      if (lookahead == 'r') ADVANCE(1549);
      END_STATE();
    case 598:
      if (lookahead == 'r') ADVANCE(1700);
      END_STATE();
    case 599:
      if (lookahead == 'r') ADVANCE(176);
      END_STATE();
    case 600:
      if (lookahead == 'r') ADVANCE(1928);
      END_STATE();
    case 601:
      if (lookahead == 'r') ADVANCE(166);
      END_STATE();
    case 602:
      if (lookahead == 'r') ADVANCE(1833);
      END_STATE();
    case 603:
      if (lookahead == 'r') ADVANCE(1912);
      END_STATE();
    case 604:
      if (lookahead == 'r') ADVANCE(1664);
      END_STATE();
    case 605:
      if (lookahead == 'r') ADVANCE(581);
      END_STATE();
    case 606:
      if (lookahead == 'r') ADVANCE(282);
      END_STATE();
    case 607:
      if (lookahead == 'r') ADVANCE(167);
      END_STATE();
    case 608:
      if (lookahead == 'r') ADVANCE(716);
      END_STATE();
    case 609:
      if (lookahead == 'r') ADVANCE(553);
      END_STATE();
    case 610:
      if (lookahead == 'r') ADVANCE(555);
      END_STATE();
    case 611:
      if (lookahead == 'r') ADVANCE(541);
      END_STATE();
    case 612:
      if (lookahead == 'r') ADVANCE(548);
      END_STATE();
    case 613:
      if (lookahead == 'r') ADVANCE(271);
      END_STATE();
    case 614:
      if (lookahead == 'r') ADVANCE(507);
      END_STATE();
    case 615:
      if (lookahead == 'r') ADVANCE(559);
      END_STATE();
    case 616:
      if (lookahead == 'r') ADVANCE(410);
      END_STATE();
    case 617:
      if (lookahead == 'r') ADVANCE(440);
      END_STATE();
    case 618:
      if (lookahead == 'r') ADVANCE(560);
      END_STATE();
    case 619:
      if (lookahead == 'r') ADVANCE(549);
      END_STATE();
    case 620:
      if (lookahead == 'r') ADVANCE(447);
      END_STATE();
    case 621:
      if (lookahead == 'r') ADVANCE(663);
      END_STATE();
    case 622:
      if (lookahead == 'r') ADVANCE(208);
      END_STATE();
    case 623:
      if (lookahead == 'r') ADVANCE(416);
      END_STATE();
    case 624:
      if (lookahead == 'r') ADVANCE(675);
      END_STATE();
    case 625:
      if (lookahead == 'r') ADVANCE(369);
      END_STATE();
    case 626:
      if (lookahead == 'r') ADVANCE(343);
      END_STATE();
    case 627:
      if (lookahead == 'r') ADVANCE(322);
      END_STATE();
    case 628:
      if (lookahead == 'r') ADVANCE(617);
      END_STATE();
    case 629:
      if (lookahead == 'r') ADVANCE(537);
      END_STATE();
    case 630:
      if (lookahead == 'r') ADVANCE(569);
      END_STATE();
    case 631:
      if (lookahead == 'r') ADVANCE(610);
      END_STATE();
    case 632:
      if (lookahead == 'r') ADVANCE(545);
      END_STATE();
    case 633:
      if (lookahead == 'r') ADVANCE(218);
      END_STATE();
    case 634:
      if (lookahead == 'r') ADVANCE(221);
      END_STATE();
    case 635:
      if (lookahead == 'r') ADVANCE(222);
      END_STATE();
    case 636:
      if (lookahead == 's') ADVANCE(1729);
      END_STATE();
    case 637:
      if (lookahead == 's') ADVANCE(1772);
      END_STATE();
    case 638:
      if (lookahead == 's') ADVANCE(1766);
      END_STATE();
    case 639:
      if (lookahead == 's') ADVANCE(552);
      END_STATE();
    case 640:
      if (lookahead == 's') ADVANCE(265);
      END_STATE();
    case 641:
      if (lookahead == 's') ADVANCE(558);
      if (lookahead == 'y') ADVANCE(524);
      END_STATE();
    case 642:
      if (lookahead == 's') ADVANCE(637);
      END_STATE();
    case 643:
      if (lookahead == 's') ADVANCE(679);
      END_STATE();
    case 644:
      if (lookahead == 's') ADVANCE(304);
      END_STATE();
    case 645:
      if (lookahead == 's') ADVANCE(672);
      END_STATE();
    case 646:
      if (lookahead == 's') ADVANCE(276);
      END_STATE();
    case 647:
      if (lookahead == 's') ADVANCE(307);
      END_STATE();
    case 648:
      if (lookahead == 's') ADVANCE(204);
      if (lookahead == 'u') ADVANCE(532);
      END_STATE();
    case 649:
      if (lookahead == 's') ADVANCE(337);
      END_STATE();
    case 650:
      if (lookahead == 's') ADVANCE(578);
      END_STATE();
    case 651:
      if (lookahead == 's') ADVANCE(708);
      if (lookahead == 't') ADVANCE(423);
      if (lookahead == 'v') ADVANCE(346);
      END_STATE();
    case 652:
      if (lookahead == 's') ADVANCE(708);
      if (lookahead == 'v') ADVANCE(346);
      END_STATE();
    case 653:
      if (lookahead == 's') ADVANCE(231);
      END_STATE();
    case 654:
      if (lookahead == 's') ADVANCE(717);
      END_STATE();
    case 655:
      if (lookahead == 's') ADVANCE(441);
      END_STATE();
    case 656:
      if (lookahead == 't') ADVANCE(209);
      if (lookahead == 'u') ADVANCE(246);
      END_STATE();
    case 657:
      if (lookahead == 't') ADVANCE(1818);
      END_STATE();
    case 658:
      if (lookahead == 't') ADVANCE(1781);
      END_STATE();
    case 659:
      if (lookahead == 't') ADVANCE(1672);
      END_STATE();
    case 660:
      if (lookahead == 't') ADVANCE(1892);
      END_STATE();
    case 661:
      if (lookahead == 't') ADVANCE(1812);
      END_STATE();
    case 662:
      if (lookahead == 't') ADVANCE(1793);
      END_STATE();
    case 663:
      if (lookahead == 't') ADVANCE(1763);
      END_STATE();
    case 664:
      if (lookahead == 't') ADVANCE(1561);
      END_STATE();
    case 665:
      if (lookahead == 't') ADVANCE(1769);
      END_STATE();
    case 666:
      if (lookahead == 't') ADVANCE(1790);
      END_STATE();
    case 667:
      if (lookahead == 't') ADVANCE(1803);
      END_STATE();
    case 668:
      if (lookahead == 't') ADVANCE(1814);
      END_STATE();
    case 669:
      if (lookahead == 't') ADVANCE(1809);
      END_STATE();
    case 670:
      if (lookahead == 't') ADVANCE(1816);
      END_STATE();
    case 671:
      if (lookahead == 't') ADVANCE(1819);
      END_STATE();
    case 672:
      if (lookahead == 't') ADVANCE(385);
      END_STATE();
    case 673:
      if (lookahead == 't') ADVANCE(406);
      END_STATE();
    case 674:
      if (lookahead == 't') ADVANCE(561);
      END_STATE();
    case 675:
      if (lookahead == 't') ADVANCE(736);
      END_STATE();
    case 676:
      if (lookahead == 't') ADVANCE(401);
      END_STATE();
    case 677:
      if (lookahead == 't') ADVANCE(402);
      END_STATE();
    case 678:
      if (lookahead == 't') ADVANCE(341);
      END_STATE();
    case 679:
      if (lookahead == 't') ADVANCE(616);
      END_STATE();
    case 680:
      if (lookahead == 't') ADVANCE(213);
      END_STATE();
    case 681:
      if (lookahead == 't') ADVANCE(608);
      END_STATE();
    case 682:
      if (lookahead == 't') ADVANCE(313);
      END_STATE();
    case 683:
      if (lookahead == 't') ADVANCE(315);
      END_STATE();
    case 684:
      if (lookahead == 't') ADVANCE(345);
      END_STATE();
    case 685:
      if (lookahead == 't') ADVANCE(347);
      END_STATE();
    case 686:
      if (lookahead == 't') ADVANCE(350);
      END_STATE();
    case 687:
      if (lookahead == 't') ADVANCE(320);
      END_STATE();
    case 688:
      if (lookahead == 't') ADVANCE(262);
      END_STATE();
    case 689:
      if (lookahead == 't') ADVANCE(564);
      END_STATE();
    case 690:
      if (lookahead == 't') ADVANCE(425);
      END_STATE();
    case 691:
      if (lookahead == 't') ADVANCE(431);
      END_STATE();
    case 692:
      if (lookahead == 't') ADVANCE(565);
      END_STATE();
    case 693:
      if (lookahead == 't') ADVANCE(432);
      END_STATE();
    case 694:
      if (lookahead == 't') ADVANCE(571);
      END_STATE();
    case 695:
      if (lookahead == 't') ADVANCE(444);
      END_STATE();
    case 696:
      if (lookahead == 't') ADVANCE(573);
      END_STATE();
    case 697:
      if (lookahead == 't') ADVANCE(438);
      END_STATE();
    case 698:
      if (lookahead == 't') ADVANCE(360);
      END_STATE();
    case 699:
      if (lookahead == 't') ADVANCE(739);
      END_STATE();
    case 700:
      if (lookahead == 't') ADVANCE(375);
      END_STATE();
    case 701:
      if (lookahead == 't') ADVANCE(580);
      END_STATE();
    case 702:
      if (lookahead == 't') ADVANCE(376);
      END_STATE();
    case 703:
      if (lookahead == 't') ADVANCE(377);
      END_STATE();
    case 704:
      if (lookahead == 't') ADVANCE(240);
      END_STATE();
    case 705:
      if (lookahead == 'u') ADVANCE(492);
      END_STATE();
    case 706:
      if (lookahead == 'u') ADVANCE(680);
      END_STATE();
    case 707:
      if (lookahead == 'u') ADVANCE(583);
      END_STATE();
    case 708:
      if (lookahead == 'u') ADVANCE(502);
      END_STATE();
    case 709:
      if (lookahead == 'u') ADVANCE(613);
      END_STATE();
    case 710:
      if (lookahead == 'u') ADVANCE(394);
      END_STATE();
    case 711:
      if (lookahead == 'u') ADVANCE(660);
      END_STATE();
    case 712:
      if (lookahead == 'u') ADVANCE(306);
      if (lookahead == 'y') ADVANCE(1714);
      END_STATE();
    case 713:
      if (lookahead == 'u') ADVANCE(314);
      END_STATE();
    case 714:
      if (lookahead == 'u') ADVANCE(689);
      END_STATE();
    case 715:
      if (lookahead == 'u') ADVANCE(614);
      END_STATE();
    case 716:
      if (lookahead == 'u') ADVANCE(268);
      END_STATE();
    case 717:
      if (lookahead == 'u') ADVANCE(627);
      END_STATE();
    case 718:
      if (lookahead == 'u') ADVANCE(685);
      END_STATE();
    case 719:
      if (lookahead == 'u') ADVANCE(442);
      END_STATE();
    case 720:
      if (lookahead == 'u') ADVANCE(704);
      END_STATE();
    case 721:
      if (lookahead == 'v') ADVANCE(233);
      END_STATE();
    case 722:
      if (lookahead == 'v') ADVANCE(230);
      END_STATE();
    case 723:
      if (lookahead == 'v') ADVANCE(358);
      END_STATE();
    case 724:
      if (lookahead == 'v') ADVANCE(237);
      END_STATE();
    case 725:
      if (lookahead == 'v') ADVANCE(243);
      END_STATE();
    case 726:
      if (lookahead == 'w') ADVANCE(1751);
      END_STATE();
    case 727:
      if (lookahead == 'w') ADVANCE(535);
      END_STATE();
    case 728:
      if (lookahead == 'w') ADVANCE(436);
      END_STATE();
    case 729:
      if (lookahead == 'x') ADVANCE(1827);
      END_STATE();
    case 730:
      if (lookahead == 'x') ADVANCE(1824);
      END_STATE();
    case 731:
      if (lookahead == 'x') ADVANCE(1830);
      END_STATE();
    case 732:
      if (lookahead == 'y') ADVANCE(585);
      END_STATE();
    case 733:
      if (lookahead == 'y') ADVANCE(1655);
      END_STATE();
    case 734:
      if (lookahead == 'y') ADVANCE(179);
      END_STATE();
    case 735:
      if (lookahead == 'y') ADVANCE(1558);
      END_STATE();
    case 736:
      if (lookahead == 'y') ADVANCE(1911);
      END_STATE();
    case 737:
      if (lookahead == 'y') ADVANCE(1822);
      END_STATE();
    case 738:
      if (lookahead == 'y') ADVANCE(590);
      END_STATE();
    case 739:
      if (lookahead == 'y') ADVANCE(587);
      END_STATE();
    case 740:
      if (lookahead == 'y') ADVANCE(524);
      END_STATE();
    case 741:
      if (lookahead == 'z') ADVANCE(735);
      END_STATE();
    case 742:
      if (lookahead == '{') ADVANCE(1686);
      END_STATE();
    case 743:
      if (lookahead == '}') ADVANCE(1626);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(743);
      END_STATE();
    case 744:
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(744);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '/') ADVANCE(159);
      END_STATE();
    case 745:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(750);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1571);
      END_STATE();
    case 746:
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(1577);
      END_STATE();
    case 747:
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(1576);
      END_STATE();
    case 748:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1545);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_1, 802, lookahead)) ADVANCE(1547);
      END_STATE();
    case 749:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1570);
      END_STATE();
    case 750:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1571);
      END_STATE();
    case 751:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(1575);
      END_STATE();
    case 752:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(743);
      END_STATE();
    case 753:
      if (lookahead != 0 &&
          lookahead != '#') ADVANCE(33);
      END_STATE();
    case 754:
      if (eof) ADVANCE(771);
      ADVANCE_MAP(
        '!', 1807,
        '"', 1585,
        '#', 39,
        '$', 748,
        '%', 1737,
        '&', 1657,
        '(', 1640,
        ')', 1628,
        '*', 1734,
        '+', 1731,
        ',', 1631,
        '-', 1732,
        '.', 1645,
        '/', 1735,
        '0', 1572,
        ':', 1637,
        ';', 1808,
        '<', 1669,
        '=', 173,
        '>', 1671,
        '?', 1651,
        '@', 1841,
        'P', 605,
        'T', 732,
        '[', 1641,
        '\\', 1623,
        ']', 1642,
        '^', 1743,
        '_', 1842,
        '`', 189,
        'a', 251,
        'b', 551,
        'c', 197,
        'd', 297,
        'e', 190,
        'f', 191,
        'g', 333,
        'i', 379,
        'l', 192,
        'm', 195,
        'n', 409,
        'o', 582,
        'p', 193,
        'r', 298,
        's', 299,
        't', 405,
        'u', 1625,
        'v', 201,
        'w', 335,
        'y', 414,
        '{', 1685,
        '|', 1741,
        '}', 1687,
        '~', 1740,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(754);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1573);
      END_STATE();
    case 755:
      if (eof) ADVANCE(771);
      ADVANCE_MAP(
        '!', 1807,
        '"', 1585,
        '#', 40,
        '$', 748,
        '%', 1737,
        '&', 1657,
        '(', 1640,
        '*', 1734,
        '+', 1731,
        '-', 1732,
        '.', 151,
        '/', 1735,
        '0', 1572,
        '<', 1669,
        '=', 173,
        '>', 1671,
        '@', 1841,
        '[', 1641,
        '\\', 1622,
        '^', 1743,
        '`', 189,
        'a', 848,
        'b', 1034,
        'c', 990,
        'd', 947,
        'e', 815,
        'f', 816,
        'g', 1133,
        'i', 926,
        'l', 818,
        'm', 821,
        'n', 950,
        'o', 1051,
        'p', 824,
        'r', 880,
        's', 898,
        't', 945,
        'u', 1015,
        'v', 828,
        'w', 903,
        '{', 1685,
        '|', 1741,
        '~', 1740,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(755);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1573);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_1, 802, lookahead)) ADVANCE(1542);
      END_STATE();
    case 756:
      if (eof) ADVANCE(771);
      ADVANCE_MAP(
        '!', 1807,
        '"', 1585,
        '#', 156,
        '$', 748,
        '%', 1737,
        '&', 1657,
        '(', 1640,
        ')', 1628,
        '*', 1734,
        '+', 1731,
        ',', 1631,
        '-', 1732,
        '.', 151,
        '/', 1735,
        '0', 1572,
        ':', 1637,
        '<', 1669,
        '=', 173,
        '>', 1671,
        '?', 1652,
        '[', 1641,
        '\\', 1622,
        ']', 1642,
        '^', 1743,
        '`', 189,
        'a', 1200,
        'b', 1400,
        'c', 1419,
        'e', 1158,
        'f', 1160,
        'i', 1285,
        'l', 1162,
        'n', 1308,
        'p', 1169,
        'r', 1279,
        's', 1251,
        't', 1436,
        '{', 1685,
        '|', 1741,
        '}', 1687,
        '~', 1740,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(757);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1573);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_1, 802, lookahead)) ADVANCE(1542);
      END_STATE();
    case 757:
      if (eof) ADVANCE(771);
      ADVANCE_MAP(
        '!', 1807,
        '"', 1585,
        '#', 156,
        '$', 748,
        '%', 1737,
        '&', 1657,
        '(', 1640,
        ')', 1628,
        '*', 1734,
        '+', 1731,
        ',', 1631,
        '-', 1732,
        '.', 151,
        '/', 1735,
        '0', 1572,
        ':', 1637,
        '<', 1669,
        '=', 173,
        '>', 1671,
        '?', 1651,
        '[', 1641,
        '\\', 1622,
        ']', 1642,
        '^', 1743,
        '`', 189,
        'a', 1200,
        'b', 1400,
        'c', 1419,
        'e', 1158,
        'f', 1160,
        'i', 1285,
        'l', 1162,
        'n', 1308,
        'p', 1169,
        'r', 1279,
        's', 1251,
        't', 1436,
        '{', 1685,
        '|', 1741,
        '}', 1687,
        '~', 1740,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(757);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1573);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_1, 802, lookahead)) ADVANCE(1542);
      END_STATE();
    case 758:
      if (eof) ADVANCE(771);
      ADVANCE_MAP(
        '!', 1807,
        '"', 1585,
        '#', 154,
        '$', 748,
        '%', 1737,
        '&', 1657,
        '(', 1640,
        ')', 1628,
        '*', 1734,
        '+', 1731,
        ',', 1631,
        '-', 1732,
        '.', 151,
        '/', 1735,
        '0', 1572,
        ':', 1637,
        '<', 1669,
        '=', 173,
        '>', 1671,
        '?', 1652,
        '[', 1641,
        '\\', 1622,
        ']', 1642,
        '^', 1743,
        '`', 189,
        'a', 1200,
        'b', 1400,
        'c', 1155,
        'e', 1158,
        'f', 1160,
        'i', 1285,
        'l', 1161,
        'n', 1308,
        'p', 1169,
        'r', 1279,
        's', 1251,
        't', 1436,
        'v', 1164,
        '{', 1685,
        '|', 1741,
        '}', 1687,
        '~', 1740,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(759);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1573);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_1, 802, lookahead)) ADVANCE(1542);
      END_STATE();
    case 759:
      if (eof) ADVANCE(771);
      ADVANCE_MAP(
        '!', 1807,
        '"', 1585,
        '#', 154,
        '$', 748,
        '%', 1737,
        '&', 1657,
        '(', 1640,
        ')', 1628,
        '*', 1734,
        '+', 1731,
        ',', 1631,
        '-', 1732,
        '.', 151,
        '/', 1735,
        '0', 1572,
        ':', 1637,
        '<', 1669,
        '=', 173,
        '>', 1671,
        '?', 1651,
        '[', 1641,
        '\\', 1622,
        ']', 1642,
        '^', 1743,
        '`', 189,
        'a', 1200,
        'b', 1400,
        'c', 1155,
        'e', 1158,
        'f', 1160,
        'i', 1285,
        'l', 1161,
        'n', 1308,
        'p', 1169,
        'r', 1279,
        's', 1251,
        't', 1436,
        'v', 1164,
        '{', 1685,
        '|', 1741,
        '}', 1687,
        '~', 1740,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(759);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1573);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_1, 802, lookahead)) ADVANCE(1542);
      END_STATE();
    case 760:
      if (eof) ADVANCE(771);
      ADVANCE_MAP(
        '!', 1807,
        '#', 325,
        '$', 748,
        '%', 1737,
        '&', 1657,
        '(', 1640,
        ')', 1628,
        '*', 1734,
        '+', 1731,
        ',', 1631,
        '-', 1732,
        '.', 1644,
        '/', 1736,
        '0', 1574,
        ':', 1637,
        '<', 1669,
        '=', 173,
        '>', 1671,
        '?', 1652,
        '[', 1641,
        ']', 1642,
        '^', 1743,
        '`', 189,
        'a', 1201,
        'b', 1400,
        'c', 1419,
        'e', 1158,
        'i', 1460,
        'l', 1162,
        'p', 1169,
        'r', 1279,
        '{', 1685,
        '|', 1741,
        '}', 1687,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(761);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1574);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_1, 802, lookahead)) ADVANCE(1542);
      END_STATE();
    case 761:
      if (eof) ADVANCE(771);
      ADVANCE_MAP(
        '!', 1807,
        '#', 325,
        '$', 748,
        '%', 1737,
        '&', 1657,
        '(', 1640,
        ')', 1628,
        '*', 1734,
        '+', 1731,
        ',', 1631,
        '-', 1732,
        '.', 1644,
        '/', 1736,
        '0', 1574,
        ':', 1637,
        '<', 1669,
        '=', 173,
        '>', 1671,
        '?', 1651,
        '[', 1641,
        ']', 1642,
        '^', 1743,
        '`', 189,
        'a', 1201,
        'b', 1400,
        'c', 1419,
        'e', 1158,
        'i', 1460,
        'l', 1162,
        'p', 1169,
        'r', 1279,
        '{', 1685,
        '|', 1741,
        '}', 1687,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(761);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1574);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_1, 802, lookahead)) ADVANCE(1542);
      END_STATE();
    case 762:
      if (eof) ADVANCE(771);
      ADVANCE_MAP(
        '!', 1807,
        '#', 325,
        '$', 748,
        '%', 1737,
        '&', 1657,
        '(', 1640,
        ')', 1628,
        '*', 1734,
        '+', 1731,
        ',', 1631,
        '-', 1732,
        '.', 1644,
        '/', 1736,
        ':', 1637,
        '<', 1669,
        '=', 173,
        '>', 1671,
        '?', 1652,
        '[', 1641,
        ']', 1642,
        '^', 1743,
        '`', 189,
        'a', 1197,
        'b', 1400,
        'c', 1419,
        'e', 1158,
        'i', 1460,
        'l', 1162,
        'p', 1169,
        'r', 1279,
        's', 1408,
        '{', 1685,
        '|', 1741,
        '}', 1687,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(763);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_1, 802, lookahead)) ADVANCE(1542);
      END_STATE();
    case 763:
      if (eof) ADVANCE(771);
      ADVANCE_MAP(
        '!', 1807,
        '#', 325,
        '$', 748,
        '%', 1737,
        '&', 1657,
        '(', 1640,
        ')', 1628,
        '*', 1734,
        '+', 1731,
        ',', 1631,
        '-', 1732,
        '.', 1644,
        '/', 1736,
        ':', 1637,
        '<', 1669,
        '=', 173,
        '>', 1671,
        '?', 1651,
        '[', 1641,
        ']', 1642,
        '^', 1743,
        '`', 189,
        'a', 1197,
        'b', 1400,
        'c', 1419,
        'e', 1158,
        'i', 1460,
        'l', 1162,
        'p', 1169,
        'r', 1279,
        's', 1408,
        '{', 1685,
        '|', 1741,
        '}', 1687,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(763);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_1, 802, lookahead)) ADVANCE(1542);
      END_STATE();
    case 764:
      if (eof) ADVANCE(771);
      ADVANCE_MAP(
        '!', 1807,
        '#', 325,
        '%', 1737,
        '&', 1657,
        '(', 1640,
        ')', 1628,
        '*', 1734,
        '+', 1731,
        ',', 1631,
        '-', 1732,
        '.', 1644,
        '/', 1736,
        ':', 1637,
        ';', 1808,
        '<', 1669,
        '=', 173,
        '>', 1671,
        '?', 1652,
        '@', 1841,
        '[', 1641,
        ']', 1642,
        '^', 1743,
        'a', 252,
        'b', 550,
        'c', 198,
        'd', 373,
        'e', 515,
        'f', 229,
        'i', 496,
        'l', 192,
        'm', 195,
        'n', 556,
        'o', 584,
        'p', 216,
        'r', 326,
        's', 357,
        't', 738,
        'u', 534,
        'v', 201,
        'w', 335,
        '{', 1685,
        '|', 1741,
        '}', 1687,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(765);
      END_STATE();
    case 765:
      if (eof) ADVANCE(771);
      ADVANCE_MAP(
        '!', 1807,
        '#', 325,
        '%', 1737,
        '&', 1657,
        '(', 1640,
        ')', 1628,
        '*', 1734,
        '+', 1731,
        ',', 1631,
        '-', 1732,
        '.', 1644,
        '/', 1736,
        ':', 1637,
        ';', 1808,
        '<', 1669,
        '=', 173,
        '>', 1671,
        '?', 1651,
        '@', 1841,
        '[', 1641,
        ']', 1642,
        '^', 1743,
        'a', 252,
        'b', 550,
        'c', 198,
        'd', 373,
        'e', 515,
        'f', 229,
        'i', 496,
        'l', 192,
        'm', 195,
        'n', 556,
        'o', 584,
        'p', 216,
        'r', 326,
        's', 357,
        't', 738,
        'u', 534,
        'v', 201,
        'w', 335,
        '{', 1685,
        '|', 1741,
        '}', 1687,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(765);
      END_STATE();
    case 766:
      if (eof) ADVANCE(771);
      ADVANCE_MAP(
        '!', 1638,
        '#', 325,
        '$', 748,
        '%', 168,
        '&', 1657,
        '(', 1640,
        ')', 1628,
        '*', 169,
        '+', 170,
        ',', 1631,
        '-', 171,
        '.', 1646,
        '/', 163,
        '0', 1574,
        ':', 1637,
        '<', 1668,
        '>', 1670,
        '?', 1652,
        '@', 1841,
        '[', 1641,
        '\\', 145,
        ']', 1642,
        '^', 742,
        '`', 189,
        'a', 1195,
        'b', 1400,
        'c', 1154,
        'd', 1229,
        'e', 1156,
        'f', 1302,
        'i', 1360,
        'l', 1161,
        'm', 1515,
        'n', 1409,
        'o', 1424,
        'p', 1165,
        'r', 1230,
        's', 1406,
        't', 1536,
        'u', 1379,
        'v', 1164,
        'w', 1256,
        '{', 1685,
        '}', 1687,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(769);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1574);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_1, 802, lookahead)) ADVANCE(1542);
      END_STATE();
    case 767:
      if (eof) ADVANCE(771);
      ADVANCE_MAP(
        '!', 1638,
        '#', 325,
        '$', 748,
        '&', 1657,
        '(', 1640,
        ')', 1628,
        ',', 1631,
        '.', 1646,
        '/', 162,
        ':', 1637,
        '<', 1668,
        '>', 1670,
        '?', 1652,
        '@', 1840,
        '[', 1641,
        ']', 1642,
        '`', 189,
        'a', 1197,
        'b', 1400,
        'c', 1419,
        'e', 1158,
        'l', 1162,
        'p', 1169,
        'r', 1279,
        's', 1408,
        '{', 1685,
        '}', 1687,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(770);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_1, 802, lookahead)) ADVANCE(1542);
      END_STATE();
    case 768:
      if (eof) ADVANCE(771);
      ADVANCE_MAP(
        '!', 1806,
        '#', 325,
        '&', 1657,
        '(', 1640,
        ')', 1628,
        ',', 1631,
        '.', 1643,
        '/', 162,
        ':', 1637,
        '<', 1668,
        '?', 1651,
        '@', 1841,
        'a', 252,
        'b', 550,
        'c', 198,
        'd', 374,
        'e', 515,
        'f', 229,
        'i', 495,
        'l', 192,
        'm', 706,
        'n', 556,
        'o', 584,
        'p', 216,
        'r', 326,
        's', 656,
        't', 738,
        'u', 534,
        'v', 201,
        'w', 334,
        '{', 1685,
        '}', 1687,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(768);
      END_STATE();
    case 769:
      if (eof) ADVANCE(771);
      ADVANCE_MAP(
        '#', 325,
        '$', 748,
        '%', 168,
        '&', 1657,
        '(', 1640,
        ')', 1628,
        '*', 169,
        '+', 170,
        ',', 1631,
        '-', 171,
        '.', 1646,
        '/', 163,
        '0', 1574,
        ':', 1637,
        '<', 1668,
        '>', 1670,
        '?', 1651,
        '@', 1841,
        '[', 1641,
        '\\', 145,
        ']', 1642,
        '^', 742,
        '`', 189,
        'a', 1195,
        'b', 1400,
        'c', 1154,
        'd', 1229,
        'e', 1156,
        'f', 1302,
        'i', 1360,
        'l', 1161,
        'm', 1515,
        'n', 1409,
        'o', 1424,
        'p', 1165,
        'r', 1230,
        's', 1406,
        't', 1536,
        'u', 1379,
        'v', 1164,
        'w', 1256,
        '{', 1685,
        '}', 1687,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(769);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1574);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_1, 802, lookahead)) ADVANCE(1542);
      END_STATE();
    case 770:
      if (eof) ADVANCE(771);
      ADVANCE_MAP(
        '#', 325,
        '$', 748,
        '&', 1657,
        '(', 1640,
        ')', 1628,
        ',', 1631,
        '.', 1646,
        '/', 162,
        ':', 1637,
        '<', 1668,
        '>', 1670,
        '?', 1651,
        '@', 1840,
        '[', 1641,
        ']', 1642,
        '`', 189,
        'a', 1197,
        'b', 1400,
        'c', 1419,
        'e', 1158,
        'l', 1162,
        'p', 1169,
        'r', 1279,
        's', 1408,
        '{', 1685,
        '}', 1687,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(770);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_1, 802, lookahead)) ADVANCE(1542);
      END_STATE();
    case 771:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 772:
      ACCEPT_TOKEN(anon_sym_POUND_BANG);
      END_STATE();
    case 773:
      ACCEPT_TOKEN(aux_sym_shebang_line_token1);
      if (lookahead == '#') ADVANCE(781);
      if (lookahead == '/') ADVANCE(774);
      if (lookahead == '\t' ||
          lookahead == 0x0b ||
          lookahead == '\f' ||
          lookahead == ' ') ADVANCE(773);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(804);
      END_STATE();
    case 774:
      ACCEPT_TOKEN(aux_sym_shebang_line_token1);
      if (lookahead == '/') ADVANCE(804);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(804);
      END_STATE();
    case 775:
      ACCEPT_TOKEN(aux_sym_shebang_line_token1);
      if (lookahead == 'L') ADVANCE(794);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(804);
      END_STATE();
    case 776:
      ACCEPT_TOKEN(aux_sym_shebang_line_token1);
      if (lookahead == 'a') ADVANCE(802);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(804);
      END_STATE();
    case 777:
      ACCEPT_TOKEN(aux_sym_shebang_line_token1);
      if (lookahead == 'a') ADVANCE(798);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(804);
      END_STATE();
    case 778:
      ACCEPT_TOKEN(aux_sym_shebang_line_token1);
      if (lookahead == 'c') ADVANCE(776);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(804);
      END_STATE();
    case 779:
      ACCEPT_TOKEN(aux_sym_shebang_line_token1);
      if (lookahead == 'c') ADVANCE(783);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(804);
      END_STATE();
    case 780:
      ACCEPT_TOKEN(aux_sym_shebang_line_token1);
      if (lookahead == 'd') ADVANCE(786);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(804);
      END_STATE();
    case 781:
      ACCEPT_TOKEN(aux_sym_shebang_line_token1);
      if (lookahead == 'e') ADVANCE(789);
      if (lookahead == 'i') ADVANCE(784);
      if (lookahead == 's') ADVANCE(793);
      if (lookahead == 'w') ADVANCE(777);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(804);
      END_STATE();
    case 782:
      ACCEPT_TOKEN(aux_sym_shebang_line_token1);
      if (lookahead == 'e') ADVANCE(786);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(804);
      END_STATE();
    case 783:
      ACCEPT_TOKEN(aux_sym_shebang_line_token1);
      if (lookahead == 'e') ADVANCE(775);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(804);
      END_STATE();
    case 784:
      ACCEPT_TOKEN(aux_sym_shebang_line_token1);
      if (lookahead == 'f') ADVANCE(804);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(804);
      END_STATE();
    case 785:
      ACCEPT_TOKEN(aux_sym_shebang_line_token1);
      if (lookahead == 'g') ADVANCE(804);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(804);
      END_STATE();
    case 786:
      ACCEPT_TOKEN(aux_sym_shebang_line_token1);
      if (lookahead == 'i') ADVANCE(784);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(804);
      END_STATE();
    case 787:
      ACCEPT_TOKEN(aux_sym_shebang_line_token1);
      if (lookahead == 'i') ADVANCE(791);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(804);
      END_STATE();
    case 788:
      ACCEPT_TOKEN(aux_sym_shebang_line_token1);
      if (lookahead == 'i') ADVANCE(795);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(804);
      END_STATE();
    case 789:
      ACCEPT_TOKEN(aux_sym_shebang_line_token1);
      if (lookahead == 'l') ADVANCE(801);
      if (lookahead == 'n') ADVANCE(780);
      if (lookahead == 'r') ADVANCE(800);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(804);
      END_STATE();
    case 790:
      ACCEPT_TOKEN(aux_sym_shebang_line_token1);
      if (lookahead == 'n') ADVANCE(804);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(804);
      END_STATE();
    case 791:
      ACCEPT_TOKEN(aux_sym_shebang_line_token1);
      if (lookahead == 'n') ADVANCE(785);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(804);
      END_STATE();
    case 792:
      ACCEPT_TOKEN(aux_sym_shebang_line_token1);
      if (lookahead == 'n') ADVANCE(787);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(804);
      END_STATE();
    case 793:
      ACCEPT_TOKEN(aux_sym_shebang_line_token1);
      if (lookahead == 'o') ADVANCE(803);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(804);
      END_STATE();
    case 794:
      ACCEPT_TOKEN(aux_sym_shebang_line_token1);
      if (lookahead == 'o') ADVANCE(778);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(804);
      END_STATE();
    case 795:
      ACCEPT_TOKEN(aux_sym_shebang_line_token1);
      if (lookahead == 'o') ADVANCE(790);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(804);
      END_STATE();
    case 796:
      ACCEPT_TOKEN(aux_sym_shebang_line_token1);
      if (lookahead == 'o') ADVANCE(797);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(804);
      END_STATE();
    case 797:
      ACCEPT_TOKEN(aux_sym_shebang_line_token1);
      if (lookahead == 'r') ADVANCE(804);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(804);
      END_STATE();
    case 798:
      ACCEPT_TOKEN(aux_sym_shebang_line_token1);
      if (lookahead == 'r') ADVANCE(792);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(804);
      END_STATE();
    case 799:
      ACCEPT_TOKEN(aux_sym_shebang_line_token1);
      if (lookahead == 'r') ADVANCE(779);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(804);
      END_STATE();
    case 800:
      ACCEPT_TOKEN(aux_sym_shebang_line_token1);
      if (lookahead == 'r') ADVANCE(796);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(804);
      END_STATE();
    case 801:
      ACCEPT_TOKEN(aux_sym_shebang_line_token1);
      if (lookahead == 's') ADVANCE(782);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(804);
      END_STATE();
    case 802:
      ACCEPT_TOKEN(aux_sym_shebang_line_token1);
      if (lookahead == 't') ADVANCE(788);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(804);
      END_STATE();
    case 803:
      ACCEPT_TOKEN(aux_sym_shebang_line_token1);
      if (lookahead == 'u') ADVANCE(799);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(804);
      END_STATE();
    case 804:
      ACCEPT_TOKEN(aux_sym_shebang_line_token1);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(804);
      END_STATE();
    case 805:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\n') ADVANCE(33);
      if (lookahead == '#') ADVANCE(810);
      if (lookahead != 0) ADVANCE(806);
      END_STATE();
    case 806:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\n') ADVANCE(34);
      if (lookahead == '/') ADVANCE(805);
      if (lookahead != 0) ADVANCE(806);
      END_STATE();
    case 807:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '*') ADVANCE(1667);
      if (lookahead == '/') ADVANCE(808);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(809);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n') ADVANCE(809);
      END_STATE();
    case 808:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '*') ADVANCE(1667);
      if (lookahead == '/') ADVANCE(808);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(810);
      END_STATE();
    case 809:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '/') ADVANCE(810);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(809);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n') ADVANCE(809);
      END_STATE();
    case 810:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(810);
      END_STATE();
    case 811:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1665);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 812:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1666);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 813:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'S') ADVANCE(918);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 814:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'S') ADVANCE(919);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 815:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'a') ADVANCE(850);
      if (lookahead == 'n') ADVANCE(1124);
      if (lookahead == 'x') ADVANCE(1108);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 816:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'a') ADVANCE(993);
      if (lookahead == 'i') ADVANCE(994);
      if (lookahead == 'o') ADVANCE(1061);
      if (lookahead == 'u') ADVANCE(1018);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 817:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'a') ADVANCE(993);
      if (lookahead == 'i') ADVANCE(1023);
      if (lookahead == 'o') ADVANCE(1061);
      if (lookahead == 'u') ADVANCE(1018);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 818:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'a') ADVANCE(1150);
      if (lookahead == 'e') ADVANCE(1095);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 819:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'a') ADVANCE(940);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 820:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'a') ADVANCE(1085);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 821:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'a') ADVANCE(865);
      if (lookahead == 'u') ADVANCE(1110);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 822:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'a') ADVANCE(1007);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 823:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'a') ADVANCE(979);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 824:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'a') ADVANCE(851);
      if (lookahead == 'o') ADVANCE(1090);
      if (lookahead == 'r') ADVANCE(881);
      if (lookahead == 'u') ADVANCE(846);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 825:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'a') ADVANCE(851);
      if (lookahead == 'o') ADVANCE(1090);
      if (lookahead == 'r') ADVANCE(921);
      if (lookahead == 'u') ADVANCE(846);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 826:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'a') ADVANCE(851);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 827:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'a') ADVANCE(980);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 828:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'a') ADVANCE(1062);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 829:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'a') ADVANCE(1063);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 830:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'a') ADVANCE(985);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 831:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'a') ADVANCE(1083);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 832:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'a') ADVANCE(986);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 833:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'a') ADVANCE(1122);
      if (lookahead == 'r') ADVANCE(1128);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 834:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'a') ADVANCE(987);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 835:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'a') ADVANCE(1112);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 836:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'a') ADVANCE(989);
      if (lookahead == 'i') ADVANCE(994);
      if (lookahead == 'o') ADVANCE(1061);
      if (lookahead == 'u') ADVANCE(1018);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 837:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'a') ADVANCE(1100);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 838:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'a') ADVANCE(1115);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 839:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'a') ADVANCE(968);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 840:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'a') ADVANCE(1113);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 841:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'a') ADVANCE(1093);
      if (lookahead == 'l') ADVANCE(820);
      if (lookahead == 'o') ADVANCE(1012);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 842:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'a') ADVANCE(1001);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 843:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'a') ADVANCE(1114);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 844:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'a') ADVANCE(1117);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 845:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'a') ADVANCE(1118);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 846:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'b') ADVANCE(995);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 847:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'b') ADVANCE(1135);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 848:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'c') ADVANCE(1119);
      if (lookahead == 's') ADVANCE(1084);
      if (lookahead == 'w') ADVANCE(839);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 849:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'c') ADVANCE(1119);
      if (lookahead == 's') ADVANCE(1148);
      if (lookahead == 'w') ADVANCE(839);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 850:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'c') ADVANCE(942);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 851:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'c') ADVANCE(981);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 852:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'c') ADVANCE(1788);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 853:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'c') ADVANCE(1553);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 854:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'c') ADVANCE(1857);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 855:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'c') ADVANCE(1878);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 856:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'c') ADVANCE(1881);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 857:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'c') ADVANCE(943);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 858:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'c') ADVANCE(976);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 859:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'c') ADVANCE(1047);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 860:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'c') ADVANCE(897);
      if (lookahead == 'f') ADVANCE(954);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 861:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'c') ADVANCE(1101);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 862:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'c') ADVANCE(1102);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 863:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'c') ADVANCE(908);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 864:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'c') ADVANCE(888);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 865:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'c') ADVANCE(1069);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 866:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'd') ADVANCE(1704);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 867:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'd') ADVANCE(1901);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 868:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'd') ADVANCE(1851);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 869:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'd') ADVANCE(1887);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 870:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'd') ADVANCE(1854);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 871:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'd') ADVANCE(813);
      if (lookahead == 's') ADVANCE(1111);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 872:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'd') ADVANCE(1760);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 873:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'd') ADVANCE(960);
      if (lookahead == 'f') ADVANCE(948);
      if (lookahead == 'i') ADVANCE(1096);
      if (lookahead == 'o') ADVANCE(1130);
      if (lookahead == 't') ADVANCE(913);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 874:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'd') ADVANCE(960);
      if (lookahead == 'f') ADVANCE(948);
      if (lookahead == 'o') ADVANCE(1130);
      if (lookahead == 't') ADVANCE(913);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 875:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'd') ADVANCE(960);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 876:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'd') ADVANCE(887);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 877:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'd') ADVANCE(1106);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 878:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'd') ADVANCE(955);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 879:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'd') ADVANCE(924);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 880:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'e') ADVANCE(1054);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 881:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'e') ADVANCE(860);
      if (lookahead == 'i') ADVANCE(1138);
      if (lookahead == 'o') ADVANCE(1121);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 882:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'e') ADVANCE(1579);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 883:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'e') ADVANCE(1582);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 884:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'e') ADVANCE(1750);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 885:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'e') ADVANCE(1565);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 886:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'e') ADVANCE(1860);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 887:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'e') ADVANCE(1845);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 888:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'e') ADVANCE(1848);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 889:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'e') ADVANCE(1866);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 890:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'e') ADVANCE(1838);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 891:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'e') ADVANCE(1053);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 892:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'e') ADVANCE(983);
      if (lookahead == 't') ADVANCE(833);
      if (lookahead == 'u') ADVANCE(1057);
      if (lookahead == 'w') ADVANCE(964);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 893:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'e') ADVANCE(983);
      if (lookahead == 't') ADVANCE(1068);
      if (lookahead == 'u') ADVANCE(1057);
      if (lookahead == 'w') ADVANCE(964);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 894:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'e') ADVANCE(1756);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 895:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'e') ADVANCE(1706);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 896:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'e') ADVANCE(1055);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 897:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'e') ADVANCE(879);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 898:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'e') ADVANCE(984);
      if (lookahead == 't') ADVANCE(833);
      if (lookahead == 'u') ADVANCE(1057);
      if (lookahead == 'w') ADVANCE(964);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 899:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'e') ADVANCE(984);
      if (lookahead == 't') ADVANCE(1068);
      if (lookahead == 'u') ADVANCE(1057);
      if (lookahead == 'w') ADVANCE(964);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 900:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'e') ADVANCE(1060);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 901:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'e') ADVANCE(867);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 902:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'e') ADVANCE(823);
      if (lookahead == 'h') ADVANCE(958);
      if (lookahead == 'i') ADVANCE(998);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 903:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'e') ADVANCE(823);
      if (lookahead == 'h') ADVANCE(958);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 904:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'e') ADVANCE(868);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 905:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'e') ADVANCE(877);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 906:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'e') ADVANCE(1010);
      if (lookahead == 't') ADVANCE(959);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 907:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'e') ADVANCE(869);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 908:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'e') ADVANCE(941);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 909:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'e') ADVANCE(1024);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 910:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'e') ADVANCE(870);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 911:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'e') ADVANCE(1029);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 912:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'e') ADVANCE(842);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 913:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'e') ADVANCE(1079);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 914:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'e') ADVANCE(1065);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 915:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'e') ADVANCE(827);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 916:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'e') ADVANCE(996);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 917:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'e') ADVANCE(1103);
      if (lookahead == 'u') ADVANCE(829);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 918:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'e') ADVANCE(1104);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 919:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'e') ADVANCE(1105);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 920:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'e') ADVANCE(1081);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 921:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'e') ADVANCE(933);
      if (lookahead == 'i') ADVANCE(1138);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 922:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'e') ADVANCE(837);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 923:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'e') ADVANCE(862);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 924:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'e') ADVANCE(1028);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 925:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'e') ADVANCE(1031);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 926:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'f') ADVANCE(1659);
      if (lookahead == 'm') ADVANCE(1059);
      if (lookahead == 'n') ADVANCE(873);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 927:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'f') ADVANCE(1659);
      if (lookahead == 'n') ADVANCE(874);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 928:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'f') ADVANCE(1659);
      if (lookahead == 'n') ADVANCE(1689);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 929:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'f') ADVANCE(1659);
      if (lookahead == 'n') ADVANCE(1690);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 930:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'f') ADVANCE(1659);
      if (lookahead == 'n') ADVANCE(875);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 931:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'f') ADVANCE(1698);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 932:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'f') ADVANCE(1147);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 933:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'f') ADVANCE(954);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 934:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'f') ADVANCE(956);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 935:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'g') ADVANCE(1872);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 936:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'g') ADVANCE(1906);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 937:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'g') ADVANCE(1909);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 938:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'g') ADVANCE(1875);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 939:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'g') ADVANCE(944);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 940:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'g') ADVANCE(885);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 941:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'g') ADVANCE(1071);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 942:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'h') ADVANCE(1556);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 943:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'h') ADVANCE(1662);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 944:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'h') ADVANCE(1709);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 945:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'h') ADVANCE(1066);
      if (lookahead == 'r') ADVANCE(1127);
      if (lookahead == 'y') ADVANCE(1058);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 946:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'h') ADVANCE(1074);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 947:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'i') ADVANCE(1086);
      if (lookahead == 'o') ADVANCE(1712);
      if (lookahead == 'y') ADVANCE(1021);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 948:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'i') ADVANCE(1143);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 949:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'i') ADVANCE(871);
      if (lookahead == 'o') ADVANCE(1712);
      if (lookahead == 'y') ADVANCE(1021);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 950:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'i') ADVANCE(982);
      if (lookahead == 'o') ADVANCE(1009);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 951:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'i') ADVANCE(982);
      if (lookahead == 'o') ADVANCE(1019);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 952:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'i') ADVANCE(982);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 953:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'i') ADVANCE(847);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 954:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'i') ADVANCE(1144);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 955:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'i') ADVANCE(932);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 956:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'i') ADVANCE(1145);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 957:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'i') ADVANCE(1091);
      if (lookahead == 'm') ADVANCE(1137);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 958:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'i') ADVANCE(997);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 959:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'i') ADVANCE(1050);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 960:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'i') ADVANCE(1072);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 961:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'i') ADVANCE(854);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 962:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'i') ADVANCE(1049);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 963:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'i') ADVANCE(1016);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 964:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'i') ADVANCE(1120);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 965:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'i') ADVANCE(855);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 966:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'i') ADVANCE(1017);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 967:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'i') ADVANCE(831);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 968:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'i') ADVANCE(1097);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 969:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'i') ADVANCE(856);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 970:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'i') ADVANCE(1020);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 971:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'i') ADVANCE(1022);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 972:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'i') ADVANCE(1026);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 973:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'i') ADVANCE(916);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 974:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'i') ADVANCE(876);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 975:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'i') ADVANCE(1076);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 976:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'i') ADVANCE(843);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 977:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'i') ADVANCE(925);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 978:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'i') ADVANCE(1139);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 979:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'k') ADVANCE(1898);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 980:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'k') ADVANCE(1758);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 981:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'k') ADVANCE(819);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 982:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'l') ADVANCE(1568);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 983:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'l') ADVANCE(931);
      if (lookahead == 't') ADVANCE(1820);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 984:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'l') ADVANCE(931);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 985:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'l') ADVANCE(1890);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 986:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'l') ADVANCE(1863);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 987:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'l') ADVANCE(1884);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 988:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'l') ADVANCE(1779);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 989:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'l') ADVANCE(999);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 990:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'l') ADVANCE(820);
      if (lookahead == 'o') ADVANCE(1008);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 991:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'l') ADVANCE(820);
      if (lookahead == 'o') ADVANCE(1012);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 992:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'l') ADVANCE(820);
      if (lookahead == 'o') ADVANCE(1014);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 993:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'l') ADVANCE(1092);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 994:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'l') ADVANCE(900);
      if (lookahead == 'n') ADVANCE(830);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 995:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'l') ADVANCE(961);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 996:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'l') ADVANCE(872);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 997:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'l') ADVANCE(884);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 998:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'l') ADVANCE(1000);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 999:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'l') ADVANCE(1109);
      if (lookahead == 's') ADVANCE(883);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1000:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'l') ADVANCE(814);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1001:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'l') ADVANCE(967);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1002:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'l') ADVANCE(844);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1003:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'm') ADVANCE(1776);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1004:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'm') ADVANCE(1046);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1005:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'm') ADVANCE(970);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1006:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'm') ADVANCE(1137);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1007:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'm') ADVANCE(969);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1008:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'n') ADVANCE(1089);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1009:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'n') ADVANCE(957);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1010:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'n') ADVANCE(1869);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1011:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'n') ADVANCE(1801);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1012:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'n') ADVANCE(1087);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1013:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'n') ADVANCE(1754);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1014:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'n') ADVANCE(1088);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1015:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'n') ADVANCE(1036);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1016:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'n') ADVANCE(935);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1017:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'n') ADVANCE(936);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1018:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'n') ADVANCE(852);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1019:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'n') ADVANCE(1006);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1020:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'n') ADVANCE(937);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1021:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'n') ADVANCE(822);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1022:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'n') ADVANCE(938);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1023:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'n') ADVANCE(830);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1024:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'n') ADVANCE(1094);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1025:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'n') ADVANCE(853);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1026:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'n') ADVANCE(1132);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1027:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'n') ADVANCE(901);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1028:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'n') ADVANCE(863);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1029:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'n') ADVANCE(977);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1030:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'n') ADVANCE(832);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1031:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'n') ADVANCE(864);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1032:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'n') ADVANCE(834);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1033:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'o') ADVANCE(1080);
      if (lookahead == 'r') ADVANCE(915);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1034:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'o') ADVANCE(1080);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1035:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'o') ADVANCE(1712);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1036:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'o') ADVANCE(1141);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1037:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'o') ADVANCE(1797);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1038:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'o') ADVANCE(1140);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1039:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'o') ADVANCE(1142);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1040:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'o') ADVANCE(858);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1041:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'o') ADVANCE(1064);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1042:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'o') ADVANCE(1002);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1043:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'o') ADVANCE(1126);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1044:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'o') ADVANCE(1075);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1045:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'o') ADVANCE(859);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1046:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'o') ADVANCE(878);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1047:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'o') ADVANCE(988);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1048:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'o') ADVANCE(1129);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1049:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'o') ADVANCE(1011);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1050:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'o') ADVANCE(1032);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1051:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'p') ADVANCE(906);
      if (lookahead == 'v') ADVANCE(920);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1052:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'p') ADVANCE(1835);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1053:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'p') ADVANCE(922);
      if (lookahead == 'q') ADVANCE(1136);
      if (lookahead == 't') ADVANCE(1131);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1054:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'p') ADVANCE(922);
      if (lookahead == 'q') ADVANCE(1136);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1055:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'p') ADVANCE(922);
      if (lookahead == 't') ADVANCE(1131);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1056:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'p') ADVANCE(890);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1057:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'p') ADVANCE(914);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1058:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'p') ADVANCE(912);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1059:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'p') ADVANCE(1044);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1060:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'p') ADVANCE(1077);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1061:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'r') ADVANCE(1748);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1062:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'r') ADVANCE(1785);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1063:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'r') ADVANCE(866);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1064:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'r') ADVANCE(1550);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1065:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'r') ADVANCE(1701);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1066:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'r') ADVANCE(1038);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1067:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'r') ADVANCE(1039);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1068:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'r') ADVANCE(1128);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1069:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'r') ADVANCE(1037);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1070:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'r') ADVANCE(953);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1071:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'r') ADVANCE(1043);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1072:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'r') ADVANCE(923);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1073:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'r') ADVANCE(974);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1074:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'r') ADVANCE(1048);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1075:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'r') ADVANCE(1099);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1076:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'r') ADVANCE(904);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1077:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'r') ADVANCE(978);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1078:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'r') ADVANCE(1013);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1079:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'r') ADVANCE(1030);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1080:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'r') ADVANCE(1067);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1081:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'r') ADVANCE(1073);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1082:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 's') ADVANCE(1773);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1083:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 's') ADVANCE(1767);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1084:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 's') ADVANCE(1040);
      if (lookahead == 'y') ADVANCE(1025);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1085:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 's') ADVANCE(1082);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1086:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 's') ADVANCE(1111);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1087:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 's') ADVANCE(1134);
      if (lookahead == 't') ADVANCE(972);
      if (lookahead == 'v') ADVANCE(911);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1088:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 's') ADVANCE(1134);
      if (lookahead == 't') ADVANCE(972);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1089:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 's') ADVANCE(1134);
      if (lookahead == 'v') ADVANCE(911);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1090:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 's') ADVANCE(1107);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1091:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 's') ADVANCE(1042);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1092:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 's') ADVANCE(883);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1093:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 's') ADVANCE(895);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1094:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 's') ADVANCE(962);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1095:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 't') ADVANCE(1782);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1096:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 't') ADVANCE(1810);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1097:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 't') ADVANCE(1673);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1098:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 't') ADVANCE(1893);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1099:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 't') ADVANCE(1764);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1100:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 't') ADVANCE(1562);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1101:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 't') ADVANCE(1770);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1102:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 't') ADVANCE(1804);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1103:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 't') ADVANCE(1817);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1104:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 't') ADVANCE(1794);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1105:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 't') ADVANCE(1791);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1106:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 't') ADVANCE(1149);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1107:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 't') ADVANCE(934);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1108:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 't') ADVANCE(909);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1109:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 't') ADVANCE(946);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1110:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 't') ADVANCE(835);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1111:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 't') ADVANCE(1070);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1112:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 't') ADVANCE(963);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1113:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 't') ADVANCE(886);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1114:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 't') ADVANCE(905);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1115:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 't') ADVANCE(971);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1116:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 't') ADVANCE(907);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1117:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 't') ADVANCE(910);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1118:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 't') ADVANCE(889);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1119:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 't') ADVANCE(1041);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1120:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 't') ADVANCE(857);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1121:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 't') ADVANCE(1045);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1122:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 't') ADVANCE(965);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1123:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 't') ADVANCE(838);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1124:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'u') ADVANCE(1003);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1125:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'u') ADVANCE(1110);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1126:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'u') ADVANCE(1052);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1127:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'u') ADVANCE(882);
      if (lookahead == 'y') ADVANCE(1715);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1128:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'u') ADVANCE(861);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1129:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'u') ADVANCE(939);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1130:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'u') ADVANCE(1098);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1131:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'u') ADVANCE(1078);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1132:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'u') ADVANCE(894);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1133:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'u') ADVANCE(829);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1134:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'u') ADVANCE(1005);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1135:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'u') ADVANCE(1116);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1136:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'u') ADVANCE(975);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1137:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'u') ADVANCE(1123);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1138:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'v') ADVANCE(840);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1139:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'v') ADVANCE(845);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1140:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'w') ADVANCE(1752);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1141:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'w') ADVANCE(1027);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1142:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'w') ADVANCE(966);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1143:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'x') ADVANCE(1828);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1144:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'x') ADVANCE(1825);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1145:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'x') ADVANCE(1831);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1146:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'y') ADVANCE(1559);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1147:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'y') ADVANCE(1823);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1148:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'y') ADVANCE(1025);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1149:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'y') ADVANCE(1056);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1150:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'z') ADVANCE(1146);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'y')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1151:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1152:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'S') ADVANCE(1271);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1153:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'S') ADVANCE(1272);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1154:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'a') ADVANCE(1464);
      if (lookahead == 'l') ADVANCE(1172);
      if (lookahead == 'o') ADVANCE(1365);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1155:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'a') ADVANCE(1464);
      if (lookahead == 'o') ADVANCE(1389);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1156:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'a') ADVANCE(1202);
      if (lookahead == 'n') ADVANCE(1512);
      if (lookahead == 'x') ADVANCE(1491);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1157:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'a') ADVANCE(1202);
      if (lookahead == 'n') ADVANCE(1512);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1158:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'a') ADVANCE(1202);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1159:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'a') ADVANCE(1356);
      if (lookahead == 'i') ADVANCE(1349);
      if (lookahead == 'u') ADVANCE(1381);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1160:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'a') ADVANCE(1356);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1161:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'a') ADVANCE(1540);
      if (lookahead == 'e') ADVANCE(1476);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1162:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'a') ADVANCE(1540);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1163:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'a') ADVANCE(1296);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1164:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'a') ADVANCE(1437);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1165:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'a') ADVANCE(1203);
      if (lookahead == 'o') ADVANCE(1470);
      if (lookahead == 'r') ADVANCE(1231);
      if (lookahead == 'u') ADVANCE(1193);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1166:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'a') ADVANCE(1203);
      if (lookahead == 'o') ADVANCE(1470);
      if (lookahead == 'r') ADVANCE(1275);
      if (lookahead == 'u') ADVANCE(1193);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1167:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'a') ADVANCE(1203);
      if (lookahead == 'o') ADVANCE(1470);
      if (lookahead == 'r') ADVANCE(1274);
      if (lookahead == 'u') ADVANCE(1193);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1168:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'a') ADVANCE(1203);
      if (lookahead == 'r') ADVANCE(1414);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1169:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'a') ADVANCE(1203);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1170:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'a') ADVANCE(1363);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1171:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'a') ADVANCE(1336);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1172:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'a') ADVANCE(1468);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1173:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'a') ADVANCE(1341);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1174:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'a') ADVANCE(1342);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1175:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'a') ADVANCE(1462);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1176:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'a') ADVANCE(1343);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1177:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'a') ADVANCE(1504);
      if (lookahead == 'r') ADVANCE(1516);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1178:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'a') ADVANCE(1504);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1179:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'a') ADVANCE(1345);
      if (lookahead == 'i') ADVANCE(1349);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1180:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'a') ADVANCE(1351);
      if (lookahead == 'i') ADVANCE(1349);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1181:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'a') ADVANCE(1501);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1182:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'a') ADVANCE(1218);
      if (lookahead == 'u') ADVANCE(1493);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1183:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'a') ADVANCE(1482);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1184:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'a') ADVANCE(1495);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1185:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'a') ADVANCE(1322);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1186:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'a') ADVANCE(1353);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1187:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'a') ADVANCE(1496);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1188:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'a') ADVANCE(1498);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1189:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'a') ADVANCE(1499);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1190:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'a') ADVANCE(1508);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1191:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'b') ADVANCE(1471);
      if (lookahead == 'p') ADVANCE(1264);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1192:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'b') ADVANCE(1471);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1193:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'b') ADVANCE(1350);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1194:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'b') ADVANCE(1522);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1195:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'c') ADVANCE(1500);
      if (lookahead == 'n') ADVANCE(1535);
      if (lookahead == 's') ADVANCE(1463);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1196:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'c') ADVANCE(1500);
      if (lookahead == 'n') ADVANCE(1535);
      if (lookahead == 's') ADVANCE(1538);
      if (lookahead == 'w') ADVANCE(1185);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1197:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'c') ADVANCE(1500);
      if (lookahead == 'n') ADVANCE(1535);
      if (lookahead == 's') ADVANCE(1538);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1198:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'c') ADVANCE(1500);
      if (lookahead == 's') ADVANCE(1463);
      if (lookahead == 'w') ADVANCE(1185);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1199:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'c') ADVANCE(1500);
      if (lookahead == 's') ADVANCE(1463);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1200:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'c') ADVANCE(1500);
      if (lookahead == 's') ADVANCE(1538);
      if (lookahead == 'w') ADVANCE(1185);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1201:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'c') ADVANCE(1500);
      if (lookahead == 's') ADVANCE(1538);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1202:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'c') ADVANCE(1298);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1203:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'c') ADVANCE(1337);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1204:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'c') ADVANCE(1789);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1205:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'c') ADVANCE(1554);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1206:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'c') ADVANCE(1858);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1207:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'c') ADVANCE(1879);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1208:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'c') ADVANCE(1882);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1209:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'c') ADVANCE(1299);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1210:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'c') ADVANCE(1334);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1211:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'c') ADVANCE(1235);
      if (lookahead == 'f') ADVANCE(1310);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1212:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'c') ADVANCE(1483);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1213:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'c') ADVANCE(1484);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1214:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'c') ADVANCE(1259);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1215:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'c') ADVANCE(1239);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1216:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'c') ADVANCE(1416);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1217:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'c') ADVANCE(1417);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1218:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'c') ADVANCE(1452);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1219:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'c') ADVANCE(1456);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1220:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'd') ADVANCE(1902);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1221:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'd') ADVANCE(1852);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1222:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'd') ADVANCE(1888);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1223:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'd') ADVANCE(1855);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1224:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'd') ADVANCE(1152);
      if (lookahead == 's') ADVANCE(1492);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1225:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'd') ADVANCE(1318);
      if (lookahead == 'f') ADVANCE(1304);
      if (lookahead == 'i') ADVANCE(1477);
      if (lookahead == 'o') ADVANCE(1521);
      if (lookahead == 't') ADVANCE(1262);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1226:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'd') ADVANCE(1238);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1227:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'd') ADVANCE(1488);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1228:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'd') ADVANCE(1269);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1229:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(1317);
      if (lookahead == 'i') ADVANCE(1467);
      if (lookahead == 'y') ADVANCE(1384);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1230:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(1429);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1231:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(1211);
      if (lookahead == 'i') ADVANCE(1525);
      if (lookahead == 'o') ADVANCE(1503);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1232:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(1707);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1233:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(1580);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1234:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(1583);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1235:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(1228);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1236:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(1566);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1237:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(1861);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1238:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(1846);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1239:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(1849);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1240:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(1867);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1241:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(1839);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1242:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(1654);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1243:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(1339);
      if (lookahead == 'u') ADVANCE(1431);
      if (lookahead == 'w') ADVANCE(1320);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1244:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(1648);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1245:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(1220);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1246:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(1340);
      if (lookahead == 'o') ADVANCE(1362);
      if (lookahead == 'u') ADVANCE(1431);
      if (lookahead == 'w') ADVANCE(1320);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1247:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(1340);
      if (lookahead == 't') ADVANCE(1177);
      if (lookahead == 'u') ADVANCE(1191);
      if (lookahead == 'w') ADVANCE(1320);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1248:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(1340);
      if (lookahead == 't') ADVANCE(1177);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1249:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(1340);
      if (lookahead == 't') ADVANCE(1444);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1250:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(1340);
      if (lookahead == 't') ADVANCE(1178);
      if (lookahead == 'u') ADVANCE(1431);
      if (lookahead == 'w') ADVANCE(1320);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1251:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(1340);
      if (lookahead == 'u') ADVANCE(1431);
      if (lookahead == 'w') ADVANCE(1320);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1252:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(1340);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1253:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(1434);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1254:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(1221);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1255:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(1171);
      if (lookahead == 'i') ADVANCE(1352);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1256:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(1171);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1257:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(1227);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1258:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(1222);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1259:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(1297);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1260:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(1223);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1261:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(1367);
      if (lookahead == 't') ADVANCE(1313);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1262:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(1457);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1263:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(1388);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1264:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(1439);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1265:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(1186);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1266:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(1395);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1267:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(1440);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1268:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(1441);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1269:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(1396);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1270:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(1509);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1271:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(1486);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1272:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(1487);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1273:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(1458);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1274:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(1289);
      if (lookahead == 'i') ADVANCE(1525);
      if (lookahead == 'o') ADVANCE(1503);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1275:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(1289);
      if (lookahead == 'i') ADVANCE(1525);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1276:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(1213);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1277:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(1183);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1278:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(1397);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1279:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(1430);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1280:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'f') ADVANCE(1660);
      if (lookahead == 'm') ADVANCE(1432);
      if (lookahead == 'n') ADVANCE(1225);
      if (lookahead == 's') ADVANCE(1730);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1281:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'f') ADVANCE(1660);
      if (lookahead == 'n') ADVANCE(1288);
      if (lookahead == 's') ADVANCE(1730);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1282:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'f') ADVANCE(1660);
      if (lookahead == 'n') ADVANCE(1288);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1283:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'f') ADVANCE(1660);
      if (lookahead == 'n') ADVANCE(1696);
      if (lookahead == 's') ADVANCE(1730);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1284:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'f') ADVANCE(1660);
      if (lookahead == 'n') ADVANCE(1420);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1285:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'f') ADVANCE(1660);
      if (lookahead == 's') ADVANCE(1730);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1286:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'f') ADVANCE(1660);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1287:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'f') ADVANCE(1699);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1288:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'f') ADVANCE(1304);
      if (lookahead == 'o') ADVANCE(1521);
      if (lookahead == 't') ADVANCE(1262);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1289:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'f') ADVANCE(1310);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1290:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'f') ADVANCE(1311);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1291:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'g') ADVANCE(1873);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1292:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'g') ADVANCE(1907);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1293:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'g') ADVANCE(1910);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1294:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'g') ADVANCE(1876);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1295:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'g') ADVANCE(1300);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1296:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'g') ADVANCE(1236);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1297:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'g') ADVANCE(1446);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1298:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'h') ADVANCE(1557);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1299:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'h') ADVANCE(1663);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1300:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'h') ADVANCE(1710);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1301:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'h') ADVANCE(1448);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1302:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'i') ADVANCE(1349);
      if (lookahead == 'u') ADVANCE(1381);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1303:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'i') ADVANCE(1349);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1304:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'i') ADVANCE(1530);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1305:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'i') ADVANCE(1224);
      if (lookahead == 'y') ADVANCE(1384);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1306:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'i') ADVANCE(1467);
      if (lookahead == 'y') ADVANCE(1384);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1307:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'i') ADVANCE(1338);
      if (lookahead == 'o') ADVANCE(1366);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1308:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'i') ADVANCE(1338);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1309:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'i') ADVANCE(1194);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1310:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'i') ADVANCE(1531);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1311:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'i') ADVANCE(1532);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1312:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'i') ADVANCE(1426);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1313:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'i') ADVANCE(1421);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1314:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'i') ADVANCE(1477);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1315:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'i') ADVANCE(1469);
      if (lookahead == 'm') ADVANCE(1524);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1316:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'i') ADVANCE(1418);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1317:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'i') ADVANCE(1398);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1318:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'i') ADVANCE(1451);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1319:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'i') ADVANCE(1206);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1320:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'i') ADVANCE(1502);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1321:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'i') ADVANCE(1207);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1322:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'i') ADVANCE(1478);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1323:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'i') ADVANCE(1208);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1324:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'i') ADVANCE(1380);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1325:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1326:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'i') ADVANCE(1383);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1327:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'i') ADVANCE(1480);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1328:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'i') ADVANCE(1386);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1329:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'i') ADVANCE(1226);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1330:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'i') ADVANCE(1175);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1331:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'i') ADVANCE(1454);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1332:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'i') ADVANCE(1387);
      if (lookahead == 'u') ADVANCE(1381);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1333:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'i') ADVANCE(1278);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1334:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'i') ADVANCE(1187);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1335:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'i') ADVANCE(1526);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1336:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'k') ADVANCE(1899);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1337:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'k') ADVANCE(1163);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1338:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'l') ADVANCE(1569);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1339:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'l') ADVANCE(1287);
      if (lookahead == 't') ADVANCE(1507);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1340:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'l') ADVANCE(1287);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1341:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'l') ADVANCE(1891);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1342:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'l') ADVANCE(1864);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1343:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'l') ADVANCE(1885);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1344:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'l') ADVANCE(1780);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1345:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'l') ADVANCE(1354);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1346:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'l') ADVANCE(1650);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1347:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'l') ADVANCE(1172);
      if (lookahead == 'o') ADVANCE(1365);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1348:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'l') ADVANCE(1172);
      if (lookahead == 'o') ADVANCE(1389);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1349:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'l') ADVANCE(1253);
      if (lookahead == 'n') ADVANCE(1173);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1350:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'l') ADVANCE(1319);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1351:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'l') ADVANCE(1355);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1352:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'l') ADVANCE(1357);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1353:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'l') ADVANCE(1330);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1354:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'l') ADVANCE(1490);
      if (lookahead == 's') ADVANCE(1234);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1355:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'l') ADVANCE(1490);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1356:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'l') ADVANCE(1472);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1357:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'l') ADVANCE(1153);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1358:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'l') ADVANCE(1188);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1359:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'm') ADVANCE(1432);
      if (lookahead == 'n') ADVANCE(1225);
      if (lookahead == 's') ADVANCE(1730);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1360:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'm') ADVANCE(1432);
      if (lookahead == 'n') ADVANCE(1225);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1361:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'm') ADVANCE(1777);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1362:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'm') ADVANCE(1242);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1363:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'm') ADVANCE(1323);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1364:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'm') ADVANCE(1326);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1365:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'n') ADVANCE(1465);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1366:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'n') ADVANCE(1315);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1367:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'n') ADVANCE(1870);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1368:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'n') ADVANCE(1802);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1369:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'n') ADVANCE(1288);
      if (lookahead == 's') ADVANCE(1730);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1370:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'n') ADVANCE(1288);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1371:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'n') ADVANCE(1696);
      if (lookahead == 's') ADVANCE(1730);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1372:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'n') ADVANCE(1696);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1373:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'n') ADVANCE(1691);
      if (lookahead == 's') ADVANCE(1730);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1374:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'n') ADVANCE(1691);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1375:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'n') ADVANCE(1694);
      if (lookahead == 's') ADVANCE(1730);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1376:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'n') ADVANCE(1692);
      if (lookahead == 's') ADVANCE(1730);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1377:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'n') ADVANCE(1692);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1378:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'n') ADVANCE(1695);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1379:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'n') ADVANCE(1401);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1380:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'n') ADVANCE(1291);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1381:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'n') ADVANCE(1204);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1382:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'n') ADVANCE(1292);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1383:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'n') ADVANCE(1293);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1384:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'n') ADVANCE(1170);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1385:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'n') ADVANCE(1205);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1386:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'n') ADVANCE(1294);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1387:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'n') ADVANCE(1173);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1388:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'n') ADVANCE(1473);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1389:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'n') ADVANCE(1466);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1390:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'n') ADVANCE(1420);
      if (lookahead == 's') ADVANCE(1730);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1391:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'n') ADVANCE(1420);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1392:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'n') ADVANCE(1174);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1393:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'n') ADVANCE(1245);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1394:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'n') ADVANCE(1176);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1395:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'n') ADVANCE(1333);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1396:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'n') ADVANCE(1214);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1397:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'n') ADVANCE(1215);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1398:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'n') ADVANCE(1327);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1399:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'n') ADVANCE(1314);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1400:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'o') ADVANCE(1442);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1401:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'o') ADVANCE(1528);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1402:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'o') ADVANCE(1798);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1403:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'o') ADVANCE(1529);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1404:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'o') ADVANCE(1438);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1405:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'o') ADVANCE(1210);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1406:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'o') ADVANCE(1362);
      if (lookahead == 't') ADVANCE(1177);
      if (lookahead == 'u') ADVANCE(1192);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1407:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'o') ADVANCE(1362);
      if (lookahead == 't') ADVANCE(1178);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1408:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'o') ADVANCE(1362);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1409:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'o') ADVANCE(1366);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1410:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'o') ADVANCE(1517);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1411:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'o') ADVANCE(1455);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1412:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'o') ADVANCE(1358);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1413:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'o') ADVANCE(1518);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1414:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'o') ADVANCE(1503);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1415:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'o') ADVANCE(1216);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1416:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'o') ADVANCE(1344);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1417:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'o') ADVANCE(1346);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1418:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'o') ADVANCE(1368);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1419:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'o') ADVANCE(1389);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1420:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'o') ADVANCE(1521);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1421:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'o') ADVANCE(1394);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1422:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'o') ADVANCE(1217);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1423:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'o') ADVANCE(1510);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1424:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'p') ADVANCE(1261);
      if (lookahead == 'v') ADVANCE(1273);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1425:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'p') ADVANCE(1836);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1426:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'p') ADVANCE(1485);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1427:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'p') ADVANCE(1241);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1428:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'p') ADVANCE(1244);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1429:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'p') ADVANCE(1277);
      if (lookahead == 'q') ADVANCE(1523);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1430:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'p') ADVANCE(1277);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1431:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'p') ADVANCE(1264);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1432:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'p') ADVANCE(1411);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1433:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'p') ADVANCE(1265);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1434:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'p') ADVANCE(1453);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1435:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'r') ADVANCE(1519);
      if (lookahead == 'y') ADVANCE(1433);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1436:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'r') ADVANCE(1519);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1437:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'r') ADVANCE(1786);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1438:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'r') ADVANCE(1551);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1439:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'r') ADVANCE(1702);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1440:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'r') ADVANCE(811);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1441:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'r') ADVANCE(812);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1442:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'r') ADVANCE(1443);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1443:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'r') ADVANCE(1403);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1444:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'r') ADVANCE(1516);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1445:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'r') ADVANCE(1533);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1446:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'r') ADVANCE(1410);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1447:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'r') ADVANCE(1520);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1448:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'r') ADVANCE(1413);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1449:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'r') ADVANCE(1309);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1450:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'r') ADVANCE(1329);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1451:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'r') ADVANCE(1276);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1452:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'r') ADVANCE(1402);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1453:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'r') ADVANCE(1335);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1454:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'r') ADVANCE(1254);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1455:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'r') ADVANCE(1481);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1456:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'r') ADVANCE(1312);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1457:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'r') ADVANCE(1392);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1458:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'r') ADVANCE(1450);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1459:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'r') ADVANCE(1423);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1460:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 's') ADVANCE(1730);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1461:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 's') ADVANCE(1774);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1462:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 's') ADVANCE(1768);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1463:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 's') ADVANCE(1405);
      if (lookahead == 'y') ADVANCE(1385);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1464:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 's') ADVANCE(1232);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1465:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 's') ADVANCE(1513);
      if (lookahead == 'v') ADVANCE(1266);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1466:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 's') ADVANCE(1513);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1467:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 's') ADVANCE(1492);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1468:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 's') ADVANCE(1461);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1469:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 's') ADVANCE(1412);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1470:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 's') ADVANCE(1489);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1471:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 's') ADVANCE(1219);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1472:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 's') ADVANCE(1234);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1473:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 's') ADVANCE(1316);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1474:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 't') ADVANCE(1177);
      if (lookahead == 'u') ADVANCE(1192);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1475:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 't') ADVANCE(1177);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1476:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 't') ADVANCE(1783);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1477:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 't') ADVANCE(1811);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1478:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 't') ADVANCE(1674);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1479:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 't') ADVANCE(1894);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1480:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 't') ADVANCE(1813);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1481:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 't') ADVANCE(1765);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1482:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 't') ADVANCE(1563);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1483:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 't') ADVANCE(1771);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1484:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 't') ADVANCE(1805);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1485:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 't') ADVANCE(1815);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1486:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 't') ADVANCE(1795);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1487:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 't') ADVANCE(1792);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1488:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 't') ADVANCE(1537);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1489:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 't') ADVANCE(1290);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1490:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 't') ADVANCE(1301);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1491:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 't') ADVANCE(1263);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1492:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 't') ADVANCE(1449);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1493:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 't') ADVANCE(1181);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1494:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 't') ADVANCE(1444);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1495:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 't') ADVANCE(1237);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1496:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 't') ADVANCE(1257);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1497:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 't') ADVANCE(1258);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1498:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 't') ADVANCE(1260);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1499:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 't') ADVANCE(1240);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1500:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 't') ADVANCE(1404);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1501:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 't') ADVANCE(1324);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1502:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 't') ADVANCE(1209);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1503:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 't') ADVANCE(1415);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1504:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 't') ADVANCE(1321);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1505:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 't') ADVANCE(1267);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1506:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 't') ADVANCE(1178);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1507:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 't') ADVANCE(1268);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1508:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 't') ADVANCE(1328);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1509:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 't') ADVANCE(1505);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1510:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 't') ADVANCE(1422);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1511:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 't') ADVANCE(1190);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1512:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'u') ADVANCE(1361);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1513:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'u') ADVANCE(1364);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1514:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'u') ADVANCE(1381);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1515:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'u') ADVANCE(1493);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1516:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'u') ADVANCE(1212);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1517:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'u') ADVANCE(1425);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1518:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'u') ADVANCE(1295);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1519:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'u') ADVANCE(1233);
      if (lookahead == 'y') ADVANCE(1716);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1520:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'u') ADVANCE(1233);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1521:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'u') ADVANCE(1479);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1522:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'u') ADVANCE(1497);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1523:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'u') ADVANCE(1331);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1524:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'u') ADVANCE(1511);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1525:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'v') ADVANCE(1184);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1526:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'v') ADVANCE(1189);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1527:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'w') ADVANCE(1320);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1528:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1529:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'w') ADVANCE(1325);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1530:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'x') ADVANCE(1829);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1531:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'x') ADVANCE(1826);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1532:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'x') ADVANCE(1832);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1533:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'y') ADVANCE(1716);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1534:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'y') ADVANCE(1560);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1535:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'y') ADVANCE(1656);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1536:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'y') ADVANCE(1433);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1537:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'y') ADVANCE(1427);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1538:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'y') ADVANCE(1385);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1539:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'y') ADVANCE(1428);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1540:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'z') ADVANCE(1534);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1541:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 0x20e3) ADVANCE(1543);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_3, 912, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1542:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1543:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1544:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token2);
      END_STATE();
    case 1545:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token3);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1545);
      END_STATE();
    case 1546:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token4);
      if (lookahead == 0x20e3) ADVANCE(1548);
      if (lookahead == 0xfe0f) ADVANCE(1546);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1547);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_3, 912, lookahead)) ADVANCE(1547);
      END_STATE();
    case 1547:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token4);
      if (lookahead == 0xfe0f) ADVANCE(1546);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1547);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1547);
      END_STATE();
    case 1548:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token4);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1547);
      END_STATE();
    case 1549:
      ACCEPT_TOKEN(anon_sym_actor);
      END_STATE();
    case 1550:
      ACCEPT_TOKEN(anon_sym_actor);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1551:
      ACCEPT_TOKEN(anon_sym_actor);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1552:
      ACCEPT_TOKEN(anon_sym_async);
      END_STATE();
    case 1553:
      ACCEPT_TOKEN(anon_sym_async);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1554:
      ACCEPT_TOKEN(anon_sym_async);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1555:
      ACCEPT_TOKEN(anon_sym_each);
      END_STATE();
    case 1556:
      ACCEPT_TOKEN(anon_sym_each);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1557:
      ACCEPT_TOKEN(anon_sym_each);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1558:
      ACCEPT_TOKEN(anon_sym_lazy);
      END_STATE();
    case 1559:
      ACCEPT_TOKEN(anon_sym_lazy);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1560:
      ACCEPT_TOKEN(anon_sym_lazy);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1561:
      ACCEPT_TOKEN(anon_sym_repeat);
      END_STATE();
    case 1562:
      ACCEPT_TOKEN(anon_sym_repeat);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1563:
      ACCEPT_TOKEN(anon_sym_repeat);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1564:
      ACCEPT_TOKEN(anon_sym_package);
      END_STATE();
    case 1565:
      ACCEPT_TOKEN(anon_sym_package);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1566:
      ACCEPT_TOKEN(anon_sym_package);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1567:
      ACCEPT_TOKEN(anon_sym_nil);
      END_STATE();
    case 1568:
      ACCEPT_TOKEN(anon_sym_nil);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1569:
      ACCEPT_TOKEN(anon_sym_nil);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1570:
      ACCEPT_TOKEN(sym_real_literal);
      if (lookahead == '_') ADVANCE(186);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(745);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1570);
      END_STATE();
    case 1571:
      ACCEPT_TOKEN(sym_real_literal);
      if (lookahead == '_') ADVANCE(187);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1571);
      END_STATE();
    case 1572:
      ACCEPT_TOKEN(sym_integer_literal);
      ADVANCE_MAP(
        '.', 749,
        '_', 182,
        'B', 746,
        'b', 746,
        'E', 745,
        'e', 745,
        'O', 747,
        'o', 747,
        'X', 751,
        'x', 751,
      );
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1573);
      END_STATE();
    case 1573:
      ACCEPT_TOKEN(sym_integer_literal);
      if (lookahead == '.') ADVANCE(749);
      if (lookahead == '_') ADVANCE(182);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(745);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1573);
      END_STATE();
    case 1574:
      ACCEPT_TOKEN(sym_integer_literal);
      if (lookahead == '_') ADVANCE(188);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1574);
      END_STATE();
    case 1575:
      ACCEPT_TOKEN(sym_hex_literal);
      if (lookahead == '_') ADVANCE(185);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(1575);
      END_STATE();
    case 1576:
      ACCEPT_TOKEN(sym_oct_literal);
      if (lookahead == '_') ADVANCE(184);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(1576);
      END_STATE();
    case 1577:
      ACCEPT_TOKEN(sym_bin_literal);
      if (lookahead == '_') ADVANCE(183);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(1577);
      END_STATE();
    case 1578:
      ACCEPT_TOKEN(anon_sym_true);
      END_STATE();
    case 1579:
      ACCEPT_TOKEN(anon_sym_true);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1580:
      ACCEPT_TOKEN(anon_sym_true);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1581:
      ACCEPT_TOKEN(anon_sym_false);
      END_STATE();
    case 1582:
      ACCEPT_TOKEN(anon_sym_false);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1583:
      ACCEPT_TOKEN(anon_sym_false);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1584:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 1585:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      if (lookahead == '"') ADVANCE(111);
      END_STATE();
    case 1586:
      ACCEPT_TOKEN(aux_sym_line_str_text_token1);
      if (lookahead == '\n') ADVANCE(1621);
      if (lookahead == 'f') ADVANCE(1588);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(1588);
      END_STATE();
    case 1587:
      ACCEPT_TOKEN(aux_sym_line_str_text_token1);
      if (lookahead == '\n') ADVANCE(1621);
      if (lookahead == 'i') ADVANCE(1586);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(1588);
      END_STATE();
    case 1588:
      ACCEPT_TOKEN(aux_sym_line_str_text_token1);
      if (lookahead == '\n') ADVANCE(1621);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(1588);
      END_STATE();
    case 1589:
      ACCEPT_TOKEN(aux_sym_line_str_text_token1);
      if (lookahead == '#') ADVANCE(1597);
      if (lookahead == '/') ADVANCE(1590);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(1589);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '#' &&
          lookahead != '\\') ADVANCE(1621);
      END_STATE();
    case 1590:
      ACCEPT_TOKEN(aux_sym_line_str_text_token1);
      if (lookahead == '/') ADVANCE(1588);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(1621);
      END_STATE();
    case 1591:
      ACCEPT_TOKEN(aux_sym_line_str_text_token1);
      if (lookahead == 'L') ADVANCE(1610);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(1621);
      END_STATE();
    case 1592:
      ACCEPT_TOKEN(aux_sym_line_str_text_token1);
      if (lookahead == 'a') ADVANCE(1618);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(1621);
      END_STATE();
    case 1593:
      ACCEPT_TOKEN(aux_sym_line_str_text_token1);
      if (lookahead == 'a') ADVANCE(1613);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(1621);
      END_STATE();
    case 1594:
      ACCEPT_TOKEN(aux_sym_line_str_text_token1);
      if (lookahead == 'c') ADVANCE(1592);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(1621);
      END_STATE();
    case 1595:
      ACCEPT_TOKEN(aux_sym_line_str_text_token1);
      if (lookahead == 'c') ADVANCE(1599);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(1621);
      END_STATE();
    case 1596:
      ACCEPT_TOKEN(aux_sym_line_str_text_token1);
      if (lookahead == 'd') ADVANCE(1602);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(1621);
      END_STATE();
    case 1597:
      ACCEPT_TOKEN(aux_sym_line_str_text_token1);
      if (lookahead == 'e') ADVANCE(1605);
      if (lookahead == 'i') ADVANCE(1600);
      if (lookahead == 's') ADVANCE(1609);
      if (lookahead == 'w') ADVANCE(1593);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(1621);
      END_STATE();
    case 1598:
      ACCEPT_TOKEN(aux_sym_line_str_text_token1);
      if (lookahead == 'e') ADVANCE(1587);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(1621);
      END_STATE();
    case 1599:
      ACCEPT_TOKEN(aux_sym_line_str_text_token1);
      if (lookahead == 'e') ADVANCE(1591);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(1621);
      END_STATE();
    case 1600:
      ACCEPT_TOKEN(aux_sym_line_str_text_token1);
      if (lookahead == 'f') ADVANCE(1588);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(1621);
      END_STATE();
    case 1601:
      ACCEPT_TOKEN(aux_sym_line_str_text_token1);
      if (lookahead == 'g') ADVANCE(1620);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(1621);
      END_STATE();
    case 1602:
      ACCEPT_TOKEN(aux_sym_line_str_text_token1);
      if (lookahead == 'i') ADVANCE(1600);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(1621);
      END_STATE();
    case 1603:
      ACCEPT_TOKEN(aux_sym_line_str_text_token1);
      if (lookahead == 'i') ADVANCE(1607);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(1621);
      END_STATE();
    case 1604:
      ACCEPT_TOKEN(aux_sym_line_str_text_token1);
      if (lookahead == 'i') ADVANCE(1611);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(1621);
      END_STATE();
    case 1605:
      ACCEPT_TOKEN(aux_sym_line_str_text_token1);
      if (lookahead == 'l') ADVANCE(1617);
      if (lookahead == 'n') ADVANCE(1596);
      if (lookahead == 'r') ADVANCE(1616);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(1621);
      END_STATE();
    case 1606:
      ACCEPT_TOKEN(aux_sym_line_str_text_token1);
      if (lookahead == 'n') ADVANCE(1620);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(1621);
      END_STATE();
    case 1607:
      ACCEPT_TOKEN(aux_sym_line_str_text_token1);
      if (lookahead == 'n') ADVANCE(1601);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(1621);
      END_STATE();
    case 1608:
      ACCEPT_TOKEN(aux_sym_line_str_text_token1);
      if (lookahead == 'n') ADVANCE(1603);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(1621);
      END_STATE();
    case 1609:
      ACCEPT_TOKEN(aux_sym_line_str_text_token1);
      if (lookahead == 'o') ADVANCE(1619);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(1621);
      END_STATE();
    case 1610:
      ACCEPT_TOKEN(aux_sym_line_str_text_token1);
      if (lookahead == 'o') ADVANCE(1594);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(1621);
      END_STATE();
    case 1611:
      ACCEPT_TOKEN(aux_sym_line_str_text_token1);
      if (lookahead == 'o') ADVANCE(1606);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(1621);
      END_STATE();
    case 1612:
      ACCEPT_TOKEN(aux_sym_line_str_text_token1);
      if (lookahead == 'o') ADVANCE(1615);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(1621);
      END_STATE();
    case 1613:
      ACCEPT_TOKEN(aux_sym_line_str_text_token1);
      if (lookahead == 'r') ADVANCE(1608);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(1621);
      END_STATE();
    case 1614:
      ACCEPT_TOKEN(aux_sym_line_str_text_token1);
      if (lookahead == 'r') ADVANCE(1595);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(1621);
      END_STATE();
    case 1615:
      ACCEPT_TOKEN(aux_sym_line_str_text_token1);
      if (lookahead == 'r') ADVANCE(1620);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(1621);
      END_STATE();
    case 1616:
      ACCEPT_TOKEN(aux_sym_line_str_text_token1);
      if (lookahead == 'r') ADVANCE(1612);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(1621);
      END_STATE();
    case 1617:
      ACCEPT_TOKEN(aux_sym_line_str_text_token1);
      if (lookahead == 's') ADVANCE(1598);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(1621);
      END_STATE();
    case 1618:
      ACCEPT_TOKEN(aux_sym_line_str_text_token1);
      if (lookahead == 't') ADVANCE(1604);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(1621);
      END_STATE();
    case 1619:
      ACCEPT_TOKEN(aux_sym_line_str_text_token1);
      if (lookahead == 'u') ADVANCE(1614);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(1621);
      END_STATE();
    case 1620:
      ACCEPT_TOKEN(aux_sym_line_str_text_token1);
      if (lookahead == '\n' ||
          lookahead == '\r') ADVANCE(1621);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(1620);
      END_STATE();
    case 1621:
      ACCEPT_TOKEN(aux_sym_line_str_text_token1);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(1621);
      END_STATE();
    case 1622:
      ACCEPT_TOKEN(anon_sym_BSLASH);
      END_STATE();
    case 1623:
      ACCEPT_TOKEN(anon_sym_BSLASH);
      ADVANCE_MAP(
        '(', 1630,
        '\n', 1632,
        '"', 1632,
        '\'', 1632,
        '0', 1632,
        '\\', 1632,
        'n', 1632,
        'r', 1632,
        't', 1632,
      );
      END_STATE();
    case 1624:
      ACCEPT_TOKEN(anon_sym_u);
      END_STATE();
    case 1625:
      ACCEPT_TOKEN(anon_sym_u);
      if (lookahead == 'n') ADVANCE(547);
      END_STATE();
    case 1626:
      ACCEPT_TOKEN(aux_sym__uni_character_literal_token1);
      END_STATE();
    case 1627:
      ACCEPT_TOKEN(anon_sym_DQUOTE_DQUOTE_DQUOTE);
      END_STATE();
    case 1628:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 1629:
      ACCEPT_TOKEN(sym_raw_str_interpolation_start);
      END_STATE();
    case 1630:
      ACCEPT_TOKEN(anon_sym_BSLASH_LPAREN);
      END_STATE();
    case 1631:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 1632:
      ACCEPT_TOKEN(sym__escaped_identifier);
      END_STATE();
    case 1633:
      ACCEPT_TOKEN(sym__extended_regex_literal);
      if (lookahead == '/') ADVANCE(113);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(160);
      END_STATE();
    case 1634:
      ACCEPT_TOKEN(aux_sym__multiline_regex_literal_token1);
      END_STATE();
    case 1635:
      ACCEPT_TOKEN(aux_sym__multiline_regex_literal_token2);
      END_STATE();
    case 1636:
      ACCEPT_TOKEN(sym__oneline_regex_literal);
      END_STATE();
    case 1637:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 1638:
      ACCEPT_TOKEN(anon_sym_BANG);
      END_STATE();
    case 1639:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '=') ADVANCE(1722);
      END_STATE();
    case 1640:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 1641:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 1642:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 1643:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 1644:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(153);
      END_STATE();
    case 1645:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(153);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1570);
      END_STATE();
    case 1646:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(152);
      END_STATE();
    case 1647:
      ACCEPT_TOKEN(anon_sym_Type);
      END_STATE();
    case 1648:
      ACCEPT_TOKEN(anon_sym_Type);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1649:
      ACCEPT_TOKEN(anon_sym_Protocol);
      END_STATE();
    case 1650:
      ACCEPT_TOKEN(anon_sym_Protocol);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1651:
      ACCEPT_TOKEN(anon_sym_QMARK);
      END_STATE();
    case 1652:
      ACCEPT_TOKEN(anon_sym_QMARK2);
      END_STATE();
    case 1653:
      ACCEPT_TOKEN(anon_sym_some);
      END_STATE();
    case 1654:
      ACCEPT_TOKEN(anon_sym_some);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1655:
      ACCEPT_TOKEN(anon_sym_any);
      END_STATE();
    case 1656:
      ACCEPT_TOKEN(anon_sym_any);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1657:
      ACCEPT_TOKEN(anon_sym_AMP);
      END_STATE();
    case 1658:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 1659:
      ACCEPT_TOKEN(anon_sym_if);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1660:
      ACCEPT_TOKEN(anon_sym_if);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1661:
      ACCEPT_TOKEN(anon_sym_switch);
      END_STATE();
    case 1662:
      ACCEPT_TOKEN(anon_sym_switch);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1663:
      ACCEPT_TOKEN(anon_sym_switch);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1664:
      ACCEPT_TOKEN(anon_sym_POUNDselector);
      END_STATE();
    case 1665:
      ACCEPT_TOKEN(anon_sym_getter_COLON);
      END_STATE();
    case 1666:
      ACCEPT_TOKEN(anon_sym_setter_COLON);
      END_STATE();
    case 1667:
      ACCEPT_TOKEN(aux_sym_custom_operator_token1);
      if (lookahead == '*') ADVANCE(1667);
      END_STATE();
    case 1668:
      ACCEPT_TOKEN(anon_sym_LT);
      END_STATE();
    case 1669:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(1744);
      if (lookahead == '=') ADVANCE(1725);
      END_STATE();
    case 1670:
      ACCEPT_TOKEN(anon_sym_GT);
      END_STATE();
    case 1671:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(1726);
      if (lookahead == '>') ADVANCE(1745);
      END_STATE();
    case 1672:
      ACCEPT_TOKEN(anon_sym_await);
      END_STATE();
    case 1673:
      ACCEPT_TOKEN(anon_sym_await);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1674:
      ACCEPT_TOKEN(anon_sym_await);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1675:
      ACCEPT_TOKEN(anon_sym_POUNDfile);
      if (lookahead == 'I') ADVANCE(174);
      if (lookahead == 'L') ADVANCE(448);
      if (lookahead == 'P') ADVANCE(224);
      END_STATE();
    case 1676:
      ACCEPT_TOKEN(anon_sym_POUNDfileID);
      END_STATE();
    case 1677:
      ACCEPT_TOKEN(anon_sym_POUNDfilePath);
      END_STATE();
    case 1678:
      ACCEPT_TOKEN(anon_sym_POUNDline);
      END_STATE();
    case 1679:
      ACCEPT_TOKEN(anon_sym_POUNDcolumn);
      END_STATE();
    case 1680:
      ACCEPT_TOKEN(anon_sym_POUNDfunction);
      END_STATE();
    case 1681:
      ACCEPT_TOKEN(anon_sym_POUNDdsohandle);
      END_STATE();
    case 1682:
      ACCEPT_TOKEN(anon_sym_POUNDcolorLiteral);
      END_STATE();
    case 1683:
      ACCEPT_TOKEN(anon_sym_POUNDfileLiteral);
      END_STATE();
    case 1684:
      ACCEPT_TOKEN(anon_sym_POUNDimageLiteral);
      END_STATE();
    case 1685:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 1686:
      ACCEPT_TOKEN(anon_sym_CARET_LBRACE);
      END_STATE();
    case 1687:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 1688:
      ACCEPT_TOKEN(anon_sym_in);
      END_STATE();
    case 1689:
      ACCEPT_TOKEN(anon_sym_in);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'd') ADVANCE(960);
      if (lookahead == 'f') ADVANCE(948);
      if (lookahead == 'o') ADVANCE(1130);
      if (lookahead == 't') ADVANCE(913);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1690:
      ACCEPT_TOKEN(anon_sym_in);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 'd') ADVANCE(960);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1691:
      ACCEPT_TOKEN(anon_sym_in);
      if (lookahead == 'd') ADVANCE(1318);
      if (lookahead == 'f') ADVANCE(1304);
      if (lookahead == 'o') ADVANCE(1521);
      if (lookahead == 't') ADVANCE(1262);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1692:
      ACCEPT_TOKEN(anon_sym_in);
      if (lookahead == 'd') ADVANCE(1318);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1693:
      ACCEPT_TOKEN(anon_sym_in);
      if (lookahead == 'd') ADVANCE(428);
      if (lookahead == 'f') ADVANCE(407);
      if (lookahead == 'o') ADVANCE(711);
      if (lookahead == 't') ADVANCE(351);
      END_STATE();
    case 1694:
      ACCEPT_TOKEN(anon_sym_in);
      if (lookahead == 'f') ADVANCE(1304);
      if (lookahead == 'o') ADVANCE(1521);
      if (lookahead == 't') ADVANCE(1262);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1695:
      ACCEPT_TOKEN(anon_sym_in);
      if (lookahead == 'o') ADVANCE(1521);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1696:
      ACCEPT_TOKEN(anon_sym_in);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1697:
      ACCEPT_TOKEN(anon_sym_self);
      END_STATE();
    case 1698:
      ACCEPT_TOKEN(anon_sym_self);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1699:
      ACCEPT_TOKEN(anon_sym_self);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1700:
      ACCEPT_TOKEN(anon_sym_super);
      END_STATE();
    case 1701:
      ACCEPT_TOKEN(anon_sym_super);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1702:
      ACCEPT_TOKEN(anon_sym_super);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1703:
      ACCEPT_TOKEN(anon_sym_guard);
      END_STATE();
    case 1704:
      ACCEPT_TOKEN(anon_sym_guard);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1705:
      ACCEPT_TOKEN(anon_sym_case);
      END_STATE();
    case 1706:
      ACCEPT_TOKEN(anon_sym_case);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1707:
      ACCEPT_TOKEN(anon_sym_case);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1708:
      ACCEPT_TOKEN(anon_sym_fallthrough);
      END_STATE();
    case 1709:
      ACCEPT_TOKEN(anon_sym_fallthrough);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1710:
      ACCEPT_TOKEN(anon_sym_fallthrough);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1711:
      ACCEPT_TOKEN(anon_sym_do);
      END_STATE();
    case 1712:
      ACCEPT_TOKEN(anon_sym_do);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1713:
      ACCEPT_TOKEN(anon_sym_POUNDkeyPath);
      END_STATE();
    case 1714:
      ACCEPT_TOKEN(anon_sym_try);
      END_STATE();
    case 1715:
      ACCEPT_TOKEN(anon_sym_try);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1716:
      ACCEPT_TOKEN(anon_sym_try);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1717:
      ACCEPT_TOKEN(anon_sym_PLUS_EQ);
      END_STATE();
    case 1718:
      ACCEPT_TOKEN(anon_sym_DASH_EQ);
      END_STATE();
    case 1719:
      ACCEPT_TOKEN(anon_sym_STAR_EQ);
      END_STATE();
    case 1720:
      ACCEPT_TOKEN(anon_sym_SLASH_EQ);
      END_STATE();
    case 1721:
      ACCEPT_TOKEN(anon_sym_PERCENT_EQ);
      END_STATE();
    case 1722:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      if (lookahead == '=') ADVANCE(1723);
      END_STATE();
    case 1723:
      ACCEPT_TOKEN(anon_sym_BANG_EQ_EQ);
      END_STATE();
    case 1724:
      ACCEPT_TOKEN(anon_sym_EQ_EQ_EQ);
      END_STATE();
    case 1725:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 1726:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 1727:
      ACCEPT_TOKEN(anon_sym_DOT_DOT_DOT);
      END_STATE();
    case 1728:
      ACCEPT_TOKEN(anon_sym_DOT_DOT_LT);
      END_STATE();
    case 1729:
      ACCEPT_TOKEN(anon_sym_is);
      END_STATE();
    case 1730:
      ACCEPT_TOKEN(anon_sym_is);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1731:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(1738);
      if (lookahead == '=') ADVANCE(1717);
      END_STATE();
    case 1732:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(1739);
      if (lookahead == '=') ADVANCE(1718);
      END_STATE();
    case 1733:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 1734:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '=') ADVANCE(1719);
      END_STATE();
    case 1735:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(1667);
      if (lookahead == '/') ADVANCE(807);
      if (lookahead == '=') ADVANCE(1720);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(744);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n') ADVANCE(159);
      END_STATE();
    case 1736:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(1667);
      if (lookahead == '/') ADVANCE(808);
      if (lookahead == '=') ADVANCE(1720);
      END_STATE();
    case 1737:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      if (lookahead == '=') ADVANCE(1721);
      END_STATE();
    case 1738:
      ACCEPT_TOKEN(anon_sym_PLUS_PLUS);
      END_STATE();
    case 1739:
      ACCEPT_TOKEN(anon_sym_DASH_DASH);
      END_STATE();
    case 1740:
      ACCEPT_TOKEN(anon_sym_TILDE);
      END_STATE();
    case 1741:
      ACCEPT_TOKEN(anon_sym_PIPE);
      END_STATE();
    case 1742:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 1743:
      ACCEPT_TOKEN(anon_sym_CARET);
      if (lookahead == '{') ADVANCE(1686);
      END_STATE();
    case 1744:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      END_STATE();
    case 1745:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      END_STATE();
    case 1746:
      ACCEPT_TOKEN(sym_statement_label);
      END_STATE();
    case 1747:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 1748:
      ACCEPT_TOKEN(anon_sym_for);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1749:
      ACCEPT_TOKEN(anon_sym_while);
      END_STATE();
    case 1750:
      ACCEPT_TOKEN(anon_sym_while);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1751:
      ACCEPT_TOKEN(sym_throw_keyword);
      END_STATE();
    case 1752:
      ACCEPT_TOKEN(sym_throw_keyword);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1753:
      ACCEPT_TOKEN(anon_sym_return);
      END_STATE();
    case 1754:
      ACCEPT_TOKEN(anon_sym_return);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1755:
      ACCEPT_TOKEN(anon_sym_continue);
      END_STATE();
    case 1756:
      ACCEPT_TOKEN(anon_sym_continue);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1757:
      ACCEPT_TOKEN(anon_sym_break);
      END_STATE();
    case 1758:
      ACCEPT_TOKEN(anon_sym_break);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1759:
      ACCEPT_TOKEN(anon_sym_yield);
      END_STATE();
    case 1760:
      ACCEPT_TOKEN(anon_sym_yield);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1761:
      ACCEPT_TOKEN(anon_sym_POUNDavailable);
      END_STATE();
    case 1762:
      ACCEPT_TOKEN(anon_sym_POUNDunavailable);
      END_STATE();
    case 1763:
      ACCEPT_TOKEN(anon_sym_import);
      END_STATE();
    case 1764:
      ACCEPT_TOKEN(anon_sym_import);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1765:
      ACCEPT_TOKEN(anon_sym_import);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1766:
      ACCEPT_TOKEN(anon_sym_typealias);
      END_STATE();
    case 1767:
      ACCEPT_TOKEN(anon_sym_typealias);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1768:
      ACCEPT_TOKEN(anon_sym_typealias);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1769:
      ACCEPT_TOKEN(anon_sym_struct);
      END_STATE();
    case 1770:
      ACCEPT_TOKEN(anon_sym_struct);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1771:
      ACCEPT_TOKEN(anon_sym_struct);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1772:
      ACCEPT_TOKEN(anon_sym_class);
      END_STATE();
    case 1773:
      ACCEPT_TOKEN(anon_sym_class);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1774:
      ACCEPT_TOKEN(anon_sym_class);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1775:
      ACCEPT_TOKEN(anon_sym_enum);
      END_STATE();
    case 1776:
      ACCEPT_TOKEN(anon_sym_enum);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1777:
      ACCEPT_TOKEN(anon_sym_enum);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1778:
      ACCEPT_TOKEN(anon_sym_protocol);
      END_STATE();
    case 1779:
      ACCEPT_TOKEN(anon_sym_protocol);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1780:
      ACCEPT_TOKEN(anon_sym_protocol);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1781:
      ACCEPT_TOKEN(anon_sym_let);
      END_STATE();
    case 1782:
      ACCEPT_TOKEN(anon_sym_let);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1783:
      ACCEPT_TOKEN(anon_sym_let);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1784:
      ACCEPT_TOKEN(anon_sym_var);
      END_STATE();
    case 1785:
      ACCEPT_TOKEN(anon_sym_var);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1786:
      ACCEPT_TOKEN(anon_sym_var);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1787:
      ACCEPT_TOKEN(anon_sym_func);
      END_STATE();
    case 1788:
      ACCEPT_TOKEN(anon_sym_func);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1789:
      ACCEPT_TOKEN(anon_sym_func);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1790:
      ACCEPT_TOKEN(anon_sym_willSet);
      END_STATE();
    case 1791:
      ACCEPT_TOKEN(anon_sym_willSet);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1792:
      ACCEPT_TOKEN(anon_sym_willSet);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1793:
      ACCEPT_TOKEN(anon_sym_didSet);
      END_STATE();
    case 1794:
      ACCEPT_TOKEN(anon_sym_didSet);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1795:
      ACCEPT_TOKEN(anon_sym_didSet);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1796:
      ACCEPT_TOKEN(anon_sym_macro);
      END_STATE();
    case 1797:
      ACCEPT_TOKEN(anon_sym_macro);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1798:
      ACCEPT_TOKEN(anon_sym_macro);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1799:
      ACCEPT_TOKEN(anon_sym_POUNDexternalMacro);
      END_STATE();
    case 1800:
      ACCEPT_TOKEN(anon_sym_extension);
      END_STATE();
    case 1801:
      ACCEPT_TOKEN(anon_sym_extension);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1802:
      ACCEPT_TOKEN(anon_sym_extension);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1803:
      ACCEPT_TOKEN(anon_sym_indirect);
      END_STATE();
    case 1804:
      ACCEPT_TOKEN(anon_sym_indirect);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1805:
      ACCEPT_TOKEN(anon_sym_indirect);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1806:
      ACCEPT_TOKEN(anon_sym_BANG2);
      END_STATE();
    case 1807:
      ACCEPT_TOKEN(anon_sym_BANG2);
      if (lookahead == '=') ADVANCE(1722);
      END_STATE();
    case 1808:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 1809:
      ACCEPT_TOKEN(anon_sym_init);
      END_STATE();
    case 1810:
      ACCEPT_TOKEN(anon_sym_init);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1811:
      ACCEPT_TOKEN(anon_sym_init);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1812:
      ACCEPT_TOKEN(anon_sym_deinit);
      END_STATE();
    case 1813:
      ACCEPT_TOKEN(anon_sym_deinit);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1814:
      ACCEPT_TOKEN(anon_sym_subscript);
      END_STATE();
    case 1815:
      ACCEPT_TOKEN(anon_sym_subscript);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1816:
      ACCEPT_TOKEN(anon_sym_get);
      END_STATE();
    case 1817:
      ACCEPT_TOKEN(anon_sym_get);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1818:
      ACCEPT_TOKEN(anon_sym_get);
      if (lookahead == 't') ADVANCE(355);
      END_STATE();
    case 1819:
      ACCEPT_TOKEN(anon_sym_set);
      END_STATE();
    case 1820:
      ACCEPT_TOKEN(anon_sym_set);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1821:
      ACCEPT_TOKEN(anon_sym_set);
      if (lookahead == 'p') ADVANCE(219);
      if (lookahead == 't') ADVANCE(356);
      END_STATE();
    case 1822:
      ACCEPT_TOKEN(anon_sym__modify);
      END_STATE();
    case 1823:
      ACCEPT_TOKEN(anon_sym__modify);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1824:
      ACCEPT_TOKEN(anon_sym_prefix);
      END_STATE();
    case 1825:
      ACCEPT_TOKEN(anon_sym_prefix);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1826:
      ACCEPT_TOKEN(anon_sym_prefix);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1827:
      ACCEPT_TOKEN(anon_sym_infix);
      END_STATE();
    case 1828:
      ACCEPT_TOKEN(anon_sym_infix);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1829:
      ACCEPT_TOKEN(anon_sym_infix);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1830:
      ACCEPT_TOKEN(anon_sym_postfix);
      END_STATE();
    case 1831:
      ACCEPT_TOKEN(anon_sym_postfix);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1832:
      ACCEPT_TOKEN(anon_sym_postfix);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1833:
      ACCEPT_TOKEN(anon_sym_operator);
      END_STATE();
    case 1834:
      ACCEPT_TOKEN(anon_sym_precedencegroup);
      END_STATE();
    case 1835:
      ACCEPT_TOKEN(anon_sym_precedencegroup);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1836:
      ACCEPT_TOKEN(anon_sym_precedencegroup);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1837:
      ACCEPT_TOKEN(anon_sym_associatedtype);
      END_STATE();
    case 1838:
      ACCEPT_TOKEN(anon_sym_associatedtype);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1839:
      ACCEPT_TOKEN(anon_sym_associatedtype);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1840:
      ACCEPT_TOKEN(anon_sym_AT);
      END_STATE();
    case 1841:
      ACCEPT_TOKEN(anon_sym_AT);
      if (lookahead == 'a') ADVANCE(714);
      if (lookahead == 'e') ADVANCE(640);
      END_STATE();
    case 1842:
      ACCEPT_TOKEN(sym_wildcard_pattern);
      END_STATE();
    case 1843:
      ACCEPT_TOKEN(sym_wildcard_pattern);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1844:
      ACCEPT_TOKEN(anon_sym_override);
      END_STATE();
    case 1845:
      ACCEPT_TOKEN(anon_sym_override);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1846:
      ACCEPT_TOKEN(anon_sym_override);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1847:
      ACCEPT_TOKEN(anon_sym_convenience);
      END_STATE();
    case 1848:
      ACCEPT_TOKEN(anon_sym_convenience);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1849:
      ACCEPT_TOKEN(anon_sym_convenience);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1850:
      ACCEPT_TOKEN(anon_sym_required);
      END_STATE();
    case 1851:
      ACCEPT_TOKEN(anon_sym_required);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1852:
      ACCEPT_TOKEN(anon_sym_required);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1853:
      ACCEPT_TOKEN(anon_sym_nonisolated);
      END_STATE();
    case 1854:
      ACCEPT_TOKEN(anon_sym_nonisolated);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1855:
      ACCEPT_TOKEN(anon_sym_nonisolated);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1856:
      ACCEPT_TOKEN(anon_sym_public);
      END_STATE();
    case 1857:
      ACCEPT_TOKEN(anon_sym_public);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1858:
      ACCEPT_TOKEN(anon_sym_public);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1859:
      ACCEPT_TOKEN(anon_sym_private);
      END_STATE();
    case 1860:
      ACCEPT_TOKEN(anon_sym_private);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1861:
      ACCEPT_TOKEN(anon_sym_private);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1862:
      ACCEPT_TOKEN(anon_sym_internal);
      END_STATE();
    case 1863:
      ACCEPT_TOKEN(anon_sym_internal);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1864:
      ACCEPT_TOKEN(anon_sym_internal);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1865:
      ACCEPT_TOKEN(anon_sym_fileprivate);
      END_STATE();
    case 1866:
      ACCEPT_TOKEN(anon_sym_fileprivate);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1867:
      ACCEPT_TOKEN(anon_sym_fileprivate);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1868:
      ACCEPT_TOKEN(anon_sym_open);
      END_STATE();
    case 1869:
      ACCEPT_TOKEN(anon_sym_open);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1870:
      ACCEPT_TOKEN(anon_sym_open);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1871:
      ACCEPT_TOKEN(anon_sym_mutating);
      END_STATE();
    case 1872:
      ACCEPT_TOKEN(anon_sym_mutating);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1873:
      ACCEPT_TOKEN(anon_sym_mutating);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1874:
      ACCEPT_TOKEN(anon_sym_nonmutating);
      END_STATE();
    case 1875:
      ACCEPT_TOKEN(anon_sym_nonmutating);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1876:
      ACCEPT_TOKEN(anon_sym_nonmutating);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1877:
      ACCEPT_TOKEN(anon_sym_static);
      END_STATE();
    case 1878:
      ACCEPT_TOKEN(anon_sym_static);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1879:
      ACCEPT_TOKEN(anon_sym_static);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1880:
      ACCEPT_TOKEN(anon_sym_dynamic);
      END_STATE();
    case 1881:
      ACCEPT_TOKEN(anon_sym_dynamic);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1882:
      ACCEPT_TOKEN(anon_sym_dynamic);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1883:
      ACCEPT_TOKEN(anon_sym_optional);
      END_STATE();
    case 1884:
      ACCEPT_TOKEN(anon_sym_optional);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1885:
      ACCEPT_TOKEN(anon_sym_optional);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1886:
      ACCEPT_TOKEN(anon_sym_distributed);
      END_STATE();
    case 1887:
      ACCEPT_TOKEN(anon_sym_distributed);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1888:
      ACCEPT_TOKEN(anon_sym_distributed);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1889:
      ACCEPT_TOKEN(anon_sym_final);
      END_STATE();
    case 1890:
      ACCEPT_TOKEN(anon_sym_final);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1891:
      ACCEPT_TOKEN(anon_sym_final);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1892:
      ACCEPT_TOKEN(anon_sym_inout);
      END_STATE();
    case 1893:
      ACCEPT_TOKEN(anon_sym_inout);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1894:
      ACCEPT_TOKEN(anon_sym_inout);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1895:
      ACCEPT_TOKEN(anon_sym_ATescaping);
      END_STATE();
    case 1896:
      ACCEPT_TOKEN(anon_sym_ATautoclosure);
      END_STATE();
    case 1897:
      ACCEPT_TOKEN(anon_sym_weak);
      END_STATE();
    case 1898:
      ACCEPT_TOKEN(anon_sym_weak);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1899:
      ACCEPT_TOKEN(anon_sym_weak);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1900:
      ACCEPT_TOKEN(anon_sym_unowned);
      if (lookahead == '(') ADVANCE(648);
      END_STATE();
    case 1901:
      ACCEPT_TOKEN(anon_sym_unowned);
      if (lookahead == '(') ADVANCE(648);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1902:
      ACCEPT_TOKEN(anon_sym_unowned);
      if (lookahead == '(') ADVANCE(648);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1903:
      ACCEPT_TOKEN(anon_sym_unowned_LPARENsafe_RPAREN);
      END_STATE();
    case 1904:
      ACCEPT_TOKEN(anon_sym_unowned_LPARENunsafe_RPAREN);
      END_STATE();
    case 1905:
      ACCEPT_TOKEN(anon_sym_borrowing);
      END_STATE();
    case 1906:
      ACCEPT_TOKEN(anon_sym_borrowing);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1907:
      ACCEPT_TOKEN(anon_sym_borrowing);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1908:
      ACCEPT_TOKEN(anon_sym_consuming);
      END_STATE();
    case 1909:
      ACCEPT_TOKEN(anon_sym_consuming);
      if (lookahead == ':') ADVANCE(1746);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1151);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1910:
      ACCEPT_TOKEN(anon_sym_consuming);
      if (lookahead == 0xfe0f) ADVANCE(1541);
      if ((0x1f3fb <= lookahead && lookahead <= 0x1f3ff)) ADVANCE(1542);
      if (set_contains(aux_sym_simple_identifier_token1_character_set_2, 911, lookahead)) ADVANCE(1542);
      END_STATE();
    case 1911:
      ACCEPT_TOKEN(anon_sym_property);
      END_STATE();
    case 1912:
      ACCEPT_TOKEN(anon_sym_receiver);
      END_STATE();
    case 1913:
      ACCEPT_TOKEN(anon_sym_param);
      END_STATE();
    case 1914:
      ACCEPT_TOKEN(anon_sym_setparam);
      END_STATE();
    case 1915:
      ACCEPT_TOKEN(anon_sym_delegate);
      END_STATE();
    case 1916:
      ACCEPT_TOKEN(sym_directive);
      if (lookahead == '\n') ADVANCE(33);
      if (lookahead == '#') ADVANCE(1925);
      if (lookahead != 0) ADVANCE(1920);
      END_STATE();
    case 1917:
      ACCEPT_TOKEN(sym_directive);
      if (lookahead == '\n') ADVANCE(34);
      if (lookahead == '\r') ADVANCE(33);
      if (lookahead == '/') ADVANCE(1921);
      if (lookahead != 0) ADVANCE(1917);
      END_STATE();
    case 1918:
      ACCEPT_TOKEN(sym_directive);
      if (lookahead == '\n') ADVANCE(34);
      if (lookahead == '/') ADVANCE(1916);
      if (lookahead == 'f') ADVANCE(1920);
      if (lookahead != 0) ADVANCE(1920);
      END_STATE();
    case 1919:
      ACCEPT_TOKEN(sym_directive);
      if (lookahead == '\n') ADVANCE(34);
      if (lookahead == '/') ADVANCE(1916);
      if (lookahead == 'i') ADVANCE(1918);
      if (lookahead != 0) ADVANCE(1920);
      END_STATE();
    case 1920:
      ACCEPT_TOKEN(sym_directive);
      if (lookahead == '\n') ADVANCE(34);
      if (lookahead == '/') ADVANCE(1916);
      if (lookahead != 0) ADVANCE(1920);
      END_STATE();
    case 1921:
      ACCEPT_TOKEN(sym_directive);
      if (lookahead == '#') ADVANCE(1924);
      if (lookahead == '\n' ||
          lookahead == '\r') ADVANCE(33);
      if (lookahead != 0) ADVANCE(1917);
      END_STATE();
    case 1922:
      ACCEPT_TOKEN(sym_directive);
      if (lookahead == 'f') ADVANCE(1925);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1925);
      END_STATE();
    case 1923:
      ACCEPT_TOKEN(sym_directive);
      if (lookahead == 'i') ADVANCE(1922);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1925);
      END_STATE();
    case 1924:
      ACCEPT_TOKEN(sym_directive);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(1924);
      END_STATE();
    case 1925:
      ACCEPT_TOKEN(sym_directive);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1925);
      END_STATE();
    case 1926:
      ACCEPT_TOKEN(sym_diagnostic);
      if (lookahead == '\n') ADVANCE(34);
      if (lookahead == '\r') ADVANCE(33);
      if (lookahead == '/') ADVANCE(1927);
      if (lookahead != 0) ADVANCE(1926);
      END_STATE();
    case 1927:
      ACCEPT_TOKEN(sym_diagnostic);
      if (lookahead == '#') ADVANCE(1928);
      if (lookahead == '\n' ||
          lookahead == '\r') ADVANCE(33);
      if (lookahead != 0) ADVANCE(1926);
      END_STATE();
    case 1928:
      ACCEPT_TOKEN(sym_diagnostic);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(1928);
      END_STATE();
    case 1929:
      ACCEPT_TOKEN(anon_sym_unused1);
      END_STATE();
    case 1930:
      ACCEPT_TOKEN(anon_sym_unused2);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 755, .external_lex_state = 2},
  [2] = {.lex_state = 51, .external_lex_state = 2},
  [3] = {.lex_state = 51, .external_lex_state = 2},
  [4] = {.lex_state = 51, .external_lex_state = 2},
  [5] = {.lex_state = 51, .external_lex_state = 2},
  [6] = {.lex_state = 55, .external_lex_state = 2},
  [7] = {.lex_state = 55, .external_lex_state = 2},
  [8] = {.lex_state = 53, .external_lex_state = 3},
  [9] = {.lex_state = 55, .external_lex_state = 2},
  [10] = {.lex_state = 53, .external_lex_state = 3},
  [11] = {.lex_state = 53, .external_lex_state = 3},
  [12] = {.lex_state = 53, .external_lex_state = 3},
  [13] = {.lex_state = 53, .external_lex_state = 3},
  [14] = {.lex_state = 53, .external_lex_state = 3},
  [15] = {.lex_state = 53, .external_lex_state = 3},
  [16] = {.lex_state = 55, .external_lex_state = 2},
  [17] = {.lex_state = 53, .external_lex_state = 3},
  [18] = {.lex_state = 53, .external_lex_state = 3},
  [19] = {.lex_state = 53, .external_lex_state = 3},
  [20] = {.lex_state = 53, .external_lex_state = 3},
  [21] = {.lex_state = 53, .external_lex_state = 3},
  [22] = {.lex_state = 755, .external_lex_state = 2},
  [23] = {.lex_state = 755, .external_lex_state = 2},
  [24] = {.lex_state = 755, .external_lex_state = 2},
  [25] = {.lex_state = 755, .external_lex_state = 2},
  [26] = {.lex_state = 755, .external_lex_state = 2},
  [27] = {.lex_state = 54, .external_lex_state = 3},
  [28] = {.lex_state = 54, .external_lex_state = 3},
  [29] = {.lex_state = 57, .external_lex_state = 2},
  [30] = {.lex_state = 57, .external_lex_state = 2},
  [31] = {.lex_state = 57, .external_lex_state = 2},
  [32] = {.lex_state = 64, .external_lex_state = 4},
  [33] = {.lex_state = 59, .external_lex_state = 2},
  [34] = {.lex_state = 59, .external_lex_state = 2},
  [35] = {.lex_state = 59, .external_lex_state = 2},
  [36] = {.lex_state = 59, .external_lex_state = 2},
  [37] = {.lex_state = 59, .external_lex_state = 2},
  [38] = {.lex_state = 59, .external_lex_state = 2},
  [39] = {.lex_state = 59, .external_lex_state = 2},
  [40] = {.lex_state = 59, .external_lex_state = 2},
  [41] = {.lex_state = 59, .external_lex_state = 2},
  [42] = {.lex_state = 59, .external_lex_state = 2},
  [43] = {.lex_state = 59, .external_lex_state = 2},
  [44] = {.lex_state = 59, .external_lex_state = 2},
  [45] = {.lex_state = 59, .external_lex_state = 2},
  [46] = {.lex_state = 59, .external_lex_state = 2},
  [47] = {.lex_state = 59, .external_lex_state = 2},
  [48] = {.lex_state = 59, .external_lex_state = 2},
  [49] = {.lex_state = 59, .external_lex_state = 2},
  [50] = {.lex_state = 59, .external_lex_state = 2},
  [51] = {.lex_state = 59, .external_lex_state = 2},
  [52] = {.lex_state = 59, .external_lex_state = 2},
  [53] = {.lex_state = 59, .external_lex_state = 2},
  [54] = {.lex_state = 58, .external_lex_state = 2},
  [55] = {.lex_state = 58, .external_lex_state = 2},
  [56] = {.lex_state = 58, .external_lex_state = 2},
  [57] = {.lex_state = 58, .external_lex_state = 2},
  [58] = {.lex_state = 58, .external_lex_state = 2},
  [59] = {.lex_state = 58, .external_lex_state = 2},
  [60] = {.lex_state = 58, .external_lex_state = 2},
  [61] = {.lex_state = 66, .external_lex_state = 5},
  [62] = {.lex_state = 58, .external_lex_state = 2},
  [63] = {.lex_state = 58, .external_lex_state = 2},
  [64] = {.lex_state = 58, .external_lex_state = 2},
  [65] = {.lex_state = 58, .external_lex_state = 2},
  [66] = {.lex_state = 58, .external_lex_state = 2},
  [67] = {.lex_state = 58, .external_lex_state = 2},
  [68] = {.lex_state = 58, .external_lex_state = 2},
  [69] = {.lex_state = 58, .external_lex_state = 2},
  [70] = {.lex_state = 58, .external_lex_state = 2},
  [71] = {.lex_state = 58, .external_lex_state = 2},
  [72] = {.lex_state = 58, .external_lex_state = 2},
  [73] = {.lex_state = 58, .external_lex_state = 2},
  [74] = {.lex_state = 58, .external_lex_state = 2},
  [75] = {.lex_state = 58, .external_lex_state = 2},
  [76] = {.lex_state = 58, .external_lex_state = 2},
  [77] = {.lex_state = 58, .external_lex_state = 2},
  [78] = {.lex_state = 58, .external_lex_state = 2},
  [79] = {.lex_state = 58, .external_lex_state = 2},
  [80] = {.lex_state = 58, .external_lex_state = 2},
  [81] = {.lex_state = 58, .external_lex_state = 2},
  [82] = {.lex_state = 58, .external_lex_state = 2},
  [83] = {.lex_state = 58, .external_lex_state = 2},
  [84] = {.lex_state = 58, .external_lex_state = 2},
  [85] = {.lex_state = 58, .external_lex_state = 2},
  [86] = {.lex_state = 58, .external_lex_state = 2},
  [87] = {.lex_state = 58, .external_lex_state = 2},
  [88] = {.lex_state = 58, .external_lex_state = 2},
  [89] = {.lex_state = 58, .external_lex_state = 2},
  [90] = {.lex_state = 58, .external_lex_state = 2},
  [91] = {.lex_state = 58, .external_lex_state = 2},
  [92] = {.lex_state = 58, .external_lex_state = 2},
  [93] = {.lex_state = 58, .external_lex_state = 2},
  [94] = {.lex_state = 58, .external_lex_state = 2},
  [95] = {.lex_state = 58, .external_lex_state = 2},
  [96] = {.lex_state = 58, .external_lex_state = 2},
  [97] = {.lex_state = 58, .external_lex_state = 2},
  [98] = {.lex_state = 58, .external_lex_state = 2},
  [99] = {.lex_state = 58, .external_lex_state = 2},
  [100] = {.lex_state = 58, .external_lex_state = 2},
  [101] = {.lex_state = 58, .external_lex_state = 2},
  [102] = {.lex_state = 58, .external_lex_state = 2},
  [103] = {.lex_state = 66, .external_lex_state = 6},
  [104] = {.lex_state = 58, .external_lex_state = 2},
  [105] = {.lex_state = 64, .external_lex_state = 4},
  [106] = {.lex_state = 58, .external_lex_state = 2},
  [107] = {.lex_state = 58, .external_lex_state = 2},
  [108] = {.lex_state = 58, .external_lex_state = 2},
  [109] = {.lex_state = 58, .external_lex_state = 2},
  [110] = {.lex_state = 64, .external_lex_state = 4},
  [111] = {.lex_state = 64, .external_lex_state = 4},
  [112] = {.lex_state = 58, .external_lex_state = 2},
  [113] = {.lex_state = 58, .external_lex_state = 2},
  [114] = {.lex_state = 58, .external_lex_state = 2},
  [115] = {.lex_state = 58, .external_lex_state = 2},
  [116] = {.lex_state = 58, .external_lex_state = 2},
  [117] = {.lex_state = 49, .external_lex_state = 5},
  [118] = {.lex_state = 49, .external_lex_state = 5},
  [119] = {.lex_state = 49, .external_lex_state = 5},
  [120] = {.lex_state = 49, .external_lex_state = 6},
  [121] = {.lex_state = 49, .external_lex_state = 6},
  [122] = {.lex_state = 49, .external_lex_state = 6},
  [123] = {.lex_state = 49, .external_lex_state = 6},
  [124] = {.lex_state = 56, .external_lex_state = 7},
  [125] = {.lex_state = 41, .external_lex_state = 8},
  [126] = {.lex_state = 41, .external_lex_state = 8},
  [127] = {.lex_state = 41, .external_lex_state = 8},
  [128] = {.lex_state = 41, .external_lex_state = 8},
  [129] = {.lex_state = 35, .external_lex_state = 8},
  [130] = {.lex_state = 35, .external_lex_state = 8},
  [131] = {.lex_state = 758, .external_lex_state = 9},
  [132] = {.lex_state = 758, .external_lex_state = 10},
  [133] = {.lex_state = 48, .external_lex_state = 2},
  [134] = {.lex_state = 45, .external_lex_state = 2},
  [135] = {.lex_state = 758, .external_lex_state = 4},
  [136] = {.lex_state = 758, .external_lex_state = 10},
  [137] = {.lex_state = 758, .external_lex_state = 11},
  [138] = {.lex_state = 758, .external_lex_state = 12},
  [139] = {.lex_state = 52, .external_lex_state = 2},
  [140] = {.lex_state = 758, .external_lex_state = 13},
  [141] = {.lex_state = 44, .external_lex_state = 2},
  [142] = {.lex_state = 44, .external_lex_state = 2},
  [143] = {.lex_state = 44, .external_lex_state = 2},
  [144] = {.lex_state = 44, .external_lex_state = 2},
  [145] = {.lex_state = 44, .external_lex_state = 2},
  [146] = {.lex_state = 44, .external_lex_state = 2},
  [147] = {.lex_state = 44, .external_lex_state = 2},
  [148] = {.lex_state = 44, .external_lex_state = 2},
  [149] = {.lex_state = 44, .external_lex_state = 2},
  [150] = {.lex_state = 44, .external_lex_state = 2},
  [151] = {.lex_state = 46, .external_lex_state = 14},
  [152] = {.lex_state = 60, .external_lex_state = 2},
  [153] = {.lex_state = 60, .external_lex_state = 2},
  [154] = {.lex_state = 46, .external_lex_state = 14},
  [155] = {.lex_state = 61, .external_lex_state = 2},
  [156] = {.lex_state = 61, .external_lex_state = 2},
  [157] = {.lex_state = 756, .external_lex_state = 9},
  [158] = {.lex_state = 61, .external_lex_state = 2},
  [159] = {.lex_state = 61, .external_lex_state = 2},
  [160] = {.lex_state = 61, .external_lex_state = 2},
  [161] = {.lex_state = 61, .external_lex_state = 2},
  [162] = {.lex_state = 61, .external_lex_state = 2},
  [163] = {.lex_state = 756, .external_lex_state = 9},
  [164] = {.lex_state = 756, .external_lex_state = 9},
  [165] = {.lex_state = 61, .external_lex_state = 2},
  [166] = {.lex_state = 61, .external_lex_state = 2},
  [167] = {.lex_state = 61, .external_lex_state = 2},
  [168] = {.lex_state = 61, .external_lex_state = 2},
  [169] = {.lex_state = 68, .external_lex_state = 2},
  [170] = {.lex_state = 61, .external_lex_state = 2},
  [171] = {.lex_state = 756, .external_lex_state = 10},
  [172] = {.lex_state = 756, .external_lex_state = 10},
  [173] = {.lex_state = 61, .external_lex_state = 2},
  [174] = {.lex_state = 756, .external_lex_state = 10},
  [175] = {.lex_state = 61, .external_lex_state = 2},
  [176] = {.lex_state = 756, .external_lex_state = 4},
  [177] = {.lex_state = 68, .external_lex_state = 2},
  [178] = {.lex_state = 68, .external_lex_state = 2},
  [179] = {.lex_state = 68, .external_lex_state = 2},
  [180] = {.lex_state = 68, .external_lex_state = 2},
  [181] = {.lex_state = 68, .external_lex_state = 2},
  [182] = {.lex_state = 68, .external_lex_state = 2},
  [183] = {.lex_state = 68, .external_lex_state = 2},
  [184] = {.lex_state = 68, .external_lex_state = 2},
  [185] = {.lex_state = 68, .external_lex_state = 2},
  [186] = {.lex_state = 68, .external_lex_state = 2},
  [187] = {.lex_state = 68, .external_lex_state = 2},
  [188] = {.lex_state = 68, .external_lex_state = 2},
  [189] = {.lex_state = 68, .external_lex_state = 2},
  [190] = {.lex_state = 756, .external_lex_state = 4},
  [191] = {.lex_state = 68, .external_lex_state = 2},
  [192] = {.lex_state = 756, .external_lex_state = 10},
  [193] = {.lex_state = 68, .external_lex_state = 2},
  [194] = {.lex_state = 756, .external_lex_state = 4},
  [195] = {.lex_state = 68, .external_lex_state = 2},
  [196] = {.lex_state = 68, .external_lex_state = 2},
  [197] = {.lex_state = 756, .external_lex_state = 10},
  [198] = {.lex_state = 68, .external_lex_state = 2},
  [199] = {.lex_state = 68, .external_lex_state = 2},
  [200] = {.lex_state = 68, .external_lex_state = 2},
  [201] = {.lex_state = 68, .external_lex_state = 2},
  [202] = {.lex_state = 68, .external_lex_state = 2},
  [203] = {.lex_state = 68, .external_lex_state = 2},
  [204] = {.lex_state = 756, .external_lex_state = 10},
  [205] = {.lex_state = 68, .external_lex_state = 2},
  [206] = {.lex_state = 68, .external_lex_state = 2},
  [207] = {.lex_state = 756, .external_lex_state = 10},
  [208] = {.lex_state = 756, .external_lex_state = 11},
  [209] = {.lex_state = 756, .external_lex_state = 12},
  [210] = {.lex_state = 756, .external_lex_state = 11},
  [211] = {.lex_state = 756, .external_lex_state = 11},
  [212] = {.lex_state = 756, .external_lex_state = 12},
  [213] = {.lex_state = 756, .external_lex_state = 12},
  [214] = {.lex_state = 756, .external_lex_state = 13},
  [215] = {.lex_state = 756, .external_lex_state = 13},
  [216] = {.lex_state = 756, .external_lex_state = 13},
  [217] = {.lex_state = 69, .external_lex_state = 2},
  [218] = {.lex_state = 69, .external_lex_state = 2},
  [219] = {.lex_state = 69, .external_lex_state = 2},
  [220] = {.lex_state = 69, .external_lex_state = 2},
  [221] = {.lex_state = 69, .external_lex_state = 2},
  [222] = {.lex_state = 69, .external_lex_state = 2},
  [223] = {.lex_state = 69, .external_lex_state = 2},
  [224] = {.lex_state = 69, .external_lex_state = 2},
  [225] = {.lex_state = 69, .external_lex_state = 2},
  [226] = {.lex_state = 69, .external_lex_state = 2},
  [227] = {.lex_state = 69, .external_lex_state = 2},
  [228] = {.lex_state = 69, .external_lex_state = 2},
  [229] = {.lex_state = 69, .external_lex_state = 2},
  [230] = {.lex_state = 69, .external_lex_state = 2},
  [231] = {.lex_state = 69, .external_lex_state = 2},
  [232] = {.lex_state = 69, .external_lex_state = 2},
  [233] = {.lex_state = 69, .external_lex_state = 2},
  [234] = {.lex_state = 69, .external_lex_state = 2},
  [235] = {.lex_state = 69, .external_lex_state = 2},
  [236] = {.lex_state = 69, .external_lex_state = 2},
  [237] = {.lex_state = 69, .external_lex_state = 2},
  [238] = {.lex_state = 69, .external_lex_state = 2},
  [239] = {.lex_state = 69, .external_lex_state = 2},
  [240] = {.lex_state = 69, .external_lex_state = 2},
  [241] = {.lex_state = 69, .external_lex_state = 2},
  [242] = {.lex_state = 69, .external_lex_state = 2},
  [243] = {.lex_state = 69, .external_lex_state = 2},
  [244] = {.lex_state = 69, .external_lex_state = 2},
  [245] = {.lex_state = 69, .external_lex_state = 2},
  [246] = {.lex_state = 69, .external_lex_state = 2},
  [247] = {.lex_state = 69, .external_lex_state = 2},
  [248] = {.lex_state = 69, .external_lex_state = 2},
  [249] = {.lex_state = 69, .external_lex_state = 2},
  [250] = {.lex_state = 69, .external_lex_state = 2},
  [251] = {.lex_state = 69, .external_lex_state = 2},
  [252] = {.lex_state = 69, .external_lex_state = 2},
  [253] = {.lex_state = 69, .external_lex_state = 2},
  [254] = {.lex_state = 69, .external_lex_state = 2},
  [255] = {.lex_state = 69, .external_lex_state = 2},
  [256] = {.lex_state = 69, .external_lex_state = 2},
  [257] = {.lex_state = 69, .external_lex_state = 2},
  [258] = {.lex_state = 69, .external_lex_state = 2},
  [259] = {.lex_state = 69, .external_lex_state = 2},
  [260] = {.lex_state = 44, .external_lex_state = 2},
  [261] = {.lex_state = 52, .external_lex_state = 2},
  [262] = {.lex_state = 44, .external_lex_state = 2},
  [263] = {.lex_state = 44, .external_lex_state = 2},
  [264] = {.lex_state = 44, .external_lex_state = 2},
  [265] = {.lex_state = 44, .external_lex_state = 2},
  [266] = {.lex_state = 44, .external_lex_state = 2},
  [267] = {.lex_state = 44, .external_lex_state = 2},
  [268] = {.lex_state = 44, .external_lex_state = 2},
  [269] = {.lex_state = 44, .external_lex_state = 2},
  [270] = {.lex_state = 44, .external_lex_state = 2},
  [271] = {.lex_state = 69, .external_lex_state = 2},
  [272] = {.lex_state = 69, .external_lex_state = 2},
  [273] = {.lex_state = 69, .external_lex_state = 2},
  [274] = {.lex_state = 69, .external_lex_state = 2},
  [275] = {.lex_state = 69, .external_lex_state = 2},
  [276] = {.lex_state = 69, .external_lex_state = 15},
  [277] = {.lex_state = 69, .external_lex_state = 2},
  [278] = {.lex_state = 69, .external_lex_state = 2},
  [279] = {.lex_state = 69, .external_lex_state = 2},
  [280] = {.lex_state = 69, .external_lex_state = 2},
  [281] = {.lex_state = 69, .external_lex_state = 2},
  [282] = {.lex_state = 69, .external_lex_state = 2},
  [283] = {.lex_state = 69, .external_lex_state = 16},
  [284] = {.lex_state = 69, .external_lex_state = 2},
  [285] = {.lex_state = 69, .external_lex_state = 2},
  [286] = {.lex_state = 69, .external_lex_state = 2},
  [287] = {.lex_state = 69, .external_lex_state = 2},
  [288] = {.lex_state = 69, .external_lex_state = 2},
  [289] = {.lex_state = 69, .external_lex_state = 2},
  [290] = {.lex_state = 69, .external_lex_state = 2},
  [291] = {.lex_state = 69, .external_lex_state = 2},
  [292] = {.lex_state = 69, .external_lex_state = 2},
  [293] = {.lex_state = 69, .external_lex_state = 2},
  [294] = {.lex_state = 69, .external_lex_state = 2},
  [295] = {.lex_state = 69, .external_lex_state = 2},
  [296] = {.lex_state = 69, .external_lex_state = 2},
  [297] = {.lex_state = 69, .external_lex_state = 2},
  [298] = {.lex_state = 69, .external_lex_state = 2},
  [299] = {.lex_state = 69, .external_lex_state = 2},
  [300] = {.lex_state = 62, .external_lex_state = 2},
  [301] = {.lex_state = 69, .external_lex_state = 2},
  [302] = {.lex_state = 69, .external_lex_state = 2},
  [303] = {.lex_state = 62, .external_lex_state = 2},
  [304] = {.lex_state = 62, .external_lex_state = 2},
  [305] = {.lex_state = 69, .external_lex_state = 2},
  [306] = {.lex_state = 69, .external_lex_state = 2},
  [307] = {.lex_state = 69, .external_lex_state = 2},
  [308] = {.lex_state = 69, .external_lex_state = 2},
  [309] = {.lex_state = 69, .external_lex_state = 2},
  [310] = {.lex_state = 69, .external_lex_state = 2},
  [311] = {.lex_state = 69, .external_lex_state = 2},
  [312] = {.lex_state = 69, .external_lex_state = 2},
  [313] = {.lex_state = 69, .external_lex_state = 2},
  [314] = {.lex_state = 69, .external_lex_state = 2},
  [315] = {.lex_state = 69, .external_lex_state = 2},
  [316] = {.lex_state = 69, .external_lex_state = 2},
  [317] = {.lex_state = 69, .external_lex_state = 2},
  [318] = {.lex_state = 69, .external_lex_state = 2},
  [319] = {.lex_state = 69, .external_lex_state = 2},
  [320] = {.lex_state = 62, .external_lex_state = 2},
  [321] = {.lex_state = 69, .external_lex_state = 2},
  [322] = {.lex_state = 69, .external_lex_state = 2},
  [323] = {.lex_state = 69, .external_lex_state = 2},
  [324] = {.lex_state = 69, .external_lex_state = 2},
  [325] = {.lex_state = 69, .external_lex_state = 2},
  [326] = {.lex_state = 69, .external_lex_state = 2},
  [327] = {.lex_state = 69, .external_lex_state = 2},
  [328] = {.lex_state = 69, .external_lex_state = 2},
  [329] = {.lex_state = 69, .external_lex_state = 2},
  [330] = {.lex_state = 69, .external_lex_state = 2},
  [331] = {.lex_state = 69, .external_lex_state = 2},
  [332] = {.lex_state = 69, .external_lex_state = 2},
  [333] = {.lex_state = 69, .external_lex_state = 2},
  [334] = {.lex_state = 69, .external_lex_state = 2},
  [335] = {.lex_state = 69, .external_lex_state = 2},
  [336] = {.lex_state = 69, .external_lex_state = 2},
  [337] = {.lex_state = 69, .external_lex_state = 2},
  [338] = {.lex_state = 69, .external_lex_state = 2},
  [339] = {.lex_state = 69, .external_lex_state = 2},
  [340] = {.lex_state = 69, .external_lex_state = 2},
  [341] = {.lex_state = 69, .external_lex_state = 2},
  [342] = {.lex_state = 69, .external_lex_state = 2},
  [343] = {.lex_state = 69, .external_lex_state = 2},
  [344] = {.lex_state = 62, .external_lex_state = 2},
  [345] = {.lex_state = 69, .external_lex_state = 2},
  [346] = {.lex_state = 69, .external_lex_state = 2},
  [347] = {.lex_state = 69, .external_lex_state = 2},
  [348] = {.lex_state = 69, .external_lex_state = 2},
  [349] = {.lex_state = 69, .external_lex_state = 2},
  [350] = {.lex_state = 69, .external_lex_state = 2},
  [351] = {.lex_state = 69, .external_lex_state = 2},
  [352] = {.lex_state = 69, .external_lex_state = 2},
  [353] = {.lex_state = 69, .external_lex_state = 2},
  [354] = {.lex_state = 62, .external_lex_state = 2},
  [355] = {.lex_state = 69, .external_lex_state = 2},
  [356] = {.lex_state = 69, .external_lex_state = 2},
  [357] = {.lex_state = 69, .external_lex_state = 2},
  [358] = {.lex_state = 69, .external_lex_state = 2},
  [359] = {.lex_state = 69, .external_lex_state = 2},
  [360] = {.lex_state = 69, .external_lex_state = 2},
  [361] = {.lex_state = 69, .external_lex_state = 2},
  [362] = {.lex_state = 69, .external_lex_state = 2},
  [363] = {.lex_state = 69, .external_lex_state = 2},
  [364] = {.lex_state = 69, .external_lex_state = 2},
  [365] = {.lex_state = 69, .external_lex_state = 2},
  [366] = {.lex_state = 69, .external_lex_state = 2},
  [367] = {.lex_state = 69, .external_lex_state = 2},
  [368] = {.lex_state = 69, .external_lex_state = 2},
  [369] = {.lex_state = 69, .external_lex_state = 2},
  [370] = {.lex_state = 69, .external_lex_state = 2},
  [371] = {.lex_state = 69, .external_lex_state = 2},
  [372] = {.lex_state = 69, .external_lex_state = 2},
  [373] = {.lex_state = 69, .external_lex_state = 2},
  [374] = {.lex_state = 69, .external_lex_state = 2},
  [375] = {.lex_state = 69, .external_lex_state = 2},
  [376] = {.lex_state = 69, .external_lex_state = 2},
  [377] = {.lex_state = 69, .external_lex_state = 2},
  [378] = {.lex_state = 69, .external_lex_state = 2},
  [379] = {.lex_state = 69, .external_lex_state = 2},
  [380] = {.lex_state = 69, .external_lex_state = 2},
  [381] = {.lex_state = 69, .external_lex_state = 2},
  [382] = {.lex_state = 69, .external_lex_state = 2},
  [383] = {.lex_state = 62, .external_lex_state = 2},
  [384] = {.lex_state = 69, .external_lex_state = 2},
  [385] = {.lex_state = 62, .external_lex_state = 2},
  [386] = {.lex_state = 69, .external_lex_state = 2},
  [387] = {.lex_state = 69, .external_lex_state = 2},
  [388] = {.lex_state = 69, .external_lex_state = 2},
  [389] = {.lex_state = 69, .external_lex_state = 2},
  [390] = {.lex_state = 69, .external_lex_state = 2},
  [391] = {.lex_state = 69, .external_lex_state = 2},
  [392] = {.lex_state = 69, .external_lex_state = 2},
  [393] = {.lex_state = 69, .external_lex_state = 2},
  [394] = {.lex_state = 62, .external_lex_state = 2},
  [395] = {.lex_state = 69, .external_lex_state = 2},
  [396] = {.lex_state = 69, .external_lex_state = 2},
  [397] = {.lex_state = 69, .external_lex_state = 2},
  [398] = {.lex_state = 69, .external_lex_state = 2},
  [399] = {.lex_state = 69, .external_lex_state = 2},
  [400] = {.lex_state = 69, .external_lex_state = 2},
  [401] = {.lex_state = 69, .external_lex_state = 2},
  [402] = {.lex_state = 69, .external_lex_state = 2},
  [403] = {.lex_state = 69, .external_lex_state = 2},
  [404] = {.lex_state = 69, .external_lex_state = 2},
  [405] = {.lex_state = 69, .external_lex_state = 2},
  [406] = {.lex_state = 69, .external_lex_state = 2},
  [407] = {.lex_state = 69, .external_lex_state = 2},
  [408] = {.lex_state = 69, .external_lex_state = 2},
  [409] = {.lex_state = 69, .external_lex_state = 2},
  [410] = {.lex_state = 69, .external_lex_state = 2},
  [411] = {.lex_state = 69, .external_lex_state = 2},
  [412] = {.lex_state = 69, .external_lex_state = 2},
  [413] = {.lex_state = 69, .external_lex_state = 2},
  [414] = {.lex_state = 69, .external_lex_state = 2},
  [415] = {.lex_state = 69, .external_lex_state = 2},
  [416] = {.lex_state = 69, .external_lex_state = 2},
  [417] = {.lex_state = 69, .external_lex_state = 2},
  [418] = {.lex_state = 69, .external_lex_state = 2},
  [419] = {.lex_state = 69, .external_lex_state = 2},
  [420] = {.lex_state = 69, .external_lex_state = 2},
  [421] = {.lex_state = 69, .external_lex_state = 2},
  [422] = {.lex_state = 69, .external_lex_state = 2},
  [423] = {.lex_state = 69, .external_lex_state = 2},
  [424] = {.lex_state = 69, .external_lex_state = 2},
  [425] = {.lex_state = 69, .external_lex_state = 2},
  [426] = {.lex_state = 69, .external_lex_state = 2},
  [427] = {.lex_state = 69, .external_lex_state = 2},
  [428] = {.lex_state = 69, .external_lex_state = 2},
  [429] = {.lex_state = 69, .external_lex_state = 2},
  [430] = {.lex_state = 69, .external_lex_state = 2},
  [431] = {.lex_state = 69, .external_lex_state = 2},
  [432] = {.lex_state = 69, .external_lex_state = 2},
  [433] = {.lex_state = 69, .external_lex_state = 2},
  [434] = {.lex_state = 69, .external_lex_state = 2},
  [435] = {.lex_state = 69, .external_lex_state = 2},
  [436] = {.lex_state = 69, .external_lex_state = 2},
  [437] = {.lex_state = 69, .external_lex_state = 2},
  [438] = {.lex_state = 69, .external_lex_state = 2},
  [439] = {.lex_state = 69, .external_lex_state = 2},
  [440] = {.lex_state = 69, .external_lex_state = 2},
  [441] = {.lex_state = 69, .external_lex_state = 2},
  [442] = {.lex_state = 69, .external_lex_state = 2},
  [443] = {.lex_state = 69, .external_lex_state = 2},
  [444] = {.lex_state = 69, .external_lex_state = 2},
  [445] = {.lex_state = 69, .external_lex_state = 2},
  [446] = {.lex_state = 69, .external_lex_state = 2},
  [447] = {.lex_state = 69, .external_lex_state = 2},
  [448] = {.lex_state = 69, .external_lex_state = 2},
  [449] = {.lex_state = 69, .external_lex_state = 2},
  [450] = {.lex_state = 69, .external_lex_state = 2},
  [451] = {.lex_state = 69, .external_lex_state = 2},
  [452] = {.lex_state = 69, .external_lex_state = 2},
  [453] = {.lex_state = 69, .external_lex_state = 2},
  [454] = {.lex_state = 69, .external_lex_state = 2},
  [455] = {.lex_state = 69, .external_lex_state = 2},
  [456] = {.lex_state = 69, .external_lex_state = 2},
  [457] = {.lex_state = 69, .external_lex_state = 2},
  [458] = {.lex_state = 69, .external_lex_state = 2},
  [459] = {.lex_state = 69, .external_lex_state = 2},
  [460] = {.lex_state = 69, .external_lex_state = 2},
  [461] = {.lex_state = 69, .external_lex_state = 2},
  [462] = {.lex_state = 69, .external_lex_state = 2},
  [463] = {.lex_state = 69, .external_lex_state = 2},
  [464] = {.lex_state = 69, .external_lex_state = 2},
  [465] = {.lex_state = 69, .external_lex_state = 2},
  [466] = {.lex_state = 69, .external_lex_state = 2},
  [467] = {.lex_state = 69, .external_lex_state = 2},
  [468] = {.lex_state = 69, .external_lex_state = 2},
  [469] = {.lex_state = 69, .external_lex_state = 2},
  [470] = {.lex_state = 69, .external_lex_state = 2},
  [471] = {.lex_state = 69, .external_lex_state = 2},
  [472] = {.lex_state = 69, .external_lex_state = 2},
  [473] = {.lex_state = 69, .external_lex_state = 2},
  [474] = {.lex_state = 69, .external_lex_state = 2},
  [475] = {.lex_state = 69, .external_lex_state = 2},
  [476] = {.lex_state = 69, .external_lex_state = 2},
  [477] = {.lex_state = 69, .external_lex_state = 2},
  [478] = {.lex_state = 69, .external_lex_state = 2},
  [479] = {.lex_state = 69, .external_lex_state = 2},
  [480] = {.lex_state = 69, .external_lex_state = 2},
  [481] = {.lex_state = 69, .external_lex_state = 2},
  [482] = {.lex_state = 69, .external_lex_state = 2},
  [483] = {.lex_state = 69, .external_lex_state = 2},
  [484] = {.lex_state = 69, .external_lex_state = 2},
  [485] = {.lex_state = 69, .external_lex_state = 2},
  [486] = {.lex_state = 69, .external_lex_state = 2},
  [487] = {.lex_state = 69, .external_lex_state = 2},
  [488] = {.lex_state = 69, .external_lex_state = 2},
  [489] = {.lex_state = 69, .external_lex_state = 2},
  [490] = {.lex_state = 69, .external_lex_state = 2},
  [491] = {.lex_state = 69, .external_lex_state = 2},
  [492] = {.lex_state = 69, .external_lex_state = 2},
  [493] = {.lex_state = 69, .external_lex_state = 2},
  [494] = {.lex_state = 69, .external_lex_state = 2},
  [495] = {.lex_state = 69, .external_lex_state = 2},
  [496] = {.lex_state = 69, .external_lex_state = 2},
  [497] = {.lex_state = 69, .external_lex_state = 2},
  [498] = {.lex_state = 69, .external_lex_state = 2},
  [499] = {.lex_state = 69, .external_lex_state = 2},
  [500] = {.lex_state = 69, .external_lex_state = 2},
  [501] = {.lex_state = 69, .external_lex_state = 2},
  [502] = {.lex_state = 69, .external_lex_state = 2},
  [503] = {.lex_state = 69, .external_lex_state = 2},
  [504] = {.lex_state = 69, .external_lex_state = 2},
  [505] = {.lex_state = 69, .external_lex_state = 2},
  [506] = {.lex_state = 69, .external_lex_state = 2},
  [507] = {.lex_state = 69, .external_lex_state = 2},
  [508] = {.lex_state = 69, .external_lex_state = 2},
  [509] = {.lex_state = 69, .external_lex_state = 2},
  [510] = {.lex_state = 69, .external_lex_state = 2},
  [511] = {.lex_state = 69, .external_lex_state = 2},
  [512] = {.lex_state = 69, .external_lex_state = 2},
  [513] = {.lex_state = 69, .external_lex_state = 2},
  [514] = {.lex_state = 69, .external_lex_state = 2},
  [515] = {.lex_state = 69, .external_lex_state = 2},
  [516] = {.lex_state = 69, .external_lex_state = 2},
  [517] = {.lex_state = 69, .external_lex_state = 2},
  [518] = {.lex_state = 69, .external_lex_state = 2},
  [519] = {.lex_state = 69, .external_lex_state = 2},
  [520] = {.lex_state = 69, .external_lex_state = 2},
  [521] = {.lex_state = 69, .external_lex_state = 2},
  [522] = {.lex_state = 69, .external_lex_state = 2},
  [523] = {.lex_state = 69, .external_lex_state = 2},
  [524] = {.lex_state = 69, .external_lex_state = 2},
  [525] = {.lex_state = 69, .external_lex_state = 2},
  [526] = {.lex_state = 69, .external_lex_state = 2},
  [527] = {.lex_state = 69, .external_lex_state = 2},
  [528] = {.lex_state = 69, .external_lex_state = 2},
  [529] = {.lex_state = 69, .external_lex_state = 2},
  [530] = {.lex_state = 69, .external_lex_state = 2},
  [531] = {.lex_state = 69, .external_lex_state = 2},
  [532] = {.lex_state = 69, .external_lex_state = 2},
  [533] = {.lex_state = 69, .external_lex_state = 2},
  [534] = {.lex_state = 69, .external_lex_state = 2},
  [535] = {.lex_state = 69, .external_lex_state = 2},
  [536] = {.lex_state = 69, .external_lex_state = 2},
  [537] = {.lex_state = 69, .external_lex_state = 2},
  [538] = {.lex_state = 69, .external_lex_state = 2},
  [539] = {.lex_state = 69, .external_lex_state = 2},
  [540] = {.lex_state = 69, .external_lex_state = 2},
  [541] = {.lex_state = 69, .external_lex_state = 2},
  [542] = {.lex_state = 69, .external_lex_state = 2},
  [543] = {.lex_state = 69, .external_lex_state = 2},
  [544] = {.lex_state = 69, .external_lex_state = 2},
  [545] = {.lex_state = 69, .external_lex_state = 2},
  [546] = {.lex_state = 69, .external_lex_state = 2},
  [547] = {.lex_state = 69, .external_lex_state = 2},
  [548] = {.lex_state = 69, .external_lex_state = 2},
  [549] = {.lex_state = 69, .external_lex_state = 2},
  [550] = {.lex_state = 69, .external_lex_state = 2},
  [551] = {.lex_state = 69, .external_lex_state = 2},
  [552] = {.lex_state = 69, .external_lex_state = 2},
  [553] = {.lex_state = 69, .external_lex_state = 2},
  [554] = {.lex_state = 69, .external_lex_state = 2},
  [555] = {.lex_state = 69, .external_lex_state = 2},
  [556] = {.lex_state = 69, .external_lex_state = 2},
  [557] = {.lex_state = 69, .external_lex_state = 2},
  [558] = {.lex_state = 69, .external_lex_state = 2},
  [559] = {.lex_state = 69, .external_lex_state = 2},
  [560] = {.lex_state = 69, .external_lex_state = 2},
  [561] = {.lex_state = 69, .external_lex_state = 2},
  [562] = {.lex_state = 69, .external_lex_state = 2},
  [563] = {.lex_state = 69, .external_lex_state = 2},
  [564] = {.lex_state = 69, .external_lex_state = 2},
  [565] = {.lex_state = 69, .external_lex_state = 2},
  [566] = {.lex_state = 69, .external_lex_state = 2},
  [567] = {.lex_state = 69, .external_lex_state = 2},
  [568] = {.lex_state = 69, .external_lex_state = 2},
  [569] = {.lex_state = 69, .external_lex_state = 2},
  [570] = {.lex_state = 69, .external_lex_state = 2},
  [571] = {.lex_state = 69, .external_lex_state = 2},
  [572] = {.lex_state = 69, .external_lex_state = 2},
  [573] = {.lex_state = 69, .external_lex_state = 2},
  [574] = {.lex_state = 69, .external_lex_state = 2},
  [575] = {.lex_state = 69, .external_lex_state = 2},
  [576] = {.lex_state = 69, .external_lex_state = 2},
  [577] = {.lex_state = 69, .external_lex_state = 2},
  [578] = {.lex_state = 69, .external_lex_state = 2},
  [579] = {.lex_state = 69, .external_lex_state = 2},
  [580] = {.lex_state = 69, .external_lex_state = 2},
  [581] = {.lex_state = 69, .external_lex_state = 2},
  [582] = {.lex_state = 69, .external_lex_state = 2},
  [583] = {.lex_state = 69, .external_lex_state = 2},
  [584] = {.lex_state = 69, .external_lex_state = 2},
  [585] = {.lex_state = 69, .external_lex_state = 2},
  [586] = {.lex_state = 69, .external_lex_state = 2},
  [587] = {.lex_state = 69, .external_lex_state = 2},
  [588] = {.lex_state = 69, .external_lex_state = 2},
  [589] = {.lex_state = 69, .external_lex_state = 2},
  [590] = {.lex_state = 69, .external_lex_state = 2},
  [591] = {.lex_state = 69, .external_lex_state = 2},
  [592] = {.lex_state = 69, .external_lex_state = 2},
  [593] = {.lex_state = 69, .external_lex_state = 2},
  [594] = {.lex_state = 69, .external_lex_state = 2},
  [595] = {.lex_state = 69, .external_lex_state = 2},
  [596] = {.lex_state = 69, .external_lex_state = 2},
  [597] = {.lex_state = 69, .external_lex_state = 2},
  [598] = {.lex_state = 69, .external_lex_state = 2},
  [599] = {.lex_state = 69, .external_lex_state = 2},
  [600] = {.lex_state = 69, .external_lex_state = 2},
  [601] = {.lex_state = 69, .external_lex_state = 2},
  [602] = {.lex_state = 69, .external_lex_state = 2},
  [603] = {.lex_state = 69, .external_lex_state = 2},
  [604] = {.lex_state = 64, .external_lex_state = 4},
  [605] = {.lex_state = 64, .external_lex_state = 4},
  [606] = {.lex_state = 64, .external_lex_state = 4},
  [607] = {.lex_state = 64, .external_lex_state = 4},
  [608] = {.lex_state = 64, .external_lex_state = 4},
  [609] = {.lex_state = 64, .external_lex_state = 4},
  [610] = {.lex_state = 64, .external_lex_state = 4},
  [611] = {.lex_state = 755, .external_lex_state = 2},
  [612] = {.lex_state = 73, .external_lex_state = 17},
  [613] = {.lex_state = 73, .external_lex_state = 17},
  [614] = {.lex_state = 49, .external_lex_state = 5},
  [615] = {.lex_state = 49, .external_lex_state = 5},
  [616] = {.lex_state = 49, .external_lex_state = 5},
  [617] = {.lex_state = 49, .external_lex_state = 5},
  [618] = {.lex_state = 49, .external_lex_state = 5},
  [619] = {.lex_state = 49, .external_lex_state = 5},
  [620] = {.lex_state = 49, .external_lex_state = 5},
  [621] = {.lex_state = 49, .external_lex_state = 6},
  [622] = {.lex_state = 49, .external_lex_state = 6},
  [623] = {.lex_state = 49, .external_lex_state = 6},
  [624] = {.lex_state = 49, .external_lex_state = 6},
  [625] = {.lex_state = 49, .external_lex_state = 6},
  [626] = {.lex_state = 764, .external_lex_state = 18},
  [627] = {.lex_state = 49, .external_lex_state = 6},
  [628] = {.lex_state = 49, .external_lex_state = 6},
  [629] = {.lex_state = 764, .external_lex_state = 18},
  [630] = {.lex_state = 764, .external_lex_state = 18},
  [631] = {.lex_state = 764, .external_lex_state = 18},
  [632] = {.lex_state = 764, .external_lex_state = 18},
  [633] = {.lex_state = 764, .external_lex_state = 18},
  [634] = {.lex_state = 764, .external_lex_state = 18},
  [635] = {.lex_state = 764, .external_lex_state = 18},
  [636] = {.lex_state = 764, .external_lex_state = 18},
  [637] = {.lex_state = 764, .external_lex_state = 18},
  [638] = {.lex_state = 764, .external_lex_state = 18},
  [639] = {.lex_state = 764, .external_lex_state = 18},
  [640] = {.lex_state = 77, .external_lex_state = 19},
  [641] = {.lex_state = 77, .external_lex_state = 19},
  [642] = {.lex_state = 77, .external_lex_state = 20},
  [643] = {.lex_state = 77, .external_lex_state = 20},
  [644] = {.lex_state = 764, .external_lex_state = 21},
  [645] = {.lex_state = 764, .external_lex_state = 21},
  [646] = {.lex_state = 764, .external_lex_state = 22},
  [647] = {.lex_state = 764, .external_lex_state = 21},
  [648] = {.lex_state = 764, .external_lex_state = 21},
  [649] = {.lex_state = 764, .external_lex_state = 21},
  [650] = {.lex_state = 764, .external_lex_state = 21},
  [651] = {.lex_state = 764, .external_lex_state = 22},
  [652] = {.lex_state = 764, .external_lex_state = 21},
  [653] = {.lex_state = 764, .external_lex_state = 21},
  [654] = {.lex_state = 764, .external_lex_state = 21},
  [655] = {.lex_state = 764, .external_lex_state = 21},
  [656] = {.lex_state = 764, .external_lex_state = 21},
  [657] = {.lex_state = 764, .external_lex_state = 22},
  [658] = {.lex_state = 74, .external_lex_state = 18},
  [659] = {.lex_state = 764, .external_lex_state = 22},
  [660] = {.lex_state = 764, .external_lex_state = 22},
  [661] = {.lex_state = 764, .external_lex_state = 22},
  [662] = {.lex_state = 764, .external_lex_state = 22},
  [663] = {.lex_state = 764, .external_lex_state = 22},
  [664] = {.lex_state = 764, .external_lex_state = 22},
  [665] = {.lex_state = 764, .external_lex_state = 22},
  [666] = {.lex_state = 764, .external_lex_state = 22},
  [667] = {.lex_state = 764, .external_lex_state = 22},
  [668] = {.lex_state = 764, .external_lex_state = 22},
  [669] = {.lex_state = 764, .external_lex_state = 22},
  [670] = {.lex_state = 764, .external_lex_state = 22},
  [671] = {.lex_state = 764, .external_lex_state = 22},
  [672] = {.lex_state = 58, .external_lex_state = 2},
  [673] = {.lex_state = 58, .external_lex_state = 2},
  [674] = {.lex_state = 58, .external_lex_state = 2},
  [675] = {.lex_state = 58, .external_lex_state = 2},
  [676] = {.lex_state = 58, .external_lex_state = 2},
  [677] = {.lex_state = 58, .external_lex_state = 2},
  [678] = {.lex_state = 58, .external_lex_state = 2},
  [679] = {.lex_state = 764, .external_lex_state = 17},
  [680] = {.lex_state = 764, .external_lex_state = 17},
  [681] = {.lex_state = 764, .external_lex_state = 17},
  [682] = {.lex_state = 74, .external_lex_state = 18},
  [683] = {.lex_state = 74, .external_lex_state = 18},
  [684] = {.lex_state = 74, .external_lex_state = 18},
  [685] = {.lex_state = 764, .external_lex_state = 17},
  [686] = {.lex_state = 764, .external_lex_state = 17},
  [687] = {.lex_state = 764, .external_lex_state = 17},
  [688] = {.lex_state = 764, .external_lex_state = 17},
  [689] = {.lex_state = 764, .external_lex_state = 17},
  [690] = {.lex_state = 764, .external_lex_state = 17},
  [691] = {.lex_state = 764, .external_lex_state = 17},
  [692] = {.lex_state = 764, .external_lex_state = 17},
  [693] = {.lex_state = 764, .external_lex_state = 17},
  [694] = {.lex_state = 764, .external_lex_state = 17},
  [695] = {.lex_state = 764, .external_lex_state = 17},
  [696] = {.lex_state = 764, .external_lex_state = 17},
  [697] = {.lex_state = 764, .external_lex_state = 18},
  [698] = {.lex_state = 764, .external_lex_state = 17},
  [699] = {.lex_state = 764, .external_lex_state = 17},
  [700] = {.lex_state = 764, .external_lex_state = 18},
  [701] = {.lex_state = 764, .external_lex_state = 17},
  [702] = {.lex_state = 764, .external_lex_state = 17},
  [703] = {.lex_state = 764, .external_lex_state = 18},
  [704] = {.lex_state = 764, .external_lex_state = 18},
  [705] = {.lex_state = 764, .external_lex_state = 17},
  [706] = {.lex_state = 764, .external_lex_state = 17},
  [707] = {.lex_state = 764, .external_lex_state = 17},
  [708] = {.lex_state = 764, .external_lex_state = 17},
  [709] = {.lex_state = 764, .external_lex_state = 17},
  [710] = {.lex_state = 764, .external_lex_state = 17},
  [711] = {.lex_state = 764, .external_lex_state = 17},
  [712] = {.lex_state = 764, .external_lex_state = 17},
  [713] = {.lex_state = 764, .external_lex_state = 17},
  [714] = {.lex_state = 764, .external_lex_state = 17},
  [715] = {.lex_state = 764, .external_lex_state = 17},
  [716] = {.lex_state = 764, .external_lex_state = 17},
  [717] = {.lex_state = 764, .external_lex_state = 17},
  [718] = {.lex_state = 83, .external_lex_state = 23},
  [719] = {.lex_state = 81, .external_lex_state = 20},
  [720] = {.lex_state = 74, .external_lex_state = 18},
  [721] = {.lex_state = 74, .external_lex_state = 18},
  [722] = {.lex_state = 764, .external_lex_state = 17},
  [723] = {.lex_state = 74, .external_lex_state = 18},
  [724] = {.lex_state = 764, .external_lex_state = 17},
  [725] = {.lex_state = 74, .external_lex_state = 18},
  [726] = {.lex_state = 74, .external_lex_state = 18},
  [727] = {.lex_state = 74, .external_lex_state = 18},
  [728] = {.lex_state = 764, .external_lex_state = 18},
  [729] = {.lex_state = 764, .external_lex_state = 18},
  [730] = {.lex_state = 764, .external_lex_state = 18},
  [731] = {.lex_state = 764, .external_lex_state = 18},
  [732] = {.lex_state = 764, .external_lex_state = 18},
  [733] = {.lex_state = 764, .external_lex_state = 18},
  [734] = {.lex_state = 764, .external_lex_state = 18},
  [735] = {.lex_state = 764, .external_lex_state = 18},
  [736] = {.lex_state = 764, .external_lex_state = 18},
  [737] = {.lex_state = 764, .external_lex_state = 18},
  [738] = {.lex_state = 764, .external_lex_state = 18},
  [739] = {.lex_state = 764, .external_lex_state = 24},
  [740] = {.lex_state = 764, .external_lex_state = 18},
  [741] = {.lex_state = 764, .external_lex_state = 18},
  [742] = {.lex_state = 764, .external_lex_state = 24},
  [743] = {.lex_state = 764, .external_lex_state = 18},
  [744] = {.lex_state = 764, .external_lex_state = 18},
  [745] = {.lex_state = 764, .external_lex_state = 18},
  [746] = {.lex_state = 764, .external_lex_state = 18},
  [747] = {.lex_state = 764, .external_lex_state = 24},
  [748] = {.lex_state = 764, .external_lex_state = 24},
  [749] = {.lex_state = 764, .external_lex_state = 18},
  [750] = {.lex_state = 78, .external_lex_state = 21},
  [751] = {.lex_state = 764, .external_lex_state = 18},
  [752] = {.lex_state = 764, .external_lex_state = 18},
  [753] = {.lex_state = 764, .external_lex_state = 18},
  [754] = {.lex_state = 764, .external_lex_state = 18},
  [755] = {.lex_state = 764, .external_lex_state = 18},
  [756] = {.lex_state = 764, .external_lex_state = 18},
  [757] = {.lex_state = 764, .external_lex_state = 18},
  [758] = {.lex_state = 764, .external_lex_state = 18},
  [759] = {.lex_state = 764, .external_lex_state = 18},
  [760] = {.lex_state = 764, .external_lex_state = 18},
  [761] = {.lex_state = 764, .external_lex_state = 18},
  [762] = {.lex_state = 764, .external_lex_state = 18},
  [763] = {.lex_state = 764, .external_lex_state = 18},
  [764] = {.lex_state = 764, .external_lex_state = 18},
  [765] = {.lex_state = 764, .external_lex_state = 18},
  [766] = {.lex_state = 764, .external_lex_state = 18},
  [767] = {.lex_state = 764, .external_lex_state = 18},
  [768] = {.lex_state = 764, .external_lex_state = 18},
  [769] = {.lex_state = 764, .external_lex_state = 18},
  [770] = {.lex_state = 764, .external_lex_state = 18},
  [771] = {.lex_state = 764, .external_lex_state = 18},
  [772] = {.lex_state = 764, .external_lex_state = 18},
  [773] = {.lex_state = 764, .external_lex_state = 18},
  [774] = {.lex_state = 764, .external_lex_state = 18},
  [775] = {.lex_state = 764, .external_lex_state = 18},
  [776] = {.lex_state = 764, .external_lex_state = 18},
  [777] = {.lex_state = 764, .external_lex_state = 18},
  [778] = {.lex_state = 764, .external_lex_state = 18},
  [779] = {.lex_state = 764, .external_lex_state = 18},
  [780] = {.lex_state = 764, .external_lex_state = 18},
  [781] = {.lex_state = 764, .external_lex_state = 18},
  [782] = {.lex_state = 764, .external_lex_state = 18},
  [783] = {.lex_state = 764, .external_lex_state = 18},
  [784] = {.lex_state = 764, .external_lex_state = 18},
  [785] = {.lex_state = 764, .external_lex_state = 18},
  [786] = {.lex_state = 764, .external_lex_state = 18},
  [787] = {.lex_state = 764, .external_lex_state = 18},
  [788] = {.lex_state = 764, .external_lex_state = 18},
  [789] = {.lex_state = 764, .external_lex_state = 18},
  [790] = {.lex_state = 764, .external_lex_state = 18},
  [791] = {.lex_state = 764, .external_lex_state = 18},
  [792] = {.lex_state = 764, .external_lex_state = 18},
  [793] = {.lex_state = 764, .external_lex_state = 18},
  [794] = {.lex_state = 764, .external_lex_state = 18},
  [795] = {.lex_state = 764, .external_lex_state = 18},
  [796] = {.lex_state = 764, .external_lex_state = 18},
  [797] = {.lex_state = 764, .external_lex_state = 18},
  [798] = {.lex_state = 764, .external_lex_state = 18},
  [799] = {.lex_state = 764, .external_lex_state = 18},
  [800] = {.lex_state = 764, .external_lex_state = 18},
  [801] = {.lex_state = 764, .external_lex_state = 18},
  [802] = {.lex_state = 764, .external_lex_state = 18},
  [803] = {.lex_state = 764, .external_lex_state = 18},
  [804] = {.lex_state = 764, .external_lex_state = 18},
  [805] = {.lex_state = 764, .external_lex_state = 18},
  [806] = {.lex_state = 764, .external_lex_state = 18},
  [807] = {.lex_state = 764, .external_lex_state = 18},
  [808] = {.lex_state = 764, .external_lex_state = 18},
  [809] = {.lex_state = 764, .external_lex_state = 18},
  [810] = {.lex_state = 764, .external_lex_state = 18},
  [811] = {.lex_state = 764, .external_lex_state = 18},
  [812] = {.lex_state = 764, .external_lex_state = 18},
  [813] = {.lex_state = 764, .external_lex_state = 18},
  [814] = {.lex_state = 764, .external_lex_state = 18},
  [815] = {.lex_state = 764, .external_lex_state = 18},
  [816] = {.lex_state = 764, .external_lex_state = 18},
  [817] = {.lex_state = 764, .external_lex_state = 18},
  [818] = {.lex_state = 764, .external_lex_state = 18},
  [819] = {.lex_state = 764, .external_lex_state = 18},
  [820] = {.lex_state = 764, .external_lex_state = 18},
  [821] = {.lex_state = 764, .external_lex_state = 18},
  [822] = {.lex_state = 764, .external_lex_state = 18},
  [823] = {.lex_state = 764, .external_lex_state = 18},
  [824] = {.lex_state = 764, .external_lex_state = 18},
  [825] = {.lex_state = 764, .external_lex_state = 18},
  [826] = {.lex_state = 764, .external_lex_state = 18},
  [827] = {.lex_state = 764, .external_lex_state = 18},
  [828] = {.lex_state = 764, .external_lex_state = 18},
  [829] = {.lex_state = 764, .external_lex_state = 18},
  [830] = {.lex_state = 78, .external_lex_state = 22},
  [831] = {.lex_state = 764, .external_lex_state = 25},
  [832] = {.lex_state = 764, .external_lex_state = 25},
  [833] = {.lex_state = 756, .external_lex_state = 9},
  [834] = {.lex_state = 764, .external_lex_state = 25},
  [835] = {.lex_state = 756, .external_lex_state = 9},
  [836] = {.lex_state = 756, .external_lex_state = 9},
  [837] = {.lex_state = 756, .external_lex_state = 9},
  [838] = {.lex_state = 756, .external_lex_state = 9},
  [839] = {.lex_state = 756, .external_lex_state = 9},
  [840] = {.lex_state = 756, .external_lex_state = 9},
  [841] = {.lex_state = 756, .external_lex_state = 10},
  [842] = {.lex_state = 756, .external_lex_state = 10},
  [843] = {.lex_state = 756, .external_lex_state = 10},
  [844] = {.lex_state = 82, .external_lex_state = 20},
  [845] = {.lex_state = 756, .external_lex_state = 10},
  [846] = {.lex_state = 84, .external_lex_state = 23},
  [847] = {.lex_state = 78, .external_lex_state = 21},
  [848] = {.lex_state = 756, .external_lex_state = 10},
  [849] = {.lex_state = 78, .external_lex_state = 21},
  [850] = {.lex_state = 82, .external_lex_state = 20},
  [851] = {.lex_state = 78, .external_lex_state = 21},
  [852] = {.lex_state = 84, .external_lex_state = 23},
  [853] = {.lex_state = 756, .external_lex_state = 10},
  [854] = {.lex_state = 756, .external_lex_state = 10},
  [855] = {.lex_state = 756, .external_lex_state = 4},
  [856] = {.lex_state = 756, .external_lex_state = 10},
  [857] = {.lex_state = 756, .external_lex_state = 10},
  [858] = {.lex_state = 78, .external_lex_state = 22},
  [859] = {.lex_state = 756, .external_lex_state = 10},
  [860] = {.lex_state = 756, .external_lex_state = 4},
  [861] = {.lex_state = 756, .external_lex_state = 4},
  [862] = {.lex_state = 756, .external_lex_state = 10},
  [863] = {.lex_state = 78, .external_lex_state = 22},
  [864] = {.lex_state = 756, .external_lex_state = 4},
  [865] = {.lex_state = 756, .external_lex_state = 10},
  [866] = {.lex_state = 756, .external_lex_state = 10},
  [867] = {.lex_state = 756, .external_lex_state = 4},
  [868] = {.lex_state = 756, .external_lex_state = 4},
  [869] = {.lex_state = 756, .external_lex_state = 10},
  [870] = {.lex_state = 78, .external_lex_state = 22},
  [871] = {.lex_state = 756, .external_lex_state = 4},
  [872] = {.lex_state = 756, .external_lex_state = 12},
  [873] = {.lex_state = 756, .external_lex_state = 12},
  [874] = {.lex_state = 756, .external_lex_state = 11},
  [875] = {.lex_state = 756, .external_lex_state = 12},
  [876] = {.lex_state = 756, .external_lex_state = 11},
  [877] = {.lex_state = 756, .external_lex_state = 11},
  [878] = {.lex_state = 756, .external_lex_state = 12},
  [879] = {.lex_state = 756, .external_lex_state = 11},
  [880] = {.lex_state = 756, .external_lex_state = 11},
  [881] = {.lex_state = 756, .external_lex_state = 12},
  [882] = {.lex_state = 756, .external_lex_state = 12},
  [883] = {.lex_state = 764, .external_lex_state = 19},
  [884] = {.lex_state = 756, .external_lex_state = 12},
  [885] = {.lex_state = 756, .external_lex_state = 11},
  [886] = {.lex_state = 756, .external_lex_state = 11},
  [887] = {.lex_state = 756, .external_lex_state = 13},
  [888] = {.lex_state = 764, .external_lex_state = 19},
  [889] = {.lex_state = 756, .external_lex_state = 13},
  [890] = {.lex_state = 756, .external_lex_state = 13},
  [891] = {.lex_state = 764, .external_lex_state = 19},
  [892] = {.lex_state = 764, .external_lex_state = 19},
  [893] = {.lex_state = 764, .external_lex_state = 19},
  [894] = {.lex_state = 764, .external_lex_state = 20},
  [895] = {.lex_state = 756, .external_lex_state = 13},
  [896] = {.lex_state = 764, .external_lex_state = 19},
  [897] = {.lex_state = 764, .external_lex_state = 19},
  [898] = {.lex_state = 756, .external_lex_state = 13},
  [899] = {.lex_state = 78, .external_lex_state = 22},
  [900] = {.lex_state = 756, .external_lex_state = 13},
  [901] = {.lex_state = 764, .external_lex_state = 19},
  [902] = {.lex_state = 756, .external_lex_state = 13},
  [903] = {.lex_state = 764, .external_lex_state = 20},
  [904] = {.lex_state = 78, .external_lex_state = 21},
  [905] = {.lex_state = 764, .external_lex_state = 20},
  [906] = {.lex_state = 78, .external_lex_state = 21},
  [907] = {.lex_state = 78, .external_lex_state = 21},
  [908] = {.lex_state = 78, .external_lex_state = 21},
  [909] = {.lex_state = 78, .external_lex_state = 21},
  [910] = {.lex_state = 764, .external_lex_state = 20},
  [911] = {.lex_state = 764, .external_lex_state = 20},
  [912] = {.lex_state = 764, .external_lex_state = 22},
  [913] = {.lex_state = 764, .external_lex_state = 20},
  [914] = {.lex_state = 764, .external_lex_state = 20},
  [915] = {.lex_state = 764, .external_lex_state = 20},
  [916] = {.lex_state = 78, .external_lex_state = 21},
  [917] = {.lex_state = 78, .external_lex_state = 22},
  [918] = {.lex_state = 764, .external_lex_state = 19},
  [919] = {.lex_state = 78, .external_lex_state = 22},
  [920] = {.lex_state = 78, .external_lex_state = 22},
  [921] = {.lex_state = 78, .external_lex_state = 22},
  [922] = {.lex_state = 764, .external_lex_state = 19},
  [923] = {.lex_state = 764, .external_lex_state = 19},
  [924] = {.lex_state = 764, .external_lex_state = 19},
  [925] = {.lex_state = 78, .external_lex_state = 22},
  [926] = {.lex_state = 764, .external_lex_state = 19},
  [927] = {.lex_state = 764, .external_lex_state = 19},
  [928] = {.lex_state = 766, .external_lex_state = 26},
  [929] = {.lex_state = 78, .external_lex_state = 22},
  [930] = {.lex_state = 766, .external_lex_state = 26},
  [931] = {.lex_state = 764, .external_lex_state = 19},
  [932] = {.lex_state = 78, .external_lex_state = 22},
  [933] = {.lex_state = 764, .external_lex_state = 20},
  [934] = {.lex_state = 764, .external_lex_state = 20},
  [935] = {.lex_state = 764, .external_lex_state = 20},
  [936] = {.lex_state = 764, .external_lex_state = 19},
  [937] = {.lex_state = 764, .external_lex_state = 20},
  [938] = {.lex_state = 764, .external_lex_state = 19},
  [939] = {.lex_state = 764, .external_lex_state = 20},
  [940] = {.lex_state = 764, .external_lex_state = 20},
  [941] = {.lex_state = 764, .external_lex_state = 20},
  [942] = {.lex_state = 764, .external_lex_state = 19},
  [943] = {.lex_state = 764, .external_lex_state = 21},
  [944] = {.lex_state = 766, .external_lex_state = 27},
  [945] = {.lex_state = 766, .external_lex_state = 27},
  [946] = {.lex_state = 764, .external_lex_state = 19},
  [947] = {.lex_state = 764, .external_lex_state = 21},
  [948] = {.lex_state = 764, .external_lex_state = 21},
  [949] = {.lex_state = 764, .external_lex_state = 21},
  [950] = {.lex_state = 764, .external_lex_state = 19},
  [951] = {.lex_state = 764, .external_lex_state = 20},
  [952] = {.lex_state = 764, .external_lex_state = 19},
  [953] = {.lex_state = 764, .external_lex_state = 19},
  [954] = {.lex_state = 764, .external_lex_state = 19},
  [955] = {.lex_state = 764, .external_lex_state = 19},
  [956] = {.lex_state = 764, .external_lex_state = 19},
  [957] = {.lex_state = 764, .external_lex_state = 19},
  [958] = {.lex_state = 764, .external_lex_state = 19},
  [959] = {.lex_state = 764, .external_lex_state = 19},
  [960] = {.lex_state = 764, .external_lex_state = 19},
  [961] = {.lex_state = 764, .external_lex_state = 19},
  [962] = {.lex_state = 764, .external_lex_state = 19},
  [963] = {.lex_state = 764, .external_lex_state = 20},
  [964] = {.lex_state = 764, .external_lex_state = 19},
  [965] = {.lex_state = 764, .external_lex_state = 19},
  [966] = {.lex_state = 764, .external_lex_state = 19},
  [967] = {.lex_state = 764, .external_lex_state = 22},
  [968] = {.lex_state = 764, .external_lex_state = 20},
  [969] = {.lex_state = 764, .external_lex_state = 20},
  [970] = {.lex_state = 764, .external_lex_state = 20},
  [971] = {.lex_state = 766, .external_lex_state = 28},
  [972] = {.lex_state = 764, .external_lex_state = 20},
  [973] = {.lex_state = 764, .external_lex_state = 20},
  [974] = {.lex_state = 764, .external_lex_state = 22},
  [975] = {.lex_state = 764, .external_lex_state = 20},
  [976] = {.lex_state = 764, .external_lex_state = 20},
  [977] = {.lex_state = 764, .external_lex_state = 20},
  [978] = {.lex_state = 766, .external_lex_state = 28},
  [979] = {.lex_state = 764, .external_lex_state = 20},
  [980] = {.lex_state = 764, .external_lex_state = 20},
  [981] = {.lex_state = 764, .external_lex_state = 22},
  [982] = {.lex_state = 764, .external_lex_state = 20},
  [983] = {.lex_state = 764, .external_lex_state = 20},
  [984] = {.lex_state = 764, .external_lex_state = 20},
  [985] = {.lex_state = 764, .external_lex_state = 20},
  [986] = {.lex_state = 764, .external_lex_state = 20},
  [987] = {.lex_state = 764, .external_lex_state = 20},
  [988] = {.lex_state = 764, .external_lex_state = 22},
  [989] = {.lex_state = 764, .external_lex_state = 20},
  [990] = {.lex_state = 107, .external_lex_state = 29},
  [991] = {.lex_state = 107, .external_lex_state = 29},
  [992] = {.lex_state = 107, .external_lex_state = 29},
  [993] = {.lex_state = 107, .external_lex_state = 29},
  [994] = {.lex_state = 107, .external_lex_state = 29},
  [995] = {.lex_state = 766, .external_lex_state = 30},
  [996] = {.lex_state = 766, .external_lex_state = 30},
  [997] = {.lex_state = 107, .external_lex_state = 29},
  [998] = {.lex_state = 107, .external_lex_state = 29},
  [999] = {.lex_state = 762, .external_lex_state = 31},
  [1000] = {.lex_state = 762, .external_lex_state = 31},
  [1001] = {.lex_state = 107, .external_lex_state = 29},
  [1002] = {.lex_state = 107, .external_lex_state = 29},
  [1003] = {.lex_state = 764, .external_lex_state = 21},
  [1004] = {.lex_state = 764, .external_lex_state = 21},
  [1005] = {.lex_state = 764, .external_lex_state = 21},
  [1006] = {.lex_state = 764, .external_lex_state = 21},
  [1007] = {.lex_state = 764, .external_lex_state = 21},
  [1008] = {.lex_state = 764, .external_lex_state = 21},
  [1009] = {.lex_state = 764, .external_lex_state = 21},
  [1010] = {.lex_state = 764, .external_lex_state = 21},
  [1011] = {.lex_state = 764, .external_lex_state = 21},
  [1012] = {.lex_state = 764, .external_lex_state = 21},
  [1013] = {.lex_state = 762, .external_lex_state = 23},
  [1014] = {.lex_state = 764, .external_lex_state = 21},
  [1015] = {.lex_state = 764, .external_lex_state = 21},
  [1016] = {.lex_state = 762, .external_lex_state = 23},
  [1017] = {.lex_state = 36, .external_lex_state = 32},
  [1018] = {.lex_state = 764, .external_lex_state = 21},
  [1019] = {.lex_state = 764, .external_lex_state = 22},
  [1020] = {.lex_state = 764, .external_lex_state = 33},
  [1021] = {.lex_state = 107, .external_lex_state = 29},
  [1022] = {.lex_state = 764, .external_lex_state = 22},
  [1023] = {.lex_state = 69, .external_lex_state = 2},
  [1024] = {.lex_state = 69, .external_lex_state = 2},
  [1025] = {.lex_state = 764, .external_lex_state = 22},
  [1026] = {.lex_state = 764, .external_lex_state = 33},
  [1027] = {.lex_state = 107, .external_lex_state = 29},
  [1028] = {.lex_state = 764, .external_lex_state = 21},
  [1029] = {.lex_state = 764, .external_lex_state = 22},
  [1030] = {.lex_state = 764, .external_lex_state = 21},
  [1031] = {.lex_state = 764, .external_lex_state = 21},
  [1032] = {.lex_state = 764, .external_lex_state = 22},
  [1033] = {.lex_state = 69, .external_lex_state = 2},
  [1034] = {.lex_state = 764, .external_lex_state = 22},
  [1035] = {.lex_state = 764, .external_lex_state = 21},
  [1036] = {.lex_state = 69, .external_lex_state = 2},
  [1037] = {.lex_state = 764, .external_lex_state = 22},
  [1038] = {.lex_state = 764, .external_lex_state = 22},
  [1039] = {.lex_state = 764, .external_lex_state = 21},
  [1040] = {.lex_state = 764, .external_lex_state = 21},
  [1041] = {.lex_state = 69, .external_lex_state = 2},
  [1042] = {.lex_state = 764, .external_lex_state = 22},
  [1043] = {.lex_state = 762, .external_lex_state = 17},
  [1044] = {.lex_state = 764, .external_lex_state = 21},
  [1045] = {.lex_state = 764, .external_lex_state = 22},
  [1046] = {.lex_state = 762, .external_lex_state = 17},
  [1047] = {.lex_state = 764, .external_lex_state = 33},
  [1048] = {.lex_state = 764, .external_lex_state = 22},
  [1049] = {.lex_state = 764, .external_lex_state = 33},
  [1050] = {.lex_state = 762, .external_lex_state = 23},
  [1051] = {.lex_state = 764, .external_lex_state = 22},
  [1052] = {.lex_state = 69, .external_lex_state = 2},
  [1053] = {.lex_state = 69, .external_lex_state = 2},
  [1054] = {.lex_state = 107, .external_lex_state = 29},
  [1055] = {.lex_state = 764, .external_lex_state = 22},
  [1056] = {.lex_state = 764, .external_lex_state = 22},
  [1057] = {.lex_state = 762, .external_lex_state = 23},
  [1058] = {.lex_state = 107, .external_lex_state = 29},
  [1059] = {.lex_state = 764, .external_lex_state = 21},
  [1060] = {.lex_state = 764, .external_lex_state = 34},
  [1061] = {.lex_state = 764, .external_lex_state = 21},
  [1062] = {.lex_state = 764, .external_lex_state = 21},
  [1063] = {.lex_state = 764, .external_lex_state = 21},
  [1064] = {.lex_state = 764, .external_lex_state = 21},
  [1065] = {.lex_state = 764, .external_lex_state = 21},
  [1066] = {.lex_state = 764, .external_lex_state = 21},
  [1067] = {.lex_state = 764, .external_lex_state = 21},
  [1068] = {.lex_state = 764, .external_lex_state = 21},
  [1069] = {.lex_state = 764, .external_lex_state = 21},
  [1070] = {.lex_state = 764, .external_lex_state = 21},
  [1071] = {.lex_state = 762, .external_lex_state = 35},
  [1072] = {.lex_state = 762, .external_lex_state = 35},
  [1073] = {.lex_state = 764, .external_lex_state = 21},
  [1074] = {.lex_state = 764, .external_lex_state = 21},
  [1075] = {.lex_state = 764, .external_lex_state = 22},
  [1076] = {.lex_state = 764, .external_lex_state = 21},
  [1077] = {.lex_state = 764, .external_lex_state = 21},
  [1078] = {.lex_state = 764, .external_lex_state = 21},
  [1079] = {.lex_state = 764, .external_lex_state = 21},
  [1080] = {.lex_state = 764, .external_lex_state = 21},
  [1081] = {.lex_state = 764, .external_lex_state = 34},
  [1082] = {.lex_state = 764, .external_lex_state = 21},
  [1083] = {.lex_state = 764, .external_lex_state = 21},
  [1084] = {.lex_state = 764, .external_lex_state = 21},
  [1085] = {.lex_state = 764, .external_lex_state = 21},
  [1086] = {.lex_state = 764, .external_lex_state = 22},
  [1087] = {.lex_state = 764, .external_lex_state = 21},
  [1088] = {.lex_state = 764, .external_lex_state = 21},
  [1089] = {.lex_state = 764, .external_lex_state = 22},
  [1090] = {.lex_state = 764, .external_lex_state = 21},
  [1091] = {.lex_state = 764, .external_lex_state = 21},
  [1092] = {.lex_state = 764, .external_lex_state = 21},
  [1093] = {.lex_state = 764, .external_lex_state = 21},
  [1094] = {.lex_state = 764, .external_lex_state = 21},
  [1095] = {.lex_state = 764, .external_lex_state = 21},
  [1096] = {.lex_state = 764, .external_lex_state = 21},
  [1097] = {.lex_state = 764, .external_lex_state = 21},
  [1098] = {.lex_state = 764, .external_lex_state = 21},
  [1099] = {.lex_state = 764, .external_lex_state = 21},
  [1100] = {.lex_state = 764, .external_lex_state = 34},
  [1101] = {.lex_state = 764, .external_lex_state = 21},
  [1102] = {.lex_state = 764, .external_lex_state = 21},
  [1103] = {.lex_state = 764, .external_lex_state = 21},
  [1104] = {.lex_state = 69, .external_lex_state = 2},
  [1105] = {.lex_state = 764, .external_lex_state = 21},
  [1106] = {.lex_state = 764, .external_lex_state = 21},
  [1107] = {.lex_state = 764, .external_lex_state = 21},
  [1108] = {.lex_state = 764, .external_lex_state = 21},
  [1109] = {.lex_state = 764, .external_lex_state = 34},
  [1110] = {.lex_state = 764, .external_lex_state = 21},
  [1111] = {.lex_state = 764, .external_lex_state = 21},
  [1112] = {.lex_state = 764, .external_lex_state = 22},
  [1113] = {.lex_state = 764, .external_lex_state = 21},
  [1114] = {.lex_state = 764, .external_lex_state = 21},
  [1115] = {.lex_state = 764, .external_lex_state = 21},
  [1116] = {.lex_state = 764, .external_lex_state = 22},
  [1117] = {.lex_state = 764, .external_lex_state = 21},
  [1118] = {.lex_state = 764, .external_lex_state = 21},
  [1119] = {.lex_state = 764, .external_lex_state = 21},
  [1120] = {.lex_state = 764, .external_lex_state = 21},
  [1121] = {.lex_state = 764, .external_lex_state = 22},
  [1122] = {.lex_state = 764, .external_lex_state = 21},
  [1123] = {.lex_state = 764, .external_lex_state = 21},
  [1124] = {.lex_state = 107, .external_lex_state = 29},
  [1125] = {.lex_state = 764, .external_lex_state = 21},
  [1126] = {.lex_state = 764, .external_lex_state = 21},
  [1127] = {.lex_state = 764, .external_lex_state = 21},
  [1128] = {.lex_state = 764, .external_lex_state = 21},
  [1129] = {.lex_state = 764, .external_lex_state = 21},
  [1130] = {.lex_state = 764, .external_lex_state = 21},
  [1131] = {.lex_state = 764, .external_lex_state = 21},
  [1132] = {.lex_state = 764, .external_lex_state = 22},
  [1133] = {.lex_state = 764, .external_lex_state = 21},
  [1134] = {.lex_state = 764, .external_lex_state = 21},
  [1135] = {.lex_state = 764, .external_lex_state = 21},
  [1136] = {.lex_state = 764, .external_lex_state = 21},
  [1137] = {.lex_state = 764, .external_lex_state = 21},
  [1138] = {.lex_state = 764, .external_lex_state = 22},
  [1139] = {.lex_state = 107, .external_lex_state = 29},
  [1140] = {.lex_state = 764, .external_lex_state = 21},
  [1141] = {.lex_state = 764, .external_lex_state = 22},
  [1142] = {.lex_state = 764, .external_lex_state = 21},
  [1143] = {.lex_state = 764, .external_lex_state = 21},
  [1144] = {.lex_state = 764, .external_lex_state = 21},
  [1145] = {.lex_state = 764, .external_lex_state = 21},
  [1146] = {.lex_state = 762, .external_lex_state = 36},
  [1147] = {.lex_state = 764, .external_lex_state = 21},
  [1148] = {.lex_state = 764, .external_lex_state = 21},
  [1149] = {.lex_state = 764, .external_lex_state = 21},
  [1150] = {.lex_state = 764, .external_lex_state = 21},
  [1151] = {.lex_state = 764, .external_lex_state = 21},
  [1152] = {.lex_state = 764, .external_lex_state = 21},
  [1153] = {.lex_state = 762, .external_lex_state = 36},
  [1154] = {.lex_state = 764, .external_lex_state = 21},
  [1155] = {.lex_state = 764, .external_lex_state = 21},
  [1156] = {.lex_state = 764, .external_lex_state = 22},
  [1157] = {.lex_state = 764, .external_lex_state = 22},
  [1158] = {.lex_state = 764, .external_lex_state = 22},
  [1159] = {.lex_state = 764, .external_lex_state = 22},
  [1160] = {.lex_state = 764, .external_lex_state = 22},
  [1161] = {.lex_state = 764, .external_lex_state = 22},
  [1162] = {.lex_state = 764, .external_lex_state = 22},
  [1163] = {.lex_state = 764, .external_lex_state = 22},
  [1164] = {.lex_state = 764, .external_lex_state = 22},
  [1165] = {.lex_state = 764, .external_lex_state = 22},
  [1166] = {.lex_state = 764, .external_lex_state = 22},
  [1167] = {.lex_state = 764, .external_lex_state = 22},
  [1168] = {.lex_state = 764, .external_lex_state = 22},
  [1169] = {.lex_state = 764, .external_lex_state = 22},
  [1170] = {.lex_state = 764, .external_lex_state = 22},
  [1171] = {.lex_state = 764, .external_lex_state = 22},
  [1172] = {.lex_state = 764, .external_lex_state = 22},
  [1173] = {.lex_state = 764, .external_lex_state = 22},
  [1174] = {.lex_state = 764, .external_lex_state = 22},
  [1175] = {.lex_state = 764, .external_lex_state = 22},
  [1176] = {.lex_state = 764, .external_lex_state = 22},
  [1177] = {.lex_state = 764, .external_lex_state = 22},
  [1178] = {.lex_state = 764, .external_lex_state = 22},
  [1179] = {.lex_state = 764, .external_lex_state = 22},
  [1180] = {.lex_state = 764, .external_lex_state = 22},
  [1181] = {.lex_state = 764, .external_lex_state = 22},
  [1182] = {.lex_state = 764, .external_lex_state = 22},
  [1183] = {.lex_state = 764, .external_lex_state = 22},
  [1184] = {.lex_state = 764, .external_lex_state = 22},
  [1185] = {.lex_state = 764, .external_lex_state = 22},
  [1186] = {.lex_state = 764, .external_lex_state = 22},
  [1187] = {.lex_state = 764, .external_lex_state = 22},
  [1188] = {.lex_state = 764, .external_lex_state = 22},
  [1189] = {.lex_state = 764, .external_lex_state = 22},
  [1190] = {.lex_state = 764, .external_lex_state = 22},
  [1191] = {.lex_state = 69, .external_lex_state = 2},
  [1192] = {.lex_state = 69, .external_lex_state = 2},
  [1193] = {.lex_state = 764, .external_lex_state = 22},
  [1194] = {.lex_state = 764, .external_lex_state = 22},
  [1195] = {.lex_state = 764, .external_lex_state = 22},
  [1196] = {.lex_state = 764, .external_lex_state = 22},
  [1197] = {.lex_state = 69, .external_lex_state = 2},
  [1198] = {.lex_state = 764, .external_lex_state = 22},
  [1199] = {.lex_state = 764, .external_lex_state = 22},
  [1200] = {.lex_state = 764, .external_lex_state = 22},
  [1201] = {.lex_state = 107, .external_lex_state = 29},
  [1202] = {.lex_state = 762, .external_lex_state = 37},
  [1203] = {.lex_state = 764, .external_lex_state = 22},
  [1204] = {.lex_state = 764, .external_lex_state = 22},
  [1205] = {.lex_state = 764, .external_lex_state = 22},
  [1206] = {.lex_state = 69, .external_lex_state = 2},
  [1207] = {.lex_state = 764, .external_lex_state = 22},
  [1208] = {.lex_state = 764, .external_lex_state = 22},
  [1209] = {.lex_state = 764, .external_lex_state = 22},
  [1210] = {.lex_state = 764, .external_lex_state = 22},
  [1211] = {.lex_state = 764, .external_lex_state = 22},
  [1212] = {.lex_state = 764, .external_lex_state = 22},
  [1213] = {.lex_state = 764, .external_lex_state = 22},
  [1214] = {.lex_state = 764, .external_lex_state = 22},
  [1215] = {.lex_state = 764, .external_lex_state = 22},
  [1216] = {.lex_state = 764, .external_lex_state = 22},
  [1217] = {.lex_state = 764, .external_lex_state = 22},
  [1218] = {.lex_state = 764, .external_lex_state = 22},
  [1219] = {.lex_state = 764, .external_lex_state = 22},
  [1220] = {.lex_state = 762, .external_lex_state = 37},
  [1221] = {.lex_state = 69, .external_lex_state = 2},
  [1222] = {.lex_state = 69, .external_lex_state = 2},
  [1223] = {.lex_state = 764, .external_lex_state = 22},
  [1224] = {.lex_state = 764, .external_lex_state = 22},
  [1225] = {.lex_state = 764, .external_lex_state = 22},
  [1226] = {.lex_state = 764, .external_lex_state = 22},
  [1227] = {.lex_state = 764, .external_lex_state = 22},
  [1228] = {.lex_state = 764, .external_lex_state = 22},
  [1229] = {.lex_state = 69, .external_lex_state = 2},
  [1230] = {.lex_state = 764, .external_lex_state = 22},
  [1231] = {.lex_state = 764, .external_lex_state = 22},
  [1232] = {.lex_state = 764, .external_lex_state = 22},
  [1233] = {.lex_state = 764, .external_lex_state = 22},
  [1234] = {.lex_state = 764, .external_lex_state = 22},
  [1235] = {.lex_state = 764, .external_lex_state = 22},
  [1236] = {.lex_state = 69, .external_lex_state = 2},
  [1237] = {.lex_state = 764, .external_lex_state = 22},
  [1238] = {.lex_state = 764, .external_lex_state = 22},
  [1239] = {.lex_state = 764, .external_lex_state = 22},
  [1240] = {.lex_state = 764, .external_lex_state = 22},
  [1241] = {.lex_state = 764, .external_lex_state = 22},
  [1242] = {.lex_state = 764, .external_lex_state = 22},
  [1243] = {.lex_state = 764, .external_lex_state = 22},
  [1244] = {.lex_state = 764, .external_lex_state = 22},
  [1245] = {.lex_state = 69, .external_lex_state = 2},
  [1246] = {.lex_state = 69, .external_lex_state = 2},
  [1247] = {.lex_state = 85, .external_lex_state = 23},
  [1248] = {.lex_state = 102, .external_lex_state = 38},
  [1249] = {.lex_state = 102, .external_lex_state = 38},
  [1250] = {.lex_state = 764, .external_lex_state = 39},
  [1251] = {.lex_state = 764, .external_lex_state = 39},
  [1252] = {.lex_state = 102, .external_lex_state = 40},
  [1253] = {.lex_state = 764, .external_lex_state = 39},
  [1254] = {.lex_state = 102, .external_lex_state = 40},
  [1255] = {.lex_state = 764, .external_lex_state = 39},
  [1256] = {.lex_state = 764, .external_lex_state = 25},
  [1257] = {.lex_state = 764, .external_lex_state = 39},
  [1258] = {.lex_state = 764, .external_lex_state = 39},
  [1259] = {.lex_state = 764, .external_lex_state = 39},
  [1260] = {.lex_state = 764, .external_lex_state = 39},
  [1261] = {.lex_state = 764, .external_lex_state = 39},
  [1262] = {.lex_state = 764, .external_lex_state = 25},
  [1263] = {.lex_state = 764, .external_lex_state = 39},
  [1264] = {.lex_state = 764, .external_lex_state = 39},
  [1265] = {.lex_state = 764, .external_lex_state = 25},
  [1266] = {.lex_state = 764, .external_lex_state = 25},
  [1267] = {.lex_state = 102, .external_lex_state = 41},
  [1268] = {.lex_state = 764, .external_lex_state = 25},
  [1269] = {.lex_state = 764, .external_lex_state = 25},
  [1270] = {.lex_state = 764, .external_lex_state = 25},
  [1271] = {.lex_state = 764, .external_lex_state = 25},
  [1272] = {.lex_state = 764, .external_lex_state = 25},
  [1273] = {.lex_state = 764, .external_lex_state = 25},
  [1274] = {.lex_state = 764, .external_lex_state = 25},
  [1275] = {.lex_state = 764, .external_lex_state = 25},
  [1276] = {.lex_state = 764, .external_lex_state = 18},
  [1277] = {.lex_state = 764, .external_lex_state = 25},
  [1278] = {.lex_state = 764, .external_lex_state = 25},
  [1279] = {.lex_state = 764, .external_lex_state = 25},
  [1280] = {.lex_state = 102, .external_lex_state = 41},
  [1281] = {.lex_state = 764, .external_lex_state = 18},
  [1282] = {.lex_state = 764, .external_lex_state = 18},
  [1283] = {.lex_state = 764, .external_lex_state = 18},
  [1284] = {.lex_state = 764, .external_lex_state = 18},
  [1285] = {.lex_state = 764, .external_lex_state = 18},
  [1286] = {.lex_state = 764, .external_lex_state = 18},
  [1287] = {.lex_state = 764, .external_lex_state = 18},
  [1288] = {.lex_state = 764, .external_lex_state = 25},
  [1289] = {.lex_state = 764, .external_lex_state = 42},
  [1290] = {.lex_state = 764, .external_lex_state = 18},
  [1291] = {.lex_state = 764, .external_lex_state = 25},
  [1292] = {.lex_state = 764, .external_lex_state = 18},
  [1293] = {.lex_state = 764, .external_lex_state = 18},
  [1294] = {.lex_state = 764, .external_lex_state = 18},
  [1295] = {.lex_state = 764, .external_lex_state = 18},
  [1296] = {.lex_state = 764, .external_lex_state = 25},
  [1297] = {.lex_state = 764, .external_lex_state = 43},
  [1298] = {.lex_state = 764, .external_lex_state = 25},
  [1299] = {.lex_state = 764, .external_lex_state = 25},
  [1300] = {.lex_state = 764, .external_lex_state = 25},
  [1301] = {.lex_state = 764, .external_lex_state = 18},
  [1302] = {.lex_state = 764, .external_lex_state = 18},
  [1303] = {.lex_state = 764, .external_lex_state = 18},
  [1304] = {.lex_state = 764, .external_lex_state = 25},
  [1305] = {.lex_state = 764, .external_lex_state = 42},
  [1306] = {.lex_state = 764, .external_lex_state = 18},
  [1307] = {.lex_state = 764, .external_lex_state = 39},
  [1308] = {.lex_state = 764, .external_lex_state = 25},
  [1309] = {.lex_state = 764, .external_lex_state = 25},
  [1310] = {.lex_state = 764, .external_lex_state = 25},
  [1311] = {.lex_state = 764, .external_lex_state = 18},
  [1312] = {.lex_state = 764, .external_lex_state = 18},
  [1313] = {.lex_state = 764, .external_lex_state = 18},
  [1314] = {.lex_state = 764, .external_lex_state = 18},
  [1315] = {.lex_state = 764, .external_lex_state = 18},
  [1316] = {.lex_state = 764, .external_lex_state = 18},
  [1317] = {.lex_state = 764, .external_lex_state = 18},
  [1318] = {.lex_state = 764, .external_lex_state = 18},
  [1319] = {.lex_state = 764, .external_lex_state = 18},
  [1320] = {.lex_state = 764, .external_lex_state = 18},
  [1321] = {.lex_state = 764, .external_lex_state = 42},
  [1322] = {.lex_state = 764, .external_lex_state = 42},
  [1323] = {.lex_state = 764, .external_lex_state = 42},
  [1324] = {.lex_state = 764, .external_lex_state = 42},
  [1325] = {.lex_state = 764, .external_lex_state = 42},
  [1326] = {.lex_state = 764, .external_lex_state = 43},
  [1327] = {.lex_state = 764, .external_lex_state = 18},
  [1328] = {.lex_state = 764, .external_lex_state = 18},
  [1329] = {.lex_state = 764, .external_lex_state = 43},
  [1330] = {.lex_state = 764, .external_lex_state = 18},
  [1331] = {.lex_state = 764, .external_lex_state = 18},
  [1332] = {.lex_state = 764, .external_lex_state = 43},
  [1333] = {.lex_state = 764, .external_lex_state = 18},
  [1334] = {.lex_state = 764, .external_lex_state = 18},
  [1335] = {.lex_state = 764, .external_lex_state = 43},
  [1336] = {.lex_state = 764, .external_lex_state = 18},
  [1337] = {.lex_state = 764, .external_lex_state = 43},
  [1338] = {.lex_state = 764, .external_lex_state = 42},
  [1339] = {.lex_state = 764, .external_lex_state = 18},
  [1340] = {.lex_state = 764, .external_lex_state = 18},
  [1341] = {.lex_state = 764, .external_lex_state = 18},
  [1342] = {.lex_state = 764, .external_lex_state = 25},
  [1343] = {.lex_state = 764, .external_lex_state = 18},
  [1344] = {.lex_state = 764, .external_lex_state = 43},
  [1345] = {.lex_state = 764, .external_lex_state = 18},
  [1346] = {.lex_state = 764, .external_lex_state = 24},
  [1347] = {.lex_state = 764, .external_lex_state = 18},
  [1348] = {.lex_state = 764, .external_lex_state = 18},
  [1349] = {.lex_state = 764, .external_lex_state = 25},
  [1350] = {.lex_state = 764, .external_lex_state = 43},
  [1351] = {.lex_state = 764, .external_lex_state = 43},
  [1352] = {.lex_state = 764, .external_lex_state = 18},
  [1353] = {.lex_state = 764, .external_lex_state = 18},
  [1354] = {.lex_state = 764, .external_lex_state = 18},
  [1355] = {.lex_state = 764, .external_lex_state = 18},
  [1356] = {.lex_state = 764, .external_lex_state = 18},
  [1357] = {.lex_state = 764, .external_lex_state = 18},
  [1358] = {.lex_state = 764, .external_lex_state = 18},
  [1359] = {.lex_state = 764, .external_lex_state = 42},
  [1360] = {.lex_state = 764, .external_lex_state = 18},
  [1361] = {.lex_state = 764, .external_lex_state = 18},
  [1362] = {.lex_state = 764, .external_lex_state = 18},
  [1363] = {.lex_state = 764, .external_lex_state = 18},
  [1364] = {.lex_state = 764, .external_lex_state = 18},
  [1365] = {.lex_state = 764, .external_lex_state = 42},
  [1366] = {.lex_state = 764, .external_lex_state = 18},
  [1367] = {.lex_state = 764, .external_lex_state = 43},
  [1368] = {.lex_state = 764, .external_lex_state = 18},
  [1369] = {.lex_state = 764, .external_lex_state = 25},
  [1370] = {.lex_state = 764, .external_lex_state = 18},
  [1371] = {.lex_state = 764, .external_lex_state = 18},
  [1372] = {.lex_state = 764, .external_lex_state = 42},
  [1373] = {.lex_state = 764, .external_lex_state = 18},
  [1374] = {.lex_state = 764, .external_lex_state = 18},
  [1375] = {.lex_state = 764, .external_lex_state = 43},
  [1376] = {.lex_state = 764, .external_lex_state = 43},
  [1377] = {.lex_state = 764, .external_lex_state = 18},
  [1378] = {.lex_state = 764, .external_lex_state = 18},
  [1379] = {.lex_state = 764, .external_lex_state = 18},
  [1380] = {.lex_state = 764, .external_lex_state = 18},
  [1381] = {.lex_state = 764, .external_lex_state = 24},
  [1382] = {.lex_state = 764, .external_lex_state = 24},
  [1383] = {.lex_state = 764, .external_lex_state = 18},
  [1384] = {.lex_state = 764, .external_lex_state = 18},
  [1385] = {.lex_state = 764, .external_lex_state = 24},
  [1386] = {.lex_state = 764, .external_lex_state = 18},
  [1387] = {.lex_state = 764, .external_lex_state = 18},
  [1388] = {.lex_state = 764, .external_lex_state = 24},
  [1389] = {.lex_state = 764, .external_lex_state = 24},
  [1390] = {.lex_state = 764, .external_lex_state = 24},
  [1391] = {.lex_state = 764, .external_lex_state = 24},
  [1392] = {.lex_state = 764, .external_lex_state = 18},
  [1393] = {.lex_state = 764, .external_lex_state = 24},
  [1394] = {.lex_state = 764, .external_lex_state = 24},
  [1395] = {.lex_state = 764, .external_lex_state = 18},
  [1396] = {.lex_state = 764, .external_lex_state = 18},
  [1397] = {.lex_state = 764, .external_lex_state = 24},
  [1398] = {.lex_state = 764, .external_lex_state = 18},
  [1399] = {.lex_state = 764, .external_lex_state = 18},
  [1400] = {.lex_state = 764, .external_lex_state = 24},
  [1401] = {.lex_state = 764, .external_lex_state = 18},
  [1402] = {.lex_state = 764, .external_lex_state = 18},
  [1403] = {.lex_state = 764, .external_lex_state = 18},
  [1404] = {.lex_state = 764, .external_lex_state = 18},
  [1405] = {.lex_state = 764, .external_lex_state = 18},
  [1406] = {.lex_state = 764, .external_lex_state = 18},
  [1407] = {.lex_state = 764, .external_lex_state = 18},
  [1408] = {.lex_state = 764, .external_lex_state = 18},
  [1409] = {.lex_state = 764, .external_lex_state = 18},
  [1410] = {.lex_state = 102, .external_lex_state = 44},
  [1411] = {.lex_state = 764, .external_lex_state = 18},
  [1412] = {.lex_state = 764, .external_lex_state = 18},
  [1413] = {.lex_state = 764, .external_lex_state = 18},
  [1414] = {.lex_state = 102, .external_lex_state = 44},
  [1415] = {.lex_state = 764, .external_lex_state = 18},
  [1416] = {.lex_state = 764, .external_lex_state = 18},
  [1417] = {.lex_state = 764, .external_lex_state = 18},
  [1418] = {.lex_state = 764, .external_lex_state = 43},
  [1419] = {.lex_state = 764, .external_lex_state = 18},
  [1420] = {.lex_state = 764, .external_lex_state = 43},
  [1421] = {.lex_state = 764, .external_lex_state = 18},
  [1422] = {.lex_state = 764, .external_lex_state = 18},
  [1423] = {.lex_state = 764, .external_lex_state = 18},
  [1424] = {.lex_state = 764, .external_lex_state = 18},
  [1425] = {.lex_state = 764, .external_lex_state = 18},
  [1426] = {.lex_state = 764, .external_lex_state = 18},
  [1427] = {.lex_state = 764, .external_lex_state = 18},
  [1428] = {.lex_state = 764, .external_lex_state = 18},
  [1429] = {.lex_state = 764, .external_lex_state = 18},
  [1430] = {.lex_state = 764, .external_lex_state = 18},
  [1431] = {.lex_state = 764, .external_lex_state = 18},
  [1432] = {.lex_state = 764, .external_lex_state = 18},
  [1433] = {.lex_state = 764, .external_lex_state = 18},
  [1434] = {.lex_state = 764, .external_lex_state = 18},
  [1435] = {.lex_state = 764, .external_lex_state = 18},
  [1436] = {.lex_state = 764, .external_lex_state = 18},
  [1437] = {.lex_state = 764, .external_lex_state = 18},
  [1438] = {.lex_state = 764, .external_lex_state = 18},
  [1439] = {.lex_state = 764, .external_lex_state = 18},
  [1440] = {.lex_state = 764, .external_lex_state = 18},
  [1441] = {.lex_state = 764, .external_lex_state = 18},
  [1442] = {.lex_state = 764, .external_lex_state = 18},
  [1443] = {.lex_state = 764, .external_lex_state = 18},
  [1444] = {.lex_state = 764, .external_lex_state = 18},
  [1445] = {.lex_state = 764, .external_lex_state = 18},
  [1446] = {.lex_state = 764, .external_lex_state = 18},
  [1447] = {.lex_state = 764, .external_lex_state = 18},
  [1448] = {.lex_state = 764, .external_lex_state = 18},
  [1449] = {.lex_state = 764, .external_lex_state = 18},
  [1450] = {.lex_state = 764, .external_lex_state = 18},
  [1451] = {.lex_state = 764, .external_lex_state = 18},
  [1452] = {.lex_state = 764, .external_lex_state = 18},
  [1453] = {.lex_state = 764, .external_lex_state = 18},
  [1454] = {.lex_state = 764, .external_lex_state = 18},
  [1455] = {.lex_state = 764, .external_lex_state = 18},
  [1456] = {.lex_state = 764, .external_lex_state = 18},
  [1457] = {.lex_state = 764, .external_lex_state = 18},
  [1458] = {.lex_state = 764, .external_lex_state = 18},
  [1459] = {.lex_state = 760, .external_lex_state = 39},
  [1460] = {.lex_state = 107, .external_lex_state = 29},
  [1461] = {.lex_state = 107, .external_lex_state = 29},
  [1462] = {.lex_state = 70, .external_lex_state = 17},
  [1463] = {.lex_state = 37, .external_lex_state = 17},
  [1464] = {.lex_state = 107, .external_lex_state = 29},
  [1465] = {.lex_state = 87, .external_lex_state = 23},
  [1466] = {.lex_state = 107, .external_lex_state = 29},
  [1467] = {.lex_state = 107, .external_lex_state = 29},
  [1468] = {.lex_state = 87, .external_lex_state = 23},
  [1469] = {.lex_state = 760, .external_lex_state = 25},
  [1470] = {.lex_state = 86, .external_lex_state = 23},
  [1471] = {.lex_state = 760, .external_lex_state = 18},
  [1472] = {.lex_state = 760, .external_lex_state = 25},
  [1473] = {.lex_state = 107, .external_lex_state = 29},
  [1474] = {.lex_state = 760, .external_lex_state = 42},
  [1475] = {.lex_state = 760, .external_lex_state = 43},
  [1476] = {.lex_state = 760, .external_lex_state = 39},
  [1477] = {.lex_state = 87, .external_lex_state = 23},
  [1478] = {.lex_state = 107, .external_lex_state = 45},
  [1479] = {.lex_state = 760, .external_lex_state = 24},
  [1480] = {.lex_state = 760, .external_lex_state = 39},
  [1481] = {.lex_state = 760, .external_lex_state = 39},
  [1482] = {.lex_state = 760, .external_lex_state = 25},
  [1483] = {.lex_state = 760, .external_lex_state = 25},
  [1484] = {.lex_state = 760, .external_lex_state = 25},
  [1485] = {.lex_state = 99, .external_lex_state = 25},
  [1486] = {.lex_state = 760, .external_lex_state = 25},
  [1487] = {.lex_state = 760, .external_lex_state = 18},
  [1488] = {.lex_state = 768, .external_lex_state = 45},
  [1489] = {.lex_state = 107, .external_lex_state = 26},
  [1490] = {.lex_state = 107, .external_lex_state = 26},
  [1491] = {.lex_state = 760, .external_lex_state = 25},
  [1492] = {.lex_state = 768, .external_lex_state = 45},
  [1493] = {.lex_state = 760, .external_lex_state = 18},
  [1494] = {.lex_state = 107, .external_lex_state = 26},
  [1495] = {.lex_state = 768, .external_lex_state = 45},
  [1496] = {.lex_state = 107, .external_lex_state = 46},
  [1497] = {.lex_state = 107, .external_lex_state = 26},
  [1498] = {.lex_state = 768, .external_lex_state = 45},
  [1499] = {.lex_state = 768, .external_lex_state = 45},
  [1500] = {.lex_state = 760, .external_lex_state = 18},
  [1501] = {.lex_state = 768, .external_lex_state = 45},
  [1502] = {.lex_state = 768, .external_lex_state = 45},
  [1503] = {.lex_state = 760, .external_lex_state = 25},
  [1504] = {.lex_state = 107, .external_lex_state = 45},
  [1505] = {.lex_state = 760, .external_lex_state = 18},
  [1506] = {.lex_state = 760, .external_lex_state = 25},
  [1507] = {.lex_state = 107, .external_lex_state = 29},
  [1508] = {.lex_state = 107, .external_lex_state = 28},
  [1509] = {.lex_state = 760, .external_lex_state = 42},
  [1510] = {.lex_state = 760, .external_lex_state = 43},
  [1511] = {.lex_state = 760, .external_lex_state = 42},
  [1512] = {.lex_state = 107, .external_lex_state = 45},
  [1513] = {.lex_state = 760, .external_lex_state = 43},
  [1514] = {.lex_state = 107, .external_lex_state = 26},
  [1515] = {.lex_state = 107, .external_lex_state = 28},
  [1516] = {.lex_state = 760, .external_lex_state = 42},
  [1517] = {.lex_state = 107, .external_lex_state = 47},
  [1518] = {.lex_state = 760, .external_lex_state = 43},
  [1519] = {.lex_state = 107, .external_lex_state = 45},
  [1520] = {.lex_state = 107, .external_lex_state = 47},
  [1521] = {.lex_state = 107, .external_lex_state = 47},
  [1522] = {.lex_state = 107, .external_lex_state = 47},
  [1523] = {.lex_state = 107, .external_lex_state = 27},
  [1524] = {.lex_state = 107, .external_lex_state = 27},
  [1525] = {.lex_state = 107, .external_lex_state = 46},
  [1526] = {.lex_state = 107, .external_lex_state = 46},
  [1527] = {.lex_state = 107, .external_lex_state = 27},
  [1528] = {.lex_state = 760, .external_lex_state = 24},
  [1529] = {.lex_state = 107, .external_lex_state = 46},
  [1530] = {.lex_state = 107, .external_lex_state = 46},
  [1531] = {.lex_state = 760, .external_lex_state = 39},
  [1532] = {.lex_state = 760, .external_lex_state = 39},
  [1533] = {.lex_state = 107, .external_lex_state = 26},
  [1534] = {.lex_state = 760, .external_lex_state = 39},
  [1535] = {.lex_state = 107, .external_lex_state = 46},
  [1536] = {.lex_state = 760, .external_lex_state = 39},
  [1537] = {.lex_state = 760, .external_lex_state = 39},
  [1538] = {.lex_state = 760, .external_lex_state = 39},
  [1539] = {.lex_state = 107, .external_lex_state = 48},
  [1540] = {.lex_state = 107, .external_lex_state = 26},
  [1541] = {.lex_state = 107, .external_lex_state = 46},
  [1542] = {.lex_state = 760, .external_lex_state = 24},
  [1543] = {.lex_state = 760, .external_lex_state = 24},
  [1544] = {.lex_state = 107, .external_lex_state = 26},
  [1545] = {.lex_state = 107, .external_lex_state = 27},
  [1546] = {.lex_state = 107, .external_lex_state = 26},
  [1547] = {.lex_state = 107, .external_lex_state = 46},
  [1548] = {.lex_state = 107, .external_lex_state = 28},
  [1549] = {.lex_state = 107, .external_lex_state = 28},
  [1550] = {.lex_state = 107, .external_lex_state = 47},
  [1551] = {.lex_state = 107, .external_lex_state = 47},
  [1552] = {.lex_state = 760, .external_lex_state = 25},
  [1553] = {.lex_state = 107, .external_lex_state = 29},
  [1554] = {.lex_state = 107, .external_lex_state = 47},
  [1555] = {.lex_state = 107, .external_lex_state = 47},
  [1556] = {.lex_state = 760, .external_lex_state = 25},
  [1557] = {.lex_state = 107, .external_lex_state = 47},
  [1558] = {.lex_state = 107, .external_lex_state = 45},
  [1559] = {.lex_state = 107, .external_lex_state = 46},
  [1560] = {.lex_state = 107, .external_lex_state = 45},
  [1561] = {.lex_state = 107, .external_lex_state = 45},
  [1562] = {.lex_state = 107, .external_lex_state = 46},
  [1563] = {.lex_state = 107, .external_lex_state = 47},
  [1564] = {.lex_state = 107, .external_lex_state = 47},
  [1565] = {.lex_state = 107, .external_lex_state = 45},
  [1566] = {.lex_state = 107, .external_lex_state = 28},
  [1567] = {.lex_state = 107, .external_lex_state = 46},
  [1568] = {.lex_state = 760, .external_lex_state = 25},
  [1569] = {.lex_state = 107, .external_lex_state = 45},
  [1570] = {.lex_state = 107, .external_lex_state = 45},
  [1571] = {.lex_state = 107, .external_lex_state = 28},
  [1572] = {.lex_state = 760, .external_lex_state = 25},
  [1573] = {.lex_state = 768, .external_lex_state = 45},
  [1574] = {.lex_state = 107, .external_lex_state = 45},
  [1575] = {.lex_state = 760, .external_lex_state = 25},
  [1576] = {.lex_state = 107, .external_lex_state = 28},
  [1577] = {.lex_state = 760, .external_lex_state = 25},
  [1578] = {.lex_state = 107, .external_lex_state = 45},
  [1579] = {.lex_state = 107, .external_lex_state = 28},
  [1580] = {.lex_state = 107, .external_lex_state = 28},
  [1581] = {.lex_state = 760, .external_lex_state = 18},
  [1582] = {.lex_state = 107, .external_lex_state = 27},
  [1583] = {.lex_state = 768, .external_lex_state = 45},
  [1584] = {.lex_state = 107, .external_lex_state = 48},
  [1585] = {.lex_state = 760, .external_lex_state = 25},
  [1586] = {.lex_state = 760, .external_lex_state = 25},
  [1587] = {.lex_state = 107, .external_lex_state = 27},
  [1588] = {.lex_state = 107, .external_lex_state = 47},
  [1589] = {.lex_state = 760, .external_lex_state = 25},
  [1590] = {.lex_state = 760, .external_lex_state = 25},
  [1591] = {.lex_state = 768, .external_lex_state = 45},
  [1592] = {.lex_state = 768, .external_lex_state = 45},
  [1593] = {.lex_state = 760, .external_lex_state = 25},
  [1594] = {.lex_state = 107, .external_lex_state = 47},
  [1595] = {.lex_state = 760, .external_lex_state = 18},
  [1596] = {.lex_state = 760, .external_lex_state = 18},
  [1597] = {.lex_state = 760, .external_lex_state = 18},
  [1598] = {.lex_state = 107, .external_lex_state = 47},
  [1599] = {.lex_state = 107, .external_lex_state = 47},
  [1600] = {.lex_state = 107, .external_lex_state = 47},
  [1601] = {.lex_state = 768, .external_lex_state = 45},
  [1602] = {.lex_state = 760, .external_lex_state = 25},
  [1603] = {.lex_state = 760, .external_lex_state = 18},
  [1604] = {.lex_state = 764, .external_lex_state = 31},
  [1605] = {.lex_state = 768, .external_lex_state = 45},
  [1606] = {.lex_state = 107, .external_lex_state = 47},
  [1607] = {.lex_state = 107, .external_lex_state = 27},
  [1608] = {.lex_state = 107, .external_lex_state = 47},
  [1609] = {.lex_state = 107, .external_lex_state = 48},
  [1610] = {.lex_state = 107, .external_lex_state = 30},
  [1611] = {.lex_state = 760, .external_lex_state = 18},
  [1612] = {.lex_state = 107, .external_lex_state = 30},
  [1613] = {.lex_state = 107, .external_lex_state = 30},
  [1614] = {.lex_state = 107, .external_lex_state = 27},
  [1615] = {.lex_state = 760, .external_lex_state = 18},
  [1616] = {.lex_state = 107, .external_lex_state = 48},
  [1617] = {.lex_state = 107, .external_lex_state = 48},
  [1618] = {.lex_state = 107, .external_lex_state = 48},
  [1619] = {.lex_state = 760, .external_lex_state = 18},
  [1620] = {.lex_state = 107, .external_lex_state = 30},
  [1621] = {.lex_state = 107, .external_lex_state = 27},
  [1622] = {.lex_state = 107, .external_lex_state = 47},
  [1623] = {.lex_state = 760, .external_lex_state = 25},
  [1624] = {.lex_state = 107, .external_lex_state = 48},
  [1625] = {.lex_state = 107, .external_lex_state = 48},
  [1626] = {.lex_state = 107, .external_lex_state = 49},
  [1627] = {.lex_state = 760, .external_lex_state = 42},
  [1628] = {.lex_state = 107, .external_lex_state = 48},
  [1629] = {.lex_state = 107, .external_lex_state = 49},
  [1630] = {.lex_state = 107, .external_lex_state = 50},
  [1631] = {.lex_state = 107, .external_lex_state = 46},
  [1632] = {.lex_state = 760, .external_lex_state = 42},
  [1633] = {.lex_state = 107, .external_lex_state = 46},
  [1634] = {.lex_state = 764, .external_lex_state = 31},
  [1635] = {.lex_state = 760, .external_lex_state = 42},
  [1636] = {.lex_state = 107, .external_lex_state = 49},
  [1637] = {.lex_state = 107, .external_lex_state = 49},
  [1638] = {.lex_state = 760, .external_lex_state = 43},
  [1639] = {.lex_state = 107, .external_lex_state = 46},
  [1640] = {.lex_state = 760, .external_lex_state = 42},
  [1641] = {.lex_state = 107, .external_lex_state = 51},
  [1642] = {.lex_state = 764, .external_lex_state = 31},
  [1643] = {.lex_state = 764, .external_lex_state = 31},
  [1644] = {.lex_state = 107, .external_lex_state = 49},
  [1645] = {.lex_state = 760, .external_lex_state = 43},
  [1646] = {.lex_state = 760, .external_lex_state = 43},
  [1647] = {.lex_state = 107, .external_lex_state = 46},
  [1648] = {.lex_state = 107, .external_lex_state = 46},
  [1649] = {.lex_state = 107, .external_lex_state = 48},
  [1650] = {.lex_state = 107, .external_lex_state = 46},
  [1651] = {.lex_state = 107, .external_lex_state = 49},
  [1652] = {.lex_state = 107, .external_lex_state = 48},
  [1653] = {.lex_state = 107, .external_lex_state = 49},
  [1654] = {.lex_state = 760, .external_lex_state = 42},
  [1655] = {.lex_state = 760, .external_lex_state = 42},
  [1656] = {.lex_state = 107, .external_lex_state = 46},
  [1657] = {.lex_state = 107, .external_lex_state = 49},
  [1658] = {.lex_state = 107, .external_lex_state = 49},
  [1659] = {.lex_state = 107, .external_lex_state = 30},
  [1660] = {.lex_state = 107, .external_lex_state = 47},
  [1661] = {.lex_state = 107, .external_lex_state = 49},
  [1662] = {.lex_state = 107, .external_lex_state = 47},
  [1663] = {.lex_state = 764, .external_lex_state = 31},
  [1664] = {.lex_state = 764, .external_lex_state = 31},
  [1665] = {.lex_state = 764, .external_lex_state = 31},
  [1666] = {.lex_state = 760, .external_lex_state = 43},
  [1667] = {.lex_state = 107, .external_lex_state = 46},
  [1668] = {.lex_state = 107, .external_lex_state = 46},
  [1669] = {.lex_state = 107, .external_lex_state = 49},
  [1670] = {.lex_state = 764, .external_lex_state = 31},
  [1671] = {.lex_state = 764, .external_lex_state = 23},
  [1672] = {.lex_state = 107, .external_lex_state = 49},
  [1673] = {.lex_state = 107, .external_lex_state = 47},
  [1674] = {.lex_state = 760, .external_lex_state = 43},
  [1675] = {.lex_state = 107, .external_lex_state = 47},
  [1676] = {.lex_state = 760, .external_lex_state = 43},
  [1677] = {.lex_state = 107, .external_lex_state = 46},
  [1678] = {.lex_state = 764, .external_lex_state = 23},
  [1679] = {.lex_state = 107, .external_lex_state = 30},
  [1680] = {.lex_state = 760, .external_lex_state = 24},
  [1681] = {.lex_state = 760, .external_lex_state = 24},
  [1682] = {.lex_state = 764, .external_lex_state = 23},
  [1683] = {.lex_state = 760, .external_lex_state = 24},
  [1684] = {.lex_state = 107, .external_lex_state = 47},
  [1685] = {.lex_state = 760, .external_lex_state = 24},
  [1686] = {.lex_state = 764, .external_lex_state = 23},
  [1687] = {.lex_state = 760, .external_lex_state = 24},
  [1688] = {.lex_state = 764, .external_lex_state = 23},
  [1689] = {.lex_state = 107, .external_lex_state = 47},
  [1690] = {.lex_state = 764, .external_lex_state = 23},
  [1691] = {.lex_state = 107, .external_lex_state = 46},
  [1692] = {.lex_state = 764, .external_lex_state = 23},
  [1693] = {.lex_state = 764, .external_lex_state = 17},
  [1694] = {.lex_state = 107, .external_lex_state = 46},
  [1695] = {.lex_state = 760, .external_lex_state = 24},
  [1696] = {.lex_state = 107, .external_lex_state = 46},
  [1697] = {.lex_state = 107, .external_lex_state = 30},
  [1698] = {.lex_state = 764, .external_lex_state = 23},
  [1699] = {.lex_state = 107, .external_lex_state = 46},
  [1700] = {.lex_state = 107, .external_lex_state = 30},
  [1701] = {.lex_state = 764, .external_lex_state = 23},
  [1702] = {.lex_state = 107, .external_lex_state = 30},
  [1703] = {.lex_state = 764, .external_lex_state = 23},
  [1704] = {.lex_state = 764, .external_lex_state = 23},
  [1705] = {.lex_state = 764, .external_lex_state = 17},
  [1706] = {.lex_state = 764, .external_lex_state = 23},
  [1707] = {.lex_state = 764, .external_lex_state = 17},
  [1708] = {.lex_state = 764, .external_lex_state = 23},
  [1709] = {.lex_state = 764, .external_lex_state = 23},
  [1710] = {.lex_state = 764, .external_lex_state = 23},
  [1711] = {.lex_state = 107, .external_lex_state = 48},
  [1712] = {.lex_state = 764, .external_lex_state = 31},
  [1713] = {.lex_state = 107, .external_lex_state = 48},
  [1714] = {.lex_state = 107, .external_lex_state = 48},
  [1715] = {.lex_state = 107, .external_lex_state = 48},
  [1716] = {.lex_state = 107, .external_lex_state = 48},
  [1717] = {.lex_state = 764, .external_lex_state = 31},
  [1718] = {.lex_state = 107, .external_lex_state = 48},
  [1719] = {.lex_state = 764, .external_lex_state = 17},
  [1720] = {.lex_state = 764, .external_lex_state = 31},
  [1721] = {.lex_state = 764, .external_lex_state = 31},
  [1722] = {.lex_state = 764, .external_lex_state = 17},
  [1723] = {.lex_state = 764, .external_lex_state = 31},
  [1724] = {.lex_state = 764, .external_lex_state = 23},
  [1725] = {.lex_state = 764, .external_lex_state = 36},
  [1726] = {.lex_state = 107, .external_lex_state = 48},
  [1727] = {.lex_state = 764, .external_lex_state = 17},
  [1728] = {.lex_state = 764, .external_lex_state = 31},
  [1729] = {.lex_state = 768, .external_lex_state = 52},
  [1730] = {.lex_state = 764, .external_lex_state = 17},
  [1731] = {.lex_state = 107, .external_lex_state = 51},
  [1732] = {.lex_state = 107, .external_lex_state = 51},
  [1733] = {.lex_state = 107, .external_lex_state = 48},
  [1734] = {.lex_state = 107, .external_lex_state = 48},
  [1735] = {.lex_state = 107, .external_lex_state = 48},
  [1736] = {.lex_state = 764, .external_lex_state = 35},
  [1737] = {.lex_state = 764, .external_lex_state = 17},
  [1738] = {.lex_state = 107, .external_lex_state = 50},
  [1739] = {.lex_state = 764, .external_lex_state = 35},
  [1740] = {.lex_state = 764, .external_lex_state = 23},
  [1741] = {.lex_state = 768, .external_lex_state = 53},
  [1742] = {.lex_state = 107, .external_lex_state = 48},
  [1743] = {.lex_state = 764, .external_lex_state = 31},
  [1744] = {.lex_state = 764, .external_lex_state = 23},
  [1745] = {.lex_state = 130, .external_lex_state = 29},
  [1746] = {.lex_state = 764, .external_lex_state = 31},
  [1747] = {.lex_state = 768, .external_lex_state = 53},
  [1748] = {.lex_state = 107, .external_lex_state = 48},
  [1749] = {.lex_state = 107, .external_lex_state = 48},
  [1750] = {.lex_state = 764, .external_lex_state = 37},
  [1751] = {.lex_state = 768, .external_lex_state = 52},
  [1752] = {.lex_state = 764, .external_lex_state = 35},
  [1753] = {.lex_state = 764, .external_lex_state = 31},
  [1754] = {.lex_state = 764, .external_lex_state = 23},
  [1755] = {.lex_state = 764, .external_lex_state = 23},
  [1756] = {.lex_state = 764, .external_lex_state = 36},
  [1757] = {.lex_state = 764, .external_lex_state = 35},
  [1758] = {.lex_state = 764, .external_lex_state = 36},
  [1759] = {.lex_state = 764, .external_lex_state = 36},
  [1760] = {.lex_state = 764, .external_lex_state = 35},
  [1761] = {.lex_state = 768, .external_lex_state = 53},
  [1762] = {.lex_state = 764, .external_lex_state = 36},
  [1763] = {.lex_state = 764, .external_lex_state = 35},
  [1764] = {.lex_state = 764, .external_lex_state = 36},
  [1765] = {.lex_state = 764, .external_lex_state = 35},
  [1766] = {.lex_state = 764, .external_lex_state = 35},
  [1767] = {.lex_state = 107, .external_lex_state = 48},
  [1768] = {.lex_state = 764, .external_lex_state = 23},
  [1769] = {.lex_state = 764, .external_lex_state = 36},
  [1770] = {.lex_state = 764, .external_lex_state = 36},
  [1771] = {.lex_state = 764, .external_lex_state = 23},
  [1772] = {.lex_state = 764, .external_lex_state = 37},
  [1773] = {.lex_state = 107, .external_lex_state = 54},
  [1774] = {.lex_state = 768, .external_lex_state = 53},
  [1775] = {.lex_state = 107, .external_lex_state = 51},
  [1776] = {.lex_state = 107, .external_lex_state = 51},
  [1777] = {.lex_state = 107, .external_lex_state = 54},
  [1778] = {.lex_state = 131, .external_lex_state = 29},
  [1779] = {.lex_state = 107, .external_lex_state = 55},
  [1780] = {.lex_state = 764, .external_lex_state = 31},
  [1781] = {.lex_state = 107, .external_lex_state = 56},
  [1782] = {.lex_state = 764, .external_lex_state = 31},
  [1783] = {.lex_state = 764, .external_lex_state = 31},
  [1784] = {.lex_state = 764, .external_lex_state = 23},
  [1785] = {.lex_state = 107, .external_lex_state = 56},
  [1786] = {.lex_state = 764, .external_lex_state = 31},
  [1787] = {.lex_state = 764, .external_lex_state = 31},
  [1788] = {.lex_state = 764, .external_lex_state = 31},
  [1789] = {.lex_state = 107, .external_lex_state = 29},
  [1790] = {.lex_state = 764, .external_lex_state = 31},
  [1791] = {.lex_state = 764, .external_lex_state = 31},
  [1792] = {.lex_state = 764, .external_lex_state = 23},
  [1793] = {.lex_state = 764, .external_lex_state = 31},
  [1794] = {.lex_state = 107, .external_lex_state = 56},
  [1795] = {.lex_state = 764, .external_lex_state = 31},
  [1796] = {.lex_state = 764, .external_lex_state = 37},
  [1797] = {.lex_state = 764, .external_lex_state = 31},
  [1798] = {.lex_state = 764, .external_lex_state = 37},
  [1799] = {.lex_state = 764, .external_lex_state = 31},
  [1800] = {.lex_state = 107, .external_lex_state = 56},
  [1801] = {.lex_state = 107, .external_lex_state = 51},
  [1802] = {.lex_state = 107, .external_lex_state = 54},
  [1803] = {.lex_state = 107, .external_lex_state = 51},
  [1804] = {.lex_state = 107, .external_lex_state = 56},
  [1805] = {.lex_state = 107, .external_lex_state = 56},
  [1806] = {.lex_state = 107, .external_lex_state = 56},
  [1807] = {.lex_state = 764, .external_lex_state = 31},
  [1808] = {.lex_state = 768, .external_lex_state = 53},
  [1809] = {.lex_state = 764, .external_lex_state = 31},
  [1810] = {.lex_state = 107, .external_lex_state = 56},
  [1811] = {.lex_state = 764, .external_lex_state = 31},
  [1812] = {.lex_state = 764, .external_lex_state = 23},
  [1813] = {.lex_state = 764, .external_lex_state = 39},
  [1814] = {.lex_state = 107, .external_lex_state = 56},
  [1815] = {.lex_state = 764, .external_lex_state = 39},
  [1816] = {.lex_state = 764, .external_lex_state = 39},
  [1817] = {.lex_state = 764, .external_lex_state = 39},
  [1818] = {.lex_state = 107, .external_lex_state = 56},
  [1819] = {.lex_state = 107, .external_lex_state = 56},
  [1820] = {.lex_state = 764, .external_lex_state = 31},
  [1821] = {.lex_state = 764, .external_lex_state = 23},
  [1822] = {.lex_state = 107, .external_lex_state = 56},
  [1823] = {.lex_state = 764, .external_lex_state = 37},
  [1824] = {.lex_state = 764, .external_lex_state = 23},
  [1825] = {.lex_state = 107, .external_lex_state = 54},
  [1826] = {.lex_state = 107, .external_lex_state = 54},
  [1827] = {.lex_state = 768, .external_lex_state = 53},
  [1828] = {.lex_state = 764, .external_lex_state = 37},
  [1829] = {.lex_state = 107, .external_lex_state = 51},
  [1830] = {.lex_state = 764, .external_lex_state = 23},
  [1831] = {.lex_state = 764, .external_lex_state = 23},
  [1832] = {.lex_state = 764, .external_lex_state = 31},
  [1833] = {.lex_state = 764, .external_lex_state = 37},
  [1834] = {.lex_state = 764, .external_lex_state = 23},
  [1835] = {.lex_state = 764, .external_lex_state = 37},
  [1836] = {.lex_state = 764, .external_lex_state = 23},
  [1837] = {.lex_state = 107, .external_lex_state = 51},
  [1838] = {.lex_state = 764, .external_lex_state = 23},
  [1839] = {.lex_state = 768, .external_lex_state = 53},
  [1840] = {.lex_state = 764, .external_lex_state = 36},
  [1841] = {.lex_state = 764, .external_lex_state = 23},
  [1842] = {.lex_state = 764, .external_lex_state = 23},
  [1843] = {.lex_state = 764, .external_lex_state = 23},
  [1844] = {.lex_state = 764, .external_lex_state = 25},
  [1845] = {.lex_state = 768, .external_lex_state = 53},
  [1846] = {.lex_state = 764, .external_lex_state = 23},
  [1847] = {.lex_state = 764, .external_lex_state = 17},
  [1848] = {.lex_state = 764, .external_lex_state = 23},
  [1849] = {.lex_state = 132, .external_lex_state = 29},
  [1850] = {.lex_state = 95, .external_lex_state = 57},
  [1851] = {.lex_state = 764, .external_lex_state = 23},
  [1852] = {.lex_state = 764, .external_lex_state = 17},
  [1853] = {.lex_state = 764, .external_lex_state = 23},
  [1854] = {.lex_state = 764, .external_lex_state = 35},
  [1855] = {.lex_state = 764, .external_lex_state = 23},
  [1856] = {.lex_state = 107, .external_lex_state = 29},
  [1857] = {.lex_state = 764, .external_lex_state = 23},
  [1858] = {.lex_state = 764, .external_lex_state = 36},
  [1859] = {.lex_state = 764, .external_lex_state = 23},
  [1860] = {.lex_state = 768, .external_lex_state = 53},
  [1861] = {.lex_state = 764, .external_lex_state = 35},
  [1862] = {.lex_state = 107, .external_lex_state = 49},
  [1863] = {.lex_state = 764, .external_lex_state = 23},
  [1864] = {.lex_state = 764, .external_lex_state = 23},
  [1865] = {.lex_state = 764, .external_lex_state = 25},
  [1866] = {.lex_state = 764, .external_lex_state = 23},
  [1867] = {.lex_state = 764, .external_lex_state = 35},
  [1868] = {.lex_state = 107, .external_lex_state = 54},
  [1869] = {.lex_state = 764, .external_lex_state = 17},
  [1870] = {.lex_state = 764, .external_lex_state = 23},
  [1871] = {.lex_state = 764, .external_lex_state = 35},
  [1872] = {.lex_state = 764, .external_lex_state = 23},
  [1873] = {.lex_state = 764, .external_lex_state = 23},
  [1874] = {.lex_state = 768, .external_lex_state = 53},
  [1875] = {.lex_state = 764, .external_lex_state = 36},
  [1876] = {.lex_state = 764, .external_lex_state = 36},
  [1877] = {.lex_state = 768, .external_lex_state = 53},
  [1878] = {.lex_state = 768, .external_lex_state = 53},
  [1879] = {.lex_state = 764, .external_lex_state = 23},
  [1880] = {.lex_state = 764, .external_lex_state = 35},
  [1881] = {.lex_state = 764, .external_lex_state = 35},
  [1882] = {.lex_state = 764, .external_lex_state = 36},
  [1883] = {.lex_state = 764, .external_lex_state = 25},
  [1884] = {.lex_state = 764, .external_lex_state = 25},
  [1885] = {.lex_state = 764, .external_lex_state = 23},
  [1886] = {.lex_state = 764, .external_lex_state = 36},
  [1887] = {.lex_state = 768, .external_lex_state = 53},
  [1888] = {.lex_state = 764, .external_lex_state = 23},
  [1889] = {.lex_state = 768, .external_lex_state = 53},
  [1890] = {.lex_state = 122, .external_lex_state = 51},
  [1891] = {.lex_state = 764, .external_lex_state = 23},
  [1892] = {.lex_state = 97, .external_lex_state = 23},
  [1893] = {.lex_state = 121, .external_lex_state = 58},
  [1894] = {.lex_state = 764, .external_lex_state = 23},
  [1895] = {.lex_state = 38, .external_lex_state = 17},
  [1896] = {.lex_state = 122, .external_lex_state = 51},
  [1897] = {.lex_state = 764, .external_lex_state = 23},
  [1898] = {.lex_state = 764, .external_lex_state = 35},
  [1899] = {.lex_state = 764, .external_lex_state = 23},
  [1900] = {.lex_state = 107, .external_lex_state = 49},
  [1901] = {.lex_state = 764, .external_lex_state = 36},
  [1902] = {.lex_state = 121, .external_lex_state = 58},
  [1903] = {.lex_state = 764, .external_lex_state = 35},
  [1904] = {.lex_state = 764, .external_lex_state = 23},
  [1905] = {.lex_state = 764, .external_lex_state = 23},
  [1906] = {.lex_state = 764, .external_lex_state = 23},
  [1907] = {.lex_state = 122, .external_lex_state = 51},
  [1908] = {.lex_state = 97, .external_lex_state = 23},
  [1909] = {.lex_state = 764, .external_lex_state = 37},
  [1910] = {.lex_state = 764, .external_lex_state = 36},
  [1911] = {.lex_state = 764, .external_lex_state = 37},
  [1912] = {.lex_state = 122, .external_lex_state = 51},
  [1913] = {.lex_state = 107, .external_lex_state = 53},
  [1914] = {.lex_state = 107, .external_lex_state = 53},
  [1915] = {.lex_state = 764, .external_lex_state = 37},
  [1916] = {.lex_state = 764, .external_lex_state = 25},
  [1917] = {.lex_state = 764, .external_lex_state = 23},
  [1918] = {.lex_state = 764, .external_lex_state = 37},
  [1919] = {.lex_state = 764, .external_lex_state = 35},
  [1920] = {.lex_state = 764, .external_lex_state = 25},
  [1921] = {.lex_state = 764, .external_lex_state = 17},
  [1922] = {.lex_state = 107, .external_lex_state = 49},
  [1923] = {.lex_state = 107, .external_lex_state = 49},
  [1924] = {.lex_state = 107, .external_lex_state = 54},
  [1925] = {.lex_state = 764, .external_lex_state = 23},
  [1926] = {.lex_state = 764, .external_lex_state = 23},
  [1927] = {.lex_state = 764, .external_lex_state = 23},
  [1928] = {.lex_state = 107, .external_lex_state = 54},
  [1929] = {.lex_state = 764, .external_lex_state = 23},
  [1930] = {.lex_state = 764, .external_lex_state = 23},
  [1931] = {.lex_state = 764, .external_lex_state = 23},
  [1932] = {.lex_state = 764, .external_lex_state = 25},
  [1933] = {.lex_state = 121, .external_lex_state = 58},
  [1934] = {.lex_state = 764, .external_lex_state = 17},
  [1935] = {.lex_state = 764, .external_lex_state = 25},
  [1936] = {.lex_state = 764, .external_lex_state = 23},
  [1937] = {.lex_state = 764, .external_lex_state = 23},
  [1938] = {.lex_state = 764, .external_lex_state = 36},
  [1939] = {.lex_state = 764, .external_lex_state = 23},
  [1940] = {.lex_state = 764, .external_lex_state = 37},
  [1941] = {.lex_state = 764, .external_lex_state = 37},
  [1942] = {.lex_state = 121, .external_lex_state = 58},
  [1943] = {.lex_state = 107, .external_lex_state = 59},
  [1944] = {.lex_state = 107, .external_lex_state = 60},
  [1945] = {.lex_state = 764, .external_lex_state = 36},
  [1946] = {.lex_state = 764, .external_lex_state = 36},
  [1947] = {.lex_state = 107, .external_lex_state = 60},
  [1948] = {.lex_state = 107, .external_lex_state = 60},
  [1949] = {.lex_state = 107, .external_lex_state = 60},
  [1950] = {.lex_state = 107, .external_lex_state = 60},
  [1951] = {.lex_state = 764, .external_lex_state = 39},
  [1952] = {.lex_state = 764, .external_lex_state = 35},
  [1953] = {.lex_state = 107, .external_lex_state = 50},
  [1954] = {.lex_state = 764, .external_lex_state = 43},
  [1955] = {.lex_state = 107, .external_lex_state = 50},
  [1956] = {.lex_state = 764, .external_lex_state = 43},
  [1957] = {.lex_state = 764, .external_lex_state = 36},
  [1958] = {.lex_state = 764, .external_lex_state = 35},
  [1959] = {.lex_state = 764, .external_lex_state = 39},
  [1960] = {.lex_state = 764, .external_lex_state = 43},
  [1961] = {.lex_state = 107, .external_lex_state = 54},
  [1962] = {.lex_state = 764, .external_lex_state = 43},
  [1963] = {.lex_state = 764, .external_lex_state = 39},
  [1964] = {.lex_state = 764, .external_lex_state = 36},
  [1965] = {.lex_state = 764, .external_lex_state = 37},
  [1966] = {.lex_state = 764, .external_lex_state = 35},
  [1967] = {.lex_state = 764, .external_lex_state = 35},
  [1968] = {.lex_state = 764, .external_lex_state = 39},
  [1969] = {.lex_state = 764, .external_lex_state = 39},
  [1970] = {.lex_state = 764, .external_lex_state = 35},
  [1971] = {.lex_state = 764, .external_lex_state = 35},
  [1972] = {.lex_state = 764, .external_lex_state = 35},
  [1973] = {.lex_state = 764, .external_lex_state = 35},
  [1974] = {.lex_state = 764, .external_lex_state = 37},
  [1975] = {.lex_state = 764, .external_lex_state = 35},
  [1976] = {.lex_state = 107, .external_lex_state = 60},
  [1977] = {.lex_state = 764, .external_lex_state = 39},
  [1978] = {.lex_state = 107, .external_lex_state = 50},
  [1979] = {.lex_state = 764, .external_lex_state = 35},
  [1980] = {.lex_state = 764, .external_lex_state = 37},
  [1981] = {.lex_state = 764, .external_lex_state = 36},
  [1982] = {.lex_state = 764, .external_lex_state = 35},
  [1983] = {.lex_state = 764, .external_lex_state = 36},
  [1984] = {.lex_state = 764, .external_lex_state = 36},
  [1985] = {.lex_state = 764, .external_lex_state = 36},
  [1986] = {.lex_state = 764, .external_lex_state = 36},
  [1987] = {.lex_state = 764, .external_lex_state = 36},
  [1988] = {.lex_state = 764, .external_lex_state = 35},
  [1989] = {.lex_state = 107, .external_lex_state = 60},
  [1990] = {.lex_state = 764, .external_lex_state = 36},
  [1991] = {.lex_state = 764, .external_lex_state = 35},
  [1992] = {.lex_state = 764, .external_lex_state = 36},
  [1993] = {.lex_state = 764, .external_lex_state = 39},
  [1994] = {.lex_state = 107, .external_lex_state = 60},
  [1995] = {.lex_state = 764, .external_lex_state = 39},
  [1996] = {.lex_state = 764, .external_lex_state = 39},
  [1997] = {.lex_state = 107, .external_lex_state = 60},
  [1998] = {.lex_state = 764, .external_lex_state = 36},
  [1999] = {.lex_state = 107, .external_lex_state = 60},
  [2000] = {.lex_state = 107, .external_lex_state = 60},
  [2001] = {.lex_state = 764, .external_lex_state = 35},
  [2002] = {.lex_state = 764, .external_lex_state = 39},
  [2003] = {.lex_state = 764, .external_lex_state = 17},
  [2004] = {.lex_state = 121, .external_lex_state = 58},
  [2005] = {.lex_state = 764, .external_lex_state = 35},
  [2006] = {.lex_state = 38, .external_lex_state = 17},
  [2007] = {.lex_state = 107, .external_lex_state = 60},
  [2008] = {.lex_state = 107, .external_lex_state = 60},
  [2009] = {.lex_state = 107, .external_lex_state = 60},
  [2010] = {.lex_state = 764, .external_lex_state = 42},
  [2011] = {.lex_state = 764, .external_lex_state = 42},
  [2012] = {.lex_state = 764, .external_lex_state = 35},
  [2013] = {.lex_state = 107, .external_lex_state = 60},
  [2014] = {.lex_state = 107, .external_lex_state = 60},
  [2015] = {.lex_state = 107, .external_lex_state = 60},
  [2016] = {.lex_state = 764, .external_lex_state = 39},
  [2017] = {.lex_state = 107, .external_lex_state = 60},
  [2018] = {.lex_state = 764, .external_lex_state = 36},
  [2019] = {.lex_state = 107, .external_lex_state = 60},
  [2020] = {.lex_state = 107, .external_lex_state = 60},
  [2021] = {.lex_state = 107, .external_lex_state = 60},
  [2022] = {.lex_state = 107, .external_lex_state = 29},
  [2023] = {.lex_state = 107, .external_lex_state = 60},
  [2024] = {.lex_state = 764, .external_lex_state = 42},
  [2025] = {.lex_state = 764, .external_lex_state = 36},
  [2026] = {.lex_state = 764, .external_lex_state = 39},
  [2027] = {.lex_state = 764, .external_lex_state = 42},
  [2028] = {.lex_state = 764, .external_lex_state = 39},
  [2029] = {.lex_state = 107, .external_lex_state = 60},
  [2030] = {.lex_state = 107, .external_lex_state = 60},
  [2031] = {.lex_state = 764, .external_lex_state = 36},
  [2032] = {.lex_state = 764, .external_lex_state = 35},
  [2033] = {.lex_state = 764, .external_lex_state = 36},
  [2034] = {.lex_state = 122, .external_lex_state = 51},
  [2035] = {.lex_state = 764, .external_lex_state = 25},
  [2036] = {.lex_state = 107, .external_lex_state = 54},
  [2037] = {.lex_state = 764, .external_lex_state = 37},
  [2038] = {.lex_state = 107, .external_lex_state = 61},
  [2039] = {.lex_state = 764, .external_lex_state = 62},
  [2040] = {.lex_state = 764, .external_lex_state = 62},
  [2041] = {.lex_state = 764, .external_lex_state = 25},
  [2042] = {.lex_state = 107, .external_lex_state = 50},
  [2043] = {.lex_state = 764, .external_lex_state = 62},
  [2044] = {.lex_state = 764, .external_lex_state = 25},
  [2045] = {.lex_state = 764, .external_lex_state = 25},
  [2046] = {.lex_state = 768, .external_lex_state = 59},
  [2047] = {.lex_state = 764, .external_lex_state = 37},
  [2048] = {.lex_state = 768, .external_lex_state = 59},
  [2049] = {.lex_state = 122, .external_lex_state = 51},
  [2050] = {.lex_state = 122, .external_lex_state = 51},
  [2051] = {.lex_state = 107, .external_lex_state = 51},
  [2052] = {.lex_state = 764, .external_lex_state = 37},
  [2053] = {.lex_state = 768, .external_lex_state = 59},
  [2054] = {.lex_state = 768, .external_lex_state = 59},
  [2055] = {.lex_state = 764, .external_lex_state = 37},
  [2056] = {.lex_state = 764, .external_lex_state = 25},
  [2057] = {.lex_state = 764, .external_lex_state = 25},
  [2058] = {.lex_state = 768, .external_lex_state = 59},
  [2059] = {.lex_state = 764, .external_lex_state = 37},
  [2060] = {.lex_state = 764, .external_lex_state = 37},
  [2061] = {.lex_state = 122, .external_lex_state = 51},
  [2062] = {.lex_state = 764, .external_lex_state = 37},
  [2063] = {.lex_state = 107, .external_lex_state = 50},
  [2064] = {.lex_state = 764, .external_lex_state = 37},
  [2065] = {.lex_state = 764, .external_lex_state = 25},
  [2066] = {.lex_state = 764, .external_lex_state = 62},
  [2067] = {.lex_state = 107, .external_lex_state = 50},
  [2068] = {.lex_state = 107, .external_lex_state = 38},
  [2069] = {.lex_state = 107, .external_lex_state = 54},
  [2070] = {.lex_state = 764, .external_lex_state = 39},
  [2071] = {.lex_state = 121, .external_lex_state = 58},
  [2072] = {.lex_state = 764, .external_lex_state = 39},
  [2073] = {.lex_state = 768, .external_lex_state = 59},
  [2074] = {.lex_state = 764, .external_lex_state = 39},
  [2075] = {.lex_state = 107, .external_lex_state = 51},
  [2076] = {.lex_state = 107, .external_lex_state = 29},
  [2077] = {.lex_state = 764, .external_lex_state = 25},
  [2078] = {.lex_state = 764, .external_lex_state = 24},
  [2079] = {.lex_state = 764, .external_lex_state = 25},
  [2080] = {.lex_state = 764, .external_lex_state = 39},
  [2081] = {.lex_state = 764, .external_lex_state = 37},
  [2082] = {.lex_state = 764, .external_lex_state = 37},
  [2083] = {.lex_state = 764, .external_lex_state = 24},
  [2084] = {.lex_state = 107, .external_lex_state = 54},
  [2085] = {.lex_state = 764, .external_lex_state = 37},
  [2086] = {.lex_state = 107, .external_lex_state = 38},
  [2087] = {.lex_state = 122, .external_lex_state = 51},
  [2088] = {.lex_state = 764, .external_lex_state = 37},
  [2089] = {.lex_state = 764, .external_lex_state = 37},
  [2090] = {.lex_state = 764, .external_lex_state = 37},
  [2091] = {.lex_state = 107, .external_lex_state = 29},
  [2092] = {.lex_state = 764, .external_lex_state = 37},
  [2093] = {.lex_state = 107, .external_lex_state = 51},
  [2094] = {.lex_state = 764, .external_lex_state = 37},
  [2095] = {.lex_state = 107, .external_lex_state = 29},
  [2096] = {.lex_state = 121, .external_lex_state = 58},
  [2097] = {.lex_state = 764, .external_lex_state = 37},
  [2098] = {.lex_state = 764, .external_lex_state = 25},
  [2099] = {.lex_state = 107, .external_lex_state = 38},
  [2100] = {.lex_state = 121, .external_lex_state = 58},
  [2101] = {.lex_state = 764, .external_lex_state = 24},
  [2102] = {.lex_state = 121, .external_lex_state = 58},
  [2103] = {.lex_state = 764, .external_lex_state = 24},
  [2104] = {.lex_state = 107, .external_lex_state = 50},
  [2105] = {.lex_state = 764, .external_lex_state = 25},
  [2106] = {.lex_state = 764, .external_lex_state = 25},
  [2107] = {.lex_state = 107, .external_lex_state = 29},
  [2108] = {.lex_state = 107, .external_lex_state = 29},
  [2109] = {.lex_state = 764, .external_lex_state = 39},
  [2110] = {.lex_state = 768, .external_lex_state = 59},
  [2111] = {.lex_state = 764, .external_lex_state = 39},
  [2112] = {.lex_state = 107, .external_lex_state = 38},
  [2113] = {.lex_state = 764, .external_lex_state = 39},
  [2114] = {.lex_state = 764, .external_lex_state = 25},
  [2115] = {.lex_state = 764, .external_lex_state = 25},
  [2116] = {.lex_state = 107, .external_lex_state = 54},
  [2117] = {.lex_state = 764, .external_lex_state = 39},
  [2118] = {.lex_state = 764, .external_lex_state = 39},
  [2119] = {.lex_state = 107, .external_lex_state = 54},
  [2120] = {.lex_state = 107, .external_lex_state = 54},
  [2121] = {.lex_state = 764, .external_lex_state = 25},
  [2122] = {.lex_state = 107, .external_lex_state = 29},
  [2123] = {.lex_state = 764, .external_lex_state = 25},
  [2124] = {.lex_state = 107, .external_lex_state = 29},
  [2125] = {.lex_state = 764, .external_lex_state = 39},
  [2126] = {.lex_state = 764, .external_lex_state = 39},
  [2127] = {.lex_state = 764, .external_lex_state = 39},
  [2128] = {.lex_state = 764, .external_lex_state = 39},
  [2129] = {.lex_state = 764, .external_lex_state = 63},
  [2130] = {.lex_state = 107, .external_lex_state = 54},
  [2131] = {.lex_state = 764, .external_lex_state = 63},
  [2132] = {.lex_state = 107, .external_lex_state = 54},
  [2133] = {.lex_state = 764, .external_lex_state = 39},
  [2134] = {.lex_state = 764, .external_lex_state = 39},
  [2135] = {.lex_state = 764, .external_lex_state = 39},
  [2136] = {.lex_state = 764, .external_lex_state = 39},
  [2137] = {.lex_state = 764, .external_lex_state = 39},
  [2138] = {.lex_state = 764, .external_lex_state = 39},
  [2139] = {.lex_state = 122, .external_lex_state = 29},
  [2140] = {.lex_state = 764, .external_lex_state = 39},
  [2141] = {.lex_state = 764, .external_lex_state = 39},
  [2142] = {.lex_state = 107, .external_lex_state = 29},
  [2143] = {.lex_state = 764, .external_lex_state = 39},
  [2144] = {.lex_state = 107, .external_lex_state = 29},
  [2145] = {.lex_state = 107, .external_lex_state = 29},
  [2146] = {.lex_state = 764, .external_lex_state = 39},
  [2147] = {.lex_state = 107, .external_lex_state = 29},
  [2148] = {.lex_state = 107, .external_lex_state = 29},
  [2149] = {.lex_state = 107, .external_lex_state = 29},
  [2150] = {.lex_state = 107, .external_lex_state = 29},
  [2151] = {.lex_state = 107, .external_lex_state = 29},
  [2152] = {.lex_state = 107, .external_lex_state = 29},
  [2153] = {.lex_state = 107, .external_lex_state = 29},
  [2154] = {.lex_state = 107, .external_lex_state = 29},
  [2155] = {.lex_state = 107, .external_lex_state = 29},
  [2156] = {.lex_state = 107, .external_lex_state = 29},
  [2157] = {.lex_state = 107, .external_lex_state = 29},
  [2158] = {.lex_state = 107, .external_lex_state = 54},
  [2159] = {.lex_state = 107, .external_lex_state = 29},
  [2160] = {.lex_state = 107, .external_lex_state = 29},
  [2161] = {.lex_state = 764, .external_lex_state = 39},
  [2162] = {.lex_state = 107, .external_lex_state = 29},
  [2163] = {.lex_state = 764, .external_lex_state = 25},
  [2164] = {.lex_state = 764, .external_lex_state = 39},
  [2165] = {.lex_state = 107, .external_lex_state = 29},
  [2166] = {.lex_state = 107, .external_lex_state = 29},
  [2167] = {.lex_state = 764, .external_lex_state = 39},
  [2168] = {.lex_state = 107, .external_lex_state = 29},
  [2169] = {.lex_state = 764, .external_lex_state = 39},
  [2170] = {.lex_state = 107, .external_lex_state = 29},
  [2171] = {.lex_state = 107, .external_lex_state = 29},
  [2172] = {.lex_state = 107, .external_lex_state = 29},
  [2173] = {.lex_state = 764, .external_lex_state = 39},
  [2174] = {.lex_state = 107, .external_lex_state = 59},
  [2175] = {.lex_state = 764, .external_lex_state = 39},
  [2176] = {.lex_state = 107, .external_lex_state = 29},
  [2177] = {.lex_state = 107, .external_lex_state = 29},
  [2178] = {.lex_state = 764, .external_lex_state = 39},
  [2179] = {.lex_state = 764, .external_lex_state = 39},
  [2180] = {.lex_state = 107, .external_lex_state = 29},
  [2181] = {.lex_state = 107, .external_lex_state = 29},
  [2182] = {.lex_state = 764, .external_lex_state = 39},
  [2183] = {.lex_state = 121, .external_lex_state = 55},
  [2184] = {.lex_state = 107, .external_lex_state = 29},
  [2185] = {.lex_state = 107, .external_lex_state = 29},
  [2186] = {.lex_state = 764, .external_lex_state = 39},
  [2187] = {.lex_state = 107, .external_lex_state = 29},
  [2188] = {.lex_state = 764, .external_lex_state = 25},
  [2189] = {.lex_state = 107, .external_lex_state = 29},
  [2190] = {.lex_state = 764, .external_lex_state = 25},
  [2191] = {.lex_state = 764, .external_lex_state = 39},
  [2192] = {.lex_state = 764, .external_lex_state = 39},
  [2193] = {.lex_state = 107, .external_lex_state = 29},
  [2194] = {.lex_state = 121, .external_lex_state = 55},
  [2195] = {.lex_state = 107, .external_lex_state = 29},
  [2196] = {.lex_state = 767, .external_lex_state = 64},
  [2197] = {.lex_state = 107, .external_lex_state = 29},
  [2198] = {.lex_state = 107, .external_lex_state = 29},
  [2199] = {.lex_state = 764, .external_lex_state = 39},
  [2200] = {.lex_state = 107, .external_lex_state = 29},
  [2201] = {.lex_state = 107, .external_lex_state = 59},
  [2202] = {.lex_state = 764, .external_lex_state = 39},
  [2203] = {.lex_state = 107, .external_lex_state = 29},
  [2204] = {.lex_state = 764, .external_lex_state = 25},
  [2205] = {.lex_state = 107, .external_lex_state = 29},
  [2206] = {.lex_state = 764, .external_lex_state = 25},
  [2207] = {.lex_state = 764, .external_lex_state = 25},
  [2208] = {.lex_state = 107, .external_lex_state = 29},
  [2209] = {.lex_state = 107, .external_lex_state = 29},
  [2210] = {.lex_state = 764, .external_lex_state = 39},
  [2211] = {.lex_state = 107, .external_lex_state = 29},
  [2212] = {.lex_state = 764, .external_lex_state = 39},
  [2213] = {.lex_state = 107, .external_lex_state = 29},
  [2214] = {.lex_state = 764, .external_lex_state = 39},
  [2215] = {.lex_state = 764, .external_lex_state = 39},
  [2216] = {.lex_state = 107, .external_lex_state = 29},
  [2217] = {.lex_state = 107, .external_lex_state = 38},
  [2218] = {.lex_state = 764, .external_lex_state = 25},
  [2219] = {.lex_state = 107, .external_lex_state = 29},
  [2220] = {.lex_state = 107, .external_lex_state = 29},
  [2221] = {.lex_state = 107, .external_lex_state = 59},
  [2222] = {.lex_state = 764, .external_lex_state = 25},
  [2223] = {.lex_state = 107, .external_lex_state = 29},
  [2224] = {.lex_state = 764, .external_lex_state = 39},
  [2225] = {.lex_state = 764, .external_lex_state = 39},
  [2226] = {.lex_state = 107, .external_lex_state = 29},
  [2227] = {.lex_state = 107, .external_lex_state = 29},
  [2228] = {.lex_state = 764, .external_lex_state = 39},
  [2229] = {.lex_state = 107, .external_lex_state = 29},
  [2230] = {.lex_state = 764, .external_lex_state = 39},
  [2231] = {.lex_state = 764, .external_lex_state = 25},
  [2232] = {.lex_state = 764, .external_lex_state = 39},
  [2233] = {.lex_state = 107, .external_lex_state = 29},
  [2234] = {.lex_state = 764, .external_lex_state = 39},
  [2235] = {.lex_state = 107, .external_lex_state = 29},
  [2236] = {.lex_state = 764, .external_lex_state = 39},
  [2237] = {.lex_state = 107, .external_lex_state = 29},
  [2238] = {.lex_state = 764, .external_lex_state = 25},
  [2239] = {.lex_state = 121, .external_lex_state = 55},
  [2240] = {.lex_state = 107, .external_lex_state = 29},
  [2241] = {.lex_state = 764, .external_lex_state = 39},
  [2242] = {.lex_state = 764, .external_lex_state = 39},
  [2243] = {.lex_state = 107, .external_lex_state = 29},
  [2244] = {.lex_state = 764, .external_lex_state = 39},
  [2245] = {.lex_state = 764, .external_lex_state = 39},
  [2246] = {.lex_state = 764, .external_lex_state = 39},
  [2247] = {.lex_state = 764, .external_lex_state = 39},
  [2248] = {.lex_state = 107, .external_lex_state = 50},
  [2249] = {.lex_state = 764, .external_lex_state = 25},
  [2250] = {.lex_state = 764, .external_lex_state = 18},
  [2251] = {.lex_state = 764, .external_lex_state = 18},
  [2252] = {.lex_state = 764, .external_lex_state = 39},
  [2253] = {.lex_state = 764, .external_lex_state = 39},
  [2254] = {.lex_state = 107, .external_lex_state = 29},
  [2255] = {.lex_state = 764, .external_lex_state = 39},
  [2256] = {.lex_state = 107, .external_lex_state = 29},
  [2257] = {.lex_state = 764, .external_lex_state = 39},
  [2258] = {.lex_state = 107, .external_lex_state = 29},
  [2259] = {.lex_state = 107, .external_lex_state = 29},
  [2260] = {.lex_state = 764, .external_lex_state = 39},
  [2261] = {.lex_state = 764, .external_lex_state = 39},
  [2262] = {.lex_state = 107, .external_lex_state = 29},
  [2263] = {.lex_state = 764, .external_lex_state = 25},
  [2264] = {.lex_state = 764, .external_lex_state = 39},
  [2265] = {.lex_state = 764, .external_lex_state = 39},
  [2266] = {.lex_state = 764, .external_lex_state = 39},
  [2267] = {.lex_state = 764, .external_lex_state = 63},
  [2268] = {.lex_state = 764, .external_lex_state = 25},
  [2269] = {.lex_state = 764, .external_lex_state = 25},
  [2270] = {.lex_state = 764, .external_lex_state = 25},
  [2271] = {.lex_state = 764, .external_lex_state = 39},
  [2272] = {.lex_state = 764, .external_lex_state = 39},
  [2273] = {.lex_state = 764, .external_lex_state = 39},
  [2274] = {.lex_state = 764, .external_lex_state = 39},
  [2275] = {.lex_state = 764, .external_lex_state = 18},
  [2276] = {.lex_state = 764, .external_lex_state = 25},
  [2277] = {.lex_state = 107, .external_lex_state = 29},
  [2278] = {.lex_state = 107, .external_lex_state = 29},
  [2279] = {.lex_state = 764, .external_lex_state = 25},
  [2280] = {.lex_state = 764, .external_lex_state = 39},
  [2281] = {.lex_state = 107, .external_lex_state = 29},
  [2282] = {.lex_state = 764, .external_lex_state = 39},
  [2283] = {.lex_state = 764, .external_lex_state = 39},
  [2284] = {.lex_state = 764, .external_lex_state = 39},
  [2285] = {.lex_state = 764, .external_lex_state = 63},
  [2286] = {.lex_state = 764, .external_lex_state = 39},
  [2287] = {.lex_state = 764, .external_lex_state = 39},
  [2288] = {.lex_state = 764, .external_lex_state = 39},
  [2289] = {.lex_state = 767, .external_lex_state = 64},
  [2290] = {.lex_state = 764, .external_lex_state = 39},
  [2291] = {.lex_state = 764, .external_lex_state = 39},
  [2292] = {.lex_state = 764, .external_lex_state = 39},
  [2293] = {.lex_state = 764, .external_lex_state = 39},
  [2294] = {.lex_state = 107, .external_lex_state = 29},
  [2295] = {.lex_state = 107, .external_lex_state = 29},
  [2296] = {.lex_state = 107, .external_lex_state = 29},
  [2297] = {.lex_state = 764, .external_lex_state = 39},
  [2298] = {.lex_state = 764, .external_lex_state = 39},
  [2299] = {.lex_state = 764, .external_lex_state = 39},
  [2300] = {.lex_state = 122, .external_lex_state = 29},
  [2301] = {.lex_state = 107, .external_lex_state = 65},
  [2302] = {.lex_state = 764, .external_lex_state = 39},
  [2303] = {.lex_state = 764, .external_lex_state = 39},
  [2304] = {.lex_state = 764, .external_lex_state = 39},
  [2305] = {.lex_state = 764, .external_lex_state = 25},
  [2306] = {.lex_state = 122, .external_lex_state = 29},
  [2307] = {.lex_state = 122, .external_lex_state = 29},
  [2308] = {.lex_state = 107, .external_lex_state = 29},
  [2309] = {.lex_state = 764, .external_lex_state = 25},
  [2310] = {.lex_state = 107, .external_lex_state = 29},
  [2311] = {.lex_state = 764, .external_lex_state = 25},
  [2312] = {.lex_state = 121, .external_lex_state = 55},
  [2313] = {.lex_state = 764, .external_lex_state = 25},
  [2314] = {.lex_state = 764, .external_lex_state = 25},
  [2315] = {.lex_state = 764, .external_lex_state = 25},
  [2316] = {.lex_state = 764, .external_lex_state = 25},
  [2317] = {.lex_state = 764, .external_lex_state = 25},
  [2318] = {.lex_state = 764, .external_lex_state = 42},
  [2319] = {.lex_state = 107, .external_lex_state = 40},
  [2320] = {.lex_state = 764, .external_lex_state = 43},
  [2321] = {.lex_state = 764, .external_lex_state = 25},
  [2322] = {.lex_state = 764, .external_lex_state = 25},
  [2323] = {.lex_state = 764, .external_lex_state = 25},
  [2324] = {.lex_state = 107, .external_lex_state = 54},
  [2325] = {.lex_state = 764, .external_lex_state = 25},
  [2326] = {.lex_state = 764, .external_lex_state = 25},
  [2327] = {.lex_state = 107, .external_lex_state = 61},
  [2328] = {.lex_state = 107, .external_lex_state = 29},
  [2329] = {.lex_state = 107, .external_lex_state = 29},
  [2330] = {.lex_state = 764, .external_lex_state = 25},
  [2331] = {.lex_state = 764, .external_lex_state = 25},
  [2332] = {.lex_state = 764, .external_lex_state = 25},
  [2333] = {.lex_state = 107, .external_lex_state = 55},
  [2334] = {.lex_state = 107, .external_lex_state = 29},
  [2335] = {.lex_state = 107, .external_lex_state = 54},
  [2336] = {.lex_state = 107, .external_lex_state = 29},
  [2337] = {.lex_state = 764, .external_lex_state = 25},
  [2338] = {.lex_state = 107, .external_lex_state = 29},
  [2339] = {.lex_state = 107, .external_lex_state = 51},
  [2340] = {.lex_state = 764, .external_lex_state = 25},
  [2341] = {.lex_state = 107, .external_lex_state = 40},
  [2342] = {.lex_state = 107, .external_lex_state = 61},
  [2343] = {.lex_state = 107, .external_lex_state = 61},
  [2344] = {.lex_state = 107, .external_lex_state = 29},
  [2345] = {.lex_state = 764, .external_lex_state = 25},
  [2346] = {.lex_state = 107, .external_lex_state = 40},
  [2347] = {.lex_state = 107, .external_lex_state = 61},
  [2348] = {.lex_state = 107, .external_lex_state = 54},
  [2349] = {.lex_state = 107, .external_lex_state = 55},
  [2350] = {.lex_state = 764, .external_lex_state = 43},
  [2351] = {.lex_state = 764, .external_lex_state = 63},
  [2352] = {.lex_state = 107, .external_lex_state = 29},
  [2353] = {.lex_state = 764, .external_lex_state = 25},
  [2354] = {.lex_state = 764, .external_lex_state = 42},
  [2355] = {.lex_state = 764, .external_lex_state = 63},
  [2356] = {.lex_state = 107, .external_lex_state = 61},
  [2357] = {.lex_state = 107, .external_lex_state = 38},
  [2358] = {.lex_state = 764, .external_lex_state = 25},
  [2359] = {.lex_state = 764, .external_lex_state = 25},
  [2360] = {.lex_state = 764, .external_lex_state = 25},
  [2361] = {.lex_state = 107, .external_lex_state = 61},
  [2362] = {.lex_state = 764, .external_lex_state = 25},
  [2363] = {.lex_state = 764, .external_lex_state = 25},
  [2364] = {.lex_state = 107, .external_lex_state = 55},
  [2365] = {.lex_state = 107, .external_lex_state = 38},
  [2366] = {.lex_state = 764, .external_lex_state = 42},
  [2367] = {.lex_state = 764, .external_lex_state = 25},
  [2368] = {.lex_state = 764, .external_lex_state = 25},
  [2369] = {.lex_state = 107, .external_lex_state = 38},
  [2370] = {.lex_state = 764, .external_lex_state = 43},
  [2371] = {.lex_state = 764, .external_lex_state = 25},
  [2372] = {.lex_state = 764, .external_lex_state = 43},
  [2373] = {.lex_state = 764, .external_lex_state = 42},
  [2374] = {.lex_state = 764, .external_lex_state = 43},
  [2375] = {.lex_state = 107, .external_lex_state = 29},
  [2376] = {.lex_state = 764, .external_lex_state = 42},
  [2377] = {.lex_state = 107, .external_lex_state = 60},
  [2378] = {.lex_state = 107, .external_lex_state = 55},
  [2379] = {.lex_state = 764, .external_lex_state = 43},
  [2380] = {.lex_state = 764, .external_lex_state = 43},
  [2381] = {.lex_state = 764, .external_lex_state = 25},
  [2382] = {.lex_state = 764, .external_lex_state = 25},
  [2383] = {.lex_state = 764, .external_lex_state = 42},
  [2384] = {.lex_state = 764, .external_lex_state = 25},
  [2385] = {.lex_state = 764, .external_lex_state = 25},
  [2386] = {.lex_state = 107, .external_lex_state = 55},
  [2387] = {.lex_state = 764, .external_lex_state = 25},
  [2388] = {.lex_state = 107, .external_lex_state = 61},
  [2389] = {.lex_state = 764, .external_lex_state = 25},
  [2390] = {.lex_state = 107, .external_lex_state = 38},
  [2391] = {.lex_state = 107, .external_lex_state = 55},
  [2392] = {.lex_state = 764, .external_lex_state = 25},
  [2393] = {.lex_state = 764, .external_lex_state = 43},
  [2394] = {.lex_state = 764, .external_lex_state = 43},
  [2395] = {.lex_state = 764, .external_lex_state = 25},
  [2396] = {.lex_state = 764, .external_lex_state = 25},
  [2397] = {.lex_state = 764, .external_lex_state = 25},
  [2398] = {.lex_state = 764, .external_lex_state = 25},
  [2399] = {.lex_state = 107, .external_lex_state = 29},
  [2400] = {.lex_state = 764, .external_lex_state = 25},
  [2401] = {.lex_state = 764, .external_lex_state = 25},
  [2402] = {.lex_state = 764, .external_lex_state = 25},
  [2403] = {.lex_state = 764, .external_lex_state = 42},
  [2404] = {.lex_state = 764, .external_lex_state = 42},
  [2405] = {.lex_state = 764, .external_lex_state = 25},
  [2406] = {.lex_state = 764, .external_lex_state = 25},
  [2407] = {.lex_state = 107, .external_lex_state = 29},
  [2408] = {.lex_state = 764, .external_lex_state = 25},
  [2409] = {.lex_state = 107, .external_lex_state = 29},
  [2410] = {.lex_state = 764, .external_lex_state = 25},
  [2411] = {.lex_state = 764, .external_lex_state = 25},
  [2412] = {.lex_state = 764, .external_lex_state = 25},
  [2413] = {.lex_state = 764, .external_lex_state = 25},
  [2414] = {.lex_state = 764, .external_lex_state = 25},
  [2415] = {.lex_state = 764, .external_lex_state = 25},
  [2416] = {.lex_state = 764, .external_lex_state = 25},
  [2417] = {.lex_state = 764, .external_lex_state = 25},
  [2418] = {.lex_state = 764, .external_lex_state = 25},
  [2419] = {.lex_state = 764, .external_lex_state = 25},
  [2420] = {.lex_state = 107, .external_lex_state = 54},
  [2421] = {.lex_state = 764, .external_lex_state = 18},
  [2422] = {.lex_state = 764, .external_lex_state = 42},
  [2423] = {.lex_state = 764, .external_lex_state = 25},
  [2424] = {.lex_state = 107, .external_lex_state = 29},
  [2425] = {.lex_state = 107, .external_lex_state = 29},
  [2426] = {.lex_state = 764, .external_lex_state = 42},
  [2427] = {.lex_state = 107, .external_lex_state = 29},
  [2428] = {.lex_state = 107, .external_lex_state = 29},
  [2429] = {.lex_state = 107, .external_lex_state = 29},
  [2430] = {.lex_state = 107, .external_lex_state = 29},
  [2431] = {.lex_state = 764, .external_lex_state = 25},
  [2432] = {.lex_state = 107, .external_lex_state = 29},
  [2433] = {.lex_state = 764, .external_lex_state = 42},
  [2434] = {.lex_state = 764, .external_lex_state = 25},
  [2435] = {.lex_state = 764, .external_lex_state = 42},
  [2436] = {.lex_state = 764, .external_lex_state = 25},
  [2437] = {.lex_state = 107, .external_lex_state = 29},
  [2438] = {.lex_state = 764, .external_lex_state = 25},
  [2439] = {.lex_state = 764, .external_lex_state = 42},
  [2440] = {.lex_state = 764, .external_lex_state = 25},
  [2441] = {.lex_state = 764, .external_lex_state = 25},
  [2442] = {.lex_state = 764, .external_lex_state = 25},
  [2443] = {.lex_state = 764, .external_lex_state = 25},
  [2444] = {.lex_state = 107, .external_lex_state = 55},
  [2445] = {.lex_state = 764, .external_lex_state = 25},
  [2446] = {.lex_state = 764, .external_lex_state = 63},
  [2447] = {.lex_state = 764, .external_lex_state = 25},
  [2448] = {.lex_state = 107, .external_lex_state = 29},
  [2449] = {.lex_state = 764, .external_lex_state = 63},
  [2450] = {.lex_state = 764, .external_lex_state = 25},
  [2451] = {.lex_state = 764, .external_lex_state = 25},
  [2452] = {.lex_state = 107, .external_lex_state = 55},
  [2453] = {.lex_state = 764, .external_lex_state = 25},
  [2454] = {.lex_state = 764, .external_lex_state = 43},
  [2455] = {.lex_state = 107, .external_lex_state = 55},
  [2456] = {.lex_state = 764, .external_lex_state = 25},
  [2457] = {.lex_state = 107, .external_lex_state = 29},
  [2458] = {.lex_state = 107, .external_lex_state = 29},
  [2459] = {.lex_state = 764, .external_lex_state = 25},
  [2460] = {.lex_state = 767, .external_lex_state = 64},
  [2461] = {.lex_state = 107, .external_lex_state = 29},
  [2462] = {.lex_state = 764, .external_lex_state = 25},
  [2463] = {.lex_state = 764, .external_lex_state = 25},
  [2464] = {.lex_state = 764, .external_lex_state = 25},
  [2465] = {.lex_state = 764, .external_lex_state = 25},
  [2466] = {.lex_state = 764, .external_lex_state = 43},
  [2467] = {.lex_state = 764, .external_lex_state = 25},
  [2468] = {.lex_state = 767, .external_lex_state = 64},
  [2469] = {.lex_state = 764, .external_lex_state = 25},
  [2470] = {.lex_state = 764, .external_lex_state = 43},
  [2471] = {.lex_state = 764, .external_lex_state = 25},
  [2472] = {.lex_state = 107, .external_lex_state = 55},
  [2473] = {.lex_state = 764, .external_lex_state = 25},
  [2474] = {.lex_state = 107, .external_lex_state = 55},
  [2475] = {.lex_state = 107, .external_lex_state = 40},
  [2476] = {.lex_state = 764, .external_lex_state = 25},
  [2477] = {.lex_state = 764, .external_lex_state = 25},
  [2478] = {.lex_state = 107, .external_lex_state = 55},
  [2479] = {.lex_state = 764, .external_lex_state = 25},
  [2480] = {.lex_state = 764, .external_lex_state = 25},
  [2481] = {.lex_state = 764, .external_lex_state = 25},
  [2482] = {.lex_state = 764, .external_lex_state = 25},
  [2483] = {.lex_state = 764, .external_lex_state = 25},
  [2484] = {.lex_state = 764, .external_lex_state = 25},
  [2485] = {.lex_state = 764, .external_lex_state = 43},
  [2486] = {.lex_state = 764, .external_lex_state = 43},
  [2487] = {.lex_state = 764, .external_lex_state = 43},
  [2488] = {.lex_state = 764, .external_lex_state = 25},
  [2489] = {.lex_state = 107, .external_lex_state = 59},
  [2490] = {.lex_state = 764, .external_lex_state = 42},
  [2491] = {.lex_state = 764, .external_lex_state = 25},
  [2492] = {.lex_state = 764, .external_lex_state = 24},
  [2493] = {.lex_state = 764, .external_lex_state = 24},
  [2494] = {.lex_state = 764, .external_lex_state = 25},
  [2495] = {.lex_state = 764, .external_lex_state = 25},
  [2496] = {.lex_state = 764, .external_lex_state = 18},
  [2497] = {.lex_state = 764, .external_lex_state = 43},
  [2498] = {.lex_state = 764, .external_lex_state = 42},
  [2499] = {.lex_state = 764, .external_lex_state = 24},
  [2500] = {.lex_state = 764, .external_lex_state = 25},
  [2501] = {.lex_state = 764, .external_lex_state = 25},
  [2502] = {.lex_state = 764, .external_lex_state = 25},
  [2503] = {.lex_state = 764, .external_lex_state = 25},
  [2504] = {.lex_state = 764, .external_lex_state = 43},
  [2505] = {.lex_state = 107, .external_lex_state = 41},
  [2506] = {.lex_state = 767, .external_lex_state = 66},
  [2507] = {.lex_state = 107, .external_lex_state = 59},
  [2508] = {.lex_state = 764, .external_lex_state = 25},
  [2509] = {.lex_state = 764, .external_lex_state = 25},
  [2510] = {.lex_state = 107, .external_lex_state = 59},
  [2511] = {.lex_state = 764, .external_lex_state = 42},
  [2512] = {.lex_state = 107, .external_lex_state = 29},
  [2513] = {.lex_state = 767, .external_lex_state = 66},
  [2514] = {.lex_state = 764, .external_lex_state = 25},
  [2515] = {.lex_state = 107, .external_lex_state = 65},
  [2516] = {.lex_state = 764, .external_lex_state = 25},
  [2517] = {.lex_state = 764, .external_lex_state = 18},
  [2518] = {.lex_state = 764, .external_lex_state = 25},
  [2519] = {.lex_state = 764, .external_lex_state = 24},
  [2520] = {.lex_state = 764, .external_lex_state = 25},
  [2521] = {.lex_state = 764, .external_lex_state = 24},
  [2522] = {.lex_state = 764, .external_lex_state = 25},
  [2523] = {.lex_state = 764, .external_lex_state = 25},
  [2524] = {.lex_state = 764, .external_lex_state = 42},
  [2525] = {.lex_state = 107, .external_lex_state = 29},
  [2526] = {.lex_state = 107, .external_lex_state = 29},
  [2527] = {.lex_state = 107, .external_lex_state = 65},
  [2528] = {.lex_state = 764, .external_lex_state = 42},
  [2529] = {.lex_state = 107, .external_lex_state = 65},
  [2530] = {.lex_state = 764, .external_lex_state = 18},
  [2531] = {.lex_state = 764, .external_lex_state = 25},
  [2532] = {.lex_state = 764, .external_lex_state = 42},
  [2533] = {.lex_state = 764, .external_lex_state = 24},
  [2534] = {.lex_state = 764, .external_lex_state = 24},
  [2535] = {.lex_state = 764, .external_lex_state = 42},
  [2536] = {.lex_state = 764, .external_lex_state = 43},
  [2537] = {.lex_state = 764, .external_lex_state = 43},
  [2538] = {.lex_state = 764, .external_lex_state = 25},
  [2539] = {.lex_state = 107, .external_lex_state = 65},
  [2540] = {.lex_state = 764, .external_lex_state = 25},
  [2541] = {.lex_state = 764, .external_lex_state = 25},
  [2542] = {.lex_state = 764, .external_lex_state = 25},
  [2543] = {.lex_state = 107, .external_lex_state = 65},
  [2544] = {.lex_state = 764, .external_lex_state = 18},
  [2545] = {.lex_state = 107, .external_lex_state = 65},
  [2546] = {.lex_state = 764, .external_lex_state = 25},
  [2547] = {.lex_state = 764, .external_lex_state = 25},
  [2548] = {.lex_state = 107, .external_lex_state = 65},
  [2549] = {.lex_state = 764, .external_lex_state = 25},
  [2550] = {.lex_state = 764, .external_lex_state = 18},
  [2551] = {.lex_state = 764, .external_lex_state = 18},
  [2552] = {.lex_state = 107, .external_lex_state = 29},
  [2553] = {.lex_state = 107, .external_lex_state = 29},
  [2554] = {.lex_state = 107, .external_lex_state = 29},
  [2555] = {.lex_state = 107, .external_lex_state = 61},
  [2556] = {.lex_state = 764, .external_lex_state = 25},
  [2557] = {.lex_state = 107, .external_lex_state = 29},
  [2558] = {.lex_state = 764, .external_lex_state = 24},
  [2559] = {.lex_state = 764, .external_lex_state = 25},
  [2560] = {.lex_state = 764, .external_lex_state = 18},
  [2561] = {.lex_state = 764, .external_lex_state = 42},
  [2562] = {.lex_state = 764, .external_lex_state = 25},
  [2563] = {.lex_state = 764, .external_lex_state = 24},
  [2564] = {.lex_state = 764, .external_lex_state = 24},
  [2565] = {.lex_state = 764, .external_lex_state = 42},
  [2566] = {.lex_state = 107, .external_lex_state = 61},
  [2567] = {.lex_state = 764, .external_lex_state = 25},
  [2568] = {.lex_state = 764, .external_lex_state = 42},
  [2569] = {.lex_state = 764, .external_lex_state = 25},
  [2570] = {.lex_state = 764, .external_lex_state = 25},
  [2571] = {.lex_state = 107, .external_lex_state = 29},
  [2572] = {.lex_state = 107, .external_lex_state = 29},
  [2573] = {.lex_state = 764, .external_lex_state = 43},
  [2574] = {.lex_state = 764, .external_lex_state = 25},
  [2575] = {.lex_state = 107, .external_lex_state = 59},
  [2576] = {.lex_state = 107, .external_lex_state = 29},
  [2577] = {.lex_state = 764, .external_lex_state = 25},
  [2578] = {.lex_state = 107, .external_lex_state = 29},
  [2579] = {.lex_state = 764, .external_lex_state = 25},
  [2580] = {.lex_state = 764, .external_lex_state = 25},
  [2581] = {.lex_state = 764, .external_lex_state = 25},
  [2582] = {.lex_state = 764, .external_lex_state = 25},
  [2583] = {.lex_state = 764, .external_lex_state = 25},
  [2584] = {.lex_state = 107, .external_lex_state = 59},
  [2585] = {.lex_state = 764, .external_lex_state = 25},
  [2586] = {.lex_state = 764, .external_lex_state = 25},
  [2587] = {.lex_state = 764, .external_lex_state = 25},
  [2588] = {.lex_state = 107, .external_lex_state = 29},
  [2589] = {.lex_state = 107, .external_lex_state = 61},
  [2590] = {.lex_state = 768, .external_lex_state = 59},
  [2591] = {.lex_state = 764, .external_lex_state = 25},
  [2592] = {.lex_state = 764, .external_lex_state = 25},
  [2593] = {.lex_state = 764, .external_lex_state = 25},
  [2594] = {.lex_state = 764, .external_lex_state = 25},
  [2595] = {.lex_state = 107, .external_lex_state = 29},
  [2596] = {.lex_state = 764, .external_lex_state = 18},
  [2597] = {.lex_state = 764, .external_lex_state = 25},
  [2598] = {.lex_state = 764, .external_lex_state = 25},
  [2599] = {.lex_state = 107, .external_lex_state = 41},
  [2600] = {.lex_state = 107, .external_lex_state = 59},
  [2601] = {.lex_state = 764, .external_lex_state = 25},
  [2602] = {.lex_state = 764, .external_lex_state = 25},
  [2603] = {.lex_state = 107, .external_lex_state = 41},
  [2604] = {.lex_state = 107, .external_lex_state = 59},
  [2605] = {.lex_state = 764, .external_lex_state = 25},
  [2606] = {.lex_state = 764, .external_lex_state = 18},
  [2607] = {.lex_state = 764, .external_lex_state = 24},
  [2608] = {.lex_state = 107, .external_lex_state = 29},
  [2609] = {.lex_state = 107, .external_lex_state = 40},
  [2610] = {.lex_state = 764, .external_lex_state = 25},
  [2611] = {.lex_state = 768, .external_lex_state = 59},
  [2612] = {.lex_state = 764, .external_lex_state = 25},
  [2613] = {.lex_state = 764, .external_lex_state = 25},
  [2614] = {.lex_state = 764, .external_lex_state = 25},
  [2615] = {.lex_state = 764, .external_lex_state = 25},
  [2616] = {.lex_state = 107, .external_lex_state = 29},
  [2617] = {.lex_state = 107, .external_lex_state = 29},
  [2618] = {.lex_state = 107, .external_lex_state = 29},
  [2619] = {.lex_state = 764, .external_lex_state = 18},
  [2620] = {.lex_state = 107, .external_lex_state = 29},
  [2621] = {.lex_state = 107, .external_lex_state = 29},
  [2622] = {.lex_state = 107, .external_lex_state = 29},
  [2623] = {.lex_state = 107, .external_lex_state = 29},
  [2624] = {.lex_state = 764, .external_lex_state = 18},
  [2625] = {.lex_state = 764, .external_lex_state = 25},
  [2626] = {.lex_state = 764, .external_lex_state = 25},
  [2627] = {.lex_state = 764, .external_lex_state = 25},
  [2628] = {.lex_state = 764, .external_lex_state = 42},
  [2629] = {.lex_state = 764, .external_lex_state = 25},
  [2630] = {.lex_state = 764, .external_lex_state = 18},
  [2631] = {.lex_state = 764, .external_lex_state = 25},
  [2632] = {.lex_state = 107, .external_lex_state = 59},
  [2633] = {.lex_state = 764, .external_lex_state = 25},
  [2634] = {.lex_state = 764, .external_lex_state = 25},
  [2635] = {.lex_state = 764, .external_lex_state = 25},
  [2636] = {.lex_state = 764, .external_lex_state = 24},
  [2637] = {.lex_state = 764, .external_lex_state = 25},
  [2638] = {.lex_state = 107, .external_lex_state = 29},
  [2639] = {.lex_state = 764, .external_lex_state = 24},
  [2640] = {.lex_state = 107, .external_lex_state = 29},
  [2641] = {.lex_state = 107, .external_lex_state = 29},
  [2642] = {.lex_state = 107, .external_lex_state = 29},
  [2643] = {.lex_state = 107, .external_lex_state = 29},
  [2644] = {.lex_state = 764, .external_lex_state = 25},
  [2645] = {.lex_state = 107, .external_lex_state = 29},
  [2646] = {.lex_state = 107, .external_lex_state = 29},
  [2647] = {.lex_state = 107, .external_lex_state = 29},
  [2648] = {.lex_state = 107, .external_lex_state = 29},
  [2649] = {.lex_state = 107, .external_lex_state = 29},
  [2650] = {.lex_state = 764, .external_lex_state = 25},
  [2651] = {.lex_state = 764, .external_lex_state = 18},
  [2652] = {.lex_state = 764, .external_lex_state = 43},
  [2653] = {.lex_state = 764, .external_lex_state = 25},
  [2654] = {.lex_state = 764, .external_lex_state = 25},
  [2655] = {.lex_state = 764, .external_lex_state = 25},
  [2656] = {.lex_state = 764, .external_lex_state = 18},
  [2657] = {.lex_state = 764, .external_lex_state = 25},
  [2658] = {.lex_state = 764, .external_lex_state = 25},
  [2659] = {.lex_state = 764, .external_lex_state = 24},
  [2660] = {.lex_state = 764, .external_lex_state = 25},
  [2661] = {.lex_state = 107, .external_lex_state = 41},
  [2662] = {.lex_state = 764, .external_lex_state = 25},
  [2663] = {.lex_state = 764, .external_lex_state = 25},
  [2664] = {.lex_state = 764, .external_lex_state = 25},
  [2665] = {.lex_state = 764, .external_lex_state = 25},
  [2666] = {.lex_state = 764, .external_lex_state = 25},
  [2667] = {.lex_state = 764, .external_lex_state = 25},
  [2668] = {.lex_state = 764, .external_lex_state = 25},
  [2669] = {.lex_state = 107, .external_lex_state = 29},
  [2670] = {.lex_state = 764, .external_lex_state = 43},
  [2671] = {.lex_state = 107, .external_lex_state = 29},
  [2672] = {.lex_state = 764, .external_lex_state = 42},
  [2673] = {.lex_state = 107, .external_lex_state = 29},
  [2674] = {.lex_state = 107, .external_lex_state = 29},
  [2675] = {.lex_state = 107, .external_lex_state = 29},
  [2676] = {.lex_state = 107, .external_lex_state = 29},
  [2677] = {.lex_state = 764, .external_lex_state = 42},
  [2678] = {.lex_state = 764, .external_lex_state = 43},
  [2679] = {.lex_state = 107, .external_lex_state = 29},
  [2680] = {.lex_state = 764, .external_lex_state = 42},
  [2681] = {.lex_state = 764, .external_lex_state = 42},
  [2682] = {.lex_state = 764, .external_lex_state = 42},
  [2683] = {.lex_state = 764, .external_lex_state = 42},
  [2684] = {.lex_state = 764, .external_lex_state = 42},
  [2685] = {.lex_state = 107, .external_lex_state = 29},
  [2686] = {.lex_state = 107, .external_lex_state = 29},
  [2687] = {.lex_state = 764, .external_lex_state = 42},
  [2688] = {.lex_state = 107, .external_lex_state = 29},
  [2689] = {.lex_state = 107, .external_lex_state = 29},
  [2690] = {.lex_state = 107, .external_lex_state = 29},
  [2691] = {.lex_state = 107, .external_lex_state = 29},
  [2692] = {.lex_state = 107, .external_lex_state = 29},
  [2693] = {.lex_state = 107, .external_lex_state = 29},
  [2694] = {.lex_state = 107, .external_lex_state = 29},
  [2695] = {.lex_state = 107, .external_lex_state = 29},
  [2696] = {.lex_state = 107, .external_lex_state = 29},
  [2697] = {.lex_state = 107, .external_lex_state = 29},
  [2698] = {.lex_state = 107, .external_lex_state = 29},
  [2699] = {.lex_state = 107, .external_lex_state = 29},
  [2700] = {.lex_state = 764, .external_lex_state = 24},
  [2701] = {.lex_state = 768, .external_lex_state = 59},
  [2702] = {.lex_state = 107, .external_lex_state = 29},
  [2703] = {.lex_state = 107, .external_lex_state = 29},
  [2704] = {.lex_state = 107, .external_lex_state = 29},
  [2705] = {.lex_state = 768, .external_lex_state = 59},
  [2706] = {.lex_state = 107, .external_lex_state = 29},
  [2707] = {.lex_state = 107, .external_lex_state = 29},
  [2708] = {.lex_state = 107, .external_lex_state = 29},
  [2709] = {.lex_state = 107, .external_lex_state = 29},
  [2710] = {.lex_state = 107, .external_lex_state = 29},
  [2711] = {.lex_state = 107, .external_lex_state = 29},
  [2712] = {.lex_state = 107, .external_lex_state = 29},
  [2713] = {.lex_state = 107, .external_lex_state = 29},
  [2714] = {.lex_state = 107, .external_lex_state = 29},
  [2715] = {.lex_state = 107, .external_lex_state = 29},
  [2716] = {.lex_state = 764, .external_lex_state = 24},
  [2717] = {.lex_state = 107, .external_lex_state = 29},
  [2718] = {.lex_state = 107, .external_lex_state = 29},
  [2719] = {.lex_state = 107, .external_lex_state = 29},
  [2720] = {.lex_state = 107, .external_lex_state = 29},
  [2721] = {.lex_state = 107, .external_lex_state = 29},
  [2722] = {.lex_state = 107, .external_lex_state = 29},
  [2723] = {.lex_state = 764, .external_lex_state = 42},
  [2724] = {.lex_state = 107, .external_lex_state = 29},
  [2725] = {.lex_state = 107, .external_lex_state = 29},
  [2726] = {.lex_state = 107, .external_lex_state = 29},
  [2727] = {.lex_state = 107, .external_lex_state = 29},
  [2728] = {.lex_state = 107, .external_lex_state = 29},
  [2729] = {.lex_state = 107, .external_lex_state = 29},
  [2730] = {.lex_state = 764, .external_lex_state = 42},
  [2731] = {.lex_state = 107, .external_lex_state = 29},
  [2732] = {.lex_state = 107, .external_lex_state = 29},
  [2733] = {.lex_state = 764, .external_lex_state = 42},
  [2734] = {.lex_state = 764, .external_lex_state = 43},
  [2735] = {.lex_state = 107, .external_lex_state = 29},
  [2736] = {.lex_state = 764, .external_lex_state = 42},
  [2737] = {.lex_state = 107, .external_lex_state = 29},
  [2738] = {.lex_state = 107, .external_lex_state = 29},
  [2739] = {.lex_state = 107, .external_lex_state = 29},
  [2740] = {.lex_state = 764, .external_lex_state = 42},
  [2741] = {.lex_state = 107, .external_lex_state = 29},
  [2742] = {.lex_state = 107, .external_lex_state = 29},
  [2743] = {.lex_state = 764, .external_lex_state = 43},
  [2744] = {.lex_state = 107, .external_lex_state = 29},
  [2745] = {.lex_state = 764, .external_lex_state = 43},
  [2746] = {.lex_state = 764, .external_lex_state = 24},
  [2747] = {.lex_state = 107, .external_lex_state = 41},
  [2748] = {.lex_state = 107, .external_lex_state = 29},
  [2749] = {.lex_state = 107, .external_lex_state = 29},
  [2750] = {.lex_state = 764, .external_lex_state = 42},
  [2751] = {.lex_state = 107, .external_lex_state = 29},
  [2752] = {.lex_state = 107, .external_lex_state = 29},
  [2753] = {.lex_state = 107, .external_lex_state = 29},
  [2754] = {.lex_state = 107, .external_lex_state = 29},
  [2755] = {.lex_state = 107, .external_lex_state = 29},
  [2756] = {.lex_state = 107, .external_lex_state = 29},
  [2757] = {.lex_state = 764, .external_lex_state = 42},
  [2758] = {.lex_state = 107, .external_lex_state = 29},
  [2759] = {.lex_state = 107, .external_lex_state = 29},
  [2760] = {.lex_state = 764, .external_lex_state = 42},
  [2761] = {.lex_state = 107, .external_lex_state = 29},
  [2762] = {.lex_state = 107, .external_lex_state = 29},
  [2763] = {.lex_state = 107, .external_lex_state = 29},
  [2764] = {.lex_state = 107, .external_lex_state = 29},
  [2765] = {.lex_state = 107, .external_lex_state = 29},
  [2766] = {.lex_state = 768, .external_lex_state = 59},
  [2767] = {.lex_state = 107, .external_lex_state = 29},
  [2768] = {.lex_state = 107, .external_lex_state = 29},
  [2769] = {.lex_state = 107, .external_lex_state = 29},
  [2770] = {.lex_state = 107, .external_lex_state = 29},
  [2771] = {.lex_state = 764, .external_lex_state = 42},
  [2772] = {.lex_state = 768, .external_lex_state = 59},
  [2773] = {.lex_state = 107, .external_lex_state = 29},
  [2774] = {.lex_state = 107, .external_lex_state = 29},
  [2775] = {.lex_state = 107, .external_lex_state = 29},
  [2776] = {.lex_state = 107, .external_lex_state = 29},
  [2777] = {.lex_state = 764, .external_lex_state = 42},
  [2778] = {.lex_state = 107, .external_lex_state = 29},
  [2779] = {.lex_state = 107, .external_lex_state = 29},
  [2780] = {.lex_state = 107, .external_lex_state = 29},
  [2781] = {.lex_state = 107, .external_lex_state = 29},
  [2782] = {.lex_state = 107, .external_lex_state = 29},
  [2783] = {.lex_state = 107, .external_lex_state = 29},
  [2784] = {.lex_state = 107, .external_lex_state = 29},
  [2785] = {.lex_state = 107, .external_lex_state = 29},
  [2786] = {.lex_state = 764, .external_lex_state = 43},
  [2787] = {.lex_state = 107, .external_lex_state = 29},
  [2788] = {.lex_state = 107, .external_lex_state = 40},
  [2789] = {.lex_state = 107, .external_lex_state = 29},
  [2790] = {.lex_state = 107, .external_lex_state = 29},
  [2791] = {.lex_state = 107, .external_lex_state = 40},
  [2792] = {.lex_state = 107, .external_lex_state = 29},
  [2793] = {.lex_state = 107, .external_lex_state = 29},
  [2794] = {.lex_state = 107, .external_lex_state = 29},
  [2795] = {.lex_state = 107, .external_lex_state = 40},
  [2796] = {.lex_state = 107, .external_lex_state = 29},
  [2797] = {.lex_state = 107, .external_lex_state = 29},
  [2798] = {.lex_state = 107, .external_lex_state = 29},
  [2799] = {.lex_state = 107, .external_lex_state = 29},
  [2800] = {.lex_state = 107, .external_lex_state = 29},
  [2801] = {.lex_state = 764, .external_lex_state = 43},
  [2802] = {.lex_state = 764, .external_lex_state = 43},
  [2803] = {.lex_state = 764, .external_lex_state = 43},
  [2804] = {.lex_state = 107, .external_lex_state = 29},
  [2805] = {.lex_state = 764, .external_lex_state = 42},
  [2806] = {.lex_state = 107, .external_lex_state = 29},
  [2807] = {.lex_state = 107, .external_lex_state = 65},
  [2808] = {.lex_state = 107, .external_lex_state = 29},
  [2809] = {.lex_state = 107, .external_lex_state = 29},
  [2810] = {.lex_state = 107, .external_lex_state = 29},
  [2811] = {.lex_state = 764, .external_lex_state = 42},
  [2812] = {.lex_state = 107, .external_lex_state = 29},
  [2813] = {.lex_state = 107, .external_lex_state = 29},
  [2814] = {.lex_state = 764, .external_lex_state = 42},
  [2815] = {.lex_state = 107, .external_lex_state = 29},
  [2816] = {.lex_state = 107, .external_lex_state = 29},
  [2817] = {.lex_state = 764, .external_lex_state = 18},
  [2818] = {.lex_state = 107, .external_lex_state = 29},
  [2819] = {.lex_state = 764, .external_lex_state = 42},
  [2820] = {.lex_state = 107, .external_lex_state = 29},
  [2821] = {.lex_state = 764, .external_lex_state = 42},
  [2822] = {.lex_state = 764, .external_lex_state = 43},
  [2823] = {.lex_state = 764, .external_lex_state = 42},
  [2824] = {.lex_state = 764, .external_lex_state = 42},
  [2825] = {.lex_state = 107, .external_lex_state = 29},
  [2826] = {.lex_state = 107, .external_lex_state = 29},
  [2827] = {.lex_state = 764, .external_lex_state = 43},
  [2828] = {.lex_state = 107, .external_lex_state = 29},
  [2829] = {.lex_state = 107, .external_lex_state = 29},
  [2830] = {.lex_state = 764, .external_lex_state = 43},
  [2831] = {.lex_state = 107, .external_lex_state = 29},
  [2832] = {.lex_state = 107, .external_lex_state = 29},
  [2833] = {.lex_state = 764, .external_lex_state = 43},
  [2834] = {.lex_state = 107, .external_lex_state = 29},
  [2835] = {.lex_state = 107, .external_lex_state = 29},
  [2836] = {.lex_state = 767, .external_lex_state = 66},
  [2837] = {.lex_state = 107, .external_lex_state = 29},
  [2838] = {.lex_state = 107, .external_lex_state = 29},
  [2839] = {.lex_state = 107, .external_lex_state = 29},
  [2840] = {.lex_state = 767, .external_lex_state = 66},
  [2841] = {.lex_state = 107, .external_lex_state = 29},
  [2842] = {.lex_state = 107, .external_lex_state = 29},
  [2843] = {.lex_state = 107, .external_lex_state = 29},
  [2844] = {.lex_state = 107, .external_lex_state = 29},
  [2845] = {.lex_state = 107, .external_lex_state = 29},
  [2846] = {.lex_state = 107, .external_lex_state = 29},
  [2847] = {.lex_state = 107, .external_lex_state = 29},
  [2848] = {.lex_state = 764, .external_lex_state = 42},
  [2849] = {.lex_state = 107, .external_lex_state = 29},
  [2850] = {.lex_state = 107, .external_lex_state = 29},
  [2851] = {.lex_state = 107, .external_lex_state = 29},
  [2852] = {.lex_state = 107, .external_lex_state = 29},
  [2853] = {.lex_state = 107, .external_lex_state = 29},
  [2854] = {.lex_state = 764, .external_lex_state = 43},
  [2855] = {.lex_state = 107, .external_lex_state = 29},
  [2856] = {.lex_state = 764, .external_lex_state = 42},
  [2857] = {.lex_state = 107, .external_lex_state = 29},
  [2858] = {.lex_state = 107, .external_lex_state = 29},
  [2859] = {.lex_state = 764, .external_lex_state = 42},
  [2860] = {.lex_state = 107, .external_lex_state = 29},
  [2861] = {.lex_state = 107, .external_lex_state = 29},
  [2862] = {.lex_state = 764, .external_lex_state = 43},
  [2863] = {.lex_state = 107, .external_lex_state = 29},
  [2864] = {.lex_state = 107, .external_lex_state = 29},
  [2865] = {.lex_state = 107, .external_lex_state = 29},
  [2866] = {.lex_state = 764, .external_lex_state = 43},
  [2867] = {.lex_state = 107, .external_lex_state = 29},
  [2868] = {.lex_state = 107, .external_lex_state = 29},
  [2869] = {.lex_state = 107, .external_lex_state = 29},
  [2870] = {.lex_state = 107, .external_lex_state = 29},
  [2871] = {.lex_state = 764, .external_lex_state = 43},
  [2872] = {.lex_state = 107, .external_lex_state = 29},
  [2873] = {.lex_state = 107, .external_lex_state = 29},
  [2874] = {.lex_state = 107, .external_lex_state = 29},
  [2875] = {.lex_state = 764, .external_lex_state = 43},
  [2876] = {.lex_state = 764, .external_lex_state = 42},
  [2877] = {.lex_state = 764, .external_lex_state = 42},
  [2878] = {.lex_state = 764, .external_lex_state = 42},
  [2879] = {.lex_state = 107, .external_lex_state = 29},
  [2880] = {.lex_state = 107, .external_lex_state = 29},
  [2881] = {.lex_state = 764, .external_lex_state = 42},
  [2882] = {.lex_state = 107, .external_lex_state = 29},
  [2883] = {.lex_state = 107, .external_lex_state = 29},
  [2884] = {.lex_state = 107, .external_lex_state = 29},
  [2885] = {.lex_state = 107, .external_lex_state = 29},
  [2886] = {.lex_state = 107, .external_lex_state = 29},
  [2887] = {.lex_state = 107, .external_lex_state = 29},
  [2888] = {.lex_state = 107, .external_lex_state = 29},
  [2889] = {.lex_state = 107, .external_lex_state = 29},
  [2890] = {.lex_state = 107, .external_lex_state = 29},
  [2891] = {.lex_state = 107, .external_lex_state = 29},
  [2892] = {.lex_state = 764, .external_lex_state = 24},
  [2893] = {.lex_state = 107, .external_lex_state = 29},
  [2894] = {.lex_state = 107, .external_lex_state = 29},
  [2895] = {.lex_state = 764, .external_lex_state = 43},
  [2896] = {.lex_state = 107, .external_lex_state = 29},
  [2897] = {.lex_state = 107, .external_lex_state = 29},
  [2898] = {.lex_state = 107, .external_lex_state = 29},
  [2899] = {.lex_state = 764, .external_lex_state = 42},
  [2900] = {.lex_state = 107, .external_lex_state = 29},
  [2901] = {.lex_state = 107, .external_lex_state = 29},
  [2902] = {.lex_state = 764, .external_lex_state = 42},
  [2903] = {.lex_state = 107, .external_lex_state = 29},
  [2904] = {.lex_state = 764, .external_lex_state = 43},
  [2905] = {.lex_state = 764, .external_lex_state = 43},
  [2906] = {.lex_state = 764, .external_lex_state = 42},
  [2907] = {.lex_state = 107, .external_lex_state = 29},
  [2908] = {.lex_state = 107, .external_lex_state = 29},
  [2909] = {.lex_state = 107, .external_lex_state = 29},
  [2910] = {.lex_state = 107, .external_lex_state = 29},
  [2911] = {.lex_state = 767, .external_lex_state = 67},
  [2912] = {.lex_state = 107, .external_lex_state = 29},
  [2913] = {.lex_state = 107, .external_lex_state = 29},
  [2914] = {.lex_state = 107, .external_lex_state = 29},
  [2915] = {.lex_state = 107, .external_lex_state = 29},
  [2916] = {.lex_state = 764, .external_lex_state = 43},
  [2917] = {.lex_state = 764, .external_lex_state = 42},
  [2918] = {.lex_state = 107, .external_lex_state = 29},
  [2919] = {.lex_state = 764, .external_lex_state = 24},
  [2920] = {.lex_state = 764, .external_lex_state = 43},
  [2921] = {.lex_state = 767, .external_lex_state = 67},
  [2922] = {.lex_state = 107, .external_lex_state = 29},
  [2923] = {.lex_state = 764, .external_lex_state = 43},
  [2924] = {.lex_state = 764, .external_lex_state = 42},
  [2925] = {.lex_state = 764, .external_lex_state = 43},
  [2926] = {.lex_state = 764, .external_lex_state = 42},
  [2927] = {.lex_state = 764, .external_lex_state = 43},
  [2928] = {.lex_state = 764, .external_lex_state = 42},
  [2929] = {.lex_state = 764, .external_lex_state = 43},
  [2930] = {.lex_state = 107, .external_lex_state = 29},
  [2931] = {.lex_state = 764, .external_lex_state = 42},
  [2932] = {.lex_state = 764, .external_lex_state = 43},
  [2933] = {.lex_state = 764, .external_lex_state = 42},
  [2934] = {.lex_state = 107, .external_lex_state = 29},
  [2935] = {.lex_state = 764, .external_lex_state = 42},
  [2936] = {.lex_state = 764, .external_lex_state = 24},
  [2937] = {.lex_state = 764, .external_lex_state = 42},
  [2938] = {.lex_state = 764, .external_lex_state = 43},
  [2939] = {.lex_state = 764, .external_lex_state = 42},
  [2940] = {.lex_state = 764, .external_lex_state = 42},
  [2941] = {.lex_state = 107, .external_lex_state = 65},
  [2942] = {.lex_state = 764, .external_lex_state = 42},
  [2943] = {.lex_state = 764, .external_lex_state = 43},
  [2944] = {.lex_state = 764, .external_lex_state = 43},
  [2945] = {.lex_state = 764, .external_lex_state = 42},
  [2946] = {.lex_state = 764, .external_lex_state = 43},
  [2947] = {.lex_state = 764, .external_lex_state = 43},
  [2948] = {.lex_state = 764, .external_lex_state = 42},
  [2949] = {.lex_state = 764, .external_lex_state = 43},
  [2950] = {.lex_state = 107, .external_lex_state = 29},
  [2951] = {.lex_state = 764, .external_lex_state = 43},
  [2952] = {.lex_state = 764, .external_lex_state = 43},
  [2953] = {.lex_state = 764, .external_lex_state = 43},
  [2954] = {.lex_state = 107, .external_lex_state = 29},
  [2955] = {.lex_state = 764, .external_lex_state = 42},
  [2956] = {.lex_state = 764, .external_lex_state = 42},
  [2957] = {.lex_state = 764, .external_lex_state = 42},
  [2958] = {.lex_state = 764, .external_lex_state = 42},
  [2959] = {.lex_state = 764, .external_lex_state = 43},
  [2960] = {.lex_state = 107, .external_lex_state = 29},
  [2961] = {.lex_state = 107, .external_lex_state = 40},
  [2962] = {.lex_state = 107, .external_lex_state = 29},
  [2963] = {.lex_state = 764, .external_lex_state = 42},
  [2964] = {.lex_state = 764, .external_lex_state = 42},
  [2965] = {.lex_state = 764, .external_lex_state = 24},
  [2966] = {.lex_state = 107, .external_lex_state = 29},
  [2967] = {.lex_state = 107, .external_lex_state = 29},
  [2968] = {.lex_state = 764, .external_lex_state = 18},
  [2969] = {.lex_state = 764, .external_lex_state = 42},
  [2970] = {.lex_state = 764, .external_lex_state = 42},
  [2971] = {.lex_state = 764, .external_lex_state = 42},
  [2972] = {.lex_state = 764, .external_lex_state = 42},
  [2973] = {.lex_state = 764, .external_lex_state = 43},
  [2974] = {.lex_state = 764, .external_lex_state = 42},
  [2975] = {.lex_state = 764, .external_lex_state = 43},
  [2976] = {.lex_state = 764, .external_lex_state = 42},
  [2977] = {.lex_state = 764, .external_lex_state = 42},
  [2978] = {.lex_state = 764, .external_lex_state = 42},
  [2979] = {.lex_state = 764, .external_lex_state = 43},
  [2980] = {.lex_state = 107, .external_lex_state = 29},
  [2981] = {.lex_state = 107, .external_lex_state = 29},
  [2982] = {.lex_state = 764, .external_lex_state = 43},
  [2983] = {.lex_state = 764, .external_lex_state = 43},
  [2984] = {.lex_state = 764, .external_lex_state = 43},
  [2985] = {.lex_state = 764, .external_lex_state = 42},
  [2986] = {.lex_state = 764, .external_lex_state = 42},
  [2987] = {.lex_state = 764, .external_lex_state = 42},
  [2988] = {.lex_state = 764, .external_lex_state = 43},
  [2989] = {.lex_state = 764, .external_lex_state = 42},
  [2990] = {.lex_state = 764, .external_lex_state = 43},
  [2991] = {.lex_state = 764, .external_lex_state = 43},
  [2992] = {.lex_state = 764, .external_lex_state = 43},
  [2993] = {.lex_state = 764, .external_lex_state = 42},
  [2994] = {.lex_state = 764, .external_lex_state = 42},
  [2995] = {.lex_state = 764, .external_lex_state = 43},
  [2996] = {.lex_state = 764, .external_lex_state = 43},
  [2997] = {.lex_state = 764, .external_lex_state = 43},
  [2998] = {.lex_state = 764, .external_lex_state = 42},
  [2999] = {.lex_state = 764, .external_lex_state = 43},
  [3000] = {.lex_state = 764, .external_lex_state = 43},
  [3001] = {.lex_state = 764, .external_lex_state = 43},
  [3002] = {.lex_state = 764, .external_lex_state = 43},
  [3003] = {.lex_state = 764, .external_lex_state = 43},
  [3004] = {.lex_state = 764, .external_lex_state = 43},
  [3005] = {.lex_state = 764, .external_lex_state = 43},
  [3006] = {.lex_state = 764, .external_lex_state = 42},
  [3007] = {.lex_state = 764, .external_lex_state = 43},
  [3008] = {.lex_state = 764, .external_lex_state = 43},
  [3009] = {.lex_state = 764, .external_lex_state = 43},
  [3010] = {.lex_state = 764, .external_lex_state = 43},
  [3011] = {.lex_state = 764, .external_lex_state = 42},
  [3012] = {.lex_state = 764, .external_lex_state = 43},
  [3013] = {.lex_state = 764, .external_lex_state = 42},
  [3014] = {.lex_state = 764, .external_lex_state = 43},
  [3015] = {.lex_state = 764, .external_lex_state = 43},
  [3016] = {.lex_state = 107, .external_lex_state = 29},
  [3017] = {.lex_state = 764, .external_lex_state = 43},
  [3018] = {.lex_state = 107, .external_lex_state = 29},
  [3019] = {.lex_state = 764, .external_lex_state = 42},
  [3020] = {.lex_state = 764, .external_lex_state = 43},
  [3021] = {.lex_state = 107, .external_lex_state = 65},
  [3022] = {.lex_state = 764, .external_lex_state = 43},
  [3023] = {.lex_state = 764, .external_lex_state = 43},
  [3024] = {.lex_state = 764, .external_lex_state = 43},
  [3025] = {.lex_state = 764, .external_lex_state = 43},
  [3026] = {.lex_state = 764, .external_lex_state = 42},
  [3027] = {.lex_state = 764, .external_lex_state = 43},
  [3028] = {.lex_state = 764, .external_lex_state = 42},
  [3029] = {.lex_state = 764, .external_lex_state = 43},
  [3030] = {.lex_state = 764, .external_lex_state = 43},
  [3031] = {.lex_state = 764, .external_lex_state = 43},
  [3032] = {.lex_state = 107, .external_lex_state = 29},
  [3033] = {.lex_state = 107, .external_lex_state = 29},
  [3034] = {.lex_state = 107, .external_lex_state = 29},
  [3035] = {.lex_state = 764, .external_lex_state = 42},
  [3036] = {.lex_state = 107, .external_lex_state = 29},
  [3037] = {.lex_state = 764, .external_lex_state = 43},
  [3038] = {.lex_state = 764, .external_lex_state = 43},
  [3039] = {.lex_state = 764, .external_lex_state = 42},
  [3040] = {.lex_state = 107, .external_lex_state = 61},
  [3041] = {.lex_state = 107, .external_lex_state = 61},
  [3042] = {.lex_state = 764, .external_lex_state = 24},
  [3043] = {.lex_state = 764, .external_lex_state = 24},
  [3044] = {.lex_state = 764, .external_lex_state = 24},
  [3045] = {.lex_state = 764, .external_lex_state = 24},
  [3046] = {.lex_state = 764, .external_lex_state = 24},
  [3047] = {.lex_state = 764, .external_lex_state = 24},
  [3048] = {.lex_state = 764, .external_lex_state = 24},
  [3049] = {.lex_state = 764, .external_lex_state = 24},
  [3050] = {.lex_state = 107, .external_lex_state = 61},
  [3051] = {.lex_state = 764, .external_lex_state = 24},
  [3052] = {.lex_state = 764, .external_lex_state = 24},
  [3053] = {.lex_state = 764, .external_lex_state = 24},
  [3054] = {.lex_state = 767, .external_lex_state = 67},
  [3055] = {.lex_state = 767, .external_lex_state = 67},
  [3056] = {.lex_state = 764, .external_lex_state = 24},
  [3057] = {.lex_state = 764, .external_lex_state = 24},
  [3058] = {.lex_state = 764, .external_lex_state = 24},
  [3059] = {.lex_state = 764, .external_lex_state = 24},
  [3060] = {.lex_state = 764, .external_lex_state = 24},
  [3061] = {.lex_state = 107, .external_lex_state = 41},
  [3062] = {.lex_state = 764, .external_lex_state = 24},
  [3063] = {.lex_state = 764, .external_lex_state = 24},
  [3064] = {.lex_state = 764, .external_lex_state = 24},
  [3065] = {.lex_state = 764, .external_lex_state = 24},
  [3066] = {.lex_state = 107, .external_lex_state = 68},
  [3067] = {.lex_state = 764, .external_lex_state = 24},
  [3068] = {.lex_state = 107, .external_lex_state = 29},
  [3069] = {.lex_state = 764, .external_lex_state = 24},
  [3070] = {.lex_state = 764, .external_lex_state = 24},
  [3071] = {.lex_state = 764, .external_lex_state = 24},
  [3072] = {.lex_state = 764, .external_lex_state = 24},
  [3073] = {.lex_state = 764, .external_lex_state = 24},
  [3074] = {.lex_state = 764, .external_lex_state = 24},
  [3075] = {.lex_state = 764, .external_lex_state = 24},
  [3076] = {.lex_state = 764, .external_lex_state = 24},
  [3077] = {.lex_state = 764, .external_lex_state = 24},
  [3078] = {.lex_state = 764, .external_lex_state = 24},
  [3079] = {.lex_state = 764, .external_lex_state = 24},
  [3080] = {.lex_state = 764, .external_lex_state = 24},
  [3081] = {.lex_state = 764, .external_lex_state = 24},
  [3082] = {.lex_state = 764, .external_lex_state = 24},
  [3083] = {.lex_state = 767, .external_lex_state = 69},
  [3084] = {.lex_state = 764, .external_lex_state = 24},
  [3085] = {.lex_state = 767, .external_lex_state = 69},
  [3086] = {.lex_state = 764, .external_lex_state = 24},
  [3087] = {.lex_state = 764, .external_lex_state = 24},
  [3088] = {.lex_state = 764, .external_lex_state = 24},
  [3089] = {.lex_state = 767, .external_lex_state = 30},
  [3090] = {.lex_state = 764, .external_lex_state = 24},
  [3091] = {.lex_state = 764, .external_lex_state = 24},
  [3092] = {.lex_state = 764, .external_lex_state = 24},
  [3093] = {.lex_state = 764, .external_lex_state = 24},
  [3094] = {.lex_state = 764, .external_lex_state = 24},
  [3095] = {.lex_state = 764, .external_lex_state = 24},
  [3096] = {.lex_state = 764, .external_lex_state = 24},
  [3097] = {.lex_state = 767, .external_lex_state = 30},
  [3098] = {.lex_state = 764, .external_lex_state = 24},
  [3099] = {.lex_state = 764, .external_lex_state = 24},
  [3100] = {.lex_state = 764, .external_lex_sta