/*-------------------------------------------------------*/
/* stuff.c      ( NTHU CS MapleBBS Ver 2.36 )            */
/*-------------------------------------------------------*/
/* target : utility routines                             */
/* create : 95/03/29                                     */
/* update : 95/12/15                                     */
/*-------------------------------------------------------*/


#include <sys/param.h>
#include "bbs.h"


/* ----------------------------------------------------- */
/* set file path for boards/user home                    */
/* ----------------------------------------------------- */

char *str_home_file = "home/%s/%s";
char *str_board_file = "boards/%s/%s";
char *str_dotdir = ".DIR";

/*
void
sethomepath(buf, userid)
  char *buf, *userid;
{
  sprintf(buf, "home/%s", userid);
}


void
sethomedir(buf, userid)
  char *buf, *userid;
{
  sprintf(buf, str_home_file, userid, str_dotdir);
}


void
sethomefile(buf, userid, fname)
  char *buf, *userid, *fname;
{
  sprintf(buf, str_home_file, userid, fname);
}


void
setuserfile(buf, fname)
  char *buf, *fname;
{
  sprintf(buf, str_home_file, cuser.userid, fname);
}


void
setapath(buf, boardname)
  char *buf, *boardname;
{
  sprintf(buf, "man/%s", boardname);
}


void
setbpath(buf, boardname)
  char *buf, *boardname;
{
  sprintf(buf, "boards/%s", boardname);
}


void
setbdir(buf, boardname)
  char *buf, *boardname;
{
  sprintf(buf, str_board_file, boardname,
    currmode & MODE_DIGEST ? fn_mandex : str_dotdir);
}


void
setbfile(buf, boardname, fname)
  char *buf, *boardname, *fname;
{
  sprintf(buf, str_board_file, boardname, fname);
}
*/

void
setdirpath(buf, direct, fname)
  char *buf, *direct, *fname;
{
  strcpy(buf, direct);
  direct = strrchr(buf, '/');
  strcpy(direct + 1, fname);
}

/*
char *
subject(title)
  char *title;
{
  if (!strncasecmp(title, str_reply, 3))
  {
    title += 3;
    if (*title == ' ')
      title++;
  }
  return title;
}
*/

/* ----------------------------------------------------- */
/* rഫˬd                                      */
/* ----------------------------------------------------- */

/* Case Independent strncmp */

int
ci_strncmp(s1, s2, n)
  register char *s1, *s2;
  register int n;
{
  register char c1, c2;
  register int diff;

  do
  {
    c1 = *s1++;
    if (c1 >= 'A' && c1 <= 'Z')
      c1 |= 32;

    c2 = *s2++;
    if (c2 >= 'A' && c2 <= 'Z')
      c2 |= 32;

    if (diff = c1 - c2)
      return (diff);
  } while (--n && c1);

  return 0;
}


void
str_lower(t, s)
  char *t, *s;
{
  register uschar ch;

  do
  {
    ch = *s++;
    *t++ = char_lower(ch);
  } while (ch);
}


int
strstr_lower(str, tag)
  char *str, *tag;              /* tag : lower-case string */
{
  char buf[STRLEN];

  str_lower(buf, str);
  return (int) strstr(buf, tag);
}


void
trim(buf)                       /* remove trailing space */
  char *buf;
{
  char *p = buf;

  while (*p)
    p++;
  while (--p >= buf)
  {
    if (*p == ' ')
      *p = '\0';
    else
      break;
  }
}


/* ----------------------------------------------------- */
/* rˬdơG^BƦrBɦWBE-mail address        */
/* ----------------------------------------------------- */


#ifdef BIT8
int
isprint2(ch)
  char ch;
{
  return ((ch & 0x80) ? 1 : isprint(ch));
}
#endif


int
not_alpha(ch)
  register char ch;
{
  return (ch < 'A' || (ch > 'Z' && ch < 'a') || ch > 'z');
}


int
not_alnum(ch)
  register char ch;
{
  return (ch < '0' || (ch > '9' && ch < 'A') ||
    (ch > 'Z' && ch < 'a') || ch > 'z');
}


int
invalid_fname(str)
  char *str;
{
  char ch;

  while (ch = *str++)
  {
    if (not_alnum(ch) && !strchr("@[]-._/", ch))
      return 1;
  }
  return 0;
}


int
valid_ident(ident)
  char *ident;
{
  static char *invalid[] = {"unknown@", "root@", "gopher@", "bbs@",
  "@bbs", "guest@", "@ppp", "@slip", NULL};
  char buf[128];
  int i;

  str_lower(buf, ident);
  for (i = 0; invalid[i]; i++)
    if (strstr(buf, invalid[i]))
      return 0;
  return 1;
}

/*
int
is_BM(list)
  char *list;                    ODGBM list
{
  register int ch, len;

  ch = list[0];
  if ((ch > ' ') && (ch < 128))
  {
    len = strlen(cuser.userid);
    do
    {
      if (!ci_strncmp(list, cuser.userid, len))
      {
        ch = list[len];
        if ((ch == 0) || (ch == '/') || (ch == ']'))
          return 1;
      }
      while (ch = *list++)
      {
        if (ch == '/')
          break;
      }
    } while (ch);
  }
  return 0;
}
*/

/* ----------------------------------------------------- */
/* ɮˬdơGɮסBؿBݩ                        */
/* ----------------------------------------------------- */


int
dashf(fname)
  char *fname;
{
  struct stat st;

  return (stat(fname, &st) == 0 && S_ISREG(st.st_mode));
}


int
dashd(fname)
  char *fname;
{
  struct stat st;

  return (stat(fname, &st) == 0 && S_ISDIR(st.st_mode));
}

/*
int
belong(filelist, key)
  char *filelist;
  char *key;
{
  FILE *fp;
  int rc = 0;

  if (fp = fopen(filelist, "r"))
  {
    char buf[STRLEN], *ptr;

    while (fgets(buf, STRLEN, fp))
    {
      if ((ptr = strtok(buf, str_space)) && !strcasecmp(ptr, key))
      {
        rc = 1;
        break;
      }
    }
    fclose(fp);
  }
  return rc;
}
*/

char *
Cdate(clock)
  time_t *clock;
{
  static char foo[22];
  struct tm *mytm = localtime(clock);

  strftime(foo, 22, "%D %T %a", mytm);
  return (foo);
}


#ifdef  HAVE_CTIME
char *
Ctime(clock)
  time_t *clock;
{
  char *foo;
  char *ptr = ctime(clock);

  if (foo = strrchr(ptr, '\n'))
    *foo = '\0';
  return (ptr);
}
#endif


void
pressanykey()
{
  int ch;

  outmsg("[37;45;1m                         Ы [33m(Space/Return)[37m ~                        [0m");
  do
  {
    ch = igetkey();
  } while ((ch != ' ') && (ch != KEY_LEFT) && (ch != '\r') && (ch != '\n'));
  move(b_lines, 0);
  clrtoeol();
  refresh();
}

/*
void
bell()
{
  fputc(Ctrl('G'), stderr);
}
*/

int
search_num(ch, max)
{
  int clen = 1;
  int x, y;
  extern unsigned char scr_cols;

  outmsg("[7m ܲĴXG[0m");
  outc(ch);
  genbuf[0] = ch;
  getyx(&y, &x);
  x--;
  while ((ch = igetch()) != '\r')
  {
    if (ch == 'q' || ch == 'e')
      return -1;
    if (ch == '\n')
      break;
    if (ch == '\177' || ch == Ctrl('H'))
    {
      if (clen == 0)
      {
        bell();
        continue;
      }
      clen--;
      move(y, x + clen);
      outc(' ');
      move(y, x + clen);
      continue;
    }
    if (!isdigit(ch))
    {
      bell();
      continue;
    }
    if (x + clen >= scr_cols || clen >= 6)
    {
      bell();
      continue;
    }
    genbuf[clen++] = ch;
    outc(ch);
  }
  genbuf[clen] = '\0';
  move(b_lines, 0);
  clrtoeol();
  if (genbuf[0] == '\0')
    return -1;
  clen = atoi(genbuf);
  if (clen == 0)
    return 0;
  if (clen > max)
    return max;
  return clen - 1;
}


void
stand_title(title)
  char *title;
{
  clear();
  prints("[1;37;46mi %s j[0m\n", title);
}


/* opus : cursor position */

void
cursor_show(row, column)
  int row, column;
{
  move(row, column);
  outs(STR_CURSOR);
  move(row, column + 1);
}


void
cursor_clear(row, column)
  int row, column;
{
  move(row, column);
  outs(STR_UNCUR);
}

/*
int
cursor_key(row, column)
  int row, column;
{
  int ch;

  cursor_show(row, column);
  ch = egetch();
  move(row, column);
  outs(STR_UNCUR);
  return ch;
}
*/

void
printdash(mesg)
  char *mesg;
{
  int head = 0, tail;

  if (mesg)
    head = (strlen(mesg) + 1) >> 1;

  tail = head;

  while (head++ < 38)
    outch('-');

  if (tail)
  {
    outch(' ');
    outs(mesg);
    outch(' ');
  }

  while (tail++ < 38)
    outch('-');
  outch('\n');
}

more(char* fpath, int i)
{
   FILE* fp;
   char buf[100];

   clear();
   if (fp = fopen(fpath, "r")) {
      for (i = 0; i < 20 && fgets(buf, 100, fp); i++)
         outs(buf);
      fclose(fp);
   }
}

setuserfile(char* fpath, char* fname)
{
   char* getenv();
   char* dir = getenv("HOME");

   dir = dir ? dir : "/tmp";
   sprintf(fpath,  "%s/.ve_%s", dir, fname);
}
