# Public Domain CC0
%define _pkg_name viking

Name:       mingw64-%{_pkg_name}
Version:    1.11
Release:    1
Summary:    GPS data editor and analyzer
Group:      Applications/Productivity
License:    GPL-2.0-or-later
URL:        https://sourceforge.net/projects/viking/
Source0:    %{_pkg_name}-%{version}.tar.gz

# 64bit version only in this file. See mingw32-viking.spec for the 32bit version

# Programs to enable the cross build
BuildRequires:  mingw64-cross-gcc
BuildRequires:  mingw64-gettext-tools
BuildRequires:  intltool
BuildRequires:  libxslt-tools
BuildRequires:  glib2-devel
#^ For glib-compile-resources
BuildRequires:  vim
#^ Contains xxd command

# Code
# Not worried about versions ATM - latest is 3.22 which is what we need
BuildRequires:  mingw64-gtk3-devel
# ATM gtk3-devel auto includes at least devel versions of glib2, gobject, zlib and more

# Mandatory libraries
BuildRequires:  mingw64-json-glib-devel
BuildRequires:  mingw64-libexpat-devel
BuildRequires:  mingw64-libcurl-devel
# Optional libraries
BuildRequires:  mingw64-libgexiv2-devel
BuildRequires:  mingw64-libbz2-devel
BuildRequires:  mingw64-file-devel
BuildRequires:  mingw64-sqlite-devel
BuildRequires:  mingw64-libzip-devel
BuildRequires:  mingw64-libnettle-devel
BuildRequires:  mingw64-libgps-devel
BuildRequires:  mingw64-liboauth-devel
BuildRequires:  mingw64-libnova-devel
BuildRequires:  mingw64-xz-devel

# Libs for runtime (and thus also available for the NSIS installer to include the dependencies)
# Should be auto detected
#Requires:       mingw64-gtk3
# mingw64-libcurl4, mingw64-libgexiv2, etc...
# Currently running makensis in seperate script - so you will need it then
# NB No 64bit version available
#Requires:  mingw32-cross-nsis
# GTK3 theming
Requires:       adwaita-icon-theme

%_mingw64_package_header_debug
BuildArch:      noarch

%description
Viking is a free/open source program to manage GPS data.
You can import, plot and create tracks, routes and waypoints, show OSM and other maps, see real-time GPS position, control items, etc.
Other advanced capabilities include Geotagging Images, generate Maps (using Mapnik), Upload and Download tracks from OSM, Routing from OSRM, Name Searches from OSM Nominatim or Geonames and more.
It is written in mainly in C with some C++ and uses the GTK+3 toolkit.

%_mingw64_debug_package

%prep
%setup -q -n %{_pkg_name}-%{version}

%build
# Create Icon
pushd windows/installer/pixmaps
%{_mingw64_windres} viking_icon.rc -o viking_icon.o
popd

#
# Specifics for Windows build - i.e. no Mapnik yet
%{_mingw64_configure}\
  --disable-mapnik \
  --disable-geoclue \
  --enable-windows \
  CFLAGS="-DWINDOWS -DWIN32 -mwindows -DCURL_NO_SSL_VERIFYPEER"
# NB not sure if '-DWIN32' is necessary/applicable for a 64bit build...

%{_mingw64_make} %{?_smp_mflags}
 
%install
pushd src
%{_mingw64_strip} -g %{_pkg_name}.exe
popd

%make_install

%find_lang %{_pkg_name}

%files -f %{_pkg_name}.lang
%defattr(-,root,root)
%doc AUTHORS ChangeLog COPYING NEWS README.md doc/examples/*xml
%{_mingw64_bindir}/*%{_pkg_name}.exe
%{_mingw64_datadir}/%{_pkg_name}
%dir %{_mingw64_datadir}/applications
%{_mingw64_datadir}/applications/%{_pkg_name}.desktop
%dir %{_mingw64_datadir}/icons
%dir %{_mingw64_datadir}/icons/hicolor
%dir %{_mingw64_datadir}/icons/hicolor/48x48
%dir %{_mingw64_datadir}/icons/hicolor/48x48/apps
%{_mingw64_datadir}/icons/hicolor/48x48/apps/%{_pkg_name}.*
# Not generated anymore
#%%exclude %%{_mingw64_datadir}/icons/hicolor/icon-theme.cache
# Fix broken language detection
%dir %{_mingw64_datadir}/locale/jv
%exclude %{_mingw64_datadir}/locale/jv/LC_MESSAGES
%dir %{_mingw64_datadir}/locale/ku
%exclude %{_mingw64_datadir}/locale/ku/LC_MESSAGES

%changelog
