/*
 * Copyright (c) 2002 pancake <pancake@phreaker.net>
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote
 *    products derived from this software without specific prior written
 *    permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * This file is included in WiStumbler2 package.
 *
 * $Id: guimenu.c,v 1.0 2003/11/15 15:54:29 pancake Exp $
 */

#if USE_GTK
#include "main.h"
#include <gtk/gtk.h>
#include "guimenu.h"
#include "speaker.h"
extern void wistumbler_gui_viewlogs();

static GtkItemFactoryEntry menu_items[] =
{
	{
	"/_File",
		NULL,
		NULL,
		0,
		"<Branch>" },{
	"/File/_Save",
		"<control>S",
		(gpointer)print_clist,
		1,
		"<StockItem>",
		GTK_STOCK_SAVE },{
	"/File/_Toggle beeps",
		"<control>B",
		(gpointer)swap_beep,
		0,
		"<ToggleItem>",
		GTK_STOCK_SAVE },{
	"/File/_sep1",
		NULL, NULL,
		0,"<Separator>" },{
	"/File/_Quit",
		"<control>Q",     (gpointer)wi_exit,
		0, "<StockItem>", GTK_STOCK_QUIT },{
	"/_Edit",
		NULL, NULL,
		0,"<Branch>" },{
	"/Edit/_View_logs",
		"<control>L",     (gpointer)wistumbler_gui_viewlogs,
		0, "<StockItem>", GTK_STOCK_FIND },{
	"/Edit/_Preferences",
		NULL,             (gpointer)wistumbler_gui_config/*func*/,
		0, "<StockItem>", GTK_STOCK_PREFERENCES },{
	"/_Help",
		NULL,             NULL,
		0, "<LastBranch>" },{
	"/_Help/About",
		"<control>H",     (gpointer)wistumbler_gui_about,
		0, "<StockItem>", GTK_STOCK_HELP }
};
static gint nmenu_items = sizeof(menu_items)/sizeof(menu_items[0]);

void wistumbler_gui_menu(win,box)
	GtkWidget *win;
	GtkWidget *box;
{
	GtkAccelGroup *accel;
	GtkItemFactory *itemfact;

	/* Accelerated menus ;) (keyboard bindings) */
	accel=gtk_accel_group_new();
	itemfact=gtk_item_factory_new(GTK_TYPE_MENU_BAR,"<main>",accel);
	gtk_item_factory_create_items(itemfact,nmenu_items,menu_items,NULL);
	gtk_window_add_accel_group(GTK_WINDOW(win), accel);
	//gtk_accel_group_attach(parent);
	gtk_box_pack_start(GTK_BOX(box),
			gtk_item_factory_get_widget(itemfact,"<main>"),
			FALSE,FALSE,0);
}
#endif
