#include <stdlib.h>
#include <stdio.h>
#include <time.h>
#include <string.h>
#include <fcntl.h>
#include <unistd.h>
#include <ctype.h>
#include <pwd.h>
#include <signal.h>
#include <errno.h>
 
#include <sys/wait.h>
#include <sys/stat.h>
#include <sys/param.h>
#include <sys/types.h>
#include <sys/ioctl.h>
#include <sys/file.h>

#include <utmp.h>
#include <dirent.h>

#include <X11/Xlib.h>
#include <X11/xpm.h>
#include <X11/extensions/shape.h>

#include "../wmgeneral/wmgeneral.h"
#include "../wmgeneral/misc.h"

#include "wmfstatus-master.xpm"
char wmfstatus_mask_bits[64*64];
int  wmfstatus_mask_width = 64;
int  wmfstatus_mask_height = 64;

#define WMFSTATUS_VERSION "0.4"

#define CHAR_WIDTH 5
#define CHAR_HEIGHT 7
#define MOD_POL 0
#define MOD_SIG 1
#define DEFAULT_INPUT "/.wmfstatusrc"
#define PID_EXT ".pid"
extern	char **environ;

char	*ProgName;

char Actions[256][256];

char Strings[256][7];
unsigned int Nums[256];
int  mode;
int lines;
char uconfig_file[256];
char uconfig_pid_file[256];

void usage(void);
void printversion(void);
void BlitString(char *name, int x, int y, int h);
void BlitNum(int num, int x, int y, int h);
void GetStats( void );
void wmfstatus_routine(int, char **);
void SigUsr1(int);
int write_pid(char *);
void CheckInputFile(void);

int main(int argc, char *argv[]) {

	int		i;
	struct passwd	*pwd;
	struct sigaction sa;

	if ((pwd = getpwuid(getuid())) == NULL){
		fprintf(stderr, "Can't locate homedir for UID %d\n", getuid());
		exit(-1);
	}
	strcpy(uconfig_file, pwd->pw_dir);
	strncat(uconfig_file, DEFAULT_INPUT, sizeof(uconfig_file));

	/* Parse Command Line */
	mode = MOD_POL;
	ProgName = argv[0];
	if (strlen(ProgName) >= 5)
		ProgName += (strlen(ProgName) - 5);
	
	for (i=1; i<argc; i++) {
		char *arg = argv[i];

		if (*arg=='-') {
			switch (arg[1]) {
			case 'd' :
				if (strcmp(arg+1, "display")) {
					usage();
					exit(1);
				}
				break;
			case 'g' :
				if (strcmp(arg+1, "geometry")) {
					usage();
					exit(1);
				}
				break;
			case 'v' :
				printversion();
				exit(0);
				break;
	                case 'c' :
		                if (argc > (i+1))
                		{
		                    strcpy(uconfig_file, argv[i+1]);
                		    i++;
		                }
		                break;
			case 'p' :
				mode = MOD_SIG;
				memset(&sa, 0, sizeof(sa));
				sa.sa_handler = SigUsr1;
				if (sigaction(SIGUSR1, &sa, NULL))
					perror("sigaction");
				strncpy(uconfig_pid_file, uconfig_file,
					sizeof(uconfig_pid_file));
				strncat(uconfig_pid_file, PID_EXT, 
					sizeof(uconfig_pid_file));
				write_pid(uconfig_pid_file);
				fprintf(stderr, "Non polling mode enabled. Updating screen on SIGUSR1 signal.\n");
				break;
            default:
				usage();
				exit(0);
				break;
			}
		}
	}

	fprintf(stderr, "Trying [%s] as an input file.", uconfig_file);
	CheckInputFile();
	wmfstatus_routine(argc, argv);

	return 0;
}

void SigUsr1(int signum) {
       GetStats();
}

/*******************************************************************************\
|* wmfstatus_routine														   *|
\*******************************************************************************/

void wmfstatus_routine(int argc, char **argv)
{
    int			i;
	XEvent		Event;
	int			but_stat = -1;
	int 		j, k, l;

    time_t		curtime;
	time_t		prevtime;

    for (i=1;i<6;i++) Actions[i][0]=0;
    
    createXBMfromXPM(wmfstatus_mask_bits, wmfstatus_master_xpm, wmfstatus_mask_width, wmfstatus_mask_height);
    
    openXwindow(argc, argv, wmfstatus_master_xpm, wmfstatus_mask_bits, wmfstatus_mask_width, wmfstatus_mask_height);

    AddMouseRegion(0, 5, 6, 58, 16);
    AddMouseRegion(1, 5, 16, 58, 26);
    AddMouseRegion(2, 5, 26, 58, 36);
    AddMouseRegion(3, 5, 36, 58, 46);
    AddMouseRegion(4, 5, 46, 58, 56);

    RedrawWindow();

    prevtime = time(0) - 1;

    GetStats(); // Run for the first time anyway
    
    j = 11; k = 0; l = 11;
    while (1)
    {
		curtime = time(0);
		waitpid(0, NULL, WNOHANG);

        
        if ( curtime >= prevtime + 1)
        {
            // Get data to display
	    if (mode == MOD_POL) 
            	    GetStats();
            prevtime = curtime;
        }
        for (i=0; i<5; i++) {
	  copyXPMArea(5, 84, 54, 11, 5, (11*(i-1)) + 5 + j);
          if (lines != 0) {
	    BlitString(Strings[((i+k)%lines)+1], 5, (11*(i-1)) + 5 + j, 8);
            BlitNum(Nums[((i+k)%lines)+1], 45, (11*(i-1)) + 5 + j, 8);
          }
        }
            
        copyXPMArea(5, 84, 54, 11-j, 5, (11*(i-1)) + 5 + j);
        if (j < 8) {
	  if (lines != 0) {
	    BlitString(Strings[((i+k)%lines)+1], 5, (11*(i-1)) + 5 + j, 8-j);
            BlitNum(Nums[((i+k)%lines)+1], 45, (11*(i-1)) + 5 + j, 8-j);
          }
        }
        if (lines > 5) {
          if (l-- >= 0) {
            j--;
          }
        if (l < -15)
          l = 11;
        } else {
          k = 0; j = 11;
        }
        if (j < 0) {
          j = 11;
          k++;
        }
        if (k >= lines) {
          k = 0;
        }
        RedrawWindow();
        
        // X Events
        while (XPending(display))
        {
			XNextEvent(display, &Event);
            switch (Event.type)
            {
			case Expose:
				RedrawWindow();
				break;
			case DestroyNotify:
				XCloseDisplay(display);
				exit(0);
                break;
			case ButtonPress:
				i = CheckMouseRegion(Event.xbutton.x, Event.xbutton.y);

				but_stat = i;
				break;
			case ButtonRelease:
				i = CheckMouseRegion(Event.xbutton.x, Event.xbutton.y);

                if (but_stat == i && but_stat >= 0)
                {
			execCommand(Actions[((i+k)%lines)+1]);
				}
				but_stat = -1;
//				RedrawWindow();
				break;
			}
		}

		usleep(80000L);
	}
}


void GetStats( void )
{
	FILE *fp;
	fp = fopen(uconfig_file, "r");
        if (fp) {
		lines = 1;
		while ((fscanf(fp, "%s\t%d\t%[^\n]\n", Strings[lines],
			&Nums[lines], Actions[lines]) != EOF) || (lines < 6)) {
			lines ++;
		}
		fclose(fp);
		lines--;
		return;
	} else {
		perror("Read_Config_File");
		fprintf(stderr, "Unable to open %s, no settings read.\n",
				uconfig_file);
		return;
	}
}

// Blits a string at given co-ordinates
void BlitString(char *name, int x, int y, int h)
{
    int		i;
	int		c;
    int		k;

	k = x;
    for (i=0; name[i]; i++)
    {

        c = toupper(name[i]); 
        if (c >= 'A' && c <= 'Z')
        {   // its a letter
			c -= 'A';
			copyXPMArea(c * 6, 74, 6, h, k, y);
			k += 6;
        }
        else
        {   // its a number or symbol
			c -= '0';
			copyXPMArea(c * 6, 64, 6, h, k, y);
			k += 6;
		}
	}

}


// Blits number to give coordinates.. two 0's, right justified

void BlitNum(int num, int x, int y, int h)
{
    char buf[1024];
    int newx=x;

    if (num > 99)
    {
        newx -= CHAR_WIDTH;
    }

    if (num > 999)
    {
        newx -= CHAR_WIDTH;
    }

    sprintf(buf, "%02i", num);

    BlitString(buf, newx, y, h);
}

/*******************************************************************************\
|* usage																	   *|
\*******************************************************************************/

void usage(void)
{
    fprintf(stderr, "\nWMFstatus by FINiK <finik@sporu.net>\n\n");
	fprintf(stderr, "usage:\n");
	fprintf(stderr, "    -display <display name>\n");
	fprintf(stderr, "    -geometry +XPOS+YPOS      initial window position\n");
	fprintf(stderr, "    -c <filename>             use specified config file\n");
	fprintf(stderr, "    -h                        this help screen\n");
	fprintf(stderr, "    -v                        print the version number\n");
	fprintf(stderr, "    -p                        switch to non polling mode\n");
	fprintf(stderr, "                              info updated upon reciving SIGUSR1\n");
	fprintf(stderr, "\n");
}

/*******************************************************************************\
|* printversion																   *|
\*******************************************************************************/

void printversion(void)
{
	fprintf(stderr, "wmfstatus v%s\n", WMFSTATUS_VERSION);
}

int write_pid (char *pidfile) {
  FILE *f;
  int fd;
  int pid;

  if (((fd = open(pidfile, O_RDWR|O_CREAT, 0644)) == -1)
       || ((f = fdopen(fd, "r+")) == NULL) ) {
      fprintf(stderr, "Can't open or create %s.\n", pidfile);
      return 0;
  }

  if (flock(fd, LOCK_EX|LOCK_NB) == -1) {
      fscanf(f, "%d", &pid);
      fclose(f);
      printf("Can't lock, lock is held by pid %d.\n", pid);
      return 0;
  }

  pid = getpid();
  if (!fprintf(f,"%d\n", pid)) {
      printf("Can't write pid , %s.\n", strerror(errno));
      close(fd);
      return 0;
  }
  fflush(f);

  if (flock(fd, LOCK_UN) == -1) {
      printf("Can't unlock pidfile %s, %s.\n", pidfile, strerror(errno));
      close(fd);
      return 0;
  }
  close(fd);

  return pid;
}

void CheckInputFile(void){
  FILE *fp;

  if ((fp = fopen(uconfig_file, "r")) != NULL){
    fprintf(stderr, "..it exists!\n");
    fclose(fp);
    return;
  }
  else{
    // Try to create empty file
    fprintf(stderr, "..doesn't exist.\nCreating empty..");
    if ((fp = fopen(uconfig_file, "w")) == NULL){
      fprintf(stderr, ".can't create [%s].\n", uconfig_file);
      exit(-1);
    }
    if (!fprintf(fp,"THIS\t1\tls\nIS\t2\tls\nEMPTY\t3\tls\nINPUT\t4\tls\nFILE\t5\tls\n")) {
      fprintf(stderr, ".can't write to empty file: %s.\n", strerror(errno));
      fclose(fp);
      exit(-1);
    }
    fprintf(stderr, "..done!\n");
    fflush(fp);
    fclose(fp);
    
    
  }

  
}
