/* fontreq.h
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2001-2006 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: fontreq.h,v 1.9 2005/08/17 06:29:45 ralf Exp $ */

#ifndef FONTREQ_H
#define FONTREQ_H

#include "wdefines.h"
#include <aguix/fieldlistview.h>
#include <aguix/text.h>
#include <aguix/acontainer.h>
#include <aguix/stringgadget.h>

#define FONTREQ_MINSIZE 8
#define FONTREQ_STEPSIZE 1
#define FONTREQ_STEPS 40

class FontRequester
{
public:
  FontRequester(class AGUIX *parent);
  ~FontRequester();
  FontRequester( const FontRequester &other );
  FontRequester &operator=( const FontRequester &other );

  int request(const char *xname,char**return_xname);

  struct request_fonts {
    char *name;
    typedef enum { SCALEABLE, FIXED } type_t;
    type_t type;
    char *xname;
    int size;
  };
private:

  class AGUIX *aguix;
  FieldListView *lv,*lv2;
  Text *ftext, *missingtext;
  Button *okb,*cb,*xb;
  AWindow *win;
  List *fontlist;
  AContainer *ac1, *ac1_2;
  StringGadget *example_sg;
  
  void showsizes(int i);
  void updatefont();
  int getsize(int i,int j);
  int findfont(const char *xn,int *return_i, int *return_j);
};

static const struct request_fonts_def {
  const char *name;
  FontRequester::request_fonts::type_t type;
  const char *xname;
  int size; } use_fonts[]={ { "default", FontRequester::request_fonts::FIXED, "fixed", 8},
		            { "9x15", FontRequester::request_fonts::FIXED, "9x15", 9},
		            { "10x20", FontRequester::request_fonts::FIXED, "10x20", 10},
		            { "12x24", FontRequester::request_fonts::FIXED, "12x24", 12},
		            { "fixed", FontRequester::request_fonts::SCALEABLE,
			      "-misc-fixed-medium-r-*-*-%d-*-*-*-*-*-*-*", 0},
		            { "fixed bold", FontRequester::request_fonts::SCALEABLE,
			      "-misc-fixed-bold-*-*-*-%d-*-*-*-*-*-*-*", 0},
                            { "courier", FontRequester::request_fonts::SCALEABLE,
			      "-*-courier-medium-r-*-*-%d-*-*-*-*-*-*-*", 0},
                            { "courier bold", FontRequester::request_fonts::SCALEABLE,
			      "-*-courier-bold-r-*-*-%d-*-*-*-*-*-*-*", 0},
                            { "courier italic", FontRequester::request_fonts::SCALEABLE,
			      "-*-courier-medium-o-*-*-%d-*-*-*-*-*-*-*", 0},
                            { "courier bold italic", FontRequester::request_fonts::SCALEABLE,
			      "-*-courier-bold-o-*-*-%d-*-*-*-*-*-*-*", 0},
			    { "times", FontRequester::request_fonts::SCALEABLE,
			      "-*-times-medium-r-*-*-%d-*-*-*-*-*-*-*", 0},
			    { "times bold", FontRequester::request_fonts::SCALEABLE,
			      "-*-times-bold-r-*-*-%d-*-*-*-*-*-*-*", 0},
			    { "times italic", FontRequester::request_fonts::SCALEABLE,
			      "-*-times-medium-i-*-*-%d-*-*-*-*-*-*-*", 0},
			    { "times bold italic", FontRequester::request_fonts::SCALEABLE,
			      "-*-times-bold-i-*-*-%d-*-*-*-*-*-*-*", 0},
			    { "helvetica", FontRequester::request_fonts::SCALEABLE,
			      "-*-helvetica-medium-r-*-*-%d-*-*-*-*-*-*-*", 0},
			    { "helvetica bold", FontRequester::request_fonts::SCALEABLE,
			      "-*-helvetica-bold-r-*-*-%d-*-*-*-*-*-*-*", 0},
			    { "helvetica italic", FontRequester::request_fonts::SCALEABLE,
			      "-*-helvetica-medium-o-*-*-%d-*-*-*-*-*-*-*", 0},
			    { "helvetica bold italic", FontRequester::request_fonts::SCALEABLE,
			      "-*-helvetica-bold-o-*-*-%d-*-*-*-*-*-*-*", 0},
			    { "any font famliy", FontRequester::request_fonts::SCALEABLE,
			      "-*-*-medium-r-*-*-%d-*-*-*-*-*-*-*", 0},
			    { "generic", FontRequester::request_fonts::SCALEABLE,
			      "-*-*-*-*-*-*-%d-*-*-*-*-*-*-*", 0}
                          };

#endif

