/* nmfilter.cc
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2001-2006 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "nmfilter.hh"
#include "configheader.h"
#include "configparser.tab.h"
#include "wconfig.h"

#include <aguix/lowlevelfunc.h>

NM_Filter::NM_Filter()
{
  pattern=NULL;
  check=0;
}

NM_Filter::~NM_Filter()
{
  if(pattern!=NULL) _freesafe(pattern);
}

void NM_Filter::setPattern(const char *np)
{
  if(pattern!=NULL) _freesafe(pattern);
  if(np!=NULL) {
    pattern=dupstring(np);
  } else {
    pattern=NULL;
  }
}

char *NM_Filter::getPattern()
{
  return pattern;
}

void NM_Filter::setCheck(int nc)
{
  if((nc<0)||(nc>2)) return;
  check=nc;
}

int NM_Filter::getCheck()
{
  return check;
}

int NM_Filter::load()
{
  int found_error = 0;

  setCheck( 0 );
  for (;;) {
    if ( worker_token == PATTERN_WCP ) {
      readtoken();

      if ( worker_token != '=' ) {
        found_error = 1;
        break;
      }      
      readtoken();

      if ( worker_token == STRING_WCP ) {
        if ( pattern != NULL ) _freesafe( pattern );
        pattern = dupstring( yylval.strptr );
      } else {
        found_error = 1;
        break;
      }      
      readtoken();

      if ( worker_token != ';' ) {
        found_error = 1;
        break;
      }
      readtoken();
    } else if ( worker_token == MODE_WCP ) {
      readtoken();

      if ( worker_token != '=' ) {
        found_error = 1;
        break;
      }      
      readtoken();

      if ( worker_token == INCLUDE_WCP ) {
        setCheck( 1 );
      } else if ( worker_token == EXCLUDE_WCP ) {
        setCheck( 2 );
      } else {
        found_error = 1;
        break;
      }      
      readtoken();

      if ( worker_token != ';' ) {
        found_error = 1;
        break;
      }
      readtoken();
    } else {
      break;
    }
  }
  
  return found_error;
}

int NM_Filter::loadBin(Datei *fh)
{
  int chunksize=fh->getInt();
  int len;
  char *str;
  if(chunksize>=(2*Datei::getIntSize())) {
    len=fh->getInt();
    chunksize-=Datei::getIntSize();
    str=fh->getString(len);
    if(pattern!=NULL) _freesafe(pattern);
    pattern=str;
    chunksize-=len;
    check=fh->getInt();
    chunksize-=Datei::getIntSize();
  }
  while(chunksize>0) {
    fh->getUChar();
    chunksize--;
  }
  return 0;
}

int NM_Filter::save(Datei *fh)
{
  if ( fh == NULL ) return 1;

  if ( pattern != NULL ) fh->configPutPairString( "pattern", pattern );  
  switch ( check ) {
    case 1:
      fh->configPutPair( "mode", "include" );
      break;
    case 2:
      fh->configPutPair( "mode", "exclude" );
      break;
    default:
      break;
  }
  return 0;
}

NM_Filter *NM_Filter::duplicate()
{
  NM_Filter *fi=new NM_Filter();
  fi->setCheck(check);
  fi->setPattern(pattern);
  return fi;
}
