/* wconfig_mouse.cc
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2006 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "wconfig_mouse.hh"
#include "wconfig.h"
#include "worker.h"
#include <aguix/acontainerbb.h>

MousePanel::MousePanel( AWindow &basewin, WConfig &baseconfig ) : WConfigPanel( basewin, baseconfig )
{
}

MousePanel::~MousePanel()
{
}

int MousePanel::create()
{
  int res;
  
  res = Panel::create();

  AContainer *ac1 = setContainer( new AContainer( this, 1, 3 ), true );
  ac1->setMinSpace( 5 );
  ac1->setMaxSpace( 5 );

  addMultiLineText( catalog.getLocale( 674 ),
                    *ac1,
                    0, 0,
                    NULL, NULL );

  AContainer *ac1_1 = ac1->add( new AContainer( this, 2, 1 ), 0, 1 );
  ac1_1->setMinSpace( 5 );
  ac1_1->setMaxSpace( 5 );
  ac1_1->setBorderWidth( 0 );

  ac1_1->add( new Text( _aguix, 0, 0, catalog.getLocale( 651 ), 1 ), 0, 0, AContainer::CFIX );

  cycb1 = (CycleButton*)ac1_1->add( new CycleButton( _aguix, 0, 0, 10, 1, 0, 0 ), 1, 0, AContainer::CINCW );
  cycb1->connect( this );

  cycb1->addOption( catalog.getLocale( 652 ) );
  cycb1->addOption( catalog.getLocale( 653 ) );
  cycb1->addOption( catalog.getLocale( 654 ) );
  cycb1->addOption( catalog.getLocale( 655 ) );
  cycb1->resize( cycb1->getMaxSize(), cycb1->getHeight() );
  ac1_1->readLimits();

  if ( _baseconfig.getMouseSelectButton() == 1 &&
       _baseconfig.getMouseActivateButton() == 2 &&
       _baseconfig.getMouseScrollButton() == 3 &&
       _baseconfig.getMouseSelectMethod() == WConfig::MOUSECONF_NORMAL_MODE ) {
    cycb1->setOption( 0 );
  } else if ( _baseconfig.getMouseSelectButton() == 2 &&
       _baseconfig.getMouseActivateButton() == 1 &&
       _baseconfig.getMouseScrollButton() == 3 &&
       _baseconfig.getMouseSelectMethod() == WConfig::MOUSECONF_NORMAL_MODE ) {
    cycb1->setOption( 1 );
  } else if ( _baseconfig.getMouseSelectButton() == 1 &&
       _baseconfig.getMouseActivateButton() == 2 &&
       _baseconfig.getMouseScrollButton() == 3 &&
       _baseconfig.getMouseSelectMethod() == WConfig::MOUSECONF_ALT_MODE ) {
    cycb1->setOption( 2 );
  } else {
    cycb1->setOption( 3 );
  }

  AContainerBB *ac1_2 = static_cast<AContainerBB*>( ac1->add( new AContainerBB( this, 1, 4 ), 0, 2 ) );
  ac1_2->setMinSpace( 0 );
  ac1_2->setMaxSpace( 0 );
  ac1_2->setBorderWidth( 5 );

  AContainer *ac1_2_1 = ac1_2->add( new AContainer( this, 2, 1 ), 0, 0 );
  ac1_2_1->setMinSpace( 5 );
  ac1_2_1->setMaxSpace( 5 );
  ac1_2_1->setBorderWidth( 2 );

  ac1_2_1->add( new Text( _aguix, 0, 0, catalog.getLocale( 656 ), 1 ), 0, 0, AContainer::CFIX );

  cycbsb = (CycleButton*)ac1_2_1->add( new CycleButton( _aguix, 0, 0, 10, 1, 0, 0 ), 1, 0, AContainer::CINCW );
  cycbsb->connect( this );
 
  cycbsb->addOption( catalog.getLocale( 657 ) );
  cycbsb->addOption( catalog.getLocale( 658 ) );
  cycbsb->addOption( catalog.getLocale( 659 ) );
  cycbsb->resize( cycbsb->getMaxSize(), cycbsb->getHeight() );
  ac1_2_1->readLimits();

  switch ( _baseconfig.getMouseSelectButton() ) {
    case 2:
    case 3:
      cycbsb->setOption( _baseconfig.getMouseSelectButton() - 1 );
      break;
    default:
      cycbsb->setOption( 0 );
      break;
  }

  AContainer *ac1_2_2 = ac1_2->add( new AContainer( this, 2, 1 ), 0, 1 );
  ac1_2_2->setMinSpace( 5 );
  ac1_2_2->setMaxSpace( 5 );
  ac1_2_2->setBorderWidth( 2 );

  ac1_2_2->add( new Text( _aguix, 0, 0, catalog.getLocale( 660 ), 1 ), 0, 0, AContainer::CFIX );

  cycbab = (CycleButton*)ac1_2_2->add( new CycleButton( _aguix, 0, 0, 10, 1, 0, 0 ), 1, 0, AContainer::CINCW );
  cycbab->connect( this );
  
  cycbab->addOption( catalog.getLocale( 657 ) );
  cycbab->addOption( catalog.getLocale( 658 ) );
  cycbab->addOption( catalog.getLocale( 659 ) );
  cycbab->resize( cycbab->getMaxSize(), cycbab->getHeight() );
  ac1_2_2->readLimits();

  switch ( _baseconfig.getMouseActivateButton() ) {
    case 2:
    case 3:
      cycbab->setOption( _baseconfig.getMouseActivateButton() - 1 );
      break;
    default:
      cycbab->setOption( 0 );
      break;
  }

  AContainer *ac1_2_3 = ac1_2->add( new AContainer( this, 2, 1 ), 0, 2 );
  ac1_2_3->setMinSpace( 5 );
  ac1_2_3->setMaxSpace( 5 );
  ac1_2_3->setBorderWidth( 2 );

  ac1_2_3->add( new Text( _aguix, 0, 0, catalog.getLocale( 661 ), 1 ), 0, 0, AContainer::CFIX );

  cycbscb = (CycleButton*)ac1_2_3->add( new CycleButton( _aguix, 0, 0, 10, 1, 0, 0 ), 1, 0, AContainer::CINCW );
  cycbscb->connect( this );
  
  cycbscb->addOption( catalog.getLocale( 657 ) );
  cycbscb->addOption( catalog.getLocale( 658 ) );
  cycbscb->addOption( catalog.getLocale( 659 ) );
  cycbscb->resize( cycbscb->getMaxSize(), cycbscb->getHeight() );
  ac1_2_3->readLimits();

  switch ( _baseconfig.getMouseScrollButton() ) {
    case 2:
    case 3:
      cycbscb->setOption( _baseconfig.getMouseScrollButton() - 1 );
      break;
    default:
      cycbscb->setOption( 0 );
      break;
  }

  AContainer *ac1_2_4 = ac1_2->add( new AContainer( this, 2, 1 ), 0, 3 );
  ac1_2_4->setMinSpace( 5 );
  ac1_2_4->setMaxSpace( 5 );
  ac1_2_4->setBorderWidth( 2 );

  ac1_2_4->add( new Text( _aguix, 0, 0, catalog.getLocale( 662 ), 1 ), 0, 0, AContainer::CFIX );

  cycbsmb = (CycleButton*)ac1_2_4->add( new CycleButton( _aguix, 0, 0, 10, 1, 0, 0 ), 1, 0, AContainer::CINCW );
  cycbsmb->connect( this );
  cycbsmb->addOption( catalog.getLocale( 663 ) );
  cycbsmb->addOption( catalog.getLocale( 664 ) );
  cycbsmb->resize( cycbsmb->getMaxSize(), cycbsmb->getHeight() );
  ac1_2_4->readLimits();

  if ( _baseconfig.getMouseSelectMethod() == WConfig::MOUSECONF_ALT_MODE ) {
    cycbsmb->setOption( 1 );
  } else {
    cycbsmb->setOption( 0 );
  }

  contMaximize( true );
  return 0;
}

int MousePanel::saveValues()
{
  _baseconfig.setMouseSelectButton( cycbsb->getSelectedOption() + 1 );
  _baseconfig.setMouseActivateButton( cycbab->getSelectedOption() + 1 );
  _baseconfig.setMouseScrollButton( cycbscb->getSelectedOption() + 1 );
  switch ( cycbsmb->getSelectedOption() ) {
    case 1:
      _baseconfig.setMouseSelectMethod( WConfig::MOUSECONF_ALT_MODE );
      break;
    default:
      _baseconfig.setMouseSelectMethod( WConfig::MOUSECONF_NORMAL_MODE );
      break;
  }
  return 0;
}

void MousePanel::run( Widget *elem, AGMessage &msg )
{
  if ( msg.type == AG_CYCLEBUTTONCLICKED ) {
    if ( msg.cyclebutton.cyclebutton == cycb1 ) {
      switch ( msg.cyclebutton.option ) {
        case 1:
          cycbsb->setOption( 1 );
          cycbab->setOption( 0 );
          cycbscb->setOption( 2 );
          cycbsmb->setOption( 0 );
          break;
        case 2:
          cycbsb->setOption( 0 );
          cycbab->setOption( 1 );
          cycbscb->setOption( 2 );
          cycbsmb->setOption( 1 );
          break;
        case 3:
          break;
        default:
          cycbsb->setOption( 0 );
          cycbab->setOption( 1 );
          cycbscb->setOption( 2 );
          cycbsmb->setOption( 0 );
          break;
      }
    } else if ( msg.cyclebutton.cyclebutton == cycbsb ||
                msg.cyclebutton.cyclebutton == cycbab ||
                msg.cyclebutton.cyclebutton == cycbscb ||
                msg.cyclebutton.cyclebutton == cycbsmb ) {
      cycb1->setOption( 3 );
    }
  }
}
