/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;

public class Main {
    private int msgOutputLevel = 2;
    private File buildFile = new File("build.xml");
    private PrintStream out = System.out;
    private Vector targets = new Vector(5);
    private Properties definedProps = new Properties();
    private Vector listeners = new Vector(5);
    private boolean readyToRun = false;
    static /* synthetic */ Class class$org$apache$tools$ant$Main;

    protected Main(String[] args) throws BuildException {
        int i = 0;
        while (i < args.length) {
            String msg;
            String arg = args[i];
            if (arg.equals("-help") || arg.equals("help")) {
                Main.printUsage();
                return;
            }
            if (arg.equals("-version")) {
                Main.printVersion();
                return;
            }
            if (arg.equals("-quiet") || arg.equals("-q") || arg.equals("q")) {
                this.msgOutputLevel = 1;
            } else if (arg.equals("-verbose") || arg.equals("-v") || arg.equals("v")) {
                this.msgOutputLevel = 3;
            } else if (arg.equals("-logfile") || arg.equals("-l") || arg.equals("l")) {
                try {
                    File logFile = new File(args[i + 1]);
                    ++i;
                    this.out = new PrintStream(new FileOutputStream(logFile));
                    System.setOut(this.out);
                    System.setErr(this.out);
                }
                catch (IOException iOException) {
                    msg = "Cannot write on the specified log file. Make sure the path exists and you have write permissions.";
                    System.out.println(msg);
                    return;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    msg = "You must specify a log file when using the -log argument";
                    System.out.println(msg);
                    return;
                }
            } else if (arg.equals("-buildfile") || arg.equals("-file") || arg.equals("-f") || arg.equals("f")) {
                try {
                    this.buildFile = new File(args[i + 1]);
                    ++i;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    msg = "You must specify a buildfile when using the -buildfile argument";
                    System.out.println(msg);
                    return;
                }
            } else if (arg.equals("-listener")) {
                try {
                    this.listeners.addElement(args[i + 1]);
                    ++i;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    msg = "You must specify a classname when using the -listener argument";
                    System.out.println(msg);
                    return;
                }
            } else if (arg.startsWith("-D")) {
                String name = arg.substring(2, arg.length());
                String value = null;
                int posEq = name.indexOf("=");
                if (posEq > 0) {
                    value = name.substring(posEq + 1);
                    name = name.substring(0, posEq);
                } else if (i < args.length) {
                    value = args[++i];
                }
                ((Hashtable)this.definedProps).put(name, value);
            } else {
                if (arg.startsWith("-")) {
                    msg = "Unknown arg: " + arg;
                    System.out.println(msg);
                    Main.printUsage();
                    return;
                }
                this.targets.addElement(arg);
            }
            ++i;
        }
        if (!this.buildFile.exists()) {
            System.out.println("Buildfile: " + this.buildFile + " does not exist!");
            return;
        }
        if (this.buildFile.isDirectory()) {
            System.out.println("What? Buildfile: " + this.buildFile + " is a dir!");
            return;
        }
        this.readyToRun = true;
    }

    protected void addBuildListeners(Project project) {
        project.addBuildListener(this.createDefaultBuildListener());
        int i = 0;
        while (i < this.listeners.size()) {
            String className = (String)this.listeners.elementAt(i);
            try {
                BuildListener listener = (BuildListener)Class.forName(className).newInstance();
                project.addBuildListener(listener);
            }
            catch (Exception exc) {
                throw new BuildException("Unable to instantiate listener " + className, exc);
            }
            ++i;
        }
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    private BuildListener createDefaultBuildListener() {
        return new DefaultLogger(this.out, this.msgOutputLevel);
    }

    public static void main(String[] args) {
        try {
            new Main(args).runBuild();
            System.exit(0);
        }
        catch (Throwable throwable) {
            System.exit(1);
        }
    }

    private static void printUsage() {
        String lSep = System.getProperty("line.separator");
        StringBuffer msg = new StringBuffer();
        msg.append("ant [options] [target]" + lSep);
        msg.append("Options: " + lSep);
        msg.append("  -help                  print this message" + lSep);
        msg.append("  -version               print the version information and exit" + lSep);
        msg.append("  -quiet                 be extra quiet" + lSep);
        msg.append("  -verbose               be extra verbose" + lSep);
        msg.append("  -logfile <file>        use given file for log" + lSep);
        msg.append("  -listener <classname>  add an instance of class as a project listener" + lSep);
        msg.append("  -buildfile <file>      use given buildfile" + lSep);
        msg.append("  -D<property>=<value>   use value for given property" + lSep);
        System.out.println(msg.toString());
    }

    private static void printVersion() {
        try {
            Properties props = new Properties();
            InputStream in = (class$org$apache$tools$ant$Main != null ? class$org$apache$tools$ant$Main : (class$org$apache$tools$ant$Main = Main.class$("org.apache.tools.ant.Main"))).getResourceAsStream("/org/apache/tools/ant/version.txt");
            props.load(in);
            in.close();
            String lSep = System.getProperty("line.separator");
            StringBuffer msg = new StringBuffer();
            msg.append("Ant version ");
            msg.append(props.getProperty("VERSION"));
            msg.append(" compiled on ");
            msg.append(props.getProperty("DATE"));
            msg.append(lSep);
            System.out.println(msg.toString());
        }
        catch (IOException ioe) {
            System.err.println("Could not load the version information.");
            System.err.println(ioe.getMessage());
        }
        catch (NullPointerException nullPointerException) {
            System.err.println("Could not load the version information.");
        }
    }

    private void runBuild() throws BuildException {
        if (!this.readyToRun) {
            return;
        }
        if (this.msgOutputLevel >= 2) {
            System.out.println("Buildfile: " + this.buildFile);
        }
        Project project = new Project();
        Throwable error = null;
        try {
            try {
                this.addBuildListeners(project);
                project.fireBuildStarted();
                project.init();
                Enumeration e = ((Hashtable)this.definedProps).keys();
                while (e.hasMoreElements()) {
                    String arg = (String)e.nextElement();
                    String value = (String)((Hashtable)this.definedProps).get(arg);
                    project.setUserProperty(arg, value);
                }
                project.setUserProperty("ant.file", this.buildFile.getAbsolutePath());
                try {
                    Class.forName("javax.xml.parsers.SAXParserFactory");
                    ProjectHelper.configureProject(project, this.buildFile);
                }
                catch (NoClassDefFoundError ncdfe) {
                    throw new BuildException("No JAXP compliant XML parser found. See http://java.sun.com/xml for the\nreference implementation.", ncdfe);
                }
                catch (ClassNotFoundException cnfe) {
                    throw new BuildException("No JAXP compliant XML parser found. See http://java.sun.com/xml for the\nreference implementation.", cnfe);
                }
                catch (NullPointerException npe) {
                    throw new BuildException("No JAXP compliant XML parser found. See http://java.sun.com/xml for the\nreference implementation.", npe);
                }
                if (this.targets.size() == 0) {
                    this.targets.addElement(project.getDefaultTarget());
                }
                project.executeTargets(this.targets);
            }
            catch (RuntimeException exc) {
                error = exc;
                throw exc;
            }
            catch (Error err) {
                error = err;
                throw err;
            }
            Object var4_11 = null;
            project.fireBuildFinished(error);
        }
        catch (Throwable throwable) {
            Object var4_12 = null;
            project.fireBuildFinished(error);
            throw throwable;
        }
    }
}

