/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Exec;

public class SignJar
extends Task {
    protected String jar;
    protected String alias;
    protected String keystore;
    protected String storepass;
    protected String storetype;
    protected String keypass;
    protected String sigfile;
    protected String signedjar;
    protected boolean verbose;
    protected boolean internalsf;
    protected boolean sectionsonly;

    public void execute() throws BuildException {
        if (Project.getJavaVersion().equals("1.1")) {
            throw new BuildException("The signjar task is only available on JDK versions 1.2 or greater");
        }
        if (this.jar == null) {
            throw new BuildException("jar attribute must be set");
        }
        if (this.alias == null) {
            throw new BuildException("alias attribute must be set");
        }
        if (this.storepass == null) {
            throw new BuildException("storepass attribute must be set");
        }
        StringBuffer sb = new StringBuffer();
        sb.append("jarsigner ");
        if (this.keystore != null) {
            sb.append("-keystore \"");
            sb.append(this.keystore);
            sb.append("\" ");
        }
        if (this.storepass != null) {
            sb.append("-storepass \"");
            sb.append(this.storepass);
            sb.append("\" ");
        }
        if (this.storetype != null) {
            sb.append("-storetype \"");
            sb.append(this.storetype);
            sb.append("\" ");
        }
        if (this.keypass != null) {
            sb.append("-keypass \"");
            sb.append(this.keypass);
            sb.append("\" ");
        }
        if (this.sigfile != null) {
            sb.append("-sigfile \"");
            sb.append(this.sigfile);
            sb.append("\" ");
        }
        if (this.signedjar != null) {
            sb.append("-signedjar \"");
            sb.append(this.signedjar);
            sb.append("\" ");
        }
        if (this.verbose) {
            sb.append("-verbose ");
        }
        if (this.internalsf) {
            sb.append("-internalsf ");
        }
        if (this.sectionsonly) {
            sb.append("-sectionsonly ");
        }
        sb.append('\"');
        sb.append(this.jar);
        sb.append("\" ");
        sb.append('\"');
        sb.append(this.alias);
        sb.append("\" ");
        this.log("Signing Jar : " + new File(this.jar).getAbsolutePath());
        Exec cmd = (Exec)this.project.createTask("exec");
        cmd.setCommand(sb.toString());
        cmd.setFailonerror("true");
        cmd.setTaskName(this.getTaskName());
        cmd.execute();
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public void setInternalsf(String internalsf) {
        this.internalsf = Project.toBoolean(internalsf);
    }

    public void setJar(String jar) {
        this.jar = jar;
    }

    public void setKeypass(String keypass) {
        this.keypass = keypass;
    }

    public void setKeystore(String keystore) {
        this.keystore = keystore;
    }

    public void setSectionsonly(String sectionsonly) {
        this.sectionsonly = Project.toBoolean(sectionsonly);
    }

    public void setSigfile(String sigfile) {
        this.sigfile = sigfile;
    }

    public void setSignedjar(String signedjar) {
        this.signedjar = signedjar;
    }

    public void setStorepass(String storepass) {
        this.storepass = storepass;
    }

    public void setStoretype(String storetype) {
        this.storetype = storetype;
    }

    public void setVerbose(String verbose) {
        this.verbose = Project.toBoolean(verbose);
    }
}

