// -*- c++ -*-

/*
 *  Author: Arvin Schnell
 */


#ifndef Scope_h
#define Scope_h


#include <X11/Xlib.h>
#ifdef DBE
#  include <X11/extensions/Xdbe.h>
#endif
#include <Xm/Xm.h>


#include "Trans.h"


class Scope
{

public:

    Scope ();

    bool realize (Display*, Window);
    bool destroy ();
    bool isrealized () const { return realized; }

    void resize (bool);

    bool shot (const int32_t*, bool);

    void draw (XRectangle rect);

    void clear (bool);

    void set_zoom (double);

private:

    Display* display;
    Window window;

    double zoom;
    bool draw_cross;
    int num_count;

    enum {
#ifdef DBE
	DOUBLEBUFFER,
#endif
	SINGLEBIT,
	FULLBIT
    } drawing_mode;

    bool realized;

    unsigned int width, height;

    Pixmap pixmap;

#ifdef DBE
    XdbeBackBuffer dbeBuffer;
#endif

    GC windowGC, pixmapGC, dbeGC;

    void allocbuffer ();
    void freebuffer ();
    void clearbuffer ();

    Trans2D <double, short> K;

    XPoint* xpts;

};


#endif
