#include <stdio.h>
#include <math.h>
#include <string.h>
#include <stdlib.h>
#include "forms.h"
#include "xchiplogo.h"
#include "help.h"
 
#define ARRAY_SIZE 1024
/* If you get the segmentation error change this value to smaller sizes */
 




void chiplogo(void);
void display_bitmap(void);
void help_text(void);
void find_error(int *array[],int *error[],int x,int y,int width,int space);

FD_xchiplogo *fdui;
FD_help *fdui_help;
FD_about_form *fdui_about;

FL_FORM *bitmap_form;
int min_width=2,min_space=2,thresh_before=4,thresh_after=4,scale_factor=1;
int cif_choice=0,magic_choice=1,cif_lambda=50,error_correct=0;
int smooth_before=0,smooth_after=0;
int *image_out[ARRAY_SIZE];
int ARRAY_XSIZE=1,ARRAY_YSIZE=1;
const char *input_file,*output_file,*cif_layer,*magic_layer,*magic_tech;
int display_bitmap_counter=0;

static Display *bitmap_display;
GC gc;
Window win;
FL_Coord Bitmap_X,Bitmap_Y;


main(int argc, char *argv[])
{
  FL_OBJECT *obj;
  FILE *fpout;
  int i=0;

  cif_layer="CPG";
  magic_layer="poly";
  magic_tech="scmos";
  output_file="logo.mag";
  

  /* initialize the image_out pointer */
  for(i=0;i<ARRAY_SIZE;i++){
    image_out[i]=(int *)malloc(ARRAY_SIZE*sizeof(int));
    if(image_out[i]==NULL){
      printf("there is not enough memory\n");
      exit(0);
    }
  }
  
  bitmap_display=fl_initialize(&argc, argv, "Form", 0, 0);
  fdui=create_form_xchiplogo();
  fdui_help=create_form_help();
  fdui_about=create_form_about_form();

  /*****************************************************
    Set the default values 
    *****************************************************/

  fl_set_goodies_font(4,FL_MEDIUM_SIZE);
  fl_set_button(fdui->magic_choice,1);
  fl_set_button(fdui->error_no,1);
  fl_set_button(fdui->smooth_before,0);
  fl_set_button(fdui->smooth_after,0);
  
  fl_set_input(fdui->cif_layer,"CPG");
  fl_set_input(fdui->cif_lambda,"50");
  fl_set_input(fdui->magic_layer,"poly");
  fl_set_input(fdui->magic_tech,"scmos");
  fl_set_input(fdui->scale_factor,"1");
  fl_set_input(fdui->min_width,"2");
  fl_set_input(fdui->min_space,"2");

  fl_set_slider_value(fdui->thresh_before,4);
  fl_set_slider_bounds(fdui->thresh_before,16,1);
  fl_set_slider_step(fdui->thresh_before,1);
  fl_set_slider_precision(fdui->thresh_before,0);
  fl_set_slider_value(fdui->thresh_after,4);
  fl_set_slider_bounds(fdui->thresh_after,16,1);
  fl_set_slider_step(fdui->thresh_after,1);
  fl_set_slider_precision(fdui->thresh_after,0);

  help_text();

  fl_hide_object(fdui->error_parameters);

  fl_show_form(fdui->xchiplogo,FL_PLACE_FREE,FL_FULLBORDER,"Xchiplogo");
  /*****************************************************
    Now the main loop 
    *****************************************************/

  while (obj!=fdui->quit) {
    obj=fl_do_forms();
    min_width=atoi(fl_get_input(fdui->min_width));
    min_space=atoi(fl_get_input(fdui->min_space));
    thresh_before=fl_get_slider_value(fdui->thresh_before);
    thresh_after=fl_get_slider_value(fdui->thresh_after);
    scale_factor=atoi(fl_get_input(fdui->scale_factor));

    cif_layer=(char *)fl_get_input(fdui->cif_layer);
    cif_lambda=atoi(fl_get_input(fdui->cif_lambda));
    magic_layer=(char *)fl_get_input(fdui->magic_layer);

    if(obj==fdui->error_no){
      fl_hide_object(fdui->error_parameters);
      fl_redraw_form(fdui->xchiplogo);
      error_correct=0;
    }
    if(obj==fdui->error_yes){
      fl_show_object(fdui->error_parameters);
      error_correct=1;
    }

    if(obj==fdui->infile_browse){
      input_file=(char *)fl_show_fselector("Input PBM file selector", "", "*.pbm","");
      if(input_file != NULL){
	fl_set_input(fdui->input_file,input_file);
      }
    }
    if((obj==fdui->outfile_browse) && fl_get_button(fdui->magic_choice)){
      output_file=(char *)fl_show_fselector("Output file selector", "", "*.mag","");
      if(output_file != NULL){
	fl_set_input(fdui->output_file,output_file);
      }
    }
    if((obj==fdui->outfile_browse) && fl_get_button(fdui->cif_choice)) {
      output_file=(char *) fl_show_fselector("Output file selector","", "*.cif","");
      if(output_file != NULL){
	fl_set_input(fdui->output_file,output_file);
      }
    }

    if(obj==fdui->input_file || obj==fdui->OK){
      input_file=(char *)fl_get_input(fdui->input_file);
    }
    if(obj==fdui->output_file || obj==fdui->OK){
      output_file=(char *)fl_get_input(fdui->output_file);
      if((fpout=fopen(output_file,"w")) == NULL) {
	if(magic_choice==1){
	  fl_show_message("cannot open the output file","using the default name","logo.mag");
	  output_file="logo.mag";
	}
	if(cif_choice==1){
	  fl_show_message("cannot open the output file","using the default name","logo.cif");
	  output_file="logo.cif";
	}
      }
      else fclose(fpout);
      fl_set_input(fdui->output_file,output_file);
    }

    smooth_before=fl_get_button(fdui->smooth_before)&fl_get_button(fdui->error_yes);
    smooth_after=fl_get_button(fdui->smooth_after)&fl_get_button(fdui->error_yes);

    if(obj==fdui->about)fl_show_form(fdui_about->about_form,FL_PLACE_FREE,FL_FULLBORDER,"About Xchiplogo");
    if(obj==fdui_about->quit_about)fl_hide_form(fdui_about->about_form);


    if(obj==fdui->xv_run)system("xv &");
    if(obj==fdui->help)fl_show_form(fdui_help->help,FL_PLACE_FREE,FL_FULLBORDER,"Xchiplogo Help");
    if(obj==fdui_help->end_help)fl_hide_form(fdui_help->help);
    if(obj==fdui->OK){
      chiplogo();
      display_bitmap_counter++;
      display_bitmap();
    }
 
    cif_choice=fl_get_button(fdui->cif_choice);
    cif_layer=fl_get_input(fdui->cif_layer);
    magic_choice=fl_get_button(fdui->magic_choice);
    magic_tech=fl_get_input(fdui->magic_tech);
    magic_layer=fl_get_input(fdui->magic_layer);
    /* 
       printf("W %d,S %d,Sc %d, CIF %s, Mag %s, Mt %s\n",min_width,min_space,scale_factor,cif_layer,magic_layer,magic_tech);
       printf("IF %s   OF %s\n",input_file,output_file);
       */

  }
  fl_hide_form(fdui->xchiplogo);
	
  for(i=0;i<ARRAY_SIZE;i++){
    free(image_out[i]);
  }
  exit(0);
  
}


/********************************************
*********************************************/
void help_text(void)
{
 fl_set_browser_fontsize(fdui_help->help_browse,FL_MEDIUM_SIZE);
 fl_set_browser_fontstyle(fdui_help->help_browse,4);
 fl_addto_browser(fdui_help->help_browse,
"    
XCHIPLOGO 

     Xchiplogo is an X interface for chiplogo. 

FOR THOSE WHO DO NOT WANT TO WAIT ANY MORE

     1- open the input file (which should be in the PBM    ascii, 
     B&W format).   You can  use the input file browser.  If  you
     do not have any input file you can 'Launch XV' to grab some-
     thing from the screen and then save it into a file. Remember
     that after you generate the input file using XV, you  should
     load it in.
     
     2- Press the 'Generate Output'. If you do not have any spec-
     ific name for the outpu file in mind,     xchiplogo will use 
     'logo.mag' or 'logo.cif' instead.
     
     3- Your file is ready. You can have a look at it using  your
     favorite layout editor.
     
     4- If you want to partially correct some of the design  rule
     errors, use the options in the 'Partial Error Correction' to
     reduce the number of  errors.  Note that every time that you 
     change   the parameters,   the 'Generate Output'  should  be 
     pressed to generate the  new layout.

AND THE REST OF THE STORY

     Xchiplogo reads an ascii bitmap file, and converts it into a  
     magic  or cif file. It is a handy program for creating logos 
     of text or graphics for  putting  on  VLSI  chips.   At  the
     moment  it  accepts  the  B&W dithered format of XV as the 
     input. It has got quite a few options for resizing and  get-
     ting rid of many design rule errors that can be found in the
     bitmap file. It has  a smoothing, before and after an  error
     correction  step. The error correction step is pretty simple
     ,don't expect miracles, but it works quite  fine  and  spe- 
     cially for text gives a reasonable output.  

     I wrote this program when I saw my friends sitting for hours
     to  write  their name;  in a font that we call mikhi in per-
     sian 'nail-font'.  I have also seen  many  comercial  layout
     editors  which  have  tried  to implement a simple text-logo
     generation, which all  are very limited and inflexible. So I
     started  Xchiplogo. The input to chiplogo is ascii bitmap.It
     really doesn't matter what program has generated the bitmap,
     as  long as there are two digits at the begining of the file
     which tell the size of the bitmap in pixels,  and  then  the
     sequence of the ones and zeros.
 
     Although the output files may seem a bit  big,  if  you  use
     magic after generating the file, magic reduces the size by a
     factor of more than 10!!!.   It is simply because each black
     pixel  in  the  input file becomes a box in the output magic
     file. Magic merges the boxes  so that they  conform  to  its
     corner   stitch   style.  I  have found magic to be the best
     package for editing the design rule errors of the  generated
     layouts.   With other layout editors you may lose your pati-
     ence.
 
OPTIONS, KEYS, and PARAMETERS

      CIF layer name
        The cif layer that is  to  be  used  for  the  logo.  The
        default is CPG (poly).

      Micron/Lambda
	This parameter tells the scaling factor for a CIF format.
	For a 2 micron technology it is 50 (the default). For a 
	0.8 micron it should be set to 20, and so on.
 
      Magic layer name
        The magic layer name that is to be used for the logo. The
        default is poly.
 
      Technology name
        This option is used with magic option and is  to  specify
        the technology.
 
      Minimum width
        The minimum width of the layer. This value is used in all
        the  error  correction  and  smoothing  operations.   The
        default is 2.
 
      Minimum spacing
        The minimum space of the layer. This value is used in all
        the  error  correction  and  smoothing  operations.   The
        default is 2.
 
      Partial error correction
        This switch toggles the error  detection  and  correction
        stage.  The default is off. When it is turned on the rel-
 	evant parameters will be shown in the window.
 
      Scale factor
        The scaling factor, scales the layout by the this factor.
 
      Threshold before
        This option turns on the smoothing operation before error
        correction  stage.  The  threshold_before  is used as the
        threshold value used  after  the  smoothing.  It  can  be
        between  0 to 16. The smoothing function at the moment is
        a simple triangular function, and acts over a  neighbour-
        hood of minimum_width.
 
      Threshold after
        This option turns on the smoothing operation  before  the
        error  correction  stage.  The threshold_after is used as
        the threshold value used after the smoothing. It  can  be
        between  0 to 16. The smoothing function at the moment is
        a simple triangular function, and acts over a  neighbour-
        hood of minimum_width

      Launch XV (Shortkey CTRL-V)
	This  button  launches the XV  for grabbing  a  piece  of 
	graphics.

      Help  (Shortkey CTRL-H)
	To   bring up this  window.  In this window if  you press 
	the botton on the bottok saying 'OK, Get rid of this window' 
	the window will disappear.
 
     Generate output (CTRL-G)
 	After you have loaded an input file, press this button to 
	generate the layout. If no input file is given, or if the
	specified input does not  exist it will  warn you of this
	problem. But if the output file does not exist, depending
	on the output format selected (magic or cif) it will save
	the layout in a default file 'logo.mag' or 'logo.cif'.
     
     Input File (CTRL-I)
	You   should  specify  the  input file name. You can also 
	browse by  pressing the  browse button next to this input 
	field.
 
     Output File (CTRL-O)
	You should  specify the  output file  name.  You can also 
	browse	by pressing the browse button next to this  input 
	field.

     Quite (CTRL-Q)
        You guess what this one does!!

     About (CTRL-A)
        Just the author info.
 
NOTE
     	The format of the input file  SHOULD be  'PBM (ascii)-B&W 
	Dithered'. With other formats xchiplogo will hang.

AUTHOR
     Alireza Moini, 
     Department of Electrical and Electronics Engineering,
     The University of Adelaide

     moini@eleceng.adelaide.edu.au
     April 1996
");
  
  fl_set_browser_topline(fdui_help->help_browse,1);
}


void display_bitmap(void)
{
  int i,j;
  
  if(display_bitmap_counter==1){
    bitmap_form=fl_bgn_form(FL_NO_BOX,ARRAY_XSIZE,ARRAY_YSIZE);
    fl_end_form();
    fl_set_form_position(bitmap_form,Bitmap_X,Bitmap_Y);
    fl_show_form(bitmap_form,FL_PLACE_GEOMETRY,FL_FULLBORDER,"Xchiplogo Preview");
    gc = fl_state[fl_vmode].gc[0];
    win = fl_winget();
  }
  
  if(display_bitmap_counter>1){
    fl_get_winorigin(win,&Bitmap_X,&Bitmap_Y);
    fl_raise_form(bitmap_form);
    
    /*
      fl_hide_form(bitmap_form);
      printf("db23\n");
      fl_free_form(bitmap_form);
      printf("db24\n");
      */
    fl_set_form_size(bitmap_form,ARRAY_XSIZE,ARRAY_YSIZE);
  }
    
  for(i=0;i<ARRAY_XSIZE;i++){
    for(j=0;j<ARRAY_YSIZE;j++){
      if(image_out[i][j]==0){
	XSetForeground(bitmap_display, gc, fl_get_pixel(FL_WHITE)); 
      }
      else{
	XSetForeground(bitmap_display, gc, fl_get_pixel(FL_BLACK)); 
      }
      
      XDrawPoint(bitmap_display, win, gc, i,j);
    }
  }

 
}

void chiplogo(void )
{
  FILE	*fpin,*fpout;
  char	tmp_c;
  char	*tmp;
  int	width=1,space=1,scale=1,tech=0;
  int	x=0,y=0,base=1,junk=0;
  int   i,j,row,column;
  int   max_col=35;
  int 	max_row;
  int	x_corner,y_corner;
  int 	n=0,start=0,end=0;
  int	threshold_after=4,threshold_before=4;
  int 	*array[ARRAY_SIZE],*array2[ARRAY_SIZE];



  scale=scale_factor;
  width=min_width;
  space=min_space;
  threshold_before=thresh_before;
  threshold_after=thresh_after;

  

  /********************************************
    Now parse the input file name 
    *********************************************/	
  if((fpin=fopen(input_file,"r")) == NULL) {
    printf("cannot open input file\n");
    fl_show_message("cannot open the input file","","");
    return;
  }
  
  
  tmp= (char *)malloc(2048*sizeof(char));
  if(tmp==NULL){
    printf("there is not enough memory\n");
    fclose(fpin);
    return;
    
  }
  
  i=0;
  /* first see if it has the P1 header or not */
  fscanf(fpin,"%2s",tmp);
  if(strcmp(tmp,"P1")){
    printf("This doesn't seem like a pbm file, because it doesn't have the P1 header");
  }
  /* Now skip the next line which is about XV and its version */
  /* but this line should start with # */
  fscanf(fpin,"%s",tmp);
  while(!strncmp(tmp,"#",1)){
    fscanf(fpin,"%*[^\n]");
    getc(fpin);
    fscanf(fpin,"%s",tmp);
  }

  
  ARRAY_XSIZE = x = (int)atoi(tmp);
  fscanf(fpin,"%s",tmp);
  ARRAY_YSIZE = y = (int)atoi(tmp);
  if(ARRAY_YSIZE == 0 ||  ARRAY_XSIZE ==0){
    fclose(fpin);
    free(tmp);
    printf("array has a size of zero\n");
    return;
  }
  for(i=0;i<ARRAY_SIZE;i++){
    array[i]=(int *)malloc((ARRAY_YSIZE+2*width+2)*sizeof(int));
    if(array[i]==NULL){
      printf("there is not enough memory\n");
      exit(0);
    }
    array2[i]=(int *)malloc((ARRAY_YSIZE+2*width+2)*sizeof(int));
    if(array2[i]==NULL){
      printf("there is not enough memory\n");
      exit(0);
    }
  }
  max_row=x*y;
  max_row++;
  max_row=max_row/35;
  max_row++;
  row=0;column=0;
  
  for(i=0;i<(x*(y));i++)
    {
      fscanf(fpin,"%d",&array[i-((i/x)*x)][i/x]);
      /*
	printf("array[%d][%d]=%d\n",i-((i/x)*x),(i/x),array[i-((i/x)*x)][i/x]);
	*/    
    }
  end=1;
 
 
  /***********************************************************************
    Now use some design rule error correction to get rid of the errors
    *********************************************************************/
  enlarge_array(array,x,y,width+2);
  if(smooth_before==1){
    smooth_array(array,x,y,threshold_before,width);
  }
 
  if(error_correct==1){
 
    /* array is the input array and array2 shows the location of errors */
    find_error(array,array2,x,y,width,space);
    for(column=0;column<y;column++){
      for(row=0;row<x;row++){
	array[row][column]=array2[row][column]+array[row][column];
      }
    }
  }
 
  if(smooth_after==1){
    smooth_array(array,x,y,threshold_after,width);
  }

  shrink_array(array,x,y,width+2);
 
  for(i=0;i<ARRAY_XSIZE;i++){
    for(j=0;j<ARRAY_YSIZE;j++){
      image_out[i][j]=array[i][j];
    }
  }
 
  /************************************************************************
    Now write the magic or cif file
    **************************************************************************/
  if(magic_choice==1 && cif_choice ==0)
    {
      if((fpout=fopen(output_file,"w")) == NULL) {
	fl_show_message("cannot open the output file","","");
	return;
      }

      fprintf(fpout,"magic\ntech  %s\ntimestamp 777777777\n", magic_tech);
      fprintf(fpout,"<< %s >>\n", magic_layer);
      for(column=0;column<y;column++){
	for(row=0;row<x;row++){
 
	  if(array[row][column] ==1){
	    base=scale;
	    y_corner=y-column;
	    y_corner*=base;
	    x_corner=row*base;
	    fprintf(fpout,"rect %d %d %d %d\n",x_corner,y_corner,x_corner+base,y_corner+base);
	  }
 
 
        }
      }
      fprintf(fpout,"<< end >>\n");
    }

 
  /*************************************
    This piece is to create the cif file
    **************************************/
  else {
    if((fpout=fopen(output_file,"w")) == NULL) {
      fl_show_message("cannot open the output file","","");
      return;
    }
    fprintf(fpout,"DS 1 %d 2;\n9 logo;\nL %s;\n", cif_lambda, cif_layer);
    for(column=0;column<y;column++){
      for(row=0;row<x;row++){
 
	if(array[row][column] ==1){
	  base=10*scale*width;
	  y_corner=y-column;
	  y_corner*=base;
	  x_corner=base*row-width;
 
	  fprintf(fpout,"B %d %d %d %d;\n",base+2*width,base,x_corner+(base/2),y_corner+(base/2));
	}
 
 
      }
    }
    fprintf(fpout,"DF;\nC 1;\nEnd\n");
  }
 
  for(i=0;i<ARRAY_SIZE;i++){
    free(array[i]);
    free(array2[i]);
  }
  free(tmp);
  fclose(fpin);
  fclose(fpout);
 
}
 
 
 
/***************************************************************************
To shrink the array after the processing (error correction)
***************************************************************************/
 
int shrink_array(int *array[],int x,int y,int width)
{
  int i,j;
  for(i=0;i<x+width-1;i++){
    for(j=0;j<y+width-1;j++){
      if(i>width-1 || j>width-1 ) array[i][j]=array[i+width][j+width];
    }
  }
  return(0);
}
 
 
 
 
/***************************************************************************
To smooth the array after the processing (error correction)
***************************************************************************/
 
int smooth_array(int *array[],int x,int y,int threshold,int width)
{
  int column,row,*array2[ARRAY_SIZE],tmp,i,j,total=0;
 
  for(i=0;i<ARRAY_SIZE;i++){
    array2[i]=(int *)malloc((ARRAY_YSIZE+2*width)*sizeof(int));
  }
  
  for(column=0;column<y;column++){
    for(row=0;row<x;row++){
      array2[row][column]=0;
    }
  }
  for(i=-(width/2);i<width/2+1;i++){
    for(j=-(width/2);j<width/2+1;j++){
      total+=(width/2-max(abs(i),abs(j))+1);
    }
  }
  for(column=width;column<y+width-1;column++){
    for(row=width;row<x+width-1;row++){
      tmp=0;

      for(i=-(width/2);i<width/2+1;i++){
	for(j=-(width/2);j<width/2+1;j++){
	  tmp+=array[row+i][column+j]*(width/2-max(abs(i),abs(j))+1);
	}
      }
      if(16*tmp>total*threshold) array2[row][column]=1;
      else array2[row][column]=0;
    }
  }
  for(column=0;column<y;column++){
    for(row=0;row<x;row++){
      array[row][column]=array2[row][column];
    }
  }
  for(i=0;i<ARRAY_SIZE;i++){
    free(array2[i]);
  }
 
  return(0);
}

/***************************************************************************
Calculate the maximum of the two numbers
***************************************************************************/ 
int max(int i, int j)
{
  if(i<=j) return(j);
  else return(i);
}


/***************************************************************************
To enlarge the array before the processing (error correction)
***************************************************************************/
int enlarge_array(int *array[],int x,int y,int width)
{
  int i=0,j=0;
  for(i=x+2*width-1;i>=0;i--){
    for(j=y+2*width-1;j>=0;j--){
      if((i<width) || (j<width) || (i>(x-1+width)) || (j>(y-1+width))) {
	array[i][j]=0;
      }
      
      else {
	array[i][j]=array[i-width][j-width];
      }
      
    }
  }
  return(0);
}
 
 

/****************************************************************************
Nor use some design rule error correction methods to get rid of the errors
rs in the array
The algorithm is pretty simple (just one layer to be handled)
***************************************************************************/
void find_error(int *array[],int *error[],int x,int y,int width,int space)
{
  int i=0,j=0,tmp=0,k=0,tmp1=0;
  for(i=0;i<ARRAY_XSIZE+1;i++){
    for(j=0;j<ARRAY_YSIZE+1;j++){
      error[i][j]=0;
    }
  }
 
  /** first find the horizontal width errors **/
  /** note that the input array has been enlarged before **/
  for(j=width;j<y+width+1;j++){
    for(i=width;i<x+width+1;i++){
      tmp=0; tmp1=0;
      for(k=width;k>0;k--){
	if(array[i-k][j]+error[i-k][j]>0){tmp1+=1;tmp=1;}
	if(array[i-k][j]+error[i-k][j]==0 && tmp==1 )tmp=2;
	/*
	  printf("%d,%d a%d e%d tmp%d   ",i,j,array[i-k][j],error[i-k][j],tmp);
	  */
      }
      /*
	if(tmp1==width || tmp1==0 ) error[i][j]=0;
	else {if(tmp==1 && array[i][j]==1) error[i][j]=0;
	else {if(tmp1<width && tmp1>0 && tmp==1 && array[i][j]==1) error[i][j]=0;
	}}
	*/
      if(tmp1<width && tmp1>0 && tmp==1 && array[i][j]==0) error[i][j]=1;
    }
  }
 
 
 
  /** now find the vertical width errors **/
  /** note that the input array has been enlarged before **/
  for(i=width;i<x+width+1;i++){
    for(j=width;j<y+width+1;j++){
      tmp=0; tmp1=0;
      for(k=width;k>0;k--){
	if(array[i][j-k]+error[i][j-k]>0){tmp1+=1;tmp=1;}
	if(array[i][j-k]+error[i][j-k]==0 && tmp==1 )tmp=2;
      }
 
      if(tmp1<width && tmp1>0 && tmp==1 && array[i][j]==0) error[i][j]=1;
    }
  }
 
 
 
 
 
}

 
 
 
 
