/*****************************************************************************

    Copyright (C) 1994,1997 Ivan A. Curtis.  All rights reserved.

This code must not be re-distributed without these copyright notices intact.

*******************************************************************************
*******************************************************************************

Filename:	~icurtis/src/mx/menu.h

Description:	

Update History:   (most recent first)
   I. Curtis   9-Apr-97 12:02 -- Updated
   I. Curtis  22-Mar-94 23:11 -- Created.

******************************************************************************/

typedef struct _mx_menu {
  Window window;
  mx_appearance *app;		/* the appearance structure */
  int width, height;		/* dimension of each menu item (pixels) */
  int item_width;		/* width of largest menu item (pixels) */
  int n_items;			/* number of items in menu */
  mx_menu_item *item;		/* pointer to array of items */
  int start_item, max_items;	/* sub-range of items used */
  int inside;			/* flag indicating focus */
  int momentary;
  int choice;			/* -1 for no choice */
  int cur_x, cur_y;		/* cursor position in window */
  int cur_w, cur_h;		/* cursor size */
} mx_menu;

extern mx_menu *mx_menu_create(Display *display, mx_appearance *app,
			       int n_items, mx_menu_item *mi);

extern int mx_popup_menu(Display *display, int screen, mx_panel *panel,
			 int *x, int *y, int momentary);

extern int mx_menu_event(Display *display, int screen, XEvent *event,
			 mx_menu *menu, int *done, int *x, int *y);
