/* $Id: aktie.c,v 4.1 1995/08/10 20:37:01 lupus Exp lupus $ */

#include <stdlib.h>
#include <string.h>

#include "xfinans.h"
#include "clist.h"
#include "str.h"
#include "post.h"
#include "allocmem.h"

#define AKTIETEST 0

extern char *postString[];

void navnAntalKurs(char *post, char *navn, int *antal, double *kurs) {
  char buf[256];
  char *talstr;
  int t=0;

  zeroAddStrncpy(buf,post,255);
  while(*(buf+t)!='\0' && *(buf+t)!=',')
    t++;

  *(buf+t)='\0';
  strcpy(navn, buf);

  t++;
  while(*(buf+t)==' ')
    t++;
  talstr=buf+t;
  while(*(buf+t)!=' ')
    t++;
  *(buf+t)='\0';
  *antal=atoi(talstr);
  t++;
  while(*(buf+t)!='\0')
    t++;
  while(*(buf+t)!=' ')
    t--;
  t++;
  *kurs=atof(nocomma(buf+t));
}

char **aktiePostStrings(CLIST *poster) {
  char buf[256], navn1[128], navn2[128];
  int i, j, k, antal, antal2;
  double saldo=0.0, kurs, kurs2;
  struct postering *p, *p1;
  int ny=1;
  double startval;

  for(i=0, k=0; 
      i<poster->size && i<MAX_POSTERINGER-1;
      i++) {
    p=(struct postering *)retrieve(i+1,poster);
      sprintf(buf, "%s  %s", dateString(p->dato), p->tekst );
    for(j=strlen(p->tekst); j<POST_TEXT_LENGTH; j++)
	sprintf(buf+strlen(buf), " ");
    navnAntalKurs(p->tekst, navn1, &antal, &kurs);
    p1=(struct postering *)retrieve(i+2,poster);
    navnAntalKurs(p1->tekst, navn2, &antal2, &kurs2);

    if( ny ) {
      startval=antal*kurs;
      ny=0;
    }
    if( strcmp(navn1,navn2)!=0 ) { /* hvis forsk. */
      saldo+=antal*kurs;
      sprintf(buf+strlen(buf)-11, "%9.2f             %9.2f", antal*kurs, antal*kurs-startval);
      ny=1;
    }
    else  {
      sprintf(buf+strlen(buf), "%9.2f  %9.2f", antal*kurs, antal*kurs-startval);
    }
    if(postString[k])
      free(postString[k]);
    postString[k]=(char *)AllocateMemory(TRANSACTION_MAX_WIDTH);
    zeroAddStrncpy(postString[k], buf, TRANSACTION_MAX_WIDTH-1);
    k++;
  }
  sprintf(buf, "Samlet aktuel kursvrdi: %9.2f", saldo);
  if(postString[k])
    free(postString[k]);
  postString[k]=(char *)AllocateMemory(TRANSACTION_MAX_WIDTH);
  zeroAddStrncpy(postString[k], buf, TRANSACTION_MAX_WIDTH);

  k++;
  if(postString[k])
    free(postString[k]);
  postString[k]=0;

  return postString;
}

#if AKTIETEST
main() {
  int antal;
  double kurs;
  char navn[50];

  navnAntalKurs("Sparekasse, 3 stk kurs 230", navn, &antal, &kurs);
  printf("%s\n%d\n%9.2f", navn, antal, kurs);
}
#endif
