/* $Id: displayLimitWindow.c,v 1.1 1996/06/16 20:14:55 lupus Exp lupus $ */

/***************************************************************
 * This file is part of Xfinans                                *
 * Created 16-06-1996                                          *
 * Niels C. Larsen, Aalborg University, Denmark                *
 * (lupus@iesd.auc.dk)                                         *
 ***************************************************************/

/* pop-up window for supplying display date range */

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>

#include <X11/Xaw/Paned.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Text.h>
#include <X11/Xaw/AsciiText.h>

#include <string.h>
#include <stdlib.h>
#include "focus.h"
#include "str.h"
#include "config.h"
#include "country.h"
#include "displayLimitWindow.h"

/* ---  private declarations  --- */

extern Widget topLevel;  /* from window.c */

#define BUTTON_WIDTH 155
#define LABEL_WIDTH 120
#define FIELD_WIDTH 30

static int popup=0;
static Widget displayLimitWindowShell;

/* input fields */
static Widget beforeInput, afterInput;

/* private functions prototypes */
static void createDisplayLimitWindowWidgets();
static void displayLimitWindowApply(Widget w, XtPointer client_data, XtPointer call_data);

/* ---  public functions  --- */

void displayLimitWindowPopup(Widget w, XtPointer client_data, XtPointer call_data) {
  Position x,y;
  
  if( !popup ) {
    createDisplayLimitWindowWidgets(); /* make sure widgets are initialized */

    /* position the popup window relative to the main window */
    XtTranslateCoords(topLevel,(Position)100, (Position)40,
		      &x, &y);
    
    XtVaSetValues(displayLimitWindowShell,
		  XtNx, x,
		  XtNy, y,
		  NULL );

    XtPopup(displayLimitWindowShell, XtGrabNone);
    popup=1;
  }
}

/* ---  private functions  --- */

static void displayLimitWindowClose(Widget w, XtPointer client_data, XtPointer call_data) {
  XtPopdown(displayLimitWindowShell);
  popup=0;
}

static void displayLimitWindowApply(Widget w, XtPointer client_data,
XtPointer call_data) {
  String p;

  XtVaGetValues(beforeInput, XtNstring, &p, NULL);
  set_display_before(atoi(p));
  XtVaGetValues(afterInput, XtNstring, &p, NULL);
  set_display_after(atoi(p));

  displayLimitWindowClose(w,client_data, call_data);
}

static void createDisplayLimitWindowWidgets() {
  static int done=0;
  
  Widget displayLimitWindowPane;
  Widget displayLimitWindowForm;
  Widget displayLimitWindowBox;
  
  /* buttons */
  Widget apply;
  
  /* labels */
  Widget beforeLabel, afterLabel;

  char buf[100];
  
  if(done)
    return;
  done=1;
  
  displayLimitWindowShell = XtVaCreatePopupShell (
				      "displayLimitWindowShell",
				      transientShellWidgetClass,
				      topLevel,
				      XtNtitle, RANGE_LABEL,
				      NULL );
  
  displayLimitWindowPane = XtVaCreateManagedWidget(
				      "displayLimitWindowPane",
				      panedWidgetClass,
				      displayLimitWindowShell,
				      NULL);
  
  displayLimitWindowForm = XtVaCreateManagedWidget(
				      "displayLimitWindowForm",
				      formWidgetClass,
				      displayLimitWindowPane,
				      NULL);

  sprintf(buf, "%d", get_display_before_days());

  beforeLabel = XtVaCreateManagedWidget(
				      "beforeLabel",
				      labelWidgetClass,
                                      displayLimitWindowForm,
                                      XtNlabel, DISPLAY_LIMIT_RANGE_FROM,
				      XtNwidth, LABEL_WIDTH,
				      XtNjustify, XtJustifyLeft,
                                      NULL);

  beforeInput = XtVaCreateManagedWidget(
			              "beforeInput",
				      asciiTextWidgetClass,
				      displayLimitWindowForm,
				      XtNstring, buf,
				      XtNeditType, XawtextEdit,
				      XtNwidth, FIELD_WIDTH,
				      XtNfromHoriz, beforeLabel,
				      NULL);

  afterLabel = XtVaCreateManagedWidget(
				      "afterLabel",
				      labelWidgetClass,
                                      displayLimitWindowForm,
                                      XtNlabel, DISPLAY_LIMIT_RANGE_TO,
				      XtNwidth, LABEL_WIDTH,
				      XtNjustify, XtJustifyLeft,
				      XtNfromVert, beforeLabel,
                                      NULL);

  sprintf(buf, "%d", get_display_after_days());
  afterInput = XtVaCreateManagedWidget(
			              "centerYInput",
				      asciiTextWidgetClass,
				      displayLimitWindowForm,
				      XtNstring, buf,
				      XtNeditType, XawtextEdit,
				      XtNwidth, FIELD_WIDTH,
				      XtNfromHoriz, afterLabel,
				      XtNfromVert, beforeLabel,
				      NULL);

  displayLimitWindowBox = XtVaCreateManagedWidget(
				      "displayLimitWindowBox",
				      boxWidgetClass,
				      displayLimitWindowPane,
				      NULL);

  apply = XtVaCreateManagedWidget(
				      "circularParameterWindowApply",
				      commandWidgetClass,
				      displayLimitWindowBox,
				      XtNlabel, CONFIRM_LABEL,
				      XtNwidth, BUTTON_WIDTH, 
				      NULL);
  XtAddCallback(apply, XtNcallback, displayLimitWindowApply, topLevel); 

  saveFocusInfo(beforeInput, afterInput,
		displayLimitWindowPane, apply, 1);
  saveFocusInfo(afterInput,  beforeInput,
		displayLimitWindowPane, apply, 0);

  jumpTo(beforeInput);
}
