#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <glib.h>

int main(int argc, char **argv) {
  Display *dpy;
  Atom icc_atom;
  GError *error = NULL;
  char *profile;
  gsize length;

  dpy = XOpenDisplay(NULL);
  if (dpy == NULL) {
    g_printerr("Cannot open display\n");
    return 1;
  }

  icc_atom = XInternAtom (dpy, "_ICC_PROFILE", False);
  if (icc_atom == None) {
    g_printerr("Cannot intern atom\n");
    return 1;
  }

  if (!g_file_get_contents (argv[1], &profile, &length, &error)) {
    g_printerr("Cannot read profile: %s\n", error->message);
    g_error_free (error);
    return 1;
  }

  XChangeProperty (dpy, DefaultRootWindow (dpy), icc_atom, XA_CARDINAL, 32, PropModeReplace, profile, length/sizeof(long));

  XCloseDisplay (dpy);
  return 0;
}
