/* image_cursor.cc : X  pixmap 򥫡ȤƻȤΥ饹
 *     ¾Υ饹ϤʤꡢΩƤ롣
**/
/*
 *
 *  Copyright (C) 2000-   Kazunori Ueno(JAGARL) <jagarl@creator.club.ne.jp>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
*/


#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif
#include "image_cursor.h"
#include <gdk--/image.h>
#include <gdk--/window.h>
#include <gdk--/pixmap.h>
#include <gdk--/bitmap.h>
#include <gdk--/gc.h>
#include <gdk/gdkprivate.h>
#include <stdio.h>

P_CURSOR::P_CURSOR(Gdk_Window& win) : p_window(win) {
	// äޥĤ
	Gdk_Color black("black"); Gdk_Color white("white");
	char buf = 0;
	Gdk_Bitmap bitmap(p_window, &buf, 1, 1);
	null_cursor = gdk_cursor_new_from_pixmap(
		bitmap.gdkobj(), bitmap.gdkobj(), white.gdkobj(), black.gdkobj(), 0, 0);
	arrow_cursor = gdk_cursor_new(GDK_ARROW);

}
void P_CURSOR::Draw(void) {
	p_window.set_cursor(arrow_cursor);
}
void P_CURSOR::Delete(void) {
	p_window.set_cursor(null_cursor);
}
void P_CURSOR::DrawCursor(Gdk_Window& win) {
	win.set_cursor(arrow_cursor);
}
void P_CURSOR::DeleteCursor(Gdk_Window& win) {
	win.set_cursor(null_cursor);
}

PIX_CURSOR::PIX_CURSOR(Gdk_Window& win, Gdk_Pixmap& pix, Gdk_Bitmap& bitmap, char* im_mask, Gdk_Pixmap& bg)
	: P_CURSOR(win), window(win), pixmap(pix), mask(bitmap), background(bg)
{
	savebuf = 0;
	x = DELETED_MOUSE_X; y = DELETED_MOUSE_X; // cursor is deleted
	image_mask = im_mask;
	// image Ĥ
	int width = ( (GdkWindowPrivate*)(pix.gdkobj()) ) -> width;
	int height = ( (GdkWindowPrivate*)(pix.gdkobj()) ) -> height;
	image.get(pix, 0, 0, width, height);
	
	buffer_pixmap = Gdk_Pixmap(window, 64, 64, -1); // Хåե
	masked_gc = Gdk_GC(buffer_pixmap); masked_gc.set_clip_mask(mask); // mask 
	gc = Gdk_GC(buffer_pixmap); gc.set_clip_mask();
}

PIX_CURSOR::~PIX_CURSOR() {
}

void PIX_CURSOR::UpdateBuffer(void) {
}

// pixmap ñ褹
void PIX_CURSOR::DrawPixmapRelative(Gdk_Pixmap* pix, int xx, int yy) {
	if (x == DELETED_MOUSE_X) return;// ޥɽƤʤ
	int nx = x-xx; int ny = y-yy;
	masked_gc.set_clip_origin(nx, ny);
	pix->draw_pixmap(masked_gc, pixmap, 0, 0, nx, ny, 32, 32);
}

void PIX_CURSOR::Draw(int new_x, int new_y) {
	if (new_x == DELETED_MOUSE_X) {Delete(); return; }
	if (x == DELETED_MOUSE_X) { // ߡʤˤɽƤʤ -> ɽ
		masked_gc.set_clip_origin(new_x,new_y);
		window.draw_pixmap(masked_gc, pixmap, 0, 0, new_x, new_y, 32, 32);
		x = new_x; y = new_y;
	} else {
		int dx = new_x - x; int dy = new_y - y;
		if (dx < 0) dx = -dx; if (dy < 0) dy = -dy;
		if (dx >= 32 || dy >= 32) { // Υȿ˶Ϥʤ
			masked_gc.set_clip_origin(new_x,new_y);
			window.draw_pixmap(gc, background, x, y, x, y, 32, 32);
			window.draw_pixmap(masked_gc, pixmap, 0, 0, new_x, new_y, 32, 32);
			x = new_x; y = new_y;
		} else { //
			int x0, y0, width, height;
			if (x < new_x) { x0=x; width=new_x-x+32;
			} else { x0=new_x; width=x-new_x+32;
			}
			if (y < new_y) { y0=y; height=new_y-y+32;
			} else { y0=new_y; height=y-new_y+32;
			}
			buffer_pixmap.draw_pixmap(gc, background, x0, y0, 0, 0, width, height);
			masked_gc.set_clip_origin(new_x-x0,new_y-y0);
			buffer_pixmap.draw_pixmap(masked_gc, pixmap, 0, 0, new_x-x0, new_y-y0, 32, 32);
			window.draw_pixmap(gc, buffer_pixmap, 0, 0, x0, y0, width, height);
			x = new_x; y = new_y;
		}
	}
}

void PIX_CURSOR::Delete(void) {
	if (x == DELETED_MOUSE_X) return; // already deleted
	window.draw_pixmap(gc, background, x, y, x, y, 32, 32);
	x = DELETED_MOUSE_X; y = DELETED_MOUSE_X;
}

// dest <- src ǥԡdest Ƥ¸
PIX_CURSOR_SAVEBUF::PIX_CURSOR_SAVEBUF(Gdk_Image* dest_im, Gdk_Image* src_im, char* mask, int dest_x, int dest_y)
{
	int src_x = 0; int src_y = 0;
	src = 0; dest = 0; bpl = 0;

	int swidth = src_im->gdkobj()->width; int sheight = src_im->gdkobj()->height;
	int dwidth = dest_im->gdkobj()->width; int dheight = dest_im->gdkobj()->height;
	int width = swidth; height = sheight;
	/* ĤΥɥθ򺵤 */
	/* ޤwidth ݤ */
	if (src_x < 0) { dest_x -= src_x; src_x = 0;}
	if (src_y < 0) { dest_y -= src_y; src_y = 0;}
	if (dest_x < 0) { src_x -= dest_x; dest_x = 0;}
	if (dest_y < 0) { src_y -= dest_y; dest_y = 0;}
	
	dwidth -= dest_x; dheight -= dest_y;
	swidth -= src_x; sheight -= src_y;
	/* dest 礭 src 礭꾮Сä˹碌 */
	if (dwidth < swidth) swidth = dwidth;
	if (dheight < sheight) sheight = dheight;
	/* ϰϥåԡʲ礭ˤʤä饨顼 */
	if (swidth <= 0 || sheight <= 0) return;

	/* 礭 */
	width = swidth; height = sheight;
	swidth = src_im->gdkobj()->width; sheight = src_im->gdkobj()->height;
	dwidth = dest_im->gdkobj()->width; dheight = dest_im->gdkobj()->height;

	// bpp ƱϤ
	int bpp = dest_im->gdkobj()->bpl / dest_im->gdkobj()->width;
	int sbpl = src_im->gdkobj()->bpl; dbpl = dest_im->gdkobj()->bpl;
	char* from_data = (char*)src_im->gdkobj()->mem;
	dest = (char*)dest_im->gdkobj()->mem;

	// ɸ碌
	from_data += src_x*bpp + src_y*sbpl;
	dest += dest_x*bpp + dest_y*dbpl;
	mask += src_x + src_y*swidth;

#ifdef SUPPORT_MSB_FIRST
	int reverse = 0;
	if (dest_im->gdkobj()->byte_order == MSBFirst)
		reverse = !0;
#endif

	// 饹ΥС
	bpl = bpp * width; src = new char[height*bpl];
	// dest -> src إԡ
	char* buf1 = dest; char* buf2 = src;
	int i,j; for (i=0; i<height; i++) {
		memcpy(buf2, buf1, bpl);
		buf1 += dbpl; buf2 += bpl;
	}
	// src_im -> dest_im إԡ
	buf1 = from_data; buf2 = dest;
	for (i=0; i<height; i++) {
		char* b1 = buf1; char* b2 = buf2; char* m = mask;
		for (j=0; j<width; j++) {
			if (*m) {
#ifdef SUPPORT_MSB_FIRST
				if (reverse && bpp == 4) {
					b2[0] = b1[3];
					b2[1] = b1[2];
					b2[2] = b1[1];
					b2[3] = b1[0];
				} else {
				memcpy(b2, b1, bpp);
				}
#else  // SUPPORT_MSB_FIRST
				memcpy(b2, b1, bpp);
#endif // SUPPORT_MSB_FIRST
			}
			b1 += bpp; b2 += bpp; m++;
		}
		buf1 += sbpl; buf2 += dbpl; mask += swidth;
	}
	// λ
	return;
}
PIX_CURSOR_SAVEBUF::~PIX_CURSOR_SAVEBUF()
{
	// src -> dest إԡ
	char* buf1 = src; char* buf2 = dest;
	int i; for (i=0; i<height; i++) {
		memcpy(buf2, buf1, bpl);
		buf1 += bpl; buf2 += dbpl;
	}
	delete src;
}

