/* image_cursor.h : X  pixmap 򥫡ȤƻȤΥ饹
 *     ¾Υ饹ϤʤꡢΩƤ롣
**/
/*
 *
 *  Copyright (C) 2000-   Kazunori Ueno(JAGARL) <jagarl@creator.club.ne.jp>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
*/


#ifndef __KANON_IMAGE_CURSOR_H__
#define __KANON_IMAGE_CURSOR_H__

#include <gdk--.h>
#define DELETED_MOUSE_X 100000

// image 򥳥ԡꥹȥ
class PIX_CURSOR_SAVEBUF {
	char* dest;
	char* src;
	int bpl, dbpl;
	int height;
public:
	PIX_CURSOR_SAVEBUF(Gdk_Image* dest, Gdk_Image* src, char* mask, int x, int y);
	~PIX_CURSOR_SAVEBUF();
};

class P_CURSOR { // PIX_CURSOR Υåѡ
	Gdk_Window& p_window;
	GdkCursor* null_cursor;
	GdkCursor* arrow_cursor;
public:
	P_CURSOR(Gdk_Window& win);
	virtual ~P_CURSOR() {};
	virtual void DrawImage(Gdk_Image* im, int x, int y) {}
	virtual void DrawImage(Gdk_Image* im) {}
	virtual void DrawImageRelative(Gdk_Image* im, int xx, int yy) {}
	virtual void DrawPixmapRelative(Gdk_Pixmap* pix, int xx, int yy) {}
	virtual void RestoreImage(void) {}
	virtual void UpdateBuffer(void) {}
	// 
	virtual void Draw(void);
	virtual void DrawCursor(Gdk_Window& window);
	// ä
	virtual void Delete(void);
	virtual void DeleteCursor(Gdk_Window& window);
	virtual void Draw(int x, int y) { Draw();}
	virtual void Draw_without_Delete(void) {Draw();}
};

class PIX_CURSOR : public P_CURSOR { // Ĥ¸뤿Υ饹
	Gdk_Window window; //  window
	Gdk_Pixmap pixmap; // ޥpixmap
	Gdk_Bitmap mask; // ޥΥޥ
	Gdk_Pixmap background; // window ƱƤ pixmap(طʤΤˤĤ)
	Gdk_Image image; // ޥ image
	char* image_mask; // image Υޥ

	Gdk_Pixmap buffer_pixmap; // طʤȹ뤿ΰХåե
	Gdk_GC masked_gc, gc;
	PIX_CURSOR_SAVEBUF* savebuf; // image ˥ޥȤȤ image ĤΥХåե

	int x, y;
public:
	PIX_CURSOR(Gdk_Window& win, Gdk_Pixmap& pix, Gdk_Bitmap& bitmap, char* mask, Gdk_Pixmap& background);
	~PIX_CURSOR();
	// Gdk_Image ˡ褹롣֥ХåեȤʤˤĤ
	// ơimagewindow褷顢(XSync() ) RestoreImage() ʤФʤʤ
	void DrawImage(Gdk_Image* im, int x, int y) { 
		if (savebuf) delete savebuf;
		savebuf = 0;
		if (x == DELETED_MOUSE_X) return;
		savebuf = new PIX_CURSOR_SAVEBUF(im, &image, image_mask, x, y);
	}
	void DrawImage(Gdk_Image* im) {
		DrawImage(im,x,y);
	}
	// ߥΤ֤ФӤ xx,yy ΰ֤
	// window ΰ image 񤭤Ȥ image ˥ޥ˻Ȥ
	void DrawImageRelative(Gdk_Image* im, int xx, int yy) {
		DrawImage(im, x+xx, y+yy);
	}
	void DrawPixmapRelative(Gdk_Pixmap* pix, int xx, int yy);
	void RestoreImage(void) { if (savebuf != 0) delete savebuf; savebuf = 0;}
	void UpdateBuffer(void); // ̤
	// (x,y) ΰ֤˥ޥư
	void Draw(int x, int y);
	void Draw(void) { if (x != DELETED_MOUSE_X) Draw(x,y);}
	void Draw_without_Delete(void) { // ̤νľʤɤȤľ
		if (x == DELETED_MOUSE_X) return;
		int orig_x = x;
		x = DELETED_MOUSE_X;
		Draw(orig_x,y);
	}
	// ä
	void Delete(void);
};

#endif /* __KANON_IMAGE_CURSOR_H__ */
