/* image_sys.cc
 *	ʸɥȡޥ롢꥿󥫡ʤɤ
 *	ƥ pdt ե뤫ɤ߹ߡ褹
**/
/*
 *
 *  Copyright (C) 2000-   Kazunori Ueno(JAGARL) <jagarl@creator.club.ne.jp>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
*/

#include "file.h"
#include "system.h"
#include "image_sys.h"
#include "image_cursor.h"
#include <glib.h>
#include <gdk/gdkprivate.h>

#ifdef SUPPORT_MSB_FIRST
void FitImage(Gdk_Image *dest, Gdk_Image *src);
#endif


// Ȥ򤫤̥饹

static void copyrect(char* dest,char* src, int dest_width,int src_width, int height) {
	int i;
	int width;
	if (dest_width < src_width) width = dest_width;
	else width = src_width;
	for (i=0; i<height;i++) {
		memcpy(dest, src, width);
		dest += dest_width; src += src_width;
	}
}


class WAKU_PDT {
	friend class SYSTEM_PDT_IMAGE; // 餷Ǥʤ
	// ȤΥ᡼
	Gdk_Image waku_top_left;	// 48x8
	char* mask_waku_top_left;
	Gdk_Image waku_top_center;	// 16x8
	char* mask_waku_top_center;
	Gdk_Image waku_top_right;	// 48x8
	char* mask_waku_top_right;
	Gdk_Image waku_bottom_left;	// 48x8
	char* mask_waku_bottom_left;
	Gdk_Image waku_bottom_center;	// 16x8
	char* mask_waku_bottom_center;
	Gdk_Image waku_bottom_right;	// 48x8
	char* mask_waku_bottom_right;
	Gdk_Image waku_left_top;		// 8x16
	char* mask_waku_left_top;
	Gdk_Image waku_left_center;		// 8x16
	char* mask_waku_left_center;
	Gdk_Image waku_left_bottom;		// 8x16
	char* mask_waku_left_bottom;
	Gdk_Image waku_right_top;		// 8x16
	char* mask_waku_right_top;
	Gdk_Image waku_right_center;		// 8x16
	char* mask_waku_right_center;
	Gdk_Image waku_right_bottom;		// 8x16
	char* mask_waku_right_bottom;

	WAKU_PDT(void);
	~WAKU_PDT();
	void Init(Gdk_Window& win, char* data, char* mask_data, int x, int y, int width); // Ȥν
	void Draw(Gdk_Image& d, int x, int y, int width, int height); // width x height Ȥ x,y 
	void MakeImage(Gdk_Window& win,  // image 
		char* data, char* mask_data, int x, int y, int width, int height, int src_width,
		Gdk_Image& image, char*& mask);
	void CopyImage(Gdk_Image& d, Gdk_Image& s, char* mask, int x, int y);  // Ǻä image / mask 
};

WAKU_PDT::WAKU_PDT(void) {
	mask_waku_top_left = 0;
	mask_waku_top_center = 0;
	mask_waku_top_right = 0;
	mask_waku_bottom_left = 0;
	mask_waku_bottom_center = 0;
	mask_waku_bottom_right = 0;
	mask_waku_left_top = 0;
	mask_waku_left_center = 0;
	mask_waku_left_bottom = 0;
	mask_waku_left_top = 0;
	mask_waku_left_center = 0;
	mask_waku_left_bottom = 0;
}

WAKU_PDT::~WAKU_PDT() {
	if (mask_waku_top_left != 0) delete mask_waku_top_left;
	if (mask_waku_top_center != 0) delete mask_waku_top_center;
	if (mask_waku_top_right != 0) delete mask_waku_top_right;
	if (mask_waku_bottom_left != 0) delete mask_waku_bottom_left;
	if (mask_waku_bottom_center != 0) delete mask_waku_bottom_center;
	if (mask_waku_bottom_right != 0) delete mask_waku_bottom_right;
	if (mask_waku_left_top != 0) delete mask_waku_left_top;
	if (mask_waku_left_center != 0) delete mask_waku_left_center;
	if (mask_waku_left_bottom != 0) delete mask_waku_left_bottom;
	if (mask_waku_right_top != 0) delete mask_waku_right_top;
	if (mask_waku_right_center != 0) delete mask_waku_right_center;
	if (mask_waku_right_bottom != 0) delete mask_waku_right_bottom;
}

void WAKU_PDT::MakeImage(Gdk_Window& win,  // image 
		char* srcdata, char* mask_data, int x, int y, int width, int height, int src_width,
		Gdk_Image& image, char*& mask)
{
	// data
	char* data = new char[width*height*4];
	copyrect( data, srcdata + (x + y * src_width)*4, width*4, src_width*4, height);

	// imageĤ
	Gdk_Visual vis = win.get_visual();
	image.create(GDK_IMAGE_NORMAL, vis, width, height);
	// ԡ
	SetImage(&image, (unsigned char*) data);
	delete[] data;

	// mask Ĥ
	mask = new char[ (width+1)*height ];
	int i,j; for (i=0; i<height; i++) {
		char* cur_mask = mask + (width+1)*i + 1;
		char* cur_src_mask = mask_data + x + src_width*(y+i);
		int count = 0;
		for (j=0; j<width; j++) {
			if ( (*cur_mask++ = *cur_src_mask++) != 0) count++;
		}
		if (count == width) count = -1;
		else if (count != 0) count = 1;
		mask[ (width+1)*i] = count;
	}
}

void WAKU_PDT::Init(Gdk_Window& win, char* data, char* mask_data, int x, int y, int width)
{
	data += ( x + y*width ) * 4; mask_data += ( x + y*width );
	MakeImage(win, data, mask_data, 0, 0, 48, 8, width, waku_top_left, mask_waku_top_left);
	MakeImage(win, data, mask_data, 48, 0, 16, 8, width, waku_top_center, mask_waku_top_center);
	MakeImage(win, data, mask_data, 64, 0, 48, 8, width, waku_top_right, mask_waku_top_right);
	MakeImage(win, data, mask_data, 0, 56, 48, 8, width, waku_bottom_left, mask_waku_bottom_left);

	MakeImage(win, data, mask_data, 48, 56, 16, 8, width, waku_bottom_center, mask_waku_bottom_center);

//	MakeImage(win, data, mask_data, 48, 56, 32, 8, width, waku_bottom_center, mask_waku_bottom_center);
	MakeImage(win, data, mask_data, 64, 56, 48, 8, width, waku_bottom_right, mask_waku_bottom_right);
	MakeImage(win, data, mask_data, 0, 8, 8, 16, width, waku_left_top, mask_waku_left_top);
	MakeImage(win, data, mask_data, 0, 24, 8, 16, width, waku_left_center, mask_waku_left_center);
	MakeImage(win, data, mask_data, 0, 40, 8, 16, width, waku_left_bottom, mask_waku_left_bottom);
	MakeImage(win, data, mask_data, 104, 8, 8, 16, width, waku_right_top, mask_waku_right_top);
	MakeImage(win, data, mask_data, 104, 24, 8, 16, width, waku_right_center, mask_waku_right_center);
	MakeImage(win, data, mask_data, 104, 40, 8, 16, width, waku_right_bottom, mask_waku_right_bottom);
}

void WAKU_PDT::CopyImage(Gdk_Image& d, Gdk_Image& s, char* mask, int x, int y) {
	// ǡ
	char* src_pt = (char*)s.gdkobj()->mem;
	char* dest_pt = (char*)d.gdkobj()->mem;
	// width, bpl ʤ
	int src_bpl = s.gdkobj()->bpl; int dest_bpl = d.gdkobj()->bpl;
	int src_width = s.gdkobj()->width; int height = s.gdkobj()->height;
	int bypp = (s.gdkobj()->bpl)/src_width; // dest_bypp Ϥ
	
	dest_pt += bypp*x + dest_bpl*y; // ɸ
	
	// ԡ
	int i;
	for (i=0; i<height; i++) {
		int m = *mask;
		if (m == 0) { // ʤˤʤ
			mask += src_width + 1;
		} else if (m == -1) { // Τޤ
			memcpy(dest_pt, src_pt, src_bpl);
			mask += src_width + 1;
		} else { // ޥȤä
			int j,k; mask++; char* tmp_src = src_pt; char* tmp_dest = dest_pt;
			for (j=0; j<src_width; j++) {
				if (*mask++) {
					for (k=0; k<bypp; k++) *tmp_dest++ = *tmp_src++;
				} else {
					tmp_dest += bypp; tmp_src += bypp;
				}
			}
		}
		dest_pt += dest_bpl; src_pt += src_bpl;
	}
}

void WAKU_PDT::Draw(Gdk_Image& d, int x, int y, int width, int height) {
	if (mask_waku_top_left == 0) return;
	if (width < 96 || height < 48) {
		fprintf(stderr, "Runtime Error in WAKU_PDT::Draw : too little width / height value.\n");
		return;
	}
	int i; int count; int destx, desty;
	// 
	count = (width-81)/16; destx = x+48; desty = y;
	for (i=0; i<count ;i++) {
		CopyImage(d, waku_top_center, mask_waku_top_center, destx, desty);
		destx += 16;
	}
	destx = x+48; desty = y+height-8;
	for (i=0; i<count ;i++) {
		CopyImage(d, waku_bottom_center, mask_waku_bottom_center, destx, desty);
		destx += 16;
	}
	count = (height-33)/16; destx = x; desty = y+24;
	for (i=0; i<count ;i++) {
		CopyImage(d, waku_left_center, mask_waku_left_center, destx, desty);
		desty += 16;
	}
	destx = x+width-8; desty = y+24;
	for (i=0; i<count ;i++) {
		CopyImage(d, waku_right_center, mask_waku_right_center, destx, desty);
		desty += 16;
	}
	// 
	CopyImage(d, waku_top_left, mask_waku_top_left, x, y);
	CopyImage(d, waku_left_top, mask_waku_left_top, x, y+8);
	CopyImage(d, waku_top_right, mask_waku_top_right, x+width-48, y);
	CopyImage(d, waku_right_top, mask_waku_right_top, x+width-8, y+8);
	CopyImage(d, waku_bottom_left, mask_waku_bottom_left, x, y+height-8);
	CopyImage(d, waku_left_bottom, mask_waku_left_bottom, x, y+height-8-16);
	CopyImage(d, waku_bottom_right, mask_waku_bottom_right, x+width-48, y+height-8);
	CopyImage(d, waku_right_bottom, mask_waku_right_bottom, x+width-8, y+height-8-16);
}

SYSTEM_PDT_IMAGE::SYSTEM_PDT_IMAGE(const char* fname) {
	filename = new char[strlen(fname)+1];
	strcpy(filename, fname);
	// ¾Сν
	return_screen1 = return_screen2 = 0;
	return_x = return_y = 0;
	return_count = 0;

	waku[0] = 0; waku[1] = 0; waku[2] = 0; waku[3] = 0;
	return_count = 0;
}

SYSTEM_PDT_IMAGE::~SYSTEM_PDT_IMAGE()
{
	delete[] filename;
	if (waku[0] != 0) { // already initialized.
		int i;for (i=0; i<4; i++) delete waku[i];
	}
}

int SYSTEM_PDT_IMAGE::Init(Gdk_Window& window, AyuSys& local_system) {
	ARCINFO* info = file_searcher.Find(FILESEARCH::PDT, filename,".PDT.G00.GPD");
	if (info == 0) return false;
	const char* fdata = info->Read();
	GRPCONV* conv = GRPCONV::AssignConverter(fdata, info->Size(), "");
	char* data = (char*)conv->Read();
	delete info;
	if (data == 0) { delete conv; return false;}
	int width = conv->Width(); int height = conv->Height();
	InitPixmaps(window, data, width, height, local_system); // ٤Ƥ pixmap ʤɤ
	delete conv;
	return true;
}
void SYSTEM_PDT_IMAGE::InitPixmaps(Gdk_Window& window,char* data, int width, int height, AyuSys& local_system)
{
	int i,j,k;
	unsigned int* srcbuf = (unsigned int*) data; // int == 32bit
	char* mask_data = new char[width*height];
	char* maskbuf = mask_data;

	unsigned int mask_pixel = *srcbuf;
	// mask Ĥ
	for (i=0; i<height; i++) {
		for (j=0; j<width; j++) {
			if (*srcbuf == mask_pixel) {
				*maskbuf = 0;
				*srcbuf = 0;
			} else {
				*maskbuf = 0xff;
			}
			srcbuf++; maskbuf++;
		}
	}

	gc = Gdk_GC(window);

	// return pixmap Ĥ
	Gdk_Visual vis = window.get_visual();
	/* retn_width / height ʤɤν */
	int max_retnw=0, max_retnh = 0;
	for (i=0; i<4; i++) {
		/* ° */
		if (i == 0) {
			return_cursor[i].retn_width = local_system.config->GetParaInt("#RETN_XSIZE");
			return_cursor[i].retn_height = local_system.config->GetParaInt("#RETN_YSIZE");
			return_cursor[i].retn_patterns = local_system.config->GetParaInt("#RETN_CONT");
		} else {
			return_cursor[i].retn_width = 32;
			return_cursor[i].retn_height = 32;
			return_cursor[i].retn_patterns = 8;
		}
		if (max_retnw < return_cursor[i].retn_width) max_retnw = return_cursor[i].retn_width;
		if (max_retnh < return_cursor[i].retn_height) max_retnh = return_cursor[i].retn_height;
		int ht = return_cursor[i].retn_height;
		int rw = return_cursor[i].retn_width * return_cursor[i].retn_patterns;
		/* ǡκ */
		char* retn_data = new char[rw * ht * 4];
		char* retn_mask = new char[rw * ht];
		int x0 = 48*i;
		if (i == 0) x0 += 8;
		copyrect(retn_data, data + (160 + (width*x0))*4 , rw*4, width*4, ht);
		copyrect(retn_mask, mask_data + (160+(width*x0)), rw, width, ht);
		/* image  */
		return_cursor[i].return_image.create(GDK_IMAGE_NORMAL, vis, rw, ht);
		SetImage(&return_cursor[i].return_image, (unsigned char*) retn_data);
		return_cursor[i].return_mask = retn_mask;
	}
	// return_tmpimage Ĥ
	return_tmpimage.create(GDK_IMAGE_SHARED, vis, max_retnw, max_retnh);
	if (return_tmpimage.gdkobj() == 0) {
		return_tmpimage.create(GDK_IMAGE_NORMAL, vis, max_retnw, max_retnh);
	}
	// ޥĤ

	// (160,200) 顢32x32 礭ǥ뤬¸
	char* mouse_data = new char[32*32*4];
	copyrect(mouse_data, data + (160 + (width*200))*4, 32*4, width*4, 32);
	// pixmap ˤ
	mouse_pixmap.create(window, 32, 32, -1);
	Gdk_Image mouse_image(GDK_IMAGE_NORMAL, vis, 32, 32);
	SetImage(&mouse_image, (unsigned char*)mouse_data);
#ifdef SUPPORT_MSB_FIRST
	if (mouse_image.gdkobj()->byte_order == MSBFirst) {
		Gdk_Image mouse_image_fit(GDK_IMAGE_NORMAL, vis, 32, 32);
		FitImage(&mouse_image_fit, &mouse_image);
		mouse_pixmap.draw_image(gc, mouse_image_fit, 0, 0, 0, 0);
	} else {
		mouse_pixmap.draw_image(gc, mouse_image, 0, 0, 0, 0);
	}
#else  // SUPPORT_MSB_FIRST
	mouse_pixmap.draw_image(gc, mouse_image, 0, 0, 0, 0);
#endif // SUPPORT_MSB_FIRST

	// bitmap Ĥ
	char* src_mask = mask_data + (160 + (width*200) ); char* mouse_mask = new char[32*32/8];
	char* mouse_mask_cur = mouse_mask;
	for (i=0; i<32; i++) {
		char* src_mask_cur = src_mask;
		for (j=0; j<4; j++) {
			int c = 0;
			for (k=0; k<8; k++) {
				if (*src_mask_cur++) { c>>=1; c|=0x80;}
				else { c>>=1; }
			}
			*mouse_mask_cur++ = c;
		}
		src_mask += width;
	}
	mouse_bitmap.create(window, mouse_mask, 32, 32);
	delete[] mouse_mask;
	mouse_image_mask = new char[32*32]; src_mask = mask_data + (160 + width*200);
	for (i=0; i<32; i++) {
		memcpy(mouse_image_mask+i*32, src_mask, 32);
		src_mask += width;
	}

	// ȤĤ
	for (i=0 ;i<4; i++) {
		waku[i] = new WAKU_PDT();
		waku[i]->Init(window, data, mask_data, 8, 8+100*i,width);
	}

	// 
	delete[] mask_data;
}

void SYSTEM_PDT_IMAGE::DeleteReturnPixmap(P_CURSOR* cursor) {
	if (return_back.gdkobj() == 0) return;
	/* return_screen2 ϡޥ̵ */
	int w=return_back.gdkobj()->width;
	int h=return_back.gdkobj()->height;
	if (return_x+w > global_system.DefaultScreenWidth()) w=global_system.DefaultScreenWidth()-return_x;
	if (return_y+h > global_system.DefaultScreenHeight()) h=global_system.DefaultScreenHeight()-return_y;
	return_screen2->draw_image(gc, return_back, 0, 0, return_x, return_y, w, h);
	global_system.FlushScreen();
	if (cursor) cursor->DrawImageRelative(&return_back, -return_x, -return_y);
	/* return_screen1 ϥޥ뤢 */
	return_screen1->draw_image(gc, return_back, 0, 0, return_x, return_y, w, h);
	global_system.FlushScreen();
	cursor->RestoreImage();
	return_back.release();
}

void SYSTEM_PDT_IMAGE::DrawReturnPixmap(P_CURSOR* cursor)
{
	if (return_back.gdkobj() == 0) return;
	int type = CursorType();
	int i,j,k;
	/* ɬפѿ */
	Gdk_Image& return_image = return_cursor[type].return_image;
	char*& return_mask = return_cursor[type].return_mask;
	int retn_patterns = return_cursor[type].retn_patterns;
	int retn_width = return_cursor[type].retn_width;
	int retn_height = return_cursor[type].retn_height;
	if (return_count >= retn_patterns) return_count = 0;
	/* image  */
	int bypp = (return_image.gdkobj()->bpl) / (return_image.gdkobj()->width);
	int mask_bpl = retn_patterns*retn_width; char* mask = return_mask + return_count*retn_width;
	char* src1 = (char*)(return_image.gdkobj()->mem) + return_count*retn_width*bypp;
	char* src2 = (char*)(return_back.gdkobj()->mem);
	int src1_bpl = return_image.gdkobj()->bpl; int src2_bpl = return_back.gdkobj()->bpl;
	char* dest = (char*)(return_tmpimage.gdkobj()->mem); int dest_bpl = return_tmpimage.gdkobj()->bpl;
#ifdef SUPPORT_MSB_FIRST
	int reverse = 0;
	if (return_image.gdkobj()->byte_order == MSBFirst)
	    reverse = !0;
#endif // SUPPORT_MSB_FIRST
	for (i=0; i<retn_height; i++) {
		char* s1 = src1; char* s2 = src2; char* d = dest; char* m = mask;
		for (j=0; j<retn_width; j++) {
			char* s = s2;
			if (*m++) s=s1;
#ifdef SUPPORT_MSB_FIRST
			if (s != s2 && bypp == 4 && reverse) {
			    *d++ = 0;
			    *d++ = s[2];
			    *d++ = s[1];
			    *d++ = s[0];
			    s1 += bypp; s2 += bypp;
			} else {
			    for (k=0; k<bypp; k++) d[k]=s[k];
			    // memcpy(d, s, bypp);
			    s1 += bypp; s2 += bypp; d += bypp;
			}
#else // SUPPORT_MSB_FIRST
			for (k=0; k<bypp; k++) d[k]=s[k];
			// memcpy(d, s, bypp);
			s1 += bypp; s2 += bypp; d += bypp; 
#endif // SUPPORT_MSB_FIRST
		}
		src1 += src1_bpl; src2 += src2_bpl; dest += dest_bpl; mask += mask_bpl;
	}
#ifdef SUPPORT_MSB_FIRST1
	Gdk_Visual vis = return_screen2->get_visual();
	Gdk_Image return_image_fit(GDK_IMAGE_NORMAL, vis, retn_width, retn_height);
#endif // SUPPORT_MSB_FIRST1
	/* ̤ */
	/* return_screen2 ϡޥ̵ */
	if (return_x + retn_width > global_system.DefaultScreenWidth()) retn_width = global_system.DefaultScreenWidth() - return_x;
	if (return_y + retn_height> global_system.DefaultScreenHeight()) retn_height= global_system.DefaultScreenHeight() - return_y;
#ifdef WORDS_BIGENDIAN1
	if (return_tmpimage.gdkobj()->byte_order == MSBFirst) {
		FitImage(&return_image_fit, &return_tmpimage);
		return_screen2->draw_image(gc, return_image_fit, 0, 0, return_x, return_y, retn_width, retn_height);
	} else {
		return_screen2->draw_image(gc, return_tmpimage, 0, 0, return_x, return_y, retn_width, retn_height);
	}
#else
	return_screen2->draw_image(gc, return_tmpimage, 0, 0, return_x, return_y, retn_width, retn_height);
#endif
	global_system.FlushScreen();
	/* return_screen1 ϥޥ뤢 */
	if (cursor) cursor->DrawImageRelative(&return_tmpimage, -return_x, -return_y);
#ifdef WORDS_BIGENDIAN1
	if (return_tmpimage.gdkobj()->byte_order == MSBFirst) {
		FitImage(&return_image_fit, &return_tmpimage);
		return_screen1->draw_image(gc, return_image_fit, 0, 0, return_x, return_y, retn_width, retn_height);
	} else {
		return_screen1->draw_image(gc, return_tmpimage, 0, 0, return_x, return_y, retn_width, retn_height);
	}
#else
	return_screen1->draw_image(gc, return_tmpimage, 0, 0, return_x, return_y, retn_width, retn_height);
#endif
	global_system.FlushScreen();
	cursor->RestoreImage();
	return_count++;
}

void SYSTEM_PDT_IMAGE::DrawReturnPixmap(Gdk_Window* win, Gdk_Drawable* d1, Gdk_Drawable* d2, int x, int y, P_CURSOR* cursor)
{
	if (return_back.gdkobj() != 0) DeleteReturnPixmap(cursor);
	Gdk_Visual vis = win->get_visual();
	int retn_width = return_cursor[CursorType()].retn_width;
	int retn_height = return_cursor[CursorType()].retn_height;
	/* ɸʾ硢 */
	if (x < 0) x=0;
	if (x >= global_system.DefaultScreenWidth()) x = global_system.DefaultScreenWidth()-1;
	if (y < 0) y=0;
	if (y >= global_system.DefaultScreenHeight()) y = global_system.DefaultScreenHeight()-1;
	if (x+retn_width >= global_system.DefaultScreenWidth()) retn_width = global_system.DefaultScreenWidth()-x;
	if (y+retn_height >= global_system.DefaultScreenHeight()) retn_height = global_system.DefaultScreenHeight()-y;
	/* return_back 򥭥ץ */
	return_back.get(*d2, x, y,  retn_width, retn_height);
	/* x, y ʤɤΥå */
	return_x = x; return_y = y;
	return_screen1 = d1; return_screen2 = d2;
	/* cursor  */
	DrawReturnPixmap(cursor);
}

// ȤɤĤ֤
#if 0 /* obsolete code */
static void DrawWakuIn15bpp(char* dat, int bpl, int width, int height, int c1, int c2, int c3) {
	int i,j;
	// ޤơ֥Ĥ
	unsigned short c1_table[32]; for (i=0; i<32; i++) { c1_table[i] = (i*c1/255) << 10; }
	unsigned short c2_table[32]; for (i=0; i<32; i++) { c2_table[i] = (i*c2/255) << 5; }
	unsigned short c3_table[32]; for (i=0; i<32; i++) { c3_table[i] = i*c3/255; }
	// ʬŤ
	for (i=0; i<height; i++) {
		unsigned short* line = (unsigned short*)dat;
		for (j=0; j<width; j++) {
			unsigned int c = *line;
			register int cc1 = c>>10;
			register int cc2 = c>>5;
			register int cc3 = c & 0x1f;
			cc1 &= 0x1f; cc2 &= 0x1f;
			*line++ = c1_table[cc1] | c2_table[cc2] | c3_table[cc3];
		}
		dat += bpl;
	}
	
}
#endif

static void DrawWakuIn16bpp(char* dat, int bpl, int width, int height, int c1, int c2, int c3) {
	int i,j;
	// ޤơ֥Ĥ
	unsigned short c1_table[32]; for (i=0; i<32; i++) { c1_table[i] = (i*c1/255) << 11; }
	unsigned short c2_table[64]; for (i=0; i<64; i++) { c2_table[i] = (i*c2/255) << 5; }
	unsigned short c3_table[32]; for (i=0; i<32; i++) { c3_table[i] = i*c3/255; }
	// ʬŤ
	for (i=0; i<height; i++) {
		unsigned short* line = (unsigned short*)dat;
		for (j=0; j<width; j++) {
			unsigned int c = *line;
			register int cc1 = c>>11;
			register int cc2 = c>>5;
			register int cc3 = c & 0x1f;
			cc1 &= 0x1f; cc2 &= 0x3f;
			*line++ = c1_table[cc1] | c2_table[cc2] | c3_table[cc3];
		}
		dat += bpl;
	}
	
}

#if 0 /* obsolete code */
static void DrawWakuIn24bpp(char* dat, int bpl, int width, int height, int c1, int c2, int c3) {
	int i,j;
	// ޤơ֥Ĥ
	unsigned char c1_table[256]; for (i=0; i<256; i++) { c1_table[i] = i*c1/255; }
	unsigned char c2_table[256]; for (i=0; i<256; i++) { c2_table[i] = i*c2/255; }
	unsigned char c3_table[256]; for (i=0; i<256; i++) { c3_table[i] = i*c3/255; }
	// ʬŤ
	for (i=0; i<height; i++) {
		unsigned char* line = (unsigned char*)dat;
		for (j=0; j<width; j++) {
			*line = c3_table[*line]; line++;
			*line = c2_table[*line]; line++;
			*line = c1_table[*line]; line++;
		}
		dat += bpl;
	}
	
}
#endif /* obsolete */

static void DrawWakuIn32bpp(char* dat, int bpl, int width, int height, int c1, int c2, int c3) {
	int i,j;
	// ޤơ֥Ĥ
	unsigned char c1_table[256]; for (i=0; i<256; i++) { c1_table[i] = i*c1/255; }
	unsigned char c2_table[256]; for (i=0; i<256; i++) { c2_table[i] = i*c2/255; }
	unsigned char c3_table[256]; for (i=0; i<256; i++) { c3_table[i] = i*c3/255; }
	// ʬŤ
	for (i=0; i<height; i++) {
		unsigned char* line = (unsigned char*)dat;
		for (j=0; j<width; j++) {
			*line = c3_table[*line]; line++;
			*line = c2_table[*line]; line++;
			*line = c1_table[*line]; line++;
			*line++ = 0;
		}
		dat += bpl;
	}
	
}


#if 0 /* obsolete code */
static void DeleteWakuIn15bpp(char* dat, int bpl, int width, int height, int c1, int c2, int c3) {
	// Ĥ
	c1 <<= 7; c1 &= 0x7c00;
	c2 <<= 3; c2 &= 0x03e0;
	c3 &= 0x1f;
	unsigned short c = c1 | c2 | c3;
	// ɤ
	int i,j;
	for (i=0; i<height; i++) {
		unsigned short* line = (unsigned short*)dat;
		for (j=0; j<width; j++) {
			*line++ = c;
		}
		dat += bpl;
	}
	return;
}
#endif /* obsolete */

static void DeleteWakuIn16bpp(char* dat, int bpl, int width, int height, int c1, int c2, int c3) {
	// Ĥ
	c1 <<= 8; c1 &= 0xf800;
	c2 <<= 3; c2 &= 0x07e0;
	c3 &= 0x1f;
	unsigned short c = c1 | c2 | c3;
	// ɤ
	int i,j;
	for (i=0; i<height; i++) {
		unsigned short* line = (unsigned short*)dat;
		for (j=0; j<width; j++) {
			*line++ = c;
		}
		dat += bpl;
	}
	return;
}

#if 0 /* obsolete code */
static void DeleteWakuIn24bpp(char* dat, int bpl, int width, int height, int c1, int c2, int c3) {
	// Ĥ
	unsigned int c = c1; unsigned char* cc = (unsigned char*)(&c);
	cc[0] = c1; cc[1] = c2; cc[2] = c3; cc[3] = 0;
	// ɤ
	int i,j;
	for (i=0; i<height; i++) {
		char* line = dat;
		for (j=0; j<width; j++) {
			*line++ = c3; *line++ = c2; *line++ = c1;
		}
		dat += bpl;
	}
	return;
}
#endif /* obsolete */

static void DeleteWakuIn32bpp(char* dat, int bpl, int width, int height, int c1, int c2, int c3) {
	// Ĥ
	unsigned int c = c1; unsigned char* cc = (unsigned char*)(&c);
	cc[0] = c3; cc[1] = c2; cc[2] = c1; cc[3] = 0;
	// ɤ
	int i,j;
	for (i=0; i<height; i++) {
		unsigned int* line = (unsigned int*)dat;
		for (j=0; j<width; j++) {
			*line++ = c;
		}
		dat += bpl;
	}
	return;
}

void SYSTEM_IMAGE::SetBrightness(Gdk_Image* im,int bright, AyuSys& local_system) {
	if (bright < 0) bright = 0;
	if (bright > 100) bright = 100;
	bright = bright * 255 / 100;
	// ̤Ť
	if (bright != 255) {
		int bpl = im->gdkobj()->bpl;
		char* dat = (char*)im->gdkobj()->mem;
		int width = global_system.DefaultScreenWidth()-8; int height = global_system.DefaultScreenHeight()-8;
		int c1=bright, c2=bright, c3=bright;
#if 0
		if (local_system.DefaultBpp() == 15) {
			DrawWakuIn15bpp(dat, bpl, width+8, height+8, c1, c2, c3);
		} else if (local_system.DefaultBpp() == 16) {
			DrawWakuIn16bpp(dat, bpl, width+8, height+8, c1, c2, c3);
		} else if (local_system.DefaultBpp() == 24) {
			DrawWakuIn24bpp(dat, bpl, width+8, height+8, c1, c2, c3);
		} else if (local_system.DefaultBpp() == 32) {
			DrawWakuIn32bpp(dat, bpl, width+8, height+8, c1, c2, c3);
		}
#endif
		if (local_system.DefaultBypp() == 2) {
			DrawWakuIn16bpp(dat, bpl, width+8, height+8, c1, c2, c3);
		} else {
			DrawWakuIn32bpp(dat, bpl, width+8, height+8, c1, c2, c3);
		}
	}
}

void SYSTEM_IMAGE::DrawWaku(Gdk_Image* im, int x, int y, int width, int height, AyuSys& local_system)
{
	/* Ʃե饰 */
	int c1, c2, c3, trans;
	local_system.config->GetParam("#WINDOW_ATTR", 3, &c1,&c2,&c3);
//	local_system.config->GetParam("#WINDOW_ATTR_TYPE", 1, &trans);
trans=0;
	if (c1<0) c1=0; if (c1>255) c1=255;
	if (c2<0) c2=0; if (c2>255) c2=255;
	if (c3<0) c3=0; if (c3>255) c3=255;
	/* ȤΥޡ */
	int mx1,my1,mx2,my2;
	if (local_system.config->GetParaInt("#NVL_SYSTEM") == 0) {
		local_system.config->GetParam("#WINDOW_ATTR_AREA", 4, &mx1,&my1,&mx2,&my2);
	} else {
		/* ̥ƥȥ⡼ */
		mx1 = 0; my1 = 0; mx2 = 0; my2 = 0;
		x = 0; y = 0; width = global_system.DefaultScreenWidth(); height = global_system.DefaultScreenHeight();
	}
	if (mx1<0) mx1=0;
	if (my1<0) my1=0;
	if (mx2<0) mx2=0;
	if (my2<0) my2=0;
	if (mx1+mx2 >= width || my1+my2 >= height) return; /* ̵ */
	// Ȥʬ(x,y),(width,height)
	x += mx1; y += my1; width -= mx1+mx2; height -= my1+my2;
	if (x+width > global_system.DefaultScreenWidth()) width=global_system.DefaultScreenWidth()-x;
	if (y+height> global_system.DefaultScreenHeight()) height=global_system.DefaultScreenHeight()-y;
	// Ȥ̤Ĥ֤
	// bpp ȡɤĤ֤ƩǶ
	int bpl = im->gdkobj()->bpl; int bypp = bpl / im->gdkobj()->width;
	char* dat = (char*)im->gdkobj()->mem;
	dat += bpl*y + bypp*x;
#if 0
	if (trans == 0) {
		if (local_system.DefaultBpp() == 15) {
			if (! local_system.DefaultRgbrev())
				DrawWakuIn15bpp(dat, bpl, width, height, c1, c2, c3);
			else
				DrawWakuIn15bpp(dat, bpl, width, height, c3, c2, c1);
		} else if (local_system.DefaultBpp() == 16) {
			if (! local_system.DefaultRgbrev())
				DrawWakuIn16bpp(dat, bpl, width, height, c1, c2, c3);
			else
				DrawWakuIn16bpp(dat, bpl, width, height, c3, c2, c1);
		} else if (local_system.DefaultBpp() == 24) {
			if (! local_system.DefaultRgbrev())
				DrawWakuIn24bpp(dat, bpl, width, height, c1, c2, c3);
			else
				DrawWakuIn24bpp(dat, bpl, width, height, c3, c2, c1);
		} else if (local_system.DefaultBpp() == 32) {
			if (! local_system.DefaultRgbrev())
				DrawWakuIn32bpp(dat, bpl, width, height, c1, c2, c3);
			else
				DrawWakuIn32bpp(dat, bpl, width, height, c3, c2, c1);
		}
	} else {
		if (local_system.DefaultBpp() == 15) {
			if (! local_system.DefaultRgbrev())
				DeleteWakuIn15bpp(dat, bpl, width, height, c1, c2, c3);
			else
				DeleteWakuIn15bpp(dat, bpl, width, height, c3, c2, c1);
		} else if (local_system.DefaultBpp() == 16) {
			if (! local_system.DefaultRgbrev())
				DeleteWakuIn16bpp(dat, bpl, width, height, c1, c2, c3);
			else
				DeleteWakuIn16bpp(dat, bpl, width, height, c3, c2, c1);
		} else if (local_system.DefaultBpp() == 24) {
			if (! local_system.DefaultRgbrev())
				DeleteWakuIn24bpp(dat, bpl, width, height, c1, c2, c3);
			else
				DeleteWakuIn24bpp(dat, bpl, width, height, c3, c2, c1);
		} else if (local_system.DefaultBpp() == 32) {
			if (! local_system.DefaultRgbrev())
				DeleteWakuIn32bpp(dat, bpl, width, height, c1, c2, c3);
			else
				DeleteWakuIn32bpp(dat, bpl, width, height, c3, c2, c1);
		}
	}
#endif
	if (trans == 0) {
		if (local_system.DefaultBypp() == 2) {
			DrawWakuIn16bpp(dat, bpl, width, height, c1, c2, c3);
		} else {
			DrawWakuIn32bpp(dat, bpl, width, height, c1, c2, c3);
		}
	} else {
		if (local_system.DefaultBypp() == 2) {
			DeleteWakuIn16bpp(dat, bpl, width, height, c1, c2, c3);
		} else {
			DeleteWakuIn32bpp(dat, bpl, width, height, c1, c2, c3);
		}
	}
}

void SYSTEM_PDT_IMAGE::DrawWaku(Gdk_Image* im, int x, int y, int width, int height, AyuSys& local_system)
{
	/* Ȥ¦ɤ */
	SYSTEM_IMAGE::DrawWaku(im,x,y,width,height,local_system);
	/* Ȥ */
	if (local_system.config->GetParaInt("#NVL_SYSTEM") == 0) {
		int type = local_system.config->GetParaInt("#WINDOW_WAKU_TYPE");
		if (type < 0 || type > 3) type = 0;
		waku[type]->Draw(*im,x,y,width,height);
	}
}

// ޥΥå
P_CURSOR* SYSTEM_PDT_IMAGE::CreateCursor(Gdk_Window* window, Gdk_Pixmap* background) {
	// ޤޥä
	Gdk_Color black("black"); Gdk_Color white("white");
	char buf = 0;
	Gdk_Bitmap bitmap(*window, &buf, 1, 1);
	GdkCursor* cursor = gdk_cursor_new_from_pixmap(
		bitmap.gdkobj(), bitmap.gdkobj(), white.gdkobj(), black.gdkobj(), 0, 0);
	window->set_cursor(cursor);
	return new PIX_CURSOR(*window, mouse_pixmap, mouse_bitmap, mouse_image_mask, *background);
}

