/*  window_all.cc
 *
 ************************************************************
 *
 *     ̥⡼ɤѹǽ toplevel window Υ饹
 *     Gtk::Window ˤΥ饹Ѿ뤳Ȥ
 *     ɥ̥⡼ɤѹǽˤʤ롣
 *
 ************************************************************
 *     Υץϡ䤵(go@denpa.org) 
 *     xlvns 1.6a (http://leafbsd.denpa.org) ˴ޤޤ
 *     ̥⡼ѴѤΥ롼򻲹ͤ˺ޤ
 *      BSD Licence ΥäƤäƽ񤤤Ƥ
 *     Ǥ礦(
 ************************************************************
 */
/*
 *
 *  Copyright (C) 2000-   Kazunori Ueno(JAGARL) <jagarl@creator.club.ne.jp>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
*/


#include <gdk/gdkx.h>
#include "window_all.h"
#include <stdio.h>
#include <unistd.h>

#define WINDOW_GEOM_X 0 /* ̥⡼ɤλβ̤κɸ̾ü¾ */
#define WINDOW_GEOM_Y 0 /* ɥ硢ưФ褤 */

typedef Window XWindow; /* Gtk::Window  conflict Τ X  Window  XWindow Ȥ̾ˤ */

using namespace Gtk;

Window_AllScreen::Window_AllScreen(GtkWindowType type) :
	Window(type) {
	flags = 0;
	dpy_restore = 0; screen_restore = 0;
	dga_buffer = 0; dga_width = 0;
	screen_bpl = -1;
	other_window_count = 0;

	configure_event.connect(SigC::slot(this, &Window_AllScreen::private_configure_event));
	enter_notify_event.connect(SigC::slot(this, &Window_AllScreen::private_enter_event));
	set_events( get_events() | GDK_ENTER_NOTIFY_MASK);
}

Window_AllScreen::~Window_AllScreen() {
	SetFinalize();
	RestoreMode(); // ɬפʤ顢̥⡼ɤ᤹
}

void Window_AllScreen::MakeOtherWindow(void) {
	if (other_window_count < 0) other_window_count = 0;
	if (other_window_count == 0 && IsAllScreen()) {
		gdk_pointer_ungrab(CurrentTime);
	}
	other_window_count++;
}

void Window_AllScreen::CloseOtherWindow(void) {
	if (other_window_count <= 0) return;
	other_window_count--;
	if (other_window_count == 0 && IsAllScreen()) {
		gdk_pointer_grab(get_window().gdkobj(), True, GdkEventMask(0),
			get_window().gdkobj(), 0, CurrentTime); // CurrentTime is a constant in <X11/Xlib.h>
		/* focus Ƥ */
		activate_focus();
	}
}

gint Window_AllScreen::private_configure_event(GdkEventConfigure* p1) {
	if (! IsAllScreen()) {
		int d;
		get_window().get_geometry(normal_x_pos, normal_y_pos,
			normal_width, normal_height, d);
		get_window().get_origin(normal_x_pos, normal_y_pos);
	}
	if (! IsInitialized()) {
		/*  : ֤ */
		/*  : DGA  frame buffer  */
		/*  : vidmode */
		SetInitialize();
		InitDGA();
		GetAllScrnMode();
	}
	return FALSE;
}

/* popup menu ʤɤ window  grab 줿硢
** ƤӥեäƤȤȤ grab 
** ޤviewport ѹƤ
*/
gint Window_AllScreen::private_enter_event(GdkEventCrossing* event) {
	if (! IsAllScreen()) return FALSE;
	if (other_window_count) return FALSE;

	gdk_pointer_grab(get_window().gdkobj(), True, GdkEventMask(0),
		get_window().gdkobj(), 0, CurrentTime); // CurrentTime is a constant in <X11/Xlib.h>
	/* focus Ƥ */
	activate_focus();

	/* ϥե */
	Display* xdisplay = GDK_WINDOW_XDISPLAY(get_window().gdkobj());
	XWindow xwindow = GDK_WINDOW_XWINDOW(get_window().gdkobj());
	XSetInputFocus(xdisplay, xwindow, RevertToPointerRoot, CurrentTime);
#ifdef HAVE_LIBXXF86VM

	int screen_num = DefaultScreen(xdisplay);
	int x=0,y=0;

	XF86VidModeGetViewPort(xdisplay, screen_num, &x, &y);
	if (x != 0 || y != 0)
		// viewport ѹ : (0,0)  viewport 򥻥åȤ
		XF86VidModeSetViewPort(xdisplay, screen_num, WINDOW_GEOM_X, WINDOW_GEOM_Y);
#endif
	return FALSE;
}

/**
 * ̤ǽξ֤᤹
 */
void Window_AllScreen::RestoreMode(void)
{
    if (IsAllScreen()) {
	if (! IsFinalized()) {
		get_window().move_resize(normal_x_pos, normal_y_pos, normal_width, normal_height);
		gdk_pointer_ungrab(CurrentTime);
	}
#ifdef HAVE_LIBXXF86VM
        XF86VidModeSwitchToMode(dpy_restore, screen_restore, modeinfos[0]);
        XSync(dpy_restore, False);
#endif
	UnsetAllScreen();
    }
}

/*
 * Ūβ٤뤫ɤå
 */
XF86VidModeModeInfo *
Window_AllScreen::CheckModeLinesRes(int w, int h)
{
    int i;
#ifdef HAVE_LIBXXF86VM
    for (i=0;i<vid_count;i++) { 
        if (modeinfos[i]->hdisplay == w && modeinfos[i]->vdisplay == h)  
            return modeinfos[i];
    }
#endif
    return NULL;
}

/* ꡼⡼ɤͭ/̵å */
void Window_AllScreen::GetAllScrnMode(void) {
#ifdef HAVE_LIBXXF86VM
        int major, minor;
        int eventBase, errorBase;
	XF86VidModeModeInfo  *sel;
	Display* xdisplay = GDK_WINDOW_XDISPLAY(get_window().gdkobj());

        if (!XF86VidModeQueryVersion(xdisplay, &major, &minor)) {
            fprintf(stderr, "Can't query video extension version\n");
        } else  if (!XF86VidModeQueryExtension(xdisplay, &eventBase, &errorBase)) {
            fprintf(stderr, "Can't query video extension information\n");
        } else if (major < XF86VM_MINMAJOR ||
                   (major == XF86VM_MINMAJOR && minor < XF86VM_MINMINOR)) {
            fprintf(stderr, "Old  XFree86-VidModeExtension version(%d.%d)\n", major, minor);
            fprintf(stderr, "Required version %d.%d\n", XF86VM_MINMAJOR, XF86VM_MINMINOR);
        } else {
            if (!XF86VidModeGetAllModeLines(xdisplay, 
					    DefaultScreen(xdisplay),
                                            &vid_count, &modeinfos)) {
                fprintf(stderr, "Can't get modeinfos\n");
#if 0
	/* 640,480 ޤ 800,600 ⡼ɤ¸ߥåʤȻפ */
            } else if ((sel = CheckModeLinesRes(640, 480)) == NULL &&
                       (sel = CheckModeLinesRes(800, 600)) == NULL) {
                fprintf(stderr, "Not found good mode...");
#endif
            } else {
		SetUsableAllScreen();
                dpy_restore = xdisplay;
                screen_restore = DefaultScreen(xdisplay);
            }
        }
#endif
}

/**
 * ̤̥⡼ɤˤ
 */
int Window_AllScreen::ToAllScreen(int width, int height) {
#ifdef HAVE_LIBXXF86VM
	if (IsAllScreen()) {
		if (all_width == width && all_height == height)
			return 1; // ʤ
		// ä󡢲̤򸵤Υ⡼ɤľ³
		RestoreMode();
	}

	XF86VidModeModeInfo* sel;
	Display* xdisplay = GDK_WINDOW_XDISPLAY(get_window().gdkobj());
	sel = CheckModeLinesRes(width, height);
	if (sel == NULL) { // ̥⡼ɤĤʤ
		fprintf(stderr, "Cannot found modeline : width = %d, height = %d\n",width,height);
		return 0;
	}
	// ̥⡼ɤѹ
	int screen_num = DefaultScreen(xdisplay);
	SetAllScreen();
	hide();
	if (! XF86VidModeSwitchToMode(xdisplay, screen_num, sel)) {
		fprintf(stderr, "Cannot change modeline : width = %d, height = %d\n", width, height);
		UnsetAllScreen();
		show();
		return 0;
	}
	show();
	all_width = width; all_height = height;
	// viewport ѹ : (0,0)  viewport 򥻥åȤ
	XF86VidModeSetViewPort(xdisplay, screen_num, WINDOW_GEOM_X, WINDOW_GEOM_Y);
	// warp pointer ɬס
        /* XWarpPointer(XtDisplay(top),
        **             None, 
        **             RootWindowOfScreen(XtScreen(top)),
        **             0, 0, 0, 0, 0, 0);
	*/
	XSync(xdisplay, False);
	/* ̤κü˥ɥäƤ򥻥åȤ */
	get_window().move_resize(WINDOW_GEOM_X,WINDOW_GEOM_Y,width,height);
	/* ޥ grab gdk-- ˤʤΤ gdk Ȥ */
	/* ޥ̤γ˽Фʤ褦ˤ */
	if (other_window_count) return 1;
	gdk_pointer_grab(get_window().gdkobj(), True, GdkEventMask(0),
		get_window().gdkobj(), 0, CurrentTime); // CurrentTime is a constant in <X11/Xlib.h>
	/* focus Ƥ */
	activate_focus();
	return 1;
#else
	return 0;
#endif
}

/* DGA ν */
void Window_AllScreen::InitDGA(void) {
#ifdef HAVE_LIBXXF86DGA
	/* suid root ƤʤȤΥå */
	uid_t uid = getuid(); uid_t euid = geteuid();
	if (uid != euid && euid == 0) {
		fprintf(stderr, "Warning : This program is suid root ; disable DGA extension !\n");
		return;
	}
	/* /dev/mem 򳫤Τå */
	FILE* mem_stream = fopen("/dev/mem", "r+b");
	if (mem_stream == 0) {
		/* direct memory access θ¤ʤ */
		return;
	}
	Display* xdisplay = GDK_WINDOW_XDISPLAY(get_window().gdkobj());
	int major, minor;
	int eventBase, errorBase;

	/* DGA Ȥ뤳ȤΥå */
	if (!XF86DGAQueryVersion(xdisplay, &major, &minor)) {
		fprintf(stderr, "Can't query DGA version\n");
		return;
	}
	if (!XF86VidModeQueryExtension(xdisplay, &eventBase, &errorBase)) {
		fprintf(stderr, "Can't query DGA information\n");
		return;
	}
	if (major < XF86DGA_MINMAJOR ||
		(major == XF86DGA_MINMAJOR && minor < XF86DGA_MINMINOR)) {
		fprintf(stderr, "Old  XFree86-DGA version(%d.%d)\n", major, minor);
		fprintf(stderr, "Required version %d.%d\n", XF86DGA_MINMAJOR, XF86DGA_MINMINOR);
		return;
	}
	int flag;
	if (! XF86DGAQueryDirectVideo(xdisplay, DefaultScreen(xdisplay), &flag)) {
		fprintf(stderr,"Can't query DGA video flag\n");
		return;
	}
	if ( (flag & XF86DGADirectPresent) == 0) {
		fprintf(stderr,"Direct video is not supported\n");
		return;
	}
	/* DGA buffer  */
	int bsize, ram_size;
	XF86DGAGetVideo(xdisplay, DefaultScreen(xdisplay), &dga_buffer, &dga_width, &bsize, &ram_size);
	ram_size *= 1024; // ram size  kb ñ̤֤äƤʤȻפ
	/* bank size  ram size 꾮硢ڡΥȥ뤬ɬס
	** ݤʤΤ DGA ̵ˤ
	*/
	if (bsize < ram_size) {
		fprintf(stderr,"bank size = %x, ram size = %x ; page control is required.\n",bsize,ram_size);
		fprintf(stderr,"DGA access with page control is not supported yet; disable DGA. \n");
		dga_width = 0; dga_buffer = 0;
		return;
	}
	/* ̤bpl */
	Gdk_Visual vis = get_window().get_visual();
	int depth = vis.gdkobj()->depth;
	if (depth == 15 || depth == 16) screen_bpl = dga_width*2;
	else if (depth == 24 || depth == 32) screen_bpl = dga_width*4;
	else screen_bpl = dga_width;
	/* λ */
#endif
	return;
}

int Window_AllScreen::DGADraw(Gdk_Image* image, int src_x, int src_y, int dest_x, int dest_y, int width, int height) {
	if (dga_buffer == 0) return 1;
	if (! IsAllScreen()) return 1;
	/* 󡢤ޤʤ */
//	return 1;
	EnableDGA();
	/* ɸå */
	if (src_x < 0) {
		width += src_x; dest_x -= src_x; src_x = 0;
	}
	if (src_y < 0) {
		height += src_y; dest_y -= src_y; src_y = 0;
	}
	if (dest_x < 0) {
		width += dest_x; src_x -= dest_x; dest_x = 0;
	}
	if (dest_y < 0) {
		height += dest_y; src_y -= dest_y; dest_y = 0;
	}
	if (src_x+width > 640) width = 640-src_x;
	if (dest_x+width > 640) width = 640-dest_x;
	if (src_y+height>480) height = 480-src_y;
	if (dest_y+height>480) height = 480-dest_y;
	if (height < 0) return 1;
	if (width < 0) return 1;
	if (height > 480) height = 480;
	if (width > 640) width = 640;
	if (width > dga_width) width = dga_width;
	int bpp = image->gdkobj()->bpl / image->gdkobj()->width;
	int sbpl = image->gdkobj()->bpl;
	int dbpl = dga_width * bpp;
	int dlen = width * bpp;
	char* dest = dga_buffer + (dest_x+WINDOW_GEOM_X)*bpp + (dest_y+WINDOW_GEOM_Y)*dbpl;
	char* src = ((char*)(image->gdkobj()->mem)) + (src_x)*bpp + (src_y)*sbpl;
	int i; for (i=0; i<height; i++) {
		if ( (flags & 0x10) == 0)  {/* DiableDGA  */
			return 1;
		}
		memcpy(dest, src, dlen);
		dest += dbpl; src += sbpl;
	}
/* ݤ餤 */
/* 	DisableDGA(); */
	return 0;
}

#include<sys/types.h>
#include<sys/mman.h>

/* 衢DGA Ȥݤˤ XF86DGADirectVideo() ŬȤä
** ͭ٤Disable Ȥ˲̤֥
** ƤޤѤѤʤʤΤǡprotect ǶŪ
** video memory 򥢥ǽˤƤޤ
** ̤ϤʤɡΤۤȤˡ(^^;
*/


void Window_AllScreen::EnableDGA(void) {
	if (dga_buffer == 0) return;
	if (flags & 0x10) return;
/*
	Display* xdisplay = GDK_WINDOW_XDISPLAY(get_window().gdkobj());
	XF86DGADirectVideo(xdisplay, DefaultScreen(xdisplay), XF86DGADirectGraphics);
*/
	mprotect(dga_buffer, (WINDOW_GEOM_Y+480)*screen_bpl, PROT_READ | PROT_WRITE);
	flags |= 0x10;
}
void Window_AllScreen::DisableDGA(void) {
	if (dga_buffer == 0) return;
	if ( (flags & 0x10) == 0) return;
/*
	Display* xdisplay = GDK_WINDOW_XDISPLAY(get_window().gdkobj());
	XF86DGADirectVideo(xdisplay, DefaultScreen(xdisplay), 0);
	mprotect(dga_buffer, (WINDOW_GEOM_Y+480)*screen_bpl, PROT_READ);
*/
	flags &= ~0x10;
}
