
/*
 * LIST.C
 *
 */

#include "defs.h"

Prototype void InitList(List *list);
Prototype void *MakeNode(const char *name, int size, int value);
Prototype void *CopyNode(Node *node);

Prototype void AddHead(List *list, Node *node);
Prototype void AddTail(List *list, Node *node);
Prototype void InsertAfter(List *list, Node *lnode, Node *node);
Prototype void InsertBefore(List *list, Node *lnode, Node *node);
Prototype void DelNode(List *list, Node *node);

Prototype void *RemHead(List *list);
Prototype void *RemTail(List *list);

Prototype void *GetHead(List *list);
Prototype void *GetTail(List *list);
Prototype void *GetNext(Node *node);
Prototype void *GetPrev(Node *node);

void 
InitList(List *list)
{
    memset(list, 0, sizeof(List));
    list->li_Node.no_Next = &list->li_Node;
    list->li_Node.no_Prev = &list->li_Node;
    list->li_Refs = 1;
}

void *
MakeNode(const char *name, int size, int value)
{
    Node *node = malloc(size + strlen(name) + 1);

    memset(node, 0, size);
    node->no_Name = (char *)node + size;
    node->no_Value = value;
    node->no_Size = size;
    if ((node->no_INode = CurINode) != NULL)
	node->no_ILine = CurINode->in_Node.no_ILine;
    strcpy(node->no_Name, name);

    return(node);
}

void *
CopyNode(Node *node)
{
    Node *n2 = malloc(node->no_Size);

    /*
     * copy the node contents.  Note that
     * the node's name still points to the
     * original node's string buffer, so we
     * do not have to allocate a new one.
     */
    memmove(n2, node, node->no_Size);

    return(n2);
}

void 
AddHead(List *list, Node *node)
{
    Node *next = list->li_Node.no_Next;

    node->no_Next = next;
    node->no_Prev = &list->li_Node;
    list->li_Node.no_Next = node;
    next->no_Prev = node;
    ++list->li_Count;
}

void
AddTail(List *list, Node *node)
{
    Node *prev = list->li_Node.no_Prev;

    node->no_Next = &list->li_Node;
    node->no_Prev = prev;
    list->li_Node.no_Prev = node;
    prev->no_Next = node;
    ++list->li_Count;
}

void 
InsertAfter(List *list, Node *lnode, Node *node)
{
    Node *next = lnode->no_Next;

    node->no_Next = next;
    node->no_Prev = lnode;
    lnode->no_Next = node;
    next->no_Prev = node;
    ++list->li_Count;
}

void 
InsertBefore(List *list, Node *lnode, Node *node)
{
    Node *prev = lnode->no_Prev;

    node->no_Next = lnode;
    node->no_Prev = prev;
    lnode->no_Prev = node;
    prev->no_Next = node;
    ++list->li_Count;
}

void 
DelNode(List *list, Node *node)
{
    node->no_Next->no_Prev = node->no_Prev;
    node->no_Prev->no_Next = node->no_Next;
    --list->li_Count;
}
void *
RemHead(List *list)
{
    Node *node;

    if ((node = GetHead(list)) != NULL)
	DelNode(list, node);
    return(node);
}

void *
RemTail(List *list)
{
    Node *node;

    if ((node = GetTail(list)) != NULL)
	DelNode(list, node);
    return(node);
}

void *
GetHead(List *list)
{
    Node *node = list->li_Node.no_Next;

    if (node == &list->li_Node)
	node = NULL;
    return(node);
}

void *
GetTail(List *list)
{
    Node *node = list->li_Node.no_Prev;

    if (node == &list->li_Node)
	node = NULL;
    return(node);
}

void *
GetNext(Node *node)
{
    if (node) {
	node = node->no_Next;
	if (node->no_Name == NULL)
	    node = NULL;
    }
    return(node);
}

void *
GetPrev(Node *node)
{
    if (node) {
	node = node->no_Prev;
	if (node->no_Name == NULL)
	    node = NULL;
    }
    return(node);
}

